// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// Life cycle state encoding definition.
//
// DO NOT EDIT THIS FILE DIRECTLY.
// It has been generated with
// $ ./util/design/gen-lc-state-enc.py --seed 10167336684108184581
//
package lc_ctrl_state_pkg;

  import prim_util_pkg::vbits;

  ///////////////////////////////
  // General size declarations //
  ///////////////////////////////

  parameter int LcValueWidth = 16;

  parameter int NumLcStateValues = 12;
  parameter int LcStateWidth = NumLcStateValues * LcValueWidth;
  parameter int NumLcStates = 13;
  parameter int DecLcStateWidth = vbits(NumLcStates);

  parameter int NumLcCountValues = 16;
  parameter int LcCountWidth = NumLcCountValues * LcValueWidth;
  parameter int NumLcCountStates = 17;
  parameter int DecLcCountWidth = vbits(NumLcCountStates);

  parameter int NumLcIdStateValues = 1;
  parameter int LcIdStateWidth = NumLcIdStateValues * LcValueWidth;
  parameter int NumLcIdStates = 2;
  parameter int DecLcIdStateWidth = vbits(NumLcIdStates+1);

  /////////////////////////////////////////////
  // Life cycle manufacturing state encoding //
  /////////////////////////////////////////////

  // These values have been generated such that they are incrementally writeable with respect
  // to the ECC polynomial specified. The values are used to define the life cycle manufacturing
  // state and transition counter encoding in lc_ctrl_pkg.sv.
  //
  // The values are unique and have the following statistics (considering all 16
  // data and 6 ECC bits):
  //
  // - Minimum Hamming weight: 8
  // - Maximum Hamming weight: 16
  // - Minimum Hamming distance from any other value: 6
  // - Maximum Hamming distance from any other value: 20
  //
  // Hamming distance histogram:
  //
  //  0: --
  //  1: --
  //  2: --
  //  3: --
  //  4: --
  //  5: --
  //  6: |||| (6.84%)
  //  7: --
  //  8: ||||||||||| (16.70%)
  //  9: --
  // 10: ||||||||||||||||||| (29.10%)
  // 11: --
  // 12: |||||||||||||||||||| (29.82%)
  // 13: --
  // 14: |||||||| (12.83%)
  // 15: --
  // 16: || (4.30%)
  // 17: --
  // 18:  (0.36%)
  // 19: --
  // 20:  (0.06%)
  // 21: --
  // 22: --
  //
  //
  // Note that the ECC bits are not defined in this package as they will be calculated by
  // the OTP ECC logic at runtime.

  // The A/B values are used for the encoded LC state.
  parameter logic [15:0] A0 = 16'b1000011000111000; // ECC: 6'b110000
  parameter logic [15:0] B0 = 16'b1110011001111001; // ECC: 6'b111111

  parameter logic [15:0] A1 = 16'b1100011000100110; // ECC: 6'b101001
  parameter logic [15:0] B1 = 16'b1101111101101110; // ECC: 6'b101011

  parameter logic [15:0] A2 = 16'b0010000111101100; // ECC: 6'b110010
  parameter logic [15:0] B2 = 16'b0111011111101101; // ECC: 6'b110110

  parameter logic [15:0] A3 = 16'b0001100111101000; // ECC: 6'b000100
  parameter logic [15:0] B3 = 16'b1101101111101100; // ECC: 6'b001101

  parameter logic [15:0] A4 = 16'b1001011001100100; // ECC: 6'b000001
  parameter logic [15:0] B4 = 16'b1101111001110100; // ECC: 6'b101101

  parameter logic [15:0] A5 = 16'b0001011000010110; // ECC: 6'b111001
  parameter logic [15:0] B5 = 16'b1011011001110111; // ECC: 6'b111101

  parameter logic [15:0] A6 = 16'b0101001001010010; // ECC: 6'b001111
  parameter logic [15:0] B6 = 16'b1101111111110010; // ECC: 6'b001111

  parameter logic [15:0] A7 = 16'b0010001001011111; // ECC: 6'b011000
  parameter logic [15:0] B7 = 16'b0011101011111111; // ECC: 6'b011101

  parameter logic [15:0] A8 = 16'b0000001110111001; // ECC: 6'b001000
  parameter logic [15:0] B8 = 16'b1100001110111111; // ECC: 6'b101010

  parameter logic [15:0] A9 = 16'b1100100101111000; // ECC: 6'b010010
  parameter logic [15:0] B9 = 16'b1111101101111001; // ECC: 6'b011110

  parameter logic [15:0] A10 = 16'b0010000110110111; // ECC: 6'b010001
  parameter logic [15:0] B10 = 16'b1011010111111111; // ECC: 6'b010101

  parameter logic [15:0] A11 = 16'b1011000100000111; // ECC: 6'b011001
  parameter logic [15:0] B11 = 16'b1111110110000111; // ECC: 6'b011111


  // The C/D values are used for the encoded LC transition counter.
  parameter logic [15:0] C0 = 16'b0011100000010000; // ECC: 6'b111001
  parameter logic [15:0] D0 = 16'b1111100100110000; // ECC: 6'b111111

  parameter logic [15:0] C1 = 16'b0011000010101011; // ECC: 6'b100110
  parameter logic [15:0] D1 = 16'b1011010011111011; // ECC: 6'b111110

  parameter logic [15:0] C2 = 16'b0011110100100000; // ECC: 6'b011000
  parameter logic [15:0] D2 = 16'b0011111101101011; // ECC: 6'b011100

  parameter logic [15:0] C3 = 16'b1010101100010010; // ECC: 6'b111000
  parameter logic [15:0] D3 = 16'b1111111110011010; // ECC: 6'b111010

  parameter logic [15:0] C4 = 16'b0100011010010100; // ECC: 6'b110110
  parameter logic [15:0] D4 = 16'b0101111110010111; // ECC: 6'b111110

  parameter logic [15:0] C5 = 16'b1011111110000101; // ECC: 6'b000000
  parameter logic [15:0] D5 = 16'b1011111111010111; // ECC: 6'b000111

  parameter logic [15:0] C6 = 16'b1110010000010111; // ECC: 6'b010100
  parameter logic [15:0] D6 = 16'b1111110010111111; // ECC: 6'b010110

  parameter logic [15:0] C7 = 16'b0100100101011010; // ECC: 6'b001000
  parameter logic [15:0] D7 = 16'b1110100111111111; // ECC: 6'b001101

  parameter logic [15:0] C8 = 16'b0000110000011011; // ECC: 6'b110110
  parameter logic [15:0] D8 = 16'b0011111000011111; // ECC: 6'b111111

  parameter logic [15:0] C9 = 16'b0111001100010100; // ECC: 6'b011001
  parameter logic [15:0] D9 = 16'b1111101101110110; // ECC: 6'b111001

  parameter logic [15:0] C10 = 16'b0001101110100010; // ECC: 6'b100011
  parameter logic [15:0] D10 = 16'b0011111111100011; // ECC: 6'b110111

  parameter logic [15:0] C11 = 16'b0000110101000010; // ECC: 6'b111101
  parameter logic [15:0] D11 = 16'b1100110111010110; // ECC: 6'b111111

  parameter logic [15:0] C12 = 16'b0001111111010001; // ECC: 6'b000010
  parameter logic [15:0] D12 = 16'b0001111111111001; // ECC: 6'b101111

  parameter logic [15:0] C13 = 16'b0010010000110000; // ECC: 6'b111111
  parameter logic [15:0] D13 = 16'b0111011100110101; // ECC: 6'b111111

  parameter logic [15:0] C14 = 16'b0010111010001111; // ECC: 6'b001000
  parameter logic [15:0] D14 = 16'b1011111010111111; // ECC: 6'b101100

  parameter logic [15:0] C15 = 16'b0100010000111101; // ECC: 6'b011010
  parameter logic [15:0] D15 = 16'b0101110011111101; // ECC: 6'b111110


  // The E/F values are used for the encoded ID state.
  parameter logic [15:0] E0 = 16'b1110000000101100; // ECC: 6'b111001
  parameter logic [15:0] F0 = 16'b1110010110111101; // ECC: 6'b111101


  parameter logic [15:0] ZRO = 16'h0;

  ////////////////////////
  // Derived enum types //
  ////////////////////////

  typedef enum logic [LcStateWidth-1:0] {
    LcStRaw           = {ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO},
    LcStTestUnlocked0 = {A11, A10,  A9,  A8,  A7,  A6,  A5,  A4,  A3,  A2,  A1,  B0},
    LcStTestLocked0   = {A11, A10,  A9,  A8,  A7,  A6,  A5,  A4,  A3,  A2,  B1,  B0},
    LcStTestUnlocked1 = {A11, A10,  A9,  A8,  A7,  A6,  A5,  A4,  A3,  B2,  B1,  B0},
    LcStTestLocked1   = {A11, A10,  A9,  A8,  A7,  A6,  A5,  A4,  B3,  B2,  B1,  B0},
    LcStTestUnlocked2 = {A11, A10,  A9,  A8,  A7,  A6,  A5,  B4,  B3,  B2,  B1,  B0},
    LcStTestLocked2   = {A11, A10,  A9,  A8,  A7,  A6,  B5,  B4,  B3,  B2,  B1,  B0},
    LcStTestUnlocked3 = {A11, A10,  A9,  A8,  A7,  B6,  B5,  B4,  B3,  B2,  B1,  B0},
    LcStDev           = {A11, A10,  A9,  A8,  B7,  B6,  B5,  B4,  B3,  B2,  B1,  B0},
    LcStProd          = {A11, A10,  A9,  B8,  A7,  B6,  B5,  B4,  B3,  B2,  B1,  B0},
    LcStProdEnd       = {A11, A10,  B9,  A8,  A7,  B6,  B5,  B4,  B3,  B2,  B1,  B0},
    LcStRma           = {B11, B10,  A9,  B8,  B7,  B6,  B5,  B4,  B3,  B2,  B1,  B0},
    LcStScrap         = {B11, B10,  B9,  B8,  B7,  B6,  B5,  B4,  B3,  B2,  B1,  B0}
  } lc_state_e;

  typedef enum logic [LcIdStateWidth-1:0] {
    LcIdBlank        = { E0},
    LcIdPersonalized = { F0}
  } lc_id_state_e;

  typedef enum logic [LcCountWidth-1:0] {
    LcCnt0  = {ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO, ZRO},
    LcCnt1  = {C15, C14, C13, C12, C11, C10,  C9,  C8,  C7,  C6,  C5,  C4,  C3,  C2,  C1,  D0},
    LcCnt2  = {C15, C14, C13, C12, C11, C10,  C9,  C8,  C7,  C6,  C5,  C4,  C3,  C2,  D1,  D0},
    LcCnt3  = {C15, C14, C13, C12, C11, C10,  C9,  C8,  C7,  C6,  C5,  C4,  C3,  D2,  D1,  D0},
    LcCnt4  = {C15, C14, C13, C12, C11, C10,  C9,  C8,  C7,  C6,  C5,  C4,  D3,  D2,  D1,  D0},
    LcCnt5  = {C15, C14, C13, C12, C11, C10,  C9,  C8,  C7,  C6,  C5,  D4,  D3,  D2,  D1,  D0},
    LcCnt6  = {C15, C14, C13, C12, C11, C10,  C9,  C8,  C7,  C6,  D5,  D4,  D3,  D2,  D1,  D0},
    LcCnt7  = {C15, C14, C13, C12, C11, C10,  C9,  C8,  C7,  D6,  D5,  D4,  D3,  D2,  D1,  D0},
    LcCnt8  = {C15, C14, C13, C12, C11, C10,  C9,  C8,  D7,  D6,  D5,  D4,  D3,  D2,  D1,  D0},
    LcCnt9  = {C15, C14, C13, C12, C11, C10,  C9,  D8,  D7,  D6,  D5,  D4,  D3,  D2,  D1,  D0},
    LcCnt10 = {C15, C14, C13, C12, C11, C10,  D9,  D8,  D7,  D6,  D5,  D4,  D3,  D2,  D1,  D0},
    LcCnt11 = {C15, C14, C13, C12, C11, D10,  D9,  D8,  D7,  D6,  D5,  D4,  D3,  D2,  D1,  D0},
    LcCnt12 = {C15, C14, C13, C12, D11, D10,  D9,  D8,  D7,  D6,  D5,  D4,  D3,  D2,  D1,  D0},
    LcCnt13 = {C15, C14, C13, D12, D11, D10,  D9,  D8,  D7,  D6,  D5,  D4,  D3,  D2,  D1,  D0},
    LcCnt14 = {C15, C14, D13, D12, D11, D10,  D9,  D8,  D7,  D6,  D5,  D4,  D3,  D2,  D1,  D0},
    LcCnt15 = {C15, D14, D13, D12, D11, D10,  D9,  D8,  D7,  D6,  D5,  D4,  D3,  D2,  D1,  D0},
    LcCnt16 = {D15, D14, D13, D12, D11, D10,  D9,  D8,  D7,  D6,  D5,  D4,  D3,  D2,  D1,  D0}
  } lc_cnt_e;

  // Decoded life cycle state, used to interface with CSRs and TAP.
  typedef enum logic [DecLcStateWidth-1:0] {
    DecLcStRaw,
    DecLcStTestUnlocked0,
    DecLcStTestLocked0,
    DecLcStTestUnlocked1,
    DecLcStTestLocked1,
    DecLcStTestUnlocked2,
    DecLcStTestLocked2,
    DecLcStTestUnlocked3,
    DecLcStDev,
    DecLcStProd,
    DecLcStProdEnd,
    DecLcStRma,
    DecLcStScrap,
    DecLcStPostTrans,
    DecLcStEscalate,
    DecLcStInvalid
  } dec_lc_state_e;

  typedef enum logic [DecLcIdStateWidth-1:0] {
    DecLcIdBlank,
    DecLcIdPersonalized,
    DecLcIdInvalid
  } dec_lc_id_state_e;

  typedef logic [DecLcCountWidth-1:0] dec_lc_cnt_t;


  ///////////////////////////////////////////
  // Hashed RAW unlock and all-zero tokens //
  ///////////////////////////////////////////

  parameter int LcTokenWidth = 128;
  typedef logic [LcTokenWidth-1:0] lc_token_t;

  parameter lc_token_t AllZeroToken = {
    128'h0
  };
  parameter lc_token_t RndCnstRawUnlockToken = {
    128'h1C8BE2FF12790AE2E6D6A68151CBD084
  };
  parameter lc_token_t AllZeroTokenHashed = {
    128'h0
  };
  parameter lc_token_t RndCnstRawUnlockTokenHashed = {
    128'h1C8BE2FF12790AE2E6D6A68151CBD084
  };

endpackage : lc_ctrl_state_pkg
