// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// Register Top module auto-generated by `reggen`

`include "prim_assert.sv"

module kmac_reg_top (
  input clk_i,
  input rst_ni,

  input  tlul_pkg::tl_h2d_t tl_i,
  output tlul_pkg::tl_d2h_t tl_o,

  // Output port for window
  output tlul_pkg::tl_h2d_t tl_win_o  [2],
  input  tlul_pkg::tl_d2h_t tl_win_i  [2],

  // To HW
  output kmac_reg_pkg::kmac_reg2hw_t reg2hw, // Write
  input  kmac_reg_pkg::kmac_hw2reg_t hw2reg, // Read

  // Integrity check errors
  output logic intg_err_o,

  // Config
  input devmode_i // If 1, explicit error return for unmapped register access
);

  import kmac_reg_pkg::* ;

  localparam int AW = 12;
  localparam int DW = 32;
  localparam int DBW = DW/8;                    // Byte Width

  // register signals
  logic           reg_we;
  logic           reg_re;
  logic [AW-1:0]  reg_addr;
  logic [DW-1:0]  reg_wdata;
  logic [DBW-1:0] reg_be;
  logic [DW-1:0]  reg_rdata;
  logic           reg_error;

  logic          addrmiss, wr_err;

  logic [DW-1:0] reg_rdata_next;

  tlul_pkg::tl_h2d_t tl_reg_h2d;
  tlul_pkg::tl_d2h_t tl_reg_d2h;

  // incoming payload check
  logic intg_err;
  tlul_cmd_intg_chk u_chk (
    .tl_i,
    .err_o(intg_err)
  );

  logic intg_err_q;
  always_ff @(posedge clk_i or negedge rst_ni) begin
    if (!rst_ni) begin
      intg_err_q <= '0;
    end else if (intg_err) begin
      intg_err_q <= 1'b1;
    end
  end

  // integrity error output is permanent and should be used for alert generation
  // register errors are transactional
  assign intg_err_o = intg_err_q | intg_err;

  // outgoing integrity generation
  tlul_pkg::tl_d2h_t tl_o_pre;
  tlul_rsp_intg_gen u_rsp_intg_gen (
    .tl_i(tl_o_pre),
    .tl_o
  );

  tlul_pkg::tl_h2d_t tl_socket_h2d [3];
  tlul_pkg::tl_d2h_t tl_socket_d2h [3];

  logic [1:0] reg_steer;

  // socket_1n connection
  assign tl_reg_h2d = tl_socket_h2d[2];
  assign tl_socket_d2h[2] = tl_reg_d2h;

  assign tl_win_o[0] = tl_socket_h2d[0];
  assign tl_socket_d2h[0] = tl_win_i[0];
  assign tl_win_o[1] = tl_socket_h2d[1];
  assign tl_socket_d2h[1] = tl_win_i[1];

  // Create Socket_1n
  tlul_socket_1n #(
    .N          (3),
    .HReqPass   (1'b1),
    .HRspPass   (1'b1),
    .DReqPass   ({3{1'b1}}),
    .DRspPass   ({3{1'b1}}),
    .HReqDepth  (4'h0),
    .HRspDepth  (4'h0),
    .DReqDepth  ({3{4'h0}}),
    .DRspDepth  ({3{4'h0}})
  ) u_socket (
    .clk_i,
    .rst_ni,
    .tl_h_i (tl_i),
    .tl_h_o (tl_o_pre),
    .tl_d_o (tl_socket_h2d),
    .tl_d_i (tl_socket_d2h),
    .dev_select_i (reg_steer)
  );

  // Create steering logic
  always_comb begin
    reg_steer = 2;       // Default set to register

    // TODO: Can below codes be unique case () inside ?
    if (tl_i.a_address[AW-1:0] >= 1024 && tl_i.a_address[AW-1:0] < 1536) begin
      reg_steer = 0;
    end
    if (tl_i.a_address[AW-1:0] >= 2048) begin
      reg_steer = 1;
    end
    if (intg_err) begin
      reg_steer = 2;
    end
  end

  tlul_adapter_reg #(
    .RegAw(AW),
    .RegDw(DW)
  ) u_reg_if (
    .clk_i,
    .rst_ni,

    .tl_i (tl_reg_h2d),
    .tl_o (tl_reg_d2h),

    .we_o    (reg_we),
    .re_o    (reg_re),
    .addr_o  (reg_addr),
    .wdata_o (reg_wdata),
    .be_o    (reg_be),
    .rdata_i (reg_rdata),
    .error_i (reg_error)
  );

  assign reg_rdata = reg_rdata_next ;
  assign reg_error = (devmode_i & addrmiss) | wr_err | intg_err;

  // Define SW related signals
  // Format: <reg>_<field>_{wd|we|qs}
  //        or <reg>_{wd|we|qs} if field == 1 or 0
  logic intr_state_kmac_done_qs;
  logic intr_state_kmac_done_wd;
  logic intr_state_kmac_done_we;
  logic intr_state_fifo_empty_qs;
  logic intr_state_fifo_empty_wd;
  logic intr_state_fifo_empty_we;
  logic intr_state_kmac_err_qs;
  logic intr_state_kmac_err_wd;
  logic intr_state_kmac_err_we;
  logic intr_enable_kmac_done_qs;
  logic intr_enable_kmac_done_wd;
  logic intr_enable_kmac_done_we;
  logic intr_enable_fifo_empty_qs;
  logic intr_enable_fifo_empty_wd;
  logic intr_enable_fifo_empty_we;
  logic intr_enable_kmac_err_qs;
  logic intr_enable_kmac_err_wd;
  logic intr_enable_kmac_err_we;
  logic intr_test_kmac_done_wd;
  logic intr_test_kmac_done_we;
  logic intr_test_fifo_empty_wd;
  logic intr_test_fifo_empty_we;
  logic intr_test_kmac_err_wd;
  logic intr_test_kmac_err_we;
  logic cfg_regwen_qs;
  logic cfg_regwen_re;
  logic cfg_kmac_en_qs;
  logic cfg_kmac_en_wd;
  logic cfg_kmac_en_we;
  logic [2:0] cfg_kstrength_qs;
  logic [2:0] cfg_kstrength_wd;
  logic cfg_kstrength_we;
  logic [1:0] cfg_mode_qs;
  logic [1:0] cfg_mode_wd;
  logic cfg_mode_we;
  logic cfg_msg_endianness_qs;
  logic cfg_msg_endianness_wd;
  logic cfg_msg_endianness_we;
  logic cfg_state_endianness_qs;
  logic cfg_state_endianness_wd;
  logic cfg_state_endianness_we;
  logic cfg_sideload_qs;
  logic cfg_sideload_wd;
  logic cfg_sideload_we;
  logic [1:0] cfg_entropy_mode_qs;
  logic [1:0] cfg_entropy_mode_wd;
  logic cfg_entropy_mode_we;
  logic cfg_entropy_fast_process_qs;
  logic cfg_entropy_fast_process_wd;
  logic cfg_entropy_fast_process_we;
  logic cfg_entropy_ready_qs;
  logic cfg_entropy_ready_wd;
  logic cfg_entropy_ready_we;
  logic cfg_err_processed_qs;
  logic cfg_err_processed_wd;
  logic cfg_err_processed_we;
  logic [3:0] cmd_wd;
  logic cmd_we;
  logic status_sha3_idle_qs;
  logic status_sha3_idle_re;
  logic status_sha3_absorb_qs;
  logic status_sha3_absorb_re;
  logic status_sha3_squeeze_qs;
  logic status_sha3_squeeze_re;
  logic [4:0] status_fifo_depth_qs;
  logic status_fifo_depth_re;
  logic status_fifo_empty_qs;
  logic status_fifo_empty_re;
  logic status_fifo_full_qs;
  logic status_fifo_full_re;
  logic [15:0] entropy_period_entropy_timer_qs;
  logic [15:0] entropy_period_entropy_timer_wd;
  logic entropy_period_entropy_timer_we;
  logic [15:0] entropy_period_wait_timer_qs;
  logic [15:0] entropy_period_wait_timer_wd;
  logic entropy_period_wait_timer_we;
  logic [31:0] entropy_seed_lower_qs;
  logic [31:0] entropy_seed_lower_wd;
  logic entropy_seed_lower_we;
  logic [31:0] entropy_seed_upper_qs;
  logic [31:0] entropy_seed_upper_wd;
  logic entropy_seed_upper_we;
  logic [31:0] key_share0_0_wd;
  logic key_share0_0_we;
  logic [31:0] key_share0_1_wd;
  logic key_share0_1_we;
  logic [31:0] key_share0_2_wd;
  logic key_share0_2_we;
  logic [31:0] key_share0_3_wd;
  logic key_share0_3_we;
  logic [31:0] key_share0_4_wd;
  logic key_share0_4_we;
  logic [31:0] key_share0_5_wd;
  logic key_share0_5_we;
  logic [31:0] key_share0_6_wd;
  logic key_share0_6_we;
  logic [31:0] key_share0_7_wd;
  logic key_share0_7_we;
  logic [31:0] key_share0_8_wd;
  logic key_share0_8_we;
  logic [31:0] key_share0_9_wd;
  logic key_share0_9_we;
  logic [31:0] key_share0_10_wd;
  logic key_share0_10_we;
  logic [31:0] key_share0_11_wd;
  logic key_share0_11_we;
  logic [31:0] key_share0_12_wd;
  logic key_share0_12_we;
  logic [31:0] key_share0_13_wd;
  logic key_share0_13_we;
  logic [31:0] key_share0_14_wd;
  logic key_share0_14_we;
  logic [31:0] key_share0_15_wd;
  logic key_share0_15_we;
  logic [31:0] key_share1_0_wd;
  logic key_share1_0_we;
  logic [31:0] key_share1_1_wd;
  logic key_share1_1_we;
  logic [31:0] key_share1_2_wd;
  logic key_share1_2_we;
  logic [31:0] key_share1_3_wd;
  logic key_share1_3_we;
  logic [31:0] key_share1_4_wd;
  logic key_share1_4_we;
  logic [31:0] key_share1_5_wd;
  logic key_share1_5_we;
  logic [31:0] key_share1_6_wd;
  logic key_share1_6_we;
  logic [31:0] key_share1_7_wd;
  logic key_share1_7_we;
  logic [31:0] key_share1_8_wd;
  logic key_share1_8_we;
  logic [31:0] key_share1_9_wd;
  logic key_share1_9_we;
  logic [31:0] key_share1_10_wd;
  logic key_share1_10_we;
  logic [31:0] key_share1_11_wd;
  logic key_share1_11_we;
  logic [31:0] key_share1_12_wd;
  logic key_share1_12_we;
  logic [31:0] key_share1_13_wd;
  logic key_share1_13_we;
  logic [31:0] key_share1_14_wd;
  logic key_share1_14_we;
  logic [31:0] key_share1_15_wd;
  logic key_share1_15_we;
  logic [2:0] key_len_wd;
  logic key_len_we;
  logic [31:0] prefix_0_qs;
  logic [31:0] prefix_0_wd;
  logic prefix_0_we;
  logic [31:0] prefix_1_qs;
  logic [31:0] prefix_1_wd;
  logic prefix_1_we;
  logic [31:0] prefix_2_qs;
  logic [31:0] prefix_2_wd;
  logic prefix_2_we;
  logic [31:0] prefix_3_qs;
  logic [31:0] prefix_3_wd;
  logic prefix_3_we;
  logic [31:0] prefix_4_qs;
  logic [31:0] prefix_4_wd;
  logic prefix_4_we;
  logic [31:0] prefix_5_qs;
  logic [31:0] prefix_5_wd;
  logic prefix_5_we;
  logic [31:0] prefix_6_qs;
  logic [31:0] prefix_6_wd;
  logic prefix_6_we;
  logic [31:0] prefix_7_qs;
  logic [31:0] prefix_7_wd;
  logic prefix_7_we;
  logic [31:0] prefix_8_qs;
  logic [31:0] prefix_8_wd;
  logic prefix_8_we;
  logic [31:0] prefix_9_qs;
  logic [31:0] prefix_9_wd;
  logic prefix_9_we;
  logic [31:0] prefix_10_qs;
  logic [31:0] prefix_10_wd;
  logic prefix_10_we;
  logic [31:0] err_code_qs;

  // Register instances
  // R[intr_state]: V(False)

  //   F[kmac_done]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_kmac_done (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_kmac_done_we),
    .wd     (intr_state_kmac_done_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.kmac_done.de),
    .d      (hw2reg.intr_state.kmac_done.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.kmac_done.q ),

    // to register interface (read)
    .qs     (intr_state_kmac_done_qs)
  );


  //   F[fifo_empty]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_fifo_empty (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_fifo_empty_we),
    .wd     (intr_state_fifo_empty_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.fifo_empty.de),
    .d      (hw2reg.intr_state.fifo_empty.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.fifo_empty.q ),

    // to register interface (read)
    .qs     (intr_state_fifo_empty_qs)
  );


  //   F[kmac_err]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_kmac_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_kmac_err_we),
    .wd     (intr_state_kmac_err_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.kmac_err.de),
    .d      (hw2reg.intr_state.kmac_err.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.kmac_err.q ),

    // to register interface (read)
    .qs     (intr_state_kmac_err_qs)
  );


  // R[intr_enable]: V(False)

  //   F[kmac_done]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_kmac_done (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_kmac_done_we),
    .wd     (intr_enable_kmac_done_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.kmac_done.q ),

    // to register interface (read)
    .qs     (intr_enable_kmac_done_qs)
  );


  //   F[fifo_empty]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_fifo_empty (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_fifo_empty_we),
    .wd     (intr_enable_fifo_empty_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.fifo_empty.q ),

    // to register interface (read)
    .qs     (intr_enable_fifo_empty_qs)
  );


  //   F[kmac_err]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_kmac_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_kmac_err_we),
    .wd     (intr_enable_kmac_err_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.kmac_err.q ),

    // to register interface (read)
    .qs     (intr_enable_kmac_err_qs)
  );


  // R[intr_test]: V(True)

  //   F[kmac_done]: 0:0
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_kmac_done (
    .re     (1'b0),
    .we     (intr_test_kmac_done_we),
    .wd     (intr_test_kmac_done_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.kmac_done.qe),
    .q      (reg2hw.intr_test.kmac_done.q ),
    .qs     ()
  );


  //   F[fifo_empty]: 1:1
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_fifo_empty (
    .re     (1'b0),
    .we     (intr_test_fifo_empty_we),
    .wd     (intr_test_fifo_empty_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.fifo_empty.qe),
    .q      (reg2hw.intr_test.fifo_empty.q ),
    .qs     ()
  );


  //   F[kmac_err]: 2:2
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_kmac_err (
    .re     (1'b0),
    .we     (intr_test_kmac_err_we),
    .wd     (intr_test_kmac_err_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.kmac_err.qe),
    .q      (reg2hw.intr_test.kmac_err.q ),
    .qs     ()
  );


  // R[cfg_regwen]: V(True)

  prim_subreg_ext #(
    .DW    (1)
  ) u_cfg_regwen (
    .re     (cfg_regwen_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.cfg_regwen.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (cfg_regwen_qs)
  );


  // R[cfg]: V(False)

  //   F[kmac_en]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_cfg_kmac_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (cfg_kmac_en_we & cfg_regwen_qs),
    .wd     (cfg_kmac_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.cfg.kmac_en.q ),

    // to register interface (read)
    .qs     (cfg_kmac_en_qs)
  );


  //   F[kstrength]: 3:1
  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h0)
  ) u_cfg_kstrength (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (cfg_kstrength_we & cfg_regwen_qs),
    .wd     (cfg_kstrength_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.cfg.kstrength.q ),

    // to register interface (read)
    .qs     (cfg_kstrength_qs)
  );


  //   F[mode]: 5:4
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_cfg_mode (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (cfg_mode_we & cfg_regwen_qs),
    .wd     (cfg_mode_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.cfg.mode.q ),

    // to register interface (read)
    .qs     (cfg_mode_qs)
  );


  //   F[msg_endianness]: 8:8
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_cfg_msg_endianness (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (cfg_msg_endianness_we & cfg_regwen_qs),
    .wd     (cfg_msg_endianness_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.cfg.msg_endianness.q ),

    // to register interface (read)
    .qs     (cfg_msg_endianness_qs)
  );


  //   F[state_endianness]: 9:9
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_cfg_state_endianness (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (cfg_state_endianness_we & cfg_regwen_qs),
    .wd     (cfg_state_endianness_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.cfg.state_endianness.q ),

    // to register interface (read)
    .qs     (cfg_state_endianness_qs)
  );


  //   F[sideload]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_cfg_sideload (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (cfg_sideload_we & cfg_regwen_qs),
    .wd     (cfg_sideload_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.cfg.sideload.q ),

    // to register interface (read)
    .qs     (cfg_sideload_qs)
  );


  //   F[entropy_mode]: 17:16
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_cfg_entropy_mode (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (cfg_entropy_mode_we & cfg_regwen_qs),
    .wd     (cfg_entropy_mode_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.cfg.entropy_mode.q ),

    // to register interface (read)
    .qs     (cfg_entropy_mode_qs)
  );


  //   F[entropy_fast_process]: 19:19
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_cfg_entropy_fast_process (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (cfg_entropy_fast_process_we & cfg_regwen_qs),
    .wd     (cfg_entropy_fast_process_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.cfg.entropy_fast_process.q ),

    // to register interface (read)
    .qs     (cfg_entropy_fast_process_qs)
  );


  //   F[entropy_ready]: 24:24
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_cfg_entropy_ready (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (cfg_entropy_ready_we & cfg_regwen_qs),
    .wd     (cfg_entropy_ready_wd),

    // from internal hardware
    .de     (hw2reg.cfg.entropy_ready.de),
    .d      (hw2reg.cfg.entropy_ready.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.cfg.entropy_ready.q ),

    // to register interface (read)
    .qs     (cfg_entropy_ready_qs)
  );


  //   F[err_processed]: 25:25
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_cfg_err_processed (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (cfg_err_processed_we & cfg_regwen_qs),
    .wd     (cfg_err_processed_wd),

    // from internal hardware
    .de     (hw2reg.cfg.err_processed.de),
    .d      (hw2reg.cfg.err_processed.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.cfg.err_processed.q ),

    // to register interface (read)
    .qs     (cfg_err_processed_qs)
  );


  // R[cmd]: V(True)

  prim_subreg_ext #(
    .DW    (4)
  ) u_cmd (
    .re     (1'b0),
    .we     (cmd_we),
    .wd     (cmd_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.cmd.qe),
    .q      (reg2hw.cmd.q ),
    .qs     ()
  );


  // R[status]: V(True)

  //   F[sha3_idle]: 0:0
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_sha3_idle (
    .re     (status_sha3_idle_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.sha3_idle.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_sha3_idle_qs)
  );


  //   F[sha3_absorb]: 1:1
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_sha3_absorb (
    .re     (status_sha3_absorb_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.sha3_absorb.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_sha3_absorb_qs)
  );


  //   F[sha3_squeeze]: 2:2
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_sha3_squeeze (
    .re     (status_sha3_squeeze_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.sha3_squeeze.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_sha3_squeeze_qs)
  );


  //   F[fifo_depth]: 12:8
  prim_subreg_ext #(
    .DW    (5)
  ) u_status_fifo_depth (
    .re     (status_fifo_depth_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.fifo_depth.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_fifo_depth_qs)
  );


  //   F[fifo_empty]: 14:14
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_fifo_empty (
    .re     (status_fifo_empty_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.fifo_empty.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_fifo_empty_qs)
  );


  //   F[fifo_full]: 15:15
  prim_subreg_ext #(
    .DW    (1)
  ) u_status_fifo_full (
    .re     (status_fifo_full_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.status.fifo_full.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (status_fifo_full_qs)
  );


  // R[entropy_period]: V(False)

  //   F[entropy_timer]: 15:0
  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h0)
  ) u_entropy_period_entropy_timer (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (entropy_period_entropy_timer_we & cfg_regwen_qs),
    .wd     (entropy_period_entropy_timer_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.entropy_period.entropy_timer.q ),

    // to register interface (read)
    .qs     (entropy_period_entropy_timer_qs)
  );


  //   F[wait_timer]: 31:16
  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h0)
  ) u_entropy_period_wait_timer (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (entropy_period_wait_timer_we & cfg_regwen_qs),
    .wd     (entropy_period_wait_timer_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.entropy_period.wait_timer.q ),

    // to register interface (read)
    .qs     (entropy_period_wait_timer_qs)
  );


  // R[entropy_seed_lower]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_entropy_seed_lower (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (entropy_seed_lower_we & cfg_regwen_qs),
    .wd     (entropy_seed_lower_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.entropy_seed_lower.qe),
    .q      (reg2hw.entropy_seed_lower.q ),

    // to register interface (read)
    .qs     (entropy_seed_lower_qs)
  );


  // R[entropy_seed_upper]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_entropy_seed_upper (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (entropy_seed_upper_we & cfg_regwen_qs),
    .wd     (entropy_seed_upper_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.entropy_seed_upper.qe),
    .q      (reg2hw.entropy_seed_upper.q ),

    // to register interface (read)
    .qs     (entropy_seed_upper_qs)
  );



  // Subregister 0 of Multireg key_share0
  // R[key_share0_0]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_0 (
    .re     (1'b0),
    .we     (key_share0_0_we),
    .wd     (key_share0_0_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[0].qe),
    .q      (reg2hw.key_share0[0].q ),
    .qs     ()
  );

  // Subregister 1 of Multireg key_share0
  // R[key_share0_1]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_1 (
    .re     (1'b0),
    .we     (key_share0_1_we),
    .wd     (key_share0_1_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[1].qe),
    .q      (reg2hw.key_share0[1].q ),
    .qs     ()
  );

  // Subregister 2 of Multireg key_share0
  // R[key_share0_2]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_2 (
    .re     (1'b0),
    .we     (key_share0_2_we),
    .wd     (key_share0_2_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[2].qe),
    .q      (reg2hw.key_share0[2].q ),
    .qs     ()
  );

  // Subregister 3 of Multireg key_share0
  // R[key_share0_3]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_3 (
    .re     (1'b0),
    .we     (key_share0_3_we),
    .wd     (key_share0_3_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[3].qe),
    .q      (reg2hw.key_share0[3].q ),
    .qs     ()
  );

  // Subregister 4 of Multireg key_share0
  // R[key_share0_4]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_4 (
    .re     (1'b0),
    .we     (key_share0_4_we),
    .wd     (key_share0_4_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[4].qe),
    .q      (reg2hw.key_share0[4].q ),
    .qs     ()
  );

  // Subregister 5 of Multireg key_share0
  // R[key_share0_5]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_5 (
    .re     (1'b0),
    .we     (key_share0_5_we),
    .wd     (key_share0_5_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[5].qe),
    .q      (reg2hw.key_share0[5].q ),
    .qs     ()
  );

  // Subregister 6 of Multireg key_share0
  // R[key_share0_6]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_6 (
    .re     (1'b0),
    .we     (key_share0_6_we),
    .wd     (key_share0_6_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[6].qe),
    .q      (reg2hw.key_share0[6].q ),
    .qs     ()
  );

  // Subregister 7 of Multireg key_share0
  // R[key_share0_7]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_7 (
    .re     (1'b0),
    .we     (key_share0_7_we),
    .wd     (key_share0_7_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[7].qe),
    .q      (reg2hw.key_share0[7].q ),
    .qs     ()
  );

  // Subregister 8 of Multireg key_share0
  // R[key_share0_8]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_8 (
    .re     (1'b0),
    .we     (key_share0_8_we),
    .wd     (key_share0_8_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[8].qe),
    .q      (reg2hw.key_share0[8].q ),
    .qs     ()
  );

  // Subregister 9 of Multireg key_share0
  // R[key_share0_9]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_9 (
    .re     (1'b0),
    .we     (key_share0_9_we),
    .wd     (key_share0_9_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[9].qe),
    .q      (reg2hw.key_share0[9].q ),
    .qs     ()
  );

  // Subregister 10 of Multireg key_share0
  // R[key_share0_10]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_10 (
    .re     (1'b0),
    .we     (key_share0_10_we),
    .wd     (key_share0_10_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[10].qe),
    .q      (reg2hw.key_share0[10].q ),
    .qs     ()
  );

  // Subregister 11 of Multireg key_share0
  // R[key_share0_11]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_11 (
    .re     (1'b0),
    .we     (key_share0_11_we),
    .wd     (key_share0_11_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[11].qe),
    .q      (reg2hw.key_share0[11].q ),
    .qs     ()
  );

  // Subregister 12 of Multireg key_share0
  // R[key_share0_12]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_12 (
    .re     (1'b0),
    .we     (key_share0_12_we),
    .wd     (key_share0_12_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[12].qe),
    .q      (reg2hw.key_share0[12].q ),
    .qs     ()
  );

  // Subregister 13 of Multireg key_share0
  // R[key_share0_13]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_13 (
    .re     (1'b0),
    .we     (key_share0_13_we),
    .wd     (key_share0_13_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[13].qe),
    .q      (reg2hw.key_share0[13].q ),
    .qs     ()
  );

  // Subregister 14 of Multireg key_share0
  // R[key_share0_14]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_14 (
    .re     (1'b0),
    .we     (key_share0_14_we),
    .wd     (key_share0_14_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[14].qe),
    .q      (reg2hw.key_share0[14].q ),
    .qs     ()
  );

  // Subregister 15 of Multireg key_share0
  // R[key_share0_15]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share0_15 (
    .re     (1'b0),
    .we     (key_share0_15_we),
    .wd     (key_share0_15_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share0[15].qe),
    .q      (reg2hw.key_share0[15].q ),
    .qs     ()
  );



  // Subregister 0 of Multireg key_share1
  // R[key_share1_0]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_0 (
    .re     (1'b0),
    .we     (key_share1_0_we),
    .wd     (key_share1_0_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[0].qe),
    .q      (reg2hw.key_share1[0].q ),
    .qs     ()
  );

  // Subregister 1 of Multireg key_share1
  // R[key_share1_1]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_1 (
    .re     (1'b0),
    .we     (key_share1_1_we),
    .wd     (key_share1_1_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[1].qe),
    .q      (reg2hw.key_share1[1].q ),
    .qs     ()
  );

  // Subregister 2 of Multireg key_share1
  // R[key_share1_2]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_2 (
    .re     (1'b0),
    .we     (key_share1_2_we),
    .wd     (key_share1_2_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[2].qe),
    .q      (reg2hw.key_share1[2].q ),
    .qs     ()
  );

  // Subregister 3 of Multireg key_share1
  // R[key_share1_3]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_3 (
    .re     (1'b0),
    .we     (key_share1_3_we),
    .wd     (key_share1_3_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[3].qe),
    .q      (reg2hw.key_share1[3].q ),
    .qs     ()
  );

  // Subregister 4 of Multireg key_share1
  // R[key_share1_4]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_4 (
    .re     (1'b0),
    .we     (key_share1_4_we),
    .wd     (key_share1_4_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[4].qe),
    .q      (reg2hw.key_share1[4].q ),
    .qs     ()
  );

  // Subregister 5 of Multireg key_share1
  // R[key_share1_5]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_5 (
    .re     (1'b0),
    .we     (key_share1_5_we),
    .wd     (key_share1_5_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[5].qe),
    .q      (reg2hw.key_share1[5].q ),
    .qs     ()
  );

  // Subregister 6 of Multireg key_share1
  // R[key_share1_6]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_6 (
    .re     (1'b0),
    .we     (key_share1_6_we),
    .wd     (key_share1_6_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[6].qe),
    .q      (reg2hw.key_share1[6].q ),
    .qs     ()
  );

  // Subregister 7 of Multireg key_share1
  // R[key_share1_7]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_7 (
    .re     (1'b0),
    .we     (key_share1_7_we),
    .wd     (key_share1_7_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[7].qe),
    .q      (reg2hw.key_share1[7].q ),
    .qs     ()
  );

  // Subregister 8 of Multireg key_share1
  // R[key_share1_8]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_8 (
    .re     (1'b0),
    .we     (key_share1_8_we),
    .wd     (key_share1_8_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[8].qe),
    .q      (reg2hw.key_share1[8].q ),
    .qs     ()
  );

  // Subregister 9 of Multireg key_share1
  // R[key_share1_9]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_9 (
    .re     (1'b0),
    .we     (key_share1_9_we),
    .wd     (key_share1_9_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[9].qe),
    .q      (reg2hw.key_share1[9].q ),
    .qs     ()
  );

  // Subregister 10 of Multireg key_share1
  // R[key_share1_10]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_10 (
    .re     (1'b0),
    .we     (key_share1_10_we),
    .wd     (key_share1_10_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[10].qe),
    .q      (reg2hw.key_share1[10].q ),
    .qs     ()
  );

  // Subregister 11 of Multireg key_share1
  // R[key_share1_11]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_11 (
    .re     (1'b0),
    .we     (key_share1_11_we),
    .wd     (key_share1_11_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[11].qe),
    .q      (reg2hw.key_share1[11].q ),
    .qs     ()
  );

  // Subregister 12 of Multireg key_share1
  // R[key_share1_12]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_12 (
    .re     (1'b0),
    .we     (key_share1_12_we),
    .wd     (key_share1_12_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[12].qe),
    .q      (reg2hw.key_share1[12].q ),
    .qs     ()
  );

  // Subregister 13 of Multireg key_share1
  // R[key_share1_13]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_13 (
    .re     (1'b0),
    .we     (key_share1_13_we),
    .wd     (key_share1_13_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[13].qe),
    .q      (reg2hw.key_share1[13].q ),
    .qs     ()
  );

  // Subregister 14 of Multireg key_share1
  // R[key_share1_14]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_14 (
    .re     (1'b0),
    .we     (key_share1_14_we),
    .wd     (key_share1_14_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[14].qe),
    .q      (reg2hw.key_share1[14].q ),
    .qs     ()
  );

  // Subregister 15 of Multireg key_share1
  // R[key_share1_15]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_key_share1_15 (
    .re     (1'b0),
    .we     (key_share1_15_we),
    .wd     (key_share1_15_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.key_share1[15].qe),
    .q      (reg2hw.key_share1[15].q ),
    .qs     ()
  );


  // R[key_len]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("WO"),
    .RESVAL  (3'h0)
  ) u_key_len (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_len_we & cfg_regwen_qs),
    .wd     (key_len_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_len.q ),

    .qs     ()
  );



  // Subregister 0 of Multireg prefix
  // R[prefix_0]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_prefix_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prefix_0_we),
    .wd     (prefix_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prefix[0].q ),

    // to register interface (read)
    .qs     (prefix_0_qs)
  );

  // Subregister 1 of Multireg prefix
  // R[prefix_1]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_prefix_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prefix_1_we),
    .wd     (prefix_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prefix[1].q ),

    // to register interface (read)
    .qs     (prefix_1_qs)
  );

  // Subregister 2 of Multireg prefix
  // R[prefix_2]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_prefix_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prefix_2_we),
    .wd     (prefix_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prefix[2].q ),

    // to register interface (read)
    .qs     (prefix_2_qs)
  );

  // Subregister 3 of Multireg prefix
  // R[prefix_3]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_prefix_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prefix_3_we),
    .wd     (prefix_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prefix[3].q ),

    // to register interface (read)
    .qs     (prefix_3_qs)
  );

  // Subregister 4 of Multireg prefix
  // R[prefix_4]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_prefix_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prefix_4_we),
    .wd     (prefix_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prefix[4].q ),

    // to register interface (read)
    .qs     (prefix_4_qs)
  );

  // Subregister 5 of Multireg prefix
  // R[prefix_5]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_prefix_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prefix_5_we),
    .wd     (prefix_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prefix[5].q ),

    // to register interface (read)
    .qs     (prefix_5_qs)
  );

  // Subregister 6 of Multireg prefix
  // R[prefix_6]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_prefix_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prefix_6_we),
    .wd     (prefix_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prefix[6].q ),

    // to register interface (read)
    .qs     (prefix_6_qs)
  );

  // Subregister 7 of Multireg prefix
  // R[prefix_7]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_prefix_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prefix_7_we),
    .wd     (prefix_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prefix[7].q ),

    // to register interface (read)
    .qs     (prefix_7_qs)
  );

  // Subregister 8 of Multireg prefix
  // R[prefix_8]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_prefix_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prefix_8_we),
    .wd     (prefix_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prefix[8].q ),

    // to register interface (read)
    .qs     (prefix_8_qs)
  );

  // Subregister 9 of Multireg prefix
  // R[prefix_9]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_prefix_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prefix_9_we),
    .wd     (prefix_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prefix[9].q ),

    // to register interface (read)
    .qs     (prefix_9_qs)
  );

  // Subregister 10 of Multireg prefix
  // R[prefix_10]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_prefix_10 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prefix_10_we),
    .wd     (prefix_10_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prefix[10].q ),

    // to register interface (read)
    .qs     (prefix_10_qs)
  );


  // R[err_code]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RO"),
    .RESVAL  (32'h0)
  ) u_err_code (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.err_code.de),
    .d      (hw2reg.err_code.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_qs)
  );




  logic [54:0] addr_hit;
  always_comb begin
    addr_hit = '0;
    addr_hit[ 0] = (reg_addr == KMAC_INTR_STATE_OFFSET);
    addr_hit[ 1] = (reg_addr == KMAC_INTR_ENABLE_OFFSET);
    addr_hit[ 2] = (reg_addr == KMAC_INTR_TEST_OFFSET);
    addr_hit[ 3] = (reg_addr == KMAC_CFG_REGWEN_OFFSET);
    addr_hit[ 4] = (reg_addr == KMAC_CFG_OFFSET);
    addr_hit[ 5] = (reg_addr == KMAC_CMD_OFFSET);
    addr_hit[ 6] = (reg_addr == KMAC_STATUS_OFFSET);
    addr_hit[ 7] = (reg_addr == KMAC_ENTROPY_PERIOD_OFFSET);
    addr_hit[ 8] = (reg_addr == KMAC_ENTROPY_SEED_LOWER_OFFSET);
    addr_hit[ 9] = (reg_addr == KMAC_ENTROPY_SEED_UPPER_OFFSET);
    addr_hit[10] = (reg_addr == KMAC_KEY_SHARE0_0_OFFSET);
    addr_hit[11] = (reg_addr == KMAC_KEY_SHARE0_1_OFFSET);
    addr_hit[12] = (reg_addr == KMAC_KEY_SHARE0_2_OFFSET);
    addr_hit[13] = (reg_addr == KMAC_KEY_SHARE0_3_OFFSET);
    addr_hit[14] = (reg_addr == KMAC_KEY_SHARE0_4_OFFSET);
    addr_hit[15] = (reg_addr == KMAC_KEY_SHARE0_5_OFFSET);
    addr_hit[16] = (reg_addr == KMAC_KEY_SHARE0_6_OFFSET);
    addr_hit[17] = (reg_addr == KMAC_KEY_SHARE0_7_OFFSET);
    addr_hit[18] = (reg_addr == KMAC_KEY_SHARE0_8_OFFSET);
    addr_hit[19] = (reg_addr == KMAC_KEY_SHARE0_9_OFFSET);
    addr_hit[20] = (reg_addr == KMAC_KEY_SHARE0_10_OFFSET);
    addr_hit[21] = (reg_addr == KMAC_KEY_SHARE0_11_OFFSET);
    addr_hit[22] = (reg_addr == KMAC_KEY_SHARE0_12_OFFSET);
    addr_hit[23] = (reg_addr == KMAC_KEY_SHARE0_13_OFFSET);
    addr_hit[24] = (reg_addr == KMAC_KEY_SHARE0_14_OFFSET);
    addr_hit[25] = (reg_addr == KMAC_KEY_SHARE0_15_OFFSET);
    addr_hit[26] = (reg_addr == KMAC_KEY_SHARE1_0_OFFSET);
    addr_hit[27] = (reg_addr == KMAC_KEY_SHARE1_1_OFFSET);
    addr_hit[28] = (reg_addr == KMAC_KEY_SHARE1_2_OFFSET);
    addr_hit[29] = (reg_addr == KMAC_KEY_SHARE1_3_OFFSET);
    addr_hit[30] = (reg_addr == KMAC_KEY_SHARE1_4_OFFSET);
    addr_hit[31] = (reg_addr == KMAC_KEY_SHARE1_5_OFFSET);
    addr_hit[32] = (reg_addr == KMAC_KEY_SHARE1_6_OFFSET);
    addr_hit[33] = (reg_addr == KMAC_KEY_SHARE1_7_OFFSET);
    addr_hit[34] = (reg_addr == KMAC_KEY_SHARE1_8_OFFSET);
    addr_hit[35] = (reg_addr == KMAC_KEY_SHARE1_9_OFFSET);
    addr_hit[36] = (reg_addr == KMAC_KEY_SHARE1_10_OFFSET);
    addr_hit[37] = (reg_addr == KMAC_KEY_SHARE1_11_OFFSET);
    addr_hit[38] = (reg_addr == KMAC_KEY_SHARE1_12_OFFSET);
    addr_hit[39] = (reg_addr == KMAC_KEY_SHARE1_13_OFFSET);
    addr_hit[40] = (reg_addr == KMAC_KEY_SHARE1_14_OFFSET);
    addr_hit[41] = (reg_addr == KMAC_KEY_SHARE1_15_OFFSET);
    addr_hit[42] = (reg_addr == KMAC_KEY_LEN_OFFSET);
    addr_hit[43] = (reg_addr == KMAC_PREFIX_0_OFFSET);
    addr_hit[44] = (reg_addr == KMAC_PREFIX_1_OFFSET);
    addr_hit[45] = (reg_addr == KMAC_PREFIX_2_OFFSET);
    addr_hit[46] = (reg_addr == KMAC_PREFIX_3_OFFSET);
    addr_hit[47] = (reg_addr == KMAC_PREFIX_4_OFFSET);
    addr_hit[48] = (reg_addr == KMAC_PREFIX_5_OFFSET);
    addr_hit[49] = (reg_addr == KMAC_PREFIX_6_OFFSET);
    addr_hit[50] = (reg_addr == KMAC_PREFIX_7_OFFSET);
    addr_hit[51] = (reg_addr == KMAC_PREFIX_8_OFFSET);
    addr_hit[52] = (reg_addr == KMAC_PREFIX_9_OFFSET);
    addr_hit[53] = (reg_addr == KMAC_PREFIX_10_OFFSET);
    addr_hit[54] = (reg_addr == KMAC_ERR_CODE_OFFSET);
  end

  assign addrmiss = (reg_re || reg_we) ? ~|addr_hit : 1'b0 ;

  // Check sub-word write is permitted
  always_comb begin
    wr_err = 1'b0;
    if (addr_hit[ 0] && reg_we && (KMAC_PERMIT[ 0] != (KMAC_PERMIT[ 0] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 1] && reg_we && (KMAC_PERMIT[ 1] != (KMAC_PERMIT[ 1] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 2] && reg_we && (KMAC_PERMIT[ 2] != (KMAC_PERMIT[ 2] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 3] && reg_we && (KMAC_PERMIT[ 3] != (KMAC_PERMIT[ 3] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 4] && reg_we && (KMAC_PERMIT[ 4] != (KMAC_PERMIT[ 4] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 5] && reg_we && (KMAC_PERMIT[ 5] != (KMAC_PERMIT[ 5] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 6] && reg_we && (KMAC_PERMIT[ 6] != (KMAC_PERMIT[ 6] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 7] && reg_we && (KMAC_PERMIT[ 7] != (KMAC_PERMIT[ 7] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 8] && reg_we && (KMAC_PERMIT[ 8] != (KMAC_PERMIT[ 8] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 9] && reg_we && (KMAC_PERMIT[ 9] != (KMAC_PERMIT[ 9] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[10] && reg_we && (KMAC_PERMIT[10] != (KMAC_PERMIT[10] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[11] && reg_we && (KMAC_PERMIT[11] != (KMAC_PERMIT[11] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[12] && reg_we && (KMAC_PERMIT[12] != (KMAC_PERMIT[12] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[13] && reg_we && (KMAC_PERMIT[13] != (KMAC_PERMIT[13] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[14] && reg_we && (KMAC_PERMIT[14] != (KMAC_PERMIT[14] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[15] && reg_we && (KMAC_PERMIT[15] != (KMAC_PERMIT[15] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[16] && reg_we && (KMAC_PERMIT[16] != (KMAC_PERMIT[16] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[17] && reg_we && (KMAC_PERMIT[17] != (KMAC_PERMIT[17] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[18] && reg_we && (KMAC_PERMIT[18] != (KMAC_PERMIT[18] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[19] && reg_we && (KMAC_PERMIT[19] != (KMAC_PERMIT[19] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[20] && reg_we && (KMAC_PERMIT[20] != (KMAC_PERMIT[20] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[21] && reg_we && (KMAC_PERMIT[21] != (KMAC_PERMIT[21] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[22] && reg_we && (KMAC_PERMIT[22] != (KMAC_PERMIT[22] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[23] && reg_we && (KMAC_PERMIT[23] != (KMAC_PERMIT[23] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[24] && reg_we && (KMAC_PERMIT[24] != (KMAC_PERMIT[24] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[25] && reg_we && (KMAC_PERMIT[25] != (KMAC_PERMIT[25] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[26] && reg_we && (KMAC_PERMIT[26] != (KMAC_PERMIT[26] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[27] && reg_we && (KMAC_PERMIT[27] != (KMAC_PERMIT[27] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[28] && reg_we && (KMAC_PERMIT[28] != (KMAC_PERMIT[28] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[29] && reg_we && (KMAC_PERMIT[29] != (KMAC_PERMIT[29] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[30] && reg_we && (KMAC_PERMIT[30] != (KMAC_PERMIT[30] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[31] && reg_we && (KMAC_PERMIT[31] != (KMAC_PERMIT[31] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[32] && reg_we && (KMAC_PERMIT[32] != (KMAC_PERMIT[32] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[33] && reg_we && (KMAC_PERMIT[33] != (KMAC_PERMIT[33] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[34] && reg_we && (KMAC_PERMIT[34] != (KMAC_PERMIT[34] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[35] && reg_we && (KMAC_PERMIT[35] != (KMAC_PERMIT[35] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[36] && reg_we && (KMAC_PERMIT[36] != (KMAC_PERMIT[36] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[37] && reg_we && (KMAC_PERMIT[37] != (KMAC_PERMIT[37] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[38] && reg_we && (KMAC_PERMIT[38] != (KMAC_PERMIT[38] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[39] && reg_we && (KMAC_PERMIT[39] != (KMAC_PERMIT[39] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[40] && reg_we && (KMAC_PERMIT[40] != (KMAC_PERMIT[40] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[41] && reg_we && (KMAC_PERMIT[41] != (KMAC_PERMIT[41] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[42] && reg_we && (KMAC_PERMIT[42] != (KMAC_PERMIT[42] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[43] && reg_we && (KMAC_PERMIT[43] != (KMAC_PERMIT[43] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[44] && reg_we && (KMAC_PERMIT[44] != (KMAC_PERMIT[44] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[45] && reg_we && (KMAC_PERMIT[45] != (KMAC_PERMIT[45] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[46] && reg_we && (KMAC_PERMIT[46] != (KMAC_PERMIT[46] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[47] && reg_we && (KMAC_PERMIT[47] != (KMAC_PERMIT[47] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[48] && reg_we && (KMAC_PERMIT[48] != (KMAC_PERMIT[48] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[49] && reg_we && (KMAC_PERMIT[49] != (KMAC_PERMIT[49] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[50] && reg_we && (KMAC_PERMIT[50] != (KMAC_PERMIT[50] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[51] && reg_we && (KMAC_PERMIT[51] != (KMAC_PERMIT[51] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[52] && reg_we && (KMAC_PERMIT[52] != (KMAC_PERMIT[52] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[53] && reg_we && (KMAC_PERMIT[53] != (KMAC_PERMIT[53] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[54] && reg_we && (KMAC_PERMIT[54] != (KMAC_PERMIT[54] & reg_be))) wr_err = 1'b1 ;
  end

  assign intr_state_kmac_done_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_kmac_done_wd = reg_wdata[0];

  assign intr_state_fifo_empty_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_fifo_empty_wd = reg_wdata[1];

  assign intr_state_kmac_err_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_kmac_err_wd = reg_wdata[2];

  assign intr_enable_kmac_done_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_kmac_done_wd = reg_wdata[0];

  assign intr_enable_fifo_empty_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_fifo_empty_wd = reg_wdata[1];

  assign intr_enable_kmac_err_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_kmac_err_wd = reg_wdata[2];

  assign intr_test_kmac_done_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_kmac_done_wd = reg_wdata[0];

  assign intr_test_fifo_empty_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_fifo_empty_wd = reg_wdata[1];

  assign intr_test_kmac_err_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_kmac_err_wd = reg_wdata[2];

  assign cfg_regwen_re = addr_hit[3] & reg_re & !reg_error;

  assign cfg_kmac_en_we = addr_hit[4] & reg_we & !reg_error;
  assign cfg_kmac_en_wd = reg_wdata[0];

  assign cfg_kstrength_we = addr_hit[4] & reg_we & !reg_error;
  assign cfg_kstrength_wd = reg_wdata[3:1];

  assign cfg_mode_we = addr_hit[4] & reg_we & !reg_error;
  assign cfg_mode_wd = reg_wdata[5:4];

  assign cfg_msg_endianness_we = addr_hit[4] & reg_we & !reg_error;
  assign cfg_msg_endianness_wd = reg_wdata[8];

  assign cfg_state_endianness_we = addr_hit[4] & reg_we & !reg_error;
  assign cfg_state_endianness_wd = reg_wdata[9];

  assign cfg_sideload_we = addr_hit[4] & reg_we & !reg_error;
  assign cfg_sideload_wd = reg_wdata[12];

  assign cfg_entropy_mode_we = addr_hit[4] & reg_we & !reg_error;
  assign cfg_entropy_mode_wd = reg_wdata[17:16];

  assign cfg_entropy_fast_process_we = addr_hit[4] & reg_we & !reg_error;
  assign cfg_entropy_fast_process_wd = reg_wdata[19];

  assign cfg_entropy_ready_we = addr_hit[4] & reg_we & !reg_error;
  assign cfg_entropy_ready_wd = reg_wdata[24];

  assign cfg_err_processed_we = addr_hit[4] & reg_we & !reg_error;
  assign cfg_err_processed_wd = reg_wdata[25];

  assign cmd_we = addr_hit[5] & reg_we & !reg_error;
  assign cmd_wd = reg_wdata[3:0];

  assign status_sha3_idle_re = addr_hit[6] & reg_re & !reg_error;

  assign status_sha3_absorb_re = addr_hit[6] & reg_re & !reg_error;

  assign status_sha3_squeeze_re = addr_hit[6] & reg_re & !reg_error;

  assign status_fifo_depth_re = addr_hit[6] & reg_re & !reg_error;

  assign status_fifo_empty_re = addr_hit[6] & reg_re & !reg_error;

  assign status_fifo_full_re = addr_hit[6] & reg_re & !reg_error;

  assign entropy_period_entropy_timer_we = addr_hit[7] & reg_we & !reg_error;
  assign entropy_period_entropy_timer_wd = reg_wdata[15:0];

  assign entropy_period_wait_timer_we = addr_hit[7] & reg_we & !reg_error;
  assign entropy_period_wait_timer_wd = reg_wdata[31:16];

  assign entropy_seed_lower_we = addr_hit[8] & reg_we & !reg_error;
  assign entropy_seed_lower_wd = reg_wdata[31:0];

  assign entropy_seed_upper_we = addr_hit[9] & reg_we & !reg_error;
  assign entropy_seed_upper_wd = reg_wdata[31:0];

  assign key_share0_0_we = addr_hit[10] & reg_we & !reg_error;
  assign key_share0_0_wd = reg_wdata[31:0];

  assign key_share0_1_we = addr_hit[11] & reg_we & !reg_error;
  assign key_share0_1_wd = reg_wdata[31:0];

  assign key_share0_2_we = addr_hit[12] & reg_we & !reg_error;
  assign key_share0_2_wd = reg_wdata[31:0];

  assign key_share0_3_we = addr_hit[13] & reg_we & !reg_error;
  assign key_share0_3_wd = reg_wdata[31:0];

  assign key_share0_4_we = addr_hit[14] & reg_we & !reg_error;
  assign key_share0_4_wd = reg_wdata[31:0];

  assign key_share0_5_we = addr_hit[15] & reg_we & !reg_error;
  assign key_share0_5_wd = reg_wdata[31:0];

  assign key_share0_6_we = addr_hit[16] & reg_we & !reg_error;
  assign key_share0_6_wd = reg_wdata[31:0];

  assign key_share0_7_we = addr_hit[17] & reg_we & !reg_error;
  assign key_share0_7_wd = reg_wdata[31:0];

  assign key_share0_8_we = addr_hit[18] & reg_we & !reg_error;
  assign key_share0_8_wd = reg_wdata[31:0];

  assign key_share0_9_we = addr_hit[19] & reg_we & !reg_error;
  assign key_share0_9_wd = reg_wdata[31:0];

  assign key_share0_10_we = addr_hit[20] & reg_we & !reg_error;
  assign key_share0_10_wd = reg_wdata[31:0];

  assign key_share0_11_we = addr_hit[21] & reg_we & !reg_error;
  assign key_share0_11_wd = reg_wdata[31:0];

  assign key_share0_12_we = addr_hit[22] & reg_we & !reg_error;
  assign key_share0_12_wd = reg_wdata[31:0];

  assign key_share0_13_we = addr_hit[23] & reg_we & !reg_error;
  assign key_share0_13_wd = reg_wdata[31:0];

  assign key_share0_14_we = addr_hit[24] & reg_we & !reg_error;
  assign key_share0_14_wd = reg_wdata[31:0];

  assign key_share0_15_we = addr_hit[25] & reg_we & !reg_error;
  assign key_share0_15_wd = reg_wdata[31:0];

  assign key_share1_0_we = addr_hit[26] & reg_we & !reg_error;
  assign key_share1_0_wd = reg_wdata[31:0];

  assign key_share1_1_we = addr_hit[27] & reg_we & !reg_error;
  assign key_share1_1_wd = reg_wdata[31:0];

  assign key_share1_2_we = addr_hit[28] & reg_we & !reg_error;
  assign key_share1_2_wd = reg_wdata[31:0];

  assign key_share1_3_we = addr_hit[29] & reg_we & !reg_error;
  assign key_share1_3_wd = reg_wdata[31:0];

  assign key_share1_4_we = addr_hit[30] & reg_we & !reg_error;
  assign key_share1_4_wd = reg_wdata[31:0];

  assign key_share1_5_we = addr_hit[31] & reg_we & !reg_error;
  assign key_share1_5_wd = reg_wdata[31:0];

  assign key_share1_6_we = addr_hit[32] & reg_we & !reg_error;
  assign key_share1_6_wd = reg_wdata[31:0];

  assign key_share1_7_we = addr_hit[33] & reg_we & !reg_error;
  assign key_share1_7_wd = reg_wdata[31:0];

  assign key_share1_8_we = addr_hit[34] & reg_we & !reg_error;
  assign key_share1_8_wd = reg_wdata[31:0];

  assign key_share1_9_we = addr_hit[35] & reg_we & !reg_error;
  assign key_share1_9_wd = reg_wdata[31:0];

  assign key_share1_10_we = addr_hit[36] & reg_we & !reg_error;
  assign key_share1_10_wd = reg_wdata[31:0];

  assign key_share1_11_we = addr_hit[37] & reg_we & !reg_error;
  assign key_share1_11_wd = reg_wdata[31:0];

  assign key_share1_12_we = addr_hit[38] & reg_we & !reg_error;
  assign key_share1_12_wd = reg_wdata[31:0];

  assign key_share1_13_we = addr_hit[39] & reg_we & !reg_error;
  assign key_share1_13_wd = reg_wdata[31:0];

  assign key_share1_14_we = addr_hit[40] & reg_we & !reg_error;
  assign key_share1_14_wd = reg_wdata[31:0];

  assign key_share1_15_we = addr_hit[41] & reg_we & !reg_error;
  assign key_share1_15_wd = reg_wdata[31:0];

  assign key_len_we = addr_hit[42] & reg_we & !reg_error;
  assign key_len_wd = reg_wdata[2:0];

  assign prefix_0_we = addr_hit[43] & reg_we & !reg_error;
  assign prefix_0_wd = reg_wdata[31:0];

  assign prefix_1_we = addr_hit[44] & reg_we & !reg_error;
  assign prefix_1_wd = reg_wdata[31:0];

  assign prefix_2_we = addr_hit[45] & reg_we & !reg_error;
  assign prefix_2_wd = reg_wdata[31:0];

  assign prefix_3_we = addr_hit[46] & reg_we & !reg_error;
  assign prefix_3_wd = reg_wdata[31:0];

  assign prefix_4_we = addr_hit[47] & reg_we & !reg_error;
  assign prefix_4_wd = reg_wdata[31:0];

  assign prefix_5_we = addr_hit[48] & reg_we & !reg_error;
  assign prefix_5_wd = reg_wdata[31:0];

  assign prefix_6_we = addr_hit[49] & reg_we & !reg_error;
  assign prefix_6_wd = reg_wdata[31:0];

  assign prefix_7_we = addr_hit[50] & reg_we & !reg_error;
  assign prefix_7_wd = reg_wdata[31:0];

  assign prefix_8_we = addr_hit[51] & reg_we & !reg_error;
  assign prefix_8_wd = reg_wdata[31:0];

  assign prefix_9_we = addr_hit[52] & reg_we & !reg_error;
  assign prefix_9_wd = reg_wdata[31:0];

  assign prefix_10_we = addr_hit[53] & reg_we & !reg_error;
  assign prefix_10_wd = reg_wdata[31:0];

  // Read data return
  always_comb begin
    reg_rdata_next = '0;
    unique case (1'b1)
      addr_hit[0]: begin
        reg_rdata_next[0] = intr_state_kmac_done_qs;
        reg_rdata_next[1] = intr_state_fifo_empty_qs;
        reg_rdata_next[2] = intr_state_kmac_err_qs;
      end

      addr_hit[1]: begin
        reg_rdata_next[0] = intr_enable_kmac_done_qs;
        reg_rdata_next[1] = intr_enable_fifo_empty_qs;
        reg_rdata_next[2] = intr_enable_kmac_err_qs;
      end

      addr_hit[2]: begin
        reg_rdata_next[0] = '0;
        reg_rdata_next[1] = '0;
        reg_rdata_next[2] = '0;
      end

      addr_hit[3]: begin
        reg_rdata_next[0] = cfg_regwen_qs;
      end

      addr_hit[4]: begin
        reg_rdata_next[0] = cfg_kmac_en_qs;
        reg_rdata_next[3:1] = cfg_kstrength_qs;
        reg_rdata_next[5:4] = cfg_mode_qs;
        reg_rdata_next[8] = cfg_msg_endianness_qs;
        reg_rdata_next[9] = cfg_state_endianness_qs;
        reg_rdata_next[12] = cfg_sideload_qs;
        reg_rdata_next[17:16] = cfg_entropy_mode_qs;
        reg_rdata_next[19] = cfg_entropy_fast_process_qs;
        reg_rdata_next[24] = cfg_entropy_ready_qs;
        reg_rdata_next[25] = cfg_err_processed_qs;
      end

      addr_hit[5]: begin
        reg_rdata_next[3:0] = '0;
      end

      addr_hit[6]: begin
        reg_rdata_next[0] = status_sha3_idle_qs;
        reg_rdata_next[1] = status_sha3_absorb_qs;
        reg_rdata_next[2] = status_sha3_squeeze_qs;
        reg_rdata_next[12:8] = status_fifo_depth_qs;
        reg_rdata_next[14] = status_fifo_empty_qs;
        reg_rdata_next[15] = status_fifo_full_qs;
      end

      addr_hit[7]: begin
        reg_rdata_next[15:0] = entropy_period_entropy_timer_qs;
        reg_rdata_next[31:16] = entropy_period_wait_timer_qs;
      end

      addr_hit[8]: begin
        reg_rdata_next[31:0] = entropy_seed_lower_qs;
      end

      addr_hit[9]: begin
        reg_rdata_next[31:0] = entropy_seed_upper_qs;
      end

      addr_hit[10]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[11]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[12]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[13]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[14]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[15]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[16]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[17]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[18]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[19]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[20]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[21]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[22]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[23]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[24]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[25]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[26]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[27]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[28]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[29]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[30]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[31]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[32]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[33]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[34]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[35]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[36]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[37]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[38]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[39]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[40]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[41]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[42]: begin
        reg_rdata_next[2:0] = '0;
      end

      addr_hit[43]: begin
        reg_rdata_next[31:0] = prefix_0_qs;
      end

      addr_hit[44]: begin
        reg_rdata_next[31:0] = prefix_1_qs;
      end

      addr_hit[45]: begin
        reg_rdata_next[31:0] = prefix_2_qs;
      end

      addr_hit[46]: begin
        reg_rdata_next[31:0] = prefix_3_qs;
      end

      addr_hit[47]: begin
        reg_rdata_next[31:0] = prefix_4_qs;
      end

      addr_hit[48]: begin
        reg_rdata_next[31:0] = prefix_5_qs;
      end

      addr_hit[49]: begin
        reg_rdata_next[31:0] = prefix_6_qs;
      end

      addr_hit[50]: begin
        reg_rdata_next[31:0] = prefix_7_qs;
      end

      addr_hit[51]: begin
        reg_rdata_next[31:0] = prefix_8_qs;
      end

      addr_hit[52]: begin
        reg_rdata_next[31:0] = prefix_9_qs;
      end

      addr_hit[53]: begin
        reg_rdata_next[31:0] = prefix_10_qs;
      end

      addr_hit[54]: begin
        reg_rdata_next[31:0] = err_code_qs;
      end

      default: begin
        reg_rdata_next = '1;
      end
    endcase
  end

  // Unused signal tieoff

  // wdata / byte enable are not always fully used
  // add a blanket unused statement to handle lint waivers
  logic unused_wdata;
  logic unused_be;
  assign unused_wdata = ^reg_wdata;
  assign unused_be = ^reg_be;

  // Assertions for Register Interface
  `ASSERT_PULSE(wePulse, reg_we)
  `ASSERT_PULSE(rePulse, reg_re)

  `ASSERT(reAfterRv, $rose(reg_re || reg_we) |=> tl_o.d_valid)

  `ASSERT(en2addrHit, (reg_we || reg_re) |-> $onehot0(addr_hit))

  // this is formulated as an assumption such that the FPV testbenches do disprove this
  // property by mistake
  //`ASSUME(reqParity, tl_reg_h2d.a_valid |-> tl_reg_h2d.a_user.chk_en == tlul_pkg::CheckDis)

endmodule
