/*
This code is written by kerukuro and released into public domain.
*/

#ifndef DIGESTPP_PROVIDERS_WHIRLPOOL_CONSTANTS_HPP
#define DIGESTPP_PROVIDERS_WHIRLPOOL_CONSTANTS_HPP

namespace digestpp
{

namespace detail
{

template<typename V>
struct whirlpool_constants
{
	static const uint64_t RC[10];
	static const uint64_t T[8][256];
};

template<typename V>
const uint64_t whirlpool_constants<V>::RC[10] = {
	0x4f01b887e8c62318ull,
	0x52916f79f5d2a636ull,
	0x357b0ca38e9bbc60ull,
	0x57fe4b2ec2d7e01dull,
	0xda4af09fe5377715ull,
	0x856ba0b10a29c958ull,
	0x67053ecbf4105dbdull,
	0xd8957da78b4127e4ull,
	0x9e4717dd667ceefbull,
	0x33835aad07bf2dcaull
};

template<typename V>
const uint64_t whirlpool_constants<V>::T[8][256] = {
	{
		0xd83078c018601818ull, 0x2646af05238c2323ull, 0xb891f97ec63fc6c6ull, 0xfbcd6f13e887e8e8ull,
		0xcb13a14c87268787ull, 0x116d62a9b8dab8b8ull, 0x0902050801040101ull, 0x0d9e6e424f214f4full,
		0x9b6ceead36d83636ull, 0xff510459a6a2a6a6ull, 0x0cb9bdded26fd2d2ull, 0x0ef706fbf5f3f5f5ull,
		0x96f280ef79f97979ull, 0x30dece5f6fa16f6full, 0x6d3feffc917e9191ull, 0xf8a407aa52555252ull,
		0x47c0fd27609d6060ull, 0x35657689bccabcbcull, 0x372bcdac9b569b9bull, 0x8a018c048e028e8eull,
		0xd25b1571a3b6a3a3ull, 0x6c183c600c300c0cull, 0x84f68aff7bf17b7bull, 0x806ae1b535d43535ull,
		0xf53a69e81d741d1dull, 0xb3dd4753e0a7e0e0ull, 0x21b3acf6d77bd7d7ull, 0x9c99ed5ec22fc2c2ull,
		0x435c966d2eb82e2eull, 0x29967a624b314b4bull, 0x5de121a3fedffefeull, 0xd5ae168257415757ull,
		0xbd2a41a815541515ull, 0xe8eeb69f77c17777ull, 0x926eeba537dc3737ull, 0x9ed7567be5b3e5e5ull,
		0x1323d98c9f469f9full, 0x23fd17d3f0e7f0f0ull, 0x20947f6a4a354a4aull, 0x44a9959eda4fdadaull,
		0xa2b025fa587d5858ull, 0xcf8fca06c903c9c9ull, 0x7c528d5529a42929ull, 0x5a1422500a280a0aull,
		0x507f4fe1b1feb1b1ull, 0xc95d1a69a0baa0a0ull, 0x14d6da7f6bb16b6bull, 0xd917ab5c852e8585ull,
		0x3c677381bdcebdbdull, 0x8fba34d25d695d5dull, 0x9020508010401010ull, 0x07f503f3f4f7f4f4ull,
		0xdd8bc016cb0bcbcbull, 0xd37cc6ed3ef83e3eull, 0x2d0a112805140505ull, 0x78cee61f67816767ull,
		0x97d55373e4b7e4e4ull, 0x024ebb25279c2727ull, 0x7382583241194141ull, 0xa70b9d2c8b168b8bull,
		0xf6530151a7a6a7a7ull, 0xb2fa94cf7de97d7dull, 0x4937fbdc956e9595ull, 0x56ad9f8ed847d8d8ull,
		0x70eb308bfbcbfbfbull, 0xcdc17123ee9feeeeull, 0xbbf891c77ced7c7cull, 0x71cce31766856666ull,
		0x7ba78ea6dd53ddddull, 0xaf2e4bb8175c1717ull, 0x458e460247014747ull, 0x1a21dc849e429e9eull,
		0xd489c51eca0fcacaull, 0x585a99752db42d2dull, 0x2e637991bfc6bfbfull, 0x3f0e1b38071c0707ull,
		0xac472301ad8eadadull, 0xb0b42fea5a755a5aull, 0xef1bb56c83368383ull, 0xb666ff8533cc3333ull,
		0x5cc6f23f63916363ull, 0x12040a1002080202ull, 0x93493839aa92aaaaull, 0xdee2a8af71d97171ull,
		0xc68dcf0ec807c8c8ull, 0xd1327dc819641919ull, 0x3b92707249394949ull, 0x5faf9a86d943d9d9ull,
		0x31f91dc3f2eff2f2ull, 0xa8db484be3abe3e3ull, 0xb9b62ae25b715b5bull, 0xbc0d9234881a8888ull,
		0x3e29c8a49a529a9aull, 0x0b4cbe2d26982626ull, 0xbf64fa8d32c83232ull, 0x597d4ae9b0fab0b0ull,
		0xf2cf6a1be983e9e9ull, 0x771e33780f3c0f0full, 0x33b7a6e6d573d5d5ull, 0xf41dba74803a8080ull,
		0x27617c99bec2bebeull, 0xeb87de26cd13cdcdull, 0x8968e4bd34d03434ull, 0x3290757a483d4848ull,
		0x54e324abffdbffffull, 0x8df48ff77af57a7aull, 0x643deaf4907a9090ull, 0x9dbe3ec25f615f5full,
		0x3d40a01d20802020ull, 0x0fd0d56768bd6868ull, 0xca3472d01a681a1aull, 0xb7412c19ae82aeaeull,
		0x7d755ec9b4eab4b4ull, 0xcea8199a544d5454ull, 0x7f3be5ec93769393ull, 0x2f44aa0d22882222ull,
		0x63c8e907648d6464ull, 0x2aff12dbf1e3f1f1ull, 0xcce6a2bf73d17373ull, 0x82245a9012481212ull,
		0x7a805d3a401d4040ull, 0x4810284008200808ull, 0x959be856c32bc3c3ull, 0xdfc57b33ec97ececull,
		0x4dab9096db4bdbdbull, 0xc05f1f61a1bea1a1ull, 0x9107831c8d0e8d8dull, 0xc87ac9f53df43d3dull,
		0x5b33f1cc97669797ull, 0x0000000000000000ull, 0xf983d436cf1bcfcfull, 0x6e5687452bac2b2bull,
		0xe1ecb39776c57676ull, 0xe619b06482328282ull, 0x28b1a9fed67fd6d6ull, 0xc33677d81b6c1b1bull,
		0x74775bc1b5eeb5b5ull, 0xbe432911af86afafull, 0x1dd4df776ab56a6aull, 0xeaa00dba505d5050ull,
		0x578a4c1245094545ull, 0x38fb18cbf3ebf3f3ull, 0xad60f09d30c03030ull, 0xc4c3742bef9befefull,
		0xda7ec3e53ffc3f3full, 0xc7aa1c9255495555ull, 0xdb591079a2b2a2a2ull, 0xe9c96503ea8feaeaull,
		0x6acaec0f65896565ull, 0x036968b9bad2babaull, 0x4a5e93652fbc2f2full, 0x8e9de74ec027c0c0ull,
		0x60a181bede5fdedeull, 0xfc386ce01c701c1cull, 0x46e72ebbfdd3fdfdull, 0x1f9a64524d294d4dull,
		0x7639e0e492729292ull, 0xfaeabc8f75c97575ull, 0x360c1e3006180606ull, 0xae0998248a128a8aull,
		0x4b7940f9b2f2b2b2ull, 0x85d15963e6bfe6e6ull, 0x7e1c36700e380e0eull, 0xe73e63f81f7c1f1full,
		0x55c4f73762956262ull, 0x3ab5a3eed477d4d4ull, 0x814d3229a89aa8a8ull, 0x5231f4c496629696ull,
		0x62ef3a9bf9c3f9f9ull, 0xa397f666c533c5c5ull, 0x104ab13525942525ull, 0xabb220f259795959ull,
		0xd015ae54842a8484ull, 0xc5e4a7b772d57272ull, 0xec72ddd539e43939ull, 0x1698615a4c2d4c4cull,
		0x94bc3bca5e655e5eull, 0x9ff085e778fd7878ull, 0xe570d8dd38e03838ull, 0x980586148c0a8c8cull,
		0x17bfb2c6d163d1d1ull, 0xe4570b41a5aea5a5ull, 0xa1d94d43e2afe2e2ull, 0x4ec2f82f61996161ull,
		0x427b45f1b3f6b3b3ull, 0x3442a51521842121ull, 0x0825d6949c4a9c9cull, 0xee3c66f01e781e1eull,
		0x6186522243114343ull, 0xb193fc76c73bc7c7ull, 0x4fe52bb3fcd7fcfcull, 0x2408142004100404ull,
		0xe3a208b251595151ull, 0x252fc7bc995e9999ull, 0x22dac44f6da96d6dull, 0x651a39680d340d0dull,
		0x79e93583facffafaull, 0x69a384b6df5bdfdfull, 0xa9fc9bd77ee57e7eull, 0x1948b43d24902424ull,
		0xfe76d7c53bec3b3bull, 0x9a4b3d31ab96ababull, 0xf081d13ece1fceceull, 0x9922558811441111ull,
		0x8303890c8f068f8full, 0x049c6b4a4e254e4eull, 0x667351d1b7e6b7b7ull, 0xe0cb600beb8bebebull,
		0xc178ccfd3cf03c3cull, 0xfd1fbf7c813e8181ull, 0x4035fed4946a9494ull, 0x1cf30cebf7fbf7f7ull,
		0x186f67a1b9deb9b9ull, 0x8b265f98134c1313ull, 0x51589c7d2cb02c2cull, 0x05bbb8d6d36bd3d3ull,
		0x8cd35c6be7bbe7e7ull, 0x39dccb576ea56e6eull, 0xaa95f36ec437c4c4ull, 0x1b060f18030c0303ull,
		0xdcac138a56455656ull, 0x5e88491a440d4444ull, 0xa0fe9edf7fe17f7full, 0x884f3721a99ea9a9ull,
		0x6754824d2aa82a2aull, 0x0a6b6db1bbd6bbbbull, 0x879fe246c123c1c1ull, 0xf1a602a253515353ull,
		0x72a58baedc57dcdcull, 0x531627580b2c0b0bull, 0x0127d39c9d4e9d9dull, 0x2bd8c1476cad6c6cull,
		0xa462f59531c43131ull, 0xf3e8b98774cd7474ull, 0x15f109e3f6fff6f6ull, 0x4c8c430a46054646ull,
		0xa5452609ac8aacacull, 0xb50f973c891e8989ull, 0xb42844a014501414ull, 0xbadf425be1a3e1e1ull,
		0xa62c4eb016581616ull, 0xf774d2cd3ae83a3aull, 0x06d2d06f69b96969ull, 0x41122d4809240909ull,
		0xd7e0ada770dd7070ull, 0x6f7154d9b6e2b6b6ull, 0x1ebdb7ced067d0d0ull, 0xd6c77e3bed93ededull,
		0xe285db2ecc17ccccull, 0x6884572a42154242ull, 0x2c2dc2b4985a9898ull, 0xed550e49a4aaa4a4ull,
		0x7550885d28a02828ull, 0x86b831da5c6d5c5cull, 0x6bed3f93f8c7f8f8ull, 0xc211a44486228686ull
	},
	{
		0x3078c018601818d8ull, 0x46af05238c232326ull, 0x91f97ec63fc6c6b8ull, 0xcd6f13e887e8e8fbull,
		0x13a14c87268787cbull, 0x6d62a9b8dab8b811ull, 0x0205080104010109ull, 0x9e6e424f214f4f0dull,
		0x6ceead36d836369bull, 0x510459a6a2a6a6ffull, 0xb9bdded26fd2d20cull, 0xf706fbf5f3f5f50eull,
		0xf280ef79f9797996ull, 0xdece5f6fa16f6f30ull, 0x3feffc917e91916dull, 0xa407aa52555252f8ull,
		0xc0fd27609d606047ull, 0x657689bccabcbc35ull, 0x2bcdac9b569b9b37ull, 0x018c048e028e8e8aull,
		0x5b1571a3b6a3a3d2ull, 0x183c600c300c0c6cull, 0xf68aff7bf17b7b84ull, 0x6ae1b535d4353580ull,
		0x3a69e81d741d1df5ull, 0xdd4753e0a7e0e0b3ull, 0xb3acf6d77bd7d721ull, 0x99ed5ec22fc2c29cull,
		0x5c966d2eb82e2e43ull, 0x967a624b314b4b29ull, 0xe121a3fedffefe5dull, 0xae168257415757d5ull,
		0x2a41a815541515bdull, 0xeeb69f77c17777e8ull, 0x6eeba537dc373792ull, 0xd7567be5b3e5e59eull,
		0x23d98c9f469f9f13ull, 0xfd17d3f0e7f0f023ull, 0x947f6a4a354a4a20ull, 0xa9959eda4fdada44ull,
		0xb025fa587d5858a2ull, 0x8fca06c903c9c9cfull, 0x528d5529a429297cull, 0x1422500a280a0a5aull,
		0x7f4fe1b1feb1b150ull, 0x5d1a69a0baa0a0c9ull, 0xd6da7f6bb16b6b14ull, 0x17ab5c852e8585d9ull,
		0x677381bdcebdbd3cull, 0xba34d25d695d5d8full, 0x2050801040101090ull, 0xf503f3f4f7f4f407ull,
		0x8bc016cb0bcbcbddull, 0x7cc6ed3ef83e3ed3ull, 0x0a1128051405052dull, 0xcee61f6781676778ull,
		0xd55373e4b7e4e497ull, 0x4ebb25279c272702ull, 0x8258324119414173ull, 0x0b9d2c8b168b8ba7ull,
		0x530151a7a6a7a7f6ull, 0xfa94cf7de97d7db2ull, 0x37fbdc956e959549ull, 0xad9f8ed847d8d856ull,
		0xeb308bfbcbfbfb70ull, 0xc17123ee9feeeecdull, 0xf891c77ced7c7cbbull, 0xcce3176685666671ull,
		0xa78ea6dd53dddd7bull, 0x2e4bb8175c1717afull, 0x8e46024701474745ull, 0x21dc849e429e9e1aull,
		0x89c51eca0fcacad4ull, 0x5a99752db42d2d58ull, 0x637991bfc6bfbf2eull, 0x0e1b38071c07073full,
		0x472301ad8eadadacull, 0xb42fea5a755a5ab0ull, 0x1bb56c83368383efull, 0x66ff8533cc3333b6ull,
		0xc6f23f639163635cull, 0x040a100208020212ull, 0x493839aa92aaaa93ull, 0xe2a8af71d97171deull,
		0x8dcf0ec807c8c8c6ull, 0x327dc819641919d1ull, 0x927072493949493bull, 0xaf9a86d943d9d95full,
		0xf91dc3f2eff2f231ull, 0xdb484be3abe3e3a8ull, 0xb62ae25b715b5bb9ull, 0x0d9234881a8888bcull,
		0x29c8a49a529a9a3eull, 0x4cbe2d269826260bull, 0x64fa8d32c83232bfull, 0x7d4ae9b0fab0b059ull,
		0xcf6a1be983e9e9f2ull, 0x1e33780f3c0f0f77ull, 0xb7a6e6d573d5d533ull, 0x1dba74803a8080f4ull,
		0x617c99bec2bebe27ull, 0x87de26cd13cdcdebull, 0x68e4bd34d0343489ull, 0x90757a483d484832ull,
		0xe324abffdbffff54ull, 0xf48ff77af57a7a8dull, 0x3deaf4907a909064ull, 0xbe3ec25f615f5f9dull,
		0x40a01d208020203dull, 0xd0d56768bd68680full, 0x3472d01a681a1acaull, 0x412c19ae82aeaeb7ull,
		0x755ec9b4eab4b47dull, 0xa8199a544d5454ceull, 0x3be5ec937693937full, 0x44aa0d228822222full,
		0xc8e907648d646463ull, 0xff12dbf1e3f1f12aull, 0xe6a2bf73d17373ccull, 0x245a901248121282ull,
		0x805d3a401d40407aull, 0x1028400820080848ull, 0x9be856c32bc3c395ull, 0xc57b33ec97ececdfull,
		0xab9096db4bdbdb4dull, 0x5f1f61a1bea1a1c0ull, 0x07831c8d0e8d8d91ull, 0x7ac9f53df43d3dc8ull,
		0x33f1cc976697975bull, 0x0000000000000000ull, 0x83d436cf1bcfcff9ull, 0x5687452bac2b2b6eull,
		0xecb39776c57676e1ull, 0x19b06482328282e6ull, 0xb1a9fed67fd6d628ull, 0x3677d81b6c1b1bc3ull,
		0x775bc1b5eeb5b574ull, 0x432911af86afafbeull, 0xd4df776ab56a6a1dull, 0xa00dba505d5050eaull,
		0x8a4c124509454557ull, 0xfb18cbf3ebf3f338ull, 0x60f09d30c03030adull, 0xc3742bef9befefc4ull,
		0x7ec3e53ffc3f3fdaull, 0xaa1c9255495555c7ull, 0x591079a2b2a2a2dbull, 0xc96503ea8feaeae9ull,
		0xcaec0f658965656aull, 0x6968b9bad2baba03ull, 0x5e93652fbc2f2f4aull, 0x9de74ec027c0c08eull,
		0xa181bede5fdede60ull, 0x386ce01c701c1cfcull, 0xe72ebbfdd3fdfd46ull, 0x9a64524d294d4d1full,
		0x39e0e49272929276ull, 0xeabc8f75c97575faull, 0x0c1e300618060636ull, 0x0998248a128a8aaeull,
		0x7940f9b2f2b2b24bull, 0xd15963e6bfe6e685ull, 0x1c36700e380e0e7eull, 0x3e63f81f7c1f1fe7ull,
		0xc4f7376295626255ull, 0xb5a3eed477d4d43aull, 0x4d3229a89aa8a881ull, 0x31f4c49662969652ull,
		0xef3a9bf9c3f9f962ull, 0x97f666c533c5c5a3ull, 0x4ab1352594252510ull, 0xb220f259795959abull,
		0x15ae54842a8484d0ull, 0xe4a7b772d57272c5ull, 0x72ddd539e43939ecull, 0x98615a4c2d4c4c16ull,
		0xbc3bca5e655e5e94ull, 0xf085e778fd78789full, 0x70d8dd38e03838e5ull, 0x0586148c0a8c8c98ull,
		0xbfb2c6d163d1d117ull, 0x570b41a5aea5a5e4ull, 0xd94d43e2afe2e2a1ull, 0xc2f82f619961614eull,
		0x7b45f1b3f6b3b342ull, 0x42a5152184212134ull, 0x25d6949c4a9c9c08ull, 0x3c66f01e781e1eeeull,
		0x8652224311434361ull, 0x93fc76c73bc7c7b1ull, 0xe52bb3fcd7fcfc4full, 0x0814200410040424ull,
		0xa208b251595151e3ull, 0x2fc7bc995e999925ull, 0xdac44f6da96d6d22ull, 0x1a39680d340d0d65ull,
		0xe93583facffafa79ull, 0xa384b6df5bdfdf69ull, 0xfc9bd77ee57e7ea9ull, 0x48b43d2490242419ull,
		0x76d7c53bec3b3bfeull, 0x4b3d31ab96abab9aull, 0x81d13ece1fcecef0ull, 0x2255881144111199ull,
		0x03890c8f068f8f83ull, 0x9c6b4a4e254e4e04ull, 0x7351d1b7e6b7b766ull, 0xcb600beb8bebebe0ull,
		0x78ccfd3cf03c3cc1ull, 0x1fbf7c813e8181fdull, 0x35fed4946a949440ull, 0xf30cebf7fbf7f71cull,
		0x6f67a1b9deb9b918ull, 0x265f98134c13138bull, 0x589c7d2cb02c2c51ull, 0xbbb8d6d36bd3d305ull,
		0xd35c6be7bbe7e78cull, 0xdccb576ea56e6e39ull, 0x95f36ec437c4c4aaull, 0x060f18030c03031bull,
		0xac138a56455656dcull, 0x88491a440d44445eull, 0xfe9edf7fe17f7fa0ull, 0x4f3721a99ea9a988ull,
		0x54824d2aa82a2a67ull, 0x6b6db1bbd6bbbb0aull, 0x9fe246c123c1c187ull, 0xa602a253515353f1ull,
		0xa58baedc57dcdc72ull, 0x1627580b2c0b0b53ull, 0x27d39c9d4e9d9d01ull, 0xd8c1476cad6c6c2bull,
		0x62f59531c43131a4ull, 0xe8b98774cd7474f3ull, 0xf109e3f6fff6f615ull, 0x8c430a460546464cull,
		0x452609ac8aacaca5ull, 0x0f973c891e8989b5ull, 0x2844a014501414b4ull, 0xdf425be1a3e1e1baull,
		0x2c4eb016581616a6ull, 0x74d2cd3ae83a3af7ull, 0xd2d06f69b9696906ull, 0x122d480924090941ull,
		0xe0ada770dd7070d7ull, 0x7154d9b6e2b6b66full, 0xbdb7ced067d0d01eull, 0xc77e3bed93ededd6ull,
		0x85db2ecc17cccce2ull, 0x84572a4215424268ull, 0x2dc2b4985a98982cull, 0x550e49a4aaa4a4edull,
		0x50885d28a0282875ull, 0xb831da5c6d5c5c86ull, 0xed3f93f8c7f8f86bull, 0x11a44486228686c2ull
	},
	{
		0x78c018601818d830ull, 0xaf05238c23232646ull, 0xf97ec63fc6c6b891ull, 0x6f13e887e8e8fbcdull,
		0xa14c87268787cb13ull, 0x62a9b8dab8b8116dull, 0x0508010401010902ull, 0x6e424f214f4f0d9eull,
		0xeead36d836369b6cull, 0x0459a6a2a6a6ff51ull, 0xbdded26fd2d20cb9ull, 0x06fbf5f3f5f50ef7ull,
		0x80ef79f9797996f2ull, 0xce5f6fa16f6f30deull, 0xeffc917e91916d3full, 0x07aa52555252f8a4ull,
		0xfd27609d606047c0ull, 0x7689bccabcbc3565ull, 0xcdac9b569b9b372bull, 0x8c048e028e8e8a01ull,
		0x1571a3b6a3a3d25bull, 0x3c600c300c0c6c18ull, 0x8aff7bf17b7b84f6ull, 0xe1b535d43535806aull,
		0x69e81d741d1df53aull, 0x4753e0a7e0e0b3ddull, 0xacf6d77bd7d721b3ull, 0xed5ec22fc2c29c99ull,
		0x966d2eb82e2e435cull, 0x7a624b314b4b2996ull, 0x21a3fedffefe5de1ull, 0x168257415757d5aeull,
		0x41a815541515bd2aull, 0xb69f77c17777e8eeull, 0xeba537dc3737926eull, 0x567be5b3e5e59ed7ull,
		0xd98c9f469f9f1323ull, 0x17d3f0e7f0f023fdull, 0x7f6a4a354a4a2094ull, 0x959eda4fdada44a9ull,
		0x25fa587d5858a2b0ull, 0xca06c903c9c9cf8full, 0x8d5529a429297c52ull, 0x22500a280a0a5a14ull,
		0x4fe1b1feb1b1507full, 0x1a69a0baa0a0c95dull, 0xda7f6bb16b6b14d6ull, 0xab5c852e8585d917ull,
		0x7381bdcebdbd3c67ull, 0x34d25d695d5d8fbaull, 0x5080104010109020ull, 0x03f3f4f7f4f407f5ull,
		0xc016cb0bcbcbdd8bull, 0xc6ed3ef83e3ed37cull, 0x1128051405052d0aull, 0xe61f6781676778ceull,
		0x5373e4b7e4e497d5ull, 0xbb25279c2727024eull, 0x5832411941417382ull, 0x9d2c8b168b8ba70bull,
		0x0151a7a6a7a7f653ull, 0x94cf7de97d7db2faull, 0xfbdc956e95954937ull, 0x9f8ed847d8d856adull,
		0x308bfbcbfbfb70ebull, 0x7123ee9feeeecdc1ull, 0x91c77ced7c7cbbf8ull, 0xe3176685666671ccull,
		0x8ea6dd53dddd7ba7ull, 0x4bb8175c1717af2eull, 0x460247014747458eull, 0xdc849e429e9e1a21ull,
		0xc51eca0fcacad489ull, 0x99752db42d2d585aull, 0x7991bfc6bfbf2e63ull, 0x1b38071c07073f0eull,
		0x2301ad8eadadac47ull, 0x2fea5a755a5ab0b4ull, 0xb56c83368383ef1bull, 0xff8533cc3333b666ull,
		0xf23f639163635cc6ull, 0x0a10020802021204ull, 0x3839aa92aaaa9349ull, 0xa8af71d97171dee2ull,
		0xcf0ec807c8c8c68dull, 0x7dc819641919d132ull, 0x7072493949493b92ull, 0x9a86d943d9d95fafull,
		0x1dc3f2eff2f231f9ull, 0x484be3abe3e3a8dbull, 0x2ae25b715b5bb9b6ull, 0x9234881a8888bc0dull,
		0xc8a49a529a9a3e29ull, 0xbe2d269826260b4cull, 0xfa8d32c83232bf64ull, 0x4ae9b0fab0b0597dull,
		0x6a1be983e9e9f2cfull, 0x33780f3c0f0f771eull, 0xa6e6d573d5d533b7ull, 0xba74803a8080f41dull,
		0x7c99bec2bebe2761ull, 0xde26cd13cdcdeb87ull, 0xe4bd34d034348968ull, 0x757a483d48483290ull,
		0x24abffdbffff54e3ull, 0x8ff77af57a7a8df4ull, 0xeaf4907a9090643dull, 0x3ec25f615f5f9dbeull,
		0xa01d208020203d40ull, 0xd56768bd68680fd0ull, 0x72d01a681a1aca34ull, 0x2c19ae82aeaeb741ull,
		0x5ec9b4eab4b47d75ull, 0x199a544d5454cea8ull, 0xe5ec937693937f3bull, 0xaa0d228822222f44ull,
		0xe907648d646463c8ull, 0x12dbf1e3f1f12affull, 0xa2bf73d17373cce6ull, 0x5a90124812128224ull,
		0x5d3a401d40407a80ull, 0x2840082008084810ull, 0xe856c32bc3c3959bull, 0x7b33ec97ececdfc5ull,
		0x9096db4bdbdb4dabull, 0x1f61a1bea1a1c05full, 0x831c8d0e8d8d9107ull, 0xc9f53df43d3dc87aull,
		0xf1cc976697975b33ull, 0x0000000000000000ull, 0xd436cf1bcfcff983ull, 0x87452bac2b2b6e56ull,
		0xb39776c57676e1ecull, 0xb06482328282e619ull, 0xa9fed67fd6d628b1ull, 0x77d81b6c1b1bc336ull,
		0x5bc1b5eeb5b57477ull, 0x2911af86afafbe43ull, 0xdf776ab56a6a1dd4ull, 0x0dba505d5050eaa0ull,
		0x4c1245094545578aull, 0x18cbf3ebf3f338fbull, 0xf09d30c03030ad60ull, 0x742bef9befefc4c3ull,
		0xc3e53ffc3f3fda7eull, 0x1c9255495555c7aaull, 0x1079a2b2a2a2db59ull, 0x6503ea8feaeae9c9ull,
		0xec0f658965656acaull, 0x68b9bad2baba0369ull, 0x93652fbc2f2f4a5eull, 0xe74ec027c0c08e9dull,
		0x81bede5fdede60a1ull, 0x6ce01c701c1cfc38ull, 0x2ebbfdd3fdfd46e7ull, 0x64524d294d4d1f9aull,
		0xe0e4927292927639ull, 0xbc8f75c97575faeaull, 0x1e3006180606360cull, 0x98248a128a8aae09ull,
		0x40f9b2f2b2b24b79ull, 0x5963e6bfe6e685d1ull, 0x36700e380e0e7e1cull, 0x63f81f7c1f1fe73eull,
		0xf7376295626255c4ull, 0xa3eed477d4d43ab5ull, 0x3229a89aa8a8814dull, 0xf4c4966296965231ull,
		0x3a9bf9c3f9f962efull, 0xf666c533c5c5a397ull, 0xb13525942525104aull, 0x20f259795959abb2ull,
		0xae54842a8484d015ull, 0xa7b772d57272c5e4ull, 0xddd539e43939ec72ull, 0x615a4c2d4c4c1698ull,
		0x3bca5e655e5e94bcull, 0x85e778fd78789ff0ull, 0xd8dd38e03838e570ull, 0x86148c0a8c8c9805ull,
		0xb2c6d163d1d117bfull, 0x0b41a5aea5a5e457ull, 0x4d43e2afe2e2a1d9ull, 0xf82f619961614ec2ull,
		0x45f1b3f6b3b3427bull, 0xa515218421213442ull, 0xd6949c4a9c9c0825ull, 0x66f01e781e1eee3cull,
		0x5222431143436186ull, 0xfc76c73bc7c7b193ull, 0x2bb3fcd7fcfc4fe5ull, 0x1420041004042408ull,
		0x08b251595151e3a2ull, 0xc7bc995e9999252full, 0xc44f6da96d6d22daull, 0x39680d340d0d651aull,
		0x3583facffafa79e9ull, 0x84b6df5bdfdf69a3ull, 0x9bd77ee57e7ea9fcull, 0xb43d249024241948ull,
		0xd7c53bec3b3bfe76ull, 0x3d31ab96abab9a4bull, 0xd13ece1fcecef081ull, 0x5588114411119922ull,
		0x890c8f068f8f8303ull, 0x6b4a4e254e4e049cull, 0x51d1b7e6b7b76673ull, 0x600beb8bebebe0cbull,
		0xccfd3cf03c3cc178ull, 0xbf7c813e8181fd1full, 0xfed4946a94944035ull, 0x0cebf7fbf7f71cf3ull,
		0x67a1b9deb9b9186full, 0x5f98134c13138b26ull, 0x9c7d2cb02c2c5158ull, 0xb8d6d36bd3d305bbull,
		0x5c6be7bbe7e78cd3ull, 0xcb576ea56e6e39dcull, 0xf36ec437c4c4aa95ull, 0x0f18030c03031b06ull,
		0x138a56455656dcacull, 0x491a440d44445e88ull, 0x9edf7fe17f7fa0feull, 0x3721a99ea9a9884full,
		0x824d2aa82a2a6754ull, 0x6db1bbd6bbbb0a6bull, 0xe246c123c1c1879full, 0x02a253515353f1a6ull,
		0x8baedc57dcdc72a5ull, 0x27580b2c0b0b5316ull, 0xd39c9d4e9d9d0127ull, 0xc1476cad6c6c2bd8ull,
		0xf59531c43131a462ull, 0xb98774cd7474f3e8ull, 0x09e3f6fff6f615f1ull, 0x430a460546464c8cull,
		0x2609ac8aacaca545ull, 0x973c891e8989b50full, 0x44a014501414b428ull, 0x425be1a3e1e1badfull,
		0x4eb016581616a62cull, 0xd2cd3ae83a3af774ull, 0xd06f69b9696906d2ull, 0x2d48092409094112ull,
		0xada770dd7070d7e0ull, 0x54d9b6e2b6b66f71ull, 0xb7ced067d0d01ebdull, 0x7e3bed93ededd6c7ull,
		0xdb2ecc17cccce285ull, 0x572a421542426884ull, 0xc2b4985a98982c2dull, 0x0e49a4aaa4a4ed55ull,
		0x885d28a028287550ull, 0x31da5c6d5c5c86b8ull, 0x3f93f8c7f8f86bedull, 0xa44486228686c211ull
	},
	{
		0xc018601818d83078ull, 0x05238c23232646afull, 0x7ec63fc6c6b891f9ull, 0x13e887e8e8fbcd6full,
		0x4c87268787cb13a1ull, 0xa9b8dab8b8116d62ull, 0x0801040101090205ull, 0x424f214f4f0d9e6eull,
		0xad36d836369b6ceeull, 0x59a6a2a6a6ff5104ull, 0xded26fd2d20cb9bdull, 0xfbf5f3f5f50ef706ull,
		0xef79f9797996f280ull, 0x5f6fa16f6f30deceull, 0xfc917e91916d3fefull, 0xaa52555252f8a407ull,
		0x27609d606047c0fdull, 0x89bccabcbc356576ull, 0xac9b569b9b372bcdull, 0x048e028e8e8a018cull,
		0x71a3b6a3a3d25b15ull, 0x600c300c0c6c183cull, 0xff7bf17b7b84f68aull, 0xb535d43535806ae1ull,
		0xe81d741d1df53a69ull, 0x53e0a7e0e0b3dd47ull, 0xf6d77bd7d721b3acull, 0x5ec22fc2c29c99edull,
		0x6d2eb82e2e435c96ull, 0x624b314b4b29967aull, 0xa3fedffefe5de121ull, 0x8257415757d5ae16ull,
		0xa815541515bd2a41ull, 0x9f77c17777e8eeb6ull, 0xa537dc3737926eebull, 0x7be5b3e5e59ed756ull,
		0x8c9f469f9f1323d9ull, 0xd3f0e7f0f023fd17ull, 0x6a4a354a4a20947full, 0x9eda4fdada44a995ull,
		0xfa587d5858a2b025ull, 0x06c903c9c9cf8fcaull, 0x5529a429297c528dull, 0x500a280a0a5a1422ull,
		0xe1b1feb1b1507f4full, 0x69a0baa0a0c95d1aull, 0x7f6bb16b6b14d6daull, 0x5c852e8585d917abull,
		0x81bdcebdbd3c6773ull, 0xd25d695d5d8fba34ull, 0x8010401010902050ull, 0xf3f4f7f4f407f503ull,
		0x16cb0bcbcbdd8bc0ull, 0xed3ef83e3ed37cc6ull, 0x28051405052d0a11ull, 0x1f6781676778cee6ull,
		0x73e4b7e4e497d553ull, 0x25279c2727024ebbull, 0x3241194141738258ull, 0x2c8b168b8ba70b9dull,
		0x51a7a6a7a7f65301ull, 0xcf7de97d7db2fa94ull, 0xdc956e95954937fbull, 0x8ed847d8d856ad9full,
		0x8bfbcbfbfb70eb30ull, 0x23ee9feeeecdc171ull, 0xc77ced7c7cbbf891ull, 0x176685666671cce3ull,
		0xa6dd53dddd7ba78eull, 0xb8175c1717af2e4bull, 0x0247014747458e46ull, 0x849e429e9e1a21dcull,
		0x1eca0fcacad489c5ull, 0x752db42d2d585a99ull, 0x91bfc6bfbf2e6379ull, 0x38071c07073f0e1bull,
		0x01ad8eadadac4723ull, 0xea5a755a5ab0b42full, 0x6c83368383ef1bb5ull, 0x8533cc3333b666ffull,
		0x3f639163635cc6f2ull, 0x100208020212040aull, 0x39aa92aaaa934938ull, 0xaf71d97171dee2a8ull,
		0x0ec807c8c8c68dcfull, 0xc819641919d1327dull, 0x72493949493b9270ull, 0x86d943d9d95faf9aull,
		0xc3f2eff2f231f91dull, 0x4be3abe3e3a8db48ull, 0xe25b715b5bb9b62aull, 0x34881a8888bc0d92ull,
		0xa49a529a9a3e29c8ull, 0x2d269826260b4cbeull, 0x8d32c83232bf64faull, 0xe9b0fab0b0597d4aull,
		0x1be983e9e9f2cf6aull, 0x780f3c0f0f771e33ull, 0xe6d573d5d533b7a6ull, 0x74803a8080f41dbaull,
		0x99bec2bebe27617cull, 0x26cd13cdcdeb87deull, 0xbd34d034348968e4ull, 0x7a483d4848329075ull,
		0xabffdbffff54e324ull, 0xf77af57a7a8df48full, 0xf4907a9090643deaull, 0xc25f615f5f9dbe3eull,
		0x1d208020203d40a0ull, 0x6768bd68680fd0d5ull, 0xd01a681a1aca3472ull, 0x19ae82aeaeb7412cull,
		0xc9b4eab4b47d755eull, 0x9a544d5454cea819ull, 0xec937693937f3be5ull, 0x0d228822222f44aaull,
		0x07648d646463c8e9ull, 0xdbf1e3f1f12aff12ull, 0xbf73d17373cce6a2ull, 0x901248121282245aull,
		0x3a401d40407a805dull, 0x4008200808481028ull, 0x56c32bc3c3959be8ull, 0x33ec97ececdfc57bull,
		0x96db4bdbdb4dab90ull, 0x61a1bea1a1c05f1full, 0x1c8d0e8d8d910783ull, 0xf53df43d3dc87ac9ull,
		0xcc976697975b33f1ull, 0x0000000000000000ull, 0x36cf1bcfcff983d4ull, 0x452bac2b2b6e5687ull,
		0x9776c57676e1ecb3ull, 0x6482328282e619b0ull, 0xfed67fd6d628b1a9ull, 0xd81b6c1b1bc33677ull,
		0xc1b5eeb5b574775bull, 0x11af86afafbe4329ull, 0x776ab56a6a1dd4dfull, 0xba505d5050eaa00dull,
		0x1245094545578a4cull, 0xcbf3ebf3f338fb18ull, 0x9d30c03030ad60f0ull, 0x2bef9befefc4c374ull,
		0xe53ffc3f3fda7ec3ull, 0x9255495555c7aa1cull, 0x79a2b2a2a2db5910ull, 0x03ea8feaeae9c965ull,
		0x0f658965656acaecull, 0xb9bad2baba036968ull, 0x652fbc2f2f4a5e93ull, 0x4ec027c0c08e9de7ull,
		0xbede5fdede60a181ull, 0xe01c701c1cfc386cull, 0xbbfdd3fdfd46e72eull, 0x524d294d4d1f9a64ull,
		0xe4927292927639e0ull, 0x8f75c97575faeabcull, 0x3006180606360c1eull, 0x248a128a8aae0998ull,
		0xf9b2f2b2b24b7940ull, 0x63e6bfe6e685d159ull, 0x700e380e0e7e1c36ull, 0xf81f7c1f1fe73e63ull,
		0x376295626255c4f7ull, 0xeed477d4d43ab5a3ull, 0x29a89aa8a8814d32ull, 0xc4966296965231f4ull,
		0x9bf9c3f9f962ef3aull, 0x66c533c5c5a397f6ull, 0x3525942525104ab1ull, 0xf259795959abb220ull,
		0x54842a8484d015aeull, 0xb772d57272c5e4a7ull, 0xd539e43939ec72ddull, 0x5a4c2d4c4c169861ull,
		0xca5e655e5e94bc3bull, 0xe778fd78789ff085ull, 0xdd38e03838e570d8ull, 0x148c0a8c8c980586ull,
		0xc6d163d1d117bfb2ull, 0x41a5aea5a5e4570bull, 0x43e2afe2e2a1d94dull, 0x2f619961614ec2f8ull,
		0xf1b3f6b3b3427b45ull, 0x15218421213442a5ull, 0x949c4a9c9c0825d6ull, 0xf01e781e1eee3c66ull,
		0x2243114343618652ull, 0x76c73bc7c7b193fcull, 0xb3fcd7fcfc4fe52bull, 0x2004100404240814ull,
		0xb251595151e3a208ull, 0xbc995e9999252fc7ull, 0x4f6da96d6d22dac4ull, 0x680d340d0d651a39ull,
		0x83facffafa79e935ull, 0xb6df5bdfdf69a384ull, 0xd77ee57e7ea9fc9bull, 0x3d249024241948b4ull,
		0xc53bec3b3bfe76d7ull, 0x31ab96abab9a4b3dull, 0x3ece1fcecef081d1ull, 0x8811441111992255ull,
		0x0c8f068f8f830389ull, 0x4a4e254e4e049c6bull, 0xd1b7e6b7b7667351ull, 0x0beb8bebebe0cb60ull,
		0xfd3cf03c3cc178ccull, 0x7c813e8181fd1fbfull, 0xd4946a94944035feull, 0xebf7fbf7f71cf30cull,
		0xa1b9deb9b9186f67ull, 0x98134c13138b265full, 0x7d2cb02c2c51589cull, 0xd6d36bd3d305bbb8ull,
		0x6be7bbe7e78cd35cull, 0x576ea56e6e39dccbull, 0x6ec437c4c4aa95f3ull, 0x18030c03031b060full,
		0x8a56455656dcac13ull, 0x1a440d44445e8849ull, 0xdf7fe17f7fa0fe9eull, 0x21a99ea9a9884f37ull,
		0x4d2aa82a2a675482ull, 0xb1bbd6bbbb0a6b6dull, 0x46c123c1c1879fe2ull, 0xa253515353f1a602ull,
		0xaedc57dcdc72a58bull, 0x580b2c0b0b531627ull, 0x9c9d4e9d9d0127d3ull, 0x476cad6c6c2bd8c1ull,
		0x9531c43131a462f5ull, 0x8774cd7474f3e8b9ull, 0xe3f6fff6f615f109ull, 0x0a460546464c8c43ull,
		0x09ac8aacaca54526ull, 0x3c891e8989b50f97ull, 0xa014501414b42844ull, 0x5be1a3e1e1badf42ull,
		0xb016581616a62c4eull, 0xcd3ae83a3af774d2ull, 0x6f69b9696906d2d0ull, 0x480924090941122dull,
		0xa770dd7070d7e0adull, 0xd9b6e2b6b66f7154ull, 0xced067d0d01ebdb7ull, 0x3bed93ededd6c77eull,
		0x2ecc17cccce285dbull, 0x2a42154242688457ull, 0xb4985a98982c2dc2ull, 0x49a4aaa4a4ed550eull,
		0x5d28a02828755088ull, 0xda5c6d5c5c86b831ull, 0x93f8c7f8f86bed3full, 0x4486228686c211a4ull
	},
	{
		0x18601818d83078c0ull, 0x238c23232646af05ull, 0xc63fc6c6b891f97eull, 0xe887e8e8fbcd6f13ull,
		0x87268787cb13a14cull, 0xb8dab8b8116d62a9ull, 0x0104010109020508ull, 0x4f214f4f0d9e6e42ull,
		0x36d836369b6ceeadull, 0xa6a2a6a6ff510459ull, 0xd26fd2d20cb9bddeull, 0xf5f3f5f50ef706fbull,
		0x79f9797996f280efull, 0x6fa16f6f30dece5full, 0x917e91916d3feffcull, 0x52555252f8a407aaull,
		0x609d606047c0fd27ull, 0xbccabcbc35657689ull, 0x9b569b9b372bcdacull, 0x8e028e8e8a018c04ull,
		0xa3b6a3a3d25b1571ull, 0x0c300c0c6c183c60ull, 0x7bf17b7b84f68affull, 0x35d43535806ae1b5ull,
		0x1d741d1df53a69e8ull, 0xe0a7e0e0b3dd4753ull, 0xd77bd7d721b3acf6ull, 0xc22fc2c29c99ed5eull,
		0x2eb82e2e435c966dull, 0x4b314b4b29967a62ull, 0xfedffefe5de121a3ull, 0x57415757d5ae1682ull,
		0x15541515bd2a41a8ull, 0x77c17777e8eeb69full, 0x37dc3737926eeba5ull, 0xe5b3e5e59ed7567bull,
		0x9f469f9f1323d98cull, 0xf0e7f0f023fd17d3ull, 0x4a354a4a20947f6aull, 0xda4fdada44a9959eull,
		0x587d5858a2b025faull, 0xc903c9c9cf8fca06ull, 0x29a429297c528d55ull, 0x0a280a0a5a142250ull,
		0xb1feb1b1507f4fe1ull, 0xa0baa0a0c95d1a69ull, 0x6bb16b6b14d6da7full, 0x852e8585d917ab5cull,
		0xbdcebdbd3c677381ull, 0x5d695d5d8fba34d2ull, 0x1040101090205080ull, 0xf4f7f4f407f503f3ull,
		0xcb0bcbcbdd8bc016ull, 0x3ef83e3ed37cc6edull, 0x051405052d0a1128ull, 0x6781676778cee61full,
		0xe4b7e4e497d55373ull, 0x279c2727024ebb25ull, 0x4119414173825832ull, 0x8b168b8ba70b9d2cull,
		0xa7a6a7a7f6530151ull, 0x7de97d7db2fa94cfull, 0x956e95954937fbdcull, 0xd847d8d856ad9f8eull,
		0xfbcbfbfb70eb308bull, 0xee9feeeecdc17123ull, 0x7ced7c7cbbf891c7ull, 0x6685666671cce317ull,
		0xdd53dddd7ba78ea6ull, 0x175c1717af2e4bb8ull, 0x47014747458e4602ull, 0x9e429e9e1a21dc84ull,
		0xca0fcacad489c51eull, 0x2db42d2d585a9975ull, 0xbfc6bfbf2e637991ull, 0x071c07073f0e1b38ull,
		0xad8eadadac472301ull, 0x5a755a5ab0b42feaull, 0x83368383ef1bb56cull, 0x33cc3333b666ff85ull,
		0x639163635cc6f23full, 0x0208020212040a10ull, 0xaa92aaaa93493839ull, 0x71d97171dee2a8afull,
		0xc807c8c8c68dcf0eull, 0x19641919d1327dc8ull, 0x493949493b927072ull, 0xd943d9d95faf9a86ull,
		0xf2eff2f231f91dc3ull, 0xe3abe3e3a8db484bull, 0x5b715b5bb9b62ae2ull, 0x881a8888bc0d9234ull,
		0x9a529a9a3e29c8a4ull, 0x269826260b4cbe2dull, 0x32c83232bf64fa8dull, 0xb0fab0b0597d4ae9ull,
		0xe983e9e9f2cf6a1bull, 0x0f3c0f0f771e3378ull, 0xd573d5d533b7a6e6ull, 0x803a8080f41dba74ull,
		0xbec2bebe27617c99ull, 0xcd13cdcdeb87de26ull, 0x34d034348968e4bdull, 0x483d48483290757aull,
		0xffdbffff54e324abull, 0x7af57a7a8df48ff7ull, 0x907a9090643deaf4ull, 0x5f615f5f9dbe3ec2ull,
		0x208020203d40a01dull, 0x68bd68680fd0d567ull, 0x1a681a1aca3472d0ull, 0xae82aeaeb7412c19ull,
		0xb4eab4b47d755ec9ull, 0x544d5454cea8199aull, 0x937693937f3be5ecull, 0x228822222f44aa0dull,
		0x648d646463c8e907ull, 0xf1e3f1f12aff12dbull, 0x73d17373cce6a2bfull, 0x1248121282245a90ull,
		0x401d40407a805d3aull, 0x0820080848102840ull, 0xc32bc3c3959be856ull, 0xec97ececdfc57b33ull,
		0xdb4bdbdb4dab9096ull, 0xa1bea1a1c05f1f61ull, 0x8d0e8d8d9107831cull, 0x3df43d3dc87ac9f5ull,
		0x976697975b33f1ccull, 0x0000000000000000ull, 0xcf1bcfcff983d436ull, 0x2bac2b2b6e568745ull,
		0x76c57676e1ecb397ull, 0x82328282e619b064ull, 0xd67fd6d628b1a9feull, 0x1b6c1b1bc33677d8ull,
		0xb5eeb5b574775bc1ull, 0xaf86afafbe432911ull, 0x6ab56a6a1dd4df77ull, 0x505d5050eaa00dbaull,
		0x45094545578a4c12ull, 0xf3ebf3f338fb18cbull, 0x30c03030ad60f09dull, 0xef9befefc4c3742bull,
		0x3ffc3f3fda7ec3e5ull, 0x55495555c7aa1c92ull, 0xa2b2a2a2db591079ull, 0xea8feaeae9c96503ull,
		0x658965656acaec0full, 0xbad2baba036968b9ull, 0x2fbc2f2f4a5e9365ull, 0xc027c0c08e9de74eull,
		0xde5fdede60a181beull, 0x1c701c1cfc386ce0ull, 0xfdd3fdfd46e72ebbull, 0x4d294d4d1f9a6452ull,
		0x927292927639e0e4ull, 0x75c97575faeabc8full, 0x06180606360c1e30ull, 0x8a128a8aae099824ull,
		0xb2f2b2b24b7940f9ull, 0xe6bfe6e685d15963ull, 0x0e380e0e7e1c3670ull, 0x1f7c1f1fe73e63f8ull,
		0x6295626255c4f737ull, 0xd477d4d43ab5a3eeull, 0xa89aa8a8814d3229ull, 0x966296965231f4c4ull,
		0xf9c3f9f962ef3a9bull, 0xc533c5c5a397f666ull, 0x25942525104ab135ull, 0x59795959abb220f2ull,
		0x842a8484d015ae54ull, 0x72d57272c5e4a7b7ull, 0x39e43939ec72ddd5ull, 0x4c2d4c4c1698615aull,
		0x5e655e5e94bc3bcaull, 0x78fd78789ff085e7ull, 0x38e03838e570d8ddull, 0x8c0a8c8c98058614ull,
		0xd163d1d117bfb2c6ull, 0xa5aea5a5e4570b41ull, 0xe2afe2e2a1d94d43ull, 0x619961614ec2f82full,
		0xb3f6b3b3427b45f1ull, 0x218421213442a515ull, 0x9c4a9c9c0825d694ull, 0x1e781e1eee3c66f0ull,
		0x4311434361865222ull, 0xc73bc7c7b193fc76ull, 0xfcd7fcfc4fe52bb3ull, 0x0410040424081420ull,
		0x51595151e3a208b2ull, 0x995e9999252fc7bcull, 0x6da96d6d22dac44full, 0x0d340d0d651a3968ull,
		0xfacffafa79e93583ull, 0xdf5bdfdf69a384b6ull, 0x7ee57e7ea9fc9bd7ull, 0x249024241948b43dull,
		0x3bec3b3bfe76d7c5ull, 0xab96abab9a4b3d31ull, 0xce1fcecef081d13eull, 0x1144111199225588ull,
		0x8f068f8f8303890cull, 0x4e254e4e049c6b4aull, 0xb7e6b7b7667351d1ull, 0xeb8bebebe0cb600bull,
		0x3cf03c3cc178ccfdull, 0x813e8181fd1fbf7cull, 0x946a94944035fed4ull, 0xf7fbf7f71cf30cebull,
		0xb9deb9b9186f67a1ull, 0x134c13138b265f98ull, 0x2cb02c2c51589c7dull, 0xd36bd3d305bbb8d6ull,
		0xe7bbe7e78cd35c6bull, 0x6ea56e6e39dccb57ull, 0xc437c4c4aa95f36eull, 0x030c03031b060f18ull,
		0x56455656dcac138aull, 0x440d44445e88491aull, 0x7fe17f7fa0fe9edfull, 0xa99ea9a9884f3721ull,
		0x2aa82a2a6754824dull, 0xbbd6bbbb0a6b6db1ull, 0xc123c1c1879fe246ull, 0x53515353f1a602a2ull,
		0xdc57dcdc72a58baeull, 0x0b2c0b0b53162758ull, 0x9d4e9d9d0127d39cull, 0x6cad6c6c2bd8c147ull,
		0x31c43131a462f595ull, 0x74cd7474f3e8b987ull, 0xf6fff6f615f109e3ull, 0x460546464c8c430aull,
		0xac8aacaca5452609ull, 0x891e8989b50f973cull, 0x14501414b42844a0ull, 0xe1a3e1e1badf425bull,
		0x16581616a62c4eb0ull, 0x3ae83a3af774d2cdull, 0x69b9696906d2d06full, 0x0924090941122d48ull,
		0x70dd7070d7e0ada7ull, 0xb6e2b6b66f7154d9ull, 0xd067d0d01ebdb7ceull, 0xed93ededd6c77e3bull,
		0xcc17cccce285db2eull, 0x421542426884572aull, 0x985a98982c2dc2b4ull, 0xa4aaa4a4ed550e49ull,
		0x28a028287550885dull, 0x5c6d5c5c86b831daull, 0xf8c7f8f86bed3f93ull, 0x86228686c211a444ull
	},
	{
		0x601818d83078c018ull, 0x8c23232646af0523ull, 0x3fc6c6b891f97ec6ull, 0x87e8e8fbcd6f13e8ull,
		0x268787cb13a14c87ull, 0xdab8b8116d62a9b8ull, 0x0401010902050801ull, 0x214f4f0d9e6e424full,
		0xd836369b6ceead36ull, 0xa2a6a6ff510459a6ull, 0x6fd2d20cb9bdded2ull, 0xf3f5f50ef706fbf5ull,
		0xf9797996f280ef79ull, 0xa16f6f30dece5f6full, 0x7e91916d3feffc91ull, 0x555252f8a407aa52ull,
		0x9d606047c0fd2760ull, 0xcabcbc35657689bcull, 0x569b9b372bcdac9bull, 0x028e8e8a018c048eull,
		0xb6a3a3d25b1571a3ull, 0x300c0c6c183c600cull, 0xf17b7b84f68aff7bull, 0xd43535806ae1b535ull,
		0x741d1df53a69e81dull, 0xa7e0e0b3dd4753e0ull, 0x7bd7d721b3acf6d7ull, 0x2fc2c29c99ed5ec2ull,
		0xb82e2e435c966d2eull, 0x314b4b29967a624bull, 0xdffefe5de121a3feull, 0x415757d5ae168257ull,
		0x541515bd2a41a815ull, 0xc17777e8eeb69f77ull, 0xdc3737926eeba537ull, 0xb3e5e59ed7567be5ull,
		0x469f9f1323d98c9full, 0xe7f0f023fd17d3f0ull, 0x354a4a20947f6a4aull, 0x4fdada44a9959edaull,
		0x7d5858a2b025fa58ull, 0x03c9c9cf8fca06c9ull, 0xa429297c528d5529ull, 0x280a0a5a1422500aull,
		0xfeb1b1507f4fe1b1ull, 0xbaa0a0c95d1a69a0ull, 0xb16b6b14d6da7f6bull, 0x2e8585d917ab5c85ull,
		0xcebdbd3c677381bdull, 0x695d5d8fba34d25dull, 0x4010109020508010ull, 0xf7f4f407f503f3f4ull,
		0x0bcbcbdd8bc016cbull, 0xf83e3ed37cc6ed3eull, 0x1405052d0a112805ull, 0x81676778cee61f67ull,
		0xb7e4e497d55373e4ull, 0x9c2727024ebb2527ull, 0x1941417382583241ull, 0x168b8ba70b9d2c8bull,
		0xa6a7a7f6530151a7ull, 0xe97d7db2fa94cf7dull, 0x6e95954937fbdc95ull, 0x47d8d856ad9f8ed8ull,
		0xcbfbfb70eb308bfbull, 0x9feeeecdc17123eeull, 0xed7c7cbbf891c77cull, 0x85666671cce31766ull,
		0x53dddd7ba78ea6ddull, 0x5c1717af2e4bb817ull, 0x014747458e460247ull, 0x429e9e1a21dc849eull,
		0x0fcacad489c51ecaull, 0xb42d2d585a99752dull, 0xc6bfbf2e637991bfull, 0x1c07073f0e1b3807ull,
		0x8eadadac472301adull, 0x755a5ab0b42fea5aull, 0x368383ef1bb56c83ull, 0xcc3333b666ff8533ull,
		0x9163635cc6f23f63ull, 0x08020212040a1002ull, 0x92aaaa93493839aaull, 0xd97171dee2a8af71ull,
		0x07c8c8c68dcf0ec8ull, 0x641919d1327dc819ull, 0x3949493b92707249ull, 0x43d9d95faf9a86d9ull,
		0xeff2f231f91dc3f2ull, 0xabe3e3a8db484be3ull, 0x715b5bb9b62ae25bull, 0x1a8888bc0d923488ull,
		0x529a9a3e29c8a49aull, 0x9826260b4cbe2d26ull, 0xc83232bf64fa8d32ull, 0xfab0b0597d4ae9b0ull,
		0x83e9e9f2cf6a1be9ull, 0x3c0f0f771e33780full, 0x73d5d533b7a6e6d5ull, 0x3a8080f41dba7480ull,
		0xc2bebe27617c99beull, 0x13cdcdeb87de26cdull, 0xd034348968e4bd34ull, 0x3d48483290757a48ull,
		0xdbffff54e324abffull, 0xf57a7a8df48ff77aull, 0x7a9090643deaf490ull, 0x615f5f9dbe3ec25full,
		0x8020203d40a01d20ull, 0xbd68680fd0d56768ull, 0x681a1aca3472d01aull, 0x82aeaeb7412c19aeull,
		0xeab4b47d755ec9b4ull, 0x4d5454cea8199a54ull, 0x7693937f3be5ec93ull, 0x8822222f44aa0d22ull,
		0x8d646463c8e90764ull, 0xe3f1f12aff12dbf1ull, 0xd17373cce6a2bf73ull, 0x48121282245a9012ull,
		0x1d40407a805d3a40ull, 0x2008084810284008ull, 0x2bc3c3959be856c3ull, 0x97ececdfc57b33ecull,
		0x4bdbdb4dab9096dbull, 0xbea1a1c05f1f61a1ull, 0x0e8d8d9107831c8dull, 0xf43d3dc87ac9f53dull,
		0x6697975b33f1cc97ull, 0x0000000000000000ull, 0x1bcfcff983d436cfull, 0xac2b2b6e5687452bull,
		0xc57676e1ecb39776ull, 0x328282e619b06482ull, 0x7fd6d628b1a9fed6ull, 0x6c1b1bc33677d81bull,
		0xeeb5b574775bc1b5ull, 0x86afafbe432911afull, 0xb56a6a1dd4df776aull, 0x5d5050eaa00dba50ull,
		0x094545578a4c1245ull, 0xebf3f338fb18cbf3ull, 0xc03030ad60f09d30ull, 0x9befefc4c3742befull,
		0xfc3f3fda7ec3e53full, 0x495555c7aa1c9255ull, 0xb2a2a2db591079a2ull, 0x8feaeae9c96503eaull,
		0x8965656acaec0f65ull, 0xd2baba036968b9baull, 0xbc2f2f4a5e93652full, 0x27c0c08e9de74ec0ull,
		0x5fdede60a181bedeull, 0x701c1cfc386ce01cull, 0xd3fdfd46e72ebbfdull, 0x294d4d1f9a64524dull,
		0x7292927639e0e492ull, 0xc97575faeabc8f75ull, 0x180606360c1e3006ull, 0x128a8aae0998248aull,
		0xf2b2b24b7940f9b2ull, 0xbfe6e685d15963e6ull, 0x380e0e7e1c36700eull, 0x7c1f1fe73e63f81full,
		0x95626255c4f73762ull, 0x77d4d43ab5a3eed4ull, 0x9aa8a8814d3229a8ull, 0x6296965231f4c496ull,
		0xc3f9f962ef3a9bf9ull, 0x33c5c5a397f666c5ull, 0x942525104ab13525ull, 0x795959abb220f259ull,
		0x2a8484d015ae5484ull, 0xd57272c5e4a7b772ull, 0xe43939ec72ddd539ull, 0x2d4c4c1698615a4cull,
		0x655e5e94bc3bca5eull, 0xfd78789ff085e778ull, 0xe03838e570d8dd38ull, 0x0a8c8c980586148cull,
		0x63d1d117bfb2c6d1ull, 0xaea5a5e4570b41a5ull, 0xafe2e2a1d94d43e2ull, 0x9961614ec2f82f61ull,
		0xf6b3b3427b45f1b3ull, 0x8421213442a51521ull, 0x4a9c9c0825d6949cull, 0x781e1eee3c66f01eull,
		0x1143436186522243ull, 0x3bc7c7b193fc76c7ull, 0xd7fcfc4fe52bb3fcull, 0x1004042408142004ull,
		0x595151e3a208b251ull, 0x5e9999252fc7bc99ull, 0xa96d6d22dac44f6dull, 0x340d0d651a39680dull,
		0xcffafa79e93583faull, 0x5bdfdf69a384b6dfull, 0xe57e7ea9fc9bd77eull, 0x9024241948b43d24ull,
		0xec3b3bfe76d7c53bull, 0x96abab9a4b3d31abull, 0x1fcecef081d13eceull, 0x4411119922558811ull,
		0x068f8f8303890c8full, 0x254e4e049c6b4a4eull, 0xe6b7b7667351d1b7ull, 0x8bebebe0cb600bebull,
		0xf03c3cc178ccfd3cull, 0x3e8181fd1fbf7c81ull, 0x6a94944035fed494ull, 0xfbf7f71cf30cebf7ull,
		0xdeb9b9186f67a1b9ull, 0x4c13138b265f9813ull, 0xb02c2c51589c7d2cull, 0x6bd3d305bbb8d6d3ull,
		0xbbe7e78cd35c6be7ull, 0xa56e6e39dccb576eull, 0x37c4c4aa95f36ec4ull, 0x0c03031b060f1803ull,
		0x455656dcac138a56ull, 0x0d44445e88491a44ull, 0xe17f7fa0fe9edf7full, 0x9ea9a9884f3721a9ull,
		0xa82a2a6754824d2aull, 0xd6bbbb0a6b6db1bbull, 0x23c1c1879fe246c1ull, 0x515353f1a602a253ull,
		0x57dcdc72a58baedcull, 0x2c0b0b531627580bull, 0x4e9d9d0127d39c9dull, 0xad6c6c2bd8c1476cull,
		0xc43131a462f59531ull, 0xcd7474f3e8b98774ull, 0xfff6f615f109e3f6ull, 0x0546464c8c430a46ull,
		0x8aacaca5452609acull, 0x1e8989b50f973c89ull, 0x501414b42844a014ull, 0xa3e1e1badf425be1ull,
		0x581616a62c4eb016ull, 0xe83a3af774d2cd3aull, 0xb9696906d2d06f69ull, 0x24090941122d4809ull,
		0xdd7070d7e0ada770ull, 0xe2b6b66f7154d9b6ull, 0x67d0d01ebdb7ced0ull, 0x93ededd6c77e3bedull,
		0x17cccce285db2eccull, 0x1542426884572a42ull, 0x5a98982c2dc2b498ull, 0xaaa4a4ed550e49a4ull,
		0xa028287550885d28ull, 0x6d5c5c86b831da5cull, 0xc7f8f86bed3f93f8ull, 0x228686c211a44486ull
	},
	{
		0x1818d83078c01860ull, 0x23232646af05238cull, 0xc6c6b891f97ec63full, 0xe8e8fbcd6f13e887ull,
		0x8787cb13a14c8726ull, 0xb8b8116d62a9b8daull, 0x0101090205080104ull, 0x4f4f0d9e6e424f21ull,
		0x36369b6ceead36d8ull, 0xa6a6ff510459a6a2ull, 0xd2d20cb9bdded26full, 0xf5f50ef706fbf5f3ull,
		0x797996f280ef79f9ull, 0x6f6f30dece5f6fa1ull, 0x91916d3feffc917eull, 0x5252f8a407aa5255ull,
		0x606047c0fd27609dull, 0xbcbc35657689bccaull, 0x9b9b372bcdac9b56ull, 0x8e8e8a018c048e02ull,
		0xa3a3d25b1571a3b6ull, 0x0c0c6c183c600c30ull, 0x7b7b84f68aff7bf1ull, 0x3535806ae1b535d4ull,
		0x1d1df53a69e81d74ull, 0xe0e0b3dd4753e0a7ull, 0xd7d721b3acf6d77bull, 0xc2c29c99ed5ec22full,
		0x2e2e435c966d2eb8ull, 0x4b4b29967a624b31ull, 0xfefe5de121a3fedfull, 0x5757d5ae16825741ull,
		0x1515bd2a41a81554ull, 0x7777e8eeb69f77c1ull, 0x3737926eeba537dcull, 0xe5e59ed7567be5b3ull,
		0x9f9f1323d98c9f46ull, 0xf0f023fd17d3f0e7ull, 0x4a4a20947f6a4a35ull, 0xdada44a9959eda4full,
		0x5858a2b025fa587dull, 0xc9c9cf8fca06c903ull, 0x29297c528d5529a4ull, 0x0a0a5a1422500a28ull,
		0xb1b1507f4fe1b1feull, 0xa0a0c95d1a69a0baull, 0x6b6b14d6da7f6bb1ull, 0x8585d917ab5c852eull,
		0xbdbd3c677381bdceull, 0x5d5d8fba34d25d69ull, 0x1010902050801040ull, 0xf4f407f503f3f4f7ull,
		0xcbcbdd8bc016cb0bull, 0x3e3ed37cc6ed3ef8ull, 0x05052d0a11280514ull, 0x676778cee61f6781ull,
		0xe4e497d55373e4b7ull, 0x2727024ebb25279cull, 0x4141738258324119ull, 0x8b8ba70b9d2c8b16ull,
		0xa7a7f6530151a7a6ull, 0x7d7db2fa94cf7de9ull, 0x95954937fbdc956eull, 0xd8d856ad9f8ed847ull,
		0xfbfb70eb308bfbcbull, 0xeeeecdc17123ee9full, 0x7c7cbbf891c77cedull, 0x666671cce3176685ull,
		0xdddd7ba78ea6dd53ull, 0x1717af2e4bb8175cull, 0x4747458e46024701ull, 0x9e9e1a21dc849e42ull,
		0xcacad489c51eca0full, 0x2d2d585a99752db4ull, 0xbfbf2e637991bfc6ull, 0x07073f0e1b38071cull,
		0xadadac472301ad8eull, 0x5a5ab0b42fea5a75ull, 0x8383ef1bb56c8336ull, 0x3333b666ff8533ccull,
		0x63635cc6f23f6391ull, 0x020212040a100208ull, 0xaaaa93493839aa92ull, 0x7171dee2a8af71d9ull,
		0xc8c8c68dcf0ec807ull, 0x1919d1327dc81964ull, 0x49493b9270724939ull, 0xd9d95faf9a86d943ull,
		0xf2f231f91dc3f2efull, 0xe3e3a8db484be3abull, 0x5b5bb9b62ae25b71ull, 0x8888bc0d9234881aull,
		0x9a9a3e29c8a49a52ull, 0x26260b4cbe2d2698ull, 0x3232bf64fa8d32c8ull, 0xb0b0597d4ae9b0faull,
		0xe9e9f2cf6a1be983ull, 0x0f0f771e33780f3cull, 0xd5d533b7a6e6d573ull, 0x8080f41dba74803aull,
		0xbebe27617c99bec2ull, 0xcdcdeb87de26cd13ull, 0x34348968e4bd34d0ull, 0x48483290757a483dull,
		0xffff54e324abffdbull, 0x7a7a8df48ff77af5ull, 0x9090643deaf4907aull, 0x5f5f9dbe3ec25f61ull,
		0x20203d40a01d2080ull, 0x68680fd0d56768bdull, 0x1a1aca3472d01a68ull, 0xaeaeb7412c19ae82ull,
		0xb4b47d755ec9b4eaull, 0x5454cea8199a544dull, 0x93937f3be5ec9376ull, 0x22222f44aa0d2288ull,
		0x646463c8e907648dull, 0xf1f12aff12dbf1e3ull, 0x7373cce6a2bf73d1ull, 0x121282245a901248ull,
		0x40407a805d3a401dull, 0x0808481028400820ull, 0xc3c3959be856c32bull, 0xececdfc57b33ec97ull,
		0xdbdb4dab9096db4bull, 0xa1a1c05f1f61a1beull, 0x8d8d9107831c8d0eull, 0x3d3dc87ac9f53df4ull,
		0x97975b33f1cc9766ull, 0x0000000000000000ull, 0xcfcff983d436cf1bull, 0x2b2b6e5687452bacull,
		0x7676e1ecb39776c5ull, 0x8282e619b0648232ull, 0xd6d628b1a9fed67full, 0x1b1bc33677d81b6cull,
		0xb5b574775bc1b5eeull, 0xafafbe432911af86ull, 0x6a6a1dd4df776ab5ull, 0x5050eaa00dba505dull,
		0x4545578a4c124509ull, 0xf3f338fb18cbf3ebull, 0x3030ad60f09d30c0ull, 0xefefc4c3742bef9bull,
		0x3f3fda7ec3e53ffcull, 0x5555c7aa1c925549ull, 0xa2a2db591079a2b2ull, 0xeaeae9c96503ea8full,
		0x65656acaec0f6589ull, 0xbaba036968b9bad2ull, 0x2f2f4a5e93652fbcull, 0xc0c08e9de74ec027ull,
		0xdede60a181bede5full, 0x1c1cfc386ce01c70ull, 0xfdfd46e72ebbfdd3ull, 0x4d4d1f9a64524d29ull,
		0x92927639e0e49272ull, 0x7575faeabc8f75c9ull, 0x0606360c1e300618ull, 0x8a8aae0998248a12ull,
		0xb2b24b7940f9b2f2ull, 0xe6e685d15963e6bfull, 0x0e0e7e1c36700e38ull, 0x1f1fe73e63f81f7cull,
		0x626255c4f7376295ull, 0xd4d43ab5a3eed477ull, 0xa8a8814d3229a89aull, 0x96965231f4c49662ull,
		0xf9f962ef3a9bf9c3ull, 0xc5c5a397f666c533ull, 0x2525104ab1352594ull, 0x5959abb220f25979ull,
		0x8484d015ae54842aull, 0x7272c5e4a7b772d5ull, 0x3939ec72ddd539e4ull, 0x4c4c1698615a4c2dull,
		0x5e5e94bc3bca5e65ull, 0x78789ff085e778fdull, 0x3838e570d8dd38e0ull, 0x8c8c980586148c0aull,
		0xd1d117bfb2c6d163ull, 0xa5a5e4570b41a5aeull, 0xe2e2a1d94d43e2afull, 0x61614ec2f82f6199ull,
		0xb3b3427b45f1b3f6ull, 0x21213442a5152184ull, 0x9c9c0825d6949c4aull, 0x1e1eee3c66f01e78ull,
		0x4343618652224311ull, 0xc7c7b193fc76c73bull, 0xfcfc4fe52bb3fcd7ull, 0x0404240814200410ull,
		0x5151e3a208b25159ull, 0x9999252fc7bc995eull, 0x6d6d22dac44f6da9ull, 0x0d0d651a39680d34ull,
		0xfafa79e93583facfull, 0xdfdf69a384b6df5bull, 0x7e7ea9fc9bd77ee5ull, 0x24241948b43d2490ull,
		0x3b3bfe76d7c53becull, 0xabab9a4b3d31ab96ull, 0xcecef081d13ece1full, 0x1111992255881144ull,
		0x8f8f8303890c8f06ull, 0x4e4e049c6b4a4e25ull, 0xb7b7667351d1b7e6ull, 0xebebe0cb600beb8bull,
		0x3c3cc178ccfd3cf0ull, 0x8181fd1fbf7c813eull, 0x94944035fed4946aull, 0xf7f71cf30cebf7fbull,
		0xb9b9186f67a1b9deull, 0x13138b265f98134cull, 0x2c2c51589c7d2cb0ull, 0xd3d305bbb8d6d36bull,
		0xe7e78cd35c6be7bbull, 0x6e6e39dccb576ea5ull, 0xc4c4aa95f36ec437ull, 0x03031b060f18030cull,
		0x5656dcac138a5645ull, 0x44445e88491a440dull, 0x7f7fa0fe9edf7fe1ull, 0xa9a9884f3721a99eull,
		0x2a2a6754824d2aa8ull, 0xbbbb0a6b6db1bbd6ull, 0xc1c1879fe246c123ull, 0x5353f1a602a25351ull,
		0xdcdc72a58baedc57ull, 0x0b0b531627580b2cull, 0x9d9d0127d39c9d4eull, 0x6c6c2bd8c1476cadull,
		0x3131a462f59531c4ull, 0x7474f3e8b98774cdull, 0xf6f615f109e3f6ffull, 0x46464c8c430a4605ull,
		0xacaca5452609ac8aull, 0x8989b50f973c891eull, 0x1414b42844a01450ull, 0xe1e1badf425be1a3ull,
		0x1616a62c4eb01658ull, 0x3a3af774d2cd3ae8ull, 0x696906d2d06f69b9ull, 0x090941122d480924ull,
		0x7070d7e0ada770ddull, 0xb6b66f7154d9b6e2ull, 0xd0d01ebdb7ced067ull, 0xededd6c77e3bed93ull,
		0xcccce285db2ecc17ull, 0x42426884572a4215ull, 0x98982c2dc2b4985aull, 0xa4a4ed550e49a4aaull,
		0x28287550885d28a0ull, 0x5c5c86b831da5c6dull, 0xf8f86bed3f93f8c7ull, 0x8686c211a4448622ull
	},
	{
		0x18d83078c0186018ull, 0x232646af05238c23ull, 0xc6b891f97ec63fc6ull, 0xe8fbcd6f13e887e8ull,
		0x87cb13a14c872687ull, 0xb8116d62a9b8dab8ull, 0x0109020508010401ull, 0x4f0d9e6e424f214full,
		0x369b6ceead36d836ull, 0xa6ff510459a6a2a6ull, 0xd20cb9bdded26fd2ull, 0xf50ef706fbf5f3f5ull,
		0x7996f280ef79f979ull, 0x6f30dece5f6fa16full, 0x916d3feffc917e91ull, 0x52f8a407aa525552ull,
		0x6047c0fd27609d60ull, 0xbc35657689bccabcull, 0x9b372bcdac9b569bull, 0x8e8a018c048e028eull,
		0xa3d25b1571a3b6a3ull, 0x0c6c183c600c300cull, 0x7b84f68aff7bf17bull, 0x35806ae1b535d435ull,
		0x1df53a69e81d741dull, 0xe0b3dd4753e0a7e0ull, 0xd721b3acf6d77bd7ull, 0xc29c99ed5ec22fc2ull,
		0x2e435c966d2eb82eull, 0x4b29967a624b314bull, 0xfe5de121a3fedffeull, 0x57d5ae1682574157ull,
		0x15bd2a41a8155415ull, 0x77e8eeb69f77c177ull, 0x37926eeba537dc37ull, 0xe59ed7567be5b3e5ull,
		0x9f1323d98c9f469full, 0xf023fd17d3f0e7f0ull, 0x4a20947f6a4a354aull, 0xda44a9959eda4fdaull,
		0x58a2b025fa587d58ull, 0xc9cf8fca06c903c9ull, 0x297c528d5529a429ull, 0x0a5a1422500a280aull,
		0xb1507f4fe1b1feb1ull, 0xa0c95d1a69a0baa0ull, 0x6b14d6da7f6bb16bull, 0x85d917ab5c852e85ull,
		0xbd3c677381bdcebdull, 0x5d8fba34d25d695dull, 0x1090205080104010ull, 0xf407f503f3f4f7f4ull,
		0xcbdd8bc016cb0bcbull, 0x3ed37cc6ed3ef83eull, 0x052d0a1128051405ull, 0x6778cee61f678167ull,
		0xe497d55373e4b7e4ull, 0x27024ebb25279c27ull, 0x4173825832411941ull, 0x8ba70b9d2c8b168bull,
		0xa7f6530151a7a6a7ull, 0x7db2fa94cf7de97dull, 0x954937fbdc956e95ull, 0xd856ad9f8ed847d8ull,
		0xfb70eb308bfbcbfbull, 0xeecdc17123ee9feeull, 0x7cbbf891c77ced7cull, 0x6671cce317668566ull,
		0xdd7ba78ea6dd53ddull, 0x17af2e4bb8175c17ull, 0x47458e4602470147ull, 0x9e1a21dc849e429eull,
		0xcad489c51eca0fcaull, 0x2d585a99752db42dull, 0xbf2e637991bfc6bfull, 0x073f0e1b38071c07ull,
		0xadac472301ad8eadull, 0x5ab0b42fea5a755aull, 0x83ef1bb56c833683ull, 0x33b666ff8533cc33ull,
		0x635cc6f23f639163ull, 0x0212040a10020802ull, 0xaa93493839aa92aaull, 0x71dee2a8af71d971ull,
		0xc8c68dcf0ec807c8ull, 0x19d1327dc8196419ull, 0x493b927072493949ull, 0xd95faf9a86d943d9ull,
		0xf231f91dc3f2eff2ull, 0xe3a8db484be3abe3ull, 0x5bb9b62ae25b715bull, 0x88bc0d9234881a88ull,
		0x9a3e29c8a49a529aull, 0x260b4cbe2d269826ull, 0x32bf64fa8d32c832ull, 0xb0597d4ae9b0fab0ull,
		0xe9f2cf6a1be983e9ull, 0x0f771e33780f3c0full, 0xd533b7a6e6d573d5ull, 0x80f41dba74803a80ull,
		0xbe27617c99bec2beull, 0xcdeb87de26cd13cdull, 0x348968e4bd34d034ull, 0x483290757a483d48ull,
		0xff54e324abffdbffull, 0x7a8df48ff77af57aull, 0x90643deaf4907a90ull, 0x5f9dbe3ec25f615full,
		0x203d40a01d208020ull, 0x680fd0d56768bd68ull, 0x1aca3472d01a681aull, 0xaeb7412c19ae82aeull,
		0xb47d755ec9b4eab4ull, 0x54cea8199a544d54ull, 0x937f3be5ec937693ull, 0x222f44aa0d228822ull,
		0x6463c8e907648d64ull, 0xf12aff12dbf1e3f1ull, 0x73cce6a2bf73d173ull, 0x1282245a90124812ull,
		0x407a805d3a401d40ull, 0x0848102840082008ull, 0xc3959be856c32bc3ull, 0xecdfc57b33ec97ecull,
		0xdb4dab9096db4bdbull, 0xa1c05f1f61a1bea1ull, 0x8d9107831c8d0e8dull, 0x3dc87ac9f53df43dull,
		0x975b33f1cc976697ull, 0x0000000000000000ull, 0xcff983d436cf1bcfull, 0x2b6e5687452bac2bull,
		0x76e1ecb39776c576ull, 0x82e619b064823282ull, 0xd628b1a9fed67fd6ull, 0x1bc33677d81b6c1bull,
		0xb574775bc1b5eeb5ull, 0xafbe432911af86afull, 0x6a1dd4df776ab56aull, 0x50eaa00dba505d50ull,
		0x45578a4c12450945ull, 0xf338fb18cbf3ebf3ull, 0x30ad60f09d30c030ull, 0xefc4c3742bef9befull,
		0x3fda7ec3e53ffc3full, 0x55c7aa1c92554955ull, 0xa2db591079a2b2a2ull, 0xeae9c96503ea8feaull,
		0x656acaec0f658965ull, 0xba036968b9bad2baull, 0x2f4a5e93652fbc2full, 0xc08e9de74ec027c0ull,
		0xde60a181bede5fdeull, 0x1cfc386ce01c701cull, 0xfd46e72ebbfdd3fdull, 0x4d1f9a64524d294dull,
		0x927639e0e4927292ull, 0x75faeabc8f75c975ull, 0x06360c1e30061806ull, 0x8aae0998248a128aull,
		0xb24b7940f9b2f2b2ull, 0xe685d15963e6bfe6ull, 0x0e7e1c36700e380eull, 0x1fe73e63f81f7c1full,
		0x6255c4f737629562ull, 0xd43ab5a3eed477d4ull, 0xa8814d3229a89aa8ull, 0x965231f4c4966296ull,
		0xf962ef3a9bf9c3f9ull, 0xc5a397f666c533c5ull, 0x25104ab135259425ull, 0x59abb220f2597959ull,
		0x84d015ae54842a84ull, 0x72c5e4a7b772d572ull, 0x39ec72ddd539e439ull, 0x4c1698615a4c2d4cull,
		0x5e94bc3bca5e655eull, 0x789ff085e778fd78ull, 0x38e570d8dd38e038ull, 0x8c980586148c0a8cull,
		0xd117bfb2c6d163d1ull, 0xa5e4570b41a5aea5ull, 0xe2a1d94d43e2afe2ull, 0x614ec2f82f619961ull,
		0xb3427b45f1b3f6b3ull, 0x213442a515218421ull, 0x9c0825d6949c4a9cull, 0x1eee3c66f01e781eull,
		0x4361865222431143ull, 0xc7b193fc76c73bc7ull, 0xfc4fe52bb3fcd7fcull, 0x0424081420041004ull,
		0x51e3a208b2515951ull, 0x99252fc7bc995e99ull, 0x6d22dac44f6da96dull, 0x0d651a39680d340dull,
		0xfa79e93583facffaull, 0xdf69a384b6df5bdfull, 0x7ea9fc9bd77ee57eull, 0x241948b43d249024ull,
		0x3bfe76d7c53bec3bull, 0xab9a4b3d31ab96abull, 0xcef081d13ece1fceull, 0x1199225588114411ull,
		0x8f8303890c8f068full, 0x4e049c6b4a4e254eull, 0xb7667351d1b7e6b7ull, 0xebe0cb600beb8bebull,
		0x3cc178ccfd3cf03cull, 0x81fd1fbf7c813e81ull, 0x944035fed4946a94ull, 0xf71cf30cebf7fbf7ull,
		0xb9186f67a1b9deb9ull, 0x138b265f98134c13ull, 0x2c51589c7d2cb02cull, 0xd305bbb8d6d36bd3ull,
		0xe78cd35c6be7bbe7ull, 0x6e39dccb576ea56eull, 0xc4aa95f36ec437c4ull, 0x031b060f18030c03ull,
		0x56dcac138a564556ull, 0x445e88491a440d44ull, 0x7fa0fe9edf7fe17full, 0xa9884f3721a99ea9ull,
		0x2a6754824d2aa82aull, 0xbb0a6b6db1bbd6bbull, 0xc1879fe246c123c1ull, 0x53f1a602a2535153ull,
		0xdc72a58baedc57dcull, 0x0b531627580b2c0bull, 0x9d0127d39c9d4e9dull, 0x6c2bd8c1476cad6cull,
		0x31a462f59531c431ull, 0x74f3e8b98774cd74ull, 0xf615f109e3f6fff6ull, 0x464c8c430a460546ull,
		0xaca5452609ac8aacull, 0x89b50f973c891e89ull, 0x14b42844a0145014ull, 0xe1badf425be1a3e1ull,
		0x16a62c4eb0165816ull, 0x3af774d2cd3ae83aull, 0x6906d2d06f69b969ull, 0x0941122d48092409ull,
		0x70d7e0ada770dd70ull, 0xb66f7154d9b6e2b6ull, 0xd01ebdb7ced067d0ull, 0xedd6c77e3bed93edull,
		0xcce285db2ecc17ccull, 0x426884572a421542ull, 0x982c2dc2b4985a98ull, 0xa4ed550e49a4aaa4ull,
		0x287550885d28a028ull, 0x5c86b831da5c6d5cull, 0xf86bed3f93f8c7f8ull, 0x86c211a444862286ull
	}
};

} // namespace detail

} // namespace digestpp

#endif