/*
This code is written by kerukuro and released into public domain.
*/

#ifndef DIGESTPP_PROVIDERS_KUPYNA_CONSTANTS_HPP
#define DIGESTPP_PROVIDERS_KUPYNA_CONSTANTS_HPP

namespace digestpp
{

namespace detail
{

template<typename V>
struct kupyna_constants
{
	static const uint64_t T[8][256];

};

template<typename V>
const uint64_t kupyna_constants<V>::T[8][256] = {
	{
		0xa832a829d77f9aa8ull, 0x4352432297d41143ull, 0x5f3e5fc2df80615full, 0x061e063014121806ull,
		0x6bda6b7f670cb16bull, 0x75bc758f2356c975ull, 0x6cc16c477519ad6cull, 0x592059f2cb927959ull,
		0x71a871af3b4ad971ull, 0xdf84dfb6f8275bdfull, 0x87a1874c35b22687ull, 0x95fb95dc59cc6e95ull,
		0x174b17b872655c17ull, 0xf017f0d31aeae7f0ull, 0xd89fd88eea3247d8ull, 0x092d0948363f2409ull,
		0x6dc46d4f731ea96dull, 0xf318f3cb10e3ebf3ull, 0x1d691de84e53741dull, 0xcbc0cb16804b0bcbull,
		0xc9cac9068c4503c9ull, 0x4d644d52b3fe294dull, 0x2c9c2c7de8c4b02cull, 0xaf29af11c56a86afull,
		0x798079ef0b72f979ull, 0xe047e0537a9aa7e0ull, 0x97f197cc55c26697ull, 0xfd2efdbb34c9d3fdull,
		0x6fce6f5f7f10a16full, 0x4b7a4b62a7ec314bull, 0x454c451283c60945ull, 0x39dd39d596afe439ull,
		0x3ec63eed84baf83eull, 0xdd8edda6f42953ddull, 0xa315a371ed4eb6a3ull, 0x4f6e4f42bff0214full,
		0xb45eb4c99f2beab4ull, 0xb654b6d99325e2b6ull, 0x9ac89aa47be1529aull, 0x0e360e70242a380eull,
		0x1f631ff8425d7c1full, 0xbf79bf91a51ac6bfull, 0x154115a87e6b5415ull, 0xe142e15b7c9da3e1ull,
		0x49704972abe23949ull, 0xd2bdd2ded6046fd2ull, 0x93e593ec4dde7693ull, 0xc6f9c67eae683fc6ull,
		0x92e092e44bd97292ull, 0x72a772b73143d572ull, 0x9edc9e8463fd429eull, 0x61f8612f5b3a9961ull,
		0xd1b2d1c6dc0d63d1ull, 0x63f2633f57349163ull, 0xfa35fa8326dccffaull, 0xee71ee235eb09feeull,
		0xf403f4f302f6f7f4ull, 0x197d19c8564f6419ull, 0xd5a6d5e6c41173d5ull, 0xad23ad01c9648eadull,
		0x582558facd957d58ull, 0xa40ea449ff5baaa4ull, 0xbb6dbbb1bd06d6bbull, 0xa11fa161e140bea1ull,
		0xdc8bdcaef22e57dcull, 0xf21df2c316e4eff2ull, 0x83b5836c2dae3683ull, 0x37eb37a5b285dc37ull,
		0x4257422a91d31542ull, 0xe453e4736286b7e4ull, 0x7a8f7af7017bf57aull, 0x32fa328dac9ec832ull,
		0x9cd69c946ff34a9cull, 0xccdbcc2e925e17ccull, 0xab3dab31dd7696abull, 0x4a7f4a6aa1eb354aull,
		0x8f898f0c058a068full, 0x6ecb6e577917a56eull, 0x04140420181c1004ull, 0x27bb2725d2f59c27ull,
		0x2e962e6de4cab82eull, 0xe75ce76b688fbbe7ull, 0xe24de2437694afe2ull, 0x5a2f5aeac19b755aull,
		0x96f496c453c56296ull, 0x164e16b074625816ull, 0x23af2305cae98c23ull, 0x2b872b45fad1ac2bull,
		0xc2edc25eb6742fc2ull, 0x65ec650f43268965ull, 0x66e36617492f8566ull, 0x0f330f78222d3c0full,
		0xbc76bc89af13cabcull, 0xa937a921d1789ea9ull, 0x474647028fc80147ull, 0x415841329bda1941ull,
		0x34e434bdb88cd034ull, 0x4875487aade53d48ull, 0xfc2bfcb332ced7fcull, 0xb751b7d19522e6b7ull,
		0x6adf6a77610bb56aull, 0x88928834179f1a88ull, 0xa50ba541f95caea5ull, 0x530253a2f7a45153ull,
		0x86a4864433b52286ull, 0xf93af99b2cd5c3f9ull, 0x5b2a5be2c79c715bull, 0xdb90db96e03b4bdbull,
		0x38d838dd90a8e038ull, 0x7b8a7bff077cf17bull, 0xc3e8c356b0732bc3ull, 0x1e661ef0445a781eull,
		0x22aa220dccee8822ull, 0x33ff3385aa99cc33ull, 0x24b4243dd8fc9024ull, 0x2888285df0d8a028ull,
		0x36ee36adb482d836ull, 0xc7fcc776a86f3bc7ull, 0xb240b2f98b39f2b2ull, 0x3bd73bc59aa1ec3bull,
		0x8e8c8e04038d028eull, 0x77b6779f2f58c177ull, 0xba68bab9bb01d2baull, 0xf506f5fb04f1f3f5ull,
		0x144414a0786c5014ull, 0x9fd99f8c65fa469full, 0x0828084030382008ull, 0x551c5592e3b64955ull,
		0x9bcd9bac7de6569bull, 0x4c614c5ab5f92d4cull, 0xfe21fea33ec0dffeull, 0x60fd60275d3d9d60ull,
		0x5c315cdad5896d5cull, 0xda95da9ee63c4fdaull, 0x187818c050486018ull, 0x4643460a89cf0546ull,
		0xcddecd26945913cdull, 0x7d947dcf136ee97dull, 0x21a52115c6e78421ull, 0xb04ab0e98737fab0ull,
		0x3fc33fe582bdfc3full, 0x1b771bd85a416c1bull, 0x8997893c11981e89ull, 0xff24ffab38c7dbffull,
		0xeb60eb0b40ab8bebull, 0x84ae84543fbb2a84ull, 0x69d0696f6b02b969ull, 0x3ad23acd9ca6e83aull,
		0x9dd39d9c69f44e9dull, 0xd7acd7f6c81f7bd7ull, 0xd3b8d3d6d0036bd3ull, 0x70ad70a73d4ddd70ull,
		0x67e6671f4f288167ull, 0x405d403a9ddd1d40ull, 0xb55bb5c1992ceeb5ull, 0xde81debefe205fdeull,
		0x5d345dd2d38e695dull, 0x30f0309da090c030ull, 0x91ef91fc41d07e91ull, 0xb14fb1e18130feb1ull,
		0x788578e70d75fd78ull, 0x1155118866774411ull, 0x0105010806070401ull, 0xe556e57b6481b3e5ull,
		0x0000000000000000ull, 0x68d568676d05bd68ull, 0x98c298b477ef5a98ull, 0xa01aa069e747baa0ull,
		0xc5f6c566a46133c5ull, 0x020a02100c0e0802ull, 0xa604a659f355a2a6ull, 0x74b974872551cd74ull,
		0x2d992d75eec3b42dull, 0x0b270b583a312c0bull, 0xa210a279eb49b2a2ull, 0x76b37697295fc576ull,
		0xb345b3f18d3ef6b3ull, 0xbe7cbe99a31dc2beull, 0xced1ce3e9e501fceull, 0xbd73bd81a914cebdull,
		0xae2cae19c36d82aeull, 0xe96ae91b4ca583e9ull, 0x8a988a241b91128aull, 0x31f53195a697c431ull,
		0x1c6c1ce04854701cull, 0xec7bec3352be97ecull, 0xf112f1db1cede3f1ull, 0x99c799bc71e85e99ull,
		0x94fe94d45fcb6a94ull, 0xaa38aa39db7192aaull, 0xf609f6e30ef8fff6ull, 0x26be262dd4f29826ull,
		0x2f932f65e2cdbc2full, 0xef74ef2b58b79befull, 0xe86fe8134aa287e8ull, 0x8c868c140f830a8cull,
		0x35e135b5be8bd435ull, 0x030f03180a090c03ull, 0xd4a3d4eec21677d4ull, 0x7f9e7fdf1f60e17full,
		0xfb30fb8b20dbcbfbull, 0x051105281e1b1405ull, 0xc1e2c146bc7d23c1ull, 0x5e3b5ecad987655eull,
		0x90ea90f447d77a90ull, 0x20a0201dc0e08020ull, 0x3dc93df58eb3f43dull, 0x82b082642ba93282ull,
		0xf70cf7eb08fffbf7ull, 0xea65ea0346ac8feaull, 0x0a220a503c36280aull, 0x0d390d682e23340dull,
		0x7e9b7ed71967e57eull, 0xf83ff8932ad2c7f8ull, 0x500d50bafdad5d50ull, 0x1a721ad05c46681aull,
		0xc4f3c46ea26637c4ull, 0x071b073812151c07ull, 0x57165782efb84157ull, 0xb862b8a9b70fdab8ull,
		0x3ccc3cfd88b4f03cull, 0x62f7623751339562ull, 0xe348e34b7093abe3ull, 0xc8cfc80e8a4207c8ull,
		0xac26ac09cf638aacull, 0x520752aaf1a35552ull, 0x64e9640745218d64ull, 0x1050108060704010ull,
		0xd0b7d0ceda0a67d0ull, 0xd99ad986ec3543d9ull, 0x135f13986a794c13ull, 0x0c3c0c602824300cull,
		0x125a12906c7e4812ull, 0x298d2955f6dfa429ull, 0x510851b2fbaa5951ull, 0xb967b9a1b108deb9ull,
		0xcfd4cf3698571bcfull, 0xd6a9d6fece187fd6ull, 0x73a273bf3744d173ull, 0x8d838d1c09840e8dull,
		0x81bf817c21a03e81ull, 0x5419549ae5b14d54ull, 0xc0e7c04eba7a27c0ull, 0xed7eed3b54b993edull,
		0x4e6b4e4ab9f7254eull, 0x4449441a85c10d44ull, 0xa701a751f552a6a7ull, 0x2a822a4dfcd6a82aull,
		0x85ab855c39bc2e85ull, 0x25b12535defb9425ull, 0xe659e6636e88bfe6ull, 0xcac5ca1e864c0fcaull,
		0x7c917cc71569ed7cull, 0x8b9d8b2c1d96168bull, 0x5613568ae9bf4556ull, 0x80ba807427a73a80ull
	},
	{
		0xd1ce3e9e501fceceull, 0x6dbbb1bd06d6bbbbull, 0x60eb0b40ab8bebebull, 0xe092e44bd9729292ull,
		0x65ea0346ac8feaeaull, 0xc0cb16804b0bcbcbull, 0x5f13986a794c1313ull, 0xe2c146bc7d23c1c1ull,
		0x6ae91b4ca583e9e9ull, 0xd23acd9ca6e83a3aull, 0xa9d6fece187fd6d6ull, 0x40b2f98b39f2b2b2ull,
		0xbdd2ded6046fd2d2ull, 0xea90f447d77a9090ull, 0x4b17b872655c1717ull, 0x3ff8932ad2c7f8f8ull,
		0x57422a91d3154242ull, 0x4115a87e6b541515ull, 0x13568ae9bf455656ull, 0x5eb4c99f2beab4b4ull,
		0xec650f4326896565ull, 0x6c1ce04854701c1cull, 0x928834179f1a8888ull, 0x52432297d4114343ull,
		0xf6c566a46133c5c5ull, 0x315cdad5896d5c5cull, 0xee36adb482d83636ull, 0x68bab9bb01d2babaull,
		0x06f5fb04f1f3f5f5ull, 0x165782efb8415757ull, 0xe6671f4f28816767ull, 0x838d1c09840e8d8dull,
		0xf53195a697c43131ull, 0x09f6e30ef8fff6f6ull, 0xe9640745218d6464ull, 0x2558facd957d5858ull,
		0xdc9e8463fd429e9eull, 0x03f4f302f6f7f4f4ull, 0xaa220dccee882222ull, 0x38aa39db7192aaaaull,
		0xbc758f2356c97575ull, 0x330f78222d3c0f0full, 0x0a02100c0e080202ull, 0x4fb1e18130feb1b1ull,
		0x84dfb6f8275bdfdfull, 0xc46d4f731ea96d6dull, 0xa273bf3744d17373ull, 0x644d52b3fe294d4dull,
		0x917cc71569ed7c7cull, 0xbe262dd4f2982626ull, 0x962e6de4cab82e2eull, 0x0cf7eb08fffbf7f7ull,
		0x2808403038200808ull, 0x345dd2d38e695d5dull, 0x49441a85c10d4444ull, 0xc63eed84baf83e3eull,
		0xd99f8c65fa469f9full, 0x4414a0786c501414ull, 0xcfc80e8a4207c8c8ull, 0x2cae19c36d82aeaeull,
		0x19549ae5b14d5454ull, 0x5010806070401010ull, 0x9fd88eea3247d8d8ull, 0x76bc89af13cabcbcull,
		0x721ad05c46681a1aull, 0xda6b7f670cb16b6bull, 0xd0696f6b02b96969ull, 0x18f3cb10e3ebf3f3ull,
		0x73bd81a914cebdbdull, 0xff3385aa99cc3333ull, 0x3dab31dd7696ababull, 0x35fa8326dccffafaull,
		0xb2d1c6dc0d63d1d1ull, 0xcd9bac7de6569b9bull, 0xd568676d05bd6868ull, 0x6b4e4ab9f7254e4eull,
		0x4e16b07462581616ull, 0xfb95dc59cc6e9595ull, 0xef91fc41d07e9191ull, 0x71ee235eb09feeeeull,
		0x614c5ab5f92d4c4cull, 0xf2633f5734916363ull, 0x8c8e04038d028e8eull, 0x2a5be2c79c715b5bull,
		0xdbcc2e925e17ccccull, 0xcc3cfd88b4f03c3cull, 0x7d19c8564f641919ull, 0x1fa161e140bea1a1ull,
		0xbf817c21a03e8181ull, 0x704972abe2394949ull, 0x8a7bff077cf17b7bull, 0x9ad986ec3543d9d9ull,
		0xce6f5f7f10a16f6full, 0xeb37a5b285dc3737ull, 0xfd60275d3d9d6060ull, 0xc5ca1e864c0fcacaull,
		0x5ce76b688fbbe7e7ull, 0x872b45fad1ac2b2bull, 0x75487aade53d4848ull, 0x2efdbb34c9d3fdfdull,
		0xf496c453c5629696ull, 0x4c451283c6094545ull, 0x2bfcb332ced7fcfcull, 0x5841329bda194141ull,
		0x5a12906c7e481212ull, 0x390d682e23340d0dull, 0x8079ef0b72f97979ull, 0x56e57b6481b3e5e5ull,
		0x97893c11981e8989ull, 0x868c140f830a8c8cull, 0x48e34b7093abe3e3ull, 0xa0201dc0e0802020ull,
		0xf0309da090c03030ull, 0x8bdcaef22e57dcdcull, 0x51b7d19522e6b7b7ull, 0xc16c477519ad6c6cull,
		0x7f4a6aa1eb354a4aull, 0x5bb5c1992ceeb5b5ull, 0xc33fe582bdfc3f3full, 0xf197cc55c2669797ull,
		0xa3d4eec21677d4d4ull, 0xf762375133956262ull, 0x992d75eec3b42d2dull, 0x1e06301412180606ull,
		0x0ea449ff5baaa4a4ull, 0x0ba541f95caea5a5ull, 0xb5836c2dae368383ull, 0x3e5fc2df80615f5full,
		0x822a4dfcd6a82a2aull, 0x95da9ee63c4fdadaull, 0xcac9068c4503c9c9ull, 0x0000000000000000ull,
		0x9b7ed71967e57e7eull, 0x10a279eb49b2a2a2ull, 0x1c5592e3b6495555ull, 0x79bf91a51ac6bfbfull,
		0x5511886677441111ull, 0xa6d5e6c41173d5d5ull, 0xd69c946ff34a9c9cull, 0xd4cf3698571bcfcfull,
		0x360e70242a380e0eull, 0x220a503c36280a0aull, 0xc93df58eb3f43d3dull, 0x0851b2fbaa595151ull,
		0x947dcf136ee97d7dull, 0xe593ec4dde769393ull, 0x771bd85a416c1b1bull, 0x21fea33ec0dffefeull,
		0xf3c46ea26637c4c4ull, 0x4647028fc8014747ull, 0x2d0948363f240909ull, 0xa4864433b5228686ull,
		0x270b583a312c0b0bull, 0x898f0c058a068f8full, 0xd39d9c69f44e9d9dull, 0xdf6a77610bb56a6aull,
		0x1b073812151c0707ull, 0x67b9a1b108deb9b9ull, 0x4ab0e98737fab0b0ull, 0xc298b477ef5a9898ull,
		0x7818c05048601818ull, 0xfa328dac9ec83232ull, 0xa871af3b4ad97171ull, 0x7a4b62a7ec314b4bull,
		0x74ef2b58b79befefull, 0xd73bc59aa1ec3b3bull, 0xad70a73d4ddd7070ull, 0x1aa069e747baa0a0ull,
		0x53e4736286b7e4e4ull, 0x5d403a9ddd1d4040ull, 0x24ffab38c7dbffffull, 0xe8c356b0732bc3c3ull,
		0x37a921d1789ea9a9ull, 0x59e6636e88bfe6e6ull, 0x8578e70d75fd7878ull, 0x3af99b2cd5c3f9f9ull,
		0x9d8b2c1d96168b8bull, 0x43460a89cf054646ull, 0xba807427a73a8080ull, 0x661ef0445a781e1eull,
		0xd838dd90a8e03838ull, 0x42e15b7c9da3e1e1ull, 0x62b8a9b70fdab8b8ull, 0x32a829d77f9aa8a8ull,
		0x47e0537a9aa7e0e0ull, 0x3c0c602824300c0cull, 0xaf2305cae98c2323ull, 0xb37697295fc57676ull,
		0x691de84e53741d1dull, 0xb12535defb942525ull, 0xb4243dd8fc902424ull, 0x1105281e1b140505ull,
		0x12f1db1cede3f1f1ull, 0xcb6e577917a56e6eull, 0xfe94d45fcb6a9494ull, 0x88285df0d8a02828ull,
		0xc89aa47be1529a9aull, 0xae84543fbb2a8484ull, 0x6fe8134aa287e8e8ull, 0x15a371ed4eb6a3a3ull,
		0x6e4f42bff0214f4full, 0xb6779f2f58c17777ull, 0xb8d3d6d0036bd3d3ull, 0xab855c39bc2e8585ull,
		0x4de2437694afe2e2ull, 0x0752aaf1a3555252ull, 0x1df2c316e4eff2f2ull, 0xb082642ba9328282ull,
		0x0d50bafdad5d5050ull, 0x8f7af7017bf57a7aull, 0x932f65e2cdbc2f2full, 0xb974872551cd7474ull,
		0x0253a2f7a4515353ull, 0x45b3f18d3ef6b3b3ull, 0xf8612f5b3a996161ull, 0x29af11c56a86afafull,
		0xdd39d596afe43939ull, 0xe135b5be8bd43535ull, 0x81debefe205fdedeull, 0xdecd26945913cdcdull,
		0x631ff8425d7c1f1full, 0xc799bc71e85e9999ull, 0x26ac09cf638aacacull, 0x23ad01c9648eadadull,
		0xa772b73143d57272ull, 0x9c2c7de8c4b02c2cull, 0x8edda6f42953ddddull, 0xb7d0ceda0a67d0d0ull,
		0xa1874c35b2268787ull, 0x7cbe99a31dc2bebeull, 0x3b5ecad987655e5eull, 0x04a659f355a2a6a6ull,
		0x7bec3352be97ececull, 0x140420181c100404ull, 0xf9c67eae683fc6c6ull, 0x0f03180a090c0303ull,
		0xe434bdb88cd03434ull, 0x30fb8b20dbcbfbfbull, 0x90db96e03b4bdbdbull, 0x2059f2cb92795959ull,
		0x54b6d99325e2b6b6ull, 0xedc25eb6742fc2c2ull, 0x0501080607040101ull, 0x17f0d31aeae7f0f0ull,
		0x2f5aeac19b755a5aull, 0x7eed3b54b993ededull, 0x01a751f552a6a7a7ull, 0xe36617492f856666ull,
		0xa52115c6e7842121ull, 0x9e7fdf1f60e17f7full, 0x988a241b91128a8aull, 0xbb2725d2f59c2727ull,
		0xfcc776a86f3bc7c7ull, 0xe7c04eba7a27c0c0ull, 0x8d2955f6dfa42929ull, 0xacd7f6c81f7bd7d7ull
	},
	{
		0x93ec4dde769393e5ull, 0xd986ec3543d9d99aull, 0x9aa47be1529a9ac8ull, 0xb5c1992ceeb5b55bull,
		0x98b477ef5a9898c2ull, 0x220dccee882222aaull, 0x451283c60945454cull, 0xfcb332ced7fcfc2bull,
		0xbab9bb01d2baba68ull, 0x6a77610bb56a6adfull, 0xdfb6f8275bdfdf84ull, 0x02100c0e0802020aull,
		0x9f8c65fa469f9fd9ull, 0xdcaef22e57dcdc8bull, 0x51b2fbaa59515108ull, 0x59f2cb9279595920ull,
		0x4a6aa1eb354a4a7full, 0x17b872655c17174bull, 0x2b45fad1ac2b2b87ull, 0xc25eb6742fc2c2edull,
		0x94d45fcb6a9494feull, 0xf4f302f6f7f4f403ull, 0xbbb1bd06d6bbbb6dull, 0xa371ed4eb6a3a315ull,
		0x62375133956262f7ull, 0xe4736286b7e4e453ull, 0x71af3b4ad97171a8ull, 0xd4eec21677d4d4a3ull,
		0xcd26945913cdcddeull, 0x70a73d4ddd7070adull, 0x16b074625816164eull, 0xe15b7c9da3e1e142ull,
		0x4972abe239494970ull, 0x3cfd88b4f03c3cccull, 0xc04eba7a27c0c0e7ull, 0xd88eea3247d8d89full,
		0x5cdad5896d5c5c31ull, 0x9bac7de6569b9bcdull, 0xad01c9648eadad23ull, 0x855c39bc2e8585abull,
		0x53a2f7a451535302ull, 0xa161e140bea1a11full, 0x7af7017bf57a7a8full, 0xc80e8a4207c8c8cfull,
		0x2d75eec3b42d2d99ull, 0xe0537a9aa7e0e047ull, 0xd1c6dc0d63d1d1b2ull, 0x72b73143d57272a7ull,
		0xa659f355a2a6a604ull, 0x2c7de8c4b02c2c9cull, 0xc46ea26637c4c4f3ull, 0xe34b7093abe3e348ull,
		0x7697295fc57676b3ull, 0x78e70d75fd787885ull, 0xb7d19522e6b7b751ull, 0xb4c99f2beab4b45eull,
		0x0948363f2409092dull, 0x3bc59aa1ec3b3bd7ull, 0x0e70242a380e0e36ull, 0x41329bda19414158ull,
		0x4c5ab5f92d4c4c61ull, 0xdebefe205fdede81ull, 0xb2f98b39f2b2b240ull, 0x90f447d77a9090eaull,
		0x2535defb942525b1ull, 0xa541f95caea5a50bull, 0xd7f6c81f7bd7d7acull, 0x03180a090c03030full,
		0x1188667744111155ull, 0x0000000000000000ull, 0xc356b0732bc3c3e8ull, 0x2e6de4cab82e2e96ull,
		0x92e44bd9729292e0ull, 0xef2b58b79befef74ull, 0x4e4ab9f7254e4e6bull, 0x12906c7e4812125aull,
		0x9d9c69f44e9d9dd3ull, 0x7dcf136ee97d7d94ull, 0xcb16804b0bcbcbc0ull, 0x35b5be8bd43535e1ull,
		0x1080607040101050ull, 0xd5e6c41173d5d5a6ull, 0x4f42bff0214f4f6eull, 0x9e8463fd429e9edcull,
		0x4d52b3fe294d4d64ull, 0xa921d1789ea9a937ull, 0x5592e3b64955551cull, 0xc67eae683fc6c6f9ull,
		0xd0ceda0a67d0d0b7ull, 0x7bff077cf17b7b8aull, 0x18c0504860181878ull, 0x97cc55c2669797f1ull,
		0xd3d6d0036bd3d3b8ull, 0x36adb482d83636eeull, 0xe6636e88bfe6e659ull, 0x487aade53d484875ull,
		0x568ae9bf45565613ull, 0x817c21a03e8181bfull, 0x8f0c058a068f8f89ull, 0x779f2f58c17777b6ull,
		0xcc2e925e17ccccdbull, 0x9c946ff34a9c9cd6ull, 0xb9a1b108deb9b967ull, 0xe2437694afe2e24dull,
		0xac09cf638aacac26ull, 0xb8a9b70fdab8b862ull, 0x2f65e2cdbc2f2f93ull, 0x15a87e6b54151541ull,
		0xa449ff5baaa4a40eull, 0x7cc71569ed7c7c91ull, 0xda9ee63c4fdada95ull, 0x38dd90a8e03838d8ull,
		0x1ef0445a781e1e66ull, 0x0b583a312c0b0b27ull, 0x05281e1b14050511ull, 0xd6fece187fd6d6a9ull,
		0x14a0786c50141444ull, 0x6e577917a56e6ecbull, 0x6c477519ad6c6cc1ull, 0x7ed71967e57e7e9bull,
		0x6617492f856666e3ull, 0xfdbb34c9d3fdfd2eull, 0xb1e18130feb1b14full, 0xe57b6481b3e5e556ull,
		0x60275d3d9d6060fdull, 0xaf11c56a86afaf29ull, 0x5ecad987655e5e3bull, 0x3385aa99cc3333ffull,
		0x874c35b2268787a1ull, 0xc9068c4503c9c9caull, 0xf0d31aeae7f0f017ull, 0x5dd2d38e695d5d34ull,
		0x6d4f731ea96d6dc4ull, 0x3fe582bdfc3f3fc3ull, 0x8834179f1a888892ull, 0x8d1c09840e8d8d83ull,
		0xc776a86f3bc7c7fcull, 0xf7eb08fffbf7f70cull, 0x1de84e53741d1d69ull, 0xe91b4ca583e9e96aull,
		0xec3352be97ecec7bull, 0xed3b54b993eded7eull, 0x807427a73a8080baull, 0x2955f6dfa429298dull,
		0x2725d2f59c2727bbull, 0xcf3698571bcfcfd4ull, 0x99bc71e85e9999c7ull, 0xa829d77f9aa8a832ull,
		0x50bafdad5d50500dull, 0x0f78222d3c0f0f33ull, 0x37a5b285dc3737ebull, 0x243dd8fc902424b4ull,
		0x285df0d8a0282888ull, 0x309da090c03030f0ull, 0x95dc59cc6e9595fbull, 0xd2ded6046fd2d2bdull,
		0x3eed84baf83e3ec6ull, 0x5be2c79c715b5b2aull, 0x403a9ddd1d40405dull, 0x836c2dae368383b5ull,
		0xb3f18d3ef6b3b345ull, 0x696f6b02b96969d0ull, 0x5782efb841575716ull, 0x1ff8425d7c1f1f63ull,
		0x073812151c07071bull, 0x1ce04854701c1c6cull, 0x8a241b91128a8a98ull, 0xbc89af13cabcbc76ull,
		0x201dc0e0802020a0ull, 0xeb0b40ab8bebeb60ull, 0xce3e9e501fceced1ull, 0x8e04038d028e8e8cull,
		0xab31dd7696abab3dull, 0xee235eb09feeee71ull, 0x3195a697c43131f5ull, 0xa279eb49b2a2a210ull,
		0x73bf3744d17373a2ull, 0xf99b2cd5c3f9f93aull, 0xca1e864c0fcacac5ull, 0x3acd9ca6e83a3ad2ull,
		0x1ad05c46681a1a72ull, 0xfb8b20dbcbfbfb30ull, 0x0d682e23340d0d39ull, 0xc146bc7d23c1c1e2ull,
		0xfea33ec0dffefe21ull, 0xfa8326dccffafa35ull, 0xf2c316e4eff2f21dull, 0x6f5f7f10a16f6fceull,
		0xbd81a914cebdbd73ull, 0x96c453c5629696f4ull, 0xdda6f42953dddd8eull, 0x432297d411434352ull,
		0x52aaf1a355525207ull, 0xb6d99325e2b6b654ull, 0x0840303820080828ull, 0xf3cb10e3ebf3f318ull,
		0xae19c36d82aeae2cull, 0xbe99a31dc2bebe7cull, 0x19c8564f6419197dull, 0x893c11981e898997ull,
		0x328dac9ec83232faull, 0x262dd4f2982626beull, 0xb0e98737fab0b04aull, 0xea0346ac8feaea65ull,
		0x4b62a7ec314b4b7aull, 0x640745218d6464e9ull, 0x84543fbb2a8484aeull, 0x82642ba9328282b0ull,
		0x6b7f670cb16b6bdaull, 0xf5fb04f1f3f5f506ull, 0x79ef0b72f9797980ull, 0xbf91a51ac6bfbf79ull,
		0x0108060704010105ull, 0x5fc2df80615f5f3eull, 0x758f2356c97575bcull, 0x633f5734916363f2ull,
		0x1bd85a416c1b1b77ull, 0x2305cae98c2323afull, 0x3df58eb3f43d3dc9ull, 0x68676d05bd6868d5ull,
		0x2a4dfcd6a82a2a82ull, 0x650f4326896565ecull, 0xe8134aa287e8e86full, 0x91fc41d07e9191efull,
		0xf6e30ef8fff6f609ull, 0xffab38c7dbffff24ull, 0x13986a794c13135full, 0x58facd957d585825ull,
		0xf1db1cede3f1f112ull, 0x47028fc801474746ull, 0x0a503c36280a0a22ull, 0x7fdf1f60e17f7f9eull,
		0xc566a46133c5c5f6ull, 0xa751f552a6a7a701ull, 0xe76b688fbbe7e75cull, 0x612f5b3a996161f8ull,
		0x5aeac19b755a5a2full, 0x063014121806061eull, 0x460a89cf05464643ull, 0x441a85c10d444449ull,
		0x422a91d315424257ull, 0x0420181c10040414ull, 0xa069e747baa0a01aull, 0xdb96e03b4bdbdb90ull,
		0x39d596afe43939ddull, 0x864433b5228686a4ull, 0x549ae5b14d545419ull, 0xaa39db7192aaaa38ull,
		0x8c140f830a8c8c86ull, 0x34bdb88cd03434e4ull, 0x2115c6e7842121a5ull, 0x8b2c1d96168b8b9dull,
		0xf8932ad2c7f8f83full, 0x0c602824300c0c3cull, 0x74872551cd7474b9ull, 0x671f4f28816767e6ull
	},
	{
		0x676d05bd6868d568ull, 0x1c09840e8d8d838dull, 0x1e864c0fcacac5caull, 0x52b3fe294d4d644dull,
		0xbf3744d17373a273ull, 0x62a7ec314b4b7a4bull, 0x4ab9f7254e4e6b4eull, 0x4dfcd6a82a2a822aull,
		0xeec21677d4d4a3d4ull, 0xaaf1a35552520752ull, 0x2dd4f2982626be26ull, 0xf18d3ef6b3b345b3ull,
		0x9ae5b14d54541954ull, 0xf0445a781e1e661eull, 0xc8564f6419197d19ull, 0xf8425d7c1f1f631full,
		0x0dccee882222aa22ull, 0x180a090c03030f03ull, 0x0a89cf0546464346ull, 0xf58eb3f43d3dc93dull,
		0x75eec3b42d2d992dull, 0x6aa1eb354a4a7f4aull, 0xa2f7a45153530253ull, 0x6c2dae368383b583ull,
		0x986a794c13135f13ull, 0x241b91128a8a988aull, 0xd19522e6b7b751b7ull, 0xe6c41173d5d5a6d5ull,
		0x35defb942525b125ull, 0xef0b72f979798079ull, 0xfb04f1f3f5f506f5ull, 0x81a914cebdbd73bdull,
		0xfacd957d58582558ull, 0x65e2cdbc2f2f932full, 0x682e23340d0d390dull, 0x100c0e0802020a02ull,
		0x3b54b993eded7eedull, 0xb2fbaa5951510851ull, 0x8463fd429e9edc9eull, 0x8866774411115511ull,
		0xc316e4eff2f21df2ull, 0xed84baf83e3ec63eull, 0x92e3b64955551c55ull, 0xcad987655e5e3b5eull,
		0xc6dc0d63d1d1b2d1ull, 0xb074625816164e16ull, 0xfd88b4f03c3ccc3cull, 0x17492f856666e366ull,
		0xa73d4ddd7070ad70ull, 0xd2d38e695d5d345dull, 0xcb10e3ebf3f318f3ull, 0x1283c60945454c45ull,
		0x3a9ddd1d40405d40ull, 0x2e925e17ccccdbccull, 0x134aa287e8e86fe8ull, 0xd45fcb6a9494fe94ull,
		0x8ae9bf4556561356ull, 0x4030382008082808ull, 0x3e9e501fceced1ceull, 0xd05c46681a1a721aull,
		0xcd9ca6e83a3ad23aull, 0xded6046fd2d2bdd2ull, 0x5b7c9da3e1e142e1ull, 0xb6f8275bdfdf84dfull,
		0xc1992ceeb5b55bb5ull, 0xdd90a8e03838d838ull, 0x577917a56e6ecb6eull, 0x70242a380e0e360eull,
		0x7b6481b3e5e556e5ull, 0xf302f6f7f4f403f4ull, 0x9b2cd5c3f9f93af9ull, 0x4433b5228686a486ull,
		0x1b4ca583e9e96ae9ull, 0x42bff0214f4f6e4full, 0xfece187fd6d6a9d6ull, 0x5c39bc2e8585ab85ull,
		0x05cae98c2323af23ull, 0x3698571bcfcfd4cfull, 0x8dac9ec83232fa32ull, 0xbc71e85e9999c799ull,
		0x95a697c43131f531ull, 0xa0786c5014144414ull, 0x19c36d82aeae2caeull, 0x235eb09feeee71eeull,
		0x0e8a4207c8c8cfc8ull, 0x7aade53d48487548ull, 0xd6d0036bd3d3b8d3ull, 0x9da090c03030f030ull,
		0x61e140bea1a11fa1ull, 0xe44bd9729292e092ull, 0x329bda1941415841ull, 0xe18130feb1b14fb1ull,
		0xc050486018187818ull, 0x6ea26637c4c4f3c4ull, 0x7de8c4b02c2c9c2cull, 0xaf3b4ad97171a871ull,
		0xb73143d57272a772ull, 0x1a85c10d44444944ull, 0xa87e6b5415154115ull, 0xbb34c9d3fdfd2efdull,
		0xa5b285dc3737eb37ull, 0x99a31dc2bebe7cbeull, 0xc2df80615f5f3e5full, 0x39db7192aaaa38aaull,
		0xac7de6569b9bcd9bull, 0x34179f1a88889288ull, 0x8eea3247d8d89fd8ull, 0x31dd7696abab3dabull,
		0x3c11981e89899789ull, 0x946ff34a9c9cd69cull, 0x8326dccffafa35faull, 0x275d3d9d6060fd60ull,
		0x0346ac8feaea65eaull, 0x89af13cabcbc76bcull, 0x375133956262f762ull, 0x602824300c0c3c0cull,
		0x3dd8fc902424b424ull, 0x59f355a2a6a604a6ull, 0x29d77f9aa8a832a8ull, 0x3352be97ecec7becull,
		0x1f4f28816767e667ull, 0x1dc0e0802020a020ull, 0x96e03b4bdbdb90dbull, 0xc71569ed7c7c917cull,
		0x5df0d8a028288828ull, 0xa6f42953dddd8eddull, 0x09cf638aacac26acull, 0xe2c79c715b5b2a5bull,
		0xbdb88cd03434e434ull, 0xd71967e57e7e9b7eull, 0x8060704010105010ull, 0xdb1cede3f1f112f1ull,
		0xff077cf17b7b8a7bull, 0x0c058a068f8f898full, 0x3f5734916363f263ull, 0x69e747baa0a01aa0ull,
		0x281e1b1405051105ull, 0xa47be1529a9ac89aull, 0x2297d41143435243ull, 0x9f2f58c17777b677ull,
		0x15c6e7842121a521ull, 0x91a51ac6bfbf79bfull, 0x25d2f59c2727bb27ull, 0x48363f2409092d09ull,
		0x56b0732bc3c3e8c3ull, 0x8c65fa469f9fd99full, 0xd99325e2b6b654b6ull, 0xf6c81f7bd7d7acd7ull,
		0x55f6dfa429298d29ull, 0x5eb6742fc2c2edc2ull, 0x0b40ab8bebeb60ebull, 0x4eba7a27c0c0e7c0ull,
		0x49ff5baaa4a40ea4ull, 0x2c1d96168b8b9d8bull, 0x140f830a8c8c868cull, 0xe84e53741d1d691dull,
		0x8b20dbcbfbfb30fbull, 0xab38c7dbffff24ffull, 0x46bc7d23c1c1e2c1ull, 0xf98b39f2b2b240b2ull,
		0xcc55c2669797f197ull, 0x6de4cab82e2e962eull, 0x932ad2c7f8f83ff8ull, 0x0f4326896565ec65ull,
		0xe30ef8fff6f609f6ull, 0x8f2356c97575bc75ull, 0x3812151c07071b07ull, 0x20181c1004041404ull,
		0x72abe23949497049ull, 0x85aa99cc3333ff33ull, 0x736286b7e4e453e4ull, 0x86ec3543d9d99ad9ull,
		0xa1b108deb9b967b9ull, 0xceda0a67d0d0b7d0ull, 0x2a91d31542425742ull, 0x76a86f3bc7c7fcc7ull,
		0x477519ad6c6cc16cull, 0xf447d77a9090ea90ull, 0x0000000000000000ull, 0x04038d028e8e8c8eull,
		0x5f7f10a16f6fce6full, 0xbafdad5d50500d50ull, 0x0806070401010501ull, 0x66a46133c5c5f6c5ull,
		0x9ee63c4fdada95daull, 0x028fc80147474647ull, 0xe582bdfc3f3fc33full, 0x26945913cdcddecdull,
		0x6f6b02b96969d069ull, 0x79eb49b2a2a210a2ull, 0x437694afe2e24de2ull, 0xf7017bf57a7a8f7aull,
		0x51f552a6a7a701a7ull, 0x7eae683fc6c6f9c6ull, 0xec4dde769393e593ull, 0x78222d3c0f0f330full,
		0x503c36280a0a220aull, 0x3014121806061e06ull, 0x636e88bfe6e659e6ull, 0x45fad1ac2b2b872bull,
		0xc453c5629696f496ull, 0x71ed4eb6a3a315a3ull, 0xe04854701c1c6c1cull, 0x11c56a86afaf29afull,
		0x77610bb56a6adf6aull, 0x906c7e4812125a12ull, 0x543fbb2a8484ae84ull, 0xd596afe43939dd39ull,
		0x6b688fbbe7e75ce7ull, 0xe98737fab0b04ab0ull, 0x642ba9328282b082ull, 0xeb08fffbf7f70cf7ull,
		0xa33ec0dffefe21feull, 0x9c69f44e9d9dd39dull, 0x4c35b2268787a187ull, 0xdad5896d5c5c315cull,
		0x7c21a03e8181bf81ull, 0xb5be8bd43535e135ull, 0xbefe205fdede81deull, 0xc99f2beab4b45eb4ull,
		0x41f95caea5a50ba5ull, 0xb332ced7fcfc2bfcull, 0x7427a73a8080ba80ull, 0x2b58b79befef74efull,
		0x16804b0bcbcbc0cbull, 0xb1bd06d6bbbb6dbbull, 0x7f670cb16b6bda6bull, 0x97295fc57676b376ull,
		0xb9bb01d2baba68baull, 0xeac19b755a5a2f5aull, 0xcf136ee97d7d947dull, 0xe70d75fd78788578ull,
		0x583a312c0b0b270bull, 0xdc59cc6e9595fb95ull, 0x4b7093abe3e348e3ull, 0x01c9648eadad23adull,
		0x872551cd7474b974ull, 0xb477ef5a9898c298ull, 0xc59aa1ec3b3bd73bull, 0xadb482d83636ee36ull,
		0x0745218d6464e964ull, 0x4f731ea96d6dc46dull, 0xaef22e57dcdc8bdcull, 0xd31aeae7f0f017f0ull,
		0xf2cb927959592059ull, 0x21d1789ea9a937a9ull, 0x5ab5f92d4c4c614cull, 0xb872655c17174b17ull,
		0xdf1f60e17f7f9e7full, 0xfc41d07e9191ef91ull, 0xa9b70fdab8b862b8ull, 0x068c4503c9c9cac9ull,
		0x82efb84157571657ull, 0xd85a416c1b1b771bull, 0x537a9aa7e0e047e0ull, 0x2f5b3a996161f861ull
	},
	{
		0xd77f9aa8a832a829ull, 0x97d4114343524322ull, 0xdf80615f5f3e5fc2ull, 0x14121806061e0630ull,
		0x670cb16b6bda6b7full, 0x2356c97575bc758full, 0x7519ad6c6cc16c47ull, 0xcb927959592059f2ull,
		0x3b4ad97171a871afull, 0xf8275bdfdf84dfb6ull, 0x35b2268787a1874cull, 0x59cc6e9595fb95dcull,
		0x72655c17174b17b8ull, 0x1aeae7f0f017f0d3ull, 0xea3247d8d89fd88eull, 0x363f2409092d0948ull,
		0x731ea96d6dc46d4full, 0x10e3ebf3f318f3cbull, 0x4e53741d1d691de8ull, 0x804b0bcbcbc0cb16ull,
		0x8c4503c9c9cac906ull, 0xb3fe294d4d644d52ull, 0xe8c4b02c2c9c2c7dull, 0xc56a86afaf29af11ull,
		0x0b72f979798079efull, 0x7a9aa7e0e047e053ull, 0x55c2669797f197ccull, 0x34c9d3fdfd2efdbbull,
		0x7f10a16f6fce6f5full, 0xa7ec314b4b7a4b62ull, 0x83c60945454c4512ull, 0x96afe43939dd39d5ull,
		0x84baf83e3ec63eedull, 0xf42953dddd8edda6ull, 0xed4eb6a3a315a371ull, 0xbff0214f4f6e4f42ull,
		0x9f2beab4b45eb4c9ull, 0x9325e2b6b654b6d9ull, 0x7be1529a9ac89aa4ull, 0x242a380e0e360e70ull,
		0x425d7c1f1f631ff8ull, 0xa51ac6bfbf79bf91ull, 0x7e6b5415154115a8ull, 0x7c9da3e1e142e15bull,
		0xabe2394949704972ull, 0xd6046fd2d2bdd2deull, 0x4dde769393e593ecull, 0xae683fc6c6f9c67eull,
		0x4bd9729292e092e4ull, 0x3143d57272a772b7ull, 0x63fd429e9edc9e84ull, 0x5b3a996161f8612full,
		0xdc0d63d1d1b2d1c6ull, 0x5734916363f2633full, 0x26dccffafa35fa83ull, 0x5eb09feeee71ee23ull,
		0x02f6f7f4f403f4f3ull, 0x564f6419197d19c8ull, 0xc41173d5d5a6d5e6ull, 0xc9648eadad23ad01ull,
		0xcd957d58582558faull, 0xff5baaa4a40ea449ull, 0xbd06d6bbbb6dbbb1ull, 0xe140bea1a11fa161ull,
		0xf22e57dcdc8bdcaeull, 0x16e4eff2f21df2c3ull, 0x2dae368383b5836cull, 0xb285dc3737eb37a5ull,
		0x91d315424257422aull, 0x6286b7e4e453e473ull, 0x017bf57a7a8f7af7ull, 0xac9ec83232fa328dull,
		0x6ff34a9c9cd69c94ull, 0x925e17ccccdbcc2eull, 0xdd7696abab3dab31ull, 0xa1eb354a4a7f4a6aull,
		0x058a068f8f898f0cull, 0x7917a56e6ecb6e57ull, 0x181c100404140420ull, 0xd2f59c2727bb2725ull,
		0xe4cab82e2e962e6dull, 0x688fbbe7e75ce76bull, 0x7694afe2e24de243ull, 0xc19b755a5a2f5aeaull,
		0x53c5629696f496c4ull, 0x74625816164e16b0ull, 0xcae98c2323af2305ull, 0xfad1ac2b2b872b45ull,
		0xb6742fc2c2edc25eull, 0x4326896565ec650full, 0x492f856666e36617ull, 0x222d3c0f0f330f78ull,
		0xaf13cabcbc76bc89ull, 0xd1789ea9a937a921ull, 0x8fc8014747464702ull, 0x9bda194141584132ull,
		0xb88cd03434e434bdull, 0xade53d484875487aull, 0x32ced7fcfc2bfcb3ull, 0x9522e6b7b751b7d1ull,
		0x610bb56a6adf6a77ull, 0x179f1a8888928834ull, 0xf95caea5a50ba541ull, 0xf7a45153530253a2ull,
		0x33b5228686a48644ull, 0x2cd5c3f9f93af99bull, 0xc79c715b5b2a5be2ull, 0xe03b4bdbdb90db96ull,
		0x90a8e03838d838ddull, 0x077cf17b7b8a7bffull, 0xb0732bc3c3e8c356ull, 0x445a781e1e661ef0ull,
		0xccee882222aa220dull, 0xaa99cc3333ff3385ull, 0xd8fc902424b4243dull, 0xf0d8a0282888285dull,
		0xb482d83636ee36adull, 0xa86f3bc7c7fcc776ull, 0x8b39f2b2b240b2f9ull, 0x9aa1ec3b3bd73bc5ull,
		0x038d028e8e8c8e04ull, 0x2f58c17777b6779full, 0xbb01d2baba68bab9ull, 0x04f1f3f5f506f5fbull,
		0x786c5014144414a0ull, 0x65fa469f9fd99f8cull, 0x3038200808280840ull, 0xe3b64955551c5592ull,
		0x7de6569b9bcd9bacull, 0xb5f92d4c4c614c5aull, 0x3ec0dffefe21fea3ull, 0x5d3d9d6060fd6027ull,
		0xd5896d5c5c315cdaull, 0xe63c4fdada95da9eull, 0x50486018187818c0ull, 0x89cf05464643460aull,
		0x945913cdcddecd26ull, 0x136ee97d7d947dcfull, 0xc6e7842121a52115ull, 0x8737fab0b04ab0e9ull,
		0x82bdfc3f3fc33fe5ull, 0x5a416c1b1b771bd8ull, 0x11981e898997893cull, 0x38c7dbffff24ffabull,
		0x40ab8bebeb60eb0bull, 0x3fbb2a8484ae8454ull, 0x6b02b96969d0696full, 0x9ca6e83a3ad23acdull,
		0x69f44e9d9dd39d9cull, 0xc81f7bd7d7acd7f6ull, 0xd0036bd3d3b8d3d6ull, 0x3d4ddd7070ad70a7ull,
		0x4f28816767e6671full, 0x9ddd1d40405d403aull, 0x992ceeb5b55bb5c1ull, 0xfe205fdede81debeull,
		0xd38e695d5d345dd2ull, 0xa090c03030f0309dull, 0x41d07e9191ef91fcull, 0x8130feb1b14fb1e1ull,
		0x0d75fd78788578e7ull, 0x6677441111551188ull, 0x0607040101050108ull, 0x6481b3e5e556e57bull,
		0x0000000000000000ull, 0x6d05bd6868d56867ull, 0x77ef5a9898c298b4ull, 0xe747baa0a01aa069ull,
		0xa46133c5c5f6c566ull, 0x0c0e0802020a0210ull, 0xf355a2a6a604a659ull, 0x2551cd7474b97487ull,
		0xeec3b42d2d992d75ull, 0x3a312c0b0b270b58ull, 0xeb49b2a2a210a279ull, 0x295fc57676b37697ull,
		0x8d3ef6b3b345b3f1ull, 0xa31dc2bebe7cbe99ull, 0x9e501fceced1ce3eull, 0xa914cebdbd73bd81ull,
		0xc36d82aeae2cae19ull, 0x4ca583e9e96ae91bull, 0x1b91128a8a988a24ull, 0xa697c43131f53195ull,
		0x4854701c1c6c1ce0ull, 0x52be97ecec7bec33ull, 0x1cede3f1f112f1dbull, 0x71e85e9999c799bcull,
		0x5fcb6a9494fe94d4ull, 0xdb7192aaaa38aa39ull, 0x0ef8fff6f609f6e3ull, 0xd4f2982626be262dull,
		0xe2cdbc2f2f932f65ull, 0x58b79befef74ef2bull, 0x4aa287e8e86fe813ull, 0x0f830a8c8c868c14ull,
		0xbe8bd43535e135b5ull, 0x0a090c03030f0318ull, 0xc21677d4d4a3d4eeull, 0x1f60e17f7f9e7fdfull,
		0x20dbcbfbfb30fb8bull, 0x1e1b140505110528ull, 0xbc7d23c1c1e2c146ull, 0xd987655e5e3b5ecaull,
		0x47d77a9090ea90f4ull, 0xc0e0802020a0201dull, 0x8eb3f43d3dc93df5ull, 0x2ba9328282b08264ull,
		0x08fffbf7f70cf7ebull, 0x46ac8feaea65ea03ull, 0x3c36280a0a220a50ull, 0x2e23340d0d390d68ull,
		0x1967e57e7e9b7ed7ull, 0x2ad2c7f8f83ff893ull, 0xfdad5d50500d50baull, 0x5c46681a1a721ad0ull,
		0xa26637c4c4f3c46eull, 0x12151c07071b0738ull, 0xefb8415757165782ull, 0xb70fdab8b862b8a9ull,
		0x88b4f03c3ccc3cfdull, 0x5133956262f76237ull, 0x7093abe3e348e34bull, 0x8a4207c8c8cfc80eull,
		0xcf638aacac26ac09ull, 0xf1a35552520752aaull, 0x45218d6464e96407ull, 0x6070401010501080ull,
		0xda0a67d0d0b7d0ceull, 0xec3543d9d99ad986ull, 0x6a794c13135f1398ull, 0x2824300c0c3c0c60ull,
		0x6c7e4812125a1290ull, 0xf6dfa429298d2955ull, 0xfbaa5951510851b2ull, 0xb108deb9b967b9a1ull,
		0x98571bcfcfd4cf36ull, 0xce187fd6d6a9d6feull, 0x3744d17373a273bfull, 0x09840e8d8d838d1cull,
		0x21a03e8181bf817cull, 0xe5b14d545419549aull, 0xba7a27c0c0e7c04eull, 0x54b993eded7eed3bull,
		0xb9f7254e4e6b4e4aull, 0x85c10d444449441aull, 0xf552a6a7a701a751ull, 0xfcd6a82a2a822a4dull,
		0x39bc2e8585ab855cull, 0xdefb942525b12535ull, 0x6e88bfe6e659e663ull, 0x864c0fcacac5ca1eull,
		0x1569ed7c7c917cc7ull, 0x1d96168b8b9d8b2cull, 0xe9bf45565613568aull, 0x27a73a8080ba8074ull
	},
	{
		0x501fceced1ce3e9eull, 0x06d6bbbb6dbbb1bdull, 0xab8bebeb60eb0b40ull, 0xd9729292e092e44bull,
		0xac8feaea65ea0346ull, 0x4b0bcbcbc0cb1680ull, 0x794c13135f13986aull, 0x7d23c1c1e2c146bcull,
		0xa583e9e96ae91b4cull, 0xa6e83a3ad23acd9cull, 0x187fd6d6a9d6feceull, 0x39f2b2b240b2f98bull,
		0x046fd2d2bdd2ded6ull, 0xd77a9090ea90f447ull, 0x655c17174b17b872ull, 0xd2c7f8f83ff8932aull,
		0xd315424257422a91ull, 0x6b5415154115a87eull, 0xbf45565613568ae9ull, 0x2beab4b45eb4c99full,
		0x26896565ec650f43ull, 0x54701c1c6c1ce048ull, 0x9f1a888892883417ull, 0xd411434352432297ull,
		0x6133c5c5f6c566a4ull, 0x896d5c5c315cdad5ull, 0x82d83636ee36adb4ull, 0x01d2baba68bab9bbull,
		0xf1f3f5f506f5fb04ull, 0xb8415757165782efull, 0x28816767e6671f4full, 0x840e8d8d838d1c09ull,
		0x97c43131f53195a6ull, 0xf8fff6f609f6e30eull, 0x218d6464e9640745ull, 0x957d58582558facdull,
		0xfd429e9edc9e8463ull, 0xf6f7f4f403f4f302ull, 0xee882222aa220dccull, 0x7192aaaa38aa39dbull,
		0x56c97575bc758f23ull, 0x2d3c0f0f330f7822ull, 0x0e0802020a02100cull, 0x30feb1b14fb1e181ull,
		0x275bdfdf84dfb6f8ull, 0x1ea96d6dc46d4f73ull, 0x44d17373a273bf37ull, 0xfe294d4d644d52b3ull,
		0x69ed7c7c917cc715ull, 0xf2982626be262dd4ull, 0xcab82e2e962e6de4ull, 0xfffbf7f70cf7eb08ull,
		0x3820080828084030ull, 0x8e695d5d345dd2d3ull, 0xc10d444449441a85ull, 0xbaf83e3ec63eed84ull,
		0xfa469f9fd99f8c65ull, 0x6c5014144414a078ull, 0x4207c8c8cfc80e8aull, 0x6d82aeae2cae19c3ull,
		0xb14d545419549ae5ull, 0x7040101050108060ull, 0x3247d8d89fd88eeaull, 0x13cabcbc76bc89afull,
		0x46681a1a721ad05cull, 0x0cb16b6bda6b7f67ull, 0x02b96969d0696f6bull, 0xe3ebf3f318f3cb10ull,
		0x14cebdbd73bd81a9ull, 0x99cc3333ff3385aaull, 0x7696abab3dab31ddull, 0xdccffafa35fa8326ull,
		0x0d63d1d1b2d1c6dcull, 0xe6569b9bcd9bac7dull, 0x05bd6868d568676dull, 0xf7254e4e6b4e4ab9ull,
		0x625816164e16b074ull, 0xcc6e9595fb95dc59ull, 0xd07e9191ef91fc41ull, 0xb09feeee71ee235eull,
		0xf92d4c4c614c5ab5ull, 0x34916363f2633f57ull, 0x8d028e8e8c8e0403ull, 0x9c715b5b2a5be2c7ull,
		0x5e17ccccdbcc2e92ull, 0xb4f03c3ccc3cfd88ull, 0x4f6419197d19c856ull, 0x40bea1a11fa161e1ull,
		0xa03e8181bf817c21ull, 0xe2394949704972abull, 0x7cf17b7b8a7bff07ull, 0x3543d9d99ad986ecull,
		0x10a16f6fce6f5f7full, 0x85dc3737eb37a5b2ull, 0x3d9d6060fd60275dull, 0x4c0fcacac5ca1e86ull,
		0x8fbbe7e75ce76b68ull, 0xd1ac2b2b872b45faull, 0xe53d484875487aadull, 0xc9d3fdfd2efdbb34ull,
		0xc5629696f496c453ull, 0xc60945454c451283ull, 0xced7fcfc2bfcb332ull, 0xda1941415841329bull,
		0x7e4812125a12906cull, 0x23340d0d390d682eull, 0x72f979798079ef0bull, 0x81b3e5e556e57b64ull,
		0x981e898997893c11ull, 0x830a8c8c868c140full, 0x93abe3e348e34b70ull, 0xe0802020a0201dc0ull,
		0x90c03030f0309da0ull, 0x2e57dcdc8bdcaef2ull, 0x22e6b7b751b7d195ull, 0x19ad6c6cc16c4775ull,
		0xeb354a4a7f4a6aa1ull, 0x2ceeb5b55bb5c199ull, 0xbdfc3f3fc33fe582ull, 0xc2669797f197cc55ull,
		0x1677d4d4a3d4eec2ull, 0x33956262f7623751ull, 0xc3b42d2d992d75eeull, 0x121806061e063014ull,
		0x5baaa4a40ea449ffull, 0x5caea5a50ba541f9ull, 0xae368383b5836c2dull, 0x80615f5f3e5fc2dfull,
		0xd6a82a2a822a4dfcull, 0x3c4fdada95da9ee6ull, 0x4503c9c9cac9068cull, 0x0000000000000000ull,
		0x67e57e7e9b7ed719ull, 0x49b2a2a210a279ebull, 0xb64955551c5592e3ull, 0x1ac6bfbf79bf91a5ull,
		0x7744111155118866ull, 0x1173d5d5a6d5e6c4ull, 0xf34a9c9cd69c946full, 0x571bcfcfd4cf3698ull,
		0x2a380e0e360e7024ull, 0x36280a0a220a503cull, 0xb3f43d3dc93df58eull, 0xaa5951510851b2fbull,
		0x6ee97d7d947dcf13ull, 0xde769393e593ec4dull, 0x416c1b1b771bd85aull, 0xc0dffefe21fea33eull,
		0x6637c4c4f3c46ea2ull, 0xc80147474647028full, 0x3f2409092d094836ull, 0xb5228686a4864433ull,
		0x312c0b0b270b583aull, 0x8a068f8f898f0c05ull, 0xf44e9d9dd39d9c69ull, 0x0bb56a6adf6a7761ull,
		0x151c07071b073812ull, 0x08deb9b967b9a1b1ull, 0x37fab0b04ab0e987ull, 0xef5a9898c298b477ull,
		0x486018187818c050ull, 0x9ec83232fa328dacull, 0x4ad97171a871af3bull, 0xec314b4b7a4b62a7ull,
		0xb79befef74ef2b58ull, 0xa1ec3b3bd73bc59aull, 0x4ddd7070ad70a73dull, 0x47baa0a01aa069e7ull,
		0x86b7e4e453e47362ull, 0xdd1d40405d403a9dull, 0xc7dbffff24ffab38ull, 0x732bc3c3e8c356b0ull,
		0x789ea9a937a921d1ull, 0x88bfe6e659e6636eull, 0x75fd78788578e70dull, 0xd5c3f9f93af99b2cull,
		0x96168b8b9d8b2c1dull, 0xcf05464643460a89ull, 0xa73a8080ba807427ull, 0x5a781e1e661ef044ull,
		0xa8e03838d838dd90ull, 0x9da3e1e142e15b7cull, 0x0fdab8b862b8a9b7ull, 0x7f9aa8a832a829d7ull,
		0x9aa7e0e047e0537aull, 0x24300c0c3c0c6028ull, 0xe98c2323af2305caull, 0x5fc57676b3769729ull,
		0x53741d1d691de84eull, 0xfb942525b12535deull, 0xfc902424b4243dd8ull, 0x1b1405051105281eull,
		0xede3f1f112f1db1cull, 0x17a56e6ecb6e5779ull, 0xcb6a9494fe94d45full, 0xd8a0282888285df0ull,
		0xe1529a9ac89aa47bull, 0xbb2a8484ae84543full, 0xa287e8e86fe8134aull, 0x4eb6a3a315a371edull,
		0xf0214f4f6e4f42bfull, 0x58c17777b6779f2full, 0x036bd3d3b8d3d6d0ull, 0xbc2e8585ab855c39ull,
		0x94afe2e24de24376ull, 0xa35552520752aaf1ull, 0xe4eff2f21df2c316ull, 0xa9328282b082642bull,
		0xad5d50500d50bafdull, 0x7bf57a7a8f7af701ull, 0xcdbc2f2f932f65e2ull, 0x51cd7474b9748725ull,
		0xa45153530253a2f7ull, 0x3ef6b3b345b3f18dull, 0x3a996161f8612f5bull, 0x6a86afaf29af11c5ull,
		0xafe43939dd39d596ull, 0x8bd43535e135b5beull, 0x205fdede81debefeull, 0x5913cdcddecd2694ull,
		0x5d7c1f1f631ff842ull, 0xe85e9999c799bc71ull, 0x638aacac26ac09cfull, 0x648eadad23ad01c9ull,
		0x43d57272a772b731ull, 0xc4b02c2c9c2c7de8ull, 0x2953dddd8edda6f4ull, 0x0a67d0d0b7d0cedaull,
		0xb2268787a1874c35ull, 0x1dc2bebe7cbe99a3ull, 0x87655e5e3b5ecad9ull, 0x55a2a6a604a659f3ull,
		0xbe97ecec7bec3352ull, 0x1c10040414042018ull, 0x683fc6c6f9c67eaeull, 0x090c03030f03180aull,
		0x8cd03434e434bdb8ull, 0xdbcbfbfb30fb8b20ull, 0x3b4bdbdb90db96e0ull, 0x927959592059f2cbull,
		0x25e2b6b654b6d993ull, 0x742fc2c2edc25eb6ull, 0x0704010105010806ull, 0xeae7f0f017f0d31aull,
		0x9b755a5a2f5aeac1ull, 0xb993eded7eed3b54ull, 0x52a6a7a701a751f5ull, 0x2f856666e3661749ull,
		0xe7842121a52115c6ull, 0x60e17f7f9e7fdf1full, 0x91128a8a988a241bull, 0xf59c2727bb2725d2ull,
		0x6f3bc7c7fcc776a8ull, 0x7a27c0c0e7c04ebaull, 0xdfa429298d2955f6ull, 0x1f7bd7d7acd7f6c8ull
	},
	{
		0x769393e593ec4ddeull, 0x43d9d99ad986ec35ull, 0x529a9ac89aa47be1ull, 0xeeb5b55bb5c1992cull,
		0x5a9898c298b477efull, 0x882222aa220dcceeull, 0x0945454c451283c6ull, 0xd7fcfc2bfcb332ceull,
		0xd2baba68bab9bb01ull, 0xb56a6adf6a77610bull, 0x5bdfdf84dfb6f827ull, 0x0802020a02100c0eull,
		0x469f9fd99f8c65faull, 0x57dcdc8bdcaef22eull, 0x5951510851b2fbaaull, 0x7959592059f2cb92ull,
		0x354a4a7f4a6aa1ebull, 0x5c17174b17b87265ull, 0xac2b2b872b45fad1ull, 0x2fc2c2edc25eb674ull,
		0x6a9494fe94d45fcbull, 0xf7f4f403f4f302f6ull, 0xd6bbbb6dbbb1bd06ull, 0xb6a3a315a371ed4eull,
		0x956262f762375133ull, 0xb7e4e453e4736286ull, 0xd97171a871af3b4aull, 0x77d4d4a3d4eec216ull,
		0x13cdcddecd269459ull, 0xdd7070ad70a73d4dull, 0x5816164e16b07462ull, 0xa3e1e142e15b7c9dull,
		0x394949704972abe2ull, 0xf03c3ccc3cfd88b4ull, 0x27c0c0e7c04eba7aull, 0x47d8d89fd88eea32ull,
		0x6d5c5c315cdad589ull, 0x569b9bcd9bac7de6ull, 0x8eadad23ad01c964ull, 0x2e8585ab855c39bcull,
		0x5153530253a2f7a4ull, 0xbea1a11fa161e140ull, 0xf57a7a8f7af7017bull, 0x07c8c8cfc80e8a42ull,
		0xb42d2d992d75eec3ull, 0xa7e0e047e0537a9aull, 0x63d1d1b2d1c6dc0dull, 0xd57272a772b73143ull,
		0xa2a6a604a659f355ull, 0xb02c2c9c2c7de8c4ull, 0x37c4c4f3c46ea266ull, 0xabe3e348e34b7093ull,
		0xc57676b37697295full, 0xfd78788578e70d75ull, 0xe6b7b751b7d19522ull, 0xeab4b45eb4c99f2bull,
		0x2409092d0948363full, 0xec3b3bd73bc59aa1ull, 0x380e0e360e70242aull, 0x1941415841329bdaull,
		0x2d4c4c614c5ab5f9ull, 0x5fdede81debefe20ull, 0xf2b2b240b2f98b39ull, 0x7a9090ea90f447d7ull,
		0x942525b12535defbull, 0xaea5a50ba541f95cull, 0x7bd7d7acd7f6c81full, 0x0c03030f03180a09ull,
		0x4411115511886677ull, 0x0000000000000000ull, 0x2bc3c3e8c356b073ull, 0xb82e2e962e6de4caull,
		0x729292e092e44bd9ull, 0x9befef74ef2b58b7ull, 0x254e4e6b4e4ab9f7ull, 0x4812125a12906c7eull,
		0x4e9d9dd39d9c69f4ull, 0xe97d7d947dcf136eull, 0x0bcbcbc0cb16804bull, 0xd43535e135b5be8bull,
		0x4010105010806070ull, 0x73d5d5a6d5e6c411ull, 0x214f4f6e4f42bff0ull, 0x429e9edc9e8463fdull,
		0x294d4d644d52b3feull, 0x9ea9a937a921d178ull, 0x4955551c5592e3b6ull, 0x3fc6c6f9c67eae68ull,
		0x67d0d0b7d0ceda0aull, 0xf17b7b8a7bff077cull, 0x6018187818c05048ull, 0x669797f197cc55c2ull,
		0x6bd3d3b8d3d6d003ull, 0xd83636ee36adb482ull, 0xbfe6e659e6636e88ull, 0x3d484875487aade5ull,
		0x45565613568ae9bfull, 0x3e8181bf817c21a0ull, 0x068f8f898f0c058aull, 0xc17777b6779f2f58ull,
		0x17ccccdbcc2e925eull, 0x4a9c9cd69c946ff3ull, 0xdeb9b967b9a1b108ull, 0xafe2e24de2437694ull,
		0x8aacac26ac09cf63ull, 0xdab8b862b8a9b70full, 0xbc2f2f932f65e2cdull, 0x5415154115a87e6bull,
		0xaaa4a40ea449ff5bull, 0xed7c7c917cc71569ull, 0x4fdada95da9ee63cull, 0xe03838d838dd90a8ull,
		0x781e1e661ef0445aull, 0x2c0b0b270b583a31ull, 0x1405051105281e1bull, 0x7fd6d6a9d6fece18ull,
		0x5014144414a0786cull, 0xa56e6ecb6e577917ull, 0xad6c6cc16c477519ull, 0xe57e7e9b7ed71967ull,
		0x856666e36617492full, 0xd3fdfd2efdbb34c9ull, 0xfeb1b14fb1e18130ull, 0xb3e5e556e57b6481ull,
		0x9d6060fd60275d3dull, 0x86afaf29af11c56aull, 0x655e5e3b5ecad987ull, 0xcc3333ff3385aa99ull,
		0x268787a1874c35b2ull, 0x03c9c9cac9068c45ull, 0xe7f0f017f0d31aeaull, 0x695d5d345dd2d38eull,
		0xa96d6dc46d4f731eull, 0xfc3f3fc33fe582bdull, 0x1a8888928834179full, 0x0e8d8d838d1c0984ull,
		0x3bc7c7fcc776a86full, 0xfbf7f70cf7eb08ffull, 0x741d1d691de84e53ull, 0x83e9e96ae91b4ca5ull,
		0x97ecec7bec3352beull, 0x93eded7eed3b54b9ull, 0x3a8080ba807427a7ull, 0xa429298d2955f6dfull,
		0x9c2727bb2725d2f5ull, 0x1bcfcfd4cf369857ull, 0x5e9999c799bc71e8ull, 0x9aa8a832a829d77full,
		0x5d50500d50bafdadull, 0x3c0f0f330f78222dull, 0xdc3737eb37a5b285ull, 0x902424b4243dd8fcull,
		0xa0282888285df0d8ull, 0xc03030f0309da090ull, 0x6e9595fb95dc59ccull, 0x6fd2d2bdd2ded604ull,
		0xf83e3ec63eed84baull, 0x715b5b2a5be2c79cull, 0x1d40405d403a9dddull, 0x368383b5836c2daeull,
		0xf6b3b345b3f18d3eull, 0xb96969d0696f6b02ull, 0x415757165782efb8ull, 0x7c1f1f631ff8425dull,
		0x1c07071b07381215ull, 0x701c1c6c1ce04854ull, 0x128a8a988a241b91ull, 0xcabcbc76bc89af13ull,
		0x802020a0201dc0e0ull, 0x8bebeb60eb0b40abull, 0x1fceced1ce3e9e50ull, 0x028e8e8c8e04038dull,
		0x96abab3dab31dd76ull, 0x9feeee71ee235eb0ull, 0xc43131f53195a697ull, 0xb2a2a210a279eb49ull,
		0xd17373a273bf3744ull, 0xc3f9f93af99b2cd5ull, 0x0fcacac5ca1e864cull, 0xe83a3ad23acd9ca6ull,
		0x681a1a721ad05c46ull, 0xcbfbfb30fb8b20dbull, 0x340d0d390d682e23ull, 0x23c1c1e2c146bc7dull,
		0xdffefe21fea33ec0ull, 0xcffafa35fa8326dcull, 0xeff2f21df2c316e4ull, 0xa16f6fce6f5f7f10ull,
		0xcebdbd73bd81a914ull, 0x629696f496c453c5ull, 0x53dddd8edda6f429ull, 0x11434352432297d4ull,
		0x5552520752aaf1a3ull, 0xe2b6b654b6d99325ull, 0x2008082808403038ull, 0xebf3f318f3cb10e3ull,
		0x82aeae2cae19c36dull, 0xc2bebe7cbe99a31dull, 0x6419197d19c8564full, 0x1e898997893c1198ull,
		0xc83232fa328dac9eull, 0x982626be262dd4f2ull, 0xfab0b04ab0e98737ull, 0x8feaea65ea0346acull,
		0x314b4b7a4b62a7ecull, 0x8d6464e964074521ull, 0x2a8484ae84543fbbull, 0x328282b082642ba9ull,
		0xb16b6bda6b7f670cull, 0xf3f5f506f5fb04f1ull, 0xf979798079ef0b72ull, 0xc6bfbf79bf91a51aull,
		0x0401010501080607ull, 0x615f5f3e5fc2df80ull, 0xc97575bc758f2356ull, 0x916363f2633f5734ull,
		0x6c1b1b771bd85a41ull, 0x8c2323af2305cae9ull, 0xf43d3dc93df58eb3ull, 0xbd6868d568676d05ull,
		0xa82a2a822a4dfcd6ull, 0x896565ec650f4326ull, 0x87e8e86fe8134aa2ull, 0x7e9191ef91fc41d0ull,
		0xfff6f609f6e30ef8ull, 0xdbffff24ffab38c7ull, 0x4c13135f13986a79ull, 0x7d58582558facd95ull,
		0xe3f1f112f1db1cedull, 0x0147474647028fc8ull, 0x280a0a220a503c36ull, 0xe17f7f9e7fdf1f60ull,
		0x33c5c5f6c566a461ull, 0xa6a7a701a751f552ull, 0xbbe7e75ce76b688full, 0x996161f8612f5b3aull,
		0x755a5a2f5aeac19bull, 0x1806061e06301412ull, 0x05464643460a89cfull, 0x0d444449441a85c1ull,
		0x15424257422a91d3ull, 0x100404140420181cull, 0xbaa0a01aa069e747ull, 0x4bdbdb90db96e03bull,
		0xe43939dd39d596afull, 0x228686a4864433b5ull, 0x4d545419549ae5b1ull, 0x92aaaa38aa39db71ull,
		0x0a8c8c868c140f83ull, 0xd03434e434bdb88cull, 0x842121a52115c6e7ull, 0x168b8b9d8b2c1d96ull,
		0xc7f8f83ff8932ad2ull, 0x300c0c3c0c602824ull, 0xcd7474b974872551ull, 0x816767e6671f4f28ull
	},
	{
		0x6868d568676d05bdull, 0x8d8d838d1c09840eull, 0xcacac5ca1e864c0full, 0x4d4d644d52b3fe29ull,
		0x7373a273bf3744d1ull, 0x4b4b7a4b62a7ec31ull, 0x4e4e6b4e4ab9f725ull, 0x2a2a822a4dfcd6a8ull,
		0xd4d4a3d4eec21677ull, 0x52520752aaf1a355ull, 0x2626be262dd4f298ull, 0xb3b345b3f18d3ef6ull,
		0x545419549ae5b14dull, 0x1e1e661ef0445a78ull, 0x19197d19c8564f64ull, 0x1f1f631ff8425d7cull,
		0x2222aa220dccee88ull, 0x03030f03180a090cull, 0x464643460a89cf05ull, 0x3d3dc93df58eb3f4ull,
		0x2d2d992d75eec3b4ull, 0x4a4a7f4a6aa1eb35ull, 0x53530253a2f7a451ull, 0x8383b5836c2dae36ull,
		0x13135f13986a794cull, 0x8a8a988a241b9112ull, 0xb7b751b7d19522e6ull, 0xd5d5a6d5e6c41173ull,
		0x2525b12535defb94ull, 0x79798079ef0b72f9ull, 0xf5f506f5fb04f1f3ull, 0xbdbd73bd81a914ceull,
		0x58582558facd957dull, 0x2f2f932f65e2cdbcull, 0x0d0d390d682e2334ull, 0x02020a02100c0e08ull,
		0xeded7eed3b54b993ull, 0x51510851b2fbaa59ull, 0x9e9edc9e8463fd42ull, 0x1111551188667744ull,
		0xf2f21df2c316e4efull, 0x3e3ec63eed84baf8ull, 0x55551c5592e3b649ull, 0x5e5e3b5ecad98765ull,
		0xd1d1b2d1c6dc0d63ull, 0x16164e16b0746258ull, 0x3c3ccc3cfd88b4f0ull, 0x6666e36617492f85ull,
		0x7070ad70a73d4dddull, 0x5d5d345dd2d38e69ull, 0xf3f318f3cb10e3ebull, 0x45454c451283c609ull,
		0x40405d403a9ddd1dull, 0xccccdbcc2e925e17ull, 0xe8e86fe8134aa287ull, 0x9494fe94d45fcb6aull,
		0x565613568ae9bf45ull, 0x0808280840303820ull, 0xceced1ce3e9e501full, 0x1a1a721ad05c4668ull,
		0x3a3ad23acd9ca6e8ull, 0xd2d2bdd2ded6046full, 0xe1e142e15b7c9da3ull, 0xdfdf84dfb6f8275bull,
		0xb5b55bb5c1992ceeull, 0x3838d838dd90a8e0ull, 0x6e6ecb6e577917a5ull, 0x0e0e360e70242a38ull,
		0xe5e556e57b6481b3ull, 0xf4f403f4f302f6f7ull, 0xf9f93af99b2cd5c3ull, 0x8686a4864433b522ull,
		0xe9e96ae91b4ca583ull, 0x4f4f6e4f42bff021ull, 0xd6d6a9d6fece187full, 0x8585ab855c39bc2eull,
		0x2323af2305cae98cull, 0xcfcfd4cf3698571bull, 0x3232fa328dac9ec8ull, 0x9999c799bc71e85eull,
		0x3131f53195a697c4ull, 0x14144414a0786c50ull, 0xaeae2cae19c36d82ull, 0xeeee71ee235eb09full,
		0xc8c8cfc80e8a4207ull, 0x484875487aade53dull, 0xd3d3b8d3d6d0036bull, 0x3030f0309da090c0ull,
		0xa1a11fa161e140beull, 0x9292e092e44bd972ull, 0x41415841329bda19ull, 0xb1b14fb1e18130feull,
		0x18187818c0504860ull, 0xc4c4f3c46ea26637ull, 0x2c2c9c2c7de8c4b0ull, 0x7171a871af3b4ad9ull,
		0x7272a772b73143d5ull, 0x444449441a85c10dull, 0x15154115a87e6b54ull, 0xfdfd2efdbb34c9d3ull,
		0x3737eb37a5b285dcull, 0xbebe7cbe99a31dc2ull, 0x5f5f3e5fc2df8061ull, 0xaaaa38aa39db7192ull,
		0x9b9bcd9bac7de656ull, 0x8888928834179f1aull, 0xd8d89fd88eea3247ull, 0xabab3dab31dd7696ull,
		0x898997893c11981eull, 0x9c9cd69c946ff34aull, 0xfafa35fa8326dccfull, 0x6060fd60275d3d9dull,
		0xeaea65ea0346ac8full, 0xbcbc76bc89af13caull, 0x6262f76237513395ull, 0x0c0c3c0c60282430ull,
		0x2424b4243dd8fc90ull, 0xa6a604a659f355a2ull, 0xa8a832a829d77f9aull, 0xecec7bec3352be97ull,
		0x6767e6671f4f2881ull, 0x2020a0201dc0e080ull, 0xdbdb90db96e03b4bull, 0x7c7c917cc71569edull,
		0x282888285df0d8a0ull, 0xdddd8edda6f42953ull, 0xacac26ac09cf638aull, 0x5b5b2a5be2c79c71ull,
		0x3434e434bdb88cd0ull, 0x7e7e9b7ed71967e5ull, 0x1010501080607040ull, 0xf1f112f1db1cede3ull,
		0x7b7b8a7bff077cf1ull, 0x8f8f898f0c058a06ull, 0x6363f2633f573491ull, 0xa0a01aa069e747baull,
		0x05051105281e1b14ull, 0x9a9ac89aa47be152ull, 0x434352432297d411ull, 0x7777b6779f2f58c1ull,
		0x2121a52115c6e784ull, 0xbfbf79bf91a51ac6ull, 0x2727bb2725d2f59cull, 0x09092d0948363f24ull,
		0xc3c3e8c356b0732bull, 0x9f9fd99f8c65fa46ull, 0xb6b654b6d99325e2ull, 0xd7d7acd7f6c81f7bull,
		0x29298d2955f6dfa4ull, 0xc2c2edc25eb6742full, 0xebeb60eb0b40ab8bull, 0xc0c0e7c04eba7a27ull,
		0xa4a40ea449ff5baaull, 0x8b8b9d8b2c1d9616ull, 0x8c8c868c140f830aull, 0x1d1d691de84e5374ull,
		0xfbfb30fb8b20dbcbull, 0xffff24ffab38c7dbull, 0xc1c1e2c146bc7d23ull, 0xb2b240b2f98b39f2ull,
		0x9797f197cc55c266ull, 0x2e2e962e6de4cab8ull, 0xf8f83ff8932ad2c7ull, 0x6565ec650f432689ull,
		0xf6f609f6e30ef8ffull, 0x7575bc758f2356c9ull, 0x07071b073812151cull, 0x0404140420181c10ull,
		0x4949704972abe239ull, 0x3333ff3385aa99ccull, 0xe4e453e4736286b7ull, 0xd9d99ad986ec3543ull,
		0xb9b967b9a1b108deull, 0xd0d0b7d0ceda0a67ull, 0x424257422a91d315ull, 0xc7c7fcc776a86f3bull,
		0x6c6cc16c477519adull, 0x9090ea90f447d77aull, 0x0000000000000000ull, 0x8e8e8c8e04038d02ull,
		0x6f6fce6f5f7f10a1ull, 0x50500d50bafdad5dull, 0x0101050108060704ull, 0xc5c5f6c566a46133ull,
		0xdada95da9ee63c4full, 0x47474647028fc801ull, 0x3f3fc33fe582bdfcull, 0xcdcddecd26945913ull,
		0x6969d0696f6b02b9ull, 0xa2a210a279eb49b2ull, 0xe2e24de2437694afull, 0x7a7a8f7af7017bf5ull,
		0xa7a701a751f552a6ull, 0xc6c6f9c67eae683full, 0x9393e593ec4dde76ull, 0x0f0f330f78222d3cull,
		0x0a0a220a503c3628ull, 0x06061e0630141218ull, 0xe6e659e6636e88bfull, 0x2b2b872b45fad1acull,
		0x9696f496c453c562ull, 0xa3a315a371ed4eb6ull, 0x1c1c6c1ce0485470ull, 0xafaf29af11c56a86ull,
		0x6a6adf6a77610bb5ull, 0x12125a12906c7e48ull, 0x8484ae84543fbb2aull, 0x3939dd39d596afe4ull,
		0xe7e75ce76b688fbbull, 0xb0b04ab0e98737faull, 0x8282b082642ba932ull, 0xf7f70cf7eb08fffbull,
		0xfefe21fea33ec0dfull, 0x9d9dd39d9c69f44eull, 0x8787a1874c35b226ull, 0x5c5c315cdad5896dull,
		0x8181bf817c21a03eull, 0x3535e135b5be8bd4ull, 0xdede81debefe205full, 0xb4b45eb4c99f2beaull,
		0xa5a50ba541f95caeull, 0xfcfc2bfcb332ced7ull, 0x8080ba807427a73aull, 0xefef74ef2b58b79bull,
		0xcbcbc0cb16804b0bull, 0xbbbb6dbbb1bd06d6ull, 0x6b6bda6b7f670cb1ull, 0x7676b37697295fc5ull,
		0xbaba68bab9bb01d2ull, 0x5a5a2f5aeac19b75ull, 0x7d7d947dcf136ee9ull, 0x78788578e70d75fdull,
		0x0b0b270b583a312cull, 0x9595fb95dc59cc6eull, 0xe3e348e34b7093abull, 0xadad23ad01c9648eull,
		0x7474b974872551cdull, 0x9898c298b477ef5aull, 0x3b3bd73bc59aa1ecull, 0x3636ee36adb482d8ull,
		0x6464e9640745218dull, 0x6d6dc46d4f731ea9ull, 0xdcdc8bdcaef22e57ull, 0xf0f017f0d31aeae7ull,
		0x59592059f2cb9279ull, 0xa9a937a921d1789eull, 0x4c4c614c5ab5f92dull, 0x17174b17b872655cull,
		0x7f7f9e7fdf1f60e1ull, 0x9191ef91fc41d07eull, 0xb8b862b8a9b70fdaull, 0xc9c9cac9068c4503ull,
		0x5757165782efb841ull, 0x1b1b771bd85a416cull, 0xe0e047e0537a9aa7ull, 0x6161f8612f5b3a99ull
	}
};

} // namespace detail

} // namespace digestpp

#endif