// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// Register Top module auto-generated by `reggen`

`include "prim_assert.sv"

module keymgr_reg_top (
  input clk_i,
  input rst_ni,

  input  tlul_pkg::tl_h2d_t tl_i,
  output tlul_pkg::tl_d2h_t tl_o,
  // To HW
  output keymgr_reg_pkg::keymgr_reg2hw_t reg2hw, // Write
  input  keymgr_reg_pkg::keymgr_hw2reg_t hw2reg, // Read

  // Integrity check errors
  output logic intg_err_o,

  // Config
  input devmode_i // If 1, explicit error return for unmapped register access
);

  import keymgr_reg_pkg::* ;

  localparam int AW = 8;
  localparam int DW = 32;
  localparam int DBW = DW/8;                    // Byte Width

  // register signals
  logic           reg_we;
  logic           reg_re;
  logic [AW-1:0]  reg_addr;
  logic [DW-1:0]  reg_wdata;
  logic [DBW-1:0] reg_be;
  logic [DW-1:0]  reg_rdata;
  logic           reg_error;

  logic          addrmiss, wr_err;

  logic [DW-1:0] reg_rdata_next;

  tlul_pkg::tl_h2d_t tl_reg_h2d;
  tlul_pkg::tl_d2h_t tl_reg_d2h;

  // incoming payload check
  logic intg_err;
  tlul_cmd_intg_chk u_chk (
    .tl_i,
    .err_o(intg_err)
  );

  logic intg_err_q;
  always_ff @(posedge clk_i or negedge rst_ni) begin
    if (!rst_ni) begin
      intg_err_q <= '0;
    end else if (intg_err) begin
      intg_err_q <= 1'b1;
    end
  end

  // integrity error output is permanent and should be used for alert generation
  // register errors are transactional
  assign intg_err_o = intg_err_q | intg_err;

  // outgoing integrity generation
  tlul_pkg::tl_d2h_t tl_o_pre;
  tlul_rsp_intg_gen u_rsp_intg_gen (
    .tl_i(tl_o_pre),
    .tl_o
  );

  assign tl_reg_h2d = tl_i;
  assign tl_o_pre   = tl_reg_d2h;

  tlul_adapter_reg #(
    .RegAw(AW),
    .RegDw(DW)
  ) u_reg_if (
    .clk_i,
    .rst_ni,

    .tl_i (tl_reg_h2d),
    .tl_o (tl_reg_d2h),

    .we_o    (reg_we),
    .re_o    (reg_re),
    .addr_o  (reg_addr),
    .wdata_o (reg_wdata),
    .be_o    (reg_be),
    .rdata_i (reg_rdata),
    .error_i (reg_error)
  );

  assign reg_rdata = reg_rdata_next ;
  assign reg_error = (devmode_i & addrmiss) | wr_err | intg_err;

  // Define SW related signals
  // Format: <reg>_<field>_{wd|we|qs}
  //        or <reg>_{wd|we|qs} if field == 1 or 0
  logic intr_state_qs;
  logic intr_state_wd;
  logic intr_state_we;
  logic intr_enable_qs;
  logic intr_enable_wd;
  logic intr_enable_we;
  logic intr_test_wd;
  logic intr_test_we;
  logic alert_test_fatal_fault_err_wd;
  logic alert_test_fatal_fault_err_we;
  logic alert_test_recov_operation_err_wd;
  logic alert_test_recov_operation_err_we;
  logic cfg_regwen_qs;
  logic cfg_regwen_re;
  logic control_start_qs;
  logic control_start_wd;
  logic control_start_we;
  logic [2:0] control_operation_qs;
  logic [2:0] control_operation_wd;
  logic control_operation_we;
  logic [1:0] control_dest_sel_qs;
  logic [1:0] control_dest_sel_wd;
  logic control_dest_sel_we;
  logic sideload_clear_qs;
  logic sideload_clear_wd;
  logic sideload_clear_we;
  logic [15:0] reseed_interval_qs;
  logic [15:0] reseed_interval_wd;
  logic reseed_interval_we;
  logic sw_binding_regwen_qs;
  logic sw_binding_regwen_wd;
  logic sw_binding_regwen_we;
  logic sw_binding_regwen_re;
  logic [31:0] sw_binding_0_qs;
  logic [31:0] sw_binding_0_wd;
  logic sw_binding_0_we;
  logic [31:0] sw_binding_1_qs;
  logic [31:0] sw_binding_1_wd;
  logic sw_binding_1_we;
  logic [31:0] sw_binding_2_qs;
  logic [31:0] sw_binding_2_wd;
  logic sw_binding_2_we;
  logic [31:0] sw_binding_3_qs;
  logic [31:0] sw_binding_3_wd;
  logic sw_binding_3_we;
  logic [31:0] sw_binding_4_qs;
  logic [31:0] sw_binding_4_wd;
  logic sw_binding_4_we;
  logic [31:0] sw_binding_5_qs;
  logic [31:0] sw_binding_5_wd;
  logic sw_binding_5_we;
  logic [31:0] sw_binding_6_qs;
  logic [31:0] sw_binding_6_wd;
  logic sw_binding_6_we;
  logic [31:0] sw_binding_7_qs;
  logic [31:0] sw_binding_7_wd;
  logic sw_binding_7_we;
  logic [31:0] salt_0_qs;
  logic [31:0] salt_0_wd;
  logic salt_0_we;
  logic [31:0] salt_1_qs;
  logic [31:0] salt_1_wd;
  logic salt_1_we;
  logic [31:0] salt_2_qs;
  logic [31:0] salt_2_wd;
  logic salt_2_we;
  logic [31:0] salt_3_qs;
  logic [31:0] salt_3_wd;
  logic salt_3_we;
  logic [31:0] salt_4_qs;
  logic [31:0] salt_4_wd;
  logic salt_4_we;
  logic [31:0] salt_5_qs;
  logic [31:0] salt_5_wd;
  logic salt_5_we;
  logic [31:0] salt_6_qs;
  logic [31:0] salt_6_wd;
  logic salt_6_we;
  logic [31:0] salt_7_qs;
  logic [31:0] salt_7_wd;
  logic salt_7_we;
  logic [31:0] key_version_qs;
  logic [31:0] key_version_wd;
  logic key_version_we;
  logic max_creator_key_ver_regwen_qs;
  logic max_creator_key_ver_regwen_wd;
  logic max_creator_key_ver_regwen_we;
  logic [31:0] max_creator_key_ver_qs;
  logic [31:0] max_creator_key_ver_wd;
  logic max_creator_key_ver_we;
  logic max_owner_int_key_ver_regwen_qs;
  logic max_owner_int_key_ver_regwen_wd;
  logic max_owner_int_key_ver_regwen_we;
  logic [31:0] max_owner_int_key_ver_qs;
  logic [31:0] max_owner_int_key_ver_wd;
  logic max_owner_int_key_ver_we;
  logic max_owner_key_ver_regwen_qs;
  logic max_owner_key_ver_regwen_wd;
  logic max_owner_key_ver_regwen_we;
  logic [31:0] max_owner_key_ver_qs;
  logic [31:0] max_owner_key_ver_wd;
  logic max_owner_key_ver_we;
  logic [31:0] sw_share0_output_0_qs;
  logic [31:0] sw_share0_output_0_wd;
  logic sw_share0_output_0_we;
  logic [31:0] sw_share0_output_1_qs;
  logic [31:0] sw_share0_output_1_wd;
  logic sw_share0_output_1_we;
  logic [31:0] sw_share0_output_2_qs;
  logic [31:0] sw_share0_output_2_wd;
  logic sw_share0_output_2_we;
  logic [31:0] sw_share0_output_3_qs;
  logic [31:0] sw_share0_output_3_wd;
  logic sw_share0_output_3_we;
  logic [31:0] sw_share0_output_4_qs;
  logic [31:0] sw_share0_output_4_wd;
  logic sw_share0_output_4_we;
  logic [31:0] sw_share0_output_5_qs;
  logic [31:0] sw_share0_output_5_wd;
  logic sw_share0_output_5_we;
  logic [31:0] sw_share0_output_6_qs;
  logic [31:0] sw_share0_output_6_wd;
  logic sw_share0_output_6_we;
  logic [31:0] sw_share0_output_7_qs;
  logic [31:0] sw_share0_output_7_wd;
  logic sw_share0_output_7_we;
  logic [31:0] sw_share1_output_0_qs;
  logic [31:0] sw_share1_output_0_wd;
  logic sw_share1_output_0_we;
  logic [31:0] sw_share1_output_1_qs;
  logic [31:0] sw_share1_output_1_wd;
  logic sw_share1_output_1_we;
  logic [31:0] sw_share1_output_2_qs;
  logic [31:0] sw_share1_output_2_wd;
  logic sw_share1_output_2_we;
  logic [31:0] sw_share1_output_3_qs;
  logic [31:0] sw_share1_output_3_wd;
  logic sw_share1_output_3_we;
  logic [31:0] sw_share1_output_4_qs;
  logic [31:0] sw_share1_output_4_wd;
  logic sw_share1_output_4_we;
  logic [31:0] sw_share1_output_5_qs;
  logic [31:0] sw_share1_output_5_wd;
  logic sw_share1_output_5_we;
  logic [31:0] sw_share1_output_6_qs;
  logic [31:0] sw_share1_output_6_wd;
  logic sw_share1_output_6_we;
  logic [31:0] sw_share1_output_7_qs;
  logic [31:0] sw_share1_output_7_wd;
  logic sw_share1_output_7_we;
  logic [2:0] working_state_qs;
  logic [1:0] op_status_qs;
  logic [1:0] op_status_wd;
  logic op_status_we;
  logic err_code_invalid_op_qs;
  logic err_code_invalid_op_wd;
  logic err_code_invalid_op_we;
  logic err_code_invalid_cmd_qs;
  logic err_code_invalid_cmd_wd;
  logic err_code_invalid_cmd_we;
  logic err_code_invalid_kmac_input_qs;
  logic err_code_invalid_kmac_input_wd;
  logic err_code_invalid_kmac_input_we;
  logic err_code_invalid_kmac_data_qs;
  logic err_code_invalid_kmac_data_wd;
  logic err_code_invalid_kmac_data_we;

  // Register instances
  // R[intr_state]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_we),
    .wd     (intr_state_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.de),
    .d      (hw2reg.intr_state.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.q ),

    // to register interface (read)
    .qs     (intr_state_qs)
  );


  // R[intr_enable]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_we),
    .wd     (intr_enable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.q ),

    // to register interface (read)
    .qs     (intr_enable_qs)
  );


  // R[intr_test]: V(True)

  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test (
    .re     (1'b0),
    .we     (intr_test_we),
    .wd     (intr_test_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.qe),
    .q      (reg2hw.intr_test.q ),
    .qs     ()
  );


  // R[alert_test]: V(True)

  //   F[fatal_fault_err]: 0:0
  prim_subreg_ext #(
    .DW    (1)
  ) u_alert_test_fatal_fault_err (
    .re     (1'b0),
    .we     (alert_test_fatal_fault_err_we),
    .wd     (alert_test_fatal_fault_err_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.alert_test.fatal_fault_err.qe),
    .q      (reg2hw.alert_test.fatal_fault_err.q ),
    .qs     ()
  );


  //   F[recov_operation_err]: 1:1
  prim_subreg_ext #(
    .DW    (1)
  ) u_alert_test_recov_operation_err (
    .re     (1'b0),
    .we     (alert_test_recov_operation_err_we),
    .wd     (alert_test_recov_operation_err_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.alert_test.recov_operation_err.qe),
    .q      (reg2hw.alert_test.recov_operation_err.q ),
    .qs     ()
  );


  // R[cfg_regwen]: V(True)

  prim_subreg_ext #(
    .DW    (1)
  ) u_cfg_regwen (
    .re     (cfg_regwen_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.cfg_regwen.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (cfg_regwen_qs)
  );


  // R[control]: V(False)

  //   F[start]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_control_start (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (control_start_we & cfg_regwen_qs),
    .wd     (control_start_wd),

    // from internal hardware
    .de     (hw2reg.control.start.de),
    .d      (hw2reg.control.start.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.control.start.q ),

    // to register interface (read)
    .qs     (control_start_qs)
  );


  //   F[operation]: 6:4
  prim_subreg #(
    .DW      (3),
    .SWACCESS("RW"),
    .RESVAL  (3'h1)
  ) u_control_operation (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (control_operation_we & cfg_regwen_qs),
    .wd     (control_operation_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.control.operation.q ),

    // to register interface (read)
    .qs     (control_operation_qs)
  );


  //   F[dest_sel]: 13:12
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_control_dest_sel (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (control_dest_sel_we & cfg_regwen_qs),
    .wd     (control_dest_sel_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.control.dest_sel.q ),

    // to register interface (read)
    .qs     (control_dest_sel_qs)
  );


  // R[sideload_clear]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_sideload_clear (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sideload_clear_we),
    .wd     (sideload_clear_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.sideload_clear.q ),

    // to register interface (read)
    .qs     (sideload_clear_qs)
  );


  // R[reseed_interval]: V(False)

  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h100)
  ) u_reseed_interval (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (reseed_interval_we),
    .wd     (reseed_interval_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.reseed_interval.q ),

    // to register interface (read)
    .qs     (reseed_interval_qs)
  );


  // R[sw_binding_regwen]: V(True)

  prim_subreg_ext #(
    .DW    (1)
  ) u_sw_binding_regwen (
    .re     (sw_binding_regwen_re),
    .we     (sw_binding_regwen_we),
    .wd     (sw_binding_regwen_wd),
    .d      (hw2reg.sw_binding_regwen.d),
    .qre    (),
    .qe     (reg2hw.sw_binding_regwen.qe),
    .q      (reg2hw.sw_binding_regwen.q ),
    .qs     (sw_binding_regwen_qs)
  );



  // Subregister 0 of Multireg sw_binding
  // R[sw_binding_0]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_sw_binding_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (sw_binding_0_we & sw_binding_regwen_qs),
    .wd     (sw_binding_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.sw_binding[0].q ),

    // to register interface (read)
    .qs     (sw_binding_0_qs)
  );

  // Subregister 1 of Multireg sw_binding
  // R[sw_binding_1]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_sw_binding_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (sw_binding_1_we & sw_binding_regwen_qs),
    .wd     (sw_binding_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.sw_binding[1].q ),

    // to register interface (read)
    .qs     (sw_binding_1_qs)
  );

  // Subregister 2 of Multireg sw_binding
  // R[sw_binding_2]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_sw_binding_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (sw_binding_2_we & sw_binding_regwen_qs),
    .wd     (sw_binding_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.sw_binding[2].q ),

    // to register interface (read)
    .qs     (sw_binding_2_qs)
  );

  // Subregister 3 of Multireg sw_binding
  // R[sw_binding_3]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_sw_binding_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (sw_binding_3_we & sw_binding_regwen_qs),
    .wd     (sw_binding_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.sw_binding[3].q ),

    // to register interface (read)
    .qs     (sw_binding_3_qs)
  );

  // Subregister 4 of Multireg sw_binding
  // R[sw_binding_4]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_sw_binding_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (sw_binding_4_we & sw_binding_regwen_qs),
    .wd     (sw_binding_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.sw_binding[4].q ),

    // to register interface (read)
    .qs     (sw_binding_4_qs)
  );

  // Subregister 5 of Multireg sw_binding
  // R[sw_binding_5]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_sw_binding_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (sw_binding_5_we & sw_binding_regwen_qs),
    .wd     (sw_binding_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.sw_binding[5].q ),

    // to register interface (read)
    .qs     (sw_binding_5_qs)
  );

  // Subregister 6 of Multireg sw_binding
  // R[sw_binding_6]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_sw_binding_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (sw_binding_6_we & sw_binding_regwen_qs),
    .wd     (sw_binding_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.sw_binding[6].q ),

    // to register interface (read)
    .qs     (sw_binding_6_qs)
  );

  // Subregister 7 of Multireg sw_binding
  // R[sw_binding_7]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_sw_binding_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (sw_binding_7_we & sw_binding_regwen_qs),
    .wd     (sw_binding_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.sw_binding[7].q ),

    // to register interface (read)
    .qs     (sw_binding_7_qs)
  );



  // Subregister 0 of Multireg salt
  // R[salt_0]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_salt_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (salt_0_we & cfg_regwen_qs),
    .wd     (salt_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.salt[0].q ),

    // to register interface (read)
    .qs     (salt_0_qs)
  );

  // Subregister 1 of Multireg salt
  // R[salt_1]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_salt_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (salt_1_we & cfg_regwen_qs),
    .wd     (salt_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.salt[1].q ),

    // to register interface (read)
    .qs     (salt_1_qs)
  );

  // Subregister 2 of Multireg salt
  // R[salt_2]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_salt_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (salt_2_we & cfg_regwen_qs),
    .wd     (salt_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.salt[2].q ),

    // to register interface (read)
    .qs     (salt_2_qs)
  );

  // Subregister 3 of Multireg salt
  // R[salt_3]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_salt_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (salt_3_we & cfg_regwen_qs),
    .wd     (salt_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.salt[3].q ),

    // to register interface (read)
    .qs     (salt_3_qs)
  );

  // Subregister 4 of Multireg salt
  // R[salt_4]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_salt_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (salt_4_we & cfg_regwen_qs),
    .wd     (salt_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.salt[4].q ),

    // to register interface (read)
    .qs     (salt_4_qs)
  );

  // Subregister 5 of Multireg salt
  // R[salt_5]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_salt_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (salt_5_we & cfg_regwen_qs),
    .wd     (salt_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.salt[5].q ),

    // to register interface (read)
    .qs     (salt_5_qs)
  );

  // Subregister 6 of Multireg salt
  // R[salt_6]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_salt_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (salt_6_we & cfg_regwen_qs),
    .wd     (salt_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.salt[6].q ),

    // to register interface (read)
    .qs     (salt_6_qs)
  );

  // Subregister 7 of Multireg salt
  // R[salt_7]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_salt_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (salt_7_we & cfg_regwen_qs),
    .wd     (salt_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.salt[7].q ),

    // to register interface (read)
    .qs     (salt_7_qs)
  );



  // Subregister 0 of Multireg key_version
  // R[key_version]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_key_version (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (key_version_we & cfg_regwen_qs),
    .wd     (key_version_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.key_version[0].q ),

    // to register interface (read)
    .qs     (key_version_qs)
  );


  // R[max_creator_key_ver_regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_max_creator_key_ver_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (max_creator_key_ver_regwen_we),
    .wd     (max_creator_key_ver_regwen_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (max_creator_key_ver_regwen_qs)
  );


  // R[max_creator_key_ver]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_max_creator_key_ver (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (max_creator_key_ver_we & max_creator_key_ver_regwen_qs),
    .wd     (max_creator_key_ver_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.max_creator_key_ver.q ),

    // to register interface (read)
    .qs     (max_creator_key_ver_qs)
  );


  // R[max_owner_int_key_ver_regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_max_owner_int_key_ver_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (max_owner_int_key_ver_regwen_we),
    .wd     (max_owner_int_key_ver_regwen_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (max_owner_int_key_ver_regwen_qs)
  );


  // R[max_owner_int_key_ver]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h1)
  ) u_max_owner_int_key_ver (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (max_owner_int_key_ver_we & max_owner_int_key_ver_regwen_qs),
    .wd     (max_owner_int_key_ver_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.max_owner_int_key_ver.q ),

    // to register interface (read)
    .qs     (max_owner_int_key_ver_qs)
  );


  // R[max_owner_key_ver_regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_max_owner_key_ver_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (max_owner_key_ver_regwen_we),
    .wd     (max_owner_key_ver_regwen_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (max_owner_key_ver_regwen_qs)
  );


  // R[max_owner_key_ver]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_max_owner_key_ver (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (max_owner_key_ver_we & max_owner_key_ver_regwen_qs),
    .wd     (max_owner_key_ver_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.max_owner_key_ver.q ),

    // to register interface (read)
    .qs     (max_owner_key_ver_qs)
  );



  // Subregister 0 of Multireg sw_share0_output
  // R[sw_share0_output_0]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share0_output_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share0_output_0_we),
    .wd     (sw_share0_output_0_wd),

    // from internal hardware
    .de     (hw2reg.sw_share0_output[0].de),
    .d      (hw2reg.sw_share0_output[0].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share0_output_0_qs)
  );

  // Subregister 1 of Multireg sw_share0_output
  // R[sw_share0_output_1]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share0_output_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share0_output_1_we),
    .wd     (sw_share0_output_1_wd),

    // from internal hardware
    .de     (hw2reg.sw_share0_output[1].de),
    .d      (hw2reg.sw_share0_output[1].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share0_output_1_qs)
  );

  // Subregister 2 of Multireg sw_share0_output
  // R[sw_share0_output_2]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share0_output_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share0_output_2_we),
    .wd     (sw_share0_output_2_wd),

    // from internal hardware
    .de     (hw2reg.sw_share0_output[2].de),
    .d      (hw2reg.sw_share0_output[2].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share0_output_2_qs)
  );

  // Subregister 3 of Multireg sw_share0_output
  // R[sw_share0_output_3]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share0_output_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share0_output_3_we),
    .wd     (sw_share0_output_3_wd),

    // from internal hardware
    .de     (hw2reg.sw_share0_output[3].de),
    .d      (hw2reg.sw_share0_output[3].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share0_output_3_qs)
  );

  // Subregister 4 of Multireg sw_share0_output
  // R[sw_share0_output_4]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share0_output_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share0_output_4_we),
    .wd     (sw_share0_output_4_wd),

    // from internal hardware
    .de     (hw2reg.sw_share0_output[4].de),
    .d      (hw2reg.sw_share0_output[4].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share0_output_4_qs)
  );

  // Subregister 5 of Multireg sw_share0_output
  // R[sw_share0_output_5]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share0_output_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share0_output_5_we),
    .wd     (sw_share0_output_5_wd),

    // from internal hardware
    .de     (hw2reg.sw_share0_output[5].de),
    .d      (hw2reg.sw_share0_output[5].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share0_output_5_qs)
  );

  // Subregister 6 of Multireg sw_share0_output
  // R[sw_share0_output_6]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share0_output_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share0_output_6_we),
    .wd     (sw_share0_output_6_wd),

    // from internal hardware
    .de     (hw2reg.sw_share0_output[6].de),
    .d      (hw2reg.sw_share0_output[6].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share0_output_6_qs)
  );

  // Subregister 7 of Multireg sw_share0_output
  // R[sw_share0_output_7]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share0_output_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share0_output_7_we),
    .wd     (sw_share0_output_7_wd),

    // from internal hardware
    .de     (hw2reg.sw_share0_output[7].de),
    .d      (hw2reg.sw_share0_output[7].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share0_output_7_qs)
  );



  // Subregister 0 of Multireg sw_share1_output
  // R[sw_share1_output_0]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share1_output_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share1_output_0_we),
    .wd     (sw_share1_output_0_wd),

    // from internal hardware
    .de     (hw2reg.sw_share1_output[0].de),
    .d      (hw2reg.sw_share1_output[0].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share1_output_0_qs)
  );

  // Subregister 1 of Multireg sw_share1_output
  // R[sw_share1_output_1]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share1_output_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share1_output_1_we),
    .wd     (sw_share1_output_1_wd),

    // from internal hardware
    .de     (hw2reg.sw_share1_output[1].de),
    .d      (hw2reg.sw_share1_output[1].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share1_output_1_qs)
  );

  // Subregister 2 of Multireg sw_share1_output
  // R[sw_share1_output_2]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share1_output_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share1_output_2_we),
    .wd     (sw_share1_output_2_wd),

    // from internal hardware
    .de     (hw2reg.sw_share1_output[2].de),
    .d      (hw2reg.sw_share1_output[2].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share1_output_2_qs)
  );

  // Subregister 3 of Multireg sw_share1_output
  // R[sw_share1_output_3]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share1_output_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share1_output_3_we),
    .wd     (sw_share1_output_3_wd),

    // from internal hardware
    .de     (hw2reg.sw_share1_output[3].de),
    .d      (hw2reg.sw_share1_output[3].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share1_output_3_qs)
  );

  // Subregister 4 of Multireg sw_share1_output
  // R[sw_share1_output_4]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share1_output_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share1_output_4_we),
    .wd     (sw_share1_output_4_wd),

    // from internal hardware
    .de     (hw2reg.sw_share1_output[4].de),
    .d      (hw2reg.sw_share1_output[4].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share1_output_4_qs)
  );

  // Subregister 5 of Multireg sw_share1_output
  // R[sw_share1_output_5]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share1_output_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share1_output_5_we),
    .wd     (sw_share1_output_5_wd),

    // from internal hardware
    .de     (hw2reg.sw_share1_output[5].de),
    .d      (hw2reg.sw_share1_output[5].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share1_output_5_qs)
  );

  // Subregister 6 of Multireg sw_share1_output
  // R[sw_share1_output_6]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share1_output_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share1_output_6_we),
    .wd     (sw_share1_output_6_wd),

    // from internal hardware
    .de     (hw2reg.sw_share1_output[6].de),
    .d      (hw2reg.sw_share1_output[6].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share1_output_6_qs)
  );

  // Subregister 7 of Multireg sw_share1_output
  // R[sw_share1_output_7]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RC"),
    .RESVAL  (32'h0)
  ) u_sw_share1_output_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (sw_share1_output_7_we),
    .wd     (sw_share1_output_7_wd),

    // from internal hardware
    .de     (hw2reg.sw_share1_output[7].de),
    .d      (hw2reg.sw_share1_output[7].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (sw_share1_output_7_qs)
  );


  // R[working_state]: V(False)

  prim_subreg #(
    .DW      (3),
    .SWACCESS("RO"),
    .RESVAL  (3'h0)
  ) u_working_state (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.working_state.de),
    .d      (hw2reg.working_state.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (working_state_qs)
  );


  // R[op_status]: V(False)

  prim_subreg #(
    .DW      (2),
    .SWACCESS("W1C"),
    .RESVAL  (2'h0)
  ) u_op_status (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (op_status_we),
    .wd     (op_status_wd),

    // from internal hardware
    .de     (hw2reg.op_status.de),
    .d      (hw2reg.op_status.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (op_status_qs)
  );


  // R[err_code]: V(False)

  //   F[invalid_op]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_err_code_invalid_op (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (err_code_invalid_op_we),
    .wd     (err_code_invalid_op_wd),

    // from internal hardware
    .de     (hw2reg.err_code.invalid_op.de),
    .d      (hw2reg.err_code.invalid_op.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.err_code.invalid_op.q ),

    // to register interface (read)
    .qs     (err_code_invalid_op_qs)
  );


  //   F[invalid_cmd]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_err_code_invalid_cmd (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (err_code_invalid_cmd_we),
    .wd     (err_code_invalid_cmd_wd),

    // from internal hardware
    .de     (hw2reg.err_code.invalid_cmd.de),
    .d      (hw2reg.err_code.invalid_cmd.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.err_code.invalid_cmd.q ),

    // to register interface (read)
    .qs     (err_code_invalid_cmd_qs)
  );


  //   F[invalid_kmac_input]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_err_code_invalid_kmac_input (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (err_code_invalid_kmac_input_we),
    .wd     (err_code_invalid_kmac_input_wd),

    // from internal hardware
    .de     (hw2reg.err_code.invalid_kmac_input.de),
    .d      (hw2reg.err_code.invalid_kmac_input.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.err_code.invalid_kmac_input.q ),

    // to register interface (read)
    .qs     (err_code_invalid_kmac_input_qs)
  );


  //   F[invalid_kmac_data]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_err_code_invalid_kmac_data (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (err_code_invalid_kmac_data_we),
    .wd     (err_code_invalid_kmac_data_wd),

    // from internal hardware
    .de     (hw2reg.err_code.invalid_kmac_data.de),
    .d      (hw2reg.err_code.invalid_kmac_data.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.err_code.invalid_kmac_data.q ),

    // to register interface (read)
    .qs     (err_code_invalid_kmac_data_qs)
  );




  logic [50:0] addr_hit;
  always_comb begin
    addr_hit = '0;
    addr_hit[ 0] = (reg_addr == KEYMGR_INTR_STATE_OFFSET);
    addr_hit[ 1] = (reg_addr == KEYMGR_INTR_ENABLE_OFFSET);
    addr_hit[ 2] = (reg_addr == KEYMGR_INTR_TEST_OFFSET);
    addr_hit[ 3] = (reg_addr == KEYMGR_ALERT_TEST_OFFSET);
    addr_hit[ 4] = (reg_addr == KEYMGR_CFG_REGWEN_OFFSET);
    addr_hit[ 5] = (reg_addr == KEYMGR_CONTROL_OFFSET);
    addr_hit[ 6] = (reg_addr == KEYMGR_SIDELOAD_CLEAR_OFFSET);
    addr_hit[ 7] = (reg_addr == KEYMGR_RESEED_INTERVAL_OFFSET);
    addr_hit[ 8] = (reg_addr == KEYMGR_SW_BINDING_REGWEN_OFFSET);
    addr_hit[ 9] = (reg_addr == KEYMGR_SW_BINDING_0_OFFSET);
    addr_hit[10] = (reg_addr == KEYMGR_SW_BINDING_1_OFFSET);
    addr_hit[11] = (reg_addr == KEYMGR_SW_BINDING_2_OFFSET);
    addr_hit[12] = (reg_addr == KEYMGR_SW_BINDING_3_OFFSET);
    addr_hit[13] = (reg_addr == KEYMGR_SW_BINDING_4_OFFSET);
    addr_hit[14] = (reg_addr == KEYMGR_SW_BINDING_5_OFFSET);
    addr_hit[15] = (reg_addr == KEYMGR_SW_BINDING_6_OFFSET);
    addr_hit[16] = (reg_addr == KEYMGR_SW_BINDING_7_OFFSET);
    addr_hit[17] = (reg_addr == KEYMGR_SALT_0_OFFSET);
    addr_hit[18] = (reg_addr == KEYMGR_SALT_1_OFFSET);
    addr_hit[19] = (reg_addr == KEYMGR_SALT_2_OFFSET);
    addr_hit[20] = (reg_addr == KEYMGR_SALT_3_OFFSET);
    addr_hit[21] = (reg_addr == KEYMGR_SALT_4_OFFSET);
    addr_hit[22] = (reg_addr == KEYMGR_SALT_5_OFFSET);
    addr_hit[23] = (reg_addr == KEYMGR_SALT_6_OFFSET);
    addr_hit[24] = (reg_addr == KEYMGR_SALT_7_OFFSET);
    addr_hit[25] = (reg_addr == KEYMGR_KEY_VERSION_OFFSET);
    addr_hit[26] = (reg_addr == KEYMGR_MAX_CREATOR_KEY_VER_REGWEN_OFFSET);
    addr_hit[27] = (reg_addr == KEYMGR_MAX_CREATOR_KEY_VER_OFFSET);
    addr_hit[28] = (reg_addr == KEYMGR_MAX_OWNER_INT_KEY_VER_REGWEN_OFFSET);
    addr_hit[29] = (reg_addr == KEYMGR_MAX_OWNER_INT_KEY_VER_OFFSET);
    addr_hit[30] = (reg_addr == KEYMGR_MAX_OWNER_KEY_VER_REGWEN_OFFSET);
    addr_hit[31] = (reg_addr == KEYMGR_MAX_OWNER_KEY_VER_OFFSET);
    addr_hit[32] = (reg_addr == KEYMGR_SW_SHARE0_OUTPUT_0_OFFSET);
    addr_hit[33] = (reg_addr == KEYMGR_SW_SHARE0_OUTPUT_1_OFFSET);
    addr_hit[34] = (reg_addr == KEYMGR_SW_SHARE0_OUTPUT_2_OFFSET);
    addr_hit[35] = (reg_addr == KEYMGR_SW_SHARE0_OUTPUT_3_OFFSET);
    addr_hit[36] = (reg_addr == KEYMGR_SW_SHARE0_OUTPUT_4_OFFSET);
    addr_hit[37] = (reg_addr == KEYMGR_SW_SHARE0_OUTPUT_5_OFFSET);
    addr_hit[38] = (reg_addr == KEYMGR_SW_SHARE0_OUTPUT_6_OFFSET);
    addr_hit[39] = (reg_addr == KEYMGR_SW_SHARE0_OUTPUT_7_OFFSET);
    addr_hit[40] = (reg_addr == KEYMGR_SW_SHARE1_OUTPUT_0_OFFSET);
    addr_hit[41] = (reg_addr == KEYMGR_SW_SHARE1_OUTPUT_1_OFFSET);
    addr_hit[42] = (reg_addr == KEYMGR_SW_SHARE1_OUTPUT_2_OFFSET);
    addr_hit[43] = (reg_addr == KEYMGR_SW_SHARE1_OUTPUT_3_OFFSET);
    addr_hit[44] = (reg_addr == KEYMGR_SW_SHARE1_OUTPUT_4_OFFSET);
    addr_hit[45] = (reg_addr == KEYMGR_SW_SHARE1_OUTPUT_5_OFFSET);
    addr_hit[46] = (reg_addr == KEYMGR_SW_SHARE1_OUTPUT_6_OFFSET);
    addr_hit[47] = (reg_addr == KEYMGR_SW_SHARE1_OUTPUT_7_OFFSET);
    addr_hit[48] = (reg_addr == KEYMGR_WORKING_STATE_OFFSET);
    addr_hit[49] = (reg_addr == KEYMGR_OP_STATUS_OFFSET);
    addr_hit[50] = (reg_addr == KEYMGR_ERR_CODE_OFFSET);
  end

  assign addrmiss = (reg_re || reg_we) ? ~|addr_hit : 1'b0 ;

  // Check sub-word write is permitted
  always_comb begin
    wr_err = 1'b0;
    if (addr_hit[ 0] && reg_we && (KEYMGR_PERMIT[ 0] != (KEYMGR_PERMIT[ 0] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 1] && reg_we && (KEYMGR_PERMIT[ 1] != (KEYMGR_PERMIT[ 1] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 2] && reg_we && (KEYMGR_PERMIT[ 2] != (KEYMGR_PERMIT[ 2] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 3] && reg_we && (KEYMGR_PERMIT[ 3] != (KEYMGR_PERMIT[ 3] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 4] && reg_we && (KEYMGR_PERMIT[ 4] != (KEYMGR_PERMIT[ 4] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 5] && reg_we && (KEYMGR_PERMIT[ 5] != (KEYMGR_PERMIT[ 5] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 6] && reg_we && (KEYMGR_PERMIT[ 6] != (KEYMGR_PERMIT[ 6] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 7] && reg_we && (KEYMGR_PERMIT[ 7] != (KEYMGR_PERMIT[ 7] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 8] && reg_we && (KEYMGR_PERMIT[ 8] != (KEYMGR_PERMIT[ 8] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 9] && reg_we && (KEYMGR_PERMIT[ 9] != (KEYMGR_PERMIT[ 9] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[10] && reg_we && (KEYMGR_PERMIT[10] != (KEYMGR_PERMIT[10] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[11] && reg_we && (KEYMGR_PERMIT[11] != (KEYMGR_PERMIT[11] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[12] && reg_we && (KEYMGR_PERMIT[12] != (KEYMGR_PERMIT[12] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[13] && reg_we && (KEYMGR_PERMIT[13] != (KEYMGR_PERMIT[13] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[14] && reg_we && (KEYMGR_PERMIT[14] != (KEYMGR_PERMIT[14] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[15] && reg_we && (KEYMGR_PERMIT[15] != (KEYMGR_PERMIT[15] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[16] && reg_we && (KEYMGR_PERMIT[16] != (KEYMGR_PERMIT[16] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[17] && reg_we && (KEYMGR_PERMIT[17] != (KEYMGR_PERMIT[17] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[18] && reg_we && (KEYMGR_PERMIT[18] != (KEYMGR_PERMIT[18] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[19] && reg_we && (KEYMGR_PERMIT[19] != (KEYMGR_PERMIT[19] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[20] && reg_we && (KEYMGR_PERMIT[20] != (KEYMGR_PERMIT[20] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[21] && reg_we && (KEYMGR_PERMIT[21] != (KEYMGR_PERMIT[21] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[22] && reg_we && (KEYMGR_PERMIT[22] != (KEYMGR_PERMIT[22] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[23] && reg_we && (KEYMGR_PERMIT[23] != (KEYMGR_PERMIT[23] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[24] && reg_we && (KEYMGR_PERMIT[24] != (KEYMGR_PERMIT[24] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[25] && reg_we && (KEYMGR_PERMIT[25] != (KEYMGR_PERMIT[25] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[26] && reg_we && (KEYMGR_PERMIT[26] != (KEYMGR_PERMIT[26] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[27] && reg_we && (KEYMGR_PERMIT[27] != (KEYMGR_PERMIT[27] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[28] && reg_we && (KEYMGR_PERMIT[28] != (KEYMGR_PERMIT[28] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[29] && reg_we && (KEYMGR_PERMIT[29] != (KEYMGR_PERMIT[29] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[30] && reg_we && (KEYMGR_PERMIT[30] != (KEYMGR_PERMIT[30] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[31] && reg_we && (KEYMGR_PERMIT[31] != (KEYMGR_PERMIT[31] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[32] && reg_we && (KEYMGR_PERMIT[32] != (KEYMGR_PERMIT[32] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[33] && reg_we && (KEYMGR_PERMIT[33] != (KEYMGR_PERMIT[33] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[34] && reg_we && (KEYMGR_PERMIT[34] != (KEYMGR_PERMIT[34] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[35] && reg_we && (KEYMGR_PERMIT[35] != (KEYMGR_PERMIT[35] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[36] && reg_we && (KEYMGR_PERMIT[36] != (KEYMGR_PERMIT[36] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[37] && reg_we && (KEYMGR_PERMIT[37] != (KEYMGR_PERMIT[37] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[38] && reg_we && (KEYMGR_PERMIT[38] != (KEYMGR_PERMIT[38] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[39] && reg_we && (KEYMGR_PERMIT[39] != (KEYMGR_PERMIT[39] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[40] && reg_we && (KEYMGR_PERMIT[40] != (KEYMGR_PERMIT[40] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[41] && reg_we && (KEYMGR_PERMIT[41] != (KEYMGR_PERMIT[41] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[42] && reg_we && (KEYMGR_PERMIT[42] != (KEYMGR_PERMIT[42] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[43] && reg_we && (KEYMGR_PERMIT[43] != (KEYMGR_PERMIT[43] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[44] && reg_we && (KEYMGR_PERMIT[44] != (KEYMGR_PERMIT[44] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[45] && reg_we && (KEYMGR_PERMIT[45] != (KEYMGR_PERMIT[45] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[46] && reg_we && (KEYMGR_PERMIT[46] != (KEYMGR_PERMIT[46] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[47] && reg_we && (KEYMGR_PERMIT[47] != (KEYMGR_PERMIT[47] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[48] && reg_we && (KEYMGR_PERMIT[48] != (KEYMGR_PERMIT[48] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[49] && reg_we && (KEYMGR_PERMIT[49] != (KEYMGR_PERMIT[49] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[50] && reg_we && (KEYMGR_PERMIT[50] != (KEYMGR_PERMIT[50] & reg_be))) wr_err = 1'b1 ;
  end

  assign intr_state_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_wd = reg_wdata[0];

  assign intr_enable_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_wd = reg_wdata[0];

  assign intr_test_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_wd = reg_wdata[0];

  assign alert_test_fatal_fault_err_we = addr_hit[3] & reg_we & !reg_error;
  assign alert_test_fatal_fault_err_wd = reg_wdata[0];

  assign alert_test_recov_operation_err_we = addr_hit[3] & reg_we & !reg_error;
  assign alert_test_recov_operation_err_wd = reg_wdata[1];

  assign cfg_regwen_re = addr_hit[4] & reg_re & !reg_error;

  assign control_start_we = addr_hit[5] & reg_we & !reg_error;
  assign control_start_wd = reg_wdata[0];

  assign control_operation_we = addr_hit[5] & reg_we & !reg_error;
  assign control_operation_wd = reg_wdata[6:4];

  assign control_dest_sel_we = addr_hit[5] & reg_we & !reg_error;
  assign control_dest_sel_wd = reg_wdata[13:12];

  assign sideload_clear_we = addr_hit[6] & reg_we & !reg_error;
  assign sideload_clear_wd = reg_wdata[0];

  assign reseed_interval_we = addr_hit[7] & reg_we & !reg_error;
  assign reseed_interval_wd = reg_wdata[15:0];

  assign sw_binding_regwen_we = addr_hit[8] & reg_we & !reg_error;
  assign sw_binding_regwen_wd = reg_wdata[0];
  assign sw_binding_regwen_re = addr_hit[8] & reg_re & !reg_error;

  assign sw_binding_0_we = addr_hit[9] & reg_we & !reg_error;
  assign sw_binding_0_wd = reg_wdata[31:0];

  assign sw_binding_1_we = addr_hit[10] & reg_we & !reg_error;
  assign sw_binding_1_wd = reg_wdata[31:0];

  assign sw_binding_2_we = addr_hit[11] & reg_we & !reg_error;
  assign sw_binding_2_wd = reg_wdata[31:0];

  assign sw_binding_3_we = addr_hit[12] & reg_we & !reg_error;
  assign sw_binding_3_wd = reg_wdata[31:0];

  assign sw_binding_4_we = addr_hit[13] & reg_we & !reg_error;
  assign sw_binding_4_wd = reg_wdata[31:0];

  assign sw_binding_5_we = addr_hit[14] & reg_we & !reg_error;
  assign sw_binding_5_wd = reg_wdata[31:0];

  assign sw_binding_6_we = addr_hit[15] & reg_we & !reg_error;
  assign sw_binding_6_wd = reg_wdata[31:0];

  assign sw_binding_7_we = addr_hit[16] & reg_we & !reg_error;
  assign sw_binding_7_wd = reg_wdata[31:0];

  assign salt_0_we = addr_hit[17] & reg_we & !reg_error;
  assign salt_0_wd = reg_wdata[31:0];

  assign salt_1_we = addr_hit[18] & reg_we & !reg_error;
  assign salt_1_wd = reg_wdata[31:0];

  assign salt_2_we = addr_hit[19] & reg_we & !reg_error;
  assign salt_2_wd = reg_wdata[31:0];

  assign salt_3_we = addr_hit[20] & reg_we & !reg_error;
  assign salt_3_wd = reg_wdata[31:0];

  assign salt_4_we = addr_hit[21] & reg_we & !reg_error;
  assign salt_4_wd = reg_wdata[31:0];

  assign salt_5_we = addr_hit[22] & reg_we & !reg_error;
  assign salt_5_wd = reg_wdata[31:0];

  assign salt_6_we = addr_hit[23] & reg_we & !reg_error;
  assign salt_6_wd = reg_wdata[31:0];

  assign salt_7_we = addr_hit[24] & reg_we & !reg_error;
  assign salt_7_wd = reg_wdata[31:0];

  assign key_version_we = addr_hit[25] & reg_we & !reg_error;
  assign key_version_wd = reg_wdata[31:0];

  assign max_creator_key_ver_regwen_we = addr_hit[26] & reg_we & !reg_error;
  assign max_creator_key_ver_regwen_wd = reg_wdata[0];

  assign max_creator_key_ver_we = addr_hit[27] & reg_we & !reg_error;
  assign max_creator_key_ver_wd = reg_wdata[31:0];

  assign max_owner_int_key_ver_regwen_we = addr_hit[28] & reg_we & !reg_error;
  assign max_owner_int_key_ver_regwen_wd = reg_wdata[0];

  assign max_owner_int_key_ver_we = addr_hit[29] & reg_we & !reg_error;
  assign max_owner_int_key_ver_wd = reg_wdata[31:0];

  assign max_owner_key_ver_regwen_we = addr_hit[30] & reg_we & !reg_error;
  assign max_owner_key_ver_regwen_wd = reg_wdata[0];

  assign max_owner_key_ver_we = addr_hit[31] & reg_we & !reg_error;
  assign max_owner_key_ver_wd = reg_wdata[31:0];

  assign sw_share0_output_0_we = addr_hit[32] & reg_re & !reg_error;
  assign sw_share0_output_0_wd = '1;

  assign sw_share0_output_1_we = addr_hit[33] & reg_re & !reg_error;
  assign sw_share0_output_1_wd = '1;

  assign sw_share0_output_2_we = addr_hit[34] & reg_re & !reg_error;
  assign sw_share0_output_2_wd = '1;

  assign sw_share0_output_3_we = addr_hit[35] & reg_re & !reg_error;
  assign sw_share0_output_3_wd = '1;

  assign sw_share0_output_4_we = addr_hit[36] & reg_re & !reg_error;
  assign sw_share0_output_4_wd = '1;

  assign sw_share0_output_5_we = addr_hit[37] & reg_re & !reg_error;
  assign sw_share0_output_5_wd = '1;

  assign sw_share0_output_6_we = addr_hit[38] & reg_re & !reg_error;
  assign sw_share0_output_6_wd = '1;

  assign sw_share0_output_7_we = addr_hit[39] & reg_re & !reg_error;
  assign sw_share0_output_7_wd = '1;

  assign sw_share1_output_0_we = addr_hit[40] & reg_re & !reg_error;
  assign sw_share1_output_0_wd = '1;

  assign sw_share1_output_1_we = addr_hit[41] & reg_re & !reg_error;
  assign sw_share1_output_1_wd = '1;

  assign sw_share1_output_2_we = addr_hit[42] & reg_re & !reg_error;
  assign sw_share1_output_2_wd = '1;

  assign sw_share1_output_3_we = addr_hit[43] & reg_re & !reg_error;
  assign sw_share1_output_3_wd = '1;

  assign sw_share1_output_4_we = addr_hit[44] & reg_re & !reg_error;
  assign sw_share1_output_4_wd = '1;

  assign sw_share1_output_5_we = addr_hit[45] & reg_re & !reg_error;
  assign sw_share1_output_5_wd = '1;

  assign sw_share1_output_6_we = addr_hit[46] & reg_re & !reg_error;
  assign sw_share1_output_6_wd = '1;

  assign sw_share1_output_7_we = addr_hit[47] & reg_re & !reg_error;
  assign sw_share1_output_7_wd = '1;

  assign op_status_we = addr_hit[49] & reg_we & !reg_error;
  assign op_status_wd = reg_wdata[1:0];

  assign err_code_invalid_op_we = addr_hit[50] & reg_we & !reg_error;
  assign err_code_invalid_op_wd = reg_wdata[0];

  assign err_code_invalid_cmd_we = addr_hit[50] & reg_we & !reg_error;
  assign err_code_invalid_cmd_wd = reg_wdata[1];

  assign err_code_invalid_kmac_input_we = addr_hit[50] & reg_we & !reg_error;
  assign err_code_invalid_kmac_input_wd = reg_wdata[2];

  assign err_code_invalid_kmac_data_we = addr_hit[50] & reg_we & !reg_error;
  assign err_code_invalid_kmac_data_wd = reg_wdata[3];

  // Read data return
  always_comb begin
    reg_rdata_next = '0;
    unique case (1'b1)
      addr_hit[0]: begin
        reg_rdata_next[0] = intr_state_qs;
      end

      addr_hit[1]: begin
        reg_rdata_next[0] = intr_enable_qs;
      end

      addr_hit[2]: begin
        reg_rdata_next[0] = '0;
      end

      addr_hit[3]: begin
        reg_rdata_next[0] = '0;
        reg_rdata_next[1] = '0;
      end

      addr_hit[4]: begin
        reg_rdata_next[0] = cfg_regwen_qs;
      end

      addr_hit[5]: begin
        reg_rdata_next[0] = control_start_qs;
        reg_rdata_next[6:4] = control_operation_qs;
        reg_rdata_next[13:12] = control_dest_sel_qs;
      end

      addr_hit[6]: begin
        reg_rdata_next[0] = sideload_clear_qs;
      end

      addr_hit[7]: begin
        reg_rdata_next[15:0] = reseed_interval_qs;
      end

      addr_hit[8]: begin
        reg_rdata_next[0] = sw_binding_regwen_qs;
      end

      addr_hit[9]: begin
        reg_rdata_next[31:0] = sw_binding_0_qs;
      end

      addr_hit[10]: begin
        reg_rdata_next[31:0] = sw_binding_1_qs;
      end

      addr_hit[11]: begin
        reg_rdata_next[31:0] = sw_binding_2_qs;
      end

      addr_hit[12]: begin
        reg_rdata_next[31:0] = sw_binding_3_qs;
      end

      addr_hit[13]: begin
        reg_rdata_next[31:0] = sw_binding_4_qs;
      end

      addr_hit[14]: begin
        reg_rdata_next[31:0] = sw_binding_5_qs;
      end

      addr_hit[15]: begin
        reg_rdata_next[31:0] = sw_binding_6_qs;
      end

      addr_hit[16]: begin
        reg_rdata_next[31:0] = sw_binding_7_qs;
      end

      addr_hit[17]: begin
        reg_rdata_next[31:0] = salt_0_qs;
      end

      addr_hit[18]: begin
        reg_rdata_next[31:0] = salt_1_qs;
      end

      addr_hit[19]: begin
        reg_rdata_next[31:0] = salt_2_qs;
      end

      addr_hit[20]: begin
        reg_rdata_next[31:0] = salt_3_qs;
      end

      addr_hit[21]: begin
        reg_rdata_next[31:0] = salt_4_qs;
      end

      addr_hit[22]: begin
        reg_rdata_next[31:0] = salt_5_qs;
      end

      addr_hit[23]: begin
        reg_rdata_next[31:0] = salt_6_qs;
      end

      addr_hit[24]: begin
        reg_rdata_next[31:0] = salt_7_qs;
      end

      addr_hit[25]: begin
        reg_rdata_next[31:0] = key_version_qs;
      end

      addr_hit[26]: begin
        reg_rdata_next[0] = max_creator_key_ver_regwen_qs;
      end

      addr_hit[27]: begin
        reg_rdata_next[31:0] = max_creator_key_ver_qs;
      end

      addr_hit[28]: begin
        reg_rdata_next[0] = max_owner_int_key_ver_regwen_qs;
      end

      addr_hit[29]: begin
        reg_rdata_next[31:0] = max_owner_int_key_ver_qs;
      end

      addr_hit[30]: begin
        reg_rdata_next[0] = max_owner_key_ver_regwen_qs;
      end

      addr_hit[31]: begin
        reg_rdata_next[31:0] = max_owner_key_ver_qs;
      end

      addr_hit[32]: begin
        reg_rdata_next[31:0] = sw_share0_output_0_qs;
      end

      addr_hit[33]: begin
        reg_rdata_next[31:0] = sw_share0_output_1_qs;
      end

      addr_hit[34]: begin
        reg_rdata_next[31:0] = sw_share0_output_2_qs;
      end

      addr_hit[35]: begin
        reg_rdata_next[31:0] = sw_share0_output_3_qs;
      end

      addr_hit[36]: begin
        reg_rdata_next[31:0] = sw_share0_output_4_qs;
      end

      addr_hit[37]: begin
        reg_rdata_next[31:0] = sw_share0_output_5_qs;
      end

      addr_hit[38]: begin
        reg_rdata_next[31:0] = sw_share0_output_6_qs;
      end

      addr_hit[39]: begin
        reg_rdata_next[31:0] = sw_share0_output_7_qs;
      end

      addr_hit[40]: begin
        reg_rdata_next[31:0] = sw_share1_output_0_qs;
      end

      addr_hit[41]: begin
        reg_rdata_next[31:0] = sw_share1_output_1_qs;
      end

      addr_hit[42]: begin
        reg_rdata_next[31:0] = sw_share1_output_2_qs;
      end

      addr_hit[43]: begin
        reg_rdata_next[31:0] = sw_share1_output_3_qs;
      end

      addr_hit[44]: begin
        reg_rdata_next[31:0] = sw_share1_output_4_qs;
      end

      addr_hit[45]: begin
        reg_rdata_next[31:0] = sw_share1_output_5_qs;
      end

      addr_hit[46]: begin
        reg_rdata_next[31:0] = sw_share1_output_6_qs;
      end

      addr_hit[47]: begin
        reg_rdata_next[31:0] = sw_share1_output_7_qs;
      end

      addr_hit[48]: begin
        reg_rdata_next[2:0] = working_state_qs;
      end

      addr_hit[49]: begin
        reg_rdata_next[1:0] = op_status_qs;
      end

      addr_hit[50]: begin
        reg_rdata_next[0] = err_code_invalid_op_qs;
        reg_rdata_next[1] = err_code_invalid_cmd_qs;
        reg_rdata_next[2] = err_code_invalid_kmac_input_qs;
        reg_rdata_next[3] = err_code_invalid_kmac_data_qs;
      end

      default: begin
        reg_rdata_next = '1;
      end
    endcase
  end

  // Unused signal tieoff

  // wdata / byte enable are not always fully used
  // add a blanket unused statement to handle lint waivers
  logic unused_wdata;
  logic unused_be;
  assign unused_wdata = ^reg_wdata;
  assign unused_be = ^reg_be;

  // Assertions for Register Interface
  `ASSERT_PULSE(wePulse, reg_we)
  `ASSERT_PULSE(rePulse, reg_re)

  `ASSERT(reAfterRv, $rose(reg_re || reg_we) |=> tl_o.d_valid)

  `ASSERT(en2addrHit, (reg_we || reg_re) |-> $onehot0(addr_hit))

  // this is formulated as an assumption such that the FPV testbenches do disprove this
  // property by mistake
  //`ASSUME(reqParity, tl_reg_h2d.a_valid |-> tl_reg_h2d.a_user.chk_en == tlul_pkg::CheckDis)

endmodule
