// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// Register Top module auto-generated by `reggen`

`include "prim_assert.sv"

module flash_ctrl_reg_top (
  input clk_i,
  input rst_ni,

  input  tlul_pkg::tl_h2d_t tl_i,
  output tlul_pkg::tl_d2h_t tl_o,

  // Output port for window
  output tlul_pkg::tl_h2d_t tl_win_o  [3],
  input  tlul_pkg::tl_d2h_t tl_win_i  [3],

  // To HW
  output flash_ctrl_reg_pkg::flash_ctrl_reg2hw_t reg2hw, // Write
  input  flash_ctrl_reg_pkg::flash_ctrl_hw2reg_t hw2reg, // Read

  // Integrity check errors
  output logic intg_err_o,

  // Config
  input devmode_i // If 1, explicit error return for unmapped register access
);

  import flash_ctrl_reg_pkg::* ;

  localparam int AW = 9;
  localparam int DW = 32;
  localparam int DBW = DW/8;                    // Byte Width

  // register signals
  logic           reg_we;
  logic           reg_re;
  logic [AW-1:0]  reg_addr;
  logic [DW-1:0]  reg_wdata;
  logic [DBW-1:0] reg_be;
  logic [DW-1:0]  reg_rdata;
  logic           reg_error;

  logic          addrmiss, wr_err;

  logic [DW-1:0] reg_rdata_next;

  tlul_pkg::tl_h2d_t tl_reg_h2d;
  tlul_pkg::tl_d2h_t tl_reg_d2h;

  // incoming payload check
  logic intg_err;
  tlul_cmd_intg_chk u_chk (
    .tl_i,
    .err_o(intg_err)
  );

  logic intg_err_q;
  always_ff @(posedge clk_i or negedge rst_ni) begin
    if (!rst_ni) begin
      intg_err_q <= '0;
    end else if (intg_err) begin
      intg_err_q <= 1'b1;
    end
  end

  // integrity error output is permanent and should be used for alert generation
  // register errors are transactional
  assign intg_err_o = intg_err_q | intg_err;

  // outgoing integrity generation
  tlul_pkg::tl_d2h_t tl_o_pre;
  tlul_rsp_intg_gen u_rsp_intg_gen (
    .tl_i(tl_o_pre),
    .tl_o
  );

  tlul_pkg::tl_h2d_t tl_socket_h2d [4];
  tlul_pkg::tl_d2h_t tl_socket_d2h [4];

  logic [2:0] reg_steer;

  // socket_1n connection
  assign tl_reg_h2d = tl_socket_h2d[3];
  assign tl_socket_d2h[3] = tl_reg_d2h;

  assign tl_win_o[0] = tl_socket_h2d[0];
  assign tl_socket_d2h[0] = tl_win_i[0];
  assign tl_win_o[1] = tl_socket_h2d[1];
  assign tl_socket_d2h[1] = tl_win_i[1];
  assign tl_win_o[2] = tl_socket_h2d[2];
  assign tl_socket_d2h[2] = tl_win_i[2];

  // Create Socket_1n
  tlul_socket_1n #(
    .N          (4),
    .HReqPass   (1'b1),
    .HRspPass   (1'b1),
    .DReqPass   ({4{1'b1}}),
    .DRspPass   ({4{1'b1}}),
    .HReqDepth  (4'h0),
    .HRspDepth  (4'h0),
    .DReqDepth  ({4{4'h0}}),
    .DRspDepth  ({4{4'h0}})
  ) u_socket (
    .clk_i,
    .rst_ni,
    .tl_h_i (tl_i),
    .tl_h_o (tl_o_pre),
    .tl_d_o (tl_socket_h2d),
    .tl_d_i (tl_socket_d2h),
    .dev_select_i (reg_steer)
  );

  // Create steering logic
  always_comb begin
    reg_steer = 3;       // Default set to register

    // TODO: Can below codes be unique case () inside ?
    if (tl_i.a_address[AW-1:0] >= 364 && tl_i.a_address[AW-1:0] < 368) begin
      reg_steer = 0;
    end
    if (tl_i.a_address[AW-1:0] >= 368 && tl_i.a_address[AW-1:0] < 372) begin
      reg_steer = 1;
    end
    if (tl_i.a_address[AW-1:0] >= 384 && tl_i.a_address[AW-1:0] < 468) begin
      reg_steer = 2;
    end
    if (intg_err) begin
      reg_steer = 3;
    end
  end

  tlul_adapter_reg #(
    .RegAw(AW),
    .RegDw(DW)
  ) u_reg_if (
    .clk_i,
    .rst_ni,

    .tl_i (tl_reg_h2d),
    .tl_o (tl_reg_d2h),

    .we_o    (reg_we),
    .re_o    (reg_re),
    .addr_o  (reg_addr),
    .wdata_o (reg_wdata),
    .be_o    (reg_be),
    .rdata_i (reg_rdata),
    .error_i (reg_error)
  );

  assign reg_rdata = reg_rdata_next ;
  assign reg_error = (devmode_i & addrmiss) | wr_err | intg_err;

  // Define SW related signals
  // Format: <reg>_<field>_{wd|we|qs}
  //        or <reg>_{wd|we|qs} if field == 1 or 0
  logic intr_state_prog_empty_qs;
  logic intr_state_prog_empty_wd;
  logic intr_state_prog_empty_we;
  logic intr_state_prog_lvl_qs;
  logic intr_state_prog_lvl_wd;
  logic intr_state_prog_lvl_we;
  logic intr_state_rd_full_qs;
  logic intr_state_rd_full_wd;
  logic intr_state_rd_full_we;
  logic intr_state_rd_lvl_qs;
  logic intr_state_rd_lvl_wd;
  logic intr_state_rd_lvl_we;
  logic intr_state_op_done_qs;
  logic intr_state_op_done_wd;
  logic intr_state_op_done_we;
  logic intr_enable_prog_empty_qs;
  logic intr_enable_prog_empty_wd;
  logic intr_enable_prog_empty_we;
  logic intr_enable_prog_lvl_qs;
  logic intr_enable_prog_lvl_wd;
  logic intr_enable_prog_lvl_we;
  logic intr_enable_rd_full_qs;
  logic intr_enable_rd_full_wd;
  logic intr_enable_rd_full_we;
  logic intr_enable_rd_lvl_qs;
  logic intr_enable_rd_lvl_wd;
  logic intr_enable_rd_lvl_we;
  logic intr_enable_op_done_qs;
  logic intr_enable_op_done_wd;
  logic intr_enable_op_done_we;
  logic intr_test_prog_empty_wd;
  logic intr_test_prog_empty_we;
  logic intr_test_prog_lvl_wd;
  logic intr_test_prog_lvl_we;
  logic intr_test_rd_full_wd;
  logic intr_test_rd_full_we;
  logic intr_test_rd_lvl_wd;
  logic intr_test_rd_lvl_we;
  logic intr_test_op_done_wd;
  logic intr_test_op_done_we;
  logic alert_test_recov_err_wd;
  logic alert_test_recov_err_we;
  logic alert_test_recov_mp_err_wd;
  logic alert_test_recov_mp_err_we;
  logic alert_test_recov_ecc_err_wd;
  logic alert_test_recov_ecc_err_we;
  logic ctrl_regwen_qs;
  logic ctrl_regwen_re;
  logic control_start_qs;
  logic control_start_wd;
  logic control_start_we;
  logic [1:0] control_op_qs;
  logic [1:0] control_op_wd;
  logic control_op_we;
  logic control_prog_sel_qs;
  logic control_prog_sel_wd;
  logic control_prog_sel_we;
  logic control_erase_sel_qs;
  logic control_erase_sel_wd;
  logic control_erase_sel_we;
  logic control_partition_sel_qs;
  logic control_partition_sel_wd;
  logic control_partition_sel_we;
  logic [1:0] control_info_sel_qs;
  logic [1:0] control_info_sel_wd;
  logic control_info_sel_we;
  logic [11:0] control_num_qs;
  logic [11:0] control_num_wd;
  logic control_num_we;
  logic [31:0] addr_qs;
  logic [31:0] addr_wd;
  logic addr_we;
  logic prog_type_en_normal_qs;
  logic prog_type_en_normal_wd;
  logic prog_type_en_normal_we;
  logic prog_type_en_repair_qs;
  logic prog_type_en_repair_wd;
  logic prog_type_en_repair_we;
  logic erase_suspend_qs;
  logic erase_suspend_wd;
  logic erase_suspend_we;
  logic region_cfg_regwen_0_qs;
  logic region_cfg_regwen_0_wd;
  logic region_cfg_regwen_0_we;
  logic region_cfg_regwen_1_qs;
  logic region_cfg_regwen_1_wd;
  logic region_cfg_regwen_1_we;
  logic region_cfg_regwen_2_qs;
  logic region_cfg_regwen_2_wd;
  logic region_cfg_regwen_2_we;
  logic region_cfg_regwen_3_qs;
  logic region_cfg_regwen_3_wd;
  logic region_cfg_regwen_3_we;
  logic region_cfg_regwen_4_qs;
  logic region_cfg_regwen_4_wd;
  logic region_cfg_regwen_4_we;
  logic region_cfg_regwen_5_qs;
  logic region_cfg_regwen_5_wd;
  logic region_cfg_regwen_5_we;
  logic region_cfg_regwen_6_qs;
  logic region_cfg_regwen_6_wd;
  logic region_cfg_regwen_6_we;
  logic region_cfg_regwen_7_qs;
  logic region_cfg_regwen_7_wd;
  logic region_cfg_regwen_7_we;
  logic mp_region_cfg_0_en_0_qs;
  logic mp_region_cfg_0_en_0_wd;
  logic mp_region_cfg_0_en_0_we;
  logic mp_region_cfg_0_rd_en_0_qs;
  logic mp_region_cfg_0_rd_en_0_wd;
  logic mp_region_cfg_0_rd_en_0_we;
  logic mp_region_cfg_0_prog_en_0_qs;
  logic mp_region_cfg_0_prog_en_0_wd;
  logic mp_region_cfg_0_prog_en_0_we;
  logic mp_region_cfg_0_erase_en_0_qs;
  logic mp_region_cfg_0_erase_en_0_wd;
  logic mp_region_cfg_0_erase_en_0_we;
  logic mp_region_cfg_0_scramble_en_0_qs;
  logic mp_region_cfg_0_scramble_en_0_wd;
  logic mp_region_cfg_0_scramble_en_0_we;
  logic mp_region_cfg_0_ecc_en_0_qs;
  logic mp_region_cfg_0_ecc_en_0_wd;
  logic mp_region_cfg_0_ecc_en_0_we;
  logic mp_region_cfg_0_he_en_0_qs;
  logic mp_region_cfg_0_he_en_0_wd;
  logic mp_region_cfg_0_he_en_0_we;
  logic [8:0] mp_region_cfg_0_base_0_qs;
  logic [8:0] mp_region_cfg_0_base_0_wd;
  logic mp_region_cfg_0_base_0_we;
  logic [9:0] mp_region_cfg_0_size_0_qs;
  logic [9:0] mp_region_cfg_0_size_0_wd;
  logic mp_region_cfg_0_size_0_we;
  logic mp_region_cfg_1_en_1_qs;
  logic mp_region_cfg_1_en_1_wd;
  logic mp_region_cfg_1_en_1_we;
  logic mp_region_cfg_1_rd_en_1_qs;
  logic mp_region_cfg_1_rd_en_1_wd;
  logic mp_region_cfg_1_rd_en_1_we;
  logic mp_region_cfg_1_prog_en_1_qs;
  logic mp_region_cfg_1_prog_en_1_wd;
  logic mp_region_cfg_1_prog_en_1_we;
  logic mp_region_cfg_1_erase_en_1_qs;
  logic mp_region_cfg_1_erase_en_1_wd;
  logic mp_region_cfg_1_erase_en_1_we;
  logic mp_region_cfg_1_scramble_en_1_qs;
  logic mp_region_cfg_1_scramble_en_1_wd;
  logic mp_region_cfg_1_scramble_en_1_we;
  logic mp_region_cfg_1_ecc_en_1_qs;
  logic mp_region_cfg_1_ecc_en_1_wd;
  logic mp_region_cfg_1_ecc_en_1_we;
  logic mp_region_cfg_1_he_en_1_qs;
  logic mp_region_cfg_1_he_en_1_wd;
  logic mp_region_cfg_1_he_en_1_we;
  logic [8:0] mp_region_cfg_1_base_1_qs;
  logic [8:0] mp_region_cfg_1_base_1_wd;
  logic mp_region_cfg_1_base_1_we;
  logic [9:0] mp_region_cfg_1_size_1_qs;
  logic [9:0] mp_region_cfg_1_size_1_wd;
  logic mp_region_cfg_1_size_1_we;
  logic mp_region_cfg_2_en_2_qs;
  logic mp_region_cfg_2_en_2_wd;
  logic mp_region_cfg_2_en_2_we;
  logic mp_region_cfg_2_rd_en_2_qs;
  logic mp_region_cfg_2_rd_en_2_wd;
  logic mp_region_cfg_2_rd_en_2_we;
  logic mp_region_cfg_2_prog_en_2_qs;
  logic mp_region_cfg_2_prog_en_2_wd;
  logic mp_region_cfg_2_prog_en_2_we;
  logic mp_region_cfg_2_erase_en_2_qs;
  logic mp_region_cfg_2_erase_en_2_wd;
  logic mp_region_cfg_2_erase_en_2_we;
  logic mp_region_cfg_2_scramble_en_2_qs;
  logic mp_region_cfg_2_scramble_en_2_wd;
  logic mp_region_cfg_2_scramble_en_2_we;
  logic mp_region_cfg_2_ecc_en_2_qs;
  logic mp_region_cfg_2_ecc_en_2_wd;
  logic mp_region_cfg_2_ecc_en_2_we;
  logic mp_region_cfg_2_he_en_2_qs;
  logic mp_region_cfg_2_he_en_2_wd;
  logic mp_region_cfg_2_he_en_2_we;
  logic [8:0] mp_region_cfg_2_base_2_qs;
  logic [8:0] mp_region_cfg_2_base_2_wd;
  logic mp_region_cfg_2_base_2_we;
  logic [9:0] mp_region_cfg_2_size_2_qs;
  logic [9:0] mp_region_cfg_2_size_2_wd;
  logic mp_region_cfg_2_size_2_we;
  logic mp_region_cfg_3_en_3_qs;
  logic mp_region_cfg_3_en_3_wd;
  logic mp_region_cfg_3_en_3_we;
  logic mp_region_cfg_3_rd_en_3_qs;
  logic mp_region_cfg_3_rd_en_3_wd;
  logic mp_region_cfg_3_rd_en_3_we;
  logic mp_region_cfg_3_prog_en_3_qs;
  logic mp_region_cfg_3_prog_en_3_wd;
  logic mp_region_cfg_3_prog_en_3_we;
  logic mp_region_cfg_3_erase_en_3_qs;
  logic mp_region_cfg_3_erase_en_3_wd;
  logic mp_region_cfg_3_erase_en_3_we;
  logic mp_region_cfg_3_scramble_en_3_qs;
  logic mp_region_cfg_3_scramble_en_3_wd;
  logic mp_region_cfg_3_scramble_en_3_we;
  logic mp_region_cfg_3_ecc_en_3_qs;
  logic mp_region_cfg_3_ecc_en_3_wd;
  logic mp_region_cfg_3_ecc_en_3_we;
  logic mp_region_cfg_3_he_en_3_qs;
  logic mp_region_cfg_3_he_en_3_wd;
  logic mp_region_cfg_3_he_en_3_we;
  logic [8:0] mp_region_cfg_3_base_3_qs;
  logic [8:0] mp_region_cfg_3_base_3_wd;
  logic mp_region_cfg_3_base_3_we;
  logic [9:0] mp_region_cfg_3_size_3_qs;
  logic [9:0] mp_region_cfg_3_size_3_wd;
  logic mp_region_cfg_3_size_3_we;
  logic mp_region_cfg_4_en_4_qs;
  logic mp_region_cfg_4_en_4_wd;
  logic mp_region_cfg_4_en_4_we;
  logic mp_region_cfg_4_rd_en_4_qs;
  logic mp_region_cfg_4_rd_en_4_wd;
  logic mp_region_cfg_4_rd_en_4_we;
  logic mp_region_cfg_4_prog_en_4_qs;
  logic mp_region_cfg_4_prog_en_4_wd;
  logic mp_region_cfg_4_prog_en_4_we;
  logic mp_region_cfg_4_erase_en_4_qs;
  logic mp_region_cfg_4_erase_en_4_wd;
  logic mp_region_cfg_4_erase_en_4_we;
  logic mp_region_cfg_4_scramble_en_4_qs;
  logic mp_region_cfg_4_scramble_en_4_wd;
  logic mp_region_cfg_4_scramble_en_4_we;
  logic mp_region_cfg_4_ecc_en_4_qs;
  logic mp_region_cfg_4_ecc_en_4_wd;
  logic mp_region_cfg_4_ecc_en_4_we;
  logic mp_region_cfg_4_he_en_4_qs;
  logic mp_region_cfg_4_he_en_4_wd;
  logic mp_region_cfg_4_he_en_4_we;
  logic [8:0] mp_region_cfg_4_base_4_qs;
  logic [8:0] mp_region_cfg_4_base_4_wd;
  logic mp_region_cfg_4_base_4_we;
  logic [9:0] mp_region_cfg_4_size_4_qs;
  logic [9:0] mp_region_cfg_4_size_4_wd;
  logic mp_region_cfg_4_size_4_we;
  logic mp_region_cfg_5_en_5_qs;
  logic mp_region_cfg_5_en_5_wd;
  logic mp_region_cfg_5_en_5_we;
  logic mp_region_cfg_5_rd_en_5_qs;
  logic mp_region_cfg_5_rd_en_5_wd;
  logic mp_region_cfg_5_rd_en_5_we;
  logic mp_region_cfg_5_prog_en_5_qs;
  logic mp_region_cfg_5_prog_en_5_wd;
  logic mp_region_cfg_5_prog_en_5_we;
  logic mp_region_cfg_5_erase_en_5_qs;
  logic mp_region_cfg_5_erase_en_5_wd;
  logic mp_region_cfg_5_erase_en_5_we;
  logic mp_region_cfg_5_scramble_en_5_qs;
  logic mp_region_cfg_5_scramble_en_5_wd;
  logic mp_region_cfg_5_scramble_en_5_we;
  logic mp_region_cfg_5_ecc_en_5_qs;
  logic mp_region_cfg_5_ecc_en_5_wd;
  logic mp_region_cfg_5_ecc_en_5_we;
  logic mp_region_cfg_5_he_en_5_qs;
  logic mp_region_cfg_5_he_en_5_wd;
  logic mp_region_cfg_5_he_en_5_we;
  logic [8:0] mp_region_cfg_5_base_5_qs;
  logic [8:0] mp_region_cfg_5_base_5_wd;
  logic mp_region_cfg_5_base_5_we;
  logic [9:0] mp_region_cfg_5_size_5_qs;
  logic [9:0] mp_region_cfg_5_size_5_wd;
  logic mp_region_cfg_5_size_5_we;
  logic mp_region_cfg_6_en_6_qs;
  logic mp_region_cfg_6_en_6_wd;
  logic mp_region_cfg_6_en_6_we;
  logic mp_region_cfg_6_rd_en_6_qs;
  logic mp_region_cfg_6_rd_en_6_wd;
  logic mp_region_cfg_6_rd_en_6_we;
  logic mp_region_cfg_6_prog_en_6_qs;
  logic mp_region_cfg_6_prog_en_6_wd;
  logic mp_region_cfg_6_prog_en_6_we;
  logic mp_region_cfg_6_erase_en_6_qs;
  logic mp_region_cfg_6_erase_en_6_wd;
  logic mp_region_cfg_6_erase_en_6_we;
  logic mp_region_cfg_6_scramble_en_6_qs;
  logic mp_region_cfg_6_scramble_en_6_wd;
  logic mp_region_cfg_6_scramble_en_6_we;
  logic mp_region_cfg_6_ecc_en_6_qs;
  logic mp_region_cfg_6_ecc_en_6_wd;
  logic mp_region_cfg_6_ecc_en_6_we;
  logic mp_region_cfg_6_he_en_6_qs;
  logic mp_region_cfg_6_he_en_6_wd;
  logic mp_region_cfg_6_he_en_6_we;
  logic [8:0] mp_region_cfg_6_base_6_qs;
  logic [8:0] mp_region_cfg_6_base_6_wd;
  logic mp_region_cfg_6_base_6_we;
  logic [9:0] mp_region_cfg_6_size_6_qs;
  logic [9:0] mp_region_cfg_6_size_6_wd;
  logic mp_region_cfg_6_size_6_we;
  logic mp_region_cfg_7_en_7_qs;
  logic mp_region_cfg_7_en_7_wd;
  logic mp_region_cfg_7_en_7_we;
  logic mp_region_cfg_7_rd_en_7_qs;
  logic mp_region_cfg_7_rd_en_7_wd;
  logic mp_region_cfg_7_rd_en_7_we;
  logic mp_region_cfg_7_prog_en_7_qs;
  logic mp_region_cfg_7_prog_en_7_wd;
  logic mp_region_cfg_7_prog_en_7_we;
  logic mp_region_cfg_7_erase_en_7_qs;
  logic mp_region_cfg_7_erase_en_7_wd;
  logic mp_region_cfg_7_erase_en_7_we;
  logic mp_region_cfg_7_scramble_en_7_qs;
  logic mp_region_cfg_7_scramble_en_7_wd;
  logic mp_region_cfg_7_scramble_en_7_we;
  logic mp_region_cfg_7_ecc_en_7_qs;
  logic mp_region_cfg_7_ecc_en_7_wd;
  logic mp_region_cfg_7_ecc_en_7_we;
  logic mp_region_cfg_7_he_en_7_qs;
  logic mp_region_cfg_7_he_en_7_wd;
  logic mp_region_cfg_7_he_en_7_we;
  logic [8:0] mp_region_cfg_7_base_7_qs;
  logic [8:0] mp_region_cfg_7_base_7_wd;
  logic mp_region_cfg_7_base_7_we;
  logic [9:0] mp_region_cfg_7_size_7_qs;
  logic [9:0] mp_region_cfg_7_size_7_wd;
  logic mp_region_cfg_7_size_7_we;
  logic default_region_rd_en_qs;
  logic default_region_rd_en_wd;
  logic default_region_rd_en_we;
  logic default_region_prog_en_qs;
  logic default_region_prog_en_wd;
  logic default_region_prog_en_we;
  logic default_region_erase_en_qs;
  logic default_region_erase_en_wd;
  logic default_region_erase_en_we;
  logic default_region_scramble_en_qs;
  logic default_region_scramble_en_wd;
  logic default_region_scramble_en_we;
  logic default_region_ecc_en_qs;
  logic default_region_ecc_en_wd;
  logic default_region_ecc_en_we;
  logic default_region_he_en_qs;
  logic default_region_he_en_wd;
  logic default_region_he_en_we;
  logic bank0_info0_regwen_0_qs;
  logic bank0_info0_regwen_0_wd;
  logic bank0_info0_regwen_0_we;
  logic bank0_info0_regwen_1_qs;
  logic bank0_info0_regwen_1_wd;
  logic bank0_info0_regwen_1_we;
  logic bank0_info0_regwen_2_qs;
  logic bank0_info0_regwen_2_wd;
  logic bank0_info0_regwen_2_we;
  logic bank0_info0_regwen_3_qs;
  logic bank0_info0_regwen_3_wd;
  logic bank0_info0_regwen_3_we;
  logic bank0_info0_regwen_4_qs;
  logic bank0_info0_regwen_4_wd;
  logic bank0_info0_regwen_4_we;
  logic bank0_info0_regwen_5_qs;
  logic bank0_info0_regwen_5_wd;
  logic bank0_info0_regwen_5_we;
  logic bank0_info0_regwen_6_qs;
  logic bank0_info0_regwen_6_wd;
  logic bank0_info0_regwen_6_we;
  logic bank0_info0_regwen_7_qs;
  logic bank0_info0_regwen_7_wd;
  logic bank0_info0_regwen_7_we;
  logic bank0_info0_regwen_8_qs;
  logic bank0_info0_regwen_8_wd;
  logic bank0_info0_regwen_8_we;
  logic bank0_info0_regwen_9_qs;
  logic bank0_info0_regwen_9_wd;
  logic bank0_info0_regwen_9_we;
  logic bank0_info0_page_cfg_0_en_0_qs;
  logic bank0_info0_page_cfg_0_en_0_wd;
  logic bank0_info0_page_cfg_0_en_0_we;
  logic bank0_info0_page_cfg_0_rd_en_0_qs;
  logic bank0_info0_page_cfg_0_rd_en_0_wd;
  logic bank0_info0_page_cfg_0_rd_en_0_we;
  logic bank0_info0_page_cfg_0_prog_en_0_qs;
  logic bank0_info0_page_cfg_0_prog_en_0_wd;
  logic bank0_info0_page_cfg_0_prog_en_0_we;
  logic bank0_info0_page_cfg_0_erase_en_0_qs;
  logic bank0_info0_page_cfg_0_erase_en_0_wd;
  logic bank0_info0_page_cfg_0_erase_en_0_we;
  logic bank0_info0_page_cfg_0_scramble_en_0_qs;
  logic bank0_info0_page_cfg_0_scramble_en_0_wd;
  logic bank0_info0_page_cfg_0_scramble_en_0_we;
  logic bank0_info0_page_cfg_0_ecc_en_0_qs;
  logic bank0_info0_page_cfg_0_ecc_en_0_wd;
  logic bank0_info0_page_cfg_0_ecc_en_0_we;
  logic bank0_info0_page_cfg_0_he_en_0_qs;
  logic bank0_info0_page_cfg_0_he_en_0_wd;
  logic bank0_info0_page_cfg_0_he_en_0_we;
  logic bank0_info0_page_cfg_1_en_1_qs;
  logic bank0_info0_page_cfg_1_en_1_wd;
  logic bank0_info0_page_cfg_1_en_1_we;
  logic bank0_info0_page_cfg_1_rd_en_1_qs;
  logic bank0_info0_page_cfg_1_rd_en_1_wd;
  logic bank0_info0_page_cfg_1_rd_en_1_we;
  logic bank0_info0_page_cfg_1_prog_en_1_qs;
  logic bank0_info0_page_cfg_1_prog_en_1_wd;
  logic bank0_info0_page_cfg_1_prog_en_1_we;
  logic bank0_info0_page_cfg_1_erase_en_1_qs;
  logic bank0_info0_page_cfg_1_erase_en_1_wd;
  logic bank0_info0_page_cfg_1_erase_en_1_we;
  logic bank0_info0_page_cfg_1_scramble_en_1_qs;
  logic bank0_info0_page_cfg_1_scramble_en_1_wd;
  logic bank0_info0_page_cfg_1_scramble_en_1_we;
  logic bank0_info0_page_cfg_1_ecc_en_1_qs;
  logic bank0_info0_page_cfg_1_ecc_en_1_wd;
  logic bank0_info0_page_cfg_1_ecc_en_1_we;
  logic bank0_info0_page_cfg_1_he_en_1_qs;
  logic bank0_info0_page_cfg_1_he_en_1_wd;
  logic bank0_info0_page_cfg_1_he_en_1_we;
  logic bank0_info0_page_cfg_2_en_2_qs;
  logic bank0_info0_page_cfg_2_en_2_wd;
  logic bank0_info0_page_cfg_2_en_2_we;
  logic bank0_info0_page_cfg_2_rd_en_2_qs;
  logic bank0_info0_page_cfg_2_rd_en_2_wd;
  logic bank0_info0_page_cfg_2_rd_en_2_we;
  logic bank0_info0_page_cfg_2_prog_en_2_qs;
  logic bank0_info0_page_cfg_2_prog_en_2_wd;
  logic bank0_info0_page_cfg_2_prog_en_2_we;
  logic bank0_info0_page_cfg_2_erase_en_2_qs;
  logic bank0_info0_page_cfg_2_erase_en_2_wd;
  logic bank0_info0_page_cfg_2_erase_en_2_we;
  logic bank0_info0_page_cfg_2_scramble_en_2_qs;
  logic bank0_info0_page_cfg_2_scramble_en_2_wd;
  logic bank0_info0_page_cfg_2_scramble_en_2_we;
  logic bank0_info0_page_cfg_2_ecc_en_2_qs;
  logic bank0_info0_page_cfg_2_ecc_en_2_wd;
  logic bank0_info0_page_cfg_2_ecc_en_2_we;
  logic bank0_info0_page_cfg_2_he_en_2_qs;
  logic bank0_info0_page_cfg_2_he_en_2_wd;
  logic bank0_info0_page_cfg_2_he_en_2_we;
  logic bank0_info0_page_cfg_3_en_3_qs;
  logic bank0_info0_page_cfg_3_en_3_wd;
  logic bank0_info0_page_cfg_3_en_3_we;
  logic bank0_info0_page_cfg_3_rd_en_3_qs;
  logic bank0_info0_page_cfg_3_rd_en_3_wd;
  logic bank0_info0_page_cfg_3_rd_en_3_we;
  logic bank0_info0_page_cfg_3_prog_en_3_qs;
  logic bank0_info0_page_cfg_3_prog_en_3_wd;
  logic bank0_info0_page_cfg_3_prog_en_3_we;
  logic bank0_info0_page_cfg_3_erase_en_3_qs;
  logic bank0_info0_page_cfg_3_erase_en_3_wd;
  logic bank0_info0_page_cfg_3_erase_en_3_we;
  logic bank0_info0_page_cfg_3_scramble_en_3_qs;
  logic bank0_info0_page_cfg_3_scramble_en_3_wd;
  logic bank0_info0_page_cfg_3_scramble_en_3_we;
  logic bank0_info0_page_cfg_3_ecc_en_3_qs;
  logic bank0_info0_page_cfg_3_ecc_en_3_wd;
  logic bank0_info0_page_cfg_3_ecc_en_3_we;
  logic bank0_info0_page_cfg_3_he_en_3_qs;
  logic bank0_info0_page_cfg_3_he_en_3_wd;
  logic bank0_info0_page_cfg_3_he_en_3_we;
  logic bank0_info0_page_cfg_4_en_4_qs;
  logic bank0_info0_page_cfg_4_en_4_wd;
  logic bank0_info0_page_cfg_4_en_4_we;
  logic bank0_info0_page_cfg_4_rd_en_4_qs;
  logic bank0_info0_page_cfg_4_rd_en_4_wd;
  logic bank0_info0_page_cfg_4_rd_en_4_we;
  logic bank0_info0_page_cfg_4_prog_en_4_qs;
  logic bank0_info0_page_cfg_4_prog_en_4_wd;
  logic bank0_info0_page_cfg_4_prog_en_4_we;
  logic bank0_info0_page_cfg_4_erase_en_4_qs;
  logic bank0_info0_page_cfg_4_erase_en_4_wd;
  logic bank0_info0_page_cfg_4_erase_en_4_we;
  logic bank0_info0_page_cfg_4_scramble_en_4_qs;
  logic bank0_info0_page_cfg_4_scramble_en_4_wd;
  logic bank0_info0_page_cfg_4_scramble_en_4_we;
  logic bank0_info0_page_cfg_4_ecc_en_4_qs;
  logic bank0_info0_page_cfg_4_ecc_en_4_wd;
  logic bank0_info0_page_cfg_4_ecc_en_4_we;
  logic bank0_info0_page_cfg_4_he_en_4_qs;
  logic bank0_info0_page_cfg_4_he_en_4_wd;
  logic bank0_info0_page_cfg_4_he_en_4_we;
  logic bank0_info0_page_cfg_5_en_5_qs;
  logic bank0_info0_page_cfg_5_en_5_wd;
  logic bank0_info0_page_cfg_5_en_5_we;
  logic bank0_info0_page_cfg_5_rd_en_5_qs;
  logic bank0_info0_page_cfg_5_rd_en_5_wd;
  logic bank0_info0_page_cfg_5_rd_en_5_we;
  logic bank0_info0_page_cfg_5_prog_en_5_qs;
  logic bank0_info0_page_cfg_5_prog_en_5_wd;
  logic bank0_info0_page_cfg_5_prog_en_5_we;
  logic bank0_info0_page_cfg_5_erase_en_5_qs;
  logic bank0_info0_page_cfg_5_erase_en_5_wd;
  logic bank0_info0_page_cfg_5_erase_en_5_we;
  logic bank0_info0_page_cfg_5_scramble_en_5_qs;
  logic bank0_info0_page_cfg_5_scramble_en_5_wd;
  logic bank0_info0_page_cfg_5_scramble_en_5_we;
  logic bank0_info0_page_cfg_5_ecc_en_5_qs;
  logic bank0_info0_page_cfg_5_ecc_en_5_wd;
  logic bank0_info0_page_cfg_5_ecc_en_5_we;
  logic bank0_info0_page_cfg_5_he_en_5_qs;
  logic bank0_info0_page_cfg_5_he_en_5_wd;
  logic bank0_info0_page_cfg_5_he_en_5_we;
  logic bank0_info0_page_cfg_6_en_6_qs;
  logic bank0_info0_page_cfg_6_en_6_wd;
  logic bank0_info0_page_cfg_6_en_6_we;
  logic bank0_info0_page_cfg_6_rd_en_6_qs;
  logic bank0_info0_page_cfg_6_rd_en_6_wd;
  logic bank0_info0_page_cfg_6_rd_en_6_we;
  logic bank0_info0_page_cfg_6_prog_en_6_qs;
  logic bank0_info0_page_cfg_6_prog_en_6_wd;
  logic bank0_info0_page_cfg_6_prog_en_6_we;
  logic bank0_info0_page_cfg_6_erase_en_6_qs;
  logic bank0_info0_page_cfg_6_erase_en_6_wd;
  logic bank0_info0_page_cfg_6_erase_en_6_we;
  logic bank0_info0_page_cfg_6_scramble_en_6_qs;
  logic bank0_info0_page_cfg_6_scramble_en_6_wd;
  logic bank0_info0_page_cfg_6_scramble_en_6_we;
  logic bank0_info0_page_cfg_6_ecc_en_6_qs;
  logic bank0_info0_page_cfg_6_ecc_en_6_wd;
  logic bank0_info0_page_cfg_6_ecc_en_6_we;
  logic bank0_info0_page_cfg_6_he_en_6_qs;
  logic bank0_info0_page_cfg_6_he_en_6_wd;
  logic bank0_info0_page_cfg_6_he_en_6_we;
  logic bank0_info0_page_cfg_7_en_7_qs;
  logic bank0_info0_page_cfg_7_en_7_wd;
  logic bank0_info0_page_cfg_7_en_7_we;
  logic bank0_info0_page_cfg_7_rd_en_7_qs;
  logic bank0_info0_page_cfg_7_rd_en_7_wd;
  logic bank0_info0_page_cfg_7_rd_en_7_we;
  logic bank0_info0_page_cfg_7_prog_en_7_qs;
  logic bank0_info0_page_cfg_7_prog_en_7_wd;
  logic bank0_info0_page_cfg_7_prog_en_7_we;
  logic bank0_info0_page_cfg_7_erase_en_7_qs;
  logic bank0_info0_page_cfg_7_erase_en_7_wd;
  logic bank0_info0_page_cfg_7_erase_en_7_we;
  logic bank0_info0_page_cfg_7_scramble_en_7_qs;
  logic bank0_info0_page_cfg_7_scramble_en_7_wd;
  logic bank0_info0_page_cfg_7_scramble_en_7_we;
  logic bank0_info0_page_cfg_7_ecc_en_7_qs;
  logic bank0_info0_page_cfg_7_ecc_en_7_wd;
  logic bank0_info0_page_cfg_7_ecc_en_7_we;
  logic bank0_info0_page_cfg_7_he_en_7_qs;
  logic bank0_info0_page_cfg_7_he_en_7_wd;
  logic bank0_info0_page_cfg_7_he_en_7_we;
  logic bank0_info0_page_cfg_8_en_8_qs;
  logic bank0_info0_page_cfg_8_en_8_wd;
  logic bank0_info0_page_cfg_8_en_8_we;
  logic bank0_info0_page_cfg_8_rd_en_8_qs;
  logic bank0_info0_page_cfg_8_rd_en_8_wd;
  logic bank0_info0_page_cfg_8_rd_en_8_we;
  logic bank0_info0_page_cfg_8_prog_en_8_qs;
  logic bank0_info0_page_cfg_8_prog_en_8_wd;
  logic bank0_info0_page_cfg_8_prog_en_8_we;
  logic bank0_info0_page_cfg_8_erase_en_8_qs;
  logic bank0_info0_page_cfg_8_erase_en_8_wd;
  logic bank0_info0_page_cfg_8_erase_en_8_we;
  logic bank0_info0_page_cfg_8_scramble_en_8_qs;
  logic bank0_info0_page_cfg_8_scramble_en_8_wd;
  logic bank0_info0_page_cfg_8_scramble_en_8_we;
  logic bank0_info0_page_cfg_8_ecc_en_8_qs;
  logic bank0_info0_page_cfg_8_ecc_en_8_wd;
  logic bank0_info0_page_cfg_8_ecc_en_8_we;
  logic bank0_info0_page_cfg_8_he_en_8_qs;
  logic bank0_info0_page_cfg_8_he_en_8_wd;
  logic bank0_info0_page_cfg_8_he_en_8_we;
  logic bank0_info0_page_cfg_9_en_9_qs;
  logic bank0_info0_page_cfg_9_en_9_wd;
  logic bank0_info0_page_cfg_9_en_9_we;
  logic bank0_info0_page_cfg_9_rd_en_9_qs;
  logic bank0_info0_page_cfg_9_rd_en_9_wd;
  logic bank0_info0_page_cfg_9_rd_en_9_we;
  logic bank0_info0_page_cfg_9_prog_en_9_qs;
  logic bank0_info0_page_cfg_9_prog_en_9_wd;
  logic bank0_info0_page_cfg_9_prog_en_9_we;
  logic bank0_info0_page_cfg_9_erase_en_9_qs;
  logic bank0_info0_page_cfg_9_erase_en_9_wd;
  logic bank0_info0_page_cfg_9_erase_en_9_we;
  logic bank0_info0_page_cfg_9_scramble_en_9_qs;
  logic bank0_info0_page_cfg_9_scramble_en_9_wd;
  logic bank0_info0_page_cfg_9_scramble_en_9_we;
  logic bank0_info0_page_cfg_9_ecc_en_9_qs;
  logic bank0_info0_page_cfg_9_ecc_en_9_wd;
  logic bank0_info0_page_cfg_9_ecc_en_9_we;
  logic bank0_info0_page_cfg_9_he_en_9_qs;
  logic bank0_info0_page_cfg_9_he_en_9_wd;
  logic bank0_info0_page_cfg_9_he_en_9_we;
  logic bank0_info1_regwen_qs;
  logic bank0_info1_regwen_wd;
  logic bank0_info1_regwen_we;
  logic bank0_info1_page_cfg_en_0_qs;
  logic bank0_info1_page_cfg_en_0_wd;
  logic bank0_info1_page_cfg_en_0_we;
  logic bank0_info1_page_cfg_rd_en_0_qs;
  logic bank0_info1_page_cfg_rd_en_0_wd;
  logic bank0_info1_page_cfg_rd_en_0_we;
  logic bank0_info1_page_cfg_prog_en_0_qs;
  logic bank0_info1_page_cfg_prog_en_0_wd;
  logic bank0_info1_page_cfg_prog_en_0_we;
  logic bank0_info1_page_cfg_erase_en_0_qs;
  logic bank0_info1_page_cfg_erase_en_0_wd;
  logic bank0_info1_page_cfg_erase_en_0_we;
  logic bank0_info1_page_cfg_scramble_en_0_qs;
  logic bank0_info1_page_cfg_scramble_en_0_wd;
  logic bank0_info1_page_cfg_scramble_en_0_we;
  logic bank0_info1_page_cfg_ecc_en_0_qs;
  logic bank0_info1_page_cfg_ecc_en_0_wd;
  logic bank0_info1_page_cfg_ecc_en_0_we;
  logic bank0_info1_page_cfg_he_en_0_qs;
  logic bank0_info1_page_cfg_he_en_0_wd;
  logic bank0_info1_page_cfg_he_en_0_we;
  logic bank0_info2_regwen_0_qs;
  logic bank0_info2_regwen_0_wd;
  logic bank0_info2_regwen_0_we;
  logic bank0_info2_regwen_1_qs;
  logic bank0_info2_regwen_1_wd;
  logic bank0_info2_regwen_1_we;
  logic bank0_info2_page_cfg_0_en_0_qs;
  logic bank0_info2_page_cfg_0_en_0_wd;
  logic bank0_info2_page_cfg_0_en_0_we;
  logic bank0_info2_page_cfg_0_rd_en_0_qs;
  logic bank0_info2_page_cfg_0_rd_en_0_wd;
  logic bank0_info2_page_cfg_0_rd_en_0_we;
  logic bank0_info2_page_cfg_0_prog_en_0_qs;
  logic bank0_info2_page_cfg_0_prog_en_0_wd;
  logic bank0_info2_page_cfg_0_prog_en_0_we;
  logic bank0_info2_page_cfg_0_erase_en_0_qs;
  logic bank0_info2_page_cfg_0_erase_en_0_wd;
  logic bank0_info2_page_cfg_0_erase_en_0_we;
  logic bank0_info2_page_cfg_0_scramble_en_0_qs;
  logic bank0_info2_page_cfg_0_scramble_en_0_wd;
  logic bank0_info2_page_cfg_0_scramble_en_0_we;
  logic bank0_info2_page_cfg_0_ecc_en_0_qs;
  logic bank0_info2_page_cfg_0_ecc_en_0_wd;
  logic bank0_info2_page_cfg_0_ecc_en_0_we;
  logic bank0_info2_page_cfg_0_he_en_0_qs;
  logic bank0_info2_page_cfg_0_he_en_0_wd;
  logic bank0_info2_page_cfg_0_he_en_0_we;
  logic bank0_info2_page_cfg_1_en_1_qs;
  logic bank0_info2_page_cfg_1_en_1_wd;
  logic bank0_info2_page_cfg_1_en_1_we;
  logic bank0_info2_page_cfg_1_rd_en_1_qs;
  logic bank0_info2_page_cfg_1_rd_en_1_wd;
  logic bank0_info2_page_cfg_1_rd_en_1_we;
  logic bank0_info2_page_cfg_1_prog_en_1_qs;
  logic bank0_info2_page_cfg_1_prog_en_1_wd;
  logic bank0_info2_page_cfg_1_prog_en_1_we;
  logic bank0_info2_page_cfg_1_erase_en_1_qs;
  logic bank0_info2_page_cfg_1_erase_en_1_wd;
  logic bank0_info2_page_cfg_1_erase_en_1_we;
  logic bank0_info2_page_cfg_1_scramble_en_1_qs;
  logic bank0_info2_page_cfg_1_scramble_en_1_wd;
  logic bank0_info2_page_cfg_1_scramble_en_1_we;
  logic bank0_info2_page_cfg_1_ecc_en_1_qs;
  logic bank0_info2_page_cfg_1_ecc_en_1_wd;
  logic bank0_info2_page_cfg_1_ecc_en_1_we;
  logic bank0_info2_page_cfg_1_he_en_1_qs;
  logic bank0_info2_page_cfg_1_he_en_1_wd;
  logic bank0_info2_page_cfg_1_he_en_1_we;
  logic bank1_info0_regwen_0_qs;
  logic bank1_info0_regwen_0_wd;
  logic bank1_info0_regwen_0_we;
  logic bank1_info0_regwen_1_qs;
  logic bank1_info0_regwen_1_wd;
  logic bank1_info0_regwen_1_we;
  logic bank1_info0_regwen_2_qs;
  logic bank1_info0_regwen_2_wd;
  logic bank1_info0_regwen_2_we;
  logic bank1_info0_regwen_3_qs;
  logic bank1_info0_regwen_3_wd;
  logic bank1_info0_regwen_3_we;
  logic bank1_info0_regwen_4_qs;
  logic bank1_info0_regwen_4_wd;
  logic bank1_info0_regwen_4_we;
  logic bank1_info0_regwen_5_qs;
  logic bank1_info0_regwen_5_wd;
  logic bank1_info0_regwen_5_we;
  logic bank1_info0_regwen_6_qs;
  logic bank1_info0_regwen_6_wd;
  logic bank1_info0_regwen_6_we;
  logic bank1_info0_regwen_7_qs;
  logic bank1_info0_regwen_7_wd;
  logic bank1_info0_regwen_7_we;
  logic bank1_info0_regwen_8_qs;
  logic bank1_info0_regwen_8_wd;
  logic bank1_info0_regwen_8_we;
  logic bank1_info0_regwen_9_qs;
  logic bank1_info0_regwen_9_wd;
  logic bank1_info0_regwen_9_we;
  logic bank1_info0_page_cfg_0_en_0_qs;
  logic bank1_info0_page_cfg_0_en_0_wd;
  logic bank1_info0_page_cfg_0_en_0_we;
  logic bank1_info0_page_cfg_0_rd_en_0_qs;
  logic bank1_info0_page_cfg_0_rd_en_0_wd;
  logic bank1_info0_page_cfg_0_rd_en_0_we;
  logic bank1_info0_page_cfg_0_prog_en_0_qs;
  logic bank1_info0_page_cfg_0_prog_en_0_wd;
  logic bank1_info0_page_cfg_0_prog_en_0_we;
  logic bank1_info0_page_cfg_0_erase_en_0_qs;
  logic bank1_info0_page_cfg_0_erase_en_0_wd;
  logic bank1_info0_page_cfg_0_erase_en_0_we;
  logic bank1_info0_page_cfg_0_scramble_en_0_qs;
  logic bank1_info0_page_cfg_0_scramble_en_0_wd;
  logic bank1_info0_page_cfg_0_scramble_en_0_we;
  logic bank1_info0_page_cfg_0_ecc_en_0_qs;
  logic bank1_info0_page_cfg_0_ecc_en_0_wd;
  logic bank1_info0_page_cfg_0_ecc_en_0_we;
  logic bank1_info0_page_cfg_0_he_en_0_qs;
  logic bank1_info0_page_cfg_0_he_en_0_wd;
  logic bank1_info0_page_cfg_0_he_en_0_we;
  logic bank1_info0_page_cfg_1_en_1_qs;
  logic bank1_info0_page_cfg_1_en_1_wd;
  logic bank1_info0_page_cfg_1_en_1_we;
  logic bank1_info0_page_cfg_1_rd_en_1_qs;
  logic bank1_info0_page_cfg_1_rd_en_1_wd;
  logic bank1_info0_page_cfg_1_rd_en_1_we;
  logic bank1_info0_page_cfg_1_prog_en_1_qs;
  logic bank1_info0_page_cfg_1_prog_en_1_wd;
  logic bank1_info0_page_cfg_1_prog_en_1_we;
  logic bank1_info0_page_cfg_1_erase_en_1_qs;
  logic bank1_info0_page_cfg_1_erase_en_1_wd;
  logic bank1_info0_page_cfg_1_erase_en_1_we;
  logic bank1_info0_page_cfg_1_scramble_en_1_qs;
  logic bank1_info0_page_cfg_1_scramble_en_1_wd;
  logic bank1_info0_page_cfg_1_scramble_en_1_we;
  logic bank1_info0_page_cfg_1_ecc_en_1_qs;
  logic bank1_info0_page_cfg_1_ecc_en_1_wd;
  logic bank1_info0_page_cfg_1_ecc_en_1_we;
  logic bank1_info0_page_cfg_1_he_en_1_qs;
  logic bank1_info0_page_cfg_1_he_en_1_wd;
  logic bank1_info0_page_cfg_1_he_en_1_we;
  logic bank1_info0_page_cfg_2_en_2_qs;
  logic bank1_info0_page_cfg_2_en_2_wd;
  logic bank1_info0_page_cfg_2_en_2_we;
  logic bank1_info0_page_cfg_2_rd_en_2_qs;
  logic bank1_info0_page_cfg_2_rd_en_2_wd;
  logic bank1_info0_page_cfg_2_rd_en_2_we;
  logic bank1_info0_page_cfg_2_prog_en_2_qs;
  logic bank1_info0_page_cfg_2_prog_en_2_wd;
  logic bank1_info0_page_cfg_2_prog_en_2_we;
  logic bank1_info0_page_cfg_2_erase_en_2_qs;
  logic bank1_info0_page_cfg_2_erase_en_2_wd;
  logic bank1_info0_page_cfg_2_erase_en_2_we;
  logic bank1_info0_page_cfg_2_scramble_en_2_qs;
  logic bank1_info0_page_cfg_2_scramble_en_2_wd;
  logic bank1_info0_page_cfg_2_scramble_en_2_we;
  logic bank1_info0_page_cfg_2_ecc_en_2_qs;
  logic bank1_info0_page_cfg_2_ecc_en_2_wd;
  logic bank1_info0_page_cfg_2_ecc_en_2_we;
  logic bank1_info0_page_cfg_2_he_en_2_qs;
  logic bank1_info0_page_cfg_2_he_en_2_wd;
  logic bank1_info0_page_cfg_2_he_en_2_we;
  logic bank1_info0_page_cfg_3_en_3_qs;
  logic bank1_info0_page_cfg_3_en_3_wd;
  logic bank1_info0_page_cfg_3_en_3_we;
  logic bank1_info0_page_cfg_3_rd_en_3_qs;
  logic bank1_info0_page_cfg_3_rd_en_3_wd;
  logic bank1_info0_page_cfg_3_rd_en_3_we;
  logic bank1_info0_page_cfg_3_prog_en_3_qs;
  logic bank1_info0_page_cfg_3_prog_en_3_wd;
  logic bank1_info0_page_cfg_3_prog_en_3_we;
  logic bank1_info0_page_cfg_3_erase_en_3_qs;
  logic bank1_info0_page_cfg_3_erase_en_3_wd;
  logic bank1_info0_page_cfg_3_erase_en_3_we;
  logic bank1_info0_page_cfg_3_scramble_en_3_qs;
  logic bank1_info0_page_cfg_3_scramble_en_3_wd;
  logic bank1_info0_page_cfg_3_scramble_en_3_we;
  logic bank1_info0_page_cfg_3_ecc_en_3_qs;
  logic bank1_info0_page_cfg_3_ecc_en_3_wd;
  logic bank1_info0_page_cfg_3_ecc_en_3_we;
  logic bank1_info0_page_cfg_3_he_en_3_qs;
  logic bank1_info0_page_cfg_3_he_en_3_wd;
  logic bank1_info0_page_cfg_3_he_en_3_we;
  logic bank1_info0_page_cfg_4_en_4_qs;
  logic bank1_info0_page_cfg_4_en_4_wd;
  logic bank1_info0_page_cfg_4_en_4_we;
  logic bank1_info0_page_cfg_4_rd_en_4_qs;
  logic bank1_info0_page_cfg_4_rd_en_4_wd;
  logic bank1_info0_page_cfg_4_rd_en_4_we;
  logic bank1_info0_page_cfg_4_prog_en_4_qs;
  logic bank1_info0_page_cfg_4_prog_en_4_wd;
  logic bank1_info0_page_cfg_4_prog_en_4_we;
  logic bank1_info0_page_cfg_4_erase_en_4_qs;
  logic bank1_info0_page_cfg_4_erase_en_4_wd;
  logic bank1_info0_page_cfg_4_erase_en_4_we;
  logic bank1_info0_page_cfg_4_scramble_en_4_qs;
  logic bank1_info0_page_cfg_4_scramble_en_4_wd;
  logic bank1_info0_page_cfg_4_scramble_en_4_we;
  logic bank1_info0_page_cfg_4_ecc_en_4_qs;
  logic bank1_info0_page_cfg_4_ecc_en_4_wd;
  logic bank1_info0_page_cfg_4_ecc_en_4_we;
  logic bank1_info0_page_cfg_4_he_en_4_qs;
  logic bank1_info0_page_cfg_4_he_en_4_wd;
  logic bank1_info0_page_cfg_4_he_en_4_we;
  logic bank1_info0_page_cfg_5_en_5_qs;
  logic bank1_info0_page_cfg_5_en_5_wd;
  logic bank1_info0_page_cfg_5_en_5_we;
  logic bank1_info0_page_cfg_5_rd_en_5_qs;
  logic bank1_info0_page_cfg_5_rd_en_5_wd;
  logic bank1_info0_page_cfg_5_rd_en_5_we;
  logic bank1_info0_page_cfg_5_prog_en_5_qs;
  logic bank1_info0_page_cfg_5_prog_en_5_wd;
  logic bank1_info0_page_cfg_5_prog_en_5_we;
  logic bank1_info0_page_cfg_5_erase_en_5_qs;
  logic bank1_info0_page_cfg_5_erase_en_5_wd;
  logic bank1_info0_page_cfg_5_erase_en_5_we;
  logic bank1_info0_page_cfg_5_scramble_en_5_qs;
  logic bank1_info0_page_cfg_5_scramble_en_5_wd;
  logic bank1_info0_page_cfg_5_scramble_en_5_we;
  logic bank1_info0_page_cfg_5_ecc_en_5_qs;
  logic bank1_info0_page_cfg_5_ecc_en_5_wd;
  logic bank1_info0_page_cfg_5_ecc_en_5_we;
  logic bank1_info0_page_cfg_5_he_en_5_qs;
  logic bank1_info0_page_cfg_5_he_en_5_wd;
  logic bank1_info0_page_cfg_5_he_en_5_we;
  logic bank1_info0_page_cfg_6_en_6_qs;
  logic bank1_info0_page_cfg_6_en_6_wd;
  logic bank1_info0_page_cfg_6_en_6_we;
  logic bank1_info0_page_cfg_6_rd_en_6_qs;
  logic bank1_info0_page_cfg_6_rd_en_6_wd;
  logic bank1_info0_page_cfg_6_rd_en_6_we;
  logic bank1_info0_page_cfg_6_prog_en_6_qs;
  logic bank1_info0_page_cfg_6_prog_en_6_wd;
  logic bank1_info0_page_cfg_6_prog_en_6_we;
  logic bank1_info0_page_cfg_6_erase_en_6_qs;
  logic bank1_info0_page_cfg_6_erase_en_6_wd;
  logic bank1_info0_page_cfg_6_erase_en_6_we;
  logic bank1_info0_page_cfg_6_scramble_en_6_qs;
  logic bank1_info0_page_cfg_6_scramble_en_6_wd;
  logic bank1_info0_page_cfg_6_scramble_en_6_we;
  logic bank1_info0_page_cfg_6_ecc_en_6_qs;
  logic bank1_info0_page_cfg_6_ecc_en_6_wd;
  logic bank1_info0_page_cfg_6_ecc_en_6_we;
  logic bank1_info0_page_cfg_6_he_en_6_qs;
  logic bank1_info0_page_cfg_6_he_en_6_wd;
  logic bank1_info0_page_cfg_6_he_en_6_we;
  logic bank1_info0_page_cfg_7_en_7_qs;
  logic bank1_info0_page_cfg_7_en_7_wd;
  logic bank1_info0_page_cfg_7_en_7_we;
  logic bank1_info0_page_cfg_7_rd_en_7_qs;
  logic bank1_info0_page_cfg_7_rd_en_7_wd;
  logic bank1_info0_page_cfg_7_rd_en_7_we;
  logic bank1_info0_page_cfg_7_prog_en_7_qs;
  logic bank1_info0_page_cfg_7_prog_en_7_wd;
  logic bank1_info0_page_cfg_7_prog_en_7_we;
  logic bank1_info0_page_cfg_7_erase_en_7_qs;
  logic bank1_info0_page_cfg_7_erase_en_7_wd;
  logic bank1_info0_page_cfg_7_erase_en_7_we;
  logic bank1_info0_page_cfg_7_scramble_en_7_qs;
  logic bank1_info0_page_cfg_7_scramble_en_7_wd;
  logic bank1_info0_page_cfg_7_scramble_en_7_we;
  logic bank1_info0_page_cfg_7_ecc_en_7_qs;
  logic bank1_info0_page_cfg_7_ecc_en_7_wd;
  logic bank1_info0_page_cfg_7_ecc_en_7_we;
  logic bank1_info0_page_cfg_7_he_en_7_qs;
  logic bank1_info0_page_cfg_7_he_en_7_wd;
  logic bank1_info0_page_cfg_7_he_en_7_we;
  logic bank1_info0_page_cfg_8_en_8_qs;
  logic bank1_info0_page_cfg_8_en_8_wd;
  logic bank1_info0_page_cfg_8_en_8_we;
  logic bank1_info0_page_cfg_8_rd_en_8_qs;
  logic bank1_info0_page_cfg_8_rd_en_8_wd;
  logic bank1_info0_page_cfg_8_rd_en_8_we;
  logic bank1_info0_page_cfg_8_prog_en_8_qs;
  logic bank1_info0_page_cfg_8_prog_en_8_wd;
  logic bank1_info0_page_cfg_8_prog_en_8_we;
  logic bank1_info0_page_cfg_8_erase_en_8_qs;
  logic bank1_info0_page_cfg_8_erase_en_8_wd;
  logic bank1_info0_page_cfg_8_erase_en_8_we;
  logic bank1_info0_page_cfg_8_scramble_en_8_qs;
  logic bank1_info0_page_cfg_8_scramble_en_8_wd;
  logic bank1_info0_page_cfg_8_scramble_en_8_we;
  logic bank1_info0_page_cfg_8_ecc_en_8_qs;
  logic bank1_info0_page_cfg_8_ecc_en_8_wd;
  logic bank1_info0_page_cfg_8_ecc_en_8_we;
  logic bank1_info0_page_cfg_8_he_en_8_qs;
  logic bank1_info0_page_cfg_8_he_en_8_wd;
  logic bank1_info0_page_cfg_8_he_en_8_we;
  logic bank1_info0_page_cfg_9_en_9_qs;
  logic bank1_info0_page_cfg_9_en_9_wd;
  logic bank1_info0_page_cfg_9_en_9_we;
  logic bank1_info0_page_cfg_9_rd_en_9_qs;
  logic bank1_info0_page_cfg_9_rd_en_9_wd;
  logic bank1_info0_page_cfg_9_rd_en_9_we;
  logic bank1_info0_page_cfg_9_prog_en_9_qs;
  logic bank1_info0_page_cfg_9_prog_en_9_wd;
  logic bank1_info0_page_cfg_9_prog_en_9_we;
  logic bank1_info0_page_cfg_9_erase_en_9_qs;
  logic bank1_info0_page_cfg_9_erase_en_9_wd;
  logic bank1_info0_page_cfg_9_erase_en_9_we;
  logic bank1_info0_page_cfg_9_scramble_en_9_qs;
  logic bank1_info0_page_cfg_9_scramble_en_9_wd;
  logic bank1_info0_page_cfg_9_scramble_en_9_we;
  logic bank1_info0_page_cfg_9_ecc_en_9_qs;
  logic bank1_info0_page_cfg_9_ecc_en_9_wd;
  logic bank1_info0_page_cfg_9_ecc_en_9_we;
  logic bank1_info0_page_cfg_9_he_en_9_qs;
  logic bank1_info0_page_cfg_9_he_en_9_wd;
  logic bank1_info0_page_cfg_9_he_en_9_we;
  logic bank1_info1_regwen_qs;
  logic bank1_info1_regwen_wd;
  logic bank1_info1_regwen_we;
  logic bank1_info1_page_cfg_en_0_qs;
  logic bank1_info1_page_cfg_en_0_wd;
  logic bank1_info1_page_cfg_en_0_we;
  logic bank1_info1_page_cfg_rd_en_0_qs;
  logic bank1_info1_page_cfg_rd_en_0_wd;
  logic bank1_info1_page_cfg_rd_en_0_we;
  logic bank1_info1_page_cfg_prog_en_0_qs;
  logic bank1_info1_page_cfg_prog_en_0_wd;
  logic bank1_info1_page_cfg_prog_en_0_we;
  logic bank1_info1_page_cfg_erase_en_0_qs;
  logic bank1_info1_page_cfg_erase_en_0_wd;
  logic bank1_info1_page_cfg_erase_en_0_we;
  logic bank1_info1_page_cfg_scramble_en_0_qs;
  logic bank1_info1_page_cfg_scramble_en_0_wd;
  logic bank1_info1_page_cfg_scramble_en_0_we;
  logic bank1_info1_page_cfg_ecc_en_0_qs;
  logic bank1_info1_page_cfg_ecc_en_0_wd;
  logic bank1_info1_page_cfg_ecc_en_0_we;
  logic bank1_info1_page_cfg_he_en_0_qs;
  logic bank1_info1_page_cfg_he_en_0_wd;
  logic bank1_info1_page_cfg_he_en_0_we;
  logic bank1_info2_regwen_0_qs;
  logic bank1_info2_regwen_0_wd;
  logic bank1_info2_regwen_0_we;
  logic bank1_info2_regwen_1_qs;
  logic bank1_info2_regwen_1_wd;
  logic bank1_info2_regwen_1_we;
  logic bank1_info2_page_cfg_0_en_0_qs;
  logic bank1_info2_page_cfg_0_en_0_wd;
  logic bank1_info2_page_cfg_0_en_0_we;
  logic bank1_info2_page_cfg_0_rd_en_0_qs;
  logic bank1_info2_page_cfg_0_rd_en_0_wd;
  logic bank1_info2_page_cfg_0_rd_en_0_we;
  logic bank1_info2_page_cfg_0_prog_en_0_qs;
  logic bank1_info2_page_cfg_0_prog_en_0_wd;
  logic bank1_info2_page_cfg_0_prog_en_0_we;
  logic bank1_info2_page_cfg_0_erase_en_0_qs;
  logic bank1_info2_page_cfg_0_erase_en_0_wd;
  logic bank1_info2_page_cfg_0_erase_en_0_we;
  logic bank1_info2_page_cfg_0_scramble_en_0_qs;
  logic bank1_info2_page_cfg_0_scramble_en_0_wd;
  logic bank1_info2_page_cfg_0_scramble_en_0_we;
  logic bank1_info2_page_cfg_0_ecc_en_0_qs;
  logic bank1_info2_page_cfg_0_ecc_en_0_wd;
  logic bank1_info2_page_cfg_0_ecc_en_0_we;
  logic bank1_info2_page_cfg_0_he_en_0_qs;
  logic bank1_info2_page_cfg_0_he_en_0_wd;
  logic bank1_info2_page_cfg_0_he_en_0_we;
  logic bank1_info2_page_cfg_1_en_1_qs;
  logic bank1_info2_page_cfg_1_en_1_wd;
  logic bank1_info2_page_cfg_1_en_1_we;
  logic bank1_info2_page_cfg_1_rd_en_1_qs;
  logic bank1_info2_page_cfg_1_rd_en_1_wd;
  logic bank1_info2_page_cfg_1_rd_en_1_we;
  logic bank1_info2_page_cfg_1_prog_en_1_qs;
  logic bank1_info2_page_cfg_1_prog_en_1_wd;
  logic bank1_info2_page_cfg_1_prog_en_1_we;
  logic bank1_info2_page_cfg_1_erase_en_1_qs;
  logic bank1_info2_page_cfg_1_erase_en_1_wd;
  logic bank1_info2_page_cfg_1_erase_en_1_we;
  logic bank1_info2_page_cfg_1_scramble_en_1_qs;
  logic bank1_info2_page_cfg_1_scramble_en_1_wd;
  logic bank1_info2_page_cfg_1_scramble_en_1_we;
  logic bank1_info2_page_cfg_1_ecc_en_1_qs;
  logic bank1_info2_page_cfg_1_ecc_en_1_wd;
  logic bank1_info2_page_cfg_1_ecc_en_1_we;
  logic bank1_info2_page_cfg_1_he_en_1_qs;
  logic bank1_info2_page_cfg_1_he_en_1_wd;
  logic bank1_info2_page_cfg_1_he_en_1_we;
  logic bank_cfg_regwen_qs;
  logic bank_cfg_regwen_wd;
  logic bank_cfg_regwen_we;
  logic mp_bank_cfg_erase_en_0_qs;
  logic mp_bank_cfg_erase_en_0_wd;
  logic mp_bank_cfg_erase_en_0_we;
  logic mp_bank_cfg_erase_en_1_qs;
  logic mp_bank_cfg_erase_en_1_wd;
  logic mp_bank_cfg_erase_en_1_we;
  logic op_status_done_qs;
  logic op_status_done_wd;
  logic op_status_done_we;
  logic op_status_err_qs;
  logic op_status_err_wd;
  logic op_status_err_we;
  logic status_rd_full_qs;
  logic status_rd_empty_qs;
  logic status_prog_full_qs;
  logic status_prog_empty_qs;
  logic status_init_wip_qs;
  logic err_code_flash_err_qs;
  logic err_code_flash_err_wd;
  logic err_code_flash_err_we;
  logic err_code_flash_alert_qs;
  logic err_code_flash_alert_wd;
  logic err_code_flash_alert_we;
  logic err_code_mp_err_qs;
  logic err_code_mp_err_wd;
  logic err_code_mp_err_we;
  logic err_code_ecc_single_err_qs;
  logic err_code_ecc_single_err_wd;
  logic err_code_ecc_single_err_we;
  logic err_code_ecc_multi_err_qs;
  logic err_code_ecc_multi_err_wd;
  logic err_code_ecc_multi_err_we;
  logic [8:0] err_addr_qs;
  logic [19:0] ecc_err_addr_0_qs;
  logic [19:0] ecc_err_addr_1_qs;
  logic phy_alert_cfg_alert_ack_qs;
  logic phy_alert_cfg_alert_ack_wd;
  logic phy_alert_cfg_alert_ack_we;
  logic phy_alert_cfg_alert_trig_qs;
  logic phy_alert_cfg_alert_trig_wd;
  logic phy_alert_cfg_alert_trig_we;
  logic phy_status_init_wip_qs;
  logic phy_status_prog_normal_avail_qs;
  logic phy_status_prog_repair_avail_qs;
  logic [31:0] scratch_qs;
  logic [31:0] scratch_wd;
  logic scratch_we;
  logic [4:0] fifo_lvl_prog_qs;
  logic [4:0] fifo_lvl_prog_wd;
  logic fifo_lvl_prog_we;
  logic [4:0] fifo_lvl_rd_qs;
  logic [4:0] fifo_lvl_rd_wd;
  logic fifo_lvl_rd_we;
  logic fifo_rst_qs;
  logic fifo_rst_wd;
  logic fifo_rst_we;

  // Register instances
  // R[intr_state]: V(False)

  //   F[prog_empty]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_prog_empty (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_prog_empty_we),
    .wd     (intr_state_prog_empty_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.prog_empty.de),
    .d      (hw2reg.intr_state.prog_empty.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.prog_empty.q ),

    // to register interface (read)
    .qs     (intr_state_prog_empty_qs)
  );


  //   F[prog_lvl]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_prog_lvl (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_prog_lvl_we),
    .wd     (intr_state_prog_lvl_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.prog_lvl.de),
    .d      (hw2reg.intr_state.prog_lvl.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.prog_lvl.q ),

    // to register interface (read)
    .qs     (intr_state_prog_lvl_qs)
  );


  //   F[rd_full]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_rd_full (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_rd_full_we),
    .wd     (intr_state_rd_full_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.rd_full.de),
    .d      (hw2reg.intr_state.rd_full.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.rd_full.q ),

    // to register interface (read)
    .qs     (intr_state_rd_full_qs)
  );


  //   F[rd_lvl]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_rd_lvl (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_rd_lvl_we),
    .wd     (intr_state_rd_lvl_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.rd_lvl.de),
    .d      (hw2reg.intr_state.rd_lvl.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.rd_lvl.q ),

    // to register interface (read)
    .qs     (intr_state_rd_lvl_qs)
  );


  //   F[op_done]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_op_done (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_op_done_we),
    .wd     (intr_state_op_done_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.op_done.de),
    .d      (hw2reg.intr_state.op_done.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.op_done.q ),

    // to register interface (read)
    .qs     (intr_state_op_done_qs)
  );


  // R[intr_enable]: V(False)

  //   F[prog_empty]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_prog_empty (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_prog_empty_we),
    .wd     (intr_enable_prog_empty_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.prog_empty.q ),

    // to register interface (read)
    .qs     (intr_enable_prog_empty_qs)
  );


  //   F[prog_lvl]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_prog_lvl (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_prog_lvl_we),
    .wd     (intr_enable_prog_lvl_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.prog_lvl.q ),

    // to register interface (read)
    .qs     (intr_enable_prog_lvl_qs)
  );


  //   F[rd_full]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_rd_full (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_rd_full_we),
    .wd     (intr_enable_rd_full_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.rd_full.q ),

    // to register interface (read)
    .qs     (intr_enable_rd_full_qs)
  );


  //   F[rd_lvl]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_rd_lvl (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_rd_lvl_we),
    .wd     (intr_enable_rd_lvl_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.rd_lvl.q ),

    // to register interface (read)
    .qs     (intr_enable_rd_lvl_qs)
  );


  //   F[op_done]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_op_done (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_op_done_we),
    .wd     (intr_enable_op_done_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.op_done.q ),

    // to register interface (read)
    .qs     (intr_enable_op_done_qs)
  );


  // R[intr_test]: V(True)

  //   F[prog_empty]: 0:0
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_prog_empty (
    .re     (1'b0),
    .we     (intr_test_prog_empty_we),
    .wd     (intr_test_prog_empty_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.prog_empty.qe),
    .q      (reg2hw.intr_test.prog_empty.q ),
    .qs     ()
  );


  //   F[prog_lvl]: 1:1
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_prog_lvl (
    .re     (1'b0),
    .we     (intr_test_prog_lvl_we),
    .wd     (intr_test_prog_lvl_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.prog_lvl.qe),
    .q      (reg2hw.intr_test.prog_lvl.q ),
    .qs     ()
  );


  //   F[rd_full]: 2:2
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_rd_full (
    .re     (1'b0),
    .we     (intr_test_rd_full_we),
    .wd     (intr_test_rd_full_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.rd_full.qe),
    .q      (reg2hw.intr_test.rd_full.q ),
    .qs     ()
  );


  //   F[rd_lvl]: 3:3
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_rd_lvl (
    .re     (1'b0),
    .we     (intr_test_rd_lvl_we),
    .wd     (intr_test_rd_lvl_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.rd_lvl.qe),
    .q      (reg2hw.intr_test.rd_lvl.q ),
    .qs     ()
  );


  //   F[op_done]: 4:4
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_op_done (
    .re     (1'b0),
    .we     (intr_test_op_done_we),
    .wd     (intr_test_op_done_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.op_done.qe),
    .q      (reg2hw.intr_test.op_done.q ),
    .qs     ()
  );


  // R[alert_test]: V(True)

  //   F[recov_err]: 0:0
  prim_subreg_ext #(
    .DW    (1)
  ) u_alert_test_recov_err (
    .re     (1'b0),
    .we     (alert_test_recov_err_we),
    .wd     (alert_test_recov_err_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.alert_test.recov_err.qe),
    .q      (reg2hw.alert_test.recov_err.q ),
    .qs     ()
  );


  //   F[recov_mp_err]: 1:1
  prim_subreg_ext #(
    .DW    (1)
  ) u_alert_test_recov_mp_err (
    .re     (1'b0),
    .we     (alert_test_recov_mp_err_we),
    .wd     (alert_test_recov_mp_err_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.alert_test.recov_mp_err.qe),
    .q      (reg2hw.alert_test.recov_mp_err.q ),
    .qs     ()
  );


  //   F[recov_ecc_err]: 2:2
  prim_subreg_ext #(
    .DW    (1)
  ) u_alert_test_recov_ecc_err (
    .re     (1'b0),
    .we     (alert_test_recov_ecc_err_we),
    .wd     (alert_test_recov_ecc_err_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.alert_test.recov_ecc_err.qe),
    .q      (reg2hw.alert_test.recov_ecc_err.q ),
    .qs     ()
  );


  // R[ctrl_regwen]: V(True)

  prim_subreg_ext #(
    .DW    (1)
  ) u_ctrl_regwen (
    .re     (ctrl_regwen_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.ctrl_regwen.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (ctrl_regwen_qs)
  );


  // R[control]: V(False)

  //   F[start]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_control_start (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (control_start_we & ctrl_regwen_qs),
    .wd     (control_start_wd),

    // from internal hardware
    .de     (hw2reg.control.start.de),
    .d      (hw2reg.control.start.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.control.start.q ),

    // to register interface (read)
    .qs     (control_start_qs)
  );


  //   F[op]: 5:4
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_control_op (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (control_op_we & ctrl_regwen_qs),
    .wd     (control_op_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.control.op.q ),

    // to register interface (read)
    .qs     (control_op_qs)
  );


  //   F[prog_sel]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_control_prog_sel (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (control_prog_sel_we & ctrl_regwen_qs),
    .wd     (control_prog_sel_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.control.prog_sel.q ),

    // to register interface (read)
    .qs     (control_prog_sel_qs)
  );


  //   F[erase_sel]: 7:7
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_control_erase_sel (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (control_erase_sel_we & ctrl_regwen_qs),
    .wd     (control_erase_sel_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.control.erase_sel.q ),

    // to register interface (read)
    .qs     (control_erase_sel_qs)
  );


  //   F[partition_sel]: 8:8
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_control_partition_sel (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (control_partition_sel_we & ctrl_regwen_qs),
    .wd     (control_partition_sel_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.control.partition_sel.q ),

    // to register interface (read)
    .qs     (control_partition_sel_qs)
  );


  //   F[info_sel]: 10:9
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_control_info_sel (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (control_info_sel_we & ctrl_regwen_qs),
    .wd     (control_info_sel_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.control.info_sel.q ),

    // to register interface (read)
    .qs     (control_info_sel_qs)
  );


  //   F[num]: 27:16
  prim_subreg #(
    .DW      (12),
    .SWACCESS("RW"),
    .RESVAL  (12'h0)
  ) u_control_num (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (control_num_we & ctrl_regwen_qs),
    .wd     (control_num_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.control.num.q ),

    // to register interface (read)
    .qs     (control_num_qs)
  );


  // R[addr]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_addr (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (addr_we),
    .wd     (addr_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.addr.q ),

    // to register interface (read)
    .qs     (addr_qs)
  );


  // R[prog_type_en]: V(False)

  //   F[normal]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_prog_type_en_normal (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prog_type_en_normal_we),
    .wd     (prog_type_en_normal_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prog_type_en.normal.q ),

    // to register interface (read)
    .qs     (prog_type_en_normal_qs)
  );


  //   F[repair]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_prog_type_en_repair (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (prog_type_en_repair_we),
    .wd     (prog_type_en_repair_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.prog_type_en.repair.q ),

    // to register interface (read)
    .qs     (prog_type_en_repair_qs)
  );


  // R[erase_suspend]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_erase_suspend (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (erase_suspend_we),
    .wd     (erase_suspend_wd),

    // from internal hardware
    .de     (hw2reg.erase_suspend.de),
    .d      (hw2reg.erase_suspend.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.erase_suspend.q ),

    // to register interface (read)
    .qs     (erase_suspend_qs)
  );



  // Subregister 0 of Multireg region_cfg_regwen
  // R[region_cfg_regwen_0]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_region_cfg_regwen_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (region_cfg_regwen_0_we),
    .wd     (region_cfg_regwen_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (region_cfg_regwen_0_qs)
  );

  // Subregister 1 of Multireg region_cfg_regwen
  // R[region_cfg_regwen_1]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_region_cfg_regwen_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (region_cfg_regwen_1_we),
    .wd     (region_cfg_regwen_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (region_cfg_regwen_1_qs)
  );

  // Subregister 2 of Multireg region_cfg_regwen
  // R[region_cfg_regwen_2]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_region_cfg_regwen_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (region_cfg_regwen_2_we),
    .wd     (region_cfg_regwen_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (region_cfg_regwen_2_qs)
  );

  // Subregister 3 of Multireg region_cfg_regwen
  // R[region_cfg_regwen_3]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_region_cfg_regwen_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (region_cfg_regwen_3_we),
    .wd     (region_cfg_regwen_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (region_cfg_regwen_3_qs)
  );

  // Subregister 4 of Multireg region_cfg_regwen
  // R[region_cfg_regwen_4]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_region_cfg_regwen_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (region_cfg_regwen_4_we),
    .wd     (region_cfg_regwen_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (region_cfg_regwen_4_qs)
  );

  // Subregister 5 of Multireg region_cfg_regwen
  // R[region_cfg_regwen_5]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_region_cfg_regwen_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (region_cfg_regwen_5_we),
    .wd     (region_cfg_regwen_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (region_cfg_regwen_5_qs)
  );

  // Subregister 6 of Multireg region_cfg_regwen
  // R[region_cfg_regwen_6]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_region_cfg_regwen_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (region_cfg_regwen_6_we),
    .wd     (region_cfg_regwen_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (region_cfg_regwen_6_qs)
  );

  // Subregister 7 of Multireg region_cfg_regwen
  // R[region_cfg_regwen_7]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_region_cfg_regwen_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (region_cfg_regwen_7_we),
    .wd     (region_cfg_regwen_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (region_cfg_regwen_7_qs)
  );



  // Subregister 0 of Multireg mp_region_cfg
  // R[mp_region_cfg_0]: V(False)

  // F[en_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_0_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_0_en_0_we & region_cfg_regwen_0_qs),
    .wd     (mp_region_cfg_0_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[0].en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_0_en_0_qs)
  );


  // F[rd_en_0]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_0_rd_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_0_rd_en_0_we & region_cfg_regwen_0_qs),
    .wd     (mp_region_cfg_0_rd_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[0].rd_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_0_rd_en_0_qs)
  );


  // F[prog_en_0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_0_prog_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_0_prog_en_0_we & region_cfg_regwen_0_qs),
    .wd     (mp_region_cfg_0_prog_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[0].prog_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_0_prog_en_0_qs)
  );


  // F[erase_en_0]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_0_erase_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_0_erase_en_0_we & region_cfg_regwen_0_qs),
    .wd     (mp_region_cfg_0_erase_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[0].erase_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_0_erase_en_0_qs)
  );


  // F[scramble_en_0]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_0_scramble_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_0_scramble_en_0_we & region_cfg_regwen_0_qs),
    .wd     (mp_region_cfg_0_scramble_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[0].scramble_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_0_scramble_en_0_qs)
  );


  // F[ecc_en_0]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_0_ecc_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_0_ecc_en_0_we & region_cfg_regwen_0_qs),
    .wd     (mp_region_cfg_0_ecc_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[0].ecc_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_0_ecc_en_0_qs)
  );


  // F[he_en_0]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_0_he_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_0_he_en_0_we & region_cfg_regwen_0_qs),
    .wd     (mp_region_cfg_0_he_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[0].he_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_0_he_en_0_qs)
  );


  // F[base_0]: 16:8
  prim_subreg #(
    .DW      (9),
    .SWACCESS("RW"),
    .RESVAL  (9'h0)
  ) u_mp_region_cfg_0_base_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_0_base_0_we & region_cfg_regwen_0_qs),
    .wd     (mp_region_cfg_0_base_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[0].base.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_0_base_0_qs)
  );


  // F[size_0]: 26:17
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_mp_region_cfg_0_size_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_0_size_0_we & region_cfg_regwen_0_qs),
    .wd     (mp_region_cfg_0_size_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[0].size.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_0_size_0_qs)
  );


  // Subregister 1 of Multireg mp_region_cfg
  // R[mp_region_cfg_1]: V(False)

  // F[en_1]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_1_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_1_en_1_we & region_cfg_regwen_1_qs),
    .wd     (mp_region_cfg_1_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[1].en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_1_en_1_qs)
  );


  // F[rd_en_1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_1_rd_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_1_rd_en_1_we & region_cfg_regwen_1_qs),
    .wd     (mp_region_cfg_1_rd_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[1].rd_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_1_rd_en_1_qs)
  );


  // F[prog_en_1]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_1_prog_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_1_prog_en_1_we & region_cfg_regwen_1_qs),
    .wd     (mp_region_cfg_1_prog_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[1].prog_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_1_prog_en_1_qs)
  );


  // F[erase_en_1]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_1_erase_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_1_erase_en_1_we & region_cfg_regwen_1_qs),
    .wd     (mp_region_cfg_1_erase_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[1].erase_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_1_erase_en_1_qs)
  );


  // F[scramble_en_1]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_1_scramble_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_1_scramble_en_1_we & region_cfg_regwen_1_qs),
    .wd     (mp_region_cfg_1_scramble_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[1].scramble_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_1_scramble_en_1_qs)
  );


  // F[ecc_en_1]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_1_ecc_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_1_ecc_en_1_we & region_cfg_regwen_1_qs),
    .wd     (mp_region_cfg_1_ecc_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[1].ecc_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_1_ecc_en_1_qs)
  );


  // F[he_en_1]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_1_he_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_1_he_en_1_we & region_cfg_regwen_1_qs),
    .wd     (mp_region_cfg_1_he_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[1].he_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_1_he_en_1_qs)
  );


  // F[base_1]: 16:8
  prim_subreg #(
    .DW      (9),
    .SWACCESS("RW"),
    .RESVAL  (9'h0)
  ) u_mp_region_cfg_1_base_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_1_base_1_we & region_cfg_regwen_1_qs),
    .wd     (mp_region_cfg_1_base_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[1].base.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_1_base_1_qs)
  );


  // F[size_1]: 26:17
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_mp_region_cfg_1_size_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_1_size_1_we & region_cfg_regwen_1_qs),
    .wd     (mp_region_cfg_1_size_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[1].size.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_1_size_1_qs)
  );


  // Subregister 2 of Multireg mp_region_cfg
  // R[mp_region_cfg_2]: V(False)

  // F[en_2]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_2_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_2_en_2_we & region_cfg_regwen_2_qs),
    .wd     (mp_region_cfg_2_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[2].en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_2_en_2_qs)
  );


  // F[rd_en_2]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_2_rd_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_2_rd_en_2_we & region_cfg_regwen_2_qs),
    .wd     (mp_region_cfg_2_rd_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[2].rd_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_2_rd_en_2_qs)
  );


  // F[prog_en_2]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_2_prog_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_2_prog_en_2_we & region_cfg_regwen_2_qs),
    .wd     (mp_region_cfg_2_prog_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[2].prog_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_2_prog_en_2_qs)
  );


  // F[erase_en_2]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_2_erase_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_2_erase_en_2_we & region_cfg_regwen_2_qs),
    .wd     (mp_region_cfg_2_erase_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[2].erase_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_2_erase_en_2_qs)
  );


  // F[scramble_en_2]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_2_scramble_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_2_scramble_en_2_we & region_cfg_regwen_2_qs),
    .wd     (mp_region_cfg_2_scramble_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[2].scramble_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_2_scramble_en_2_qs)
  );


  // F[ecc_en_2]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_2_ecc_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_2_ecc_en_2_we & region_cfg_regwen_2_qs),
    .wd     (mp_region_cfg_2_ecc_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[2].ecc_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_2_ecc_en_2_qs)
  );


  // F[he_en_2]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_2_he_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_2_he_en_2_we & region_cfg_regwen_2_qs),
    .wd     (mp_region_cfg_2_he_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[2].he_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_2_he_en_2_qs)
  );


  // F[base_2]: 16:8
  prim_subreg #(
    .DW      (9),
    .SWACCESS("RW"),
    .RESVAL  (9'h0)
  ) u_mp_region_cfg_2_base_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_2_base_2_we & region_cfg_regwen_2_qs),
    .wd     (mp_region_cfg_2_base_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[2].base.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_2_base_2_qs)
  );


  // F[size_2]: 26:17
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_mp_region_cfg_2_size_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_2_size_2_we & region_cfg_regwen_2_qs),
    .wd     (mp_region_cfg_2_size_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[2].size.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_2_size_2_qs)
  );


  // Subregister 3 of Multireg mp_region_cfg
  // R[mp_region_cfg_3]: V(False)

  // F[en_3]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_3_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_3_en_3_we & region_cfg_regwen_3_qs),
    .wd     (mp_region_cfg_3_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[3].en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_3_en_3_qs)
  );


  // F[rd_en_3]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_3_rd_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_3_rd_en_3_we & region_cfg_regwen_3_qs),
    .wd     (mp_region_cfg_3_rd_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[3].rd_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_3_rd_en_3_qs)
  );


  // F[prog_en_3]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_3_prog_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_3_prog_en_3_we & region_cfg_regwen_3_qs),
    .wd     (mp_region_cfg_3_prog_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[3].prog_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_3_prog_en_3_qs)
  );


  // F[erase_en_3]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_3_erase_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_3_erase_en_3_we & region_cfg_regwen_3_qs),
    .wd     (mp_region_cfg_3_erase_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[3].erase_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_3_erase_en_3_qs)
  );


  // F[scramble_en_3]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_3_scramble_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_3_scramble_en_3_we & region_cfg_regwen_3_qs),
    .wd     (mp_region_cfg_3_scramble_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[3].scramble_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_3_scramble_en_3_qs)
  );


  // F[ecc_en_3]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_3_ecc_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_3_ecc_en_3_we & region_cfg_regwen_3_qs),
    .wd     (mp_region_cfg_3_ecc_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[3].ecc_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_3_ecc_en_3_qs)
  );


  // F[he_en_3]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_3_he_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_3_he_en_3_we & region_cfg_regwen_3_qs),
    .wd     (mp_region_cfg_3_he_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[3].he_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_3_he_en_3_qs)
  );


  // F[base_3]: 16:8
  prim_subreg #(
    .DW      (9),
    .SWACCESS("RW"),
    .RESVAL  (9'h0)
  ) u_mp_region_cfg_3_base_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_3_base_3_we & region_cfg_regwen_3_qs),
    .wd     (mp_region_cfg_3_base_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[3].base.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_3_base_3_qs)
  );


  // F[size_3]: 26:17
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_mp_region_cfg_3_size_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_3_size_3_we & region_cfg_regwen_3_qs),
    .wd     (mp_region_cfg_3_size_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[3].size.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_3_size_3_qs)
  );


  // Subregister 4 of Multireg mp_region_cfg
  // R[mp_region_cfg_4]: V(False)

  // F[en_4]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_4_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_4_en_4_we & region_cfg_regwen_4_qs),
    .wd     (mp_region_cfg_4_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[4].en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_4_en_4_qs)
  );


  // F[rd_en_4]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_4_rd_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_4_rd_en_4_we & region_cfg_regwen_4_qs),
    .wd     (mp_region_cfg_4_rd_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[4].rd_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_4_rd_en_4_qs)
  );


  // F[prog_en_4]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_4_prog_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_4_prog_en_4_we & region_cfg_regwen_4_qs),
    .wd     (mp_region_cfg_4_prog_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[4].prog_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_4_prog_en_4_qs)
  );


  // F[erase_en_4]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_4_erase_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_4_erase_en_4_we & region_cfg_regwen_4_qs),
    .wd     (mp_region_cfg_4_erase_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[4].erase_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_4_erase_en_4_qs)
  );


  // F[scramble_en_4]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_4_scramble_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_4_scramble_en_4_we & region_cfg_regwen_4_qs),
    .wd     (mp_region_cfg_4_scramble_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[4].scramble_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_4_scramble_en_4_qs)
  );


  // F[ecc_en_4]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_4_ecc_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_4_ecc_en_4_we & region_cfg_regwen_4_qs),
    .wd     (mp_region_cfg_4_ecc_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[4].ecc_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_4_ecc_en_4_qs)
  );


  // F[he_en_4]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_4_he_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_4_he_en_4_we & region_cfg_regwen_4_qs),
    .wd     (mp_region_cfg_4_he_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[4].he_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_4_he_en_4_qs)
  );


  // F[base_4]: 16:8
  prim_subreg #(
    .DW      (9),
    .SWACCESS("RW"),
    .RESVAL  (9'h0)
  ) u_mp_region_cfg_4_base_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_4_base_4_we & region_cfg_regwen_4_qs),
    .wd     (mp_region_cfg_4_base_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[4].base.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_4_base_4_qs)
  );


  // F[size_4]: 26:17
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_mp_region_cfg_4_size_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_4_size_4_we & region_cfg_regwen_4_qs),
    .wd     (mp_region_cfg_4_size_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[4].size.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_4_size_4_qs)
  );


  // Subregister 5 of Multireg mp_region_cfg
  // R[mp_region_cfg_5]: V(False)

  // F[en_5]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_5_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_5_en_5_we & region_cfg_regwen_5_qs),
    .wd     (mp_region_cfg_5_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[5].en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_5_en_5_qs)
  );


  // F[rd_en_5]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_5_rd_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_5_rd_en_5_we & region_cfg_regwen_5_qs),
    .wd     (mp_region_cfg_5_rd_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[5].rd_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_5_rd_en_5_qs)
  );


  // F[prog_en_5]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_5_prog_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_5_prog_en_5_we & region_cfg_regwen_5_qs),
    .wd     (mp_region_cfg_5_prog_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[5].prog_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_5_prog_en_5_qs)
  );


  // F[erase_en_5]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_5_erase_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_5_erase_en_5_we & region_cfg_regwen_5_qs),
    .wd     (mp_region_cfg_5_erase_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[5].erase_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_5_erase_en_5_qs)
  );


  // F[scramble_en_5]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_5_scramble_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_5_scramble_en_5_we & region_cfg_regwen_5_qs),
    .wd     (mp_region_cfg_5_scramble_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[5].scramble_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_5_scramble_en_5_qs)
  );


  // F[ecc_en_5]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_5_ecc_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_5_ecc_en_5_we & region_cfg_regwen_5_qs),
    .wd     (mp_region_cfg_5_ecc_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[5].ecc_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_5_ecc_en_5_qs)
  );


  // F[he_en_5]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_5_he_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_5_he_en_5_we & region_cfg_regwen_5_qs),
    .wd     (mp_region_cfg_5_he_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[5].he_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_5_he_en_5_qs)
  );


  // F[base_5]: 16:8
  prim_subreg #(
    .DW      (9),
    .SWACCESS("RW"),
    .RESVAL  (9'h0)
  ) u_mp_region_cfg_5_base_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_5_base_5_we & region_cfg_regwen_5_qs),
    .wd     (mp_region_cfg_5_base_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[5].base.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_5_base_5_qs)
  );


  // F[size_5]: 26:17
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_mp_region_cfg_5_size_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_5_size_5_we & region_cfg_regwen_5_qs),
    .wd     (mp_region_cfg_5_size_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[5].size.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_5_size_5_qs)
  );


  // Subregister 6 of Multireg mp_region_cfg
  // R[mp_region_cfg_6]: V(False)

  // F[en_6]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_6_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_6_en_6_we & region_cfg_regwen_6_qs),
    .wd     (mp_region_cfg_6_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[6].en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_6_en_6_qs)
  );


  // F[rd_en_6]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_6_rd_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_6_rd_en_6_we & region_cfg_regwen_6_qs),
    .wd     (mp_region_cfg_6_rd_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[6].rd_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_6_rd_en_6_qs)
  );


  // F[prog_en_6]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_6_prog_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_6_prog_en_6_we & region_cfg_regwen_6_qs),
    .wd     (mp_region_cfg_6_prog_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[6].prog_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_6_prog_en_6_qs)
  );


  // F[erase_en_6]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_6_erase_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_6_erase_en_6_we & region_cfg_regwen_6_qs),
    .wd     (mp_region_cfg_6_erase_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[6].erase_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_6_erase_en_6_qs)
  );


  // F[scramble_en_6]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_6_scramble_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_6_scramble_en_6_we & region_cfg_regwen_6_qs),
    .wd     (mp_region_cfg_6_scramble_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[6].scramble_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_6_scramble_en_6_qs)
  );


  // F[ecc_en_6]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_6_ecc_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_6_ecc_en_6_we & region_cfg_regwen_6_qs),
    .wd     (mp_region_cfg_6_ecc_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[6].ecc_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_6_ecc_en_6_qs)
  );


  // F[he_en_6]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_6_he_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_6_he_en_6_we & region_cfg_regwen_6_qs),
    .wd     (mp_region_cfg_6_he_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[6].he_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_6_he_en_6_qs)
  );


  // F[base_6]: 16:8
  prim_subreg #(
    .DW      (9),
    .SWACCESS("RW"),
    .RESVAL  (9'h0)
  ) u_mp_region_cfg_6_base_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_6_base_6_we & region_cfg_regwen_6_qs),
    .wd     (mp_region_cfg_6_base_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[6].base.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_6_base_6_qs)
  );


  // F[size_6]: 26:17
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_mp_region_cfg_6_size_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_6_size_6_we & region_cfg_regwen_6_qs),
    .wd     (mp_region_cfg_6_size_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[6].size.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_6_size_6_qs)
  );


  // Subregister 7 of Multireg mp_region_cfg
  // R[mp_region_cfg_7]: V(False)

  // F[en_7]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_7_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_7_en_7_we & region_cfg_regwen_7_qs),
    .wd     (mp_region_cfg_7_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[7].en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_7_en_7_qs)
  );


  // F[rd_en_7]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_7_rd_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_7_rd_en_7_we & region_cfg_regwen_7_qs),
    .wd     (mp_region_cfg_7_rd_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[7].rd_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_7_rd_en_7_qs)
  );


  // F[prog_en_7]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_7_prog_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_7_prog_en_7_we & region_cfg_regwen_7_qs),
    .wd     (mp_region_cfg_7_prog_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[7].prog_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_7_prog_en_7_qs)
  );


  // F[erase_en_7]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_7_erase_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_7_erase_en_7_we & region_cfg_regwen_7_qs),
    .wd     (mp_region_cfg_7_erase_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[7].erase_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_7_erase_en_7_qs)
  );


  // F[scramble_en_7]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_7_scramble_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_7_scramble_en_7_we & region_cfg_regwen_7_qs),
    .wd     (mp_region_cfg_7_scramble_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[7].scramble_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_7_scramble_en_7_qs)
  );


  // F[ecc_en_7]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_7_ecc_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_7_ecc_en_7_we & region_cfg_regwen_7_qs),
    .wd     (mp_region_cfg_7_ecc_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[7].ecc_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_7_ecc_en_7_qs)
  );


  // F[he_en_7]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_region_cfg_7_he_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_7_he_en_7_we & region_cfg_regwen_7_qs),
    .wd     (mp_region_cfg_7_he_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[7].he_en.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_7_he_en_7_qs)
  );


  // F[base_7]: 16:8
  prim_subreg #(
    .DW      (9),
    .SWACCESS("RW"),
    .RESVAL  (9'h0)
  ) u_mp_region_cfg_7_base_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_7_base_7_we & region_cfg_regwen_7_qs),
    .wd     (mp_region_cfg_7_base_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[7].base.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_7_base_7_qs)
  );


  // F[size_7]: 26:17
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_mp_region_cfg_7_size_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_region_cfg_7_size_7_we & region_cfg_regwen_7_qs),
    .wd     (mp_region_cfg_7_size_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_region_cfg[7].size.q ),

    // to register interface (read)
    .qs     (mp_region_cfg_7_size_7_qs)
  );



  // R[default_region]: V(False)

  //   F[rd_en]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_default_region_rd_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (default_region_rd_en_we),
    .wd     (default_region_rd_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.default_region.rd_en.q ),

    // to register interface (read)
    .qs     (default_region_rd_en_qs)
  );


  //   F[prog_en]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_default_region_prog_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (default_region_prog_en_we),
    .wd     (default_region_prog_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.default_region.prog_en.q ),

    // to register interface (read)
    .qs     (default_region_prog_en_qs)
  );


  //   F[erase_en]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_default_region_erase_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (default_region_erase_en_we),
    .wd     (default_region_erase_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.default_region.erase_en.q ),

    // to register interface (read)
    .qs     (default_region_erase_en_qs)
  );


  //   F[scramble_en]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_default_region_scramble_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (default_region_scramble_en_we),
    .wd     (default_region_scramble_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.default_region.scramble_en.q ),

    // to register interface (read)
    .qs     (default_region_scramble_en_qs)
  );


  //   F[ecc_en]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_default_region_ecc_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (default_region_ecc_en_we),
    .wd     (default_region_ecc_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.default_region.ecc_en.q ),

    // to register interface (read)
    .qs     (default_region_ecc_en_qs)
  );


  //   F[he_en]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_default_region_he_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (default_region_he_en_we),
    .wd     (default_region_he_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.default_region.he_en.q ),

    // to register interface (read)
    .qs     (default_region_he_en_qs)
  );



  // Subregister 0 of Multireg bank0_info0_regwen
  // R[bank0_info0_regwen_0]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank0_info0_regwen_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank0_info0_regwen_0_we),
    .wd     (bank0_info0_regwen_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank0_info0_regwen_0_qs)
  );

  // Subregister 1 of Multireg bank0_info0_regwen
  // R[bank0_info0_regwen_1]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank0_info0_regwen_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank0_info0_regwen_1_we),
    .wd     (bank0_info0_regwen_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank0_info0_regwen_1_qs)
  );

  // Subregister 2 of Multireg bank0_info0_regwen
  // R[bank0_info0_regwen_2]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank0_info0_regwen_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank0_info0_regwen_2_we),
    .wd     (bank0_info0_regwen_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank0_info0_regwen_2_qs)
  );

  // Subregister 3 of Multireg bank0_info0_regwen
  // R[bank0_info0_regwen_3]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank0_info0_regwen_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank0_info0_regwen_3_we),
    .wd     (bank0_info0_regwen_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank0_info0_regwen_3_qs)
  );

  // Subregister 4 of Multireg bank0_info0_regwen
  // R[bank0_info0_regwen_4]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank0_info0_regwen_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank0_info0_regwen_4_we),
    .wd     (bank0_info0_regwen_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank0_info0_regwen_4_qs)
  );

  // Subregister 5 of Multireg bank0_info0_regwen
  // R[bank0_info0_regwen_5]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank0_info0_regwen_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank0_info0_regwen_5_we),
    .wd     (bank0_info0_regwen_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank0_info0_regwen_5_qs)
  );

  // Subregister 6 of Multireg bank0_info0_regwen
  // R[bank0_info0_regwen_6]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank0_info0_regwen_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank0_info0_regwen_6_we),
    .wd     (bank0_info0_regwen_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank0_info0_regwen_6_qs)
  );

  // Subregister 7 of Multireg bank0_info0_regwen
  // R[bank0_info0_regwen_7]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank0_info0_regwen_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank0_info0_regwen_7_we),
    .wd     (bank0_info0_regwen_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank0_info0_regwen_7_qs)
  );

  // Subregister 8 of Multireg bank0_info0_regwen
  // R[bank0_info0_regwen_8]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank0_info0_regwen_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank0_info0_regwen_8_we),
    .wd     (bank0_info0_regwen_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank0_info0_regwen_8_qs)
  );

  // Subregister 9 of Multireg bank0_info0_regwen
  // R[bank0_info0_regwen_9]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank0_info0_regwen_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank0_info0_regwen_9_we),
    .wd     (bank0_info0_regwen_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank0_info0_regwen_9_qs)
  );



  // Subregister 0 of Multireg bank0_info0_page_cfg
  // R[bank0_info0_page_cfg_0]: V(False)

  // F[en_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_0_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_0_en_0_we & bank0_info0_regwen_0_qs),
    .wd     (bank0_info0_page_cfg_0_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[0].en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_0_en_0_qs)
  );


  // F[rd_en_0]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_0_rd_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_0_rd_en_0_we & bank0_info0_regwen_0_qs),
    .wd     (bank0_info0_page_cfg_0_rd_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[0].rd_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_0_rd_en_0_qs)
  );


  // F[prog_en_0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_0_prog_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_0_prog_en_0_we & bank0_info0_regwen_0_qs),
    .wd     (bank0_info0_page_cfg_0_prog_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[0].prog_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_0_prog_en_0_qs)
  );


  // F[erase_en_0]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_0_erase_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_0_erase_en_0_we & bank0_info0_regwen_0_qs),
    .wd     (bank0_info0_page_cfg_0_erase_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[0].erase_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_0_erase_en_0_qs)
  );


  // F[scramble_en_0]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_0_scramble_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_0_scramble_en_0_we & bank0_info0_regwen_0_qs),
    .wd     (bank0_info0_page_cfg_0_scramble_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[0].scramble_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_0_scramble_en_0_qs)
  );


  // F[ecc_en_0]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_0_ecc_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_0_ecc_en_0_we & bank0_info0_regwen_0_qs),
    .wd     (bank0_info0_page_cfg_0_ecc_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[0].ecc_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_0_ecc_en_0_qs)
  );


  // F[he_en_0]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_0_he_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_0_he_en_0_we & bank0_info0_regwen_0_qs),
    .wd     (bank0_info0_page_cfg_0_he_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[0].he_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_0_he_en_0_qs)
  );


  // Subregister 1 of Multireg bank0_info0_page_cfg
  // R[bank0_info0_page_cfg_1]: V(False)

  // F[en_1]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_1_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_1_en_1_we & bank0_info0_regwen_1_qs),
    .wd     (bank0_info0_page_cfg_1_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[1].en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_1_en_1_qs)
  );


  // F[rd_en_1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_1_rd_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_1_rd_en_1_we & bank0_info0_regwen_1_qs),
    .wd     (bank0_info0_page_cfg_1_rd_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[1].rd_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_1_rd_en_1_qs)
  );


  // F[prog_en_1]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_1_prog_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_1_prog_en_1_we & bank0_info0_regwen_1_qs),
    .wd     (bank0_info0_page_cfg_1_prog_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[1].prog_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_1_prog_en_1_qs)
  );


  // F[erase_en_1]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_1_erase_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_1_erase_en_1_we & bank0_info0_regwen_1_qs),
    .wd     (bank0_info0_page_cfg_1_erase_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[1].erase_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_1_erase_en_1_qs)
  );


  // F[scramble_en_1]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_1_scramble_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_1_scramble_en_1_we & bank0_info0_regwen_1_qs),
    .wd     (bank0_info0_page_cfg_1_scramble_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[1].scramble_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_1_scramble_en_1_qs)
  );


  // F[ecc_en_1]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_1_ecc_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_1_ecc_en_1_we & bank0_info0_regwen_1_qs),
    .wd     (bank0_info0_page_cfg_1_ecc_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[1].ecc_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_1_ecc_en_1_qs)
  );


  // F[he_en_1]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_1_he_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_1_he_en_1_we & bank0_info0_regwen_1_qs),
    .wd     (bank0_info0_page_cfg_1_he_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[1].he_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_1_he_en_1_qs)
  );


  // Subregister 2 of Multireg bank0_info0_page_cfg
  // R[bank0_info0_page_cfg_2]: V(False)

  // F[en_2]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_2_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_2_en_2_we & bank0_info0_regwen_2_qs),
    .wd     (bank0_info0_page_cfg_2_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[2].en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_2_en_2_qs)
  );


  // F[rd_en_2]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_2_rd_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_2_rd_en_2_we & bank0_info0_regwen_2_qs),
    .wd     (bank0_info0_page_cfg_2_rd_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[2].rd_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_2_rd_en_2_qs)
  );


  // F[prog_en_2]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_2_prog_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_2_prog_en_2_we & bank0_info0_regwen_2_qs),
    .wd     (bank0_info0_page_cfg_2_prog_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[2].prog_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_2_prog_en_2_qs)
  );


  // F[erase_en_2]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_2_erase_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_2_erase_en_2_we & bank0_info0_regwen_2_qs),
    .wd     (bank0_info0_page_cfg_2_erase_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[2].erase_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_2_erase_en_2_qs)
  );


  // F[scramble_en_2]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_2_scramble_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_2_scramble_en_2_we & bank0_info0_regwen_2_qs),
    .wd     (bank0_info0_page_cfg_2_scramble_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[2].scramble_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_2_scramble_en_2_qs)
  );


  // F[ecc_en_2]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_2_ecc_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_2_ecc_en_2_we & bank0_info0_regwen_2_qs),
    .wd     (bank0_info0_page_cfg_2_ecc_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[2].ecc_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_2_ecc_en_2_qs)
  );


  // F[he_en_2]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_2_he_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_2_he_en_2_we & bank0_info0_regwen_2_qs),
    .wd     (bank0_info0_page_cfg_2_he_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[2].he_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_2_he_en_2_qs)
  );


  // Subregister 3 of Multireg bank0_info0_page_cfg
  // R[bank0_info0_page_cfg_3]: V(False)

  // F[en_3]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_3_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_3_en_3_we & bank0_info0_regwen_3_qs),
    .wd     (bank0_info0_page_cfg_3_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[3].en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_3_en_3_qs)
  );


  // F[rd_en_3]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_3_rd_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_3_rd_en_3_we & bank0_info0_regwen_3_qs),
    .wd     (bank0_info0_page_cfg_3_rd_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[3].rd_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_3_rd_en_3_qs)
  );


  // F[prog_en_3]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_3_prog_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_3_prog_en_3_we & bank0_info0_regwen_3_qs),
    .wd     (bank0_info0_page_cfg_3_prog_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[3].prog_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_3_prog_en_3_qs)
  );


  // F[erase_en_3]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_3_erase_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_3_erase_en_3_we & bank0_info0_regwen_3_qs),
    .wd     (bank0_info0_page_cfg_3_erase_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[3].erase_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_3_erase_en_3_qs)
  );


  // F[scramble_en_3]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_3_scramble_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_3_scramble_en_3_we & bank0_info0_regwen_3_qs),
    .wd     (bank0_info0_page_cfg_3_scramble_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[3].scramble_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_3_scramble_en_3_qs)
  );


  // F[ecc_en_3]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_3_ecc_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_3_ecc_en_3_we & bank0_info0_regwen_3_qs),
    .wd     (bank0_info0_page_cfg_3_ecc_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[3].ecc_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_3_ecc_en_3_qs)
  );


  // F[he_en_3]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_3_he_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_3_he_en_3_we & bank0_info0_regwen_3_qs),
    .wd     (bank0_info0_page_cfg_3_he_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[3].he_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_3_he_en_3_qs)
  );


  // Subregister 4 of Multireg bank0_info0_page_cfg
  // R[bank0_info0_page_cfg_4]: V(False)

  // F[en_4]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_4_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_4_en_4_we & bank0_info0_regwen_4_qs),
    .wd     (bank0_info0_page_cfg_4_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[4].en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_4_en_4_qs)
  );


  // F[rd_en_4]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_4_rd_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_4_rd_en_4_we & bank0_info0_regwen_4_qs),
    .wd     (bank0_info0_page_cfg_4_rd_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[4].rd_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_4_rd_en_4_qs)
  );


  // F[prog_en_4]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_4_prog_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_4_prog_en_4_we & bank0_info0_regwen_4_qs),
    .wd     (bank0_info0_page_cfg_4_prog_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[4].prog_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_4_prog_en_4_qs)
  );


  // F[erase_en_4]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_4_erase_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_4_erase_en_4_we & bank0_info0_regwen_4_qs),
    .wd     (bank0_info0_page_cfg_4_erase_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[4].erase_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_4_erase_en_4_qs)
  );


  // F[scramble_en_4]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_4_scramble_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_4_scramble_en_4_we & bank0_info0_regwen_4_qs),
    .wd     (bank0_info0_page_cfg_4_scramble_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[4].scramble_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_4_scramble_en_4_qs)
  );


  // F[ecc_en_4]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_4_ecc_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_4_ecc_en_4_we & bank0_info0_regwen_4_qs),
    .wd     (bank0_info0_page_cfg_4_ecc_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[4].ecc_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_4_ecc_en_4_qs)
  );


  // F[he_en_4]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_4_he_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_4_he_en_4_we & bank0_info0_regwen_4_qs),
    .wd     (bank0_info0_page_cfg_4_he_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[4].he_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_4_he_en_4_qs)
  );


  // Subregister 5 of Multireg bank0_info0_page_cfg
  // R[bank0_info0_page_cfg_5]: V(False)

  // F[en_5]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_5_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_5_en_5_we & bank0_info0_regwen_5_qs),
    .wd     (bank0_info0_page_cfg_5_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[5].en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_5_en_5_qs)
  );


  // F[rd_en_5]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_5_rd_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_5_rd_en_5_we & bank0_info0_regwen_5_qs),
    .wd     (bank0_info0_page_cfg_5_rd_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[5].rd_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_5_rd_en_5_qs)
  );


  // F[prog_en_5]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_5_prog_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_5_prog_en_5_we & bank0_info0_regwen_5_qs),
    .wd     (bank0_info0_page_cfg_5_prog_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[5].prog_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_5_prog_en_5_qs)
  );


  // F[erase_en_5]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_5_erase_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_5_erase_en_5_we & bank0_info0_regwen_5_qs),
    .wd     (bank0_info0_page_cfg_5_erase_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[5].erase_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_5_erase_en_5_qs)
  );


  // F[scramble_en_5]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_5_scramble_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_5_scramble_en_5_we & bank0_info0_regwen_5_qs),
    .wd     (bank0_info0_page_cfg_5_scramble_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[5].scramble_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_5_scramble_en_5_qs)
  );


  // F[ecc_en_5]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_5_ecc_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_5_ecc_en_5_we & bank0_info0_regwen_5_qs),
    .wd     (bank0_info0_page_cfg_5_ecc_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[5].ecc_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_5_ecc_en_5_qs)
  );


  // F[he_en_5]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_5_he_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_5_he_en_5_we & bank0_info0_regwen_5_qs),
    .wd     (bank0_info0_page_cfg_5_he_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[5].he_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_5_he_en_5_qs)
  );


  // Subregister 6 of Multireg bank0_info0_page_cfg
  // R[bank0_info0_page_cfg_6]: V(False)

  // F[en_6]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_6_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_6_en_6_we & bank0_info0_regwen_6_qs),
    .wd     (bank0_info0_page_cfg_6_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[6].en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_6_en_6_qs)
  );


  // F[rd_en_6]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_6_rd_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_6_rd_en_6_we & bank0_info0_regwen_6_qs),
    .wd     (bank0_info0_page_cfg_6_rd_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[6].rd_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_6_rd_en_6_qs)
  );


  // F[prog_en_6]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_6_prog_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_6_prog_en_6_we & bank0_info0_regwen_6_qs),
    .wd     (bank0_info0_page_cfg_6_prog_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[6].prog_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_6_prog_en_6_qs)
  );


  // F[erase_en_6]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_6_erase_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_6_erase_en_6_we & bank0_info0_regwen_6_qs),
    .wd     (bank0_info0_page_cfg_6_erase_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[6].erase_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_6_erase_en_6_qs)
  );


  // F[scramble_en_6]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_6_scramble_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_6_scramble_en_6_we & bank0_info0_regwen_6_qs),
    .wd     (bank0_info0_page_cfg_6_scramble_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[6].scramble_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_6_scramble_en_6_qs)
  );


  // F[ecc_en_6]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_6_ecc_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_6_ecc_en_6_we & bank0_info0_regwen_6_qs),
    .wd     (bank0_info0_page_cfg_6_ecc_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[6].ecc_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_6_ecc_en_6_qs)
  );


  // F[he_en_6]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_6_he_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_6_he_en_6_we & bank0_info0_regwen_6_qs),
    .wd     (bank0_info0_page_cfg_6_he_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[6].he_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_6_he_en_6_qs)
  );


  // Subregister 7 of Multireg bank0_info0_page_cfg
  // R[bank0_info0_page_cfg_7]: V(False)

  // F[en_7]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_7_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_7_en_7_we & bank0_info0_regwen_7_qs),
    .wd     (bank0_info0_page_cfg_7_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[7].en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_7_en_7_qs)
  );


  // F[rd_en_7]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_7_rd_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_7_rd_en_7_we & bank0_info0_regwen_7_qs),
    .wd     (bank0_info0_page_cfg_7_rd_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[7].rd_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_7_rd_en_7_qs)
  );


  // F[prog_en_7]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_7_prog_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_7_prog_en_7_we & bank0_info0_regwen_7_qs),
    .wd     (bank0_info0_page_cfg_7_prog_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[7].prog_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_7_prog_en_7_qs)
  );


  // F[erase_en_7]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_7_erase_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_7_erase_en_7_we & bank0_info0_regwen_7_qs),
    .wd     (bank0_info0_page_cfg_7_erase_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[7].erase_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_7_erase_en_7_qs)
  );


  // F[scramble_en_7]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_7_scramble_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_7_scramble_en_7_we & bank0_info0_regwen_7_qs),
    .wd     (bank0_info0_page_cfg_7_scramble_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[7].scramble_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_7_scramble_en_7_qs)
  );


  // F[ecc_en_7]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_7_ecc_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_7_ecc_en_7_we & bank0_info0_regwen_7_qs),
    .wd     (bank0_info0_page_cfg_7_ecc_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[7].ecc_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_7_ecc_en_7_qs)
  );


  // F[he_en_7]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_7_he_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_7_he_en_7_we & bank0_info0_regwen_7_qs),
    .wd     (bank0_info0_page_cfg_7_he_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[7].he_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_7_he_en_7_qs)
  );


  // Subregister 8 of Multireg bank0_info0_page_cfg
  // R[bank0_info0_page_cfg_8]: V(False)

  // F[en_8]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_8_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_8_en_8_we & bank0_info0_regwen_8_qs),
    .wd     (bank0_info0_page_cfg_8_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[8].en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_8_en_8_qs)
  );


  // F[rd_en_8]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_8_rd_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_8_rd_en_8_we & bank0_info0_regwen_8_qs),
    .wd     (bank0_info0_page_cfg_8_rd_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[8].rd_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_8_rd_en_8_qs)
  );


  // F[prog_en_8]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_8_prog_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_8_prog_en_8_we & bank0_info0_regwen_8_qs),
    .wd     (bank0_info0_page_cfg_8_prog_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[8].prog_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_8_prog_en_8_qs)
  );


  // F[erase_en_8]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_8_erase_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_8_erase_en_8_we & bank0_info0_regwen_8_qs),
    .wd     (bank0_info0_page_cfg_8_erase_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[8].erase_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_8_erase_en_8_qs)
  );


  // F[scramble_en_8]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_8_scramble_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_8_scramble_en_8_we & bank0_info0_regwen_8_qs),
    .wd     (bank0_info0_page_cfg_8_scramble_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[8].scramble_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_8_scramble_en_8_qs)
  );


  // F[ecc_en_8]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_8_ecc_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_8_ecc_en_8_we & bank0_info0_regwen_8_qs),
    .wd     (bank0_info0_page_cfg_8_ecc_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[8].ecc_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_8_ecc_en_8_qs)
  );


  // F[he_en_8]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_8_he_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_8_he_en_8_we & bank0_info0_regwen_8_qs),
    .wd     (bank0_info0_page_cfg_8_he_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[8].he_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_8_he_en_8_qs)
  );


  // Subregister 9 of Multireg bank0_info0_page_cfg
  // R[bank0_info0_page_cfg_9]: V(False)

  // F[en_9]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_9_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_9_en_9_we & bank0_info0_regwen_9_qs),
    .wd     (bank0_info0_page_cfg_9_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[9].en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_9_en_9_qs)
  );


  // F[rd_en_9]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_9_rd_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_9_rd_en_9_we & bank0_info0_regwen_9_qs),
    .wd     (bank0_info0_page_cfg_9_rd_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[9].rd_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_9_rd_en_9_qs)
  );


  // F[prog_en_9]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_9_prog_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_9_prog_en_9_we & bank0_info0_regwen_9_qs),
    .wd     (bank0_info0_page_cfg_9_prog_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[9].prog_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_9_prog_en_9_qs)
  );


  // F[erase_en_9]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_9_erase_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_9_erase_en_9_we & bank0_info0_regwen_9_qs),
    .wd     (bank0_info0_page_cfg_9_erase_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[9].erase_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_9_erase_en_9_qs)
  );


  // F[scramble_en_9]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_9_scramble_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_9_scramble_en_9_we & bank0_info0_regwen_9_qs),
    .wd     (bank0_info0_page_cfg_9_scramble_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[9].scramble_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_9_scramble_en_9_qs)
  );


  // F[ecc_en_9]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_9_ecc_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_9_ecc_en_9_we & bank0_info0_regwen_9_qs),
    .wd     (bank0_info0_page_cfg_9_ecc_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[9].ecc_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_9_ecc_en_9_qs)
  );


  // F[he_en_9]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info0_page_cfg_9_he_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info0_page_cfg_9_he_en_9_we & bank0_info0_regwen_9_qs),
    .wd     (bank0_info0_page_cfg_9_he_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info0_page_cfg[9].he_en.q ),

    // to register interface (read)
    .qs     (bank0_info0_page_cfg_9_he_en_9_qs)
  );




  // Subregister 0 of Multireg bank0_info1_regwen
  // R[bank0_info1_regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank0_info1_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank0_info1_regwen_we),
    .wd     (bank0_info1_regwen_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank0_info1_regwen_qs)
  );



  // Subregister 0 of Multireg bank0_info1_page_cfg
  // R[bank0_info1_page_cfg]: V(False)

  // F[en_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info1_page_cfg_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info1_page_cfg_en_0_we & bank0_info1_regwen_qs),
    .wd     (bank0_info1_page_cfg_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info1_page_cfg[0].en.q ),

    // to register interface (read)
    .qs     (bank0_info1_page_cfg_en_0_qs)
  );


  // F[rd_en_0]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info1_page_cfg_rd_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info1_page_cfg_rd_en_0_we & bank0_info1_regwen_qs),
    .wd     (bank0_info1_page_cfg_rd_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info1_page_cfg[0].rd_en.q ),

    // to register interface (read)
    .qs     (bank0_info1_page_cfg_rd_en_0_qs)
  );


  // F[prog_en_0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info1_page_cfg_prog_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info1_page_cfg_prog_en_0_we & bank0_info1_regwen_qs),
    .wd     (bank0_info1_page_cfg_prog_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info1_page_cfg[0].prog_en.q ),

    // to register interface (read)
    .qs     (bank0_info1_page_cfg_prog_en_0_qs)
  );


  // F[erase_en_0]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info1_page_cfg_erase_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info1_page_cfg_erase_en_0_we & bank0_info1_regwen_qs),
    .wd     (bank0_info1_page_cfg_erase_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info1_page_cfg[0].erase_en.q ),

    // to register interface (read)
    .qs     (bank0_info1_page_cfg_erase_en_0_qs)
  );


  // F[scramble_en_0]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info1_page_cfg_scramble_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info1_page_cfg_scramble_en_0_we & bank0_info1_regwen_qs),
    .wd     (bank0_info1_page_cfg_scramble_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info1_page_cfg[0].scramble_en.q ),

    // to register interface (read)
    .qs     (bank0_info1_page_cfg_scramble_en_0_qs)
  );


  // F[ecc_en_0]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info1_page_cfg_ecc_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info1_page_cfg_ecc_en_0_we & bank0_info1_regwen_qs),
    .wd     (bank0_info1_page_cfg_ecc_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info1_page_cfg[0].ecc_en.q ),

    // to register interface (read)
    .qs     (bank0_info1_page_cfg_ecc_en_0_qs)
  );


  // F[he_en_0]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info1_page_cfg_he_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info1_page_cfg_he_en_0_we & bank0_info1_regwen_qs),
    .wd     (bank0_info1_page_cfg_he_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info1_page_cfg[0].he_en.q ),

    // to register interface (read)
    .qs     (bank0_info1_page_cfg_he_en_0_qs)
  );




  // Subregister 0 of Multireg bank0_info2_regwen
  // R[bank0_info2_regwen_0]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank0_info2_regwen_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank0_info2_regwen_0_we),
    .wd     (bank0_info2_regwen_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank0_info2_regwen_0_qs)
  );

  // Subregister 1 of Multireg bank0_info2_regwen
  // R[bank0_info2_regwen_1]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank0_info2_regwen_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank0_info2_regwen_1_we),
    .wd     (bank0_info2_regwen_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank0_info2_regwen_1_qs)
  );



  // Subregister 0 of Multireg bank0_info2_page_cfg
  // R[bank0_info2_page_cfg_0]: V(False)

  // F[en_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_0_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_0_en_0_we & bank0_info2_regwen_0_qs),
    .wd     (bank0_info2_page_cfg_0_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[0].en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_0_en_0_qs)
  );


  // F[rd_en_0]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_0_rd_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_0_rd_en_0_we & bank0_info2_regwen_0_qs),
    .wd     (bank0_info2_page_cfg_0_rd_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[0].rd_en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_0_rd_en_0_qs)
  );


  // F[prog_en_0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_0_prog_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_0_prog_en_0_we & bank0_info2_regwen_0_qs),
    .wd     (bank0_info2_page_cfg_0_prog_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[0].prog_en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_0_prog_en_0_qs)
  );


  // F[erase_en_0]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_0_erase_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_0_erase_en_0_we & bank0_info2_regwen_0_qs),
    .wd     (bank0_info2_page_cfg_0_erase_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[0].erase_en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_0_erase_en_0_qs)
  );


  // F[scramble_en_0]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_0_scramble_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_0_scramble_en_0_we & bank0_info2_regwen_0_qs),
    .wd     (bank0_info2_page_cfg_0_scramble_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[0].scramble_en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_0_scramble_en_0_qs)
  );


  // F[ecc_en_0]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_0_ecc_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_0_ecc_en_0_we & bank0_info2_regwen_0_qs),
    .wd     (bank0_info2_page_cfg_0_ecc_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[0].ecc_en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_0_ecc_en_0_qs)
  );


  // F[he_en_0]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_0_he_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_0_he_en_0_we & bank0_info2_regwen_0_qs),
    .wd     (bank0_info2_page_cfg_0_he_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[0].he_en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_0_he_en_0_qs)
  );


  // Subregister 1 of Multireg bank0_info2_page_cfg
  // R[bank0_info2_page_cfg_1]: V(False)

  // F[en_1]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_1_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_1_en_1_we & bank0_info2_regwen_1_qs),
    .wd     (bank0_info2_page_cfg_1_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[1].en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_1_en_1_qs)
  );


  // F[rd_en_1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_1_rd_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_1_rd_en_1_we & bank0_info2_regwen_1_qs),
    .wd     (bank0_info2_page_cfg_1_rd_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[1].rd_en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_1_rd_en_1_qs)
  );


  // F[prog_en_1]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_1_prog_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_1_prog_en_1_we & bank0_info2_regwen_1_qs),
    .wd     (bank0_info2_page_cfg_1_prog_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[1].prog_en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_1_prog_en_1_qs)
  );


  // F[erase_en_1]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_1_erase_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_1_erase_en_1_we & bank0_info2_regwen_1_qs),
    .wd     (bank0_info2_page_cfg_1_erase_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[1].erase_en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_1_erase_en_1_qs)
  );


  // F[scramble_en_1]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_1_scramble_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_1_scramble_en_1_we & bank0_info2_regwen_1_qs),
    .wd     (bank0_info2_page_cfg_1_scramble_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[1].scramble_en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_1_scramble_en_1_qs)
  );


  // F[ecc_en_1]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_1_ecc_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_1_ecc_en_1_we & bank0_info2_regwen_1_qs),
    .wd     (bank0_info2_page_cfg_1_ecc_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[1].ecc_en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_1_ecc_en_1_qs)
  );


  // F[he_en_1]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank0_info2_page_cfg_1_he_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank0_info2_page_cfg_1_he_en_1_we & bank0_info2_regwen_1_qs),
    .wd     (bank0_info2_page_cfg_1_he_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank0_info2_page_cfg[1].he_en.q ),

    // to register interface (read)
    .qs     (bank0_info2_page_cfg_1_he_en_1_qs)
  );




  // Subregister 0 of Multireg bank1_info0_regwen
  // R[bank1_info0_regwen_0]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank1_info0_regwen_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank1_info0_regwen_0_we),
    .wd     (bank1_info0_regwen_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank1_info0_regwen_0_qs)
  );

  // Subregister 1 of Multireg bank1_info0_regwen
  // R[bank1_info0_regwen_1]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank1_info0_regwen_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank1_info0_regwen_1_we),
    .wd     (bank1_info0_regwen_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank1_info0_regwen_1_qs)
  );

  // Subregister 2 of Multireg bank1_info0_regwen
  // R[bank1_info0_regwen_2]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank1_info0_regwen_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank1_info0_regwen_2_we),
    .wd     (bank1_info0_regwen_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank1_info0_regwen_2_qs)
  );

  // Subregister 3 of Multireg bank1_info0_regwen
  // R[bank1_info0_regwen_3]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank1_info0_regwen_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank1_info0_regwen_3_we),
    .wd     (bank1_info0_regwen_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank1_info0_regwen_3_qs)
  );

  // Subregister 4 of Multireg bank1_info0_regwen
  // R[bank1_info0_regwen_4]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank1_info0_regwen_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank1_info0_regwen_4_we),
    .wd     (bank1_info0_regwen_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank1_info0_regwen_4_qs)
  );

  // Subregister 5 of Multireg bank1_info0_regwen
  // R[bank1_info0_regwen_5]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank1_info0_regwen_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank1_info0_regwen_5_we),
    .wd     (bank1_info0_regwen_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank1_info0_regwen_5_qs)
  );

  // Subregister 6 of Multireg bank1_info0_regwen
  // R[bank1_info0_regwen_6]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank1_info0_regwen_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank1_info0_regwen_6_we),
    .wd     (bank1_info0_regwen_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank1_info0_regwen_6_qs)
  );

  // Subregister 7 of Multireg bank1_info0_regwen
  // R[bank1_info0_regwen_7]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank1_info0_regwen_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank1_info0_regwen_7_we),
    .wd     (bank1_info0_regwen_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank1_info0_regwen_7_qs)
  );

  // Subregister 8 of Multireg bank1_info0_regwen
  // R[bank1_info0_regwen_8]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank1_info0_regwen_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank1_info0_regwen_8_we),
    .wd     (bank1_info0_regwen_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank1_info0_regwen_8_qs)
  );

  // Subregister 9 of Multireg bank1_info0_regwen
  // R[bank1_info0_regwen_9]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank1_info0_regwen_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank1_info0_regwen_9_we),
    .wd     (bank1_info0_regwen_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank1_info0_regwen_9_qs)
  );



  // Subregister 0 of Multireg bank1_info0_page_cfg
  // R[bank1_info0_page_cfg_0]: V(False)

  // F[en_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_0_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_0_en_0_we & bank1_info0_regwen_0_qs),
    .wd     (bank1_info0_page_cfg_0_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[0].en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_0_en_0_qs)
  );


  // F[rd_en_0]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_0_rd_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_0_rd_en_0_we & bank1_info0_regwen_0_qs),
    .wd     (bank1_info0_page_cfg_0_rd_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[0].rd_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_0_rd_en_0_qs)
  );


  // F[prog_en_0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_0_prog_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_0_prog_en_0_we & bank1_info0_regwen_0_qs),
    .wd     (bank1_info0_page_cfg_0_prog_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[0].prog_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_0_prog_en_0_qs)
  );


  // F[erase_en_0]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_0_erase_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_0_erase_en_0_we & bank1_info0_regwen_0_qs),
    .wd     (bank1_info0_page_cfg_0_erase_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[0].erase_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_0_erase_en_0_qs)
  );


  // F[scramble_en_0]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_0_scramble_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_0_scramble_en_0_we & bank1_info0_regwen_0_qs),
    .wd     (bank1_info0_page_cfg_0_scramble_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[0].scramble_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_0_scramble_en_0_qs)
  );


  // F[ecc_en_0]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_0_ecc_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_0_ecc_en_0_we & bank1_info0_regwen_0_qs),
    .wd     (bank1_info0_page_cfg_0_ecc_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[0].ecc_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_0_ecc_en_0_qs)
  );


  // F[he_en_0]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_0_he_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_0_he_en_0_we & bank1_info0_regwen_0_qs),
    .wd     (bank1_info0_page_cfg_0_he_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[0].he_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_0_he_en_0_qs)
  );


  // Subregister 1 of Multireg bank1_info0_page_cfg
  // R[bank1_info0_page_cfg_1]: V(False)

  // F[en_1]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_1_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_1_en_1_we & bank1_info0_regwen_1_qs),
    .wd     (bank1_info0_page_cfg_1_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[1].en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_1_en_1_qs)
  );


  // F[rd_en_1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_1_rd_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_1_rd_en_1_we & bank1_info0_regwen_1_qs),
    .wd     (bank1_info0_page_cfg_1_rd_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[1].rd_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_1_rd_en_1_qs)
  );


  // F[prog_en_1]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_1_prog_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_1_prog_en_1_we & bank1_info0_regwen_1_qs),
    .wd     (bank1_info0_page_cfg_1_prog_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[1].prog_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_1_prog_en_1_qs)
  );


  // F[erase_en_1]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_1_erase_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_1_erase_en_1_we & bank1_info0_regwen_1_qs),
    .wd     (bank1_info0_page_cfg_1_erase_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[1].erase_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_1_erase_en_1_qs)
  );


  // F[scramble_en_1]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_1_scramble_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_1_scramble_en_1_we & bank1_info0_regwen_1_qs),
    .wd     (bank1_info0_page_cfg_1_scramble_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[1].scramble_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_1_scramble_en_1_qs)
  );


  // F[ecc_en_1]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_1_ecc_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_1_ecc_en_1_we & bank1_info0_regwen_1_qs),
    .wd     (bank1_info0_page_cfg_1_ecc_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[1].ecc_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_1_ecc_en_1_qs)
  );


  // F[he_en_1]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_1_he_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_1_he_en_1_we & bank1_info0_regwen_1_qs),
    .wd     (bank1_info0_page_cfg_1_he_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[1].he_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_1_he_en_1_qs)
  );


  // Subregister 2 of Multireg bank1_info0_page_cfg
  // R[bank1_info0_page_cfg_2]: V(False)

  // F[en_2]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_2_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_2_en_2_we & bank1_info0_regwen_2_qs),
    .wd     (bank1_info0_page_cfg_2_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[2].en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_2_en_2_qs)
  );


  // F[rd_en_2]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_2_rd_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_2_rd_en_2_we & bank1_info0_regwen_2_qs),
    .wd     (bank1_info0_page_cfg_2_rd_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[2].rd_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_2_rd_en_2_qs)
  );


  // F[prog_en_2]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_2_prog_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_2_prog_en_2_we & bank1_info0_regwen_2_qs),
    .wd     (bank1_info0_page_cfg_2_prog_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[2].prog_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_2_prog_en_2_qs)
  );


  // F[erase_en_2]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_2_erase_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_2_erase_en_2_we & bank1_info0_regwen_2_qs),
    .wd     (bank1_info0_page_cfg_2_erase_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[2].erase_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_2_erase_en_2_qs)
  );


  // F[scramble_en_2]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_2_scramble_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_2_scramble_en_2_we & bank1_info0_regwen_2_qs),
    .wd     (bank1_info0_page_cfg_2_scramble_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[2].scramble_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_2_scramble_en_2_qs)
  );


  // F[ecc_en_2]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_2_ecc_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_2_ecc_en_2_we & bank1_info0_regwen_2_qs),
    .wd     (bank1_info0_page_cfg_2_ecc_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[2].ecc_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_2_ecc_en_2_qs)
  );


  // F[he_en_2]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_2_he_en_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_2_he_en_2_we & bank1_info0_regwen_2_qs),
    .wd     (bank1_info0_page_cfg_2_he_en_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[2].he_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_2_he_en_2_qs)
  );


  // Subregister 3 of Multireg bank1_info0_page_cfg
  // R[bank1_info0_page_cfg_3]: V(False)

  // F[en_3]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_3_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_3_en_3_we & bank1_info0_regwen_3_qs),
    .wd     (bank1_info0_page_cfg_3_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[3].en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_3_en_3_qs)
  );


  // F[rd_en_3]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_3_rd_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_3_rd_en_3_we & bank1_info0_regwen_3_qs),
    .wd     (bank1_info0_page_cfg_3_rd_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[3].rd_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_3_rd_en_3_qs)
  );


  // F[prog_en_3]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_3_prog_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_3_prog_en_3_we & bank1_info0_regwen_3_qs),
    .wd     (bank1_info0_page_cfg_3_prog_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[3].prog_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_3_prog_en_3_qs)
  );


  // F[erase_en_3]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_3_erase_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_3_erase_en_3_we & bank1_info0_regwen_3_qs),
    .wd     (bank1_info0_page_cfg_3_erase_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[3].erase_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_3_erase_en_3_qs)
  );


  // F[scramble_en_3]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_3_scramble_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_3_scramble_en_3_we & bank1_info0_regwen_3_qs),
    .wd     (bank1_info0_page_cfg_3_scramble_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[3].scramble_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_3_scramble_en_3_qs)
  );


  // F[ecc_en_3]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_3_ecc_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_3_ecc_en_3_we & bank1_info0_regwen_3_qs),
    .wd     (bank1_info0_page_cfg_3_ecc_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[3].ecc_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_3_ecc_en_3_qs)
  );


  // F[he_en_3]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_3_he_en_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_3_he_en_3_we & bank1_info0_regwen_3_qs),
    .wd     (bank1_info0_page_cfg_3_he_en_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[3].he_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_3_he_en_3_qs)
  );


  // Subregister 4 of Multireg bank1_info0_page_cfg
  // R[bank1_info0_page_cfg_4]: V(False)

  // F[en_4]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_4_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_4_en_4_we & bank1_info0_regwen_4_qs),
    .wd     (bank1_info0_page_cfg_4_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[4].en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_4_en_4_qs)
  );


  // F[rd_en_4]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_4_rd_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_4_rd_en_4_we & bank1_info0_regwen_4_qs),
    .wd     (bank1_info0_page_cfg_4_rd_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[4].rd_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_4_rd_en_4_qs)
  );


  // F[prog_en_4]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_4_prog_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_4_prog_en_4_we & bank1_info0_regwen_4_qs),
    .wd     (bank1_info0_page_cfg_4_prog_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[4].prog_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_4_prog_en_4_qs)
  );


  // F[erase_en_4]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_4_erase_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_4_erase_en_4_we & bank1_info0_regwen_4_qs),
    .wd     (bank1_info0_page_cfg_4_erase_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[4].erase_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_4_erase_en_4_qs)
  );


  // F[scramble_en_4]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_4_scramble_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_4_scramble_en_4_we & bank1_info0_regwen_4_qs),
    .wd     (bank1_info0_page_cfg_4_scramble_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[4].scramble_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_4_scramble_en_4_qs)
  );


  // F[ecc_en_4]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_4_ecc_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_4_ecc_en_4_we & bank1_info0_regwen_4_qs),
    .wd     (bank1_info0_page_cfg_4_ecc_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[4].ecc_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_4_ecc_en_4_qs)
  );


  // F[he_en_4]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_4_he_en_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_4_he_en_4_we & bank1_info0_regwen_4_qs),
    .wd     (bank1_info0_page_cfg_4_he_en_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[4].he_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_4_he_en_4_qs)
  );


  // Subregister 5 of Multireg bank1_info0_page_cfg
  // R[bank1_info0_page_cfg_5]: V(False)

  // F[en_5]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_5_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_5_en_5_we & bank1_info0_regwen_5_qs),
    .wd     (bank1_info0_page_cfg_5_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[5].en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_5_en_5_qs)
  );


  // F[rd_en_5]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_5_rd_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_5_rd_en_5_we & bank1_info0_regwen_5_qs),
    .wd     (bank1_info0_page_cfg_5_rd_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[5].rd_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_5_rd_en_5_qs)
  );


  // F[prog_en_5]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_5_prog_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_5_prog_en_5_we & bank1_info0_regwen_5_qs),
    .wd     (bank1_info0_page_cfg_5_prog_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[5].prog_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_5_prog_en_5_qs)
  );


  // F[erase_en_5]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_5_erase_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_5_erase_en_5_we & bank1_info0_regwen_5_qs),
    .wd     (bank1_info0_page_cfg_5_erase_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[5].erase_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_5_erase_en_5_qs)
  );


  // F[scramble_en_5]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_5_scramble_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_5_scramble_en_5_we & bank1_info0_regwen_5_qs),
    .wd     (bank1_info0_page_cfg_5_scramble_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[5].scramble_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_5_scramble_en_5_qs)
  );


  // F[ecc_en_5]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_5_ecc_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_5_ecc_en_5_we & bank1_info0_regwen_5_qs),
    .wd     (bank1_info0_page_cfg_5_ecc_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[5].ecc_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_5_ecc_en_5_qs)
  );


  // F[he_en_5]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_5_he_en_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_5_he_en_5_we & bank1_info0_regwen_5_qs),
    .wd     (bank1_info0_page_cfg_5_he_en_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[5].he_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_5_he_en_5_qs)
  );


  // Subregister 6 of Multireg bank1_info0_page_cfg
  // R[bank1_info0_page_cfg_6]: V(False)

  // F[en_6]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_6_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_6_en_6_we & bank1_info0_regwen_6_qs),
    .wd     (bank1_info0_page_cfg_6_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[6].en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_6_en_6_qs)
  );


  // F[rd_en_6]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_6_rd_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_6_rd_en_6_we & bank1_info0_regwen_6_qs),
    .wd     (bank1_info0_page_cfg_6_rd_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[6].rd_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_6_rd_en_6_qs)
  );


  // F[prog_en_6]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_6_prog_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_6_prog_en_6_we & bank1_info0_regwen_6_qs),
    .wd     (bank1_info0_page_cfg_6_prog_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[6].prog_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_6_prog_en_6_qs)
  );


  // F[erase_en_6]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_6_erase_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_6_erase_en_6_we & bank1_info0_regwen_6_qs),
    .wd     (bank1_info0_page_cfg_6_erase_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[6].erase_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_6_erase_en_6_qs)
  );


  // F[scramble_en_6]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_6_scramble_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_6_scramble_en_6_we & bank1_info0_regwen_6_qs),
    .wd     (bank1_info0_page_cfg_6_scramble_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[6].scramble_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_6_scramble_en_6_qs)
  );


  // F[ecc_en_6]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_6_ecc_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_6_ecc_en_6_we & bank1_info0_regwen_6_qs),
    .wd     (bank1_info0_page_cfg_6_ecc_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[6].ecc_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_6_ecc_en_6_qs)
  );


  // F[he_en_6]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_6_he_en_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_6_he_en_6_we & bank1_info0_regwen_6_qs),
    .wd     (bank1_info0_page_cfg_6_he_en_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[6].he_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_6_he_en_6_qs)
  );


  // Subregister 7 of Multireg bank1_info0_page_cfg
  // R[bank1_info0_page_cfg_7]: V(False)

  // F[en_7]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_7_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_7_en_7_we & bank1_info0_regwen_7_qs),
    .wd     (bank1_info0_page_cfg_7_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[7].en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_7_en_7_qs)
  );


  // F[rd_en_7]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_7_rd_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_7_rd_en_7_we & bank1_info0_regwen_7_qs),
    .wd     (bank1_info0_page_cfg_7_rd_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[7].rd_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_7_rd_en_7_qs)
  );


  // F[prog_en_7]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_7_prog_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_7_prog_en_7_we & bank1_info0_regwen_7_qs),
    .wd     (bank1_info0_page_cfg_7_prog_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[7].prog_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_7_prog_en_7_qs)
  );


  // F[erase_en_7]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_7_erase_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_7_erase_en_7_we & bank1_info0_regwen_7_qs),
    .wd     (bank1_info0_page_cfg_7_erase_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[7].erase_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_7_erase_en_7_qs)
  );


  // F[scramble_en_7]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_7_scramble_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_7_scramble_en_7_we & bank1_info0_regwen_7_qs),
    .wd     (bank1_info0_page_cfg_7_scramble_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[7].scramble_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_7_scramble_en_7_qs)
  );


  // F[ecc_en_7]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_7_ecc_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_7_ecc_en_7_we & bank1_info0_regwen_7_qs),
    .wd     (bank1_info0_page_cfg_7_ecc_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[7].ecc_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_7_ecc_en_7_qs)
  );


  // F[he_en_7]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_7_he_en_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_7_he_en_7_we & bank1_info0_regwen_7_qs),
    .wd     (bank1_info0_page_cfg_7_he_en_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[7].he_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_7_he_en_7_qs)
  );


  // Subregister 8 of Multireg bank1_info0_page_cfg
  // R[bank1_info0_page_cfg_8]: V(False)

  // F[en_8]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_8_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_8_en_8_we & bank1_info0_regwen_8_qs),
    .wd     (bank1_info0_page_cfg_8_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[8].en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_8_en_8_qs)
  );


  // F[rd_en_8]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_8_rd_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_8_rd_en_8_we & bank1_info0_regwen_8_qs),
    .wd     (bank1_info0_page_cfg_8_rd_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[8].rd_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_8_rd_en_8_qs)
  );


  // F[prog_en_8]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_8_prog_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_8_prog_en_8_we & bank1_info0_regwen_8_qs),
    .wd     (bank1_info0_page_cfg_8_prog_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[8].prog_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_8_prog_en_8_qs)
  );


  // F[erase_en_8]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_8_erase_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_8_erase_en_8_we & bank1_info0_regwen_8_qs),
    .wd     (bank1_info0_page_cfg_8_erase_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[8].erase_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_8_erase_en_8_qs)
  );


  // F[scramble_en_8]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_8_scramble_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_8_scramble_en_8_we & bank1_info0_regwen_8_qs),
    .wd     (bank1_info0_page_cfg_8_scramble_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[8].scramble_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_8_scramble_en_8_qs)
  );


  // F[ecc_en_8]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_8_ecc_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_8_ecc_en_8_we & bank1_info0_regwen_8_qs),
    .wd     (bank1_info0_page_cfg_8_ecc_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[8].ecc_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_8_ecc_en_8_qs)
  );


  // F[he_en_8]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_8_he_en_8 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_8_he_en_8_we & bank1_info0_regwen_8_qs),
    .wd     (bank1_info0_page_cfg_8_he_en_8_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[8].he_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_8_he_en_8_qs)
  );


  // Subregister 9 of Multireg bank1_info0_page_cfg
  // R[bank1_info0_page_cfg_9]: V(False)

  // F[en_9]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_9_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_9_en_9_we & bank1_info0_regwen_9_qs),
    .wd     (bank1_info0_page_cfg_9_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[9].en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_9_en_9_qs)
  );


  // F[rd_en_9]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_9_rd_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_9_rd_en_9_we & bank1_info0_regwen_9_qs),
    .wd     (bank1_info0_page_cfg_9_rd_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[9].rd_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_9_rd_en_9_qs)
  );


  // F[prog_en_9]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_9_prog_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_9_prog_en_9_we & bank1_info0_regwen_9_qs),
    .wd     (bank1_info0_page_cfg_9_prog_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[9].prog_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_9_prog_en_9_qs)
  );


  // F[erase_en_9]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_9_erase_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_9_erase_en_9_we & bank1_info0_regwen_9_qs),
    .wd     (bank1_info0_page_cfg_9_erase_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[9].erase_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_9_erase_en_9_qs)
  );


  // F[scramble_en_9]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_9_scramble_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_9_scramble_en_9_we & bank1_info0_regwen_9_qs),
    .wd     (bank1_info0_page_cfg_9_scramble_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[9].scramble_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_9_scramble_en_9_qs)
  );


  // F[ecc_en_9]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_9_ecc_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_9_ecc_en_9_we & bank1_info0_regwen_9_qs),
    .wd     (bank1_info0_page_cfg_9_ecc_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[9].ecc_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_9_ecc_en_9_qs)
  );


  // F[he_en_9]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info0_page_cfg_9_he_en_9 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info0_page_cfg_9_he_en_9_we & bank1_info0_regwen_9_qs),
    .wd     (bank1_info0_page_cfg_9_he_en_9_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info0_page_cfg[9].he_en.q ),

    // to register interface (read)
    .qs     (bank1_info0_page_cfg_9_he_en_9_qs)
  );




  // Subregister 0 of Multireg bank1_info1_regwen
  // R[bank1_info1_regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank1_info1_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank1_info1_regwen_we),
    .wd     (bank1_info1_regwen_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank1_info1_regwen_qs)
  );



  // Subregister 0 of Multireg bank1_info1_page_cfg
  // R[bank1_info1_page_cfg]: V(False)

  // F[en_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info1_page_cfg_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info1_page_cfg_en_0_we & bank1_info1_regwen_qs),
    .wd     (bank1_info1_page_cfg_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info1_page_cfg[0].en.q ),

    // to register interface (read)
    .qs     (bank1_info1_page_cfg_en_0_qs)
  );


  // F[rd_en_0]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info1_page_cfg_rd_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info1_page_cfg_rd_en_0_we & bank1_info1_regwen_qs),
    .wd     (bank1_info1_page_cfg_rd_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info1_page_cfg[0].rd_en.q ),

    // to register interface (read)
    .qs     (bank1_info1_page_cfg_rd_en_0_qs)
  );


  // F[prog_en_0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info1_page_cfg_prog_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info1_page_cfg_prog_en_0_we & bank1_info1_regwen_qs),
    .wd     (bank1_info1_page_cfg_prog_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info1_page_cfg[0].prog_en.q ),

    // to register interface (read)
    .qs     (bank1_info1_page_cfg_prog_en_0_qs)
  );


  // F[erase_en_0]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info1_page_cfg_erase_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info1_page_cfg_erase_en_0_we & bank1_info1_regwen_qs),
    .wd     (bank1_info1_page_cfg_erase_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info1_page_cfg[0].erase_en.q ),

    // to register interface (read)
    .qs     (bank1_info1_page_cfg_erase_en_0_qs)
  );


  // F[scramble_en_0]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info1_page_cfg_scramble_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info1_page_cfg_scramble_en_0_we & bank1_info1_regwen_qs),
    .wd     (bank1_info1_page_cfg_scramble_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info1_page_cfg[0].scramble_en.q ),

    // to register interface (read)
    .qs     (bank1_info1_page_cfg_scramble_en_0_qs)
  );


  // F[ecc_en_0]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info1_page_cfg_ecc_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info1_page_cfg_ecc_en_0_we & bank1_info1_regwen_qs),
    .wd     (bank1_info1_page_cfg_ecc_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info1_page_cfg[0].ecc_en.q ),

    // to register interface (read)
    .qs     (bank1_info1_page_cfg_ecc_en_0_qs)
  );


  // F[he_en_0]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info1_page_cfg_he_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info1_page_cfg_he_en_0_we & bank1_info1_regwen_qs),
    .wd     (bank1_info1_page_cfg_he_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info1_page_cfg[0].he_en.q ),

    // to register interface (read)
    .qs     (bank1_info1_page_cfg_he_en_0_qs)
  );




  // Subregister 0 of Multireg bank1_info2_regwen
  // R[bank1_info2_regwen_0]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank1_info2_regwen_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank1_info2_regwen_0_we),
    .wd     (bank1_info2_regwen_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank1_info2_regwen_0_qs)
  );

  // Subregister 1 of Multireg bank1_info2_regwen
  // R[bank1_info2_regwen_1]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank1_info2_regwen_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank1_info2_regwen_1_we),
    .wd     (bank1_info2_regwen_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank1_info2_regwen_1_qs)
  );



  // Subregister 0 of Multireg bank1_info2_page_cfg
  // R[bank1_info2_page_cfg_0]: V(False)

  // F[en_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_0_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_0_en_0_we & bank1_info2_regwen_0_qs),
    .wd     (bank1_info2_page_cfg_0_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[0].en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_0_en_0_qs)
  );


  // F[rd_en_0]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_0_rd_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_0_rd_en_0_we & bank1_info2_regwen_0_qs),
    .wd     (bank1_info2_page_cfg_0_rd_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[0].rd_en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_0_rd_en_0_qs)
  );


  // F[prog_en_0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_0_prog_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_0_prog_en_0_we & bank1_info2_regwen_0_qs),
    .wd     (bank1_info2_page_cfg_0_prog_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[0].prog_en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_0_prog_en_0_qs)
  );


  // F[erase_en_0]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_0_erase_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_0_erase_en_0_we & bank1_info2_regwen_0_qs),
    .wd     (bank1_info2_page_cfg_0_erase_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[0].erase_en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_0_erase_en_0_qs)
  );


  // F[scramble_en_0]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_0_scramble_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_0_scramble_en_0_we & bank1_info2_regwen_0_qs),
    .wd     (bank1_info2_page_cfg_0_scramble_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[0].scramble_en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_0_scramble_en_0_qs)
  );


  // F[ecc_en_0]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_0_ecc_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_0_ecc_en_0_we & bank1_info2_regwen_0_qs),
    .wd     (bank1_info2_page_cfg_0_ecc_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[0].ecc_en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_0_ecc_en_0_qs)
  );


  // F[he_en_0]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_0_he_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_0_he_en_0_we & bank1_info2_regwen_0_qs),
    .wd     (bank1_info2_page_cfg_0_he_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[0].he_en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_0_he_en_0_qs)
  );


  // Subregister 1 of Multireg bank1_info2_page_cfg
  // R[bank1_info2_page_cfg_1]: V(False)

  // F[en_1]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_1_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_1_en_1_we & bank1_info2_regwen_1_qs),
    .wd     (bank1_info2_page_cfg_1_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[1].en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_1_en_1_qs)
  );


  // F[rd_en_1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_1_rd_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_1_rd_en_1_we & bank1_info2_regwen_1_qs),
    .wd     (bank1_info2_page_cfg_1_rd_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[1].rd_en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_1_rd_en_1_qs)
  );


  // F[prog_en_1]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_1_prog_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_1_prog_en_1_we & bank1_info2_regwen_1_qs),
    .wd     (bank1_info2_page_cfg_1_prog_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[1].prog_en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_1_prog_en_1_qs)
  );


  // F[erase_en_1]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_1_erase_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_1_erase_en_1_we & bank1_info2_regwen_1_qs),
    .wd     (bank1_info2_page_cfg_1_erase_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[1].erase_en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_1_erase_en_1_qs)
  );


  // F[scramble_en_1]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_1_scramble_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_1_scramble_en_1_we & bank1_info2_regwen_1_qs),
    .wd     (bank1_info2_page_cfg_1_scramble_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[1].scramble_en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_1_scramble_en_1_qs)
  );


  // F[ecc_en_1]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_1_ecc_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_1_ecc_en_1_we & bank1_info2_regwen_1_qs),
    .wd     (bank1_info2_page_cfg_1_ecc_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[1].ecc_en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_1_ecc_en_1_qs)
  );


  // F[he_en_1]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_bank1_info2_page_cfg_1_he_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (bank1_info2_page_cfg_1_he_en_1_we & bank1_info2_regwen_1_qs),
    .wd     (bank1_info2_page_cfg_1_he_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.bank1_info2_page_cfg[1].he_en.q ),

    // to register interface (read)
    .qs     (bank1_info2_page_cfg_1_he_en_1_qs)
  );



  // R[bank_cfg_regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_bank_cfg_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (bank_cfg_regwen_we),
    .wd     (bank_cfg_regwen_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (bank_cfg_regwen_qs)
  );



  // Subregister 0 of Multireg mp_bank_cfg
  // R[mp_bank_cfg]: V(False)

  // F[erase_en_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_bank_cfg_erase_en_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_bank_cfg_erase_en_0_we & bank_cfg_regwen_qs),
    .wd     (mp_bank_cfg_erase_en_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_bank_cfg[0].q ),

    // to register interface (read)
    .qs     (mp_bank_cfg_erase_en_0_qs)
  );


  // F[erase_en_1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_mp_bank_cfg_erase_en_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (mp_bank_cfg_erase_en_1_we & bank_cfg_regwen_qs),
    .wd     (mp_bank_cfg_erase_en_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.mp_bank_cfg[1].q ),

    // to register interface (read)
    .qs     (mp_bank_cfg_erase_en_1_qs)
  );



  // R[op_status]: V(False)

  //   F[done]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_op_status_done (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (op_status_done_we),
    .wd     (op_status_done_wd),

    // from internal hardware
    .de     (hw2reg.op_status.done.de),
    .d      (hw2reg.op_status.done.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (op_status_done_qs)
  );


  //   F[err]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_op_status_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (op_status_err_we),
    .wd     (op_status_err_wd),

    // from internal hardware
    .de     (hw2reg.op_status.err.de),
    .d      (hw2reg.op_status.err.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (op_status_err_qs)
  );


  // R[status]: V(False)

  //   F[rd_full]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_status_rd_full (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.status.rd_full.de),
    .d      (hw2reg.status.rd_full.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (status_rd_full_qs)
  );


  //   F[rd_empty]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h1)
  ) u_status_rd_empty (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.status.rd_empty.de),
    .d      (hw2reg.status.rd_empty.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (status_rd_empty_qs)
  );


  //   F[prog_full]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_status_prog_full (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.status.prog_full.de),
    .d      (hw2reg.status.prog_full.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (status_prog_full_qs)
  );


  //   F[prog_empty]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h1)
  ) u_status_prog_empty (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.status.prog_empty.de),
    .d      (hw2reg.status.prog_empty.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (status_prog_empty_qs)
  );


  //   F[init_wip]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_status_init_wip (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.status.init_wip.de),
    .d      (hw2reg.status.init_wip.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (status_init_wip_qs)
  );


  // R[err_code]: V(False)

  //   F[flash_err]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_err_code_flash_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (err_code_flash_err_we),
    .wd     (err_code_flash_err_wd),

    // from internal hardware
    .de     (hw2reg.err_code.flash_err.de),
    .d      (hw2reg.err_code.flash_err.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_flash_err_qs)
  );


  //   F[flash_alert]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_err_code_flash_alert (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (err_code_flash_alert_we),
    .wd     (err_code_flash_alert_wd),

    // from internal hardware
    .de     (hw2reg.err_code.flash_alert.de),
    .d      (hw2reg.err_code.flash_alert.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_flash_alert_qs)
  );


  //   F[mp_err]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_err_code_mp_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (err_code_mp_err_we),
    .wd     (err_code_mp_err_wd),

    // from internal hardware
    .de     (hw2reg.err_code.mp_err.de),
    .d      (hw2reg.err_code.mp_err.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_mp_err_qs)
  );


  //   F[ecc_single_err]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_err_code_ecc_single_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (err_code_ecc_single_err_we),
    .wd     (err_code_ecc_single_err_wd),

    // from internal hardware
    .de     (hw2reg.err_code.ecc_single_err.de),
    .d      (hw2reg.err_code.ecc_single_err.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_ecc_single_err_qs)
  );


  //   F[ecc_multi_err]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_err_code_ecc_multi_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (err_code_ecc_multi_err_we),
    .wd     (err_code_ecc_multi_err_wd),

    // from internal hardware
    .de     (hw2reg.err_code.ecc_multi_err.de),
    .d      (hw2reg.err_code.ecc_multi_err.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_ecc_multi_err_qs)
  );


  // R[err_addr]: V(False)

  prim_subreg #(
    .DW      (9),
    .SWACCESS("RO"),
    .RESVAL  (9'h0)
  ) u_err_addr (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.err_addr.de),
    .d      (hw2reg.err_addr.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_addr_qs)
  );



  // Subregister 0 of Multireg ecc_err_addr
  // R[ecc_err_addr_0]: V(False)

  prim_subreg #(
    .DW      (20),
    .SWACCESS("RO"),
    .RESVAL  (20'h0)
  ) u_ecc_err_addr_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ecc_err_addr[0].de),
    .d      (hw2reg.ecc_err_addr[0].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ecc_err_addr_0_qs)
  );

  // Subregister 1 of Multireg ecc_err_addr
  // R[ecc_err_addr_1]: V(False)

  prim_subreg #(
    .DW      (20),
    .SWACCESS("RO"),
    .RESVAL  (20'h0)
  ) u_ecc_err_addr_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.ecc_err_addr[1].de),
    .d      (hw2reg.ecc_err_addr[1].d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (ecc_err_addr_1_qs)
  );


  // R[phy_alert_cfg]: V(False)

  //   F[alert_ack]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_phy_alert_cfg_alert_ack (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (phy_alert_cfg_alert_ack_we),
    .wd     (phy_alert_cfg_alert_ack_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.phy_alert_cfg.alert_ack.q ),

    // to register interface (read)
    .qs     (phy_alert_cfg_alert_ack_qs)
  );


  //   F[alert_trig]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_phy_alert_cfg_alert_trig (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (phy_alert_cfg_alert_trig_we),
    .wd     (phy_alert_cfg_alert_trig_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.phy_alert_cfg.alert_trig.q ),

    // to register interface (read)
    .qs     (phy_alert_cfg_alert_trig_qs)
  );


  // R[phy_status]: V(False)

  //   F[init_wip]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_phy_status_init_wip (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.phy_status.init_wip.de),
    .d      (hw2reg.phy_status.init_wip.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (phy_status_init_wip_qs)
  );


  //   F[prog_normal_avail]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h1)
  ) u_phy_status_prog_normal_avail (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.phy_status.prog_normal_avail.de),
    .d      (hw2reg.phy_status.prog_normal_avail.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (phy_status_prog_normal_avail_qs)
  );


  //   F[prog_repair_avail]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h1)
  ) u_phy_status_prog_repair_avail (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.phy_status.prog_repair_avail.de),
    .d      (hw2reg.phy_status.prog_repair_avail.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (phy_status_prog_repair_avail_qs)
  );


  // R[scratch]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_scratch (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (scratch_we),
    .wd     (scratch_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.scratch.q ),

    // to register interface (read)
    .qs     (scratch_qs)
  );


  // R[fifo_lvl]: V(False)

  //   F[prog]: 4:0
  prim_subreg #(
    .DW      (5),
    .SWACCESS("RW"),
    .RESVAL  (5'hf)
  ) u_fifo_lvl_prog (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (fifo_lvl_prog_we),
    .wd     (fifo_lvl_prog_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.fifo_lvl.prog.q ),

    // to register interface (read)
    .qs     (fifo_lvl_prog_qs)
  );


  //   F[rd]: 12:8
  prim_subreg #(
    .DW      (5),
    .SWACCESS("RW"),
    .RESVAL  (5'hf)
  ) u_fifo_lvl_rd (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (fifo_lvl_rd_we),
    .wd     (fifo_lvl_rd_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.fifo_lvl.rd.q ),

    // to register interface (read)
    .qs     (fifo_lvl_rd_qs)
  );


  // R[fifo_rst]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_fifo_rst (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (fifo_rst_we),
    .wd     (fifo_rst_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.fifo_rst.q ),

    // to register interface (read)
    .qs     (fifo_rst_qs)
  );




  logic [90:0] addr_hit;
  always_comb begin
    addr_hit = '0;
    addr_hit[ 0] = (reg_addr == FLASH_CTRL_INTR_STATE_OFFSET);
    addr_hit[ 1] = (reg_addr == FLASH_CTRL_INTR_ENABLE_OFFSET);
    addr_hit[ 2] = (reg_addr == FLASH_CTRL_INTR_TEST_OFFSET);
    addr_hit[ 3] = (reg_addr == FLASH_CTRL_ALERT_TEST_OFFSET);
    addr_hit[ 4] = (reg_addr == FLASH_CTRL_CTRL_REGWEN_OFFSET);
    addr_hit[ 5] = (reg_addr == FLASH_CTRL_CONTROL_OFFSET);
    addr_hit[ 6] = (reg_addr == FLASH_CTRL_ADDR_OFFSET);
    addr_hit[ 7] = (reg_addr == FLASH_CTRL_PROG_TYPE_EN_OFFSET);
    addr_hit[ 8] = (reg_addr == FLASH_CTRL_ERASE_SUSPEND_OFFSET);
    addr_hit[ 9] = (reg_addr == FLASH_CTRL_REGION_CFG_REGWEN_0_OFFSET);
    addr_hit[10] = (reg_addr == FLASH_CTRL_REGION_CFG_REGWEN_1_OFFSET);
    addr_hit[11] = (reg_addr == FLASH_CTRL_REGION_CFG_REGWEN_2_OFFSET);
    addr_hit[12] = (reg_addr == FLASH_CTRL_REGION_CFG_REGWEN_3_OFFSET);
    addr_hit[13] = (reg_addr == FLASH_CTRL_REGION_CFG_REGWEN_4_OFFSET);
    addr_hit[14] = (reg_addr == FLASH_CTRL_REGION_CFG_REGWEN_5_OFFSET);
    addr_hit[15] = (reg_addr == FLASH_CTRL_REGION_CFG_REGWEN_6_OFFSET);
    addr_hit[16] = (reg_addr == FLASH_CTRL_REGION_CFG_REGWEN_7_OFFSET);
    addr_hit[17] = (reg_addr == FLASH_CTRL_MP_REGION_CFG_0_OFFSET);
    addr_hit[18] = (reg_addr == FLASH_CTRL_MP_REGION_CFG_1_OFFSET);
    addr_hit[19] = (reg_addr == FLASH_CTRL_MP_REGION_CFG_2_OFFSET);
    addr_hit[20] = (reg_addr == FLASH_CTRL_MP_REGION_CFG_3_OFFSET);
    addr_hit[21] = (reg_addr == FLASH_CTRL_MP_REGION_CFG_4_OFFSET);
    addr_hit[22] = (reg_addr == FLASH_CTRL_MP_REGION_CFG_5_OFFSET);
    addr_hit[23] = (reg_addr == FLASH_CTRL_MP_REGION_CFG_6_OFFSET);
    addr_hit[24] = (reg_addr == FLASH_CTRL_MP_REGION_CFG_7_OFFSET);
    addr_hit[25] = (reg_addr == FLASH_CTRL_DEFAULT_REGION_OFFSET);
    addr_hit[26] = (reg_addr == FLASH_CTRL_BANK0_INFO0_REGWEN_0_OFFSET);
    addr_hit[27] = (reg_addr == FLASH_CTRL_BANK0_INFO0_REGWEN_1_OFFSET);
    addr_hit[28] = (reg_addr == FLASH_CTRL_BANK0_INFO0_REGWEN_2_OFFSET);
    addr_hit[29] = (reg_addr == FLASH_CTRL_BANK0_INFO0_REGWEN_3_OFFSET);
    addr_hit[30] = (reg_addr == FLASH_CTRL_BANK0_INFO0_REGWEN_4_OFFSET);
    addr_hit[31] = (reg_addr == FLASH_CTRL_BANK0_INFO0_REGWEN_5_OFFSET);
    addr_hit[32] = (reg_addr == FLASH_CTRL_BANK0_INFO0_REGWEN_6_OFFSET);
    addr_hit[33] = (reg_addr == FLASH_CTRL_BANK0_INFO0_REGWEN_7_OFFSET);
    addr_hit[34] = (reg_addr == FLASH_CTRL_BANK0_INFO0_REGWEN_8_OFFSET);
    addr_hit[35] = (reg_addr == FLASH_CTRL_BANK0_INFO0_REGWEN_9_OFFSET);
    addr_hit[36] = (reg_addr == FLASH_CTRL_BANK0_INFO0_PAGE_CFG_0_OFFSET);
    addr_hit[37] = (reg_addr == FLASH_CTRL_BANK0_INFO0_PAGE_CFG_1_OFFSET);
    addr_hit[38] = (reg_addr == FLASH_CTRL_BANK0_INFO0_PAGE_CFG_2_OFFSET);
    addr_hit[39] = (reg_addr == FLASH_CTRL_BANK0_INFO0_PAGE_CFG_3_OFFSET);
    addr_hit[40] = (reg_addr == FLASH_CTRL_BANK0_INFO0_PAGE_CFG_4_OFFSET);
    addr_hit[41] = (reg_addr == FLASH_CTRL_BANK0_INFO0_PAGE_CFG_5_OFFSET);
    addr_hit[42] = (reg_addr == FLASH_CTRL_BANK0_INFO0_PAGE_CFG_6_OFFSET);
    addr_hit[43] = (reg_addr == FLASH_CTRL_BANK0_INFO0_PAGE_CFG_7_OFFSET);
    addr_hit[44] = (reg_addr == FLASH_CTRL_BANK0_INFO0_PAGE_CFG_8_OFFSET);
    addr_hit[45] = (reg_addr == FLASH_CTRL_BANK0_INFO0_PAGE_CFG_9_OFFSET);
    addr_hit[46] = (reg_addr == FLASH_CTRL_BANK0_INFO1_REGWEN_OFFSET);
    addr_hit[47] = (reg_addr == FLASH_CTRL_BANK0_INFO1_PAGE_CFG_OFFSET);
    addr_hit[48] = (reg_addr == FLASH_CTRL_BANK0_INFO2_REGWEN_0_OFFSET);
    addr_hit[49] = (reg_addr == FLASH_CTRL_BANK0_INFO2_REGWEN_1_OFFSET);
    addr_hit[50] = (reg_addr == FLASH_CTRL_BANK0_INFO2_PAGE_CFG_0_OFFSET);
    addr_hit[51] = (reg_addr == FLASH_CTRL_BANK0_INFO2_PAGE_CFG_1_OFFSET);
    addr_hit[52] = (reg_addr == FLASH_CTRL_BANK1_INFO0_REGWEN_0_OFFSET);
    addr_hit[53] = (reg_addr == FLASH_CTRL_BANK1_INFO0_REGWEN_1_OFFSET);
    addr_hit[54] = (reg_addr == FLASH_CTRL_BANK1_INFO0_REGWEN_2_OFFSET);
    addr_hit[55] = (reg_addr == FLASH_CTRL_BANK1_INFO0_REGWEN_3_OFFSET);
    addr_hit[56] = (reg_addr == FLASH_CTRL_BANK1_INFO0_REGWEN_4_OFFSET);
    addr_hit[57] = (reg_addr == FLASH_CTRL_BANK1_INFO0_REGWEN_5_OFFSET);
    addr_hit[58] = (reg_addr == FLASH_CTRL_BANK1_INFO0_REGWEN_6_OFFSET);
    addr_hit[59] = (reg_addr == FLASH_CTRL_BANK1_INFO0_REGWEN_7_OFFSET);
    addr_hit[60] = (reg_addr == FLASH_CTRL_BANK1_INFO0_REGWEN_8_OFFSET);
    addr_hit[61] = (reg_addr == FLASH_CTRL_BANK1_INFO0_REGWEN_9_OFFSET);
    addr_hit[62] = (reg_addr == FLASH_CTRL_BANK1_INFO0_PAGE_CFG_0_OFFSET);
    addr_hit[63] = (reg_addr == FLASH_CTRL_BANK1_INFO0_PAGE_CFG_1_OFFSET);
    addr_hit[64] = (reg_addr == FLASH_CTRL_BANK1_INFO0_PAGE_CFG_2_OFFSET);
    addr_hit[65] = (reg_addr == FLASH_CTRL_BANK1_INFO0_PAGE_CFG_3_OFFSET);
    addr_hit[66] = (reg_addr == FLASH_CTRL_BANK1_INFO0_PAGE_CFG_4_OFFSET);
    addr_hit[67] = (reg_addr == FLASH_CTRL_BANK1_INFO0_PAGE_CFG_5_OFFSET);
    addr_hit[68] = (reg_addr == FLASH_CTRL_BANK1_INFO0_PAGE_CFG_6_OFFSET);
    addr_hit[69] = (reg_addr == FLASH_CTRL_BANK1_INFO0_PAGE_CFG_7_OFFSET);
    addr_hit[70] = (reg_addr == FLASH_CTRL_BANK1_INFO0_PAGE_CFG_8_OFFSET);
    addr_hit[71] = (reg_addr == FLASH_CTRL_BANK1_INFO0_PAGE_CFG_9_OFFSET);
    addr_hit[72] = (reg_addr == FLASH_CTRL_BANK1_INFO1_REGWEN_OFFSET);
    addr_hit[73] = (reg_addr == FLASH_CTRL_BANK1_INFO1_PAGE_CFG_OFFSET);
    addr_hit[74] = (reg_addr == FLASH_CTRL_BANK1_INFO2_REGWEN_0_OFFSET);
    addr_hit[75] = (reg_addr == FLASH_CTRL_BANK1_INFO2_REGWEN_1_OFFSET);
    addr_hit[76] = (reg_addr == FLASH_CTRL_BANK1_INFO2_PAGE_CFG_0_OFFSET);
    addr_hit[77] = (reg_addr == FLASH_CTRL_BANK1_INFO2_PAGE_CFG_1_OFFSET);
    addr_hit[78] = (reg_addr == FLASH_CTRL_BANK_CFG_REGWEN_OFFSET);
    addr_hit[79] = (reg_addr == FLASH_CTRL_MP_BANK_CFG_OFFSET);
    addr_hit[80] = (reg_addr == FLASH_CTRL_OP_STATUS_OFFSET);
    addr_hit[81] = (reg_addr == FLASH_CTRL_STATUS_OFFSET);
    addr_hit[82] = (reg_addr == FLASH_CTRL_ERR_CODE_OFFSET);
    addr_hit[83] = (reg_addr == FLASH_CTRL_ERR_ADDR_OFFSET);
    addr_hit[84] = (reg_addr == FLASH_CTRL_ECC_ERR_ADDR_0_OFFSET);
    addr_hit[85] = (reg_addr == FLASH_CTRL_ECC_ERR_ADDR_1_OFFSET);
    addr_hit[86] = (reg_addr == FLASH_CTRL_PHY_ALERT_CFG_OFFSET);
    addr_hit[87] = (reg_addr == FLASH_CTRL_PHY_STATUS_OFFSET);
    addr_hit[88] = (reg_addr == FLASH_CTRL_SCRATCH_OFFSET);
    addr_hit[89] = (reg_addr == FLASH_CTRL_FIFO_LVL_OFFSET);
    addr_hit[90] = (reg_addr == FLASH_CTRL_FIFO_RST_OFFSET);
  end

  assign addrmiss = (reg_re || reg_we) ? ~|addr_hit : 1'b0 ;

  // Check sub-word write is permitted
  always_comb begin
    wr_err = 1'b0;
    if (addr_hit[ 0] && reg_we && (FLASH_CTRL_PERMIT[ 0] != (FLASH_CTRL_PERMIT[ 0] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 1] && reg_we && (FLASH_CTRL_PERMIT[ 1] != (FLASH_CTRL_PERMIT[ 1] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 2] && reg_we && (FLASH_CTRL_PERMIT[ 2] != (FLASH_CTRL_PERMIT[ 2] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 3] && reg_we && (FLASH_CTRL_PERMIT[ 3] != (FLASH_CTRL_PERMIT[ 3] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 4] && reg_we && (FLASH_CTRL_PERMIT[ 4] != (FLASH_CTRL_PERMIT[ 4] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 5] && reg_we && (FLASH_CTRL_PERMIT[ 5] != (FLASH_CTRL_PERMIT[ 5] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 6] && reg_we && (FLASH_CTRL_PERMIT[ 6] != (FLASH_CTRL_PERMIT[ 6] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 7] && reg_we && (FLASH_CTRL_PERMIT[ 7] != (FLASH_CTRL_PERMIT[ 7] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 8] && reg_we && (FLASH_CTRL_PERMIT[ 8] != (FLASH_CTRL_PERMIT[ 8] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 9] && reg_we && (FLASH_CTRL_PERMIT[ 9] != (FLASH_CTRL_PERMIT[ 9] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[10] && reg_we && (FLASH_CTRL_PERMIT[10] != (FLASH_CTRL_PERMIT[10] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[11] && reg_we && (FLASH_CTRL_PERMIT[11] != (FLASH_CTRL_PERMIT[11] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[12] && reg_we && (FLASH_CTRL_PERMIT[12] != (FLASH_CTRL_PERMIT[12] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[13] && reg_we && (FLASH_CTRL_PERMIT[13] != (FLASH_CTRL_PERMIT[13] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[14] && reg_we && (FLASH_CTRL_PERMIT[14] != (FLASH_CTRL_PERMIT[14] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[15] && reg_we && (FLASH_CTRL_PERMIT[15] != (FLASH_CTRL_PERMIT[15] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[16] && reg_we && (FLASH_CTRL_PERMIT[16] != (FLASH_CTRL_PERMIT[16] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[17] && reg_we && (FLASH_CTRL_PERMIT[17] != (FLASH_CTRL_PERMIT[17] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[18] && reg_we && (FLASH_CTRL_PERMIT[18] != (FLASH_CTRL_PERMIT[18] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[19] && reg_we && (FLASH_CTRL_PERMIT[19] != (FLASH_CTRL_PERMIT[19] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[20] && reg_we && (FLASH_CTRL_PERMIT[20] != (FLASH_CTRL_PERMIT[20] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[21] && reg_we && (FLASH_CTRL_PERMIT[21] != (FLASH_CTRL_PERMIT[21] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[22] && reg_we && (FLASH_CTRL_PERMIT[22] != (FLASH_CTRL_PERMIT[22] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[23] && reg_we && (FLASH_CTRL_PERMIT[23] != (FLASH_CTRL_PERMIT[23] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[24] && reg_we && (FLASH_CTRL_PERMIT[24] != (FLASH_CTRL_PERMIT[24] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[25] && reg_we && (FLASH_CTRL_PERMIT[25] != (FLASH_CTRL_PERMIT[25] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[26] && reg_we && (FLASH_CTRL_PERMIT[26] != (FLASH_CTRL_PERMIT[26] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[27] && reg_we && (FLASH_CTRL_PERMIT[27] != (FLASH_CTRL_PERMIT[27] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[28] && reg_we && (FLASH_CTRL_PERMIT[28] != (FLASH_CTRL_PERMIT[28] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[29] && reg_we && (FLASH_CTRL_PERMIT[29] != (FLASH_CTRL_PERMIT[29] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[30] && reg_we && (FLASH_CTRL_PERMIT[30] != (FLASH_CTRL_PERMIT[30] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[31] && reg_we && (FLASH_CTRL_PERMIT[31] != (FLASH_CTRL_PERMIT[31] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[32] && reg_we && (FLASH_CTRL_PERMIT[32] != (FLASH_CTRL_PERMIT[32] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[33] && reg_we && (FLASH_CTRL_PERMIT[33] != (FLASH_CTRL_PERMIT[33] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[34] && reg_we && (FLASH_CTRL_PERMIT[34] != (FLASH_CTRL_PERMIT[34] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[35] && reg_we && (FLASH_CTRL_PERMIT[35] != (FLASH_CTRL_PERMIT[35] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[36] && reg_we && (FLASH_CTRL_PERMIT[36] != (FLASH_CTRL_PERMIT[36] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[37] && reg_we && (FLASH_CTRL_PERMIT[37] != (FLASH_CTRL_PERMIT[37] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[38] && reg_we && (FLASH_CTRL_PERMIT[38] != (FLASH_CTRL_PERMIT[38] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[39] && reg_we && (FLASH_CTRL_PERMIT[39] != (FLASH_CTRL_PERMIT[39] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[40] && reg_we && (FLASH_CTRL_PERMIT[40] != (FLASH_CTRL_PERMIT[40] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[41] && reg_we && (FLASH_CTRL_PERMIT[41] != (FLASH_CTRL_PERMIT[41] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[42] && reg_we && (FLASH_CTRL_PERMIT[42] != (FLASH_CTRL_PERMIT[42] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[43] && reg_we && (FLASH_CTRL_PERMIT[43] != (FLASH_CTRL_PERMIT[43] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[44] && reg_we && (FLASH_CTRL_PERMIT[44] != (FLASH_CTRL_PERMIT[44] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[45] && reg_we && (FLASH_CTRL_PERMIT[45] != (FLASH_CTRL_PERMIT[45] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[46] && reg_we && (FLASH_CTRL_PERMIT[46] != (FLASH_CTRL_PERMIT[46] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[47] && reg_we && (FLASH_CTRL_PERMIT[47] != (FLASH_CTRL_PERMIT[47] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[48] && reg_we && (FLASH_CTRL_PERMIT[48] != (FLASH_CTRL_PERMIT[48] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[49] && reg_we && (FLASH_CTRL_PERMIT[49] != (FLASH_CTRL_PERMIT[49] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[50] && reg_we && (FLASH_CTRL_PERMIT[50] != (FLASH_CTRL_PERMIT[50] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[51] && reg_we && (FLASH_CTRL_PERMIT[51] != (FLASH_CTRL_PERMIT[51] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[52] && reg_we && (FLASH_CTRL_PERMIT[52] != (FLASH_CTRL_PERMIT[52] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[53] && reg_we && (FLASH_CTRL_PERMIT[53] != (FLASH_CTRL_PERMIT[53] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[54] && reg_we && (FLASH_CTRL_PERMIT[54] != (FLASH_CTRL_PERMIT[54] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[55] && reg_we && (FLASH_CTRL_PERMIT[55] != (FLASH_CTRL_PERMIT[55] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[56] && reg_we && (FLASH_CTRL_PERMIT[56] != (FLASH_CTRL_PERMIT[56] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[57] && reg_we && (FLASH_CTRL_PERMIT[57] != (FLASH_CTRL_PERMIT[57] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[58] && reg_we && (FLASH_CTRL_PERMIT[58] != (FLASH_CTRL_PERMIT[58] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[59] && reg_we && (FLASH_CTRL_PERMIT[59] != (FLASH_CTRL_PERMIT[59] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[60] && reg_we && (FLASH_CTRL_PERMIT[60] != (FLASH_CTRL_PERMIT[60] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[61] && reg_we && (FLASH_CTRL_PERMIT[61] != (FLASH_CTRL_PERMIT[61] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[62] && reg_we && (FLASH_CTRL_PERMIT[62] != (FLASH_CTRL_PERMIT[62] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[63] && reg_we && (FLASH_CTRL_PERMIT[63] != (FLASH_CTRL_PERMIT[63] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[64] && reg_we && (FLASH_CTRL_PERMIT[64] != (FLASH_CTRL_PERMIT[64] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[65] && reg_we && (FLASH_CTRL_PERMIT[65] != (FLASH_CTRL_PERMIT[65] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[66] && reg_we && (FLASH_CTRL_PERMIT[66] != (FLASH_CTRL_PERMIT[66] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[67] && reg_we && (FLASH_CTRL_PERMIT[67] != (FLASH_CTRL_PERMIT[67] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[68] && reg_we && (FLASH_CTRL_PERMIT[68] != (FLASH_CTRL_PERMIT[68] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[69] && reg_we && (FLASH_CTRL_PERMIT[69] != (FLASH_CTRL_PERMIT[69] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[70] && reg_we && (FLASH_CTRL_PERMIT[70] != (FLASH_CTRL_PERMIT[70] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[71] && reg_we && (FLASH_CTRL_PERMIT[71] != (FLASH_CTRL_PERMIT[71] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[72] && reg_we && (FLASH_CTRL_PERMIT[72] != (FLASH_CTRL_PERMIT[72] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[73] && reg_we && (FLASH_CTRL_PERMIT[73] != (FLASH_CTRL_PERMIT[73] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[74] && reg_we && (FLASH_CTRL_PERMIT[74] != (FLASH_CTRL_PERMIT[74] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[75] && reg_we && (FLASH_CTRL_PERMIT[75] != (FLASH_CTRL_PERMIT[75] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[76] && reg_we && (FLASH_CTRL_PERMIT[76] != (FLASH_CTRL_PERMIT[76] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[77] && reg_we && (FLASH_CTRL_PERMIT[77] != (FLASH_CTRL_PERMIT[77] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[78] && reg_we && (FLASH_CTRL_PERMIT[78] != (FLASH_CTRL_PERMIT[78] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[79] && reg_we && (FLASH_CTRL_PERMIT[79] != (FLASH_CTRL_PERMIT[79] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[80] && reg_we && (FLASH_CTRL_PERMIT[80] != (FLASH_CTRL_PERMIT[80] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[81] && reg_we && (FLASH_CTRL_PERMIT[81] != (FLASH_CTRL_PERMIT[81] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[82] && reg_we && (FLASH_CTRL_PERMIT[82] != (FLASH_CTRL_PERMIT[82] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[83] && reg_we && (FLASH_CTRL_PERMIT[83] != (FLASH_CTRL_PERMIT[83] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[84] && reg_we && (FLASH_CTRL_PERMIT[84] != (FLASH_CTRL_PERMIT[84] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[85] && reg_we && (FLASH_CTRL_PERMIT[85] != (FLASH_CTRL_PERMIT[85] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[86] && reg_we && (FLASH_CTRL_PERMIT[86] != (FLASH_CTRL_PERMIT[86] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[87] && reg_we && (FLASH_CTRL_PERMIT[87] != (FLASH_CTRL_PERMIT[87] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[88] && reg_we && (FLASH_CTRL_PERMIT[88] != (FLASH_CTRL_PERMIT[88] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[89] && reg_we && (FLASH_CTRL_PERMIT[89] != (FLASH_CTRL_PERMIT[89] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[90] && reg_we && (FLASH_CTRL_PERMIT[90] != (FLASH_CTRL_PERMIT[90] & reg_be))) wr_err = 1'b1 ;
  end

  assign intr_state_prog_empty_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_prog_empty_wd = reg_wdata[0];

  assign intr_state_prog_lvl_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_prog_lvl_wd = reg_wdata[1];

  assign intr_state_rd_full_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_rd_full_wd = reg_wdata[2];

  assign intr_state_rd_lvl_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_rd_lvl_wd = reg_wdata[3];

  assign intr_state_op_done_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_op_done_wd = reg_wdata[4];

  assign intr_enable_prog_empty_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_prog_empty_wd = reg_wdata[0];

  assign intr_enable_prog_lvl_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_prog_lvl_wd = reg_wdata[1];

  assign intr_enable_rd_full_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_rd_full_wd = reg_wdata[2];

  assign intr_enable_rd_lvl_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_rd_lvl_wd = reg_wdata[3];

  assign intr_enable_op_done_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_op_done_wd = reg_wdata[4];

  assign intr_test_prog_empty_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_prog_empty_wd = reg_wdata[0];

  assign intr_test_prog_lvl_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_prog_lvl_wd = reg_wdata[1];

  assign intr_test_rd_full_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_rd_full_wd = reg_wdata[2];

  assign intr_test_rd_lvl_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_rd_lvl_wd = reg_wdata[3];

  assign intr_test_op_done_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_op_done_wd = reg_wdata[4];

  assign alert_test_recov_err_we = addr_hit[3] & reg_we & !reg_error;
  assign alert_test_recov_err_wd = reg_wdata[0];

  assign alert_test_recov_mp_err_we = addr_hit[3] & reg_we & !reg_error;
  assign alert_test_recov_mp_err_wd = reg_wdata[1];

  assign alert_test_recov_ecc_err_we = addr_hit[3] & reg_we & !reg_error;
  assign alert_test_recov_ecc_err_wd = reg_wdata[2];

  assign ctrl_regwen_re = addr_hit[4] & reg_re & !reg_error;

  assign control_start_we = addr_hit[5] & reg_we & !reg_error;
  assign control_start_wd = reg_wdata[0];

  assign control_op_we = addr_hit[5] & reg_we & !reg_error;
  assign control_op_wd = reg_wdata[5:4];

  assign control_prog_sel_we = addr_hit[5] & reg_we & !reg_error;
  assign control_prog_sel_wd = reg_wdata[6];

  assign control_erase_sel_we = addr_hit[5] & reg_we & !reg_error;
  assign control_erase_sel_wd = reg_wdata[7];

  assign control_partition_sel_we = addr_hit[5] & reg_we & !reg_error;
  assign control_partition_sel_wd = reg_wdata[8];

  assign control_info_sel_we = addr_hit[5] & reg_we & !reg_error;
  assign control_info_sel_wd = reg_wdata[10:9];

  assign control_num_we = addr_hit[5] & reg_we & !reg_error;
  assign control_num_wd = reg_wdata[27:16];

  assign addr_we = addr_hit[6] & reg_we & !reg_error;
  assign addr_wd = reg_wdata[31:0];

  assign prog_type_en_normal_we = addr_hit[7] & reg_we & !reg_error;
  assign prog_type_en_normal_wd = reg_wdata[0];

  assign prog_type_en_repair_we = addr_hit[7] & reg_we & !reg_error;
  assign prog_type_en_repair_wd = reg_wdata[1];

  assign erase_suspend_we = addr_hit[8] & reg_we & !reg_error;
  assign erase_suspend_wd = reg_wdata[0];

  assign region_cfg_regwen_0_we = addr_hit[9] & reg_we & !reg_error;
  assign region_cfg_regwen_0_wd = reg_wdata[0];

  assign region_cfg_regwen_1_we = addr_hit[10] & reg_we & !reg_error;
  assign region_cfg_regwen_1_wd = reg_wdata[0];

  assign region_cfg_regwen_2_we = addr_hit[11] & reg_we & !reg_error;
  assign region_cfg_regwen_2_wd = reg_wdata[0];

  assign region_cfg_regwen_3_we = addr_hit[12] & reg_we & !reg_error;
  assign region_cfg_regwen_3_wd = reg_wdata[0];

  assign region_cfg_regwen_4_we = addr_hit[13] & reg_we & !reg_error;
  assign region_cfg_regwen_4_wd = reg_wdata[0];

  assign region_cfg_regwen_5_we = addr_hit[14] & reg_we & !reg_error;
  assign region_cfg_regwen_5_wd = reg_wdata[0];

  assign region_cfg_regwen_6_we = addr_hit[15] & reg_we & !reg_error;
  assign region_cfg_regwen_6_wd = reg_wdata[0];

  assign region_cfg_regwen_7_we = addr_hit[16] & reg_we & !reg_error;
  assign region_cfg_regwen_7_wd = reg_wdata[0];

  assign mp_region_cfg_0_en_0_we = addr_hit[17] & reg_we & !reg_error;
  assign mp_region_cfg_0_en_0_wd = reg_wdata[0];

  assign mp_region_cfg_0_rd_en_0_we = addr_hit[17] & reg_we & !reg_error;
  assign mp_region_cfg_0_rd_en_0_wd = reg_wdata[1];

  assign mp_region_cfg_0_prog_en_0_we = addr_hit[17] & reg_we & !reg_error;
  assign mp_region_cfg_0_prog_en_0_wd = reg_wdata[2];

  assign mp_region_cfg_0_erase_en_0_we = addr_hit[17] & reg_we & !reg_error;
  assign mp_region_cfg_0_erase_en_0_wd = reg_wdata[3];

  assign mp_region_cfg_0_scramble_en_0_we = addr_hit[17] & reg_we & !reg_error;
  assign mp_region_cfg_0_scramble_en_0_wd = reg_wdata[4];

  assign mp_region_cfg_0_ecc_en_0_we = addr_hit[17] & reg_we & !reg_error;
  assign mp_region_cfg_0_ecc_en_0_wd = reg_wdata[5];

  assign mp_region_cfg_0_he_en_0_we = addr_hit[17] & reg_we & !reg_error;
  assign mp_region_cfg_0_he_en_0_wd = reg_wdata[6];

  assign mp_region_cfg_0_base_0_we = addr_hit[17] & reg_we & !reg_error;
  assign mp_region_cfg_0_base_0_wd = reg_wdata[16:8];

  assign mp_region_cfg_0_size_0_we = addr_hit[17] & reg_we & !reg_error;
  assign mp_region_cfg_0_size_0_wd = reg_wdata[26:17];

  assign mp_region_cfg_1_en_1_we = addr_hit[18] & reg_we & !reg_error;
  assign mp_region_cfg_1_en_1_wd = reg_wdata[0];

  assign mp_region_cfg_1_rd_en_1_we = addr_hit[18] & reg_we & !reg_error;
  assign mp_region_cfg_1_rd_en_1_wd = reg_wdata[1];

  assign mp_region_cfg_1_prog_en_1_we = addr_hit[18] & reg_we & !reg_error;
  assign mp_region_cfg_1_prog_en_1_wd = reg_wdata[2];

  assign mp_region_cfg_1_erase_en_1_we = addr_hit[18] & reg_we & !reg_error;
  assign mp_region_cfg_1_erase_en_1_wd = reg_wdata[3];

  assign mp_region_cfg_1_scramble_en_1_we = addr_hit[18] & reg_we & !reg_error;
  assign mp_region_cfg_1_scramble_en_1_wd = reg_wdata[4];

  assign mp_region_cfg_1_ecc_en_1_we = addr_hit[18] & reg_we & !reg_error;
  assign mp_region_cfg_1_ecc_en_1_wd = reg_wdata[5];

  assign mp_region_cfg_1_he_en_1_we = addr_hit[18] & reg_we & !reg_error;
  assign mp_region_cfg_1_he_en_1_wd = reg_wdata[6];

  assign mp_region_cfg_1_base_1_we = addr_hit[18] & reg_we & !reg_error;
  assign mp_region_cfg_1_base_1_wd = reg_wdata[16:8];

  assign mp_region_cfg_1_size_1_we = addr_hit[18] & reg_we & !reg_error;
  assign mp_region_cfg_1_size_1_wd = reg_wdata[26:17];

  assign mp_region_cfg_2_en_2_we = addr_hit[19] & reg_we & !reg_error;
  assign mp_region_cfg_2_en_2_wd = reg_wdata[0];

  assign mp_region_cfg_2_rd_en_2_we = addr_hit[19] & reg_we & !reg_error;
  assign mp_region_cfg_2_rd_en_2_wd = reg_wdata[1];

  assign mp_region_cfg_2_prog_en_2_we = addr_hit[19] & reg_we & !reg_error;
  assign mp_region_cfg_2_prog_en_2_wd = reg_wdata[2];

  assign mp_region_cfg_2_erase_en_2_we = addr_hit[19] & reg_we & !reg_error;
  assign mp_region_cfg_2_erase_en_2_wd = reg_wdata[3];

  assign mp_region_cfg_2_scramble_en_2_we = addr_hit[19] & reg_we & !reg_error;
  assign mp_region_cfg_2_scramble_en_2_wd = reg_wdata[4];

  assign mp_region_cfg_2_ecc_en_2_we = addr_hit[19] & reg_we & !reg_error;
  assign mp_region_cfg_2_ecc_en_2_wd = reg_wdata[5];

  assign mp_region_cfg_2_he_en_2_we = addr_hit[19] & reg_we & !reg_error;
  assign mp_region_cfg_2_he_en_2_wd = reg_wdata[6];

  assign mp_region_cfg_2_base_2_we = addr_hit[19] & reg_we & !reg_error;
  assign mp_region_cfg_2_base_2_wd = reg_wdata[16:8];

  assign mp_region_cfg_2_size_2_we = addr_hit[19] & reg_we & !reg_error;
  assign mp_region_cfg_2_size_2_wd = reg_wdata[26:17];

  assign mp_region_cfg_3_en_3_we = addr_hit[20] & reg_we & !reg_error;
  assign mp_region_cfg_3_en_3_wd = reg_wdata[0];

  assign mp_region_cfg_3_rd_en_3_we = addr_hit[20] & reg_we & !reg_error;
  assign mp_region_cfg_3_rd_en_3_wd = reg_wdata[1];

  assign mp_region_cfg_3_prog_en_3_we = addr_hit[20] & reg_we & !reg_error;
  assign mp_region_cfg_3_prog_en_3_wd = reg_wdata[2];

  assign mp_region_cfg_3_erase_en_3_we = addr_hit[20] & reg_we & !reg_error;
  assign mp_region_cfg_3_erase_en_3_wd = reg_wdata[3];

  assign mp_region_cfg_3_scramble_en_3_we = addr_hit[20] & reg_we & !reg_error;
  assign mp_region_cfg_3_scramble_en_3_wd = reg_wdata[4];

  assign mp_region_cfg_3_ecc_en_3_we = addr_hit[20] & reg_we & !reg_error;
  assign mp_region_cfg_3_ecc_en_3_wd = reg_wdata[5];

  assign mp_region_cfg_3_he_en_3_we = addr_hit[20] & reg_we & !reg_error;
  assign mp_region_cfg_3_he_en_3_wd = reg_wdata[6];

  assign mp_region_cfg_3_base_3_we = addr_hit[20] & reg_we & !reg_error;
  assign mp_region_cfg_3_base_3_wd = reg_wdata[16:8];

  assign mp_region_cfg_3_size_3_we = addr_hit[20] & reg_we & !reg_error;
  assign mp_region_cfg_3_size_3_wd = reg_wdata[26:17];

  assign mp_region_cfg_4_en_4_we = addr_hit[21] & reg_we & !reg_error;
  assign mp_region_cfg_4_en_4_wd = reg_wdata[0];

  assign mp_region_cfg_4_rd_en_4_we = addr_hit[21] & reg_we & !reg_error;
  assign mp_region_cfg_4_rd_en_4_wd = reg_wdata[1];

  assign mp_region_cfg_4_prog_en_4_we = addr_hit[21] & reg_we & !reg_error;
  assign mp_region_cfg_4_prog_en_4_wd = reg_wdata[2];

  assign mp_region_cfg_4_erase_en_4_we = addr_hit[21] & reg_we & !reg_error;
  assign mp_region_cfg_4_erase_en_4_wd = reg_wdata[3];

  assign mp_region_cfg_4_scramble_en_4_we = addr_hit[21] & reg_we & !reg_error;
  assign mp_region_cfg_4_scramble_en_4_wd = reg_wdata[4];

  assign mp_region_cfg_4_ecc_en_4_we = addr_hit[21] & reg_we & !reg_error;
  assign mp_region_cfg_4_ecc_en_4_wd = reg_wdata[5];

  assign mp_region_cfg_4_he_en_4_we = addr_hit[21] & reg_we & !reg_error;
  assign mp_region_cfg_4_he_en_4_wd = reg_wdata[6];

  assign mp_region_cfg_4_base_4_we = addr_hit[21] & reg_we & !reg_error;
  assign mp_region_cfg_4_base_4_wd = reg_wdata[16:8];

  assign mp_region_cfg_4_size_4_we = addr_hit[21] & reg_we & !reg_error;
  assign mp_region_cfg_4_size_4_wd = reg_wdata[26:17];

  assign mp_region_cfg_5_en_5_we = addr_hit[22] & reg_we & !reg_error;
  assign mp_region_cfg_5_en_5_wd = reg_wdata[0];

  assign mp_region_cfg_5_rd_en_5_we = addr_hit[22] & reg_we & !reg_error;
  assign mp_region_cfg_5_rd_en_5_wd = reg_wdata[1];

  assign mp_region_cfg_5_prog_en_5_we = addr_hit[22] & reg_we & !reg_error;
  assign mp_region_cfg_5_prog_en_5_wd = reg_wdata[2];

  assign mp_region_cfg_5_erase_en_5_we = addr_hit[22] & reg_we & !reg_error;
  assign mp_region_cfg_5_erase_en_5_wd = reg_wdata[3];

  assign mp_region_cfg_5_scramble_en_5_we = addr_hit[22] & reg_we & !reg_error;
  assign mp_region_cfg_5_scramble_en_5_wd = reg_wdata[4];

  assign mp_region_cfg_5_ecc_en_5_we = addr_hit[22] & reg_we & !reg_error;
  assign mp_region_cfg_5_ecc_en_5_wd = reg_wdata[5];

  assign mp_region_cfg_5_he_en_5_we = addr_hit[22] & reg_we & !reg_error;
  assign mp_region_cfg_5_he_en_5_wd = reg_wdata[6];

  assign mp_region_cfg_5_base_5_we = addr_hit[22] & reg_we & !reg_error;
  assign mp_region_cfg_5_base_5_wd = reg_wdata[16:8];

  assign mp_region_cfg_5_size_5_we = addr_hit[22] & reg_we & !reg_error;
  assign mp_region_cfg_5_size_5_wd = reg_wdata[26:17];

  assign mp_region_cfg_6_en_6_we = addr_hit[23] & reg_we & !reg_error;
  assign mp_region_cfg_6_en_6_wd = reg_wdata[0];

  assign mp_region_cfg_6_rd_en_6_we = addr_hit[23] & reg_we & !reg_error;
  assign mp_region_cfg_6_rd_en_6_wd = reg_wdata[1];

  assign mp_region_cfg_6_prog_en_6_we = addr_hit[23] & reg_we & !reg_error;
  assign mp_region_cfg_6_prog_en_6_wd = reg_wdata[2];

  assign mp_region_cfg_6_erase_en_6_we = addr_hit[23] & reg_we & !reg_error;
  assign mp_region_cfg_6_erase_en_6_wd = reg_wdata[3];

  assign mp_region_cfg_6_scramble_en_6_we = addr_hit[23] & reg_we & !reg_error;
  assign mp_region_cfg_6_scramble_en_6_wd = reg_wdata[4];

  assign mp_region_cfg_6_ecc_en_6_we = addr_hit[23] & reg_we & !reg_error;
  assign mp_region_cfg_6_ecc_en_6_wd = reg_wdata[5];

  assign mp_region_cfg_6_he_en_6_we = addr_hit[23] & reg_we & !reg_error;
  assign mp_region_cfg_6_he_en_6_wd = reg_wdata[6];

  assign mp_region_cfg_6_base_6_we = addr_hit[23] & reg_we & !reg_error;
  assign mp_region_cfg_6_base_6_wd = reg_wdata[16:8];

  assign mp_region_cfg_6_size_6_we = addr_hit[23] & reg_we & !reg_error;
  assign mp_region_cfg_6_size_6_wd = reg_wdata[26:17];

  assign mp_region_cfg_7_en_7_we = addr_hit[24] & reg_we & !reg_error;
  assign mp_region_cfg_7_en_7_wd = reg_wdata[0];

  assign mp_region_cfg_7_rd_en_7_we = addr_hit[24] & reg_we & !reg_error;
  assign mp_region_cfg_7_rd_en_7_wd = reg_wdata[1];

  assign mp_region_cfg_7_prog_en_7_we = addr_hit[24] & reg_we & !reg_error;
  assign mp_region_cfg_7_prog_en_7_wd = reg_wdata[2];

  assign mp_region_cfg_7_erase_en_7_we = addr_hit[24] & reg_we & !reg_error;
  assign mp_region_cfg_7_erase_en_7_wd = reg_wdata[3];

  assign mp_region_cfg_7_scramble_en_7_we = addr_hit[24] & reg_we & !reg_error;
  assign mp_region_cfg_7_scramble_en_7_wd = reg_wdata[4];

  assign mp_region_cfg_7_ecc_en_7_we = addr_hit[24] & reg_we & !reg_error;
  assign mp_region_cfg_7_ecc_en_7_wd = reg_wdata[5];

  assign mp_region_cfg_7_he_en_7_we = addr_hit[24] & reg_we & !reg_error;
  assign mp_region_cfg_7_he_en_7_wd = reg_wdata[6];

  assign mp_region_cfg_7_base_7_we = addr_hit[24] & reg_we & !reg_error;
  assign mp_region_cfg_7_base_7_wd = reg_wdata[16:8];

  assign mp_region_cfg_7_size_7_we = addr_hit[24] & reg_we & !reg_error;
  assign mp_region_cfg_7_size_7_wd = reg_wdata[26:17];

  assign default_region_rd_en_we = addr_hit[25] & reg_we & !reg_error;
  assign default_region_rd_en_wd = reg_wdata[0];

  assign default_region_prog_en_we = addr_hit[25] & reg_we & !reg_error;
  assign default_region_prog_en_wd = reg_wdata[1];

  assign default_region_erase_en_we = addr_hit[25] & reg_we & !reg_error;
  assign default_region_erase_en_wd = reg_wdata[2];

  assign default_region_scramble_en_we = addr_hit[25] & reg_we & !reg_error;
  assign default_region_scramble_en_wd = reg_wdata[3];

  assign default_region_ecc_en_we = addr_hit[25] & reg_we & !reg_error;
  assign default_region_ecc_en_wd = reg_wdata[4];

  assign default_region_he_en_we = addr_hit[25] & reg_we & !reg_error;
  assign default_region_he_en_wd = reg_wdata[5];

  assign bank0_info0_regwen_0_we = addr_hit[26] & reg_we & !reg_error;
  assign bank0_info0_regwen_0_wd = reg_wdata[0];

  assign bank0_info0_regwen_1_we = addr_hit[27] & reg_we & !reg_error;
  assign bank0_info0_regwen_1_wd = reg_wdata[0];

  assign bank0_info0_regwen_2_we = addr_hit[28] & reg_we & !reg_error;
  assign bank0_info0_regwen_2_wd = reg_wdata[0];

  assign bank0_info0_regwen_3_we = addr_hit[29] & reg_we & !reg_error;
  assign bank0_info0_regwen_3_wd = reg_wdata[0];

  assign bank0_info0_regwen_4_we = addr_hit[30] & reg_we & !reg_error;
  assign bank0_info0_regwen_4_wd = reg_wdata[0];

  assign bank0_info0_regwen_5_we = addr_hit[31] & reg_we & !reg_error;
  assign bank0_info0_regwen_5_wd = reg_wdata[0];

  assign bank0_info0_regwen_6_we = addr_hit[32] & reg_we & !reg_error;
  assign bank0_info0_regwen_6_wd = reg_wdata[0];

  assign bank0_info0_regwen_7_we = addr_hit[33] & reg_we & !reg_error;
  assign bank0_info0_regwen_7_wd = reg_wdata[0];

  assign bank0_info0_regwen_8_we = addr_hit[34] & reg_we & !reg_error;
  assign bank0_info0_regwen_8_wd = reg_wdata[0];

  assign bank0_info0_regwen_9_we = addr_hit[35] & reg_we & !reg_error;
  assign bank0_info0_regwen_9_wd = reg_wdata[0];

  assign bank0_info0_page_cfg_0_en_0_we = addr_hit[36] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_0_en_0_wd = reg_wdata[0];

  assign bank0_info0_page_cfg_0_rd_en_0_we = addr_hit[36] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_0_rd_en_0_wd = reg_wdata[1];

  assign bank0_info0_page_cfg_0_prog_en_0_we = addr_hit[36] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_0_prog_en_0_wd = reg_wdata[2];

  assign bank0_info0_page_cfg_0_erase_en_0_we = addr_hit[36] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_0_erase_en_0_wd = reg_wdata[3];

  assign bank0_info0_page_cfg_0_scramble_en_0_we = addr_hit[36] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_0_scramble_en_0_wd = reg_wdata[4];

  assign bank0_info0_page_cfg_0_ecc_en_0_we = addr_hit[36] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_0_ecc_en_0_wd = reg_wdata[5];

  assign bank0_info0_page_cfg_0_he_en_0_we = addr_hit[36] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_0_he_en_0_wd = reg_wdata[6];

  assign bank0_info0_page_cfg_1_en_1_we = addr_hit[37] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_1_en_1_wd = reg_wdata[0];

  assign bank0_info0_page_cfg_1_rd_en_1_we = addr_hit[37] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_1_rd_en_1_wd = reg_wdata[1];

  assign bank0_info0_page_cfg_1_prog_en_1_we = addr_hit[37] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_1_prog_en_1_wd = reg_wdata[2];

  assign bank0_info0_page_cfg_1_erase_en_1_we = addr_hit[37] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_1_erase_en_1_wd = reg_wdata[3];

  assign bank0_info0_page_cfg_1_scramble_en_1_we = addr_hit[37] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_1_scramble_en_1_wd = reg_wdata[4];

  assign bank0_info0_page_cfg_1_ecc_en_1_we = addr_hit[37] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_1_ecc_en_1_wd = reg_wdata[5];

  assign bank0_info0_page_cfg_1_he_en_1_we = addr_hit[37] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_1_he_en_1_wd = reg_wdata[6];

  assign bank0_info0_page_cfg_2_en_2_we = addr_hit[38] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_2_en_2_wd = reg_wdata[0];

  assign bank0_info0_page_cfg_2_rd_en_2_we = addr_hit[38] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_2_rd_en_2_wd = reg_wdata[1];

  assign bank0_info0_page_cfg_2_prog_en_2_we = addr_hit[38] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_2_prog_en_2_wd = reg_wdata[2];

  assign bank0_info0_page_cfg_2_erase_en_2_we = addr_hit[38] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_2_erase_en_2_wd = reg_wdata[3];

  assign bank0_info0_page_cfg_2_scramble_en_2_we = addr_hit[38] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_2_scramble_en_2_wd = reg_wdata[4];

  assign bank0_info0_page_cfg_2_ecc_en_2_we = addr_hit[38] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_2_ecc_en_2_wd = reg_wdata[5];

  assign bank0_info0_page_cfg_2_he_en_2_we = addr_hit[38] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_2_he_en_2_wd = reg_wdata[6];

  assign bank0_info0_page_cfg_3_en_3_we = addr_hit[39] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_3_en_3_wd = reg_wdata[0];

  assign bank0_info0_page_cfg_3_rd_en_3_we = addr_hit[39] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_3_rd_en_3_wd = reg_wdata[1];

  assign bank0_info0_page_cfg_3_prog_en_3_we = addr_hit[39] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_3_prog_en_3_wd = reg_wdata[2];

  assign bank0_info0_page_cfg_3_erase_en_3_we = addr_hit[39] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_3_erase_en_3_wd = reg_wdata[3];

  assign bank0_info0_page_cfg_3_scramble_en_3_we = addr_hit[39] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_3_scramble_en_3_wd = reg_wdata[4];

  assign bank0_info0_page_cfg_3_ecc_en_3_we = addr_hit[39] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_3_ecc_en_3_wd = reg_wdata[5];

  assign bank0_info0_page_cfg_3_he_en_3_we = addr_hit[39] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_3_he_en_3_wd = reg_wdata[6];

  assign bank0_info0_page_cfg_4_en_4_we = addr_hit[40] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_4_en_4_wd = reg_wdata[0];

  assign bank0_info0_page_cfg_4_rd_en_4_we = addr_hit[40] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_4_rd_en_4_wd = reg_wdata[1];

  assign bank0_info0_page_cfg_4_prog_en_4_we = addr_hit[40] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_4_prog_en_4_wd = reg_wdata[2];

  assign bank0_info0_page_cfg_4_erase_en_4_we = addr_hit[40] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_4_erase_en_4_wd = reg_wdata[3];

  assign bank0_info0_page_cfg_4_scramble_en_4_we = addr_hit[40] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_4_scramble_en_4_wd = reg_wdata[4];

  assign bank0_info0_page_cfg_4_ecc_en_4_we = addr_hit[40] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_4_ecc_en_4_wd = reg_wdata[5];

  assign bank0_info0_page_cfg_4_he_en_4_we = addr_hit[40] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_4_he_en_4_wd = reg_wdata[6];

  assign bank0_info0_page_cfg_5_en_5_we = addr_hit[41] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_5_en_5_wd = reg_wdata[0];

  assign bank0_info0_page_cfg_5_rd_en_5_we = addr_hit[41] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_5_rd_en_5_wd = reg_wdata[1];

  assign bank0_info0_page_cfg_5_prog_en_5_we = addr_hit[41] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_5_prog_en_5_wd = reg_wdata[2];

  assign bank0_info0_page_cfg_5_erase_en_5_we = addr_hit[41] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_5_erase_en_5_wd = reg_wdata[3];

  assign bank0_info0_page_cfg_5_scramble_en_5_we = addr_hit[41] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_5_scramble_en_5_wd = reg_wdata[4];

  assign bank0_info0_page_cfg_5_ecc_en_5_we = addr_hit[41] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_5_ecc_en_5_wd = reg_wdata[5];

  assign bank0_info0_page_cfg_5_he_en_5_we = addr_hit[41] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_5_he_en_5_wd = reg_wdata[6];

  assign bank0_info0_page_cfg_6_en_6_we = addr_hit[42] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_6_en_6_wd = reg_wdata[0];

  assign bank0_info0_page_cfg_6_rd_en_6_we = addr_hit[42] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_6_rd_en_6_wd = reg_wdata[1];

  assign bank0_info0_page_cfg_6_prog_en_6_we = addr_hit[42] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_6_prog_en_6_wd = reg_wdata[2];

  assign bank0_info0_page_cfg_6_erase_en_6_we = addr_hit[42] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_6_erase_en_6_wd = reg_wdata[3];

  assign bank0_info0_page_cfg_6_scramble_en_6_we = addr_hit[42] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_6_scramble_en_6_wd = reg_wdata[4];

  assign bank0_info0_page_cfg_6_ecc_en_6_we = addr_hit[42] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_6_ecc_en_6_wd = reg_wdata[5];

  assign bank0_info0_page_cfg_6_he_en_6_we = addr_hit[42] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_6_he_en_6_wd = reg_wdata[6];

  assign bank0_info0_page_cfg_7_en_7_we = addr_hit[43] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_7_en_7_wd = reg_wdata[0];

  assign bank0_info0_page_cfg_7_rd_en_7_we = addr_hit[43] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_7_rd_en_7_wd = reg_wdata[1];

  assign bank0_info0_page_cfg_7_prog_en_7_we = addr_hit[43] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_7_prog_en_7_wd = reg_wdata[2];

  assign bank0_info0_page_cfg_7_erase_en_7_we = addr_hit[43] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_7_erase_en_7_wd = reg_wdata[3];

  assign bank0_info0_page_cfg_7_scramble_en_7_we = addr_hit[43] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_7_scramble_en_7_wd = reg_wdata[4];

  assign bank0_info0_page_cfg_7_ecc_en_7_we = addr_hit[43] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_7_ecc_en_7_wd = reg_wdata[5];

  assign bank0_info0_page_cfg_7_he_en_7_we = addr_hit[43] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_7_he_en_7_wd = reg_wdata[6];

  assign bank0_info0_page_cfg_8_en_8_we = addr_hit[44] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_8_en_8_wd = reg_wdata[0];

  assign bank0_info0_page_cfg_8_rd_en_8_we = addr_hit[44] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_8_rd_en_8_wd = reg_wdata[1];

  assign bank0_info0_page_cfg_8_prog_en_8_we = addr_hit[44] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_8_prog_en_8_wd = reg_wdata[2];

  assign bank0_info0_page_cfg_8_erase_en_8_we = addr_hit[44] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_8_erase_en_8_wd = reg_wdata[3];

  assign bank0_info0_page_cfg_8_scramble_en_8_we = addr_hit[44] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_8_scramble_en_8_wd = reg_wdata[4];

  assign bank0_info0_page_cfg_8_ecc_en_8_we = addr_hit[44] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_8_ecc_en_8_wd = reg_wdata[5];

  assign bank0_info0_page_cfg_8_he_en_8_we = addr_hit[44] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_8_he_en_8_wd = reg_wdata[6];

  assign bank0_info0_page_cfg_9_en_9_we = addr_hit[45] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_9_en_9_wd = reg_wdata[0];

  assign bank0_info0_page_cfg_9_rd_en_9_we = addr_hit[45] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_9_rd_en_9_wd = reg_wdata[1];

  assign bank0_info0_page_cfg_9_prog_en_9_we = addr_hit[45] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_9_prog_en_9_wd = reg_wdata[2];

  assign bank0_info0_page_cfg_9_erase_en_9_we = addr_hit[45] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_9_erase_en_9_wd = reg_wdata[3];

  assign bank0_info0_page_cfg_9_scramble_en_9_we = addr_hit[45] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_9_scramble_en_9_wd = reg_wdata[4];

  assign bank0_info0_page_cfg_9_ecc_en_9_we = addr_hit[45] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_9_ecc_en_9_wd = reg_wdata[5];

  assign bank0_info0_page_cfg_9_he_en_9_we = addr_hit[45] & reg_we & !reg_error;
  assign bank0_info0_page_cfg_9_he_en_9_wd = reg_wdata[6];

  assign bank0_info1_regwen_we = addr_hit[46] & reg_we & !reg_error;
  assign bank0_info1_regwen_wd = reg_wdata[0];

  assign bank0_info1_page_cfg_en_0_we = addr_hit[47] & reg_we & !reg_error;
  assign bank0_info1_page_cfg_en_0_wd = reg_wdata[0];

  assign bank0_info1_page_cfg_rd_en_0_we = addr_hit[47] & reg_we & !reg_error;
  assign bank0_info1_page_cfg_rd_en_0_wd = reg_wdata[1];

  assign bank0_info1_page_cfg_prog_en_0_we = addr_hit[47] & reg_we & !reg_error;
  assign bank0_info1_page_cfg_prog_en_0_wd = reg_wdata[2];

  assign bank0_info1_page_cfg_erase_en_0_we = addr_hit[47] & reg_we & !reg_error;
  assign bank0_info1_page_cfg_erase_en_0_wd = reg_wdata[3];

  assign bank0_info1_page_cfg_scramble_en_0_we = addr_hit[47] & reg_we & !reg_error;
  assign bank0_info1_page_cfg_scramble_en_0_wd = reg_wdata[4];

  assign bank0_info1_page_cfg_ecc_en_0_we = addr_hit[47] & reg_we & !reg_error;
  assign bank0_info1_page_cfg_ecc_en_0_wd = reg_wdata[5];

  assign bank0_info1_page_cfg_he_en_0_we = addr_hit[47] & reg_we & !reg_error;
  assign bank0_info1_page_cfg_he_en_0_wd = reg_wdata[6];

  assign bank0_info2_regwen_0_we = addr_hit[48] & reg_we & !reg_error;
  assign bank0_info2_regwen_0_wd = reg_wdata[0];

  assign bank0_info2_regwen_1_we = addr_hit[49] & reg_we & !reg_error;
  assign bank0_info2_regwen_1_wd = reg_wdata[0];

  assign bank0_info2_page_cfg_0_en_0_we = addr_hit[50] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_0_en_0_wd = reg_wdata[0];

  assign bank0_info2_page_cfg_0_rd_en_0_we = addr_hit[50] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_0_rd_en_0_wd = reg_wdata[1];

  assign bank0_info2_page_cfg_0_prog_en_0_we = addr_hit[50] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_0_prog_en_0_wd = reg_wdata[2];

  assign bank0_info2_page_cfg_0_erase_en_0_we = addr_hit[50] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_0_erase_en_0_wd = reg_wdata[3];

  assign bank0_info2_page_cfg_0_scramble_en_0_we = addr_hit[50] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_0_scramble_en_0_wd = reg_wdata[4];

  assign bank0_info2_page_cfg_0_ecc_en_0_we = addr_hit[50] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_0_ecc_en_0_wd = reg_wdata[5];

  assign bank0_info2_page_cfg_0_he_en_0_we = addr_hit[50] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_0_he_en_0_wd = reg_wdata[6];

  assign bank0_info2_page_cfg_1_en_1_we = addr_hit[51] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_1_en_1_wd = reg_wdata[0];

  assign bank0_info2_page_cfg_1_rd_en_1_we = addr_hit[51] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_1_rd_en_1_wd = reg_wdata[1];

  assign bank0_info2_page_cfg_1_prog_en_1_we = addr_hit[51] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_1_prog_en_1_wd = reg_wdata[2];

  assign bank0_info2_page_cfg_1_erase_en_1_we = addr_hit[51] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_1_erase_en_1_wd = reg_wdata[3];

  assign bank0_info2_page_cfg_1_scramble_en_1_we = addr_hit[51] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_1_scramble_en_1_wd = reg_wdata[4];

  assign bank0_info2_page_cfg_1_ecc_en_1_we = addr_hit[51] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_1_ecc_en_1_wd = reg_wdata[5];

  assign bank0_info2_page_cfg_1_he_en_1_we = addr_hit[51] & reg_we & !reg_error;
  assign bank0_info2_page_cfg_1_he_en_1_wd = reg_wdata[6];

  assign bank1_info0_regwen_0_we = addr_hit[52] & reg_we & !reg_error;
  assign bank1_info0_regwen_0_wd = reg_wdata[0];

  assign bank1_info0_regwen_1_we = addr_hit[53] & reg_we & !reg_error;
  assign bank1_info0_regwen_1_wd = reg_wdata[0];

  assign bank1_info0_regwen_2_we = addr_hit[54] & reg_we & !reg_error;
  assign bank1_info0_regwen_2_wd = reg_wdata[0];

  assign bank1_info0_regwen_3_we = addr_hit[55] & reg_we & !reg_error;
  assign bank1_info0_regwen_3_wd = reg_wdata[0];

  assign bank1_info0_regwen_4_we = addr_hit[56] & reg_we & !reg_error;
  assign bank1_info0_regwen_4_wd = reg_wdata[0];

  assign bank1_info0_regwen_5_we = addr_hit[57] & reg_we & !reg_error;
  assign bank1_info0_regwen_5_wd = reg_wdata[0];

  assign bank1_info0_regwen_6_we = addr_hit[58] & reg_we & !reg_error;
  assign bank1_info0_regwen_6_wd = reg_wdata[0];

  assign bank1_info0_regwen_7_we = addr_hit[59] & reg_we & !reg_error;
  assign bank1_info0_regwen_7_wd = reg_wdata[0];

  assign bank1_info0_regwen_8_we = addr_hit[60] & reg_we & !reg_error;
  assign bank1_info0_regwen_8_wd = reg_wdata[0];

  assign bank1_info0_regwen_9_we = addr_hit[61] & reg_we & !reg_error;
  assign bank1_info0_regwen_9_wd = reg_wdata[0];

  assign bank1_info0_page_cfg_0_en_0_we = addr_hit[62] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_0_en_0_wd = reg_wdata[0];

  assign bank1_info0_page_cfg_0_rd_en_0_we = addr_hit[62] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_0_rd_en_0_wd = reg_wdata[1];

  assign bank1_info0_page_cfg_0_prog_en_0_we = addr_hit[62] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_0_prog_en_0_wd = reg_wdata[2];

  assign bank1_info0_page_cfg_0_erase_en_0_we = addr_hit[62] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_0_erase_en_0_wd = reg_wdata[3];

  assign bank1_info0_page_cfg_0_scramble_en_0_we = addr_hit[62] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_0_scramble_en_0_wd = reg_wdata[4];

  assign bank1_info0_page_cfg_0_ecc_en_0_we = addr_hit[62] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_0_ecc_en_0_wd = reg_wdata[5];

  assign bank1_info0_page_cfg_0_he_en_0_we = addr_hit[62] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_0_he_en_0_wd = reg_wdata[6];

  assign bank1_info0_page_cfg_1_en_1_we = addr_hit[63] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_1_en_1_wd = reg_wdata[0];

  assign bank1_info0_page_cfg_1_rd_en_1_we = addr_hit[63] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_1_rd_en_1_wd = reg_wdata[1];

  assign bank1_info0_page_cfg_1_prog_en_1_we = addr_hit[63] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_1_prog_en_1_wd = reg_wdata[2];

  assign bank1_info0_page_cfg_1_erase_en_1_we = addr_hit[63] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_1_erase_en_1_wd = reg_wdata[3];

  assign bank1_info0_page_cfg_1_scramble_en_1_we = addr_hit[63] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_1_scramble_en_1_wd = reg_wdata[4];

  assign bank1_info0_page_cfg_1_ecc_en_1_we = addr_hit[63] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_1_ecc_en_1_wd = reg_wdata[5];

  assign bank1_info0_page_cfg_1_he_en_1_we = addr_hit[63] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_1_he_en_1_wd = reg_wdata[6];

  assign bank1_info0_page_cfg_2_en_2_we = addr_hit[64] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_2_en_2_wd = reg_wdata[0];

  assign bank1_info0_page_cfg_2_rd_en_2_we = addr_hit[64] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_2_rd_en_2_wd = reg_wdata[1];

  assign bank1_info0_page_cfg_2_prog_en_2_we = addr_hit[64] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_2_prog_en_2_wd = reg_wdata[2];

  assign bank1_info0_page_cfg_2_erase_en_2_we = addr_hit[64] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_2_erase_en_2_wd = reg_wdata[3];

  assign bank1_info0_page_cfg_2_scramble_en_2_we = addr_hit[64] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_2_scramble_en_2_wd = reg_wdata[4];

  assign bank1_info0_page_cfg_2_ecc_en_2_we = addr_hit[64] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_2_ecc_en_2_wd = reg_wdata[5];

  assign bank1_info0_page_cfg_2_he_en_2_we = addr_hit[64] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_2_he_en_2_wd = reg_wdata[6];

  assign bank1_info0_page_cfg_3_en_3_we = addr_hit[65] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_3_en_3_wd = reg_wdata[0];

  assign bank1_info0_page_cfg_3_rd_en_3_we = addr_hit[65] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_3_rd_en_3_wd = reg_wdata[1];

  assign bank1_info0_page_cfg_3_prog_en_3_we = addr_hit[65] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_3_prog_en_3_wd = reg_wdata[2];

  assign bank1_info0_page_cfg_3_erase_en_3_we = addr_hit[65] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_3_erase_en_3_wd = reg_wdata[3];

  assign bank1_info0_page_cfg_3_scramble_en_3_we = addr_hit[65] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_3_scramble_en_3_wd = reg_wdata[4];

  assign bank1_info0_page_cfg_3_ecc_en_3_we = addr_hit[65] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_3_ecc_en_3_wd = reg_wdata[5];

  assign bank1_info0_page_cfg_3_he_en_3_we = addr_hit[65] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_3_he_en_3_wd = reg_wdata[6];

  assign bank1_info0_page_cfg_4_en_4_we = addr_hit[66] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_4_en_4_wd = reg_wdata[0];

  assign bank1_info0_page_cfg_4_rd_en_4_we = addr_hit[66] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_4_rd_en_4_wd = reg_wdata[1];

  assign bank1_info0_page_cfg_4_prog_en_4_we = addr_hit[66] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_4_prog_en_4_wd = reg_wdata[2];

  assign bank1_info0_page_cfg_4_erase_en_4_we = addr_hit[66] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_4_erase_en_4_wd = reg_wdata[3];

  assign bank1_info0_page_cfg_4_scramble_en_4_we = addr_hit[66] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_4_scramble_en_4_wd = reg_wdata[4];

  assign bank1_info0_page_cfg_4_ecc_en_4_we = addr_hit[66] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_4_ecc_en_4_wd = reg_wdata[5];

  assign bank1_info0_page_cfg_4_he_en_4_we = addr_hit[66] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_4_he_en_4_wd = reg_wdata[6];

  assign bank1_info0_page_cfg_5_en_5_we = addr_hit[67] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_5_en_5_wd = reg_wdata[0];

  assign bank1_info0_page_cfg_5_rd_en_5_we = addr_hit[67] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_5_rd_en_5_wd = reg_wdata[1];

  assign bank1_info0_page_cfg_5_prog_en_5_we = addr_hit[67] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_5_prog_en_5_wd = reg_wdata[2];

  assign bank1_info0_page_cfg_5_erase_en_5_we = addr_hit[67] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_5_erase_en_5_wd = reg_wdata[3];

  assign bank1_info0_page_cfg_5_scramble_en_5_we = addr_hit[67] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_5_scramble_en_5_wd = reg_wdata[4];

  assign bank1_info0_page_cfg_5_ecc_en_5_we = addr_hit[67] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_5_ecc_en_5_wd = reg_wdata[5];

  assign bank1_info0_page_cfg_5_he_en_5_we = addr_hit[67] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_5_he_en_5_wd = reg_wdata[6];

  assign bank1_info0_page_cfg_6_en_6_we = addr_hit[68] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_6_en_6_wd = reg_wdata[0];

  assign bank1_info0_page_cfg_6_rd_en_6_we = addr_hit[68] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_6_rd_en_6_wd = reg_wdata[1];

  assign bank1_info0_page_cfg_6_prog_en_6_we = addr_hit[68] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_6_prog_en_6_wd = reg_wdata[2];

  assign bank1_info0_page_cfg_6_erase_en_6_we = addr_hit[68] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_6_erase_en_6_wd = reg_wdata[3];

  assign bank1_info0_page_cfg_6_scramble_en_6_we = addr_hit[68] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_6_scramble_en_6_wd = reg_wdata[4];

  assign bank1_info0_page_cfg_6_ecc_en_6_we = addr_hit[68] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_6_ecc_en_6_wd = reg_wdata[5];

  assign bank1_info0_page_cfg_6_he_en_6_we = addr_hit[68] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_6_he_en_6_wd = reg_wdata[6];

  assign bank1_info0_page_cfg_7_en_7_we = addr_hit[69] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_7_en_7_wd = reg_wdata[0];

  assign bank1_info0_page_cfg_7_rd_en_7_we = addr_hit[69] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_7_rd_en_7_wd = reg_wdata[1];

  assign bank1_info0_page_cfg_7_prog_en_7_we = addr_hit[69] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_7_prog_en_7_wd = reg_wdata[2];

  assign bank1_info0_page_cfg_7_erase_en_7_we = addr_hit[69] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_7_erase_en_7_wd = reg_wdata[3];

  assign bank1_info0_page_cfg_7_scramble_en_7_we = addr_hit[69] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_7_scramble_en_7_wd = reg_wdata[4];

  assign bank1_info0_page_cfg_7_ecc_en_7_we = addr_hit[69] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_7_ecc_en_7_wd = reg_wdata[5];

  assign bank1_info0_page_cfg_7_he_en_7_we = addr_hit[69] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_7_he_en_7_wd = reg_wdata[6];

  assign bank1_info0_page_cfg_8_en_8_we = addr_hit[70] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_8_en_8_wd = reg_wdata[0];

  assign bank1_info0_page_cfg_8_rd_en_8_we = addr_hit[70] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_8_rd_en_8_wd = reg_wdata[1];

  assign bank1_info0_page_cfg_8_prog_en_8_we = addr_hit[70] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_8_prog_en_8_wd = reg_wdata[2];

  assign bank1_info0_page_cfg_8_erase_en_8_we = addr_hit[70] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_8_erase_en_8_wd = reg_wdata[3];

  assign bank1_info0_page_cfg_8_scramble_en_8_we = addr_hit[70] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_8_scramble_en_8_wd = reg_wdata[4];

  assign bank1_info0_page_cfg_8_ecc_en_8_we = addr_hit[70] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_8_ecc_en_8_wd = reg_wdata[5];

  assign bank1_info0_page_cfg_8_he_en_8_we = addr_hit[70] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_8_he_en_8_wd = reg_wdata[6];

  assign bank1_info0_page_cfg_9_en_9_we = addr_hit[71] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_9_en_9_wd = reg_wdata[0];

  assign bank1_info0_page_cfg_9_rd_en_9_we = addr_hit[71] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_9_rd_en_9_wd = reg_wdata[1];

  assign bank1_info0_page_cfg_9_prog_en_9_we = addr_hit[71] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_9_prog_en_9_wd = reg_wdata[2];

  assign bank1_info0_page_cfg_9_erase_en_9_we = addr_hit[71] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_9_erase_en_9_wd = reg_wdata[3];

  assign bank1_info0_page_cfg_9_scramble_en_9_we = addr_hit[71] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_9_scramble_en_9_wd = reg_wdata[4];

  assign bank1_info0_page_cfg_9_ecc_en_9_we = addr_hit[71] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_9_ecc_en_9_wd = reg_wdata[5];

  assign bank1_info0_page_cfg_9_he_en_9_we = addr_hit[71] & reg_we & !reg_error;
  assign bank1_info0_page_cfg_9_he_en_9_wd = reg_wdata[6];

  assign bank1_info1_regwen_we = addr_hit[72] & reg_we & !reg_error;
  assign bank1_info1_regwen_wd = reg_wdata[0];

  assign bank1_info1_page_cfg_en_0_we = addr_hit[73] & reg_we & !reg_error;
  assign bank1_info1_page_cfg_en_0_wd = reg_wdata[0];

  assign bank1_info1_page_cfg_rd_en_0_we = addr_hit[73] & reg_we & !reg_error;
  assign bank1_info1_page_cfg_rd_en_0_wd = reg_wdata[1];

  assign bank1_info1_page_cfg_prog_en_0_we = addr_hit[73] & reg_we & !reg_error;
  assign bank1_info1_page_cfg_prog_en_0_wd = reg_wdata[2];

  assign bank1_info1_page_cfg_erase_en_0_we = addr_hit[73] & reg_we & !reg_error;
  assign bank1_info1_page_cfg_erase_en_0_wd = reg_wdata[3];

  assign bank1_info1_page_cfg_scramble_en_0_we = addr_hit[73] & reg_we & !reg_error;
  assign bank1_info1_page_cfg_scramble_en_0_wd = reg_wdata[4];

  assign bank1_info1_page_cfg_ecc_en_0_we = addr_hit[73] & reg_we & !reg_error;
  assign bank1_info1_page_cfg_ecc_en_0_wd = reg_wdata[5];

  assign bank1_info1_page_cfg_he_en_0_we = addr_hit[73] & reg_we & !reg_error;
  assign bank1_info1_page_cfg_he_en_0_wd = reg_wdata[6];

  assign bank1_info2_regwen_0_we = addr_hit[74] & reg_we & !reg_error;
  assign bank1_info2_regwen_0_wd = reg_wdata[0];

  assign bank1_info2_regwen_1_we = addr_hit[75] & reg_we & !reg_error;
  assign bank1_info2_regwen_1_wd = reg_wdata[0];

  assign bank1_info2_page_cfg_0_en_0_we = addr_hit[76] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_0_en_0_wd = reg_wdata[0];

  assign bank1_info2_page_cfg_0_rd_en_0_we = addr_hit[76] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_0_rd_en_0_wd = reg_wdata[1];

  assign bank1_info2_page_cfg_0_prog_en_0_we = addr_hit[76] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_0_prog_en_0_wd = reg_wdata[2];

  assign bank1_info2_page_cfg_0_erase_en_0_we = addr_hit[76] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_0_erase_en_0_wd = reg_wdata[3];

  assign bank1_info2_page_cfg_0_scramble_en_0_we = addr_hit[76] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_0_scramble_en_0_wd = reg_wdata[4];

  assign bank1_info2_page_cfg_0_ecc_en_0_we = addr_hit[76] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_0_ecc_en_0_wd = reg_wdata[5];

  assign bank1_info2_page_cfg_0_he_en_0_we = addr_hit[76] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_0_he_en_0_wd = reg_wdata[6];

  assign bank1_info2_page_cfg_1_en_1_we = addr_hit[77] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_1_en_1_wd = reg_wdata[0];

  assign bank1_info2_page_cfg_1_rd_en_1_we = addr_hit[77] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_1_rd_en_1_wd = reg_wdata[1];

  assign bank1_info2_page_cfg_1_prog_en_1_we = addr_hit[77] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_1_prog_en_1_wd = reg_wdata[2];

  assign bank1_info2_page_cfg_1_erase_en_1_we = addr_hit[77] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_1_erase_en_1_wd = reg_wdata[3];

  assign bank1_info2_page_cfg_1_scramble_en_1_we = addr_hit[77] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_1_scramble_en_1_wd = reg_wdata[4];

  assign bank1_info2_page_cfg_1_ecc_en_1_we = addr_hit[77] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_1_ecc_en_1_wd = reg_wdata[5];

  assign bank1_info2_page_cfg_1_he_en_1_we = addr_hit[77] & reg_we & !reg_error;
  assign bank1_info2_page_cfg_1_he_en_1_wd = reg_wdata[6];

  assign bank_cfg_regwen_we = addr_hit[78] & reg_we & !reg_error;
  assign bank_cfg_regwen_wd = reg_wdata[0];

  assign mp_bank_cfg_erase_en_0_we = addr_hit[79] & reg_we & !reg_error;
  assign mp_bank_cfg_erase_en_0_wd = reg_wdata[0];

  assign mp_bank_cfg_erase_en_1_we = addr_hit[79] & reg_we & !reg_error;
  assign mp_bank_cfg_erase_en_1_wd = reg_wdata[1];

  assign op_status_done_we = addr_hit[80] & reg_we & !reg_error;
  assign op_status_done_wd = reg_wdata[0];

  assign op_status_err_we = addr_hit[80] & reg_we & !reg_error;
  assign op_status_err_wd = reg_wdata[1];

  assign err_code_flash_err_we = addr_hit[82] & reg_we & !reg_error;
  assign err_code_flash_err_wd = reg_wdata[0];

  assign err_code_flash_alert_we = addr_hit[82] & reg_we & !reg_error;
  assign err_code_flash_alert_wd = reg_wdata[1];

  assign err_code_mp_err_we = addr_hit[82] & reg_we & !reg_error;
  assign err_code_mp_err_wd = reg_wdata[2];

  assign err_code_ecc_single_err_we = addr_hit[82] & reg_we & !reg_error;
  assign err_code_ecc_single_err_wd = reg_wdata[3];

  assign err_code_ecc_multi_err_we = addr_hit[82] & reg_we & !reg_error;
  assign err_code_ecc_multi_err_wd = reg_wdata[4];

  assign phy_alert_cfg_alert_ack_we = addr_hit[86] & reg_we & !reg_error;
  assign phy_alert_cfg_alert_ack_wd = reg_wdata[0];

  assign phy_alert_cfg_alert_trig_we = addr_hit[86] & reg_we & !reg_error;
  assign phy_alert_cfg_alert_trig_wd = reg_wdata[1];

  assign scratch_we = addr_hit[88] & reg_we & !reg_error;
  assign scratch_wd = reg_wdata[31:0];

  assign fifo_lvl_prog_we = addr_hit[89] & reg_we & !reg_error;
  assign fifo_lvl_prog_wd = reg_wdata[4:0];

  assign fifo_lvl_rd_we = addr_hit[89] & reg_we & !reg_error;
  assign fifo_lvl_rd_wd = reg_wdata[12:8];

  assign fifo_rst_we = addr_hit[90] & reg_we & !reg_error;
  assign fifo_rst_wd = reg_wdata[0];

  // Read data return
  always_comb begin
    reg_rdata_next = '0;
    unique case (1'b1)
      addr_hit[0]: begin
        reg_rdata_next[0] = intr_state_prog_empty_qs;
        reg_rdata_next[1] = intr_state_prog_lvl_qs;
        reg_rdata_next[2] = intr_state_rd_full_qs;
        reg_rdata_next[3] = intr_state_rd_lvl_qs;
        reg_rdata_next[4] = intr_state_op_done_qs;
      end

      addr_hit[1]: begin
        reg_rdata_next[0] = intr_enable_prog_empty_qs;
        reg_rdata_next[1] = intr_enable_prog_lvl_qs;
        reg_rdata_next[2] = intr_enable_rd_full_qs;
        reg_rdata_next[3] = intr_enable_rd_lvl_qs;
        reg_rdata_next[4] = intr_enable_op_done_qs;
      end

      addr_hit[2]: begin
        reg_rdata_next[0] = '0;
        reg_rdata_next[1] = '0;
        reg_rdata_next[2] = '0;
        reg_rdata_next[3] = '0;
        reg_rdata_next[4] = '0;
      end

      addr_hit[3]: begin
        reg_rdata_next[0] = '0;
        reg_rdata_next[1] = '0;
        reg_rdata_next[2] = '0;
      end

      addr_hit[4]: begin
        reg_rdata_next[0] = ctrl_regwen_qs;
      end

      addr_hit[5]: begin
        reg_rdata_next[0] = control_start_qs;
        reg_rdata_next[5:4] = control_op_qs;
        reg_rdata_next[6] = control_prog_sel_qs;
        reg_rdata_next[7] = control_erase_sel_qs;
        reg_rdata_next[8] = control_partition_sel_qs;
        reg_rdata_next[10:9] = control_info_sel_qs;
        reg_rdata_next[27:16] = control_num_qs;
      end

      addr_hit[6]: begin
        reg_rdata_next[31:0] = addr_qs;
      end

      addr_hit[7]: begin
        reg_rdata_next[0] = prog_type_en_normal_qs;
        reg_rdata_next[1] = prog_type_en_repair_qs;
      end

      addr_hit[8]: begin
        reg_rdata_next[0] = erase_suspend_qs;
      end

      addr_hit[9]: begin
        reg_rdata_next[0] = region_cfg_regwen_0_qs;
      end

      addr_hit[10]: begin
        reg_rdata_next[0] = region_cfg_regwen_1_qs;
      end

      addr_hit[11]: begin
        reg_rdata_next[0] = region_cfg_regwen_2_qs;
      end

      addr_hit[12]: begin
        reg_rdata_next[0] = region_cfg_regwen_3_qs;
      end

      addr_hit[13]: begin
        reg_rdata_next[0] = region_cfg_regwen_4_qs;
      end

      addr_hit[14]: begin
        reg_rdata_next[0] = region_cfg_regwen_5_qs;
      end

      addr_hit[15]: begin
        reg_rdata_next[0] = region_cfg_regwen_6_qs;
      end

      addr_hit[16]: begin
        reg_rdata_next[0] = region_cfg_regwen_7_qs;
      end

      addr_hit[17]: begin
        reg_rdata_next[0] = mp_region_cfg_0_en_0_qs;
        reg_rdata_next[1] = mp_region_cfg_0_rd_en_0_qs;
        reg_rdata_next[2] = mp_region_cfg_0_prog_en_0_qs;
        reg_rdata_next[3] = mp_region_cfg_0_erase_en_0_qs;
        reg_rdata_next[4] = mp_region_cfg_0_scramble_en_0_qs;
        reg_rdata_next[5] = mp_region_cfg_0_ecc_en_0_qs;
        reg_rdata_next[6] = mp_region_cfg_0_he_en_0_qs;
        reg_rdata_next[16:8] = mp_region_cfg_0_base_0_qs;
        reg_rdata_next[26:17] = mp_region_cfg_0_size_0_qs;
      end

      addr_hit[18]: begin
        reg_rdata_next[0] = mp_region_cfg_1_en_1_qs;
        reg_rdata_next[1] = mp_region_cfg_1_rd_en_1_qs;
        reg_rdata_next[2] = mp_region_cfg_1_prog_en_1_qs;
        reg_rdata_next[3] = mp_region_cfg_1_erase_en_1_qs;
        reg_rdata_next[4] = mp_region_cfg_1_scramble_en_1_qs;
        reg_rdata_next[5] = mp_region_cfg_1_ecc_en_1_qs;
        reg_rdata_next[6] = mp_region_cfg_1_he_en_1_qs;
        reg_rdata_next[16:8] = mp_region_cfg_1_base_1_qs;
        reg_rdata_next[26:17] = mp_region_cfg_1_size_1_qs;
      end

      addr_hit[19]: begin
        reg_rdata_next[0] = mp_region_cfg_2_en_2_qs;
        reg_rdata_next[1] = mp_region_cfg_2_rd_en_2_qs;
        reg_rdata_next[2] = mp_region_cfg_2_prog_en_2_qs;
        reg_rdata_next[3] = mp_region_cfg_2_erase_en_2_qs;
        reg_rdata_next[4] = mp_region_cfg_2_scramble_en_2_qs;
        reg_rdata_next[5] = mp_region_cfg_2_ecc_en_2_qs;
        reg_rdata_next[6] = mp_region_cfg_2_he_en_2_qs;
        reg_rdata_next[16:8] = mp_region_cfg_2_base_2_qs;
        reg_rdata_next[26:17] = mp_region_cfg_2_size_2_qs;
      end

      addr_hit[20]: begin
        reg_rdata_next[0] = mp_region_cfg_3_en_3_qs;
        reg_rdata_next[1] = mp_region_cfg_3_rd_en_3_qs;
        reg_rdata_next[2] = mp_region_cfg_3_prog_en_3_qs;
        reg_rdata_next[3] = mp_region_cfg_3_erase_en_3_qs;
        reg_rdata_next[4] = mp_region_cfg_3_scramble_en_3_qs;
        reg_rdata_next[5] = mp_region_cfg_3_ecc_en_3_qs;
        reg_rdata_next[6] = mp_region_cfg_3_he_en_3_qs;
        reg_rdata_next[16:8] = mp_region_cfg_3_base_3_qs;
        reg_rdata_next[26:17] = mp_region_cfg_3_size_3_qs;
      end

      addr_hit[21]: begin
        reg_rdata_next[0] = mp_region_cfg_4_en_4_qs;
        reg_rdata_next[1] = mp_region_cfg_4_rd_en_4_qs;
        reg_rdata_next[2] = mp_region_cfg_4_prog_en_4_qs;
        reg_rdata_next[3] = mp_region_cfg_4_erase_en_4_qs;
        reg_rdata_next[4] = mp_region_cfg_4_scramble_en_4_qs;
        reg_rdata_next[5] = mp_region_cfg_4_ecc_en_4_qs;
        reg_rdata_next[6] = mp_region_cfg_4_he_en_4_qs;
        reg_rdata_next[16:8] = mp_region_cfg_4_base_4_qs;
        reg_rdata_next[26:17] = mp_region_cfg_4_size_4_qs;
      end

      addr_hit[22]: begin
        reg_rdata_next[0] = mp_region_cfg_5_en_5_qs;
        reg_rdata_next[1] = mp_region_cfg_5_rd_en_5_qs;
        reg_rdata_next[2] = mp_region_cfg_5_prog_en_5_qs;
        reg_rdata_next[3] = mp_region_cfg_5_erase_en_5_qs;
        reg_rdata_next[4] = mp_region_cfg_5_scramble_en_5_qs;
        reg_rdata_next[5] = mp_region_cfg_5_ecc_en_5_qs;
        reg_rdata_next[6] = mp_region_cfg_5_he_en_5_qs;
        reg_rdata_next[16:8] = mp_region_cfg_5_base_5_qs;
        reg_rdata_next[26:17] = mp_region_cfg_5_size_5_qs;
      end

      addr_hit[23]: begin
        reg_rdata_next[0] = mp_region_cfg_6_en_6_qs;
        reg_rdata_next[1] = mp_region_cfg_6_rd_en_6_qs;
        reg_rdata_next[2] = mp_region_cfg_6_prog_en_6_qs;
        reg_rdata_next[3] = mp_region_cfg_6_erase_en_6_qs;
        reg_rdata_next[4] = mp_region_cfg_6_scramble_en_6_qs;
        reg_rdata_next[5] = mp_region_cfg_6_ecc_en_6_qs;
        reg_rdata_next[6] = mp_region_cfg_6_he_en_6_qs;
        reg_rdata_next[16:8] = mp_region_cfg_6_base_6_qs;
        reg_rdata_next[26:17] = mp_region_cfg_6_size_6_qs;
      end

      addr_hit[24]: begin
        reg_rdata_next[0] = mp_region_cfg_7_en_7_qs;
        reg_rdata_next[1] = mp_region_cfg_7_rd_en_7_qs;
        reg_rdata_next[2] = mp_region_cfg_7_prog_en_7_qs;
        reg_rdata_next[3] = mp_region_cfg_7_erase_en_7_qs;
        reg_rdata_next[4] = mp_region_cfg_7_scramble_en_7_qs;
        reg_rdata_next[5] = mp_region_cfg_7_ecc_en_7_qs;
        reg_rdata_next[6] = mp_region_cfg_7_he_en_7_qs;
        reg_rdata_next[16:8] = mp_region_cfg_7_base_7_qs;
        reg_rdata_next[26:17] = mp_region_cfg_7_size_7_qs;
      end

      addr_hit[25]: begin
        reg_rdata_next[0] = default_region_rd_en_qs;
        reg_rdata_next[1] = default_region_prog_en_qs;
        reg_rdata_next[2] = default_region_erase_en_qs;
        reg_rdata_next[3] = default_region_scramble_en_qs;
        reg_rdata_next[4] = default_region_ecc_en_qs;
        reg_rdata_next[5] = default_region_he_en_qs;
      end

      addr_hit[26]: begin
        reg_rdata_next[0] = bank0_info0_regwen_0_qs;
      end

      addr_hit[27]: begin
        reg_rdata_next[0] = bank0_info0_regwen_1_qs;
      end

      addr_hit[28]: begin
        reg_rdata_next[0] = bank0_info0_regwen_2_qs;
      end

      addr_hit[29]: begin
        reg_rdata_next[0] = bank0_info0_regwen_3_qs;
      end

      addr_hit[30]: begin
        reg_rdata_next[0] = bank0_info0_regwen_4_qs;
      end

      addr_hit[31]: begin
        reg_rdata_next[0] = bank0_info0_regwen_5_qs;
      end

      addr_hit[32]: begin
        reg_rdata_next[0] = bank0_info0_regwen_6_qs;
      end

      addr_hit[33]: begin
        reg_rdata_next[0] = bank0_info0_regwen_7_qs;
      end

      addr_hit[34]: begin
        reg_rdata_next[0] = bank0_info0_regwen_8_qs;
      end

      addr_hit[35]: begin
        reg_rdata_next[0] = bank0_info0_regwen_9_qs;
      end

      addr_hit[36]: begin
        reg_rdata_next[0] = bank0_info0_page_cfg_0_en_0_qs;
        reg_rdata_next[1] = bank0_info0_page_cfg_0_rd_en_0_qs;
        reg_rdata_next[2] = bank0_info0_page_cfg_0_prog_en_0_qs;
        reg_rdata_next[3] = bank0_info0_page_cfg_0_erase_en_0_qs;
        reg_rdata_next[4] = bank0_info0_page_cfg_0_scramble_en_0_qs;
        reg_rdata_next[5] = bank0_info0_page_cfg_0_ecc_en_0_qs;
        reg_rdata_next[6] = bank0_info0_page_cfg_0_he_en_0_qs;
      end

      addr_hit[37]: begin
        reg_rdata_next[0] = bank0_info0_page_cfg_1_en_1_qs;
        reg_rdata_next[1] = bank0_info0_page_cfg_1_rd_en_1_qs;
        reg_rdata_next[2] = bank0_info0_page_cfg_1_prog_en_1_qs;
        reg_rdata_next[3] = bank0_info0_page_cfg_1_erase_en_1_qs;
        reg_rdata_next[4] = bank0_info0_page_cfg_1_scramble_en_1_qs;
        reg_rdata_next[5] = bank0_info0_page_cfg_1_ecc_en_1_qs;
        reg_rdata_next[6] = bank0_info0_page_cfg_1_he_en_1_qs;
      end

      addr_hit[38]: begin
        reg_rdata_next[0] = bank0_info0_page_cfg_2_en_2_qs;
        reg_rdata_next[1] = bank0_info0_page_cfg_2_rd_en_2_qs;
        reg_rdata_next[2] = bank0_info0_page_cfg_2_prog_en_2_qs;
        reg_rdata_next[3] = bank0_info0_page_cfg_2_erase_en_2_qs;
        reg_rdata_next[4] = bank0_info0_page_cfg_2_scramble_en_2_qs;
        reg_rdata_next[5] = bank0_info0_page_cfg_2_ecc_en_2_qs;
        reg_rdata_next[6] = bank0_info0_page_cfg_2_he_en_2_qs;
      end

      addr_hit[39]: begin
        reg_rdata_next[0] = bank0_info0_page_cfg_3_en_3_qs;
        reg_rdata_next[1] = bank0_info0_page_cfg_3_rd_en_3_qs;
        reg_rdata_next[2] = bank0_info0_page_cfg_3_prog_en_3_qs;
        reg_rdata_next[3] = bank0_info0_page_cfg_3_erase_en_3_qs;
        reg_rdata_next[4] = bank0_info0_page_cfg_3_scramble_en_3_qs;
        reg_rdata_next[5] = bank0_info0_page_cfg_3_ecc_en_3_qs;
        reg_rdata_next[6] = bank0_info0_page_cfg_3_he_en_3_qs;
      end

      addr_hit[40]: begin
        reg_rdata_next[0] = bank0_info0_page_cfg_4_en_4_qs;
        reg_rdata_next[1] = bank0_info0_page_cfg_4_rd_en_4_qs;
        reg_rdata_next[2] = bank0_info0_page_cfg_4_prog_en_4_qs;
        reg_rdata_next[3] = bank0_info0_page_cfg_4_erase_en_4_qs;
        reg_rdata_next[4] = bank0_info0_page_cfg_4_scramble_en_4_qs;
        reg_rdata_next[5] = bank0_info0_page_cfg_4_ecc_en_4_qs;
        reg_rdata_next[6] = bank0_info0_page_cfg_4_he_en_4_qs;
      end

      addr_hit[41]: begin
        reg_rdata_next[0] = bank0_info0_page_cfg_5_en_5_qs;
        reg_rdata_next[1] = bank0_info0_page_cfg_5_rd_en_5_qs;
        reg_rdata_next[2] = bank0_info0_page_cfg_5_prog_en_5_qs;
        reg_rdata_next[3] = bank0_info0_page_cfg_5_erase_en_5_qs;
        reg_rdata_next[4] = bank0_info0_page_cfg_5_scramble_en_5_qs;
        reg_rdata_next[5] = bank0_info0_page_cfg_5_ecc_en_5_qs;
        reg_rdata_next[6] = bank0_info0_page_cfg_5_he_en_5_qs;
      end

      addr_hit[42]: begin
        reg_rdata_next[0] = bank0_info0_page_cfg_6_en_6_qs;
        reg_rdata_next[1] = bank0_info0_page_cfg_6_rd_en_6_qs;
        reg_rdata_next[2] = bank0_info0_page_cfg_6_prog_en_6_qs;
        reg_rdata_next[3] = bank0_info0_page_cfg_6_erase_en_6_qs;
        reg_rdata_next[4] = bank0_info0_page_cfg_6_scramble_en_6_qs;
        reg_rdata_next[5] = bank0_info0_page_cfg_6_ecc_en_6_qs;
        reg_rdata_next[6] = bank0_info0_page_cfg_6_he_en_6_qs;
      end

      addr_hit[43]: begin
        reg_rdata_next[0] = bank0_info0_page_cfg_7_en_7_qs;
        reg_rdata_next[1] = bank0_info0_page_cfg_7_rd_en_7_qs;
        reg_rdata_next[2] = bank0_info0_page_cfg_7_prog_en_7_qs;
        reg_rdata_next[3] = bank0_info0_page_cfg_7_erase_en_7_qs;
        reg_rdata_next[4] = bank0_info0_page_cfg_7_scramble_en_7_qs;
        reg_rdata_next[5] = bank0_info0_page_cfg_7_ecc_en_7_qs;
        reg_rdata_next[6] = bank0_info0_page_cfg_7_he_en_7_qs;
      end

      addr_hit[44]: begin
        reg_rdata_next[0] = bank0_info0_page_cfg_8_en_8_qs;
        reg_rdata_next[1] = bank0_info0_page_cfg_8_rd_en_8_qs;
        reg_rdata_next[2] = bank0_info0_page_cfg_8_prog_en_8_qs;
        reg_rdata_next[3] = bank0_info0_page_cfg_8_erase_en_8_qs;
        reg_rdata_next[4] = bank0_info0_page_cfg_8_scramble_en_8_qs;
        reg_rdata_next[5] = bank0_info0_page_cfg_8_ecc_en_8_qs;
        reg_rdata_next[6] = bank0_info0_page_cfg_8_he_en_8_qs;
      end

      addr_hit[45]: begin
        reg_rdata_next[0] = bank0_info0_page_cfg_9_en_9_qs;
        reg_rdata_next[1] = bank0_info0_page_cfg_9_rd_en_9_qs;
        reg_rdata_next[2] = bank0_info0_page_cfg_9_prog_en_9_qs;
        reg_rdata_next[3] = bank0_info0_page_cfg_9_erase_en_9_qs;
        reg_rdata_next[4] = bank0_info0_page_cfg_9_scramble_en_9_qs;
        reg_rdata_next[5] = bank0_info0_page_cfg_9_ecc_en_9_qs;
        reg_rdata_next[6] = bank0_info0_page_cfg_9_he_en_9_qs;
      end

      addr_hit[46]: begin
        reg_rdata_next[0] = bank0_info1_regwen_qs;
      end

      addr_hit[47]: begin
        reg_rdata_next[0] = bank0_info1_page_cfg_en_0_qs;
        reg_rdata_next[1] = bank0_info1_page_cfg_rd_en_0_qs;
        reg_rdata_next[2] = bank0_info1_page_cfg_prog_en_0_qs;
        reg_rdata_next[3] = bank0_info1_page_cfg_erase_en_0_qs;
        reg_rdata_next[4] = bank0_info1_page_cfg_scramble_en_0_qs;
        reg_rdata_next[5] = bank0_info1_page_cfg_ecc_en_0_qs;
        reg_rdata_next[6] = bank0_info1_page_cfg_he_en_0_qs;
      end

      addr_hit[48]: begin
        reg_rdata_next[0] = bank0_info2_regwen_0_qs;
      end

      addr_hit[49]: begin
        reg_rdata_next[0] = bank0_info2_regwen_1_qs;
      end

      addr_hit[50]: begin
        reg_rdata_next[0] = bank0_info2_page_cfg_0_en_0_qs;
        reg_rdata_next[1] = bank0_info2_page_cfg_0_rd_en_0_qs;
        reg_rdata_next[2] = bank0_info2_page_cfg_0_prog_en_0_qs;
        reg_rdata_next[3] = bank0_info2_page_cfg_0_erase_en_0_qs;
        reg_rdata_next[4] = bank0_info2_page_cfg_0_scramble_en_0_qs;
        reg_rdata_next[5] = bank0_info2_page_cfg_0_ecc_en_0_qs;
        reg_rdata_next[6] = bank0_info2_page_cfg_0_he_en_0_qs;
      end

      addr_hit[51]: begin
        reg_rdata_next[0] = bank0_info2_page_cfg_1_en_1_qs;
        reg_rdata_next[1] = bank0_info2_page_cfg_1_rd_en_1_qs;
        reg_rdata_next[2] = bank0_info2_page_cfg_1_prog_en_1_qs;
        reg_rdata_next[3] = bank0_info2_page_cfg_1_erase_en_1_qs;
        reg_rdata_next[4] = bank0_info2_page_cfg_1_scramble_en_1_qs;
        reg_rdata_next[5] = bank0_info2_page_cfg_1_ecc_en_1_qs;
        reg_rdata_next[6] = bank0_info2_page_cfg_1_he_en_1_qs;
      end

      addr_hit[52]: begin
        reg_rdata_next[0] = bank1_info0_regwen_0_qs;
      end

      addr_hit[53]: begin
        reg_rdata_next[0] = bank1_info0_regwen_1_qs;
      end

      addr_hit[54]: begin
        reg_rdata_next[0] = bank1_info0_regwen_2_qs;
      end

      addr_hit[55]: begin
        reg_rdata_next[0] = bank1_info0_regwen_3_qs;
      end

      addr_hit[56]: begin
        reg_rdata_next[0] = bank1_info0_regwen_4_qs;
      end

      addr_hit[57]: begin
        reg_rdata_next[0] = bank1_info0_regwen_5_qs;
      end

      addr_hit[58]: begin
        reg_rdata_next[0] = bank1_info0_regwen_6_qs;
      end

      addr_hit[59]: begin
        reg_rdata_next[0] = bank1_info0_regwen_7_qs;
      end

      addr_hit[60]: begin
        reg_rdata_next[0] = bank1_info0_regwen_8_qs;
      end

      addr_hit[61]: begin
        reg_rdata_next[0] = bank1_info0_regwen_9_qs;
      end

      addr_hit[62]: begin
        reg_rdata_next[0] = bank1_info0_page_cfg_0_en_0_qs;
        reg_rdata_next[1] = bank1_info0_page_cfg_0_rd_en_0_qs;
        reg_rdata_next[2] = bank1_info0_page_cfg_0_prog_en_0_qs;
        reg_rdata_next[3] = bank1_info0_page_cfg_0_erase_en_0_qs;
        reg_rdata_next[4] = bank1_info0_page_cfg_0_scramble_en_0_qs;
        reg_rdata_next[5] = bank1_info0_page_cfg_0_ecc_en_0_qs;
        reg_rdata_next[6] = bank1_info0_page_cfg_0_he_en_0_qs;
      end

      addr_hit[63]: begin
        reg_rdata_next[0] = bank1_info0_page_cfg_1_en_1_qs;
        reg_rdata_next[1] = bank1_info0_page_cfg_1_rd_en_1_qs;
        reg_rdata_next[2] = bank1_info0_page_cfg_1_prog_en_1_qs;
        reg_rdata_next[3] = bank1_info0_page_cfg_1_erase_en_1_qs;
        reg_rdata_next[4] = bank1_info0_page_cfg_1_scramble_en_1_qs;
        reg_rdata_next[5] = bank1_info0_page_cfg_1_ecc_en_1_qs;
        reg_rdata_next[6] = bank1_info0_page_cfg_1_he_en_1_qs;
      end

      addr_hit[64]: begin
        reg_rdata_next[0] = bank1_info0_page_cfg_2_en_2_qs;
        reg_rdata_next[1] = bank1_info0_page_cfg_2_rd_en_2_qs;
        reg_rdata_next[2] = bank1_info0_page_cfg_2_prog_en_2_qs;
        reg_rdata_next[3] = bank1_info0_page_cfg_2_erase_en_2_qs;
        reg_rdata_next[4] = bank1_info0_page_cfg_2_scramble_en_2_qs;
        reg_rdata_next[5] = bank1_info0_page_cfg_2_ecc_en_2_qs;
        reg_rdata_next[6] = bank1_info0_page_cfg_2_he_en_2_qs;
      end

      addr_hit[65]: begin
        reg_rdata_next[0] = bank1_info0_page_cfg_3_en_3_qs;
        reg_rdata_next[1] = bank1_info0_page_cfg_3_rd_en_3_qs;
        reg_rdata_next[2] = bank1_info0_page_cfg_3_prog_en_3_qs;
        reg_rdata_next[3] = bank1_info0_page_cfg_3_erase_en_3_qs;
        reg_rdata_next[4] = bank1_info0_page_cfg_3_scramble_en_3_qs;
        reg_rdata_next[5] = bank1_info0_page_cfg_3_ecc_en_3_qs;
        reg_rdata_next[6] = bank1_info0_page_cfg_3_he_en_3_qs;
      end

      addr_hit[66]: begin
        reg_rdata_next[0] = bank1_info0_page_cfg_4_en_4_qs;
        reg_rdata_next[1] = bank1_info0_page_cfg_4_rd_en_4_qs;
        reg_rdata_next[2] = bank1_info0_page_cfg_4_prog_en_4_qs;
        reg_rdata_next[3] = bank1_info0_page_cfg_4_erase_en_4_qs;
        reg_rdata_next[4] = bank1_info0_page_cfg_4_scramble_en_4_qs;
        reg_rdata_next[5] = bank1_info0_page_cfg_4_ecc_en_4_qs;
        reg_rdata_next[6] = bank1_info0_page_cfg_4_he_en_4_qs;
      end

      addr_hit[67]: begin
        reg_rdata_next[0] = bank1_info0_page_cfg_5_en_5_qs;
        reg_rdata_next[1] = bank1_info0_page_cfg_5_rd_en_5_qs;
        reg_rdata_next[2] = bank1_info0_page_cfg_5_prog_en_5_qs;
        reg_rdata_next[3] = bank1_info0_page_cfg_5_erase_en_5_qs;
        reg_rdata_next[4] = bank1_info0_page_cfg_5_scramble_en_5_qs;
        reg_rdata_next[5] = bank1_info0_page_cfg_5_ecc_en_5_qs;
        reg_rdata_next[6] = bank1_info0_page_cfg_5_he_en_5_qs;
      end

      addr_hit[68]: begin
        reg_rdata_next[0] = bank1_info0_page_cfg_6_en_6_qs;
        reg_rdata_next[1] = bank1_info0_page_cfg_6_rd_en_6_qs;
        reg_rdata_next[2] = bank1_info0_page_cfg_6_prog_en_6_qs;
        reg_rdata_next[3] = bank1_info0_page_cfg_6_erase_en_6_qs;
        reg_rdata_next[4] = bank1_info0_page_cfg_6_scramble_en_6_qs;
        reg_rdata_next[5] = bank1_info0_page_cfg_6_ecc_en_6_qs;
        reg_rdata_next[6] = bank1_info0_page_cfg_6_he_en_6_qs;
      end

      addr_hit[69]: begin
        reg_rdata_next[0] = bank1_info0_page_cfg_7_en_7_qs;
        reg_rdata_next[1] = bank1_info0_page_cfg_7_rd_en_7_qs;
        reg_rdata_next[2] = bank1_info0_page_cfg_7_prog_en_7_qs;
        reg_rdata_next[3] = bank1_info0_page_cfg_7_erase_en_7_qs;
        reg_rdata_next[4] = bank1_info0_page_cfg_7_scramble_en_7_qs;
        reg_rdata_next[5] = bank1_info0_page_cfg_7_ecc_en_7_qs;
        reg_rdata_next[6] = bank1_info0_page_cfg_7_he_en_7_qs;
      end

      addr_hit[70]: begin
        reg_rdata_next[0] = bank1_info0_page_cfg_8_en_8_qs;
        reg_rdata_next[1] = bank1_info0_page_cfg_8_rd_en_8_qs;
        reg_rdata_next[2] = bank1_info0_page_cfg_8_prog_en_8_qs;
        reg_rdata_next[3] = bank1_info0_page_cfg_8_erase_en_8_qs;
        reg_rdata_next[4] = bank1_info0_page_cfg_8_scramble_en_8_qs;
        reg_rdata_next[5] = bank1_info0_page_cfg_8_ecc_en_8_qs;
        reg_rdata_next[6] = bank1_info0_page_cfg_8_he_en_8_qs;
      end

      addr_hit[71]: begin
        reg_rdata_next[0] = bank1_info0_page_cfg_9_en_9_qs;
        reg_rdata_next[1] = bank1_info0_page_cfg_9_rd_en_9_qs;
        reg_rdata_next[2] = bank1_info0_page_cfg_9_prog_en_9_qs;
        reg_rdata_next[3] = bank1_info0_page_cfg_9_erase_en_9_qs;
        reg_rdata_next[4] = bank1_info0_page_cfg_9_scramble_en_9_qs;
        reg_rdata_next[5] = bank1_info0_page_cfg_9_ecc_en_9_qs;
        reg_rdata_next[6] = bank1_info0_page_cfg_9_he_en_9_qs;
      end

      addr_hit[72]: begin
        reg_rdata_next[0] = bank1_info1_regwen_qs;
      end

      addr_hit[73]: begin
        reg_rdata_next[0] = bank1_info1_page_cfg_en_0_qs;
        reg_rdata_next[1] = bank1_info1_page_cfg_rd_en_0_qs;
        reg_rdata_next[2] = bank1_info1_page_cfg_prog_en_0_qs;
        reg_rdata_next[3] = bank1_info1_page_cfg_erase_en_0_qs;
        reg_rdata_next[4] = bank1_info1_page_cfg_scramble_en_0_qs;
        reg_rdata_next[5] = bank1_info1_page_cfg_ecc_en_0_qs;
        reg_rdata_next[6] = bank1_info1_page_cfg_he_en_0_qs;
      end

      addr_hit[74]: begin
        reg_rdata_next[0] = bank1_info2_regwen_0_qs;
      end

      addr_hit[75]: begin
        reg_rdata_next[0] = bank1_info2_regwen_1_qs;
      end

      addr_hit[76]: begin
        reg_rdata_next[0] = bank1_info2_page_cfg_0_en_0_qs;
        reg_rdata_next[1] = bank1_info2_page_cfg_0_rd_en_0_qs;
        reg_rdata_next[2] = bank1_info2_page_cfg_0_prog_en_0_qs;
        reg_rdata_next[3] = bank1_info2_page_cfg_0_erase_en_0_qs;
        reg_rdata_next[4] = bank1_info2_page_cfg_0_scramble_en_0_qs;
        reg_rdata_next[5] = bank1_info2_page_cfg_0_ecc_en_0_qs;
        reg_rdata_next[6] = bank1_info2_page_cfg_0_he_en_0_qs;
      end

      addr_hit[77]: begin
        reg_rdata_next[0] = bank1_info2_page_cfg_1_en_1_qs;
        reg_rdata_next[1] = bank1_info2_page_cfg_1_rd_en_1_qs;
        reg_rdata_next[2] = bank1_info2_page_cfg_1_prog_en_1_qs;
        reg_rdata_next[3] = bank1_info2_page_cfg_1_erase_en_1_qs;
        reg_rdata_next[4] = bank1_info2_page_cfg_1_scramble_en_1_qs;
        reg_rdata_next[5] = bank1_info2_page_cfg_1_ecc_en_1_qs;
        reg_rdata_next[6] = bank1_info2_page_cfg_1_he_en_1_qs;
      end

      addr_hit[78]: begin
        reg_rdata_next[0] = bank_cfg_regwen_qs;
      end

      addr_hit[79]: begin
        reg_rdata_next[0] = mp_bank_cfg_erase_en_0_qs;
        reg_rdata_next[1] = mp_bank_cfg_erase_en_1_qs;
      end

      addr_hit[80]: begin
        reg_rdata_next[0] = op_status_done_qs;
        reg_rdata_next[1] = op_status_err_qs;
      end

      addr_hit[81]: begin
        reg_rdata_next[0] = status_rd_full_qs;
        reg_rdata_next[1] = status_rd_empty_qs;
        reg_rdata_next[2] = status_prog_full_qs;
        reg_rdata_next[3] = status_prog_empty_qs;
        reg_rdata_next[4] = status_init_wip_qs;
      end

      addr_hit[82]: begin
        reg_rdata_next[0] = err_code_flash_err_qs;
        reg_rdata_next[1] = err_code_flash_alert_qs;
        reg_rdata_next[2] = err_code_mp_err_qs;
        reg_rdata_next[3] = err_code_ecc_single_err_qs;
        reg_rdata_next[4] = err_code_ecc_multi_err_qs;
      end

      addr_hit[83]: begin
        reg_rdata_next[8:0] = err_addr_qs;
      end

      addr_hit[84]: begin
        reg_rdata_next[19:0] = ecc_err_addr_0_qs;
      end

      addr_hit[85]: begin
        reg_rdata_next[19:0] = ecc_err_addr_1_qs;
      end

      addr_hit[86]: begin
        reg_rdata_next[0] = phy_alert_cfg_alert_ack_qs;
        reg_rdata_next[1] = phy_alert_cfg_alert_trig_qs;
      end

      addr_hit[87]: begin
        reg_rdata_next[0] = phy_status_init_wip_qs;
        reg_rdata_next[1] = phy_status_prog_normal_avail_qs;
        reg_rdata_next[2] = phy_status_prog_repair_avail_qs;
      end

      addr_hit[88]: begin
        reg_rdata_next[31:0] = scratch_qs;
      end

      addr_hit[89]: begin
        reg_rdata_next[4:0] = fifo_lvl_prog_qs;
        reg_rdata_next[12:8] = fifo_lvl_rd_qs;
      end

      addr_hit[90]: begin
        reg_rdata_next[0] = fifo_rst_qs;
      end

      default: begin
        reg_rdata_next = '1;
      end
    endcase
  end

  // Unused signal tieoff

  // wdata / byte enable are not always fully used
  // add a blanket unused statement to handle lint waivers
  logic unused_wdata;
  logic unused_be;
  assign unused_wdata = ^reg_wdata;
  assign unused_be = ^reg_be;

  // Assertions for Register Interface
  `ASSERT_PULSE(wePulse, reg_we)
  `ASSERT_PULSE(rePulse, reg_re)

  `ASSERT(reAfterRv, $rose(reg_re || reg_we) |=> tl_o.d_valid)

  `ASSERT(en2addrHit, (reg_we || reg_re) |-> $onehot0(addr_hit))

  // this is formulated as an assumption such that the FPV testbenches do disprove this
  // property by mistake
  //`ASSUME(reqParity, tl_reg_h2d.a_valid |-> tl_reg_h2d.a_user.chk_en == tlul_pkg::CheckDis)

endmodule
