// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// Register Top module auto-generated by `reggen`

`include "prim_assert.sv"

module entropy_src_reg_top (
  input clk_i,
  input rst_ni,

  input  tlul_pkg::tl_h2d_t tl_i,
  output tlul_pkg::tl_d2h_t tl_o,
  // To HW
  output entropy_src_reg_pkg::entropy_src_reg2hw_t reg2hw, // Write
  input  entropy_src_reg_pkg::entropy_src_hw2reg_t hw2reg, // Read

  // Integrity check errors
  output logic intg_err_o,

  // Config
  input devmode_i // If 1, explicit error return for unmapped register access
);

  import entropy_src_reg_pkg::* ;

  localparam int AW = 8;
  localparam int DW = 32;
  localparam int DBW = DW/8;                    // Byte Width

  // register signals
  logic           reg_we;
  logic           reg_re;
  logic [AW-1:0]  reg_addr;
  logic [DW-1:0]  reg_wdata;
  logic [DBW-1:0] reg_be;
  logic [DW-1:0]  reg_rdata;
  logic           reg_error;

  logic          addrmiss, wr_err;

  logic [DW-1:0] reg_rdata_next;

  tlul_pkg::tl_h2d_t tl_reg_h2d;
  tlul_pkg::tl_d2h_t tl_reg_d2h;

  // incoming payload check
  logic intg_err;
  tlul_cmd_intg_chk u_chk (
    .tl_i,
    .err_o(intg_err)
  );

  logic intg_err_q;
  always_ff @(posedge clk_i or negedge rst_ni) begin
    if (!rst_ni) begin
      intg_err_q <= '0;
    end else if (intg_err) begin
      intg_err_q <= 1'b1;
    end
  end

  // integrity error output is permanent and should be used for alert generation
  // register errors are transactional
  assign intg_err_o = intg_err_q | intg_err;

  // outgoing integrity generation
  tlul_pkg::tl_d2h_t tl_o_pre;
  tlul_rsp_intg_gen u_rsp_intg_gen (
    .tl_i(tl_o_pre),
    .tl_o
  );

  assign tl_reg_h2d = tl_i;
  assign tl_o_pre   = tl_reg_d2h;

  tlul_adapter_reg #(
    .RegAw(AW),
    .RegDw(DW)
  ) u_reg_if (
    .clk_i,
    .rst_ni,

    .tl_i (tl_reg_h2d),
    .tl_o (tl_reg_d2h),

    .we_o    (reg_we),
    .re_o    (reg_re),
    .addr_o  (reg_addr),
    .wdata_o (reg_wdata),
    .be_o    (reg_be),
    .rdata_i (reg_rdata),
    .error_i (reg_error)
  );

  assign reg_rdata = reg_rdata_next ;
  assign reg_error = (devmode_i & addrmiss) | wr_err | intg_err;

  // Define SW related signals
  // Format: <reg>_<field>_{wd|we|qs}
  //        or <reg>_{wd|we|qs} if field == 1 or 0
  logic intr_state_es_entropy_valid_qs;
  logic intr_state_es_entropy_valid_wd;
  logic intr_state_es_entropy_valid_we;
  logic intr_state_es_health_test_failed_qs;
  logic intr_state_es_health_test_failed_wd;
  logic intr_state_es_health_test_failed_we;
  logic intr_state_es_fatal_err_qs;
  logic intr_state_es_fatal_err_wd;
  logic intr_state_es_fatal_err_we;
  logic intr_enable_es_entropy_valid_qs;
  logic intr_enable_es_entropy_valid_wd;
  logic intr_enable_es_entropy_valid_we;
  logic intr_enable_es_health_test_failed_qs;
  logic intr_enable_es_health_test_failed_wd;
  logic intr_enable_es_health_test_failed_we;
  logic intr_enable_es_fatal_err_qs;
  logic intr_enable_es_fatal_err_wd;
  logic intr_enable_es_fatal_err_we;
  logic intr_test_es_entropy_valid_wd;
  logic intr_test_es_entropy_valid_we;
  logic intr_test_es_health_test_failed_wd;
  logic intr_test_es_health_test_failed_we;
  logic intr_test_es_fatal_err_wd;
  logic intr_test_es_fatal_err_we;
  logic alert_test_recov_alert_wd;
  logic alert_test_recov_alert_we;
  logic alert_test_fatal_alert_wd;
  logic alert_test_fatal_alert_we;
  logic regwen_qs;
  logic regwen_wd;
  logic regwen_we;
  logic [7:0] rev_abi_revision_qs;
  logic [7:0] rev_hw_revision_qs;
  logic [7:0] rev_chip_type_qs;
  logic [1:0] conf_enable_qs;
  logic [1:0] conf_enable_wd;
  logic conf_enable_we;
  logic conf_boot_bypass_disable_qs;
  logic conf_boot_bypass_disable_wd;
  logic conf_boot_bypass_disable_we;
  logic conf_repcnt_disable_qs;
  logic conf_repcnt_disable_wd;
  logic conf_repcnt_disable_we;
  logic conf_adaptp_disable_qs;
  logic conf_adaptp_disable_wd;
  logic conf_adaptp_disable_we;
  logic conf_bucket_disable_qs;
  logic conf_bucket_disable_wd;
  logic conf_bucket_disable_we;
  logic conf_markov_disable_qs;
  logic conf_markov_disable_wd;
  logic conf_markov_disable_we;
  logic conf_health_test_clr_qs;
  logic conf_health_test_clr_wd;
  logic conf_health_test_clr_we;
  logic conf_rng_bit_en_qs;
  logic conf_rng_bit_en_wd;
  logic conf_rng_bit_en_we;
  logic [1:0] conf_rng_bit_sel_qs;
  logic [1:0] conf_rng_bit_sel_wd;
  logic conf_rng_bit_sel_we;
  logic conf_extht_enable_qs;
  logic conf_extht_enable_wd;
  logic conf_extht_enable_we;
  logic [15:0] rate_qs;
  logic [15:0] rate_wd;
  logic rate_we;
  logic entropy_control_es_route_qs;
  logic entropy_control_es_route_wd;
  logic entropy_control_es_route_we;
  logic entropy_control_es_type_qs;
  logic entropy_control_es_type_wd;
  logic entropy_control_es_type_we;
  logic [31:0] entropy_data_qs;
  logic entropy_data_re;
  logic [15:0] health_test_windows_fips_window_qs;
  logic [15:0] health_test_windows_fips_window_wd;
  logic health_test_windows_fips_window_we;
  logic [15:0] health_test_windows_bypass_window_qs;
  logic [15:0] health_test_windows_bypass_window_wd;
  logic health_test_windows_bypass_window_we;
  logic [15:0] repcnt_thresholds_fips_thresh_qs;
  logic [15:0] repcnt_thresholds_fips_thresh_wd;
  logic repcnt_thresholds_fips_thresh_we;
  logic repcnt_thresholds_fips_thresh_re;
  logic [15:0] repcnt_thresholds_bypass_thresh_qs;
  logic [15:0] repcnt_thresholds_bypass_thresh_wd;
  logic repcnt_thresholds_bypass_thresh_we;
  logic repcnt_thresholds_bypass_thresh_re;
  logic [15:0] adaptp_hi_thresholds_fips_thresh_qs;
  logic [15:0] adaptp_hi_thresholds_fips_thresh_wd;
  logic adaptp_hi_thresholds_fips_thresh_we;
  logic adaptp_hi_thresholds_fips_thresh_re;
  logic [15:0] adaptp_hi_thresholds_bypass_thresh_qs;
  logic [15:0] adaptp_hi_thresholds_bypass_thresh_wd;
  logic adaptp_hi_thresholds_bypass_thresh_we;
  logic adaptp_hi_thresholds_bypass_thresh_re;
  logic [15:0] adaptp_lo_thresholds_fips_thresh_qs;
  logic [15:0] adaptp_lo_thresholds_fips_thresh_wd;
  logic adaptp_lo_thresholds_fips_thresh_we;
  logic adaptp_lo_thresholds_fips_thresh_re;
  logic [15:0] adaptp_lo_thresholds_bypass_thresh_qs;
  logic [15:0] adaptp_lo_thresholds_bypass_thresh_wd;
  logic adaptp_lo_thresholds_bypass_thresh_we;
  logic adaptp_lo_thresholds_bypass_thresh_re;
  logic [15:0] bucket_thresholds_fips_thresh_qs;
  logic [15:0] bucket_thresholds_fips_thresh_wd;
  logic bucket_thresholds_fips_thresh_we;
  logic bucket_thresholds_fips_thresh_re;
  logic [15:0] bucket_thresholds_bypass_thresh_qs;
  logic [15:0] bucket_thresholds_bypass_thresh_wd;
  logic bucket_thresholds_bypass_thresh_we;
  logic bucket_thresholds_bypass_thresh_re;
  logic [15:0] markov_hi_thresholds_fips_thresh_qs;
  logic [15:0] markov_hi_thresholds_fips_thresh_wd;
  logic markov_hi_thresholds_fips_thresh_we;
  logic markov_hi_thresholds_fips_thresh_re;
  logic [15:0] markov_hi_thresholds_bypass_thresh_qs;
  logic [15:0] markov_hi_thresholds_bypass_thresh_wd;
  logic markov_hi_thresholds_bypass_thresh_we;
  logic markov_hi_thresholds_bypass_thresh_re;
  logic [15:0] markov_lo_thresholds_fips_thresh_qs;
  logic [15:0] markov_lo_thresholds_fips_thresh_wd;
  logic markov_lo_thresholds_fips_thresh_we;
  logic markov_lo_thresholds_fips_thresh_re;
  logic [15:0] markov_lo_thresholds_bypass_thresh_qs;
  logic [15:0] markov_lo_thresholds_bypass_thresh_wd;
  logic markov_lo_thresholds_bypass_thresh_we;
  logic markov_lo_thresholds_bypass_thresh_re;
  logic [15:0] extht_hi_thresholds_fips_thresh_qs;
  logic [15:0] extht_hi_thresholds_fips_thresh_wd;
  logic extht_hi_thresholds_fips_thresh_we;
  logic extht_hi_thresholds_fips_thresh_re;
  logic [15:0] extht_hi_thresholds_bypass_thresh_qs;
  logic [15:0] extht_hi_thresholds_bypass_thresh_wd;
  logic extht_hi_thresholds_bypass_thresh_we;
  logic extht_hi_thresholds_bypass_thresh_re;
  logic [15:0] extht_lo_thresholds_fips_thresh_qs;
  logic [15:0] extht_lo_thresholds_fips_thresh_wd;
  logic extht_lo_thresholds_fips_thresh_we;
  logic extht_lo_thresholds_fips_thresh_re;
  logic [15:0] extht_lo_thresholds_bypass_thresh_qs;
  logic [15:0] extht_lo_thresholds_bypass_thresh_wd;
  logic extht_lo_thresholds_bypass_thresh_we;
  logic extht_lo_thresholds_bypass_thresh_re;
  logic [15:0] repcnt_hi_watermarks_fips_watermark_qs;
  logic repcnt_hi_watermarks_fips_watermark_re;
  logic [15:0] repcnt_hi_watermarks_bypass_watermark_qs;
  logic repcnt_hi_watermarks_bypass_watermark_re;
  logic [15:0] adaptp_hi_watermarks_fips_watermark_qs;
  logic adaptp_hi_watermarks_fips_watermark_re;
  logic [15:0] adaptp_hi_watermarks_bypass_watermark_qs;
  logic adaptp_hi_watermarks_bypass_watermark_re;
  logic [15:0] adaptp_lo_watermarks_fips_watermark_qs;
  logic adaptp_lo_watermarks_fips_watermark_re;
  logic [15:0] adaptp_lo_watermarks_bypass_watermark_qs;
  logic adaptp_lo_watermarks_bypass_watermark_re;
  logic [15:0] extht_hi_watermarks_fips_watermark_qs;
  logic extht_hi_watermarks_fips_watermark_re;
  logic [15:0] extht_hi_watermarks_bypass_watermark_qs;
  logic extht_hi_watermarks_bypass_watermark_re;
  logic [15:0] extht_lo_watermarks_fips_watermark_qs;
  logic extht_lo_watermarks_fips_watermark_re;
  logic [15:0] extht_lo_watermarks_bypass_watermark_qs;
  logic extht_lo_watermarks_bypass_watermark_re;
  logic [15:0] bucket_hi_watermarks_fips_watermark_qs;
  logic bucket_hi_watermarks_fips_watermark_re;
  logic [15:0] bucket_hi_watermarks_bypass_watermark_qs;
  logic bucket_hi_watermarks_bypass_watermark_re;
  logic [15:0] markov_hi_watermarks_fips_watermark_qs;
  logic markov_hi_watermarks_fips_watermark_re;
  logic [15:0] markov_hi_watermarks_bypass_watermark_qs;
  logic markov_hi_watermarks_bypass_watermark_re;
  logic [15:0] markov_lo_watermarks_fips_watermark_qs;
  logic markov_lo_watermarks_fips_watermark_re;
  logic [15:0] markov_lo_watermarks_bypass_watermark_qs;
  logic markov_lo_watermarks_bypass_watermark_re;
  logic [31:0] repcnt_total_fails_qs;
  logic repcnt_total_fails_re;
  logic [31:0] adaptp_hi_total_fails_qs;
  logic adaptp_hi_total_fails_re;
  logic [31:0] adaptp_lo_total_fails_qs;
  logic adaptp_lo_total_fails_re;
  logic [31:0] bucket_total_fails_qs;
  logic bucket_total_fails_re;
  logic [31:0] markov_hi_total_fails_qs;
  logic markov_hi_total_fails_re;
  logic [31:0] markov_lo_total_fails_qs;
  logic markov_lo_total_fails_re;
  logic [31:0] extht_hi_total_fails_qs;
  logic extht_hi_total_fails_re;
  logic [31:0] extht_lo_total_fails_qs;
  logic extht_lo_total_fails_re;
  logic [3:0] alert_threshold_qs;
  logic [3:0] alert_threshold_wd;
  logic alert_threshold_we;
  logic [3:0] alert_fail_counts_any_fail_count_qs;
  logic alert_fail_counts_any_fail_count_re;
  logic [3:0] alert_fail_counts_repcnt_fail_count_qs;
  logic alert_fail_counts_repcnt_fail_count_re;
  logic [3:0] alert_fail_counts_adaptp_hi_fail_count_qs;
  logic alert_fail_counts_adaptp_hi_fail_count_re;
  logic [3:0] alert_fail_counts_adaptp_lo_fail_count_qs;
  logic alert_fail_counts_adaptp_lo_fail_count_re;
  logic [3:0] alert_fail_counts_bucket_fail_count_qs;
  logic alert_fail_counts_bucket_fail_count_re;
  logic [3:0] alert_fail_counts_markov_hi_fail_count_qs;
  logic alert_fail_counts_markov_hi_fail_count_re;
  logic [3:0] alert_fail_counts_markov_lo_fail_count_qs;
  logic alert_fail_counts_markov_lo_fail_count_re;
  logic [3:0] extht_fail_counts_extht_hi_fail_count_qs;
  logic extht_fail_counts_extht_hi_fail_count_re;
  logic [3:0] extht_fail_counts_extht_lo_fail_count_qs;
  logic extht_fail_counts_extht_lo_fail_count_re;
  logic fw_ov_control_fw_ov_mode_qs;
  logic fw_ov_control_fw_ov_mode_wd;
  logic fw_ov_control_fw_ov_mode_we;
  logic fw_ov_control_fw_ov_fifo_reg_rd_qs;
  logic fw_ov_control_fw_ov_fifo_reg_rd_wd;
  logic fw_ov_control_fw_ov_fifo_reg_rd_we;
  logic fw_ov_control_fw_ov_fifo_reg_wr_qs;
  logic fw_ov_control_fw_ov_fifo_reg_wr_wd;
  logic fw_ov_control_fw_ov_fifo_reg_wr_we;
  logic [31:0] fw_ov_rd_data_qs;
  logic fw_ov_rd_data_re;
  logic [31:0] fw_ov_wr_data_wd;
  logic fw_ov_wr_data_we;
  logic [6:0] fw_ov_fifo_sts_qs;
  logic fw_ov_fifo_sts_re;
  logic [6:0] pre_cond_fifo_depth_qs;
  logic [6:0] pre_cond_fifo_depth_wd;
  logic pre_cond_fifo_depth_we;
  logic [2:0] debug_status_entropy_fifo_depth_qs;
  logic debug_status_entropy_fifo_depth_re;
  logic debug_status_diag_qs;
  logic debug_status_diag_re;
  logic [3:0] seed_qs;
  logic [3:0] seed_wd;
  logic seed_we;
  logic err_code_sfifo_esrng_err_qs;
  logic err_code_sfifo_precon_err_qs;
  logic err_code_sfifo_esfinal_err_qs;
  logic err_code_es_ack_sm_err_qs;
  logic err_code_es_main_sm_err_qs;
  logic err_code_fifo_write_err_qs;
  logic err_code_fifo_read_err_qs;
  logic err_code_fifo_state_err_qs;
  logic [4:0] err_code_test_qs;
  logic [4:0] err_code_test_wd;
  logic err_code_test_we;

  // Register instances
  // R[intr_state]: V(False)

  //   F[es_entropy_valid]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_es_entropy_valid (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_es_entropy_valid_we),
    .wd     (intr_state_es_entropy_valid_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.es_entropy_valid.de),
    .d      (hw2reg.intr_state.es_entropy_valid.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.es_entropy_valid.q ),

    // to register interface (read)
    .qs     (intr_state_es_entropy_valid_qs)
  );


  //   F[es_health_test_failed]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_es_health_test_failed (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_es_health_test_failed_we),
    .wd     (intr_state_es_health_test_failed_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.es_health_test_failed.de),
    .d      (hw2reg.intr_state.es_health_test_failed.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.es_health_test_failed.q ),

    // to register interface (read)
    .qs     (intr_state_es_health_test_failed_qs)
  );


  //   F[es_fatal_err]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_es_fatal_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_es_fatal_err_we),
    .wd     (intr_state_es_fatal_err_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.es_fatal_err.de),
    .d      (hw2reg.intr_state.es_fatal_err.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.es_fatal_err.q ),

    // to register interface (read)
    .qs     (intr_state_es_fatal_err_qs)
  );


  // R[intr_enable]: V(False)

  //   F[es_entropy_valid]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_es_entropy_valid (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_es_entropy_valid_we),
    .wd     (intr_enable_es_entropy_valid_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.es_entropy_valid.q ),

    // to register interface (read)
    .qs     (intr_enable_es_entropy_valid_qs)
  );


  //   F[es_health_test_failed]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_es_health_test_failed (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_es_health_test_failed_we),
    .wd     (intr_enable_es_health_test_failed_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.es_health_test_failed.q ),

    // to register interface (read)
    .qs     (intr_enable_es_health_test_failed_qs)
  );


  //   F[es_fatal_err]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_es_fatal_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_es_fatal_err_we),
    .wd     (intr_enable_es_fatal_err_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.es_fatal_err.q ),

    // to register interface (read)
    .qs     (intr_enable_es_fatal_err_qs)
  );


  // R[intr_test]: V(True)

  //   F[es_entropy_valid]: 0:0
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_es_entropy_valid (
    .re     (1'b0),
    .we     (intr_test_es_entropy_valid_we),
    .wd     (intr_test_es_entropy_valid_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.es_entropy_valid.qe),
    .q      (reg2hw.intr_test.es_entropy_valid.q ),
    .qs     ()
  );


  //   F[es_health_test_failed]: 1:1
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_es_health_test_failed (
    .re     (1'b0),
    .we     (intr_test_es_health_test_failed_we),
    .wd     (intr_test_es_health_test_failed_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.es_health_test_failed.qe),
    .q      (reg2hw.intr_test.es_health_test_failed.q ),
    .qs     ()
  );


  //   F[es_fatal_err]: 2:2
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_es_fatal_err (
    .re     (1'b0),
    .we     (intr_test_es_fatal_err_we),
    .wd     (intr_test_es_fatal_err_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.es_fatal_err.qe),
    .q      (reg2hw.intr_test.es_fatal_err.q ),
    .qs     ()
  );


  // R[alert_test]: V(True)

  //   F[recov_alert]: 0:0
  prim_subreg_ext #(
    .DW    (1)
  ) u_alert_test_recov_alert (
    .re     (1'b0),
    .we     (alert_test_recov_alert_we),
    .wd     (alert_test_recov_alert_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.alert_test.recov_alert.qe),
    .q      (reg2hw.alert_test.recov_alert.q ),
    .qs     ()
  );


  //   F[fatal_alert]: 1:1
  prim_subreg_ext #(
    .DW    (1)
  ) u_alert_test_fatal_alert (
    .re     (1'b0),
    .we     (alert_test_fatal_alert_we),
    .wd     (alert_test_fatal_alert_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.alert_test.fatal_alert.qe),
    .q      (reg2hw.alert_test.fatal_alert.q ),
    .qs     ()
  );


  // R[regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (regwen_we),
    .wd     (regwen_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.regwen.q ),

    // to register interface (read)
    .qs     (regwen_qs)
  );


  // R[rev]: V(False)

  //   F[abi_revision]: 7:0
  // constant-only read
  assign rev_abi_revision_qs = 8'h3;


  //   F[hw_revision]: 15:8
  // constant-only read
  assign rev_hw_revision_qs = 8'h3;


  //   F[chip_type]: 23:16
  // constant-only read
  assign rev_chip_type_qs = 8'h1;


  // R[conf]: V(False)

  //   F[enable]: 1:0
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_conf_enable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (conf_enable_we & regwen_qs),
    .wd     (conf_enable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.conf.enable.q ),

    // to register interface (read)
    .qs     (conf_enable_qs)
  );


  //   F[boot_bypass_disable]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_conf_boot_bypass_disable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (conf_boot_bypass_disable_we & regwen_qs),
    .wd     (conf_boot_bypass_disable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.conf.boot_bypass_disable.q ),

    // to register interface (read)
    .qs     (conf_boot_bypass_disable_qs)
  );


  //   F[repcnt_disable]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_conf_repcnt_disable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (conf_repcnt_disable_we & regwen_qs),
    .wd     (conf_repcnt_disable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.conf.repcnt_disable.q ),

    // to register interface (read)
    .qs     (conf_repcnt_disable_qs)
  );


  //   F[adaptp_disable]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_conf_adaptp_disable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (conf_adaptp_disable_we & regwen_qs),
    .wd     (conf_adaptp_disable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.conf.adaptp_disable.q ),

    // to register interface (read)
    .qs     (conf_adaptp_disable_qs)
  );


  //   F[bucket_disable]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_conf_bucket_disable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (conf_bucket_disable_we & regwen_qs),
    .wd     (conf_bucket_disable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.conf.bucket_disable.q ),

    // to register interface (read)
    .qs     (conf_bucket_disable_qs)
  );


  //   F[markov_disable]: 7:7
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_conf_markov_disable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (conf_markov_disable_we & regwen_qs),
    .wd     (conf_markov_disable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.conf.markov_disable.q ),

    // to register interface (read)
    .qs     (conf_markov_disable_qs)
  );


  //   F[health_test_clr]: 8:8
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_conf_health_test_clr (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (conf_health_test_clr_we & regwen_qs),
    .wd     (conf_health_test_clr_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.conf.health_test_clr.q ),

    // to register interface (read)
    .qs     (conf_health_test_clr_qs)
  );


  //   F[rng_bit_en]: 9:9
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_conf_rng_bit_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (conf_rng_bit_en_we & regwen_qs),
    .wd     (conf_rng_bit_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.conf.rng_bit_en.q ),

    // to register interface (read)
    .qs     (conf_rng_bit_en_qs)
  );


  //   F[rng_bit_sel]: 11:10
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_conf_rng_bit_sel (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (conf_rng_bit_sel_we & regwen_qs),
    .wd     (conf_rng_bit_sel_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.conf.rng_bit_sel.q ),

    // to register interface (read)
    .qs     (conf_rng_bit_sel_qs)
  );


  //   F[extht_enable]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_conf_extht_enable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (conf_extht_enable_we & regwen_qs),
    .wd     (conf_extht_enable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.conf.extht_enable.q ),

    // to register interface (read)
    .qs     (conf_extht_enable_qs)
  );


  // R[rate]: V(False)

  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h8)
  ) u_rate (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (rate_we),
    .wd     (rate_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.rate.q ),

    // to register interface (read)
    .qs     (rate_qs)
  );


  // R[entropy_control]: V(False)

  //   F[es_route]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_entropy_control_es_route (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (entropy_control_es_route_we & regwen_qs),
    .wd     (entropy_control_es_route_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.entropy_control.es_route.q ),

    // to register interface (read)
    .qs     (entropy_control_es_route_qs)
  );


  //   F[es_type]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_entropy_control_es_type (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (entropy_control_es_type_we & regwen_qs),
    .wd     (entropy_control_es_type_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.entropy_control.es_type.q ),

    // to register interface (read)
    .qs     (entropy_control_es_type_qs)
  );


  // R[entropy_data]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_entropy_data (
    .re     (entropy_data_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.entropy_data.d),
    .qre    (reg2hw.entropy_data.re),
    .qe     (),
    .q      (reg2hw.entropy_data.q ),
    .qs     (entropy_data_qs)
  );


  // R[health_test_windows]: V(False)

  //   F[fips_window]: 15:0
  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h100)
  ) u_health_test_windows_fips_window (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (health_test_windows_fips_window_we & regwen_qs),
    .wd     (health_test_windows_fips_window_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.health_test_windows.fips_window.q ),

    // to register interface (read)
    .qs     (health_test_windows_fips_window_qs)
  );


  //   F[bypass_window]: 31:16
  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h60)
  ) u_health_test_windows_bypass_window (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (health_test_windows_bypass_window_we & regwen_qs),
    .wd     (health_test_windows_bypass_window_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.health_test_windows.bypass_window.q ),

    // to register interface (read)
    .qs     (health_test_windows_bypass_window_qs)
  );


  // R[repcnt_thresholds]: V(True)

  //   F[fips_thresh]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_repcnt_thresholds_fips_thresh (
    .re     (repcnt_thresholds_fips_thresh_re),
    // qualified with register enable
    .we     (repcnt_thresholds_fips_thresh_we & regwen_qs),
    .wd     (repcnt_thresholds_fips_thresh_wd),
    .d      (hw2reg.repcnt_thresholds.fips_thresh.d),
    .qre    (),
    .qe     (reg2hw.repcnt_thresholds.fips_thresh.qe),
    .q      (reg2hw.repcnt_thresholds.fips_thresh.q ),
    .qs     (repcnt_thresholds_fips_thresh_qs)
  );


  //   F[bypass_thresh]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_repcnt_thresholds_bypass_thresh (
    .re     (repcnt_thresholds_bypass_thresh_re),
    // qualified with register enable
    .we     (repcnt_thresholds_bypass_thresh_we & regwen_qs),
    .wd     (repcnt_thresholds_bypass_thresh_wd),
    .d      (hw2reg.repcnt_thresholds.bypass_thresh.d),
    .qre    (),
    .qe     (reg2hw.repcnt_thresholds.bypass_thresh.qe),
    .q      (reg2hw.repcnt_thresholds.bypass_thresh.q ),
    .qs     (repcnt_thresholds_bypass_thresh_qs)
  );


  // R[adaptp_hi_thresholds]: V(True)

  //   F[fips_thresh]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_adaptp_hi_thresholds_fips_thresh (
    .re     (adaptp_hi_thresholds_fips_thresh_re),
    // qualified with register enable
    .we     (adaptp_hi_thresholds_fips_thresh_we & regwen_qs),
    .wd     (adaptp_hi_thresholds_fips_thresh_wd),
    .d      (hw2reg.adaptp_hi_thresholds.fips_thresh.d),
    .qre    (),
    .qe     (reg2hw.adaptp_hi_thresholds.fips_thresh.qe),
    .q      (reg2hw.adaptp_hi_thresholds.fips_thresh.q ),
    .qs     (adaptp_hi_thresholds_fips_thresh_qs)
  );


  //   F[bypass_thresh]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_adaptp_hi_thresholds_bypass_thresh (
    .re     (adaptp_hi_thresholds_bypass_thresh_re),
    // qualified with register enable
    .we     (adaptp_hi_thresholds_bypass_thresh_we & regwen_qs),
    .wd     (adaptp_hi_thresholds_bypass_thresh_wd),
    .d      (hw2reg.adaptp_hi_thresholds.bypass_thresh.d),
    .qre    (),
    .qe     (reg2hw.adaptp_hi_thresholds.bypass_thresh.qe),
    .q      (reg2hw.adaptp_hi_thresholds.bypass_thresh.q ),
    .qs     (adaptp_hi_thresholds_bypass_thresh_qs)
  );


  // R[adaptp_lo_thresholds]: V(True)

  //   F[fips_thresh]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_adaptp_lo_thresholds_fips_thresh (
    .re     (adaptp_lo_thresholds_fips_thresh_re),
    // qualified with register enable
    .we     (adaptp_lo_thresholds_fips_thresh_we & regwen_qs),
    .wd     (adaptp_lo_thresholds_fips_thresh_wd),
    .d      (hw2reg.adaptp_lo_thresholds.fips_thresh.d),
    .qre    (),
    .qe     (reg2hw.adaptp_lo_thresholds.fips_thresh.qe),
    .q      (reg2hw.adaptp_lo_thresholds.fips_thresh.q ),
    .qs     (adaptp_lo_thresholds_fips_thresh_qs)
  );


  //   F[bypass_thresh]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_adaptp_lo_thresholds_bypass_thresh (
    .re     (adaptp_lo_thresholds_bypass_thresh_re),
    // qualified with register enable
    .we     (adaptp_lo_thresholds_bypass_thresh_we & regwen_qs),
    .wd     (adaptp_lo_thresholds_bypass_thresh_wd),
    .d      (hw2reg.adaptp_lo_thresholds.bypass_thresh.d),
    .qre    (),
    .qe     (reg2hw.adaptp_lo_thresholds.bypass_thresh.qe),
    .q      (reg2hw.adaptp_lo_thresholds.bypass_thresh.q ),
    .qs     (adaptp_lo_thresholds_bypass_thresh_qs)
  );


  // R[bucket_thresholds]: V(True)

  //   F[fips_thresh]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_bucket_thresholds_fips_thresh (
    .re     (bucket_thresholds_fips_thresh_re),
    // qualified with register enable
    .we     (bucket_thresholds_fips_thresh_we & regwen_qs),
    .wd     (bucket_thresholds_fips_thresh_wd),
    .d      (hw2reg.bucket_thresholds.fips_thresh.d),
    .qre    (),
    .qe     (reg2hw.bucket_thresholds.fips_thresh.qe),
    .q      (reg2hw.bucket_thresholds.fips_thresh.q ),
    .qs     (bucket_thresholds_fips_thresh_qs)
  );


  //   F[bypass_thresh]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_bucket_thresholds_bypass_thresh (
    .re     (bucket_thresholds_bypass_thresh_re),
    // qualified with register enable
    .we     (bucket_thresholds_bypass_thresh_we & regwen_qs),
    .wd     (bucket_thresholds_bypass_thresh_wd),
    .d      (hw2reg.bucket_thresholds.bypass_thresh.d),
    .qre    (),
    .qe     (reg2hw.bucket_thresholds.bypass_thresh.qe),
    .q      (reg2hw.bucket_thresholds.bypass_thresh.q ),
    .qs     (bucket_thresholds_bypass_thresh_qs)
  );


  // R[markov_hi_thresholds]: V(True)

  //   F[fips_thresh]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_markov_hi_thresholds_fips_thresh (
    .re     (markov_hi_thresholds_fips_thresh_re),
    // qualified with register enable
    .we     (markov_hi_thresholds_fips_thresh_we & regwen_qs),
    .wd     (markov_hi_thresholds_fips_thresh_wd),
    .d      (hw2reg.markov_hi_thresholds.fips_thresh.d),
    .qre    (),
    .qe     (reg2hw.markov_hi_thresholds.fips_thresh.qe),
    .q      (reg2hw.markov_hi_thresholds.fips_thresh.q ),
    .qs     (markov_hi_thresholds_fips_thresh_qs)
  );


  //   F[bypass_thresh]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_markov_hi_thresholds_bypass_thresh (
    .re     (markov_hi_thresholds_bypass_thresh_re),
    // qualified with register enable
    .we     (markov_hi_thresholds_bypass_thresh_we & regwen_qs),
    .wd     (markov_hi_thresholds_bypass_thresh_wd),
    .d      (hw2reg.markov_hi_thresholds.bypass_thresh.d),
    .qre    (),
    .qe     (reg2hw.markov_hi_thresholds.bypass_thresh.qe),
    .q      (reg2hw.markov_hi_thresholds.bypass_thresh.q ),
    .qs     (markov_hi_thresholds_bypass_thresh_qs)
  );


  // R[markov_lo_thresholds]: V(True)

  //   F[fips_thresh]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_markov_lo_thresholds_fips_thresh (
    .re     (markov_lo_thresholds_fips_thresh_re),
    // qualified with register enable
    .we     (markov_lo_thresholds_fips_thresh_we & regwen_qs),
    .wd     (markov_lo_thresholds_fips_thresh_wd),
    .d      (hw2reg.markov_lo_thresholds.fips_thresh.d),
    .qre    (),
    .qe     (reg2hw.markov_lo_thresholds.fips_thresh.qe),
    .q      (reg2hw.markov_lo_thresholds.fips_thresh.q ),
    .qs     (markov_lo_thresholds_fips_thresh_qs)
  );


  //   F[bypass_thresh]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_markov_lo_thresholds_bypass_thresh (
    .re     (markov_lo_thresholds_bypass_thresh_re),
    // qualified with register enable
    .we     (markov_lo_thresholds_bypass_thresh_we & regwen_qs),
    .wd     (markov_lo_thresholds_bypass_thresh_wd),
    .d      (hw2reg.markov_lo_thresholds.bypass_thresh.d),
    .qre    (),
    .qe     (reg2hw.markov_lo_thresholds.bypass_thresh.qe),
    .q      (reg2hw.markov_lo_thresholds.bypass_thresh.q ),
    .qs     (markov_lo_thresholds_bypass_thresh_qs)
  );


  // R[extht_hi_thresholds]: V(True)

  //   F[fips_thresh]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_extht_hi_thresholds_fips_thresh (
    .re     (extht_hi_thresholds_fips_thresh_re),
    // qualified with register enable
    .we     (extht_hi_thresholds_fips_thresh_we & regwen_qs),
    .wd     (extht_hi_thresholds_fips_thresh_wd),
    .d      (hw2reg.extht_hi_thresholds.fips_thresh.d),
    .qre    (),
    .qe     (reg2hw.extht_hi_thresholds.fips_thresh.qe),
    .q      (reg2hw.extht_hi_thresholds.fips_thresh.q ),
    .qs     (extht_hi_thresholds_fips_thresh_qs)
  );


  //   F[bypass_thresh]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_extht_hi_thresholds_bypass_thresh (
    .re     (extht_hi_thresholds_bypass_thresh_re),
    // qualified with register enable
    .we     (extht_hi_thresholds_bypass_thresh_we & regwen_qs),
    .wd     (extht_hi_thresholds_bypass_thresh_wd),
    .d      (hw2reg.extht_hi_thresholds.bypass_thresh.d),
    .qre    (),
    .qe     (reg2hw.extht_hi_thresholds.bypass_thresh.qe),
    .q      (reg2hw.extht_hi_thresholds.bypass_thresh.q ),
    .qs     (extht_hi_thresholds_bypass_thresh_qs)
  );


  // R[extht_lo_thresholds]: V(True)

  //   F[fips_thresh]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_extht_lo_thresholds_fips_thresh (
    .re     (extht_lo_thresholds_fips_thresh_re),
    // qualified with register enable
    .we     (extht_lo_thresholds_fips_thresh_we & regwen_qs),
    .wd     (extht_lo_thresholds_fips_thresh_wd),
    .d      (hw2reg.extht_lo_thresholds.fips_thresh.d),
    .qre    (),
    .qe     (reg2hw.extht_lo_thresholds.fips_thresh.qe),
    .q      (reg2hw.extht_lo_thresholds.fips_thresh.q ),
    .qs     (extht_lo_thresholds_fips_thresh_qs)
  );


  //   F[bypass_thresh]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_extht_lo_thresholds_bypass_thresh (
    .re     (extht_lo_thresholds_bypass_thresh_re),
    // qualified with register enable
    .we     (extht_lo_thresholds_bypass_thresh_we & regwen_qs),
    .wd     (extht_lo_thresholds_bypass_thresh_wd),
    .d      (hw2reg.extht_lo_thresholds.bypass_thresh.d),
    .qre    (),
    .qe     (reg2hw.extht_lo_thresholds.bypass_thresh.qe),
    .q      (reg2hw.extht_lo_thresholds.bypass_thresh.q ),
    .qs     (extht_lo_thresholds_bypass_thresh_qs)
  );


  // R[repcnt_hi_watermarks]: V(True)

  //   F[fips_watermark]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_repcnt_hi_watermarks_fips_watermark (
    .re     (repcnt_hi_watermarks_fips_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.repcnt_hi_watermarks.fips_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (repcnt_hi_watermarks_fips_watermark_qs)
  );


  //   F[bypass_watermark]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_repcnt_hi_watermarks_bypass_watermark (
    .re     (repcnt_hi_watermarks_bypass_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.repcnt_hi_watermarks.bypass_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (repcnt_hi_watermarks_bypass_watermark_qs)
  );


  // R[adaptp_hi_watermarks]: V(True)

  //   F[fips_watermark]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_adaptp_hi_watermarks_fips_watermark (
    .re     (adaptp_hi_watermarks_fips_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.adaptp_hi_watermarks.fips_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (adaptp_hi_watermarks_fips_watermark_qs)
  );


  //   F[bypass_watermark]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_adaptp_hi_watermarks_bypass_watermark (
    .re     (adaptp_hi_watermarks_bypass_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.adaptp_hi_watermarks.bypass_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (adaptp_hi_watermarks_bypass_watermark_qs)
  );


  // R[adaptp_lo_watermarks]: V(True)

  //   F[fips_watermark]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_adaptp_lo_watermarks_fips_watermark (
    .re     (adaptp_lo_watermarks_fips_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.adaptp_lo_watermarks.fips_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (adaptp_lo_watermarks_fips_watermark_qs)
  );


  //   F[bypass_watermark]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_adaptp_lo_watermarks_bypass_watermark (
    .re     (adaptp_lo_watermarks_bypass_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.adaptp_lo_watermarks.bypass_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (adaptp_lo_watermarks_bypass_watermark_qs)
  );


  // R[extht_hi_watermarks]: V(True)

  //   F[fips_watermark]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_extht_hi_watermarks_fips_watermark (
    .re     (extht_hi_watermarks_fips_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.extht_hi_watermarks.fips_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (extht_hi_watermarks_fips_watermark_qs)
  );


  //   F[bypass_watermark]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_extht_hi_watermarks_bypass_watermark (
    .re     (extht_hi_watermarks_bypass_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.extht_hi_watermarks.bypass_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (extht_hi_watermarks_bypass_watermark_qs)
  );


  // R[extht_lo_watermarks]: V(True)

  //   F[fips_watermark]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_extht_lo_watermarks_fips_watermark (
    .re     (extht_lo_watermarks_fips_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.extht_lo_watermarks.fips_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (extht_lo_watermarks_fips_watermark_qs)
  );


  //   F[bypass_watermark]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_extht_lo_watermarks_bypass_watermark (
    .re     (extht_lo_watermarks_bypass_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.extht_lo_watermarks.bypass_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (extht_lo_watermarks_bypass_watermark_qs)
  );


  // R[bucket_hi_watermarks]: V(True)

  //   F[fips_watermark]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_bucket_hi_watermarks_fips_watermark (
    .re     (bucket_hi_watermarks_fips_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.bucket_hi_watermarks.fips_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (bucket_hi_watermarks_fips_watermark_qs)
  );


  //   F[bypass_watermark]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_bucket_hi_watermarks_bypass_watermark (
    .re     (bucket_hi_watermarks_bypass_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.bucket_hi_watermarks.bypass_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (bucket_hi_watermarks_bypass_watermark_qs)
  );


  // R[markov_hi_watermarks]: V(True)

  //   F[fips_watermark]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_markov_hi_watermarks_fips_watermark (
    .re     (markov_hi_watermarks_fips_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.markov_hi_watermarks.fips_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (markov_hi_watermarks_fips_watermark_qs)
  );


  //   F[bypass_watermark]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_markov_hi_watermarks_bypass_watermark (
    .re     (markov_hi_watermarks_bypass_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.markov_hi_watermarks.bypass_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (markov_hi_watermarks_bypass_watermark_qs)
  );


  // R[markov_lo_watermarks]: V(True)

  //   F[fips_watermark]: 15:0
  prim_subreg_ext #(
    .DW    (16)
  ) u_markov_lo_watermarks_fips_watermark (
    .re     (markov_lo_watermarks_fips_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.markov_lo_watermarks.fips_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (markov_lo_watermarks_fips_watermark_qs)
  );


  //   F[bypass_watermark]: 31:16
  prim_subreg_ext #(
    .DW    (16)
  ) u_markov_lo_watermarks_bypass_watermark (
    .re     (markov_lo_watermarks_bypass_watermark_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.markov_lo_watermarks.bypass_watermark.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (markov_lo_watermarks_bypass_watermark_qs)
  );


  // R[repcnt_total_fails]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_repcnt_total_fails (
    .re     (repcnt_total_fails_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.repcnt_total_fails.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (repcnt_total_fails_qs)
  );


  // R[adaptp_hi_total_fails]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_adaptp_hi_total_fails (
    .re     (adaptp_hi_total_fails_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.adaptp_hi_total_fails.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (adaptp_hi_total_fails_qs)
  );


  // R[adaptp_lo_total_fails]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_adaptp_lo_total_fails (
    .re     (adaptp_lo_total_fails_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.adaptp_lo_total_fails.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (adaptp_lo_total_fails_qs)
  );


  // R[bucket_total_fails]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_bucket_total_fails (
    .re     (bucket_total_fails_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.bucket_total_fails.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (bucket_total_fails_qs)
  );


  // R[markov_hi_total_fails]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_markov_hi_total_fails (
    .re     (markov_hi_total_fails_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.markov_hi_total_fails.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (markov_hi_total_fails_qs)
  );


  // R[markov_lo_total_fails]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_markov_lo_total_fails (
    .re     (markov_lo_total_fails_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.markov_lo_total_fails.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (markov_lo_total_fails_qs)
  );


  // R[extht_hi_total_fails]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_extht_hi_total_fails (
    .re     (extht_hi_total_fails_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.extht_hi_total_fails.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (extht_hi_total_fails_qs)
  );


  // R[extht_lo_total_fails]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_extht_lo_total_fails (
    .re     (extht_lo_total_fails_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.extht_lo_total_fails.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (extht_lo_total_fails_qs)
  );


  // R[alert_threshold]: V(False)

  prim_subreg #(
    .DW      (4),
    .SWACCESS("RW"),
    .RESVAL  (4'h2)
  ) u_alert_threshold (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (alert_threshold_we & regwen_qs),
    .wd     (alert_threshold_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.alert_threshold.q ),

    // to register interface (read)
    .qs     (alert_threshold_qs)
  );


  // R[alert_fail_counts]: V(True)

  //   F[any_fail_count]: 3:0
  prim_subreg_ext #(
    .DW    (4)
  ) u_alert_fail_counts_any_fail_count (
    .re     (alert_fail_counts_any_fail_count_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.alert_fail_counts.any_fail_count.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (alert_fail_counts_any_fail_count_qs)
  );


  //   F[repcnt_fail_count]: 7:4
  prim_subreg_ext #(
    .DW    (4)
  ) u_alert_fail_counts_repcnt_fail_count (
    .re     (alert_fail_counts_repcnt_fail_count_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.alert_fail_counts.repcnt_fail_count.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (alert_fail_counts_repcnt_fail_count_qs)
  );


  //   F[adaptp_hi_fail_count]: 11:8
  prim_subreg_ext #(
    .DW    (4)
  ) u_alert_fail_counts_adaptp_hi_fail_count (
    .re     (alert_fail_counts_adaptp_hi_fail_count_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.alert_fail_counts.adaptp_hi_fail_count.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (alert_fail_counts_adaptp_hi_fail_count_qs)
  );


  //   F[adaptp_lo_fail_count]: 15:12
  prim_subreg_ext #(
    .DW    (4)
  ) u_alert_fail_counts_adaptp_lo_fail_count (
    .re     (alert_fail_counts_adaptp_lo_fail_count_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.alert_fail_counts.adaptp_lo_fail_count.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (alert_fail_counts_adaptp_lo_fail_count_qs)
  );


  //   F[bucket_fail_count]: 19:16
  prim_subreg_ext #(
    .DW    (4)
  ) u_alert_fail_counts_bucket_fail_count (
    .re     (alert_fail_counts_bucket_fail_count_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.alert_fail_counts.bucket_fail_count.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (alert_fail_counts_bucket_fail_count_qs)
  );


  //   F[markov_hi_fail_count]: 23:20
  prim_subreg_ext #(
    .DW    (4)
  ) u_alert_fail_counts_markov_hi_fail_count (
    .re     (alert_fail_counts_markov_hi_fail_count_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.alert_fail_counts.markov_hi_fail_count.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (alert_fail_counts_markov_hi_fail_count_qs)
  );


  //   F[markov_lo_fail_count]: 27:24
  prim_subreg_ext #(
    .DW    (4)
  ) u_alert_fail_counts_markov_lo_fail_count (
    .re     (alert_fail_counts_markov_lo_fail_count_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.alert_fail_counts.markov_lo_fail_count.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (alert_fail_counts_markov_lo_fail_count_qs)
  );


  // R[extht_fail_counts]: V(True)

  //   F[extht_hi_fail_count]: 3:0
  prim_subreg_ext #(
    .DW    (4)
  ) u_extht_fail_counts_extht_hi_fail_count (
    .re     (extht_fail_counts_extht_hi_fail_count_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.extht_fail_counts.extht_hi_fail_count.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (extht_fail_counts_extht_hi_fail_count_qs)
  );


  //   F[extht_lo_fail_count]: 7:4
  prim_subreg_ext #(
    .DW    (4)
  ) u_extht_fail_counts_extht_lo_fail_count (
    .re     (extht_fail_counts_extht_lo_fail_count_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.extht_fail_counts.extht_lo_fail_count.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (extht_fail_counts_extht_lo_fail_count_qs)
  );


  // R[fw_ov_control]: V(False)

  //   F[fw_ov_mode]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_fw_ov_control_fw_ov_mode (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (fw_ov_control_fw_ov_mode_we & regwen_qs),
    .wd     (fw_ov_control_fw_ov_mode_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.fw_ov_control.fw_ov_mode.q ),

    // to register interface (read)
    .qs     (fw_ov_control_fw_ov_mode_qs)
  );


  //   F[fw_ov_fifo_reg_rd]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_fw_ov_control_fw_ov_fifo_reg_rd (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (fw_ov_control_fw_ov_fifo_reg_rd_we & regwen_qs),
    .wd     (fw_ov_control_fw_ov_fifo_reg_rd_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.fw_ov_control.fw_ov_fifo_reg_rd.q ),

    // to register interface (read)
    .qs     (fw_ov_control_fw_ov_fifo_reg_rd_qs)
  );


  //   F[fw_ov_fifo_reg_wr]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_fw_ov_control_fw_ov_fifo_reg_wr (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (fw_ov_control_fw_ov_fifo_reg_wr_we & regwen_qs),
    .wd     (fw_ov_control_fw_ov_fifo_reg_wr_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.fw_ov_control.fw_ov_fifo_reg_wr.q ),

    // to register interface (read)
    .qs     (fw_ov_control_fw_ov_fifo_reg_wr_qs)
  );


  // R[fw_ov_rd_data]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_fw_ov_rd_data (
    .re     (fw_ov_rd_data_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.fw_ov_rd_data.d),
    .qre    (reg2hw.fw_ov_rd_data.re),
    .qe     (),
    .q      (reg2hw.fw_ov_rd_data.q ),
    .qs     (fw_ov_rd_data_qs)
  );


  // R[fw_ov_wr_data]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_fw_ov_wr_data (
    .re     (1'b0),
    .we     (fw_ov_wr_data_we),
    .wd     (fw_ov_wr_data_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.fw_ov_wr_data.qe),
    .q      (reg2hw.fw_ov_wr_data.q ),
    .qs     ()
  );


  // R[fw_ov_fifo_sts]: V(True)

  prim_subreg_ext #(
    .DW    (7)
  ) u_fw_ov_fifo_sts (
    .re     (fw_ov_fifo_sts_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.fw_ov_fifo_sts.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (fw_ov_fifo_sts_qs)
  );


  // R[pre_cond_fifo_depth]: V(False)

  prim_subreg #(
    .DW      (7),
    .SWACCESS("RW"),
    .RESVAL  (7'h40)
  ) u_pre_cond_fifo_depth (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (pre_cond_fifo_depth_we & regwen_qs),
    .wd     (pre_cond_fifo_depth_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.pre_cond_fifo_depth.q ),

    // to register interface (read)
    .qs     (pre_cond_fifo_depth_qs)
  );


  // R[debug_status]: V(True)

  //   F[entropy_fifo_depth]: 2:0
  prim_subreg_ext #(
    .DW    (3)
  ) u_debug_status_entropy_fifo_depth (
    .re     (debug_status_entropy_fifo_depth_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.debug_status.entropy_fifo_depth.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (debug_status_entropy_fifo_depth_qs)
  );


  //   F[diag]: 31:31
  prim_subreg_ext #(
    .DW    (1)
  ) u_debug_status_diag (
    .re     (debug_status_diag_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.debug_status.diag.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (debug_status_diag_qs)
  );


  // R[seed]: V(False)

  prim_subreg #(
    .DW      (4),
    .SWACCESS("RW"),
    .RESVAL  (4'hb)
  ) u_seed (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (seed_we & regwen_qs),
    .wd     (seed_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.seed.q ),

    // to register interface (read)
    .qs     (seed_qs)
  );


  // R[err_code]: V(False)

  //   F[sfifo_esrng_err]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_err_code_sfifo_esrng_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.err_code.sfifo_esrng_err.de),
    .d      (hw2reg.err_code.sfifo_esrng_err.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_sfifo_esrng_err_qs)
  );


  //   F[sfifo_precon_err]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_err_code_sfifo_precon_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.err_code.sfifo_precon_err.de),
    .d      (hw2reg.err_code.sfifo_precon_err.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_sfifo_precon_err_qs)
  );


  //   F[sfifo_esfinal_err]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_err_code_sfifo_esfinal_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.err_code.sfifo_esfinal_err.de),
    .d      (hw2reg.err_code.sfifo_esfinal_err.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_sfifo_esfinal_err_qs)
  );


  //   F[es_ack_sm_err]: 20:20
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_err_code_es_ack_sm_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.err_code.es_ack_sm_err.de),
    .d      (hw2reg.err_code.es_ack_sm_err.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_es_ack_sm_err_qs)
  );


  //   F[es_main_sm_err]: 21:21
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_err_code_es_main_sm_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.err_code.es_main_sm_err.de),
    .d      (hw2reg.err_code.es_main_sm_err.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_es_main_sm_err_qs)
  );


  //   F[fifo_write_err]: 28:28
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_err_code_fifo_write_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.err_code.fifo_write_err.de),
    .d      (hw2reg.err_code.fifo_write_err.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_fifo_write_err_qs)
  );


  //   F[fifo_read_err]: 29:29
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_err_code_fifo_read_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.err_code.fifo_read_err.de),
    .d      (hw2reg.err_code.fifo_read_err.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_fifo_read_err_qs)
  );


  //   F[fifo_state_err]: 30:30
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RO"),
    .RESVAL  (1'h0)
  ) u_err_code_fifo_state_err (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.err_code.fifo_state_err.de),
    .d      (hw2reg.err_code.fifo_state_err.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (err_code_fifo_state_err_qs)
  );


  // R[err_code_test]: V(False)

  prim_subreg #(
    .DW      (5),
    .SWACCESS("RW"),
    .RESVAL  (5'h0)
  ) u_err_code_test (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (err_code_test_we & regwen_qs),
    .wd     (err_code_test_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.err_code_test.qe),
    .q      (reg2hw.err_code_test.q ),

    // to register interface (read)
    .qs     (err_code_test_qs)
  );




  logic [46:0] addr_hit;
  always_comb begin
    addr_hit = '0;
    addr_hit[ 0] = (reg_addr == ENTROPY_SRC_INTR_STATE_OFFSET);
    addr_hit[ 1] = (reg_addr == ENTROPY_SRC_INTR_ENABLE_OFFSET);
    addr_hit[ 2] = (reg_addr == ENTROPY_SRC_INTR_TEST_OFFSET);
    addr_hit[ 3] = (reg_addr == ENTROPY_SRC_ALERT_TEST_OFFSET);
    addr_hit[ 4] = (reg_addr == ENTROPY_SRC_REGWEN_OFFSET);
    addr_hit[ 5] = (reg_addr == ENTROPY_SRC_REV_OFFSET);
    addr_hit[ 6] = (reg_addr == ENTROPY_SRC_CONF_OFFSET);
    addr_hit[ 7] = (reg_addr == ENTROPY_SRC_RATE_OFFSET);
    addr_hit[ 8] = (reg_addr == ENTROPY_SRC_ENTROPY_CONTROL_OFFSET);
    addr_hit[ 9] = (reg_addr == ENTROPY_SRC_ENTROPY_DATA_OFFSET);
    addr_hit[10] = (reg_addr == ENTROPY_SRC_HEALTH_TEST_WINDOWS_OFFSET);
    addr_hit[11] = (reg_addr == ENTROPY_SRC_REPCNT_THRESHOLDS_OFFSET);
    addr_hit[12] = (reg_addr == ENTROPY_SRC_ADAPTP_HI_THRESHOLDS_OFFSET);
    addr_hit[13] = (reg_addr == ENTROPY_SRC_ADAPTP_LO_THRESHOLDS_OFFSET);
    addr_hit[14] = (reg_addr == ENTROPY_SRC_BUCKET_THRESHOLDS_OFFSET);
    addr_hit[15] = (reg_addr == ENTROPY_SRC_MARKOV_HI_THRESHOLDS_OFFSET);
    addr_hit[16] = (reg_addr == ENTROPY_SRC_MARKOV_LO_THRESHOLDS_OFFSET);
    addr_hit[17] = (reg_addr == ENTROPY_SRC_EXTHT_HI_THRESHOLDS_OFFSET);
    addr_hit[18] = (reg_addr == ENTROPY_SRC_EXTHT_LO_THRESHOLDS_OFFSET);
    addr_hit[19] = (reg_addr == ENTROPY_SRC_REPCNT_HI_WATERMARKS_OFFSET);
    addr_hit[20] = (reg_addr == ENTROPY_SRC_ADAPTP_HI_WATERMARKS_OFFSET);
    addr_hit[21] = (reg_addr == ENTROPY_SRC_ADAPTP_LO_WATERMARKS_OFFSET);
    addr_hit[22] = (reg_addr == ENTROPY_SRC_EXTHT_HI_WATERMARKS_OFFSET);
    addr_hit[23] = (reg_addr == ENTROPY_SRC_EXTHT_LO_WATERMARKS_OFFSET);
    addr_hit[24] = (reg_addr == ENTROPY_SRC_BUCKET_HI_WATERMARKS_OFFSET);
    addr_hit[25] = (reg_addr == ENTROPY_SRC_MARKOV_HI_WATERMARKS_OFFSET);
    addr_hit[26] = (reg_addr == ENTROPY_SRC_MARKOV_LO_WATERMARKS_OFFSET);
    addr_hit[27] = (reg_addr == ENTROPY_SRC_REPCNT_TOTAL_FAILS_OFFSET);
    addr_hit[28] = (reg_addr == ENTROPY_SRC_ADAPTP_HI_TOTAL_FAILS_OFFSET);
    addr_hit[29] = (reg_addr == ENTROPY_SRC_ADAPTP_LO_TOTAL_FAILS_OFFSET);
    addr_hit[30] = (reg_addr == ENTROPY_SRC_BUCKET_TOTAL_FAILS_OFFSET);
    addr_hit[31] = (reg_addr == ENTROPY_SRC_MARKOV_HI_TOTAL_FAILS_OFFSET);
    addr_hit[32] = (reg_addr == ENTROPY_SRC_MARKOV_LO_TOTAL_FAILS_OFFSET);
    addr_hit[33] = (reg_addr == ENTROPY_SRC_EXTHT_HI_TOTAL_FAILS_OFFSET);
    addr_hit[34] = (reg_addr == ENTROPY_SRC_EXTHT_LO_TOTAL_FAILS_OFFSET);
    addr_hit[35] = (reg_addr == ENTROPY_SRC_ALERT_THRESHOLD_OFFSET);
    addr_hit[36] = (reg_addr == ENTROPY_SRC_ALERT_FAIL_COUNTS_OFFSET);
    addr_hit[37] = (reg_addr == ENTROPY_SRC_EXTHT_FAIL_COUNTS_OFFSET);
    addr_hit[38] = (reg_addr == ENTROPY_SRC_FW_OV_CONTROL_OFFSET);
    addr_hit[39] = (reg_addr == ENTROPY_SRC_FW_OV_RD_DATA_OFFSET);
    addr_hit[40] = (reg_addr == ENTROPY_SRC_FW_OV_WR_DATA_OFFSET);
    addr_hit[41] = (reg_addr == ENTROPY_SRC_FW_OV_FIFO_STS_OFFSET);
    addr_hit[42] = (reg_addr == ENTROPY_SRC_PRE_COND_FIFO_DEPTH_OFFSET);
    addr_hit[43] = (reg_addr == ENTROPY_SRC_DEBUG_STATUS_OFFSET);
    addr_hit[44] = (reg_addr == ENTROPY_SRC_SEED_OFFSET);
    addr_hit[45] = (reg_addr == ENTROPY_SRC_ERR_CODE_OFFSET);
    addr_hit[46] = (reg_addr == ENTROPY_SRC_ERR_CODE_TEST_OFFSET);
  end

  assign addrmiss = (reg_re || reg_we) ? ~|addr_hit : 1'b0 ;

  // Check sub-word write is permitted
  always_comb begin
    wr_err = 1'b0;
    if (addr_hit[ 0] && reg_we && (ENTROPY_SRC_PERMIT[ 0] != (ENTROPY_SRC_PERMIT[ 0] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 1] && reg_we && (ENTROPY_SRC_PERMIT[ 1] != (ENTROPY_SRC_PERMIT[ 1] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 2] && reg_we && (ENTROPY_SRC_PERMIT[ 2] != (ENTROPY_SRC_PERMIT[ 2] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 3] && reg_we && (ENTROPY_SRC_PERMIT[ 3] != (ENTROPY_SRC_PERMIT[ 3] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 4] && reg_we && (ENTROPY_SRC_PERMIT[ 4] != (ENTROPY_SRC_PERMIT[ 4] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 5] && reg_we && (ENTROPY_SRC_PERMIT[ 5] != (ENTROPY_SRC_PERMIT[ 5] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 6] && reg_we && (ENTROPY_SRC_PERMIT[ 6] != (ENTROPY_SRC_PERMIT[ 6] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 7] && reg_we && (ENTROPY_SRC_PERMIT[ 7] != (ENTROPY_SRC_PERMIT[ 7] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 8] && reg_we && (ENTROPY_SRC_PERMIT[ 8] != (ENTROPY_SRC_PERMIT[ 8] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 9] && reg_we && (ENTROPY_SRC_PERMIT[ 9] != (ENTROPY_SRC_PERMIT[ 9] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[10] && reg_we && (ENTROPY_SRC_PERMIT[10] != (ENTROPY_SRC_PERMIT[10] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[11] && reg_we && (ENTROPY_SRC_PERMIT[11] != (ENTROPY_SRC_PERMIT[11] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[12] && reg_we && (ENTROPY_SRC_PERMIT[12] != (ENTROPY_SRC_PERMIT[12] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[13] && reg_we && (ENTROPY_SRC_PERMIT[13] != (ENTROPY_SRC_PERMIT[13] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[14] && reg_we && (ENTROPY_SRC_PERMIT[14] != (ENTROPY_SRC_PERMIT[14] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[15] && reg_we && (ENTROPY_SRC_PERMIT[15] != (ENTROPY_SRC_PERMIT[15] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[16] && reg_we && (ENTROPY_SRC_PERMIT[16] != (ENTROPY_SRC_PERMIT[16] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[17] && reg_we && (ENTROPY_SRC_PERMIT[17] != (ENTROPY_SRC_PERMIT[17] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[18] && reg_we && (ENTROPY_SRC_PERMIT[18] != (ENTROPY_SRC_PERMIT[18] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[19] && reg_we && (ENTROPY_SRC_PERMIT[19] != (ENTROPY_SRC_PERMIT[19] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[20] && reg_we && (ENTROPY_SRC_PERMIT[20] != (ENTROPY_SRC_PERMIT[20] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[21] && reg_we && (ENTROPY_SRC_PERMIT[21] != (ENTROPY_SRC_PERMIT[21] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[22] && reg_we && (ENTROPY_SRC_PERMIT[22] != (ENTROPY_SRC_PERMIT[22] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[23] && reg_we && (ENTROPY_SRC_PERMIT[23] != (ENTROPY_SRC_PERMIT[23] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[24] && reg_we && (ENTROPY_SRC_PERMIT[24] != (ENTROPY_SRC_PERMIT[24] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[25] && reg_we && (ENTROPY_SRC_PERMIT[25] != (ENTROPY_SRC_PERMIT[25] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[26] && reg_we && (ENTROPY_SRC_PERMIT[26] != (ENTROPY_SRC_PERMIT[26] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[27] && reg_we && (ENTROPY_SRC_PERMIT[27] != (ENTROPY_SRC_PERMIT[27] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[28] && reg_we && (ENTROPY_SRC_PERMIT[28] != (ENTROPY_SRC_PERMIT[28] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[29] && reg_we && (ENTROPY_SRC_PERMIT[29] != (ENTROPY_SRC_PERMIT[29] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[30] && reg_we && (ENTROPY_SRC_PERMIT[30] != (ENTROPY_SRC_PERMIT[30] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[31] && reg_we && (ENTROPY_SRC_PERMIT[31] != (ENTROPY_SRC_PERMIT[31] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[32] && reg_we && (ENTROPY_SRC_PERMIT[32] != (ENTROPY_SRC_PERMIT[32] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[33] && reg_we && (ENTROPY_SRC_PERMIT[33] != (ENTROPY_SRC_PERMIT[33] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[34] && reg_we && (ENTROPY_SRC_PERMIT[34] != (ENTROPY_SRC_PERMIT[34] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[35] && reg_we && (ENTROPY_SRC_PERMIT[35] != (ENTROPY_SRC_PERMIT[35] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[36] && reg_we && (ENTROPY_SRC_PERMIT[36] != (ENTROPY_SRC_PERMIT[36] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[37] && reg_we && (ENTROPY_SRC_PERMIT[37] != (ENTROPY_SRC_PERMIT[37] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[38] && reg_we && (ENTROPY_SRC_PERMIT[38] != (ENTROPY_SRC_PERMIT[38] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[39] && reg_we && (ENTROPY_SRC_PERMIT[39] != (ENTROPY_SRC_PERMIT[39] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[40] && reg_we && (ENTROPY_SRC_PERMIT[40] != (ENTROPY_SRC_PERMIT[40] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[41] && reg_we && (ENTROPY_SRC_PERMIT[41] != (ENTROPY_SRC_PERMIT[41] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[42] && reg_we && (ENTROPY_SRC_PERMIT[42] != (ENTROPY_SRC_PERMIT[42] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[43] && reg_we && (ENTROPY_SRC_PERMIT[43] != (ENTROPY_SRC_PERMIT[43] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[44] && reg_we && (ENTROPY_SRC_PERMIT[44] != (ENTROPY_SRC_PERMIT[44] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[45] && reg_we && (ENTROPY_SRC_PERMIT[45] != (ENTROPY_SRC_PERMIT[45] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[46] && reg_we && (ENTROPY_SRC_PERMIT[46] != (ENTROPY_SRC_PERMIT[46] & reg_be))) wr_err = 1'b1 ;
  end

  assign intr_state_es_entropy_valid_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_es_entropy_valid_wd = reg_wdata[0];

  assign intr_state_es_health_test_failed_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_es_health_test_failed_wd = reg_wdata[1];

  assign intr_state_es_fatal_err_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_es_fatal_err_wd = reg_wdata[2];

  assign intr_enable_es_entropy_valid_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_es_entropy_valid_wd = reg_wdata[0];

  assign intr_enable_es_health_test_failed_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_es_health_test_failed_wd = reg_wdata[1];

  assign intr_enable_es_fatal_err_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_es_fatal_err_wd = reg_wdata[2];

  assign intr_test_es_entropy_valid_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_es_entropy_valid_wd = reg_wdata[0];

  assign intr_test_es_health_test_failed_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_es_health_test_failed_wd = reg_wdata[1];

  assign intr_test_es_fatal_err_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_es_fatal_err_wd = reg_wdata[2];

  assign alert_test_recov_alert_we = addr_hit[3] & reg_we & !reg_error;
  assign alert_test_recov_alert_wd = reg_wdata[0];

  assign alert_test_fatal_alert_we = addr_hit[3] & reg_we & !reg_error;
  assign alert_test_fatal_alert_wd = reg_wdata[1];

  assign regwen_we = addr_hit[4] & reg_we & !reg_error;
  assign regwen_wd = reg_wdata[0];

  assign conf_enable_we = addr_hit[6] & reg_we & !reg_error;
  assign conf_enable_wd = reg_wdata[1:0];

  assign conf_boot_bypass_disable_we = addr_hit[6] & reg_we & !reg_error;
  assign conf_boot_bypass_disable_wd = reg_wdata[3];

  assign conf_repcnt_disable_we = addr_hit[6] & reg_we & !reg_error;
  assign conf_repcnt_disable_wd = reg_wdata[4];

  assign conf_adaptp_disable_we = addr_hit[6] & reg_we & !reg_error;
  assign conf_adaptp_disable_wd = reg_wdata[5];

  assign conf_bucket_disable_we = addr_hit[6] & reg_we & !reg_error;
  assign conf_bucket_disable_wd = reg_wdata[6];

  assign conf_markov_disable_we = addr_hit[6] & reg_we & !reg_error;
  assign conf_markov_disable_wd = reg_wdata[7];

  assign conf_health_test_clr_we = addr_hit[6] & reg_we & !reg_error;
  assign conf_health_test_clr_wd = reg_wdata[8];

  assign conf_rng_bit_en_we = addr_hit[6] & reg_we & !reg_error;
  assign conf_rng_bit_en_wd = reg_wdata[9];

  assign conf_rng_bit_sel_we = addr_hit[6] & reg_we & !reg_error;
  assign conf_rng_bit_sel_wd = reg_wdata[11:10];

  assign conf_extht_enable_we = addr_hit[6] & reg_we & !reg_error;
  assign conf_extht_enable_wd = reg_wdata[12];

  assign rate_we = addr_hit[7] & reg_we & !reg_error;
  assign rate_wd = reg_wdata[15:0];

  assign entropy_control_es_route_we = addr_hit[8] & reg_we & !reg_error;
  assign entropy_control_es_route_wd = reg_wdata[0];

  assign entropy_control_es_type_we = addr_hit[8] & reg_we & !reg_error;
  assign entropy_control_es_type_wd = reg_wdata[1];

  assign entropy_data_re = addr_hit[9] & reg_re & !reg_error;

  assign health_test_windows_fips_window_we = addr_hit[10] & reg_we & !reg_error;
  assign health_test_windows_fips_window_wd = reg_wdata[15:0];

  assign health_test_windows_bypass_window_we = addr_hit[10] & reg_we & !reg_error;
  assign health_test_windows_bypass_window_wd = reg_wdata[31:16];

  assign repcnt_thresholds_fips_thresh_we = addr_hit[11] & reg_we & !reg_error;
  assign repcnt_thresholds_fips_thresh_wd = reg_wdata[15:0];
  assign repcnt_thresholds_fips_thresh_re = addr_hit[11] & reg_re & !reg_error;

  assign repcnt_thresholds_bypass_thresh_we = addr_hit[11] & reg_we & !reg_error;
  assign repcnt_thresholds_bypass_thresh_wd = reg_wdata[31:16];
  assign repcnt_thresholds_bypass_thresh_re = addr_hit[11] & reg_re & !reg_error;

  assign adaptp_hi_thresholds_fips_thresh_we = addr_hit[12] & reg_we & !reg_error;
  assign adaptp_hi_thresholds_fips_thresh_wd = reg_wdata[15:0];
  assign adaptp_hi_thresholds_fips_thresh_re = addr_hit[12] & reg_re & !reg_error;

  assign adaptp_hi_thresholds_bypass_thresh_we = addr_hit[12] & reg_we & !reg_error;
  assign adaptp_hi_thresholds_bypass_thresh_wd = reg_wdata[31:16];
  assign adaptp_hi_thresholds_bypass_thresh_re = addr_hit[12] & reg_re & !reg_error;

  assign adaptp_lo_thresholds_fips_thresh_we = addr_hit[13] & reg_we & !reg_error;
  assign adaptp_lo_thresholds_fips_thresh_wd = reg_wdata[15:0];
  assign adaptp_lo_thresholds_fips_thresh_re = addr_hit[13] & reg_re & !reg_error;

  assign adaptp_lo_thresholds_bypass_thresh_we = addr_hit[13] & reg_we & !reg_error;
  assign adaptp_lo_thresholds_bypass_thresh_wd = reg_wdata[31:16];
  assign adaptp_lo_thresholds_bypass_thresh_re = addr_hit[13] & reg_re & !reg_error;

  assign bucket_thresholds_fips_thresh_we = addr_hit[14] & reg_we & !reg_error;
  assign bucket_thresholds_fips_thresh_wd = reg_wdata[15:0];
  assign bucket_thresholds_fips_thresh_re = addr_hit[14] & reg_re & !reg_error;

  assign bucket_thresholds_bypass_thresh_we = addr_hit[14] & reg_we & !reg_error;
  assign bucket_thresholds_bypass_thresh_wd = reg_wdata[31:16];
  assign bucket_thresholds_bypass_thresh_re = addr_hit[14] & reg_re & !reg_error;

  assign markov_hi_thresholds_fips_thresh_we = addr_hit[15] & reg_we & !reg_error;
  assign markov_hi_thresholds_fips_thresh_wd = reg_wdata[15:0];
  assign markov_hi_thresholds_fips_thresh_re = addr_hit[15] & reg_re & !reg_error;

  assign markov_hi_thresholds_bypass_thresh_we = addr_hit[15] & reg_we & !reg_error;
  assign markov_hi_thresholds_bypass_thresh_wd = reg_wdata[31:16];
  assign markov_hi_thresholds_bypass_thresh_re = addr_hit[15] & reg_re & !reg_error;

  assign markov_lo_thresholds_fips_thresh_we = addr_hit[16] & reg_we & !reg_error;
  assign markov_lo_thresholds_fips_thresh_wd = reg_wdata[15:0];
  assign markov_lo_thresholds_fips_thresh_re = addr_hit[16] & reg_re & !reg_error;

  assign markov_lo_thresholds_bypass_thresh_we = addr_hit[16] & reg_we & !reg_error;
  assign markov_lo_thresholds_bypass_thresh_wd = reg_wdata[31:16];
  assign markov_lo_thresholds_bypass_thresh_re = addr_hit[16] & reg_re & !reg_error;

  assign extht_hi_thresholds_fips_thresh_we = addr_hit[17] & reg_we & !reg_error;
  assign extht_hi_thresholds_fips_thresh_wd = reg_wdata[15:0];
  assign extht_hi_thresholds_fips_thresh_re = addr_hit[17] & reg_re & !reg_error;

  assign extht_hi_thresholds_bypass_thresh_we = addr_hit[17] & reg_we & !reg_error;
  assign extht_hi_thresholds_bypass_thresh_wd = reg_wdata[31:16];
  assign extht_hi_thresholds_bypass_thresh_re = addr_hit[17] & reg_re & !reg_error;

  assign extht_lo_thresholds_fips_thresh_we = addr_hit[18] & reg_we & !reg_error;
  assign extht_lo_thresholds_fips_thresh_wd = reg_wdata[15:0];
  assign extht_lo_thresholds_fips_thresh_re = addr_hit[18] & reg_re & !reg_error;

  assign extht_lo_thresholds_bypass_thresh_we = addr_hit[18] & reg_we & !reg_error;
  assign extht_lo_thresholds_bypass_thresh_wd = reg_wdata[31:16];
  assign extht_lo_thresholds_bypass_thresh_re = addr_hit[18] & reg_re & !reg_error;

  assign repcnt_hi_watermarks_fips_watermark_re = addr_hit[19] & reg_re & !reg_error;

  assign repcnt_hi_watermarks_bypass_watermark_re = addr_hit[19] & reg_re & !reg_error;

  assign adaptp_hi_watermarks_fips_watermark_re = addr_hit[20] & reg_re & !reg_error;

  assign adaptp_hi_watermarks_bypass_watermark_re = addr_hit[20] & reg_re & !reg_error;

  assign adaptp_lo_watermarks_fips_watermark_re = addr_hit[21] & reg_re & !reg_error;

  assign adaptp_lo_watermarks_bypass_watermark_re = addr_hit[21] & reg_re & !reg_error;

  assign extht_hi_watermarks_fips_watermark_re = addr_hit[22] & reg_re & !reg_error;

  assign extht_hi_watermarks_bypass_watermark_re = addr_hit[22] & reg_re & !reg_error;

  assign extht_lo_watermarks_fips_watermark_re = addr_hit[23] & reg_re & !reg_error;

  assign extht_lo_watermarks_bypass_watermark_re = addr_hit[23] & reg_re & !reg_error;

  assign bucket_hi_watermarks_fips_watermark_re = addr_hit[24] & reg_re & !reg_error;

  assign bucket_hi_watermarks_bypass_watermark_re = addr_hit[24] & reg_re & !reg_error;

  assign markov_hi_watermarks_fips_watermark_re = addr_hit[25] & reg_re & !reg_error;

  assign markov_hi_watermarks_bypass_watermark_re = addr_hit[25] & reg_re & !reg_error;

  assign markov_lo_watermarks_fips_watermark_re = addr_hit[26] & reg_re & !reg_error;

  assign markov_lo_watermarks_bypass_watermark_re = addr_hit[26] & reg_re & !reg_error;

  assign repcnt_total_fails_re = addr_hit[27] & reg_re & !reg_error;

  assign adaptp_hi_total_fails_re = addr_hit[28] & reg_re & !reg_error;

  assign adaptp_lo_total_fails_re = addr_hit[29] & reg_re & !reg_error;

  assign bucket_total_fails_re = addr_hit[30] & reg_re & !reg_error;

  assign markov_hi_total_fails_re = addr_hit[31] & reg_re & !reg_error;

  assign markov_lo_total_fails_re = addr_hit[32] & reg_re & !reg_error;

  assign extht_hi_total_fails_re = addr_hit[33] & reg_re & !reg_error;

  assign extht_lo_total_fails_re = addr_hit[34] & reg_re & !reg_error;

  assign alert_threshold_we = addr_hit[35] & reg_we & !reg_error;
  assign alert_threshold_wd = reg_wdata[3:0];

  assign alert_fail_counts_any_fail_count_re = addr_hit[36] & reg_re & !reg_error;

  assign alert_fail_counts_repcnt_fail_count_re = addr_hit[36] & reg_re & !reg_error;

  assign alert_fail_counts_adaptp_hi_fail_count_re = addr_hit[36] & reg_re & !reg_error;

  assign alert_fail_counts_adaptp_lo_fail_count_re = addr_hit[36] & reg_re & !reg_error;

  assign alert_fail_counts_bucket_fail_count_re = addr_hit[36] & reg_re & !reg_error;

  assign alert_fail_counts_markov_hi_fail_count_re = addr_hit[36] & reg_re & !reg_error;

  assign alert_fail_counts_markov_lo_fail_count_re = addr_hit[36] & reg_re & !reg_error;

  assign extht_fail_counts_extht_hi_fail_count_re = addr_hit[37] & reg_re & !reg_error;

  assign extht_fail_counts_extht_lo_fail_count_re = addr_hit[37] & reg_re & !reg_error;

  assign fw_ov_control_fw_ov_mode_we = addr_hit[38] & reg_we & !reg_error;
  assign fw_ov_control_fw_ov_mode_wd = reg_wdata[0];

  assign fw_ov_control_fw_ov_fifo_reg_rd_we = addr_hit[38] & reg_we & !reg_error;
  assign fw_ov_control_fw_ov_fifo_reg_rd_wd = reg_wdata[1];

  assign fw_ov_control_fw_ov_fifo_reg_wr_we = addr_hit[38] & reg_we & !reg_error;
  assign fw_ov_control_fw_ov_fifo_reg_wr_wd = reg_wdata[2];

  assign fw_ov_rd_data_re = addr_hit[39] & reg_re & !reg_error;

  assign fw_ov_wr_data_we = addr_hit[40] & reg_we & !reg_error;
  assign fw_ov_wr_data_wd = reg_wdata[31:0];

  assign fw_ov_fifo_sts_re = addr_hit[41] & reg_re & !reg_error;

  assign pre_cond_fifo_depth_we = addr_hit[42] & reg_we & !reg_error;
  assign pre_cond_fifo_depth_wd = reg_wdata[6:0];

  assign debug_status_entropy_fifo_depth_re = addr_hit[43] & reg_re & !reg_error;

  assign debug_status_diag_re = addr_hit[43] & reg_re & !reg_error;

  assign seed_we = addr_hit[44] & reg_we & !reg_error;
  assign seed_wd = reg_wdata[3:0];

  assign err_code_test_we = addr_hit[46] & reg_we & !reg_error;
  assign err_code_test_wd = reg_wdata[4:0];

  // Read data return
  always_comb begin
    reg_rdata_next = '0;
    unique case (1'b1)
      addr_hit[0]: begin
        reg_rdata_next[0] = intr_state_es_entropy_valid_qs;
        reg_rdata_next[1] = intr_state_es_health_test_failed_qs;
        reg_rdata_next[2] = intr_state_es_fatal_err_qs;
      end

      addr_hit[1]: begin
        reg_rdata_next[0] = intr_enable_es_entropy_valid_qs;
        reg_rdata_next[1] = intr_enable_es_health_test_failed_qs;
        reg_rdata_next[2] = intr_enable_es_fatal_err_qs;
      end

      addr_hit[2]: begin
        reg_rdata_next[0] = '0;
        reg_rdata_next[1] = '0;
        reg_rdata_next[2] = '0;
      end

      addr_hit[3]: begin
        reg_rdata_next[0] = '0;
        reg_rdata_next[1] = '0;
      end

      addr_hit[4]: begin
        reg_rdata_next[0] = regwen_qs;
      end

      addr_hit[5]: begin
        reg_rdata_next[7:0] = rev_abi_revision_qs;
        reg_rdata_next[15:8] = rev_hw_revision_qs;
        reg_rdata_next[23:16] = rev_chip_type_qs;
      end

      addr_hit[6]: begin
        reg_rdata_next[1:0] = conf_enable_qs;
        reg_rdata_next[3] = conf_boot_bypass_disable_qs;
        reg_rdata_next[4] = conf_repcnt_disable_qs;
        reg_rdata_next[5] = conf_adaptp_disable_qs;
        reg_rdata_next[6] = conf_bucket_disable_qs;
        reg_rdata_next[7] = conf_markov_disable_qs;
        reg_rdata_next[8] = conf_health_test_clr_qs;
        reg_rdata_next[9] = conf_rng_bit_en_qs;
        reg_rdata_next[11:10] = conf_rng_bit_sel_qs;
        reg_rdata_next[12] = conf_extht_enable_qs;
      end

      addr_hit[7]: begin
        reg_rdata_next[15:0] = rate_qs;
      end

      addr_hit[8]: begin
        reg_rdata_next[0] = entropy_control_es_route_qs;
        reg_rdata_next[1] = entropy_control_es_type_qs;
      end

      addr_hit[9]: begin
        reg_rdata_next[31:0] = entropy_data_qs;
      end

      addr_hit[10]: begin
        reg_rdata_next[15:0] = health_test_windows_fips_window_qs;
        reg_rdata_next[31:16] = health_test_windows_bypass_window_qs;
      end

      addr_hit[11]: begin
        reg_rdata_next[15:0] = repcnt_thresholds_fips_thresh_qs;
        reg_rdata_next[31:16] = repcnt_thresholds_bypass_thresh_qs;
      end

      addr_hit[12]: begin
        reg_rdata_next[15:0] = adaptp_hi_thresholds_fips_thresh_qs;
        reg_rdata_next[31:16] = adaptp_hi_thresholds_bypass_thresh_qs;
      end

      addr_hit[13]: begin
        reg_rdata_next[15:0] = adaptp_lo_thresholds_fips_thresh_qs;
        reg_rdata_next[31:16] = adaptp_lo_thresholds_bypass_thresh_qs;
      end

      addr_hit[14]: begin
        reg_rdata_next[15:0] = bucket_thresholds_fips_thresh_qs;
        reg_rdata_next[31:16] = bucket_thresholds_bypass_thresh_qs;
      end

      addr_hit[15]: begin
        reg_rdata_next[15:0] = markov_hi_thresholds_fips_thresh_qs;
        reg_rdata_next[31:16] = markov_hi_thresholds_bypass_thresh_qs;
      end

      addr_hit[16]: begin
        reg_rdata_next[15:0] = markov_lo_thresholds_fips_thresh_qs;
        reg_rdata_next[31:16] = markov_lo_thresholds_bypass_thresh_qs;
      end

      addr_hit[17]: begin
        reg_rdata_next[15:0] = extht_hi_thresholds_fips_thresh_qs;
        reg_rdata_next[31:16] = extht_hi_thresholds_bypass_thresh_qs;
      end

      addr_hit[18]: begin
        reg_rdata_next[15:0] = extht_lo_thresholds_fips_thresh_qs;
        reg_rdata_next[31:16] = extht_lo_thresholds_bypass_thresh_qs;
      end

      addr_hit[19]: begin
        reg_rdata_next[15:0] = repcnt_hi_watermarks_fips_watermark_qs;
        reg_rdata_next[31:16] = repcnt_hi_watermarks_bypass_watermark_qs;
      end

      addr_hit[20]: begin
        reg_rdata_next[15:0] = adaptp_hi_watermarks_fips_watermark_qs;
        reg_rdata_next[31:16] = adaptp_hi_watermarks_bypass_watermark_qs;
      end

      addr_hit[21]: begin
        reg_rdata_next[15:0] = adaptp_lo_watermarks_fips_watermark_qs;
        reg_rdata_next[31:16] = adaptp_lo_watermarks_bypass_watermark_qs;
      end

      addr_hit[22]: begin
        reg_rdata_next[15:0] = extht_hi_watermarks_fips_watermark_qs;
        reg_rdata_next[31:16] = extht_hi_watermarks_bypass_watermark_qs;
      end

      addr_hit[23]: begin
        reg_rdata_next[15:0] = extht_lo_watermarks_fips_watermark_qs;
        reg_rdata_next[31:16] = extht_lo_watermarks_bypass_watermark_qs;
      end

      addr_hit[24]: begin
        reg_rdata_next[15:0] = bucket_hi_watermarks_fips_watermark_qs;
        reg_rdata_next[31:16] = bucket_hi_watermarks_bypass_watermark_qs;
      end

      addr_hit[25]: begin
        reg_rdata_next[15:0] = markov_hi_watermarks_fips_watermark_qs;
        reg_rdata_next[31:16] = markov_hi_watermarks_bypass_watermark_qs;
      end

      addr_hit[26]: begin
        reg_rdata_next[15:0] = markov_lo_watermarks_fips_watermark_qs;
        reg_rdata_next[31:16] = markov_lo_watermarks_bypass_watermark_qs;
      end

      addr_hit[27]: begin
        reg_rdata_next[31:0] = repcnt_total_fails_qs;
      end

      addr_hit[28]: begin
        reg_rdata_next[31:0] = adaptp_hi_total_fails_qs;
      end

      addr_hit[29]: begin
        reg_rdata_next[31:0] = adaptp_lo_total_fails_qs;
      end

      addr_hit[30]: begin
        reg_rdata_next[31:0] = bucket_total_fails_qs;
      end

      addr_hit[31]: begin
        reg_rdata_next[31:0] = markov_hi_total_fails_qs;
      end

      addr_hit[32]: begin
        reg_rdata_next[31:0] = markov_lo_total_fails_qs;
      end

      addr_hit[33]: begin
        reg_rdata_next[31:0] = extht_hi_total_fails_qs;
      end

      addr_hit[34]: begin
        reg_rdata_next[31:0] = extht_lo_total_fails_qs;
      end

      addr_hit[35]: begin
        reg_rdata_next[3:0] = alert_threshold_qs;
      end

      addr_hit[36]: begin
        reg_rdata_next[3:0] = alert_fail_counts_any_fail_count_qs;
        reg_rdata_next[7:4] = alert_fail_counts_repcnt_fail_count_qs;
        reg_rdata_next[11:8] = alert_fail_counts_adaptp_hi_fail_count_qs;
        reg_rdata_next[15:12] = alert_fail_counts_adaptp_lo_fail_count_qs;
        reg_rdata_next[19:16] = alert_fail_counts_bucket_fail_count_qs;
        reg_rdata_next[23:20] = alert_fail_counts_markov_hi_fail_count_qs;
        reg_rdata_next[27:24] = alert_fail_counts_markov_lo_fail_count_qs;
      end

      addr_hit[37]: begin
        reg_rdata_next[3:0] = extht_fail_counts_extht_hi_fail_count_qs;
        reg_rdata_next[7:4] = extht_fail_counts_extht_lo_fail_count_qs;
      end

      addr_hit[38]: begin
        reg_rdata_next[0] = fw_ov_control_fw_ov_mode_qs;
        reg_rdata_next[1] = fw_ov_control_fw_ov_fifo_reg_rd_qs;
        reg_rdata_next[2] = fw_ov_control_fw_ov_fifo_reg_wr_qs;
      end

      addr_hit[39]: begin
        reg_rdata_next[31:0] = fw_ov_rd_data_qs;
      end

      addr_hit[40]: begin
        reg_rdata_next[31:0] = '0;
      end

      addr_hit[41]: begin
        reg_rdata_next[6:0] = fw_ov_fifo_sts_qs;
      end

      addr_hit[42]: begin
        reg_rdata_next[6:0] = pre_cond_fifo_depth_qs;
      end

      addr_hit[43]: begin
        reg_rdata_next[2:0] = debug_status_entropy_fifo_depth_qs;
        reg_rdata_next[31] = debug_status_diag_qs;
      end

      addr_hit[44]: begin
        reg_rdata_next[3:0] = seed_qs;
      end

      addr_hit[45]: begin
        reg_rdata_next[0] = err_code_sfifo_esrng_err_qs;
        reg_rdata_next[1] = err_code_sfifo_precon_err_qs;
        reg_rdata_next[2] = err_code_sfifo_esfinal_err_qs;
        reg_rdata_next[20] = err_code_es_ack_sm_err_qs;
        reg_rdata_next[21] = err_code_es_main_sm_err_qs;
        reg_rdata_next[28] = err_code_fifo_write_err_qs;
        reg_rdata_next[29] = err_code_fifo_read_err_qs;
        reg_rdata_next[30] = err_code_fifo_state_err_qs;
      end

      addr_hit[46]: begin
        reg_rdata_next[4:0] = err_code_test_qs;
      end

      default: begin
        reg_rdata_next = '1;
      end
    endcase
  end

  // Unused signal tieoff

  // wdata / byte enable are not always fully used
  // add a blanket unused statement to handle lint waivers
  logic unused_wdata;
  logic unused_be;
  assign unused_wdata = ^reg_wdata;
  assign unused_be = ^reg_be;

  // Assertions for Register Interface
  `ASSERT_PULSE(wePulse, reg_we)
  `ASSERT_PULSE(rePulse, reg_re)

  `ASSERT(reAfterRv, $rose(reg_re || reg_we) |=> tl_o.d_valid)

  `ASSERT(en2addrHit, (reg_we || reg_re) |-> $onehot0(addr_hit))

  // this is formulated as an assumption such that the FPV testbenches do disprove this
  // property by mistake
  //`ASSUME(reqParity, tl_reg_h2d.a_valid |-> tl_reg_h2d.a_user.chk_en == tlul_pkg::CheckDis)

endmodule
