// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// Register Top module auto-generated by `reggen`

`include "prim_assert.sv"

module dcd_reg_top (
  input clk_i,
  input rst_ni,

  input  tlul_pkg::tl_h2d_t tl_i,
  output tlul_pkg::tl_d2h_t tl_o,
  // To HW
  output dcd_reg_pkg::dcd_reg2hw_t reg2hw, // Write
  input  dcd_reg_pkg::dcd_hw2reg_t hw2reg, // Read

  // Integrity check errors
  output logic intg_err_o,

  // Config
  input devmode_i // If 1, explicit error return for unmapped register access
);

  import dcd_reg_pkg::* ;

  localparam int AW = 7;
  localparam int DW = 32;
  localparam int DBW = DW/8;                    // Byte Width

  // register signals
  logic           reg_we;
  logic           reg_re;
  logic [AW-1:0]  reg_addr;
  logic [DW-1:0]  reg_wdata;
  logic [DBW-1:0] reg_be;
  logic [DW-1:0]  reg_rdata;
  logic           reg_error;

  logic          addrmiss, wr_err;

  logic [DW-1:0] reg_rdata_next;

  tlul_pkg::tl_h2d_t tl_reg_h2d;
  tlul_pkg::tl_d2h_t tl_reg_d2h;

  // incoming payload check
  logic intg_err;
  tlul_cmd_intg_chk u_chk (
    .tl_i,
    .err_o(intg_err)
  );

  logic intg_err_q;
  always_ff @(posedge clk_i or negedge rst_ni) begin
    if (!rst_ni) begin
      intg_err_q <= '0;
    end else if (intg_err) begin
      intg_err_q <= 1'b1;
    end
  end

  // integrity error output is permanent and should be used for alert generation
  // register errors are transactional
  assign intg_err_o = intg_err_q | intg_err;

  // outgoing integrity generation
  tlul_pkg::tl_d2h_t tl_o_pre;
  tlul_rsp_intg_gen u_rsp_intg_gen (
    .tl_i(tl_o_pre),
    .tl_o
  );

  assign tl_reg_h2d = tl_i;
  assign tl_o_pre   = tl_reg_d2h;

  tlul_adapter_reg #(
    .RegAw(AW),
    .RegDw(DW)
  ) u_reg_if (
    .clk_i,
    .rst_ni,

    .tl_i (tl_reg_h2d),
    .tl_o (tl_reg_d2h),

    .we_o    (reg_we),
    .re_o    (reg_re),
    .addr_o  (reg_addr),
    .wdata_o (reg_wdata),
    .be_o    (reg_be),
    .rdata_i (reg_rdata),
    .error_i (reg_error)
  );

  assign reg_rdata = reg_rdata_next ;
  assign reg_error = (devmode_i & addrmiss) | wr_err | intg_err;

  // Define SW related signals
  // Format: <reg>_<field>_{wd|we|qs}
  //        or <reg>_{wd|we|qs} if field == 1 or 0
  logic intr_state_qs;
  logic intr_state_wd;
  logic intr_state_we;
  logic intr_enable_qs;
  logic intr_enable_wd;
  logic intr_enable_we;
  logic intr_test_wd;
  logic intr_test_we;
  logic adc_en_ctl_adc_enable_qs;
  logic adc_en_ctl_adc_enable_wd;
  logic adc_en_ctl_adc_enable_we;
  logic adc_en_ctl_oneshot_mode_qs;
  logic adc_en_ctl_oneshot_mode_wd;
  logic adc_en_ctl_oneshot_mode_we;
  logic adc_pd_ctl_lp_mode_qs;
  logic adc_pd_ctl_lp_mode_wd;
  logic adc_pd_ctl_lp_mode_we;
  logic [3:0] adc_pd_ctl_pwrup_time_qs;
  logic [3:0] adc_pd_ctl_pwrup_time_wd;
  logic adc_pd_ctl_pwrup_time_we;
  logic [23:0] adc_pd_ctl_wakeup_time_qs;
  logic [23:0] adc_pd_ctl_wakeup_time_wd;
  logic adc_pd_ctl_wakeup_time_we;
  logic [7:0] adc_lp_sample_ctl_qs;
  logic [7:0] adc_lp_sample_ctl_wd;
  logic adc_lp_sample_ctl_we;
  logic [15:0] adc_sample_ctl_qs;
  logic [15:0] adc_sample_ctl_wd;
  logic adc_sample_ctl_we;
  logic adc_fsm_rst_qs;
  logic adc_fsm_rst_wd;
  logic adc_fsm_rst_we;
  logic [9:0] adc_chn0_filter_ctl_0_min_v_0_qs;
  logic [9:0] adc_chn0_filter_ctl_0_min_v_0_wd;
  logic adc_chn0_filter_ctl_0_min_v_0_we;
  logic adc_chn0_filter_ctl_0_cond_0_qs;
  logic adc_chn0_filter_ctl_0_cond_0_wd;
  logic adc_chn0_filter_ctl_0_cond_0_we;
  logic [9:0] adc_chn0_filter_ctl_0_max_v_0_qs;
  logic [9:0] adc_chn0_filter_ctl_0_max_v_0_wd;
  logic adc_chn0_filter_ctl_0_max_v_0_we;
  logic [9:0] adc_chn0_filter_ctl_1_min_v_1_qs;
  logic [9:0] adc_chn0_filter_ctl_1_min_v_1_wd;
  logic adc_chn0_filter_ctl_1_min_v_1_we;
  logic adc_chn0_filter_ctl_1_cond_1_qs;
  logic adc_chn0_filter_ctl_1_cond_1_wd;
  logic adc_chn0_filter_ctl_1_cond_1_we;
  logic [9:0] adc_chn0_filter_ctl_1_max_v_1_qs;
  logic [9:0] adc_chn0_filter_ctl_1_max_v_1_wd;
  logic adc_chn0_filter_ctl_1_max_v_1_we;
  logic [9:0] adc_chn0_filter_ctl_2_min_v_2_qs;
  logic [9:0] adc_chn0_filter_ctl_2_min_v_2_wd;
  logic adc_chn0_filter_ctl_2_min_v_2_we;
  logic adc_chn0_filter_ctl_2_cond_2_qs;
  logic adc_chn0_filter_ctl_2_cond_2_wd;
  logic adc_chn0_filter_ctl_2_cond_2_we;
  logic [9:0] adc_chn0_filter_ctl_2_max_v_2_qs;
  logic [9:0] adc_chn0_filter_ctl_2_max_v_2_wd;
  logic adc_chn0_filter_ctl_2_max_v_2_we;
  logic [9:0] adc_chn0_filter_ctl_3_min_v_3_qs;
  logic [9:0] adc_chn0_filter_ctl_3_min_v_3_wd;
  logic adc_chn0_filter_ctl_3_min_v_3_we;
  logic adc_chn0_filter_ctl_3_cond_3_qs;
  logic adc_chn0_filter_ctl_3_cond_3_wd;
  logic adc_chn0_filter_ctl_3_cond_3_we;
  logic [9:0] adc_chn0_filter_ctl_3_max_v_3_qs;
  logic [9:0] adc_chn0_filter_ctl_3_max_v_3_wd;
  logic adc_chn0_filter_ctl_3_max_v_3_we;
  logic [9:0] adc_chn0_filter_ctl_4_min_v_4_qs;
  logic [9:0] adc_chn0_filter_ctl_4_min_v_4_wd;
  logic adc_chn0_filter_ctl_4_min_v_4_we;
  logic adc_chn0_filter_ctl_4_cond_4_qs;
  logic adc_chn0_filter_ctl_4_cond_4_wd;
  logic adc_chn0_filter_ctl_4_cond_4_we;
  logic [9:0] adc_chn0_filter_ctl_4_max_v_4_qs;
  logic [9:0] adc_chn0_filter_ctl_4_max_v_4_wd;
  logic adc_chn0_filter_ctl_4_max_v_4_we;
  logic [9:0] adc_chn0_filter_ctl_5_min_v_5_qs;
  logic [9:0] adc_chn0_filter_ctl_5_min_v_5_wd;
  logic adc_chn0_filter_ctl_5_min_v_5_we;
  logic adc_chn0_filter_ctl_5_cond_5_qs;
  logic adc_chn0_filter_ctl_5_cond_5_wd;
  logic adc_chn0_filter_ctl_5_cond_5_we;
  logic [9:0] adc_chn0_filter_ctl_5_max_v_5_qs;
  logic [9:0] adc_chn0_filter_ctl_5_max_v_5_wd;
  logic adc_chn0_filter_ctl_5_max_v_5_we;
  logic [9:0] adc_chn0_filter_ctl_6_min_v_6_qs;
  logic [9:0] adc_chn0_filter_ctl_6_min_v_6_wd;
  logic adc_chn0_filter_ctl_6_min_v_6_we;
  logic adc_chn0_filter_ctl_6_cond_6_qs;
  logic adc_chn0_filter_ctl_6_cond_6_wd;
  logic adc_chn0_filter_ctl_6_cond_6_we;
  logic [9:0] adc_chn0_filter_ctl_6_max_v_6_qs;
  logic [9:0] adc_chn0_filter_ctl_6_max_v_6_wd;
  logic adc_chn0_filter_ctl_6_max_v_6_we;
  logic [9:0] adc_chn0_filter_ctl_7_min_v_7_qs;
  logic [9:0] adc_chn0_filter_ctl_7_min_v_7_wd;
  logic adc_chn0_filter_ctl_7_min_v_7_we;
  logic adc_chn0_filter_ctl_7_cond_7_qs;
  logic adc_chn0_filter_ctl_7_cond_7_wd;
  logic adc_chn0_filter_ctl_7_cond_7_we;
  logic [9:0] adc_chn0_filter_ctl_7_max_v_7_qs;
  logic [9:0] adc_chn0_filter_ctl_7_max_v_7_wd;
  logic adc_chn0_filter_ctl_7_max_v_7_we;
  logic [9:0] adc_chn1_filter_ctl_0_min_v_0_qs;
  logic [9:0] adc_chn1_filter_ctl_0_min_v_0_wd;
  logic adc_chn1_filter_ctl_0_min_v_0_we;
  logic adc_chn1_filter_ctl_0_cond_0_qs;
  logic adc_chn1_filter_ctl_0_cond_0_wd;
  logic adc_chn1_filter_ctl_0_cond_0_we;
  logic [9:0] adc_chn1_filter_ctl_0_max_v_0_qs;
  logic [9:0] adc_chn1_filter_ctl_0_max_v_0_wd;
  logic adc_chn1_filter_ctl_0_max_v_0_we;
  logic [9:0] adc_chn1_filter_ctl_1_min_v_1_qs;
  logic [9:0] adc_chn1_filter_ctl_1_min_v_1_wd;
  logic adc_chn1_filter_ctl_1_min_v_1_we;
  logic adc_chn1_filter_ctl_1_cond_1_qs;
  logic adc_chn1_filter_ctl_1_cond_1_wd;
  logic adc_chn1_filter_ctl_1_cond_1_we;
  logic [9:0] adc_chn1_filter_ctl_1_max_v_1_qs;
  logic [9:0] adc_chn1_filter_ctl_1_max_v_1_wd;
  logic adc_chn1_filter_ctl_1_max_v_1_we;
  logic [9:0] adc_chn1_filter_ctl_2_min_v_2_qs;
  logic [9:0] adc_chn1_filter_ctl_2_min_v_2_wd;
  logic adc_chn1_filter_ctl_2_min_v_2_we;
  logic adc_chn1_filter_ctl_2_cond_2_qs;
  logic adc_chn1_filter_ctl_2_cond_2_wd;
  logic adc_chn1_filter_ctl_2_cond_2_we;
  logic [9:0] adc_chn1_filter_ctl_2_max_v_2_qs;
  logic [9:0] adc_chn1_filter_ctl_2_max_v_2_wd;
  logic adc_chn1_filter_ctl_2_max_v_2_we;
  logic [9:0] adc_chn1_filter_ctl_3_min_v_3_qs;
  logic [9:0] adc_chn1_filter_ctl_3_min_v_3_wd;
  logic adc_chn1_filter_ctl_3_min_v_3_we;
  logic adc_chn1_filter_ctl_3_cond_3_qs;
  logic adc_chn1_filter_ctl_3_cond_3_wd;
  logic adc_chn1_filter_ctl_3_cond_3_we;
  logic [9:0] adc_chn1_filter_ctl_3_max_v_3_qs;
  logic [9:0] adc_chn1_filter_ctl_3_max_v_3_wd;
  logic adc_chn1_filter_ctl_3_max_v_3_we;
  logic [9:0] adc_chn1_filter_ctl_4_min_v_4_qs;
  logic [9:0] adc_chn1_filter_ctl_4_min_v_4_wd;
  logic adc_chn1_filter_ctl_4_min_v_4_we;
  logic adc_chn1_filter_ctl_4_cond_4_qs;
  logic adc_chn1_filter_ctl_4_cond_4_wd;
  logic adc_chn1_filter_ctl_4_cond_4_we;
  logic [9:0] adc_chn1_filter_ctl_4_max_v_4_qs;
  logic [9:0] adc_chn1_filter_ctl_4_max_v_4_wd;
  logic adc_chn1_filter_ctl_4_max_v_4_we;
  logic [9:0] adc_chn1_filter_ctl_5_min_v_5_qs;
  logic [9:0] adc_chn1_filter_ctl_5_min_v_5_wd;
  logic adc_chn1_filter_ctl_5_min_v_5_we;
  logic adc_chn1_filter_ctl_5_cond_5_qs;
  logic adc_chn1_filter_ctl_5_cond_5_wd;
  logic adc_chn1_filter_ctl_5_cond_5_we;
  logic [9:0] adc_chn1_filter_ctl_5_max_v_5_qs;
  logic [9:0] adc_chn1_filter_ctl_5_max_v_5_wd;
  logic adc_chn1_filter_ctl_5_max_v_5_we;
  logic [9:0] adc_chn1_filter_ctl_6_min_v_6_qs;
  logic [9:0] adc_chn1_filter_ctl_6_min_v_6_wd;
  logic adc_chn1_filter_ctl_6_min_v_6_we;
  logic adc_chn1_filter_ctl_6_cond_6_qs;
  logic adc_chn1_filter_ctl_6_cond_6_wd;
  logic adc_chn1_filter_ctl_6_cond_6_we;
  logic [9:0] adc_chn1_filter_ctl_6_max_v_6_qs;
  logic [9:0] adc_chn1_filter_ctl_6_max_v_6_wd;
  logic adc_chn1_filter_ctl_6_max_v_6_we;
  logic [9:0] adc_chn1_filter_ctl_7_min_v_7_qs;
  logic [9:0] adc_chn1_filter_ctl_7_min_v_7_wd;
  logic adc_chn1_filter_ctl_7_min_v_7_we;
  logic adc_chn1_filter_ctl_7_cond_7_qs;
  logic adc_chn1_filter_ctl_7_cond_7_wd;
  logic adc_chn1_filter_ctl_7_cond_7_we;
  logic [9:0] adc_chn1_filter_ctl_7_max_v_7_qs;
  logic [9:0] adc_chn1_filter_ctl_7_max_v_7_wd;
  logic adc_chn1_filter_ctl_7_max_v_7_we;
  logic [1:0] adc_chn_val_0_adc_chn_value_ext_0_qs;
  logic [9:0] adc_chn_val_0_adc_chn_value_0_qs;
  logic [1:0] adc_chn_val_0_adc_chn_value_intr_ext_0_qs;
  logic [9:0] adc_chn_val_0_adc_chn_value_intr_0_qs;
  logic [1:0] adc_chn_val_1_adc_chn_value_ext_1_qs;
  logic [9:0] adc_chn_val_1_adc_chn_value_1_qs;
  logic [1:0] adc_chn_val_1_adc_chn_value_intr_ext_1_qs;
  logic [9:0] adc_chn_val_1_adc_chn_value_intr_1_qs;
  logic adc_wakeup_ctl_chn0_1_filter0_en_qs;
  logic adc_wakeup_ctl_chn0_1_filter0_en_wd;
  logic adc_wakeup_ctl_chn0_1_filter0_en_we;
  logic adc_wakeup_ctl_chn0_1_filter1_en_qs;
  logic adc_wakeup_ctl_chn0_1_filter1_en_wd;
  logic adc_wakeup_ctl_chn0_1_filter1_en_we;
  logic adc_wakeup_ctl_chn0_1_filter2_en_qs;
  logic adc_wakeup_ctl_chn0_1_filter2_en_wd;
  logic adc_wakeup_ctl_chn0_1_filter2_en_we;
  logic adc_wakeup_ctl_chn0_1_filter3_en_qs;
  logic adc_wakeup_ctl_chn0_1_filter3_en_wd;
  logic adc_wakeup_ctl_chn0_1_filter3_en_we;
  logic adc_wakeup_ctl_chn0_1_filter4_en_qs;
  logic adc_wakeup_ctl_chn0_1_filter4_en_wd;
  logic adc_wakeup_ctl_chn0_1_filter4_en_we;
  logic adc_wakeup_ctl_chn0_1_filter5_en_qs;
  logic adc_wakeup_ctl_chn0_1_filter5_en_wd;
  logic adc_wakeup_ctl_chn0_1_filter5_en_we;
  logic adc_wakeup_ctl_chn0_1_filter6_en_qs;
  logic adc_wakeup_ctl_chn0_1_filter6_en_wd;
  logic adc_wakeup_ctl_chn0_1_filter6_en_we;
  logic adc_wakeup_ctl_chn0_1_filter7_en_qs;
  logic adc_wakeup_ctl_chn0_1_filter7_en_wd;
  logic adc_wakeup_ctl_chn0_1_filter7_en_we;
  logic adc_wakeup_status_cc_sink_det_qs;
  logic adc_wakeup_status_cc_sink_det_wd;
  logic adc_wakeup_status_cc_sink_det_we;
  logic adc_wakeup_status_cc_1a5_sink_det_qs;
  logic adc_wakeup_status_cc_1a5_sink_det_wd;
  logic adc_wakeup_status_cc_1a5_sink_det_we;
  logic adc_wakeup_status_cc_3a0_sink_det_qs;
  logic adc_wakeup_status_cc_3a0_sink_det_wd;
  logic adc_wakeup_status_cc_3a0_sink_det_we;
  logic adc_wakeup_status_cc_src_det_qs;
  logic adc_wakeup_status_cc_src_det_wd;
  logic adc_wakeup_status_cc_src_det_we;
  logic adc_wakeup_status_cc_1a5_src_det_qs;
  logic adc_wakeup_status_cc_1a5_src_det_wd;
  logic adc_wakeup_status_cc_1a5_src_det_we;
  logic adc_wakeup_status_cc_src_det_flip_qs;
  logic adc_wakeup_status_cc_src_det_flip_wd;
  logic adc_wakeup_status_cc_src_det_flip_we;
  logic adc_wakeup_status_cc_1a5_src_det_flip_qs;
  logic adc_wakeup_status_cc_1a5_src_det_flip_wd;
  logic adc_wakeup_status_cc_1a5_src_det_flip_we;
  logic adc_wakeup_status_cc_discon_qs;
  logic adc_wakeup_status_cc_discon_wd;
  logic adc_wakeup_status_cc_discon_we;
  logic adc_intr_ctl_chn0_1_filter0_en_qs;
  logic adc_intr_ctl_chn0_1_filter0_en_wd;
  logic adc_intr_ctl_chn0_1_filter0_en_we;
  logic adc_intr_ctl_chn0_1_filter1_en_qs;
  logic adc_intr_ctl_chn0_1_filter1_en_wd;
  logic adc_intr_ctl_chn0_1_filter1_en_we;
  logic adc_intr_ctl_chn0_1_filter2_en_qs;
  logic adc_intr_ctl_chn0_1_filter2_en_wd;
  logic adc_intr_ctl_chn0_1_filter2_en_we;
  logic adc_intr_ctl_chn0_1_filter3_en_qs;
  logic adc_intr_ctl_chn0_1_filter3_en_wd;
  logic adc_intr_ctl_chn0_1_filter3_en_we;
  logic adc_intr_ctl_chn0_1_filter4_en_qs;
  logic adc_intr_ctl_chn0_1_filter4_en_wd;
  logic adc_intr_ctl_chn0_1_filter4_en_we;
  logic adc_intr_ctl_chn0_1_filter5_en_qs;
  logic adc_intr_ctl_chn0_1_filter5_en_wd;
  logic adc_intr_ctl_chn0_1_filter5_en_we;
  logic adc_intr_ctl_chn0_1_filter6_en_qs;
  logic adc_intr_ctl_chn0_1_filter6_en_wd;
  logic adc_intr_ctl_chn0_1_filter6_en_we;
  logic adc_intr_ctl_chn0_1_filter7_en_qs;
  logic adc_intr_ctl_chn0_1_filter7_en_wd;
  logic adc_intr_ctl_chn0_1_filter7_en_we;
  logic adc_intr_ctl_oneshot_intr_en_qs;
  logic adc_intr_ctl_oneshot_intr_en_wd;
  logic adc_intr_ctl_oneshot_intr_en_we;
  logic adc_intr_status_cc_sink_det_qs;
  logic adc_intr_status_cc_sink_det_wd;
  logic adc_intr_status_cc_sink_det_we;
  logic adc_intr_status_cc_1a5_sink_det_qs;
  logic adc_intr_status_cc_1a5_sink_det_wd;
  logic adc_intr_status_cc_1a5_sink_det_we;
  logic adc_intr_status_cc_3a0_sink_det_qs;
  logic adc_intr_status_cc_3a0_sink_det_wd;
  logic adc_intr_status_cc_3a0_sink_det_we;
  logic adc_intr_status_cc_src_det_qs;
  logic adc_intr_status_cc_src_det_wd;
  logic adc_intr_status_cc_src_det_we;
  logic adc_intr_status_cc_1a5_src_det_qs;
  logic adc_intr_status_cc_1a5_src_det_wd;
  logic adc_intr_status_cc_1a5_src_det_we;
  logic adc_intr_status_cc_src_det_flip_qs;
  logic adc_intr_status_cc_src_det_flip_wd;
  logic adc_intr_status_cc_src_det_flip_we;
  logic adc_intr_status_cc_1a5_src_det_flip_qs;
  logic adc_intr_status_cc_1a5_src_det_flip_wd;
  logic adc_intr_status_cc_1a5_src_det_flip_we;
  logic adc_intr_status_cc_discon_qs;
  logic adc_intr_status_cc_discon_wd;
  logic adc_intr_status_cc_discon_we;
  logic adc_intr_status_oneshot_qs;
  logic adc_intr_status_oneshot_wd;
  logic adc_intr_status_oneshot_we;

  // Register instances
  // R[intr_state]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_we),
    .wd     (intr_state_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.de),
    .d      (hw2reg.intr_state.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.q ),

    // to register interface (read)
    .qs     (intr_state_qs)
  );


  // R[intr_enable]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_we),
    .wd     (intr_enable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.q ),

    // to register interface (read)
    .qs     (intr_enable_qs)
  );


  // R[intr_test]: V(True)

  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test (
    .re     (1'b0),
    .we     (intr_test_we),
    .wd     (intr_test_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.qe),
    .q      (reg2hw.intr_test.q ),
    .qs     ()
  );


  // R[adc_en_ctl]: V(False)

  //   F[adc_enable]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_en_ctl_adc_enable (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_en_ctl_adc_enable_we),
    .wd     (adc_en_ctl_adc_enable_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_en_ctl.adc_enable.q ),

    // to register interface (read)
    .qs     (adc_en_ctl_adc_enable_qs)
  );


  //   F[oneshot_mode]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_en_ctl_oneshot_mode (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_en_ctl_oneshot_mode_we),
    .wd     (adc_en_ctl_oneshot_mode_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_en_ctl.oneshot_mode.q ),

    // to register interface (read)
    .qs     (adc_en_ctl_oneshot_mode_qs)
  );


  // R[adc_pd_ctl]: V(False)

  //   F[lp_mode]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_pd_ctl_lp_mode (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_pd_ctl_lp_mode_we),
    .wd     (adc_pd_ctl_lp_mode_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_pd_ctl.lp_mode.qe),
    .q      (reg2hw.adc_pd_ctl.lp_mode.q ),

    // to register interface (read)
    .qs     (adc_pd_ctl_lp_mode_qs)
  );


  //   F[pwrup_time]: 7:4
  prim_subreg #(
    .DW      (4),
    .SWACCESS("RW"),
    .RESVAL  (4'h6)
  ) u_adc_pd_ctl_pwrup_time (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_pd_ctl_pwrup_time_we),
    .wd     (adc_pd_ctl_pwrup_time_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_pd_ctl.pwrup_time.qe),
    .q      (reg2hw.adc_pd_ctl.pwrup_time.q ),

    // to register interface (read)
    .qs     (adc_pd_ctl_pwrup_time_qs)
  );


  //   F[wakeup_time]: 31:8
  prim_subreg #(
    .DW      (24),
    .SWACCESS("RW"),
    .RESVAL  (24'h640)
  ) u_adc_pd_ctl_wakeup_time (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_pd_ctl_wakeup_time_we),
    .wd     (adc_pd_ctl_wakeup_time_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_pd_ctl.wakeup_time.qe),
    .q      (reg2hw.adc_pd_ctl.wakeup_time.q ),

    // to register interface (read)
    .qs     (adc_pd_ctl_wakeup_time_qs)
  );


  // R[adc_lp_sample_ctl]: V(False)

  prim_subreg #(
    .DW      (8),
    .SWACCESS("RW"),
    .RESVAL  (8'h4)
  ) u_adc_lp_sample_ctl (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_lp_sample_ctl_we),
    .wd     (adc_lp_sample_ctl_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_lp_sample_ctl.qe),
    .q      (reg2hw.adc_lp_sample_ctl.q ),

    // to register interface (read)
    .qs     (adc_lp_sample_ctl_qs)
  );


  // R[adc_sample_ctl]: V(False)

  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h9b)
  ) u_adc_sample_ctl (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_sample_ctl_we),
    .wd     (adc_sample_ctl_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_sample_ctl.qe),
    .q      (reg2hw.adc_sample_ctl.q ),

    // to register interface (read)
    .qs     (adc_sample_ctl_qs)
  );


  // R[adc_fsm_rst]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_fsm_rst (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_fsm_rst_we),
    .wd     (adc_fsm_rst_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_fsm_rst.q ),

    // to register interface (read)
    .qs     (adc_fsm_rst_qs)
  );



  // Subregister 0 of Multireg adc_chn0_filter_ctl
  // R[adc_chn0_filter_ctl_0]: V(False)

  // F[min_v_0]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_0_min_v_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_0_min_v_0_we),
    .wd     (adc_chn0_filter_ctl_0_min_v_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[0].min_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[0].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_0_min_v_0_qs)
  );


  // F[cond_0]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn0_filter_ctl_0_cond_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_0_cond_0_we),
    .wd     (adc_chn0_filter_ctl_0_cond_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[0].cond.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[0].cond.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_0_cond_0_qs)
  );


  // F[max_v_0]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_0_max_v_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_0_max_v_0_we),
    .wd     (adc_chn0_filter_ctl_0_max_v_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[0].max_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[0].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_0_max_v_0_qs)
  );


  // Subregister 1 of Multireg adc_chn0_filter_ctl
  // R[adc_chn0_filter_ctl_1]: V(False)

  // F[min_v_1]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_1_min_v_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_1_min_v_1_we),
    .wd     (adc_chn0_filter_ctl_1_min_v_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[1].min_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[1].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_1_min_v_1_qs)
  );


  // F[cond_1]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn0_filter_ctl_1_cond_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_1_cond_1_we),
    .wd     (adc_chn0_filter_ctl_1_cond_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[1].cond.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[1].cond.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_1_cond_1_qs)
  );


  // F[max_v_1]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_1_max_v_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_1_max_v_1_we),
    .wd     (adc_chn0_filter_ctl_1_max_v_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[1].max_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[1].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_1_max_v_1_qs)
  );


  // Subregister 2 of Multireg adc_chn0_filter_ctl
  // R[adc_chn0_filter_ctl_2]: V(False)

  // F[min_v_2]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_2_min_v_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_2_min_v_2_we),
    .wd     (adc_chn0_filter_ctl_2_min_v_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[2].min_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[2].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_2_min_v_2_qs)
  );


  // F[cond_2]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn0_filter_ctl_2_cond_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_2_cond_2_we),
    .wd     (adc_chn0_filter_ctl_2_cond_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[2].cond.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[2].cond.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_2_cond_2_qs)
  );


  // F[max_v_2]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_2_max_v_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_2_max_v_2_we),
    .wd     (adc_chn0_filter_ctl_2_max_v_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[2].max_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[2].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_2_max_v_2_qs)
  );


  // Subregister 3 of Multireg adc_chn0_filter_ctl
  // R[adc_chn0_filter_ctl_3]: V(False)

  // F[min_v_3]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_3_min_v_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_3_min_v_3_we),
    .wd     (adc_chn0_filter_ctl_3_min_v_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[3].min_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[3].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_3_min_v_3_qs)
  );


  // F[cond_3]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn0_filter_ctl_3_cond_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_3_cond_3_we),
    .wd     (adc_chn0_filter_ctl_3_cond_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[3].cond.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[3].cond.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_3_cond_3_qs)
  );


  // F[max_v_3]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_3_max_v_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_3_max_v_3_we),
    .wd     (adc_chn0_filter_ctl_3_max_v_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[3].max_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[3].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_3_max_v_3_qs)
  );


  // Subregister 4 of Multireg adc_chn0_filter_ctl
  // R[adc_chn0_filter_ctl_4]: V(False)

  // F[min_v_4]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_4_min_v_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_4_min_v_4_we),
    .wd     (adc_chn0_filter_ctl_4_min_v_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[4].min_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[4].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_4_min_v_4_qs)
  );


  // F[cond_4]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn0_filter_ctl_4_cond_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_4_cond_4_we),
    .wd     (adc_chn0_filter_ctl_4_cond_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[4].cond.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[4].cond.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_4_cond_4_qs)
  );


  // F[max_v_4]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_4_max_v_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_4_max_v_4_we),
    .wd     (adc_chn0_filter_ctl_4_max_v_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[4].max_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[4].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_4_max_v_4_qs)
  );


  // Subregister 5 of Multireg adc_chn0_filter_ctl
  // R[adc_chn0_filter_ctl_5]: V(False)

  // F[min_v_5]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_5_min_v_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_5_min_v_5_we),
    .wd     (adc_chn0_filter_ctl_5_min_v_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[5].min_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[5].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_5_min_v_5_qs)
  );


  // F[cond_5]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn0_filter_ctl_5_cond_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_5_cond_5_we),
    .wd     (adc_chn0_filter_ctl_5_cond_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[5].cond.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[5].cond.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_5_cond_5_qs)
  );


  // F[max_v_5]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_5_max_v_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_5_max_v_5_we),
    .wd     (adc_chn0_filter_ctl_5_max_v_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[5].max_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[5].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_5_max_v_5_qs)
  );


  // Subregister 6 of Multireg adc_chn0_filter_ctl
  // R[adc_chn0_filter_ctl_6]: V(False)

  // F[min_v_6]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_6_min_v_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_6_min_v_6_we),
    .wd     (adc_chn0_filter_ctl_6_min_v_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[6].min_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[6].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_6_min_v_6_qs)
  );


  // F[cond_6]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn0_filter_ctl_6_cond_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_6_cond_6_we),
    .wd     (adc_chn0_filter_ctl_6_cond_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[6].cond.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[6].cond.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_6_cond_6_qs)
  );


  // F[max_v_6]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_6_max_v_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_6_max_v_6_we),
    .wd     (adc_chn0_filter_ctl_6_max_v_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[6].max_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[6].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_6_max_v_6_qs)
  );


  // Subregister 7 of Multireg adc_chn0_filter_ctl
  // R[adc_chn0_filter_ctl_7]: V(False)

  // F[min_v_7]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_7_min_v_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_7_min_v_7_we),
    .wd     (adc_chn0_filter_ctl_7_min_v_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[7].min_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[7].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_7_min_v_7_qs)
  );


  // F[cond_7]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn0_filter_ctl_7_cond_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_7_cond_7_we),
    .wd     (adc_chn0_filter_ctl_7_cond_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[7].cond.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[7].cond.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_7_cond_7_qs)
  );


  // F[max_v_7]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn0_filter_ctl_7_max_v_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn0_filter_ctl_7_max_v_7_we),
    .wd     (adc_chn0_filter_ctl_7_max_v_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn0_filter_ctl[7].max_v.qe),
    .q      (reg2hw.adc_chn0_filter_ctl[7].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn0_filter_ctl_7_max_v_7_qs)
  );




  // Subregister 0 of Multireg adc_chn1_filter_ctl
  // R[adc_chn1_filter_ctl_0]: V(False)

  // F[min_v_0]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_0_min_v_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_0_min_v_0_we),
    .wd     (adc_chn1_filter_ctl_0_min_v_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[0].min_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[0].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_0_min_v_0_qs)
  );


  // F[cond_0]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn1_filter_ctl_0_cond_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_0_cond_0_we),
    .wd     (adc_chn1_filter_ctl_0_cond_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[0].cond.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[0].cond.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_0_cond_0_qs)
  );


  // F[max_v_0]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_0_max_v_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_0_max_v_0_we),
    .wd     (adc_chn1_filter_ctl_0_max_v_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[0].max_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[0].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_0_max_v_0_qs)
  );


  // Subregister 1 of Multireg adc_chn1_filter_ctl
  // R[adc_chn1_filter_ctl_1]: V(False)

  // F[min_v_1]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_1_min_v_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_1_min_v_1_we),
    .wd     (adc_chn1_filter_ctl_1_min_v_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[1].min_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[1].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_1_min_v_1_qs)
  );


  // F[cond_1]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn1_filter_ctl_1_cond_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_1_cond_1_we),
    .wd     (adc_chn1_filter_ctl_1_cond_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[1].cond.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[1].cond.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_1_cond_1_qs)
  );


  // F[max_v_1]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_1_max_v_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_1_max_v_1_we),
    .wd     (adc_chn1_filter_ctl_1_max_v_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[1].max_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[1].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_1_max_v_1_qs)
  );


  // Subregister 2 of Multireg adc_chn1_filter_ctl
  // R[adc_chn1_filter_ctl_2]: V(False)

  // F[min_v_2]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_2_min_v_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_2_min_v_2_we),
    .wd     (adc_chn1_filter_ctl_2_min_v_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[2].min_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[2].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_2_min_v_2_qs)
  );


  // F[cond_2]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn1_filter_ctl_2_cond_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_2_cond_2_we),
    .wd     (adc_chn1_filter_ctl_2_cond_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[2].cond.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[2].cond.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_2_cond_2_qs)
  );


  // F[max_v_2]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_2_max_v_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_2_max_v_2_we),
    .wd     (adc_chn1_filter_ctl_2_max_v_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[2].max_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[2].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_2_max_v_2_qs)
  );


  // Subregister 3 of Multireg adc_chn1_filter_ctl
  // R[adc_chn1_filter_ctl_3]: V(False)

  // F[min_v_3]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_3_min_v_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_3_min_v_3_we),
    .wd     (adc_chn1_filter_ctl_3_min_v_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[3].min_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[3].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_3_min_v_3_qs)
  );


  // F[cond_3]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn1_filter_ctl_3_cond_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_3_cond_3_we),
    .wd     (adc_chn1_filter_ctl_3_cond_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[3].cond.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[3].cond.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_3_cond_3_qs)
  );


  // F[max_v_3]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_3_max_v_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_3_max_v_3_we),
    .wd     (adc_chn1_filter_ctl_3_max_v_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[3].max_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[3].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_3_max_v_3_qs)
  );


  // Subregister 4 of Multireg adc_chn1_filter_ctl
  // R[adc_chn1_filter_ctl_4]: V(False)

  // F[min_v_4]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_4_min_v_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_4_min_v_4_we),
    .wd     (adc_chn1_filter_ctl_4_min_v_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[4].min_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[4].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_4_min_v_4_qs)
  );


  // F[cond_4]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn1_filter_ctl_4_cond_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_4_cond_4_we),
    .wd     (adc_chn1_filter_ctl_4_cond_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[4].cond.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[4].cond.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_4_cond_4_qs)
  );


  // F[max_v_4]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_4_max_v_4 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_4_max_v_4_we),
    .wd     (adc_chn1_filter_ctl_4_max_v_4_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[4].max_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[4].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_4_max_v_4_qs)
  );


  // Subregister 5 of Multireg adc_chn1_filter_ctl
  // R[adc_chn1_filter_ctl_5]: V(False)

  // F[min_v_5]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_5_min_v_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_5_min_v_5_we),
    .wd     (adc_chn1_filter_ctl_5_min_v_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[5].min_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[5].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_5_min_v_5_qs)
  );


  // F[cond_5]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn1_filter_ctl_5_cond_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_5_cond_5_we),
    .wd     (adc_chn1_filter_ctl_5_cond_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[5].cond.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[5].cond.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_5_cond_5_qs)
  );


  // F[max_v_5]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_5_max_v_5 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_5_max_v_5_we),
    .wd     (adc_chn1_filter_ctl_5_max_v_5_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[5].max_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[5].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_5_max_v_5_qs)
  );


  // Subregister 6 of Multireg adc_chn1_filter_ctl
  // R[adc_chn1_filter_ctl_6]: V(False)

  // F[min_v_6]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_6_min_v_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_6_min_v_6_we),
    .wd     (adc_chn1_filter_ctl_6_min_v_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[6].min_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[6].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_6_min_v_6_qs)
  );


  // F[cond_6]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn1_filter_ctl_6_cond_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_6_cond_6_we),
    .wd     (adc_chn1_filter_ctl_6_cond_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[6].cond.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[6].cond.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_6_cond_6_qs)
  );


  // F[max_v_6]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_6_max_v_6 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_6_max_v_6_we),
    .wd     (adc_chn1_filter_ctl_6_max_v_6_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[6].max_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[6].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_6_max_v_6_qs)
  );


  // Subregister 7 of Multireg adc_chn1_filter_ctl
  // R[adc_chn1_filter_ctl_7]: V(False)

  // F[min_v_7]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_7_min_v_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_7_min_v_7_we),
    .wd     (adc_chn1_filter_ctl_7_min_v_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[7].min_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[7].min_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_7_min_v_7_qs)
  );


  // F[cond_7]: 12:12
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_chn1_filter_ctl_7_cond_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_7_cond_7_we),
    .wd     (adc_chn1_filter_ctl_7_cond_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[7].cond.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[7].cond.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_7_cond_7_qs)
  );


  // F[max_v_7]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RW"),
    .RESVAL  (10'h0)
  ) u_adc_chn1_filter_ctl_7_max_v_7 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_chn1_filter_ctl_7_max_v_7_we),
    .wd     (adc_chn1_filter_ctl_7_max_v_7_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.adc_chn1_filter_ctl[7].max_v.qe),
    .q      (reg2hw.adc_chn1_filter_ctl[7].max_v.q ),

    // to register interface (read)
    .qs     (adc_chn1_filter_ctl_7_max_v_7_qs)
  );




  // Subregister 0 of Multireg adc_chn_val
  // R[adc_chn_val_0]: V(False)

  // F[adc_chn_value_ext_0]: 1:0
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RO"),
    .RESVAL  (2'h0)
  ) u_adc_chn_val_0_adc_chn_value_ext_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.adc_chn_val[0].adc_chn_value_ext.de),
    .d      (hw2reg.adc_chn_val[0].adc_chn_value_ext.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_chn_val_0_adc_chn_value_ext_0_qs)
  );


  // F[adc_chn_value_0]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RO"),
    .RESVAL  (10'h0)
  ) u_adc_chn_val_0_adc_chn_value_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.adc_chn_val[0].adc_chn_value.de),
    .d      (hw2reg.adc_chn_val[0].adc_chn_value.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_chn_val_0_adc_chn_value_0_qs)
  );


  // F[adc_chn_value_intr_ext_0]: 17:16
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RO"),
    .RESVAL  (2'h0)
  ) u_adc_chn_val_0_adc_chn_value_intr_ext_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.adc_chn_val[0].adc_chn_value_intr_ext.de),
    .d      (hw2reg.adc_chn_val[0].adc_chn_value_intr_ext.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_chn_val_0_adc_chn_value_intr_ext_0_qs)
  );


  // F[adc_chn_value_intr_0]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RO"),
    .RESVAL  (10'h0)
  ) u_adc_chn_val_0_adc_chn_value_intr_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.adc_chn_val[0].adc_chn_value_intr.de),
    .d      (hw2reg.adc_chn_val[0].adc_chn_value_intr.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_chn_val_0_adc_chn_value_intr_0_qs)
  );


  // Subregister 1 of Multireg adc_chn_val
  // R[adc_chn_val_1]: V(False)

  // F[adc_chn_value_ext_1]: 1:0
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RO"),
    .RESVAL  (2'h0)
  ) u_adc_chn_val_1_adc_chn_value_ext_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.adc_chn_val[1].adc_chn_value_ext.de),
    .d      (hw2reg.adc_chn_val[1].adc_chn_value_ext.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_chn_val_1_adc_chn_value_ext_1_qs)
  );


  // F[adc_chn_value_1]: 11:2
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RO"),
    .RESVAL  (10'h0)
  ) u_adc_chn_val_1_adc_chn_value_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.adc_chn_val[1].adc_chn_value.de),
    .d      (hw2reg.adc_chn_val[1].adc_chn_value.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_chn_val_1_adc_chn_value_1_qs)
  );


  // F[adc_chn_value_intr_ext_1]: 17:16
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RO"),
    .RESVAL  (2'h0)
  ) u_adc_chn_val_1_adc_chn_value_intr_ext_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.adc_chn_val[1].adc_chn_value_intr_ext.de),
    .d      (hw2reg.adc_chn_val[1].adc_chn_value_intr_ext.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_chn_val_1_adc_chn_value_intr_ext_1_qs)
  );


  // F[adc_chn_value_intr_1]: 27:18
  prim_subreg #(
    .DW      (10),
    .SWACCESS("RO"),
    .RESVAL  (10'h0)
  ) u_adc_chn_val_1_adc_chn_value_intr_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    .we     (1'b0),
    .wd     ('0  ),

    // from internal hardware
    .de     (hw2reg.adc_chn_val[1].adc_chn_value_intr.de),
    .d      (hw2reg.adc_chn_val[1].adc_chn_value_intr.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_chn_val_1_adc_chn_value_intr_1_qs)
  );



  // R[adc_wakeup_ctl]: V(False)

  //   F[chn0_1_filter0_en]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_ctl_chn0_1_filter0_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_ctl_chn0_1_filter0_en_we),
    .wd     (adc_wakeup_ctl_chn0_1_filter0_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_wakeup_ctl.chn0_1_filter0_en.q ),

    // to register interface (read)
    .qs     (adc_wakeup_ctl_chn0_1_filter0_en_qs)
  );


  //   F[chn0_1_filter1_en]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_ctl_chn0_1_filter1_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_ctl_chn0_1_filter1_en_we),
    .wd     (adc_wakeup_ctl_chn0_1_filter1_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_wakeup_ctl.chn0_1_filter1_en.q ),

    // to register interface (read)
    .qs     (adc_wakeup_ctl_chn0_1_filter1_en_qs)
  );


  //   F[chn0_1_filter2_en]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_ctl_chn0_1_filter2_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_ctl_chn0_1_filter2_en_we),
    .wd     (adc_wakeup_ctl_chn0_1_filter2_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_wakeup_ctl.chn0_1_filter2_en.q ),

    // to register interface (read)
    .qs     (adc_wakeup_ctl_chn0_1_filter2_en_qs)
  );


  //   F[chn0_1_filter3_en]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_ctl_chn0_1_filter3_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_ctl_chn0_1_filter3_en_we),
    .wd     (adc_wakeup_ctl_chn0_1_filter3_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_wakeup_ctl.chn0_1_filter3_en.q ),

    // to register interface (read)
    .qs     (adc_wakeup_ctl_chn0_1_filter3_en_qs)
  );


  //   F[chn0_1_filter4_en]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_ctl_chn0_1_filter4_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_ctl_chn0_1_filter4_en_we),
    .wd     (adc_wakeup_ctl_chn0_1_filter4_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_wakeup_ctl.chn0_1_filter4_en.q ),

    // to register interface (read)
    .qs     (adc_wakeup_ctl_chn0_1_filter4_en_qs)
  );


  //   F[chn0_1_filter5_en]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_ctl_chn0_1_filter5_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_ctl_chn0_1_filter5_en_we),
    .wd     (adc_wakeup_ctl_chn0_1_filter5_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_wakeup_ctl.chn0_1_filter5_en.q ),

    // to register interface (read)
    .qs     (adc_wakeup_ctl_chn0_1_filter5_en_qs)
  );


  //   F[chn0_1_filter6_en]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_ctl_chn0_1_filter6_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_ctl_chn0_1_filter6_en_we),
    .wd     (adc_wakeup_ctl_chn0_1_filter6_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_wakeup_ctl.chn0_1_filter6_en.q ),

    // to register interface (read)
    .qs     (adc_wakeup_ctl_chn0_1_filter6_en_qs)
  );


  //   F[chn0_1_filter7_en]: 7:7
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_ctl_chn0_1_filter7_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_ctl_chn0_1_filter7_en_we),
    .wd     (adc_wakeup_ctl_chn0_1_filter7_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_wakeup_ctl.chn0_1_filter7_en.q ),

    // to register interface (read)
    .qs     (adc_wakeup_ctl_chn0_1_filter7_en_qs)
  );


  // R[adc_wakeup_status]: V(False)

  //   F[cc_sink_det]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_status_cc_sink_det (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_status_cc_sink_det_we),
    .wd     (adc_wakeup_status_cc_sink_det_wd),

    // from internal hardware
    .de     (hw2reg.adc_wakeup_status.cc_sink_det.de),
    .d      (hw2reg.adc_wakeup_status.cc_sink_det.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_wakeup_status_cc_sink_det_qs)
  );


  //   F[cc_1a5_sink_det]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_status_cc_1a5_sink_det (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_status_cc_1a5_sink_det_we),
    .wd     (adc_wakeup_status_cc_1a5_sink_det_wd),

    // from internal hardware
    .de     (hw2reg.adc_wakeup_status.cc_1a5_sink_det.de),
    .d      (hw2reg.adc_wakeup_status.cc_1a5_sink_det.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_wakeup_status_cc_1a5_sink_det_qs)
  );


  //   F[cc_3a0_sink_det]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_status_cc_3a0_sink_det (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_status_cc_3a0_sink_det_we),
    .wd     (adc_wakeup_status_cc_3a0_sink_det_wd),

    // from internal hardware
    .de     (hw2reg.adc_wakeup_status.cc_3a0_sink_det.de),
    .d      (hw2reg.adc_wakeup_status.cc_3a0_sink_det.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_wakeup_status_cc_3a0_sink_det_qs)
  );


  //   F[cc_src_det]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_status_cc_src_det (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_status_cc_src_det_we),
    .wd     (adc_wakeup_status_cc_src_det_wd),

    // from internal hardware
    .de     (hw2reg.adc_wakeup_status.cc_src_det.de),
    .d      (hw2reg.adc_wakeup_status.cc_src_det.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_wakeup_status_cc_src_det_qs)
  );


  //   F[cc_1a5_src_det]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_status_cc_1a5_src_det (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_status_cc_1a5_src_det_we),
    .wd     (adc_wakeup_status_cc_1a5_src_det_wd),

    // from internal hardware
    .de     (hw2reg.adc_wakeup_status.cc_1a5_src_det.de),
    .d      (hw2reg.adc_wakeup_status.cc_1a5_src_det.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_wakeup_status_cc_1a5_src_det_qs)
  );


  //   F[cc_src_det_flip]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_status_cc_src_det_flip (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_status_cc_src_det_flip_we),
    .wd     (adc_wakeup_status_cc_src_det_flip_wd),

    // from internal hardware
    .de     (hw2reg.adc_wakeup_status.cc_src_det_flip.de),
    .d      (hw2reg.adc_wakeup_status.cc_src_det_flip.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_wakeup_status_cc_src_det_flip_qs)
  );


  //   F[cc_1a5_src_det_flip]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_status_cc_1a5_src_det_flip (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_status_cc_1a5_src_det_flip_we),
    .wd     (adc_wakeup_status_cc_1a5_src_det_flip_wd),

    // from internal hardware
    .de     (hw2reg.adc_wakeup_status.cc_1a5_src_det_flip.de),
    .d      (hw2reg.adc_wakeup_status.cc_1a5_src_det_flip.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_wakeup_status_cc_1a5_src_det_flip_qs)
  );


  //   F[cc_discon]: 7:7
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_wakeup_status_cc_discon (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_wakeup_status_cc_discon_we),
    .wd     (adc_wakeup_status_cc_discon_wd),

    // from internal hardware
    .de     (hw2reg.adc_wakeup_status.cc_discon.de),
    .d      (hw2reg.adc_wakeup_status.cc_discon.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_wakeup_status_cc_discon_qs)
  );


  // R[adc_intr_ctl]: V(False)

  //   F[chn0_1_filter0_en]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_intr_ctl_chn0_1_filter0_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_ctl_chn0_1_filter0_en_we),
    .wd     (adc_intr_ctl_chn0_1_filter0_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_intr_ctl.chn0_1_filter0_en.q ),

    // to register interface (read)
    .qs     (adc_intr_ctl_chn0_1_filter0_en_qs)
  );


  //   F[chn0_1_filter1_en]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_intr_ctl_chn0_1_filter1_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_ctl_chn0_1_filter1_en_we),
    .wd     (adc_intr_ctl_chn0_1_filter1_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_intr_ctl.chn0_1_filter1_en.q ),

    // to register interface (read)
    .qs     (adc_intr_ctl_chn0_1_filter1_en_qs)
  );


  //   F[chn0_1_filter2_en]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_intr_ctl_chn0_1_filter2_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_ctl_chn0_1_filter2_en_we),
    .wd     (adc_intr_ctl_chn0_1_filter2_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_intr_ctl.chn0_1_filter2_en.q ),

    // to register interface (read)
    .qs     (adc_intr_ctl_chn0_1_filter2_en_qs)
  );


  //   F[chn0_1_filter3_en]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_intr_ctl_chn0_1_filter3_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_ctl_chn0_1_filter3_en_we),
    .wd     (adc_intr_ctl_chn0_1_filter3_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_intr_ctl.chn0_1_filter3_en.q ),

    // to register interface (read)
    .qs     (adc_intr_ctl_chn0_1_filter3_en_qs)
  );


  //   F[chn0_1_filter4_en]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_intr_ctl_chn0_1_filter4_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_ctl_chn0_1_filter4_en_we),
    .wd     (adc_intr_ctl_chn0_1_filter4_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_intr_ctl.chn0_1_filter4_en.q ),

    // to register interface (read)
    .qs     (adc_intr_ctl_chn0_1_filter4_en_qs)
  );


  //   F[chn0_1_filter5_en]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_intr_ctl_chn0_1_filter5_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_ctl_chn0_1_filter5_en_we),
    .wd     (adc_intr_ctl_chn0_1_filter5_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_intr_ctl.chn0_1_filter5_en.q ),

    // to register interface (read)
    .qs     (adc_intr_ctl_chn0_1_filter5_en_qs)
  );


  //   F[chn0_1_filter6_en]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_intr_ctl_chn0_1_filter6_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_ctl_chn0_1_filter6_en_we),
    .wd     (adc_intr_ctl_chn0_1_filter6_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_intr_ctl.chn0_1_filter6_en.q ),

    // to register interface (read)
    .qs     (adc_intr_ctl_chn0_1_filter6_en_qs)
  );


  //   F[chn0_1_filter7_en]: 7:7
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_intr_ctl_chn0_1_filter7_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_ctl_chn0_1_filter7_en_we),
    .wd     (adc_intr_ctl_chn0_1_filter7_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_intr_ctl.chn0_1_filter7_en.q ),

    // to register interface (read)
    .qs     (adc_intr_ctl_chn0_1_filter7_en_qs)
  );


  //   F[oneshot_intr_en]: 8:8
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_adc_intr_ctl_oneshot_intr_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_ctl_oneshot_intr_en_we),
    .wd     (adc_intr_ctl_oneshot_intr_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.adc_intr_ctl.oneshot_intr_en.q ),

    // to register interface (read)
    .qs     (adc_intr_ctl_oneshot_intr_en_qs)
  );


  // R[adc_intr_status]: V(False)

  //   F[cc_sink_det]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_intr_status_cc_sink_det (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_status_cc_sink_det_we),
    .wd     (adc_intr_status_cc_sink_det_wd),

    // from internal hardware
    .de     (hw2reg.adc_intr_status.cc_sink_det.de),
    .d      (hw2reg.adc_intr_status.cc_sink_det.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_intr_status_cc_sink_det_qs)
  );


  //   F[cc_1a5_sink_det]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_intr_status_cc_1a5_sink_det (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_status_cc_1a5_sink_det_we),
    .wd     (adc_intr_status_cc_1a5_sink_det_wd),

    // from internal hardware
    .de     (hw2reg.adc_intr_status.cc_1a5_sink_det.de),
    .d      (hw2reg.adc_intr_status.cc_1a5_sink_det.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_intr_status_cc_1a5_sink_det_qs)
  );


  //   F[cc_3a0_sink_det]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_intr_status_cc_3a0_sink_det (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_status_cc_3a0_sink_det_we),
    .wd     (adc_intr_status_cc_3a0_sink_det_wd),

    // from internal hardware
    .de     (hw2reg.adc_intr_status.cc_3a0_sink_det.de),
    .d      (hw2reg.adc_intr_status.cc_3a0_sink_det.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_intr_status_cc_3a0_sink_det_qs)
  );


  //   F[cc_src_det]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_intr_status_cc_src_det (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_status_cc_src_det_we),
    .wd     (adc_intr_status_cc_src_det_wd),

    // from internal hardware
    .de     (hw2reg.adc_intr_status.cc_src_det.de),
    .d      (hw2reg.adc_intr_status.cc_src_det.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_intr_status_cc_src_det_qs)
  );


  //   F[cc_1a5_src_det]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_intr_status_cc_1a5_src_det (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_status_cc_1a5_src_det_we),
    .wd     (adc_intr_status_cc_1a5_src_det_wd),

    // from internal hardware
    .de     (hw2reg.adc_intr_status.cc_1a5_src_det.de),
    .d      (hw2reg.adc_intr_status.cc_1a5_src_det.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_intr_status_cc_1a5_src_det_qs)
  );


  //   F[cc_src_det_flip]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_intr_status_cc_src_det_flip (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_status_cc_src_det_flip_we),
    .wd     (adc_intr_status_cc_src_det_flip_wd),

    // from internal hardware
    .de     (hw2reg.adc_intr_status.cc_src_det_flip.de),
    .d      (hw2reg.adc_intr_status.cc_src_det_flip.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_intr_status_cc_src_det_flip_qs)
  );


  //   F[cc_1a5_src_det_flip]: 6:6
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_intr_status_cc_1a5_src_det_flip (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_status_cc_1a5_src_det_flip_we),
    .wd     (adc_intr_status_cc_1a5_src_det_flip_wd),

    // from internal hardware
    .de     (hw2reg.adc_intr_status.cc_1a5_src_det_flip.de),
    .d      (hw2reg.adc_intr_status.cc_1a5_src_det_flip.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_intr_status_cc_1a5_src_det_flip_qs)
  );


  //   F[cc_discon]: 7:7
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_intr_status_cc_discon (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_status_cc_discon_we),
    .wd     (adc_intr_status_cc_discon_wd),

    // from internal hardware
    .de     (hw2reg.adc_intr_status.cc_discon.de),
    .d      (hw2reg.adc_intr_status.cc_discon.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_intr_status_cc_discon_qs)
  );


  //   F[oneshot]: 8:8
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_adc_intr_status_oneshot (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (adc_intr_status_oneshot_we),
    .wd     (adc_intr_status_oneshot_wd),

    // from internal hardware
    .de     (hw2reg.adc_intr_status.oneshot.de),
    .d      (hw2reg.adc_intr_status.oneshot.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (adc_intr_status_oneshot_qs)
  );




  logic [29:0] addr_hit;
  always_comb begin
    addr_hit = '0;
    addr_hit[ 0] = (reg_addr == DCD_INTR_STATE_OFFSET);
    addr_hit[ 1] = (reg_addr == DCD_INTR_ENABLE_OFFSET);
    addr_hit[ 2] = (reg_addr == DCD_INTR_TEST_OFFSET);
    addr_hit[ 3] = (reg_addr == DCD_ADC_EN_CTL_OFFSET);
    addr_hit[ 4] = (reg_addr == DCD_ADC_PD_CTL_OFFSET);
    addr_hit[ 5] = (reg_addr == DCD_ADC_LP_SAMPLE_CTL_OFFSET);
    addr_hit[ 6] = (reg_addr == DCD_ADC_SAMPLE_CTL_OFFSET);
    addr_hit[ 7] = (reg_addr == DCD_ADC_FSM_RST_OFFSET);
    addr_hit[ 8] = (reg_addr == DCD_ADC_CHN0_FILTER_CTL_0_OFFSET);
    addr_hit[ 9] = (reg_addr == DCD_ADC_CHN0_FILTER_CTL_1_OFFSET);
    addr_hit[10] = (reg_addr == DCD_ADC_CHN0_FILTER_CTL_2_OFFSET);
    addr_hit[11] = (reg_addr == DCD_ADC_CHN0_FILTER_CTL_3_OFFSET);
    addr_hit[12] = (reg_addr == DCD_ADC_CHN0_FILTER_CTL_4_OFFSET);
    addr_hit[13] = (reg_addr == DCD_ADC_CHN0_FILTER_CTL_5_OFFSET);
    addr_hit[14] = (reg_addr == DCD_ADC_CHN0_FILTER_CTL_6_OFFSET);
    addr_hit[15] = (reg_addr == DCD_ADC_CHN0_FILTER_CTL_7_OFFSET);
    addr_hit[16] = (reg_addr == DCD_ADC_CHN1_FILTER_CTL_0_OFFSET);
    addr_hit[17] = (reg_addr == DCD_ADC_CHN1_FILTER_CTL_1_OFFSET);
    addr_hit[18] = (reg_addr == DCD_ADC_CHN1_FILTER_CTL_2_OFFSET);
    addr_hit[19] = (reg_addr == DCD_ADC_CHN1_FILTER_CTL_3_OFFSET);
    addr_hit[20] = (reg_addr == DCD_ADC_CHN1_FILTER_CTL_4_OFFSET);
    addr_hit[21] = (reg_addr == DCD_ADC_CHN1_FILTER_CTL_5_OFFSET);
    addr_hit[22] = (reg_addr == DCD_ADC_CHN1_FILTER_CTL_6_OFFSET);
    addr_hit[23] = (reg_addr == DCD_ADC_CHN1_FILTER_CTL_7_OFFSET);
    addr_hit[24] = (reg_addr == DCD_ADC_CHN_VAL_0_OFFSET);
    addr_hit[25] = (reg_addr == DCD_ADC_CHN_VAL_1_OFFSET);
    addr_hit[26] = (reg_addr == DCD_ADC_WAKEUP_CTL_OFFSET);
    addr_hit[27] = (reg_addr == DCD_ADC_WAKEUP_STATUS_OFFSET);
    addr_hit[28] = (reg_addr == DCD_ADC_INTR_CTL_OFFSET);
    addr_hit[29] = (reg_addr == DCD_ADC_INTR_STATUS_OFFSET);
  end

  assign addrmiss = (reg_re || reg_we) ? ~|addr_hit : 1'b0 ;

  // Check sub-word write is permitted
  always_comb begin
    wr_err = 1'b0;
    if (addr_hit[ 0] && reg_we && (DCD_PERMIT[ 0] != (DCD_PERMIT[ 0] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 1] && reg_we && (DCD_PERMIT[ 1] != (DCD_PERMIT[ 1] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 2] && reg_we && (DCD_PERMIT[ 2] != (DCD_PERMIT[ 2] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 3] && reg_we && (DCD_PERMIT[ 3] != (DCD_PERMIT[ 3] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 4] && reg_we && (DCD_PERMIT[ 4] != (DCD_PERMIT[ 4] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 5] && reg_we && (DCD_PERMIT[ 5] != (DCD_PERMIT[ 5] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 6] && reg_we && (DCD_PERMIT[ 6] != (DCD_PERMIT[ 6] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 7] && reg_we && (DCD_PERMIT[ 7] != (DCD_PERMIT[ 7] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 8] && reg_we && (DCD_PERMIT[ 8] != (DCD_PERMIT[ 8] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 9] && reg_we && (DCD_PERMIT[ 9] != (DCD_PERMIT[ 9] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[10] && reg_we && (DCD_PERMIT[10] != (DCD_PERMIT[10] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[11] && reg_we && (DCD_PERMIT[11] != (DCD_PERMIT[11] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[12] && reg_we && (DCD_PERMIT[12] != (DCD_PERMIT[12] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[13] && reg_we && (DCD_PERMIT[13] != (DCD_PERMIT[13] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[14] && reg_we && (DCD_PERMIT[14] != (DCD_PERMIT[14] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[15] && reg_we && (DCD_PERMIT[15] != (DCD_PERMIT[15] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[16] && reg_we && (DCD_PERMIT[16] != (DCD_PERMIT[16] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[17] && reg_we && (DCD_PERMIT[17] != (DCD_PERMIT[17] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[18] && reg_we && (DCD_PERMIT[18] != (DCD_PERMIT[18] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[19] && reg_we && (DCD_PERMIT[19] != (DCD_PERMIT[19] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[20] && reg_we && (DCD_PERMIT[20] != (DCD_PERMIT[20] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[21] && reg_we && (DCD_PERMIT[21] != (DCD_PERMIT[21] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[22] && reg_we && (DCD_PERMIT[22] != (DCD_PERMIT[22] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[23] && reg_we && (DCD_PERMIT[23] != (DCD_PERMIT[23] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[24] && reg_we && (DCD_PERMIT[24] != (DCD_PERMIT[24] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[25] && reg_we && (DCD_PERMIT[25] != (DCD_PERMIT[25] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[26] && reg_we && (DCD_PERMIT[26] != (DCD_PERMIT[26] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[27] && reg_we && (DCD_PERMIT[27] != (DCD_PERMIT[27] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[28] && reg_we && (DCD_PERMIT[28] != (DCD_PERMIT[28] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[29] && reg_we && (DCD_PERMIT[29] != (DCD_PERMIT[29] & reg_be))) wr_err = 1'b1 ;
  end

  assign intr_state_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_wd = reg_wdata[0];

  assign intr_enable_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_wd = reg_wdata[0];

  assign intr_test_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_wd = reg_wdata[0];

  assign adc_en_ctl_adc_enable_we = addr_hit[3] & reg_we & !reg_error;
  assign adc_en_ctl_adc_enable_wd = reg_wdata[0];

  assign adc_en_ctl_oneshot_mode_we = addr_hit[3] & reg_we & !reg_error;
  assign adc_en_ctl_oneshot_mode_wd = reg_wdata[1];

  assign adc_pd_ctl_lp_mode_we = addr_hit[4] & reg_we & !reg_error;
  assign adc_pd_ctl_lp_mode_wd = reg_wdata[0];

  assign adc_pd_ctl_pwrup_time_we = addr_hit[4] & reg_we & !reg_error;
  assign adc_pd_ctl_pwrup_time_wd = reg_wdata[7:4];

  assign adc_pd_ctl_wakeup_time_we = addr_hit[4] & reg_we & !reg_error;
  assign adc_pd_ctl_wakeup_time_wd = reg_wdata[31:8];

  assign adc_lp_sample_ctl_we = addr_hit[5] & reg_we & !reg_error;
  assign adc_lp_sample_ctl_wd = reg_wdata[7:0];

  assign adc_sample_ctl_we = addr_hit[6] & reg_we & !reg_error;
  assign adc_sample_ctl_wd = reg_wdata[15:0];

  assign adc_fsm_rst_we = addr_hit[7] & reg_we & !reg_error;
  assign adc_fsm_rst_wd = reg_wdata[0];

  assign adc_chn0_filter_ctl_0_min_v_0_we = addr_hit[8] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_0_min_v_0_wd = reg_wdata[11:2];

  assign adc_chn0_filter_ctl_0_cond_0_we = addr_hit[8] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_0_cond_0_wd = reg_wdata[12];

  assign adc_chn0_filter_ctl_0_max_v_0_we = addr_hit[8] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_0_max_v_0_wd = reg_wdata[27:18];

  assign adc_chn0_filter_ctl_1_min_v_1_we = addr_hit[9] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_1_min_v_1_wd = reg_wdata[11:2];

  assign adc_chn0_filter_ctl_1_cond_1_we = addr_hit[9] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_1_cond_1_wd = reg_wdata[12];

  assign adc_chn0_filter_ctl_1_max_v_1_we = addr_hit[9] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_1_max_v_1_wd = reg_wdata[27:18];

  assign adc_chn0_filter_ctl_2_min_v_2_we = addr_hit[10] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_2_min_v_2_wd = reg_wdata[11:2];

  assign adc_chn0_filter_ctl_2_cond_2_we = addr_hit[10] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_2_cond_2_wd = reg_wdata[12];

  assign adc_chn0_filter_ctl_2_max_v_2_we = addr_hit[10] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_2_max_v_2_wd = reg_wdata[27:18];

  assign adc_chn0_filter_ctl_3_min_v_3_we = addr_hit[11] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_3_min_v_3_wd = reg_wdata[11:2];

  assign adc_chn0_filter_ctl_3_cond_3_we = addr_hit[11] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_3_cond_3_wd = reg_wdata[12];

  assign adc_chn0_filter_ctl_3_max_v_3_we = addr_hit[11] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_3_max_v_3_wd = reg_wdata[27:18];

  assign adc_chn0_filter_ctl_4_min_v_4_we = addr_hit[12] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_4_min_v_4_wd = reg_wdata[11:2];

  assign adc_chn0_filter_ctl_4_cond_4_we = addr_hit[12] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_4_cond_4_wd = reg_wdata[12];

  assign adc_chn0_filter_ctl_4_max_v_4_we = addr_hit[12] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_4_max_v_4_wd = reg_wdata[27:18];

  assign adc_chn0_filter_ctl_5_min_v_5_we = addr_hit[13] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_5_min_v_5_wd = reg_wdata[11:2];

  assign adc_chn0_filter_ctl_5_cond_5_we = addr_hit[13] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_5_cond_5_wd = reg_wdata[12];

  assign adc_chn0_filter_ctl_5_max_v_5_we = addr_hit[13] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_5_max_v_5_wd = reg_wdata[27:18];

  assign adc_chn0_filter_ctl_6_min_v_6_we = addr_hit[14] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_6_min_v_6_wd = reg_wdata[11:2];

  assign adc_chn0_filter_ctl_6_cond_6_we = addr_hit[14] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_6_cond_6_wd = reg_wdata[12];

  assign adc_chn0_filter_ctl_6_max_v_6_we = addr_hit[14] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_6_max_v_6_wd = reg_wdata[27:18];

  assign adc_chn0_filter_ctl_7_min_v_7_we = addr_hit[15] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_7_min_v_7_wd = reg_wdata[11:2];

  assign adc_chn0_filter_ctl_7_cond_7_we = addr_hit[15] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_7_cond_7_wd = reg_wdata[12];

  assign adc_chn0_filter_ctl_7_max_v_7_we = addr_hit[15] & reg_we & !reg_error;
  assign adc_chn0_filter_ctl_7_max_v_7_wd = reg_wdata[27:18];

  assign adc_chn1_filter_ctl_0_min_v_0_we = addr_hit[16] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_0_min_v_0_wd = reg_wdata[11:2];

  assign adc_chn1_filter_ctl_0_cond_0_we = addr_hit[16] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_0_cond_0_wd = reg_wdata[12];

  assign adc_chn1_filter_ctl_0_max_v_0_we = addr_hit[16] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_0_max_v_0_wd = reg_wdata[27:18];

  assign adc_chn1_filter_ctl_1_min_v_1_we = addr_hit[17] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_1_min_v_1_wd = reg_wdata[11:2];

  assign adc_chn1_filter_ctl_1_cond_1_we = addr_hit[17] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_1_cond_1_wd = reg_wdata[12];

  assign adc_chn1_filter_ctl_1_max_v_1_we = addr_hit[17] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_1_max_v_1_wd = reg_wdata[27:18];

  assign adc_chn1_filter_ctl_2_min_v_2_we = addr_hit[18] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_2_min_v_2_wd = reg_wdata[11:2];

  assign adc_chn1_filter_ctl_2_cond_2_we = addr_hit[18] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_2_cond_2_wd = reg_wdata[12];

  assign adc_chn1_filter_ctl_2_max_v_2_we = addr_hit[18] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_2_max_v_2_wd = reg_wdata[27:18];

  assign adc_chn1_filter_ctl_3_min_v_3_we = addr_hit[19] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_3_min_v_3_wd = reg_wdata[11:2];

  assign adc_chn1_filter_ctl_3_cond_3_we = addr_hit[19] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_3_cond_3_wd = reg_wdata[12];

  assign adc_chn1_filter_ctl_3_max_v_3_we = addr_hit[19] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_3_max_v_3_wd = reg_wdata[27:18];

  assign adc_chn1_filter_ctl_4_min_v_4_we = addr_hit[20] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_4_min_v_4_wd = reg_wdata[11:2];

  assign adc_chn1_filter_ctl_4_cond_4_we = addr_hit[20] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_4_cond_4_wd = reg_wdata[12];

  assign adc_chn1_filter_ctl_4_max_v_4_we = addr_hit[20] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_4_max_v_4_wd = reg_wdata[27:18];

  assign adc_chn1_filter_ctl_5_min_v_5_we = addr_hit[21] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_5_min_v_5_wd = reg_wdata[11:2];

  assign adc_chn1_filter_ctl_5_cond_5_we = addr_hit[21] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_5_cond_5_wd = reg_wdata[12];

  assign adc_chn1_filter_ctl_5_max_v_5_we = addr_hit[21] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_5_max_v_5_wd = reg_wdata[27:18];

  assign adc_chn1_filter_ctl_6_min_v_6_we = addr_hit[22] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_6_min_v_6_wd = reg_wdata[11:2];

  assign adc_chn1_filter_ctl_6_cond_6_we = addr_hit[22] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_6_cond_6_wd = reg_wdata[12];

  assign adc_chn1_filter_ctl_6_max_v_6_we = addr_hit[22] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_6_max_v_6_wd = reg_wdata[27:18];

  assign adc_chn1_filter_ctl_7_min_v_7_we = addr_hit[23] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_7_min_v_7_wd = reg_wdata[11:2];

  assign adc_chn1_filter_ctl_7_cond_7_we = addr_hit[23] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_7_cond_7_wd = reg_wdata[12];

  assign adc_chn1_filter_ctl_7_max_v_7_we = addr_hit[23] & reg_we & !reg_error;
  assign adc_chn1_filter_ctl_7_max_v_7_wd = reg_wdata[27:18];

  assign adc_wakeup_ctl_chn0_1_filter0_en_we = addr_hit[26] & reg_we & !reg_error;
  assign adc_wakeup_ctl_chn0_1_filter0_en_wd = reg_wdata[0];

  assign adc_wakeup_ctl_chn0_1_filter1_en_we = addr_hit[26] & reg_we & !reg_error;
  assign adc_wakeup_ctl_chn0_1_filter1_en_wd = reg_wdata[1];

  assign adc_wakeup_ctl_chn0_1_filter2_en_we = addr_hit[26] & reg_we & !reg_error;
  assign adc_wakeup_ctl_chn0_1_filter2_en_wd = reg_wdata[2];

  assign adc_wakeup_ctl_chn0_1_filter3_en_we = addr_hit[26] & reg_we & !reg_error;
  assign adc_wakeup_ctl_chn0_1_filter3_en_wd = reg_wdata[3];

  assign adc_wakeup_ctl_chn0_1_filter4_en_we = addr_hit[26] & reg_we & !reg_error;
  assign adc_wakeup_ctl_chn0_1_filter4_en_wd = reg_wdata[4];

  assign adc_wakeup_ctl_chn0_1_filter5_en_we = addr_hit[26] & reg_we & !reg_error;
  assign adc_wakeup_ctl_chn0_1_filter5_en_wd = reg_wdata[5];

  assign adc_wakeup_ctl_chn0_1_filter6_en_we = addr_hit[26] & reg_we & !reg_error;
  assign adc_wakeup_ctl_chn0_1_filter6_en_wd = reg_wdata[6];

  assign adc_wakeup_ctl_chn0_1_filter7_en_we = addr_hit[26] & reg_we & !reg_error;
  assign adc_wakeup_ctl_chn0_1_filter7_en_wd = reg_wdata[7];

  assign adc_wakeup_status_cc_sink_det_we = addr_hit[27] & reg_we & !reg_error;
  assign adc_wakeup_status_cc_sink_det_wd = reg_wdata[0];

  assign adc_wakeup_status_cc_1a5_sink_det_we = addr_hit[27] & reg_we & !reg_error;
  assign adc_wakeup_status_cc_1a5_sink_det_wd = reg_wdata[1];

  assign adc_wakeup_status_cc_3a0_sink_det_we = addr_hit[27] & reg_we & !reg_error;
  assign adc_wakeup_status_cc_3a0_sink_det_wd = reg_wdata[2];

  assign adc_wakeup_status_cc_src_det_we = addr_hit[27] & reg_we & !reg_error;
  assign adc_wakeup_status_cc_src_det_wd = reg_wdata[3];

  assign adc_wakeup_status_cc_1a5_src_det_we = addr_hit[27] & reg_we & !reg_error;
  assign adc_wakeup_status_cc_1a5_src_det_wd = reg_wdata[4];

  assign adc_wakeup_status_cc_src_det_flip_we = addr_hit[27] & reg_we & !reg_error;
  assign adc_wakeup_status_cc_src_det_flip_wd = reg_wdata[5];

  assign adc_wakeup_status_cc_1a5_src_det_flip_we = addr_hit[27] & reg_we & !reg_error;
  assign adc_wakeup_status_cc_1a5_src_det_flip_wd = reg_wdata[6];

  assign adc_wakeup_status_cc_discon_we = addr_hit[27] & reg_we & !reg_error;
  assign adc_wakeup_status_cc_discon_wd = reg_wdata[7];

  assign adc_intr_ctl_chn0_1_filter0_en_we = addr_hit[28] & reg_we & !reg_error;
  assign adc_intr_ctl_chn0_1_filter0_en_wd = reg_wdata[0];

  assign adc_intr_ctl_chn0_1_filter1_en_we = addr_hit[28] & reg_we & !reg_error;
  assign adc_intr_ctl_chn0_1_filter1_en_wd = reg_wdata[1];

  assign adc_intr_ctl_chn0_1_filter2_en_we = addr_hit[28] & reg_we & !reg_error;
  assign adc_intr_ctl_chn0_1_filter2_en_wd = reg_wdata[2];

  assign adc_intr_ctl_chn0_1_filter3_en_we = addr_hit[28] & reg_we & !reg_error;
  assign adc_intr_ctl_chn0_1_filter3_en_wd = reg_wdata[3];

  assign adc_intr_ctl_chn0_1_filter4_en_we = addr_hit[28] & reg_we & !reg_error;
  assign adc_intr_ctl_chn0_1_filter4_en_wd = reg_wdata[4];

  assign adc_intr_ctl_chn0_1_filter5_en_we = addr_hit[28] & reg_we & !reg_error;
  assign adc_intr_ctl_chn0_1_filter5_en_wd = reg_wdata[5];

  assign adc_intr_ctl_chn0_1_filter6_en_we = addr_hit[28] & reg_we & !reg_error;
  assign adc_intr_ctl_chn0_1_filter6_en_wd = reg_wdata[6];

  assign adc_intr_ctl_chn0_1_filter7_en_we = addr_hit[28] & reg_we & !reg_error;
  assign adc_intr_ctl_chn0_1_filter7_en_wd = reg_wdata[7];

  assign adc_intr_ctl_oneshot_intr_en_we = addr_hit[28] & reg_we & !reg_error;
  assign adc_intr_ctl_oneshot_intr_en_wd = reg_wdata[8];

  assign adc_intr_status_cc_sink_det_we = addr_hit[29] & reg_we & !reg_error;
  assign adc_intr_status_cc_sink_det_wd = reg_wdata[0];

  assign adc_intr_status_cc_1a5_sink_det_we = addr_hit[29] & reg_we & !reg_error;
  assign adc_intr_status_cc_1a5_sink_det_wd = reg_wdata[1];

  assign adc_intr_status_cc_3a0_sink_det_we = addr_hit[29] & reg_we & !reg_error;
  assign adc_intr_status_cc_3a0_sink_det_wd = reg_wdata[2];

  assign adc_intr_status_cc_src_det_we = addr_hit[29] & reg_we & !reg_error;
  assign adc_intr_status_cc_src_det_wd = reg_wdata[3];

  assign adc_intr_status_cc_1a5_src_det_we = addr_hit[29] & reg_we & !reg_error;
  assign adc_intr_status_cc_1a5_src_det_wd = reg_wdata[4];

  assign adc_intr_status_cc_src_det_flip_we = addr_hit[29] & reg_we & !reg_error;
  assign adc_intr_status_cc_src_det_flip_wd = reg_wdata[5];

  assign adc_intr_status_cc_1a5_src_det_flip_we = addr_hit[29] & reg_we & !reg_error;
  assign adc_intr_status_cc_1a5_src_det_flip_wd = reg_wdata[6];

  assign adc_intr_status_cc_discon_we = addr_hit[29] & reg_we & !reg_error;
  assign adc_intr_status_cc_discon_wd = reg_wdata[7];

  assign adc_intr_status_oneshot_we = addr_hit[29] & reg_we & !reg_error;
  assign adc_intr_status_oneshot_wd = reg_wdata[8];

  // Read data return
  always_comb begin
    reg_rdata_next = '0;
    unique case (1'b1)
      addr_hit[0]: begin
        reg_rdata_next[0] = intr_state_qs;
      end

      addr_hit[1]: begin
        reg_rdata_next[0] = intr_enable_qs;
      end

      addr_hit[2]: begin
        reg_rdata_next[0] = '0;
      end

      addr_hit[3]: begin
        reg_rdata_next[0] = adc_en_ctl_adc_enable_qs;
        reg_rdata_next[1] = adc_en_ctl_oneshot_mode_qs;
      end

      addr_hit[4]: begin
        reg_rdata_next[0] = adc_pd_ctl_lp_mode_qs;
        reg_rdata_next[7:4] = adc_pd_ctl_pwrup_time_qs;
        reg_rdata_next[31:8] = adc_pd_ctl_wakeup_time_qs;
      end

      addr_hit[5]: begin
        reg_rdata_next[7:0] = adc_lp_sample_ctl_qs;
      end

      addr_hit[6]: begin
        reg_rdata_next[15:0] = adc_sample_ctl_qs;
      end

      addr_hit[7]: begin
        reg_rdata_next[0] = adc_fsm_rst_qs;
      end

      addr_hit[8]: begin
        reg_rdata_next[11:2] = adc_chn0_filter_ctl_0_min_v_0_qs;
        reg_rdata_next[12] = adc_chn0_filter_ctl_0_cond_0_qs;
        reg_rdata_next[27:18] = adc_chn0_filter_ctl_0_max_v_0_qs;
      end

      addr_hit[9]: begin
        reg_rdata_next[11:2] = adc_chn0_filter_ctl_1_min_v_1_qs;
        reg_rdata_next[12] = adc_chn0_filter_ctl_1_cond_1_qs;
        reg_rdata_next[27:18] = adc_chn0_filter_ctl_1_max_v_1_qs;
      end

      addr_hit[10]: begin
        reg_rdata_next[11:2] = adc_chn0_filter_ctl_2_min_v_2_qs;
        reg_rdata_next[12] = adc_chn0_filter_ctl_2_cond_2_qs;
        reg_rdata_next[27:18] = adc_chn0_filter_ctl_2_max_v_2_qs;
      end

      addr_hit[11]: begin
        reg_rdata_next[11:2] = adc_chn0_filter_ctl_3_min_v_3_qs;
        reg_rdata_next[12] = adc_chn0_filter_ctl_3_cond_3_qs;
        reg_rdata_next[27:18] = adc_chn0_filter_ctl_3_max_v_3_qs;
      end

      addr_hit[12]: begin
        reg_rdata_next[11:2] = adc_chn0_filter_ctl_4_min_v_4_qs;
        reg_rdata_next[12] = adc_chn0_filter_ctl_4_cond_4_qs;
        reg_rdata_next[27:18] = adc_chn0_filter_ctl_4_max_v_4_qs;
      end

      addr_hit[13]: begin
        reg_rdata_next[11:2] = adc_chn0_filter_ctl_5_min_v_5_qs;
        reg_rdata_next[12] = adc_chn0_filter_ctl_5_cond_5_qs;
        reg_rdata_next[27:18] = adc_chn0_filter_ctl_5_max_v_5_qs;
      end

      addr_hit[14]: begin
        reg_rdata_next[11:2] = adc_chn0_filter_ctl_6_min_v_6_qs;
        reg_rdata_next[12] = adc_chn0_filter_ctl_6_cond_6_qs;
        reg_rdata_next[27:18] = adc_chn0_filter_ctl_6_max_v_6_qs;
      end

      addr_hit[15]: begin
        reg_rdata_next[11:2] = adc_chn0_filter_ctl_7_min_v_7_qs;
        reg_rdata_next[12] = adc_chn0_filter_ctl_7_cond_7_qs;
        reg_rdata_next[27:18] = adc_chn0_filter_ctl_7_max_v_7_qs;
      end

      addr_hit[16]: begin
        reg_rdata_next[11:2] = adc_chn1_filter_ctl_0_min_v_0_qs;
        reg_rdata_next[12] = adc_chn1_filter_ctl_0_cond_0_qs;
        reg_rdata_next[27:18] = adc_chn1_filter_ctl_0_max_v_0_qs;
      end

      addr_hit[17]: begin
        reg_rdata_next[11:2] = adc_chn1_filter_ctl_1_min_v_1_qs;
        reg_rdata_next[12] = adc_chn1_filter_ctl_1_cond_1_qs;
        reg_rdata_next[27:18] = adc_chn1_filter_ctl_1_max_v_1_qs;
      end

      addr_hit[18]: begin
        reg_rdata_next[11:2] = adc_chn1_filter_ctl_2_min_v_2_qs;
        reg_rdata_next[12] = adc_chn1_filter_ctl_2_cond_2_qs;
        reg_rdata_next[27:18] = adc_chn1_filter_ctl_2_max_v_2_qs;
      end

      addr_hit[19]: begin
        reg_rdata_next[11:2] = adc_chn1_filter_ctl_3_min_v_3_qs;
        reg_rdata_next[12] = adc_chn1_filter_ctl_3_cond_3_qs;
        reg_rdata_next[27:18] = adc_chn1_filter_ctl_3_max_v_3_qs;
      end

      addr_hit[20]: begin
        reg_rdata_next[11:2] = adc_chn1_filter_ctl_4_min_v_4_qs;
        reg_rdata_next[12] = adc_chn1_filter_ctl_4_cond_4_qs;
        reg_rdata_next[27:18] = adc_chn1_filter_ctl_4_max_v_4_qs;
      end

      addr_hit[21]: begin
        reg_rdata_next[11:2] = adc_chn1_filter_ctl_5_min_v_5_qs;
        reg_rdata_next[12] = adc_chn1_filter_ctl_5_cond_5_qs;
        reg_rdata_next[27:18] = adc_chn1_filter_ctl_5_max_v_5_qs;
      end

      addr_hit[22]: begin
        reg_rdata_next[11:2] = adc_chn1_filter_ctl_6_min_v_6_qs;
        reg_rdata_next[12] = adc_chn1_filter_ctl_6_cond_6_qs;
        reg_rdata_next[27:18] = adc_chn1_filter_ctl_6_max_v_6_qs;
      end

      addr_hit[23]: begin
        reg_rdata_next[11:2] = adc_chn1_filter_ctl_7_min_v_7_qs;
        reg_rdata_next[12] = adc_chn1_filter_ctl_7_cond_7_qs;
        reg_rdata_next[27:18] = adc_chn1_filter_ctl_7_max_v_7_qs;
      end

      addr_hit[24]: begin
        reg_rdata_next[1:0] = adc_chn_val_0_adc_chn_value_ext_0_qs;
        reg_rdata_next[11:2] = adc_chn_val_0_adc_chn_value_0_qs;
        reg_rdata_next[17:16] = adc_chn_val_0_adc_chn_value_intr_ext_0_qs;
        reg_rdata_next[27:18] = adc_chn_val_0_adc_chn_value_intr_0_qs;
      end

      addr_hit[25]: begin
        reg_rdata_next[1:0] = adc_chn_val_1_adc_chn_value_ext_1_qs;
        reg_rdata_next[11:2] = adc_chn_val_1_adc_chn_value_1_qs;
        reg_rdata_next[17:16] = adc_chn_val_1_adc_chn_value_intr_ext_1_qs;
        reg_rdata_next[27:18] = adc_chn_val_1_adc_chn_value_intr_1_qs;
      end

      addr_hit[26]: begin
        reg_rdata_next[0] = adc_wakeup_ctl_chn0_1_filter0_en_qs;
        reg_rdata_next[1] = adc_wakeup_ctl_chn0_1_filter1_en_qs;
        reg_rdata_next[2] = adc_wakeup_ctl_chn0_1_filter2_en_qs;
        reg_rdata_next[3] = adc_wakeup_ctl_chn0_1_filter3_en_qs;
        reg_rdata_next[4] = adc_wakeup_ctl_chn0_1_filter4_en_qs;
        reg_rdata_next[5] = adc_wakeup_ctl_chn0_1_filter5_en_qs;
        reg_rdata_next[6] = adc_wakeup_ctl_chn0_1_filter6_en_qs;
        reg_rdata_next[7] = adc_wakeup_ctl_chn0_1_filter7_en_qs;
      end

      addr_hit[27]: begin
        reg_rdata_next[0] = adc_wakeup_status_cc_sink_det_qs;
        reg_rdata_next[1] = adc_wakeup_status_cc_1a5_sink_det_qs;
        reg_rdata_next[2] = adc_wakeup_status_cc_3a0_sink_det_qs;
        reg_rdata_next[3] = adc_wakeup_status_cc_src_det_qs;
        reg_rdata_next[4] = adc_wakeup_status_cc_1a5_src_det_qs;
        reg_rdata_next[5] = adc_wakeup_status_cc_src_det_flip_qs;
        reg_rdata_next[6] = adc_wakeup_status_cc_1a5_src_det_flip_qs;
        reg_rdata_next[7] = adc_wakeup_status_cc_discon_qs;
      end

      addr_hit[28]: begin
        reg_rdata_next[0] = adc_intr_ctl_chn0_1_filter0_en_qs;
        reg_rdata_next[1] = adc_intr_ctl_chn0_1_filter1_en_qs;
        reg_rdata_next[2] = adc_intr_ctl_chn0_1_filter2_en_qs;
        reg_rdata_next[3] = adc_intr_ctl_chn0_1_filter3_en_qs;
        reg_rdata_next[4] = adc_intr_ctl_chn0_1_filter4_en_qs;
        reg_rdata_next[5] = adc_intr_ctl_chn0_1_filter5_en_qs;
        reg_rdata_next[6] = adc_intr_ctl_chn0_1_filter6_en_qs;
        reg_rdata_next[7] = adc_intr_ctl_chn0_1_filter7_en_qs;
        reg_rdata_next[8] = adc_intr_ctl_oneshot_intr_en_qs;
      end

      addr_hit[29]: begin
        reg_rdata_next[0] = adc_intr_status_cc_sink_det_qs;
        reg_rdata_next[1] = adc_intr_status_cc_1a5_sink_det_qs;
        reg_rdata_next[2] = adc_intr_status_cc_3a0_sink_det_qs;
        reg_rdata_next[3] = adc_intr_status_cc_src_det_qs;
        reg_rdata_next[4] = adc_intr_status_cc_1a5_src_det_qs;
        reg_rdata_next[5] = adc_intr_status_cc_src_det_flip_qs;
        reg_rdata_next[6] = adc_intr_status_cc_1a5_src_det_flip_qs;
        reg_rdata_next[7] = adc_intr_status_cc_discon_qs;
        reg_rdata_next[8] = adc_intr_status_oneshot_qs;
      end

      default: begin
        reg_rdata_next = '1;
      end
    endcase
  end

  // Unused signal tieoff

  // wdata / byte enable are not always fully used
  // add a blanket unused statement to handle lint waivers
  logic unused_wdata;
  logic unused_be;
  assign unused_wdata = ^reg_wdata;
  assign unused_be = ^reg_be;

  // Assertions for Register Interface
  `ASSERT_PULSE(wePulse, reg_we)
  `ASSERT_PULSE(rePulse, reg_re)

  `ASSERT(reAfterRv, $rose(reg_re || reg_we) |=> tl_o.d_valid)

  `ASSERT(en2addrHit, (reg_we || reg_re) |-> $onehot0(addr_hit))

  // this is formulated as an assumption such that the FPV testbenches do disprove this
  // property by mistake
  //`ASSUME(reqParity, tl_reg_h2d.a_valid |-> tl_reg_h2d.a_user.chk_en == tlul_pkg::CheckDis)

endmodule
