// Copyright lowRISC contributors.
// Licensed under the Apache License, Version 2.0, see LICENSE for details.
// SPDX-License-Identifier: Apache-2.0
//
// Register Top module auto-generated by `reggen`

`include "prim_assert.sv"

module alert_handler_reg_top (
  input clk_i,
  input rst_ni,

  input  tlul_pkg::tl_h2d_t tl_i,
  output tlul_pkg::tl_d2h_t tl_o,
  // To HW
  output alert_handler_reg_pkg::alert_handler_reg2hw_t reg2hw, // Write
  input  alert_handler_reg_pkg::alert_handler_hw2reg_t hw2reg, // Read

  // Integrity check errors
  output logic intg_err_o,

  // Config
  input devmode_i // If 1, explicit error return for unmapped register access
);

  import alert_handler_reg_pkg::* ;

  localparam int AW = 10;
  localparam int DW = 32;
  localparam int DBW = DW/8;                    // Byte Width

  // register signals
  logic           reg_we;
  logic           reg_re;
  logic [AW-1:0]  reg_addr;
  logic [DW-1:0]  reg_wdata;
  logic [DBW-1:0] reg_be;
  logic [DW-1:0]  reg_rdata;
  logic           reg_error;

  logic          addrmiss, wr_err;

  logic [DW-1:0] reg_rdata_next;

  tlul_pkg::tl_h2d_t tl_reg_h2d;
  tlul_pkg::tl_d2h_t tl_reg_d2h;

  // incoming payload check
  logic intg_err;
  tlul_cmd_intg_chk u_chk (
    .tl_i,
    .err_o(intg_err)
  );

  logic intg_err_q;
  always_ff @(posedge clk_i or negedge rst_ni) begin
    if (!rst_ni) begin
      intg_err_q <= '0;
    end else if (intg_err) begin
      intg_err_q <= 1'b1;
    end
  end

  // integrity error output is permanent and should be used for alert generation
  // register errors are transactional
  assign intg_err_o = intg_err_q | intg_err;

  // outgoing integrity generation
  tlul_pkg::tl_d2h_t tl_o_pre;
  tlul_rsp_intg_gen u_rsp_intg_gen (
    .tl_i(tl_o_pre),
    .tl_o
  );

  assign tl_reg_h2d = tl_i;
  assign tl_o_pre   = tl_reg_d2h;

  tlul_adapter_reg #(
    .RegAw(AW),
    .RegDw(DW)
  ) u_reg_if (
    .clk_i,
    .rst_ni,

    .tl_i (tl_reg_h2d),
    .tl_o (tl_reg_d2h),

    .we_o    (reg_we),
    .re_o    (reg_re),
    .addr_o  (reg_addr),
    .wdata_o (reg_wdata),
    .be_o    (reg_be),
    .rdata_i (reg_rdata),
    .error_i (reg_error)
  );

  assign reg_rdata = reg_rdata_next ;
  assign reg_error = (devmode_i & addrmiss) | wr_err | intg_err;

  // Define SW related signals
  // Format: <reg>_<field>_{wd|we|qs}
  //        or <reg>_{wd|we|qs} if field == 1 or 0
  logic intr_state_classa_qs;
  logic intr_state_classa_wd;
  logic intr_state_classa_we;
  logic intr_state_classb_qs;
  logic intr_state_classb_wd;
  logic intr_state_classb_we;
  logic intr_state_classc_qs;
  logic intr_state_classc_wd;
  logic intr_state_classc_we;
  logic intr_state_classd_qs;
  logic intr_state_classd_wd;
  logic intr_state_classd_we;
  logic intr_enable_classa_qs;
  logic intr_enable_classa_wd;
  logic intr_enable_classa_we;
  logic intr_enable_classb_qs;
  logic intr_enable_classb_wd;
  logic intr_enable_classb_we;
  logic intr_enable_classc_qs;
  logic intr_enable_classc_wd;
  logic intr_enable_classc_we;
  logic intr_enable_classd_qs;
  logic intr_enable_classd_wd;
  logic intr_enable_classd_we;
  logic intr_test_classa_wd;
  logic intr_test_classa_we;
  logic intr_test_classb_wd;
  logic intr_test_classb_we;
  logic intr_test_classc_wd;
  logic intr_test_classc_we;
  logic intr_test_classd_wd;
  logic intr_test_classd_we;
  logic regwen_qs;
  logic regwen_wd;
  logic regwen_we;
  logic [23:0] ping_timeout_cyc_qs;
  logic [23:0] ping_timeout_cyc_wd;
  logic ping_timeout_cyc_we;
  logic alert_en_en_a_0_qs;
  logic alert_en_en_a_0_wd;
  logic alert_en_en_a_0_we;
  logic alert_en_en_a_1_qs;
  logic alert_en_en_a_1_wd;
  logic alert_en_en_a_1_we;
  logic alert_en_en_a_2_qs;
  logic alert_en_en_a_2_wd;
  logic alert_en_en_a_2_we;
  logic alert_en_en_a_3_qs;
  logic alert_en_en_a_3_wd;
  logic alert_en_en_a_3_we;
  logic [1:0] alert_class_class_a_0_qs;
  logic [1:0] alert_class_class_a_0_wd;
  logic alert_class_class_a_0_we;
  logic [1:0] alert_class_class_a_1_qs;
  logic [1:0] alert_class_class_a_1_wd;
  logic alert_class_class_a_1_we;
  logic [1:0] alert_class_class_a_2_qs;
  logic [1:0] alert_class_class_a_2_wd;
  logic alert_class_class_a_2_we;
  logic [1:0] alert_class_class_a_3_qs;
  logic [1:0] alert_class_class_a_3_wd;
  logic alert_class_class_a_3_we;
  logic alert_cause_a_0_qs;
  logic alert_cause_a_0_wd;
  logic alert_cause_a_0_we;
  logic alert_cause_a_1_qs;
  logic alert_cause_a_1_wd;
  logic alert_cause_a_1_we;
  logic alert_cause_a_2_qs;
  logic alert_cause_a_2_wd;
  logic alert_cause_a_2_we;
  logic alert_cause_a_3_qs;
  logic alert_cause_a_3_wd;
  logic alert_cause_a_3_we;
  logic loc_alert_en_en_la_0_qs;
  logic loc_alert_en_en_la_0_wd;
  logic loc_alert_en_en_la_0_we;
  logic loc_alert_en_en_la_1_qs;
  logic loc_alert_en_en_la_1_wd;
  logic loc_alert_en_en_la_1_we;
  logic loc_alert_en_en_la_2_qs;
  logic loc_alert_en_en_la_2_wd;
  logic loc_alert_en_en_la_2_we;
  logic loc_alert_en_en_la_3_qs;
  logic loc_alert_en_en_la_3_wd;
  logic loc_alert_en_en_la_3_we;
  logic [1:0] loc_alert_class_class_la_0_qs;
  logic [1:0] loc_alert_class_class_la_0_wd;
  logic loc_alert_class_class_la_0_we;
  logic [1:0] loc_alert_class_class_la_1_qs;
  logic [1:0] loc_alert_class_class_la_1_wd;
  logic loc_alert_class_class_la_1_we;
  logic [1:0] loc_alert_class_class_la_2_qs;
  logic [1:0] loc_alert_class_class_la_2_wd;
  logic loc_alert_class_class_la_2_we;
  logic [1:0] loc_alert_class_class_la_3_qs;
  logic [1:0] loc_alert_class_class_la_3_wd;
  logic loc_alert_class_class_la_3_we;
  logic loc_alert_cause_la_0_qs;
  logic loc_alert_cause_la_0_wd;
  logic loc_alert_cause_la_0_we;
  logic loc_alert_cause_la_1_qs;
  logic loc_alert_cause_la_1_wd;
  logic loc_alert_cause_la_1_we;
  logic loc_alert_cause_la_2_qs;
  logic loc_alert_cause_la_2_wd;
  logic loc_alert_cause_la_2_we;
  logic loc_alert_cause_la_3_qs;
  logic loc_alert_cause_la_3_wd;
  logic loc_alert_cause_la_3_we;
  logic classa_ctrl_en_qs;
  logic classa_ctrl_en_wd;
  logic classa_ctrl_en_we;
  logic classa_ctrl_lock_qs;
  logic classa_ctrl_lock_wd;
  logic classa_ctrl_lock_we;
  logic classa_ctrl_en_e0_qs;
  logic classa_ctrl_en_e0_wd;
  logic classa_ctrl_en_e0_we;
  logic classa_ctrl_en_e1_qs;
  logic classa_ctrl_en_e1_wd;
  logic classa_ctrl_en_e1_we;
  logic classa_ctrl_en_e2_qs;
  logic classa_ctrl_en_e2_wd;
  logic classa_ctrl_en_e2_we;
  logic classa_ctrl_en_e3_qs;
  logic classa_ctrl_en_e3_wd;
  logic classa_ctrl_en_e3_we;
  logic [1:0] classa_ctrl_map_e0_qs;
  logic [1:0] classa_ctrl_map_e0_wd;
  logic classa_ctrl_map_e0_we;
  logic [1:0] classa_ctrl_map_e1_qs;
  logic [1:0] classa_ctrl_map_e1_wd;
  logic classa_ctrl_map_e1_we;
  logic [1:0] classa_ctrl_map_e2_qs;
  logic [1:0] classa_ctrl_map_e2_wd;
  logic classa_ctrl_map_e2_we;
  logic [1:0] classa_ctrl_map_e3_qs;
  logic [1:0] classa_ctrl_map_e3_wd;
  logic classa_ctrl_map_e3_we;
  logic classa_regwen_qs;
  logic classa_regwen_wd;
  logic classa_regwen_we;
  logic classa_clr_wd;
  logic classa_clr_we;
  logic [15:0] classa_accum_cnt_qs;
  logic classa_accum_cnt_re;
  logic [15:0] classa_accum_thresh_qs;
  logic [15:0] classa_accum_thresh_wd;
  logic classa_accum_thresh_we;
  logic [31:0] classa_timeout_cyc_qs;
  logic [31:0] classa_timeout_cyc_wd;
  logic classa_timeout_cyc_we;
  logic [31:0] classa_phase0_cyc_qs;
  logic [31:0] classa_phase0_cyc_wd;
  logic classa_phase0_cyc_we;
  logic [31:0] classa_phase1_cyc_qs;
  logic [31:0] classa_phase1_cyc_wd;
  logic classa_phase1_cyc_we;
  logic [31:0] classa_phase2_cyc_qs;
  logic [31:0] classa_phase2_cyc_wd;
  logic classa_phase2_cyc_we;
  logic [31:0] classa_phase3_cyc_qs;
  logic [31:0] classa_phase3_cyc_wd;
  logic classa_phase3_cyc_we;
  logic [31:0] classa_esc_cnt_qs;
  logic classa_esc_cnt_re;
  logic [2:0] classa_state_qs;
  logic classa_state_re;
  logic classb_ctrl_en_qs;
  logic classb_ctrl_en_wd;
  logic classb_ctrl_en_we;
  logic classb_ctrl_lock_qs;
  logic classb_ctrl_lock_wd;
  logic classb_ctrl_lock_we;
  logic classb_ctrl_en_e0_qs;
  logic classb_ctrl_en_e0_wd;
  logic classb_ctrl_en_e0_we;
  logic classb_ctrl_en_e1_qs;
  logic classb_ctrl_en_e1_wd;
  logic classb_ctrl_en_e1_we;
  logic classb_ctrl_en_e2_qs;
  logic classb_ctrl_en_e2_wd;
  logic classb_ctrl_en_e2_we;
  logic classb_ctrl_en_e3_qs;
  logic classb_ctrl_en_e3_wd;
  logic classb_ctrl_en_e3_we;
  logic [1:0] classb_ctrl_map_e0_qs;
  logic [1:0] classb_ctrl_map_e0_wd;
  logic classb_ctrl_map_e0_we;
  logic [1:0] classb_ctrl_map_e1_qs;
  logic [1:0] classb_ctrl_map_e1_wd;
  logic classb_ctrl_map_e1_we;
  logic [1:0] classb_ctrl_map_e2_qs;
  logic [1:0] classb_ctrl_map_e2_wd;
  logic classb_ctrl_map_e2_we;
  logic [1:0] classb_ctrl_map_e3_qs;
  logic [1:0] classb_ctrl_map_e3_wd;
  logic classb_ctrl_map_e3_we;
  logic classb_regwen_qs;
  logic classb_regwen_wd;
  logic classb_regwen_we;
  logic classb_clr_wd;
  logic classb_clr_we;
  logic [15:0] classb_accum_cnt_qs;
  logic classb_accum_cnt_re;
  logic [15:0] classb_accum_thresh_qs;
  logic [15:0] classb_accum_thresh_wd;
  logic classb_accum_thresh_we;
  logic [31:0] classb_timeout_cyc_qs;
  logic [31:0] classb_timeout_cyc_wd;
  logic classb_timeout_cyc_we;
  logic [31:0] classb_phase0_cyc_qs;
  logic [31:0] classb_phase0_cyc_wd;
  logic classb_phase0_cyc_we;
  logic [31:0] classb_phase1_cyc_qs;
  logic [31:0] classb_phase1_cyc_wd;
  logic classb_phase1_cyc_we;
  logic [31:0] classb_phase2_cyc_qs;
  logic [31:0] classb_phase2_cyc_wd;
  logic classb_phase2_cyc_we;
  logic [31:0] classb_phase3_cyc_qs;
  logic [31:0] classb_phase3_cyc_wd;
  logic classb_phase3_cyc_we;
  logic [31:0] classb_esc_cnt_qs;
  logic classb_esc_cnt_re;
  logic [2:0] classb_state_qs;
  logic classb_state_re;
  logic classc_ctrl_en_qs;
  logic classc_ctrl_en_wd;
  logic classc_ctrl_en_we;
  logic classc_ctrl_lock_qs;
  logic classc_ctrl_lock_wd;
  logic classc_ctrl_lock_we;
  logic classc_ctrl_en_e0_qs;
  logic classc_ctrl_en_e0_wd;
  logic classc_ctrl_en_e0_we;
  logic classc_ctrl_en_e1_qs;
  logic classc_ctrl_en_e1_wd;
  logic classc_ctrl_en_e1_we;
  logic classc_ctrl_en_e2_qs;
  logic classc_ctrl_en_e2_wd;
  logic classc_ctrl_en_e2_we;
  logic classc_ctrl_en_e3_qs;
  logic classc_ctrl_en_e3_wd;
  logic classc_ctrl_en_e3_we;
  logic [1:0] classc_ctrl_map_e0_qs;
  logic [1:0] classc_ctrl_map_e0_wd;
  logic classc_ctrl_map_e0_we;
  logic [1:0] classc_ctrl_map_e1_qs;
  logic [1:0] classc_ctrl_map_e1_wd;
  logic classc_ctrl_map_e1_we;
  logic [1:0] classc_ctrl_map_e2_qs;
  logic [1:0] classc_ctrl_map_e2_wd;
  logic classc_ctrl_map_e2_we;
  logic [1:0] classc_ctrl_map_e3_qs;
  logic [1:0] classc_ctrl_map_e3_wd;
  logic classc_ctrl_map_e3_we;
  logic classc_regwen_qs;
  logic classc_regwen_wd;
  logic classc_regwen_we;
  logic classc_clr_wd;
  logic classc_clr_we;
  logic [15:0] classc_accum_cnt_qs;
  logic classc_accum_cnt_re;
  logic [15:0] classc_accum_thresh_qs;
  logic [15:0] classc_accum_thresh_wd;
  logic classc_accum_thresh_we;
  logic [31:0] classc_timeout_cyc_qs;
  logic [31:0] classc_timeout_cyc_wd;
  logic classc_timeout_cyc_we;
  logic [31:0] classc_phase0_cyc_qs;
  logic [31:0] classc_phase0_cyc_wd;
  logic classc_phase0_cyc_we;
  logic [31:0] classc_phase1_cyc_qs;
  logic [31:0] classc_phase1_cyc_wd;
  logic classc_phase1_cyc_we;
  logic [31:0] classc_phase2_cyc_qs;
  logic [31:0] classc_phase2_cyc_wd;
  logic classc_phase2_cyc_we;
  logic [31:0] classc_phase3_cyc_qs;
  logic [31:0] classc_phase3_cyc_wd;
  logic classc_phase3_cyc_we;
  logic [31:0] classc_esc_cnt_qs;
  logic classc_esc_cnt_re;
  logic [2:0] classc_state_qs;
  logic classc_state_re;
  logic classd_ctrl_en_qs;
  logic classd_ctrl_en_wd;
  logic classd_ctrl_en_we;
  logic classd_ctrl_lock_qs;
  logic classd_ctrl_lock_wd;
  logic classd_ctrl_lock_we;
  logic classd_ctrl_en_e0_qs;
  logic classd_ctrl_en_e0_wd;
  logic classd_ctrl_en_e0_we;
  logic classd_ctrl_en_e1_qs;
  logic classd_ctrl_en_e1_wd;
  logic classd_ctrl_en_e1_we;
  logic classd_ctrl_en_e2_qs;
  logic classd_ctrl_en_e2_wd;
  logic classd_ctrl_en_e2_we;
  logic classd_ctrl_en_e3_qs;
  logic classd_ctrl_en_e3_wd;
  logic classd_ctrl_en_e3_we;
  logic [1:0] classd_ctrl_map_e0_qs;
  logic [1:0] classd_ctrl_map_e0_wd;
  logic classd_ctrl_map_e0_we;
  logic [1:0] classd_ctrl_map_e1_qs;
  logic [1:0] classd_ctrl_map_e1_wd;
  logic classd_ctrl_map_e1_we;
  logic [1:0] classd_ctrl_map_e2_qs;
  logic [1:0] classd_ctrl_map_e2_wd;
  logic classd_ctrl_map_e2_we;
  logic [1:0] classd_ctrl_map_e3_qs;
  logic [1:0] classd_ctrl_map_e3_wd;
  logic classd_ctrl_map_e3_we;
  logic classd_regwen_qs;
  logic classd_regwen_wd;
  logic classd_regwen_we;
  logic classd_clr_wd;
  logic classd_clr_we;
  logic [15:0] classd_accum_cnt_qs;
  logic classd_accum_cnt_re;
  logic [15:0] classd_accum_thresh_qs;
  logic [15:0] classd_accum_thresh_wd;
  logic classd_accum_thresh_we;
  logic [31:0] classd_timeout_cyc_qs;
  logic [31:0] classd_timeout_cyc_wd;
  logic classd_timeout_cyc_we;
  logic [31:0] classd_phase0_cyc_qs;
  logic [31:0] classd_phase0_cyc_wd;
  logic classd_phase0_cyc_we;
  logic [31:0] classd_phase1_cyc_qs;
  logic [31:0] classd_phase1_cyc_wd;
  logic classd_phase1_cyc_we;
  logic [31:0] classd_phase2_cyc_qs;
  logic [31:0] classd_phase2_cyc_wd;
  logic classd_phase2_cyc_we;
  logic [31:0] classd_phase3_cyc_qs;
  logic [31:0] classd_phase3_cyc_wd;
  logic classd_phase3_cyc_we;
  logic [31:0] classd_esc_cnt_qs;
  logic classd_esc_cnt_re;
  logic [2:0] classd_state_qs;
  logic classd_state_re;

  // Register instances
  // R[intr_state]: V(False)

  //   F[classa]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_classa (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_classa_we),
    .wd     (intr_state_classa_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.classa.de),
    .d      (hw2reg.intr_state.classa.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.classa.q ),

    // to register interface (read)
    .qs     (intr_state_classa_qs)
  );


  //   F[classb]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_classb (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_classb_we),
    .wd     (intr_state_classb_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.classb.de),
    .d      (hw2reg.intr_state.classb.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.classb.q ),

    // to register interface (read)
    .qs     (intr_state_classb_qs)
  );


  //   F[classc]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_classc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_classc_we),
    .wd     (intr_state_classc_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.classc.de),
    .d      (hw2reg.intr_state.classc.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.classc.q ),

    // to register interface (read)
    .qs     (intr_state_classc_qs)
  );


  //   F[classd]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_intr_state_classd (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_state_classd_we),
    .wd     (intr_state_classd_wd),

    // from internal hardware
    .de     (hw2reg.intr_state.classd.de),
    .d      (hw2reg.intr_state.classd.d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_state.classd.q ),

    // to register interface (read)
    .qs     (intr_state_classd_qs)
  );


  // R[intr_enable]: V(False)

  //   F[classa]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_classa (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_classa_we),
    .wd     (intr_enable_classa_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.classa.q ),

    // to register interface (read)
    .qs     (intr_enable_classa_qs)
  );


  //   F[classb]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_classb (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_classb_we),
    .wd     (intr_enable_classb_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.classb.q ),

    // to register interface (read)
    .qs     (intr_enable_classb_qs)
  );


  //   F[classc]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_classc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_classc_we),
    .wd     (intr_enable_classc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.classc.q ),

    // to register interface (read)
    .qs     (intr_enable_classc_qs)
  );


  //   F[classd]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_intr_enable_classd (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (intr_enable_classd_we),
    .wd     (intr_enable_classd_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.intr_enable.classd.q ),

    // to register interface (read)
    .qs     (intr_enable_classd_qs)
  );


  // R[intr_test]: V(True)

  //   F[classa]: 0:0
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_classa (
    .re     (1'b0),
    .we     (intr_test_classa_we),
    .wd     (intr_test_classa_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.classa.qe),
    .q      (reg2hw.intr_test.classa.q ),
    .qs     ()
  );


  //   F[classb]: 1:1
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_classb (
    .re     (1'b0),
    .we     (intr_test_classb_we),
    .wd     (intr_test_classb_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.classb.qe),
    .q      (reg2hw.intr_test.classb.q ),
    .qs     ()
  );


  //   F[classc]: 2:2
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_classc (
    .re     (1'b0),
    .we     (intr_test_classc_we),
    .wd     (intr_test_classc_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.classc.qe),
    .q      (reg2hw.intr_test.classc.q ),
    .qs     ()
  );


  //   F[classd]: 3:3
  prim_subreg_ext #(
    .DW    (1)
  ) u_intr_test_classd (
    .re     (1'b0),
    .we     (intr_test_classd_we),
    .wd     (intr_test_classd_wd),
    .d      ('0),
    .qre    (),
    .qe     (reg2hw.intr_test.classd.qe),
    .q      (reg2hw.intr_test.classd.q ),
    .qs     ()
  );


  // R[regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (regwen_we),
    .wd     (regwen_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.regwen.q ),

    // to register interface (read)
    .qs     (regwen_qs)
  );


  // R[ping_timeout_cyc]: V(False)

  prim_subreg #(
    .DW      (24),
    .SWACCESS("RW"),
    .RESVAL  (24'h20)
  ) u_ping_timeout_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (ping_timeout_cyc_we & regwen_qs),
    .wd     (ping_timeout_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.ping_timeout_cyc.q ),

    // to register interface (read)
    .qs     (ping_timeout_cyc_qs)
  );



  // Subregister 0 of Multireg alert_en
  // R[alert_en]: V(False)

  // F[en_a_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_alert_en_en_a_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (alert_en_en_a_0_we & regwen_qs),
    .wd     (alert_en_en_a_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.alert_en[0].q ),

    // to register interface (read)
    .qs     (alert_en_en_a_0_qs)
  );


  // F[en_a_1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_alert_en_en_a_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (alert_en_en_a_1_we & regwen_qs),
    .wd     (alert_en_en_a_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.alert_en[1].q ),

    // to register interface (read)
    .qs     (alert_en_en_a_1_qs)
  );


  // F[en_a_2]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_alert_en_en_a_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (alert_en_en_a_2_we & regwen_qs),
    .wd     (alert_en_en_a_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.alert_en[2].q ),

    // to register interface (read)
    .qs     (alert_en_en_a_2_qs)
  );


  // F[en_a_3]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_alert_en_en_a_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (alert_en_en_a_3_we & regwen_qs),
    .wd     (alert_en_en_a_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.alert_en[3].q ),

    // to register interface (read)
    .qs     (alert_en_en_a_3_qs)
  );




  // Subregister 0 of Multireg alert_class
  // R[alert_class]: V(False)

  // F[class_a_0]: 1:0
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_alert_class_class_a_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (alert_class_class_a_0_we & regwen_qs),
    .wd     (alert_class_class_a_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.alert_class[0].q ),

    // to register interface (read)
    .qs     (alert_class_class_a_0_qs)
  );


  // F[class_a_1]: 3:2
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_alert_class_class_a_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (alert_class_class_a_1_we & regwen_qs),
    .wd     (alert_class_class_a_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.alert_class[1].q ),

    // to register interface (read)
    .qs     (alert_class_class_a_1_qs)
  );


  // F[class_a_2]: 5:4
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_alert_class_class_a_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (alert_class_class_a_2_we & regwen_qs),
    .wd     (alert_class_class_a_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.alert_class[2].q ),

    // to register interface (read)
    .qs     (alert_class_class_a_2_qs)
  );


  // F[class_a_3]: 7:6
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_alert_class_class_a_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (alert_class_class_a_3_we & regwen_qs),
    .wd     (alert_class_class_a_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.alert_class[3].q ),

    // to register interface (read)
    .qs     (alert_class_class_a_3_qs)
  );




  // Subregister 0 of Multireg alert_cause
  // R[alert_cause]: V(False)

  // F[a_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_alert_cause_a_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (alert_cause_a_0_we),
    .wd     (alert_cause_a_0_wd),

    // from internal hardware
    .de     (hw2reg.alert_cause[0].de),
    .d      (hw2reg.alert_cause[0].d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.alert_cause[0].q ),

    // to register interface (read)
    .qs     (alert_cause_a_0_qs)
  );


  // F[a_1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_alert_cause_a_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (alert_cause_a_1_we),
    .wd     (alert_cause_a_1_wd),

    // from internal hardware
    .de     (hw2reg.alert_cause[1].de),
    .d      (hw2reg.alert_cause[1].d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.alert_cause[1].q ),

    // to register interface (read)
    .qs     (alert_cause_a_1_qs)
  );


  // F[a_2]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_alert_cause_a_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (alert_cause_a_2_we),
    .wd     (alert_cause_a_2_wd),

    // from internal hardware
    .de     (hw2reg.alert_cause[2].de),
    .d      (hw2reg.alert_cause[2].d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.alert_cause[2].q ),

    // to register interface (read)
    .qs     (alert_cause_a_2_qs)
  );


  // F[a_3]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_alert_cause_a_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (alert_cause_a_3_we),
    .wd     (alert_cause_a_3_wd),

    // from internal hardware
    .de     (hw2reg.alert_cause[3].de),
    .d      (hw2reg.alert_cause[3].d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.alert_cause[3].q ),

    // to register interface (read)
    .qs     (alert_cause_a_3_qs)
  );




  // Subregister 0 of Multireg loc_alert_en
  // R[loc_alert_en]: V(False)

  // F[en_la_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_loc_alert_en_en_la_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (loc_alert_en_en_la_0_we & regwen_qs),
    .wd     (loc_alert_en_en_la_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.loc_alert_en[0].q ),

    // to register interface (read)
    .qs     (loc_alert_en_en_la_0_qs)
  );


  // F[en_la_1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_loc_alert_en_en_la_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (loc_alert_en_en_la_1_we & regwen_qs),
    .wd     (loc_alert_en_en_la_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.loc_alert_en[1].q ),

    // to register interface (read)
    .qs     (loc_alert_en_en_la_1_qs)
  );


  // F[en_la_2]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_loc_alert_en_en_la_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (loc_alert_en_en_la_2_we & regwen_qs),
    .wd     (loc_alert_en_en_la_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.loc_alert_en[2].q ),

    // to register interface (read)
    .qs     (loc_alert_en_en_la_2_qs)
  );


  // F[en_la_3]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_loc_alert_en_en_la_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (loc_alert_en_en_la_3_we & regwen_qs),
    .wd     (loc_alert_en_en_la_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.loc_alert_en[3].q ),

    // to register interface (read)
    .qs     (loc_alert_en_en_la_3_qs)
  );




  // Subregister 0 of Multireg loc_alert_class
  // R[loc_alert_class]: V(False)

  // F[class_la_0]: 1:0
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_loc_alert_class_class_la_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (loc_alert_class_class_la_0_we & regwen_qs),
    .wd     (loc_alert_class_class_la_0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.loc_alert_class[0].q ),

    // to register interface (read)
    .qs     (loc_alert_class_class_la_0_qs)
  );


  // F[class_la_1]: 3:2
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_loc_alert_class_class_la_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (loc_alert_class_class_la_1_we & regwen_qs),
    .wd     (loc_alert_class_class_la_1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.loc_alert_class[1].q ),

    // to register interface (read)
    .qs     (loc_alert_class_class_la_1_qs)
  );


  // F[class_la_2]: 5:4
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_loc_alert_class_class_la_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (loc_alert_class_class_la_2_we & regwen_qs),
    .wd     (loc_alert_class_class_la_2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.loc_alert_class[2].q ),

    // to register interface (read)
    .qs     (loc_alert_class_class_la_2_qs)
  );


  // F[class_la_3]: 7:6
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_loc_alert_class_class_la_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (loc_alert_class_class_la_3_we & regwen_qs),
    .wd     (loc_alert_class_class_la_3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.loc_alert_class[3].q ),

    // to register interface (read)
    .qs     (loc_alert_class_class_la_3_qs)
  );




  // Subregister 0 of Multireg loc_alert_cause
  // R[loc_alert_cause]: V(False)

  // F[la_0]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_loc_alert_cause_la_0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (loc_alert_cause_la_0_we),
    .wd     (loc_alert_cause_la_0_wd),

    // from internal hardware
    .de     (hw2reg.loc_alert_cause[0].de),
    .d      (hw2reg.loc_alert_cause[0].d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.loc_alert_cause[0].q ),

    // to register interface (read)
    .qs     (loc_alert_cause_la_0_qs)
  );


  // F[la_1]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_loc_alert_cause_la_1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (loc_alert_cause_la_1_we),
    .wd     (loc_alert_cause_la_1_wd),

    // from internal hardware
    .de     (hw2reg.loc_alert_cause[1].de),
    .d      (hw2reg.loc_alert_cause[1].d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.loc_alert_cause[1].q ),

    // to register interface (read)
    .qs     (loc_alert_cause_la_1_qs)
  );


  // F[la_2]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_loc_alert_cause_la_2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (loc_alert_cause_la_2_we),
    .wd     (loc_alert_cause_la_2_wd),

    // from internal hardware
    .de     (hw2reg.loc_alert_cause[2].de),
    .d      (hw2reg.loc_alert_cause[2].d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.loc_alert_cause[2].q ),

    // to register interface (read)
    .qs     (loc_alert_cause_la_2_qs)
  );


  // F[la_3]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("W1C"),
    .RESVAL  (1'h0)
  ) u_loc_alert_cause_la_3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (loc_alert_cause_la_3_we),
    .wd     (loc_alert_cause_la_3_wd),

    // from internal hardware
    .de     (hw2reg.loc_alert_cause[3].de),
    .d      (hw2reg.loc_alert_cause[3].d ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.loc_alert_cause[3].q ),

    // to register interface (read)
    .qs     (loc_alert_cause_la_3_qs)
  );



  // R[classa_ctrl]: V(False)

  //   F[en]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_classa_ctrl_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_ctrl_en_we & regwen_qs),
    .wd     (classa_ctrl_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_ctrl.en.q ),

    // to register interface (read)
    .qs     (classa_ctrl_en_qs)
  );


  //   F[lock]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_classa_ctrl_lock (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_ctrl_lock_we & regwen_qs),
    .wd     (classa_ctrl_lock_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_ctrl.lock.q ),

    // to register interface (read)
    .qs     (classa_ctrl_lock_qs)
  );


  //   F[en_e0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classa_ctrl_en_e0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_ctrl_en_e0_we & regwen_qs),
    .wd     (classa_ctrl_en_e0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_ctrl.en_e0.q ),

    // to register interface (read)
    .qs     (classa_ctrl_en_e0_qs)
  );


  //   F[en_e1]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classa_ctrl_en_e1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_ctrl_en_e1_we & regwen_qs),
    .wd     (classa_ctrl_en_e1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_ctrl.en_e1.q ),

    // to register interface (read)
    .qs     (classa_ctrl_en_e1_qs)
  );


  //   F[en_e2]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classa_ctrl_en_e2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_ctrl_en_e2_we & regwen_qs),
    .wd     (classa_ctrl_en_e2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_ctrl.en_e2.q ),

    // to register interface (read)
    .qs     (classa_ctrl_en_e2_qs)
  );


  //   F[en_e3]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classa_ctrl_en_e3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_ctrl_en_e3_we & regwen_qs),
    .wd     (classa_ctrl_en_e3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_ctrl.en_e3.q ),

    // to register interface (read)
    .qs     (classa_ctrl_en_e3_qs)
  );


  //   F[map_e0]: 7:6
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_classa_ctrl_map_e0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_ctrl_map_e0_we & regwen_qs),
    .wd     (classa_ctrl_map_e0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_ctrl.map_e0.q ),

    // to register interface (read)
    .qs     (classa_ctrl_map_e0_qs)
  );


  //   F[map_e1]: 9:8
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h1)
  ) u_classa_ctrl_map_e1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_ctrl_map_e1_we & regwen_qs),
    .wd     (classa_ctrl_map_e1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_ctrl.map_e1.q ),

    // to register interface (read)
    .qs     (classa_ctrl_map_e1_qs)
  );


  //   F[map_e2]: 11:10
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h2)
  ) u_classa_ctrl_map_e2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_ctrl_map_e2_we & regwen_qs),
    .wd     (classa_ctrl_map_e2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_ctrl.map_e2.q ),

    // to register interface (read)
    .qs     (classa_ctrl_map_e2_qs)
  );


  //   F[map_e3]: 13:12
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h3)
  ) u_classa_ctrl_map_e3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_ctrl_map_e3_we & regwen_qs),
    .wd     (classa_ctrl_map_e3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_ctrl.map_e3.q ),

    // to register interface (read)
    .qs     (classa_ctrl_map_e3_qs)
  );


  // R[classa_regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_classa_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (classa_regwen_we),
    .wd     (classa_regwen_wd),

    // from internal hardware
    .de     (hw2reg.classa_regwen.de),
    .d      (hw2reg.classa_regwen.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (classa_regwen_qs)
  );


  // R[classa_clr]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("WO"),
    .RESVAL  (1'h0)
  ) u_classa_clr (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_clr_we & classa_regwen_qs),
    .wd     (classa_clr_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.classa_clr.qe),
    .q      (reg2hw.classa_clr.q ),

    .qs     ()
  );


  // R[classa_accum_cnt]: V(True)

  prim_subreg_ext #(
    .DW    (16)
  ) u_classa_accum_cnt (
    .re     (classa_accum_cnt_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.classa_accum_cnt.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (classa_accum_cnt_qs)
  );


  // R[classa_accum_thresh]: V(False)

  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h0)
  ) u_classa_accum_thresh (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_accum_thresh_we & regwen_qs),
    .wd     (classa_accum_thresh_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_accum_thresh.q ),

    // to register interface (read)
    .qs     (classa_accum_thresh_qs)
  );


  // R[classa_timeout_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classa_timeout_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_timeout_cyc_we & regwen_qs),
    .wd     (classa_timeout_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_timeout_cyc.q ),

    // to register interface (read)
    .qs     (classa_timeout_cyc_qs)
  );


  // R[classa_phase0_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classa_phase0_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_phase0_cyc_we & regwen_qs),
    .wd     (classa_phase0_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_phase0_cyc.q ),

    // to register interface (read)
    .qs     (classa_phase0_cyc_qs)
  );


  // R[classa_phase1_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classa_phase1_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_phase1_cyc_we & regwen_qs),
    .wd     (classa_phase1_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_phase1_cyc.q ),

    // to register interface (read)
    .qs     (classa_phase1_cyc_qs)
  );


  // R[classa_phase2_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classa_phase2_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_phase2_cyc_we & regwen_qs),
    .wd     (classa_phase2_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_phase2_cyc.q ),

    // to register interface (read)
    .qs     (classa_phase2_cyc_qs)
  );


  // R[classa_phase3_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classa_phase3_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classa_phase3_cyc_we & regwen_qs),
    .wd     (classa_phase3_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classa_phase3_cyc.q ),

    // to register interface (read)
    .qs     (classa_phase3_cyc_qs)
  );


  // R[classa_esc_cnt]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_classa_esc_cnt (
    .re     (classa_esc_cnt_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.classa_esc_cnt.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (classa_esc_cnt_qs)
  );


  // R[classa_state]: V(True)

  prim_subreg_ext #(
    .DW    (3)
  ) u_classa_state (
    .re     (classa_state_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.classa_state.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (classa_state_qs)
  );


  // R[classb_ctrl]: V(False)

  //   F[en]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_classb_ctrl_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_ctrl_en_we & regwen_qs),
    .wd     (classb_ctrl_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_ctrl.en.q ),

    // to register interface (read)
    .qs     (classb_ctrl_en_qs)
  );


  //   F[lock]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_classb_ctrl_lock (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_ctrl_lock_we & regwen_qs),
    .wd     (classb_ctrl_lock_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_ctrl.lock.q ),

    // to register interface (read)
    .qs     (classb_ctrl_lock_qs)
  );


  //   F[en_e0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classb_ctrl_en_e0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_ctrl_en_e0_we & regwen_qs),
    .wd     (classb_ctrl_en_e0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_ctrl.en_e0.q ),

    // to register interface (read)
    .qs     (classb_ctrl_en_e0_qs)
  );


  //   F[en_e1]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classb_ctrl_en_e1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_ctrl_en_e1_we & regwen_qs),
    .wd     (classb_ctrl_en_e1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_ctrl.en_e1.q ),

    // to register interface (read)
    .qs     (classb_ctrl_en_e1_qs)
  );


  //   F[en_e2]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classb_ctrl_en_e2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_ctrl_en_e2_we & regwen_qs),
    .wd     (classb_ctrl_en_e2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_ctrl.en_e2.q ),

    // to register interface (read)
    .qs     (classb_ctrl_en_e2_qs)
  );


  //   F[en_e3]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classb_ctrl_en_e3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_ctrl_en_e3_we & regwen_qs),
    .wd     (classb_ctrl_en_e3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_ctrl.en_e3.q ),

    // to register interface (read)
    .qs     (classb_ctrl_en_e3_qs)
  );


  //   F[map_e0]: 7:6
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_classb_ctrl_map_e0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_ctrl_map_e0_we & regwen_qs),
    .wd     (classb_ctrl_map_e0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_ctrl.map_e0.q ),

    // to register interface (read)
    .qs     (classb_ctrl_map_e0_qs)
  );


  //   F[map_e1]: 9:8
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h1)
  ) u_classb_ctrl_map_e1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_ctrl_map_e1_we & regwen_qs),
    .wd     (classb_ctrl_map_e1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_ctrl.map_e1.q ),

    // to register interface (read)
    .qs     (classb_ctrl_map_e1_qs)
  );


  //   F[map_e2]: 11:10
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h2)
  ) u_classb_ctrl_map_e2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_ctrl_map_e2_we & regwen_qs),
    .wd     (classb_ctrl_map_e2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_ctrl.map_e2.q ),

    // to register interface (read)
    .qs     (classb_ctrl_map_e2_qs)
  );


  //   F[map_e3]: 13:12
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h3)
  ) u_classb_ctrl_map_e3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_ctrl_map_e3_we & regwen_qs),
    .wd     (classb_ctrl_map_e3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_ctrl.map_e3.q ),

    // to register interface (read)
    .qs     (classb_ctrl_map_e3_qs)
  );


  // R[classb_regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_classb_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (classb_regwen_we),
    .wd     (classb_regwen_wd),

    // from internal hardware
    .de     (hw2reg.classb_regwen.de),
    .d      (hw2reg.classb_regwen.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (classb_regwen_qs)
  );


  // R[classb_clr]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("WO"),
    .RESVAL  (1'h0)
  ) u_classb_clr (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_clr_we & classb_regwen_qs),
    .wd     (classb_clr_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.classb_clr.qe),
    .q      (reg2hw.classb_clr.q ),

    .qs     ()
  );


  // R[classb_accum_cnt]: V(True)

  prim_subreg_ext #(
    .DW    (16)
  ) u_classb_accum_cnt (
    .re     (classb_accum_cnt_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.classb_accum_cnt.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (classb_accum_cnt_qs)
  );


  // R[classb_accum_thresh]: V(False)

  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h0)
  ) u_classb_accum_thresh (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_accum_thresh_we & regwen_qs),
    .wd     (classb_accum_thresh_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_accum_thresh.q ),

    // to register interface (read)
    .qs     (classb_accum_thresh_qs)
  );


  // R[classb_timeout_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classb_timeout_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_timeout_cyc_we & regwen_qs),
    .wd     (classb_timeout_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_timeout_cyc.q ),

    // to register interface (read)
    .qs     (classb_timeout_cyc_qs)
  );


  // R[classb_phase0_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classb_phase0_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_phase0_cyc_we & regwen_qs),
    .wd     (classb_phase0_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_phase0_cyc.q ),

    // to register interface (read)
    .qs     (classb_phase0_cyc_qs)
  );


  // R[classb_phase1_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classb_phase1_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_phase1_cyc_we & regwen_qs),
    .wd     (classb_phase1_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_phase1_cyc.q ),

    // to register interface (read)
    .qs     (classb_phase1_cyc_qs)
  );


  // R[classb_phase2_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classb_phase2_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_phase2_cyc_we & regwen_qs),
    .wd     (classb_phase2_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_phase2_cyc.q ),

    // to register interface (read)
    .qs     (classb_phase2_cyc_qs)
  );


  // R[classb_phase3_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classb_phase3_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classb_phase3_cyc_we & regwen_qs),
    .wd     (classb_phase3_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classb_phase3_cyc.q ),

    // to register interface (read)
    .qs     (classb_phase3_cyc_qs)
  );


  // R[classb_esc_cnt]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_classb_esc_cnt (
    .re     (classb_esc_cnt_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.classb_esc_cnt.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (classb_esc_cnt_qs)
  );


  // R[classb_state]: V(True)

  prim_subreg_ext #(
    .DW    (3)
  ) u_classb_state (
    .re     (classb_state_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.classb_state.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (classb_state_qs)
  );


  // R[classc_ctrl]: V(False)

  //   F[en]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_classc_ctrl_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_ctrl_en_we & regwen_qs),
    .wd     (classc_ctrl_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_ctrl.en.q ),

    // to register interface (read)
    .qs     (classc_ctrl_en_qs)
  );


  //   F[lock]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_classc_ctrl_lock (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_ctrl_lock_we & regwen_qs),
    .wd     (classc_ctrl_lock_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_ctrl.lock.q ),

    // to register interface (read)
    .qs     (classc_ctrl_lock_qs)
  );


  //   F[en_e0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classc_ctrl_en_e0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_ctrl_en_e0_we & regwen_qs),
    .wd     (classc_ctrl_en_e0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_ctrl.en_e0.q ),

    // to register interface (read)
    .qs     (classc_ctrl_en_e0_qs)
  );


  //   F[en_e1]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classc_ctrl_en_e1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_ctrl_en_e1_we & regwen_qs),
    .wd     (classc_ctrl_en_e1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_ctrl.en_e1.q ),

    // to register interface (read)
    .qs     (classc_ctrl_en_e1_qs)
  );


  //   F[en_e2]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classc_ctrl_en_e2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_ctrl_en_e2_we & regwen_qs),
    .wd     (classc_ctrl_en_e2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_ctrl.en_e2.q ),

    // to register interface (read)
    .qs     (classc_ctrl_en_e2_qs)
  );


  //   F[en_e3]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classc_ctrl_en_e3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_ctrl_en_e3_we & regwen_qs),
    .wd     (classc_ctrl_en_e3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_ctrl.en_e3.q ),

    // to register interface (read)
    .qs     (classc_ctrl_en_e3_qs)
  );


  //   F[map_e0]: 7:6
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_classc_ctrl_map_e0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_ctrl_map_e0_we & regwen_qs),
    .wd     (classc_ctrl_map_e0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_ctrl.map_e0.q ),

    // to register interface (read)
    .qs     (classc_ctrl_map_e0_qs)
  );


  //   F[map_e1]: 9:8
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h1)
  ) u_classc_ctrl_map_e1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_ctrl_map_e1_we & regwen_qs),
    .wd     (classc_ctrl_map_e1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_ctrl.map_e1.q ),

    // to register interface (read)
    .qs     (classc_ctrl_map_e1_qs)
  );


  //   F[map_e2]: 11:10
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h2)
  ) u_classc_ctrl_map_e2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_ctrl_map_e2_we & regwen_qs),
    .wd     (classc_ctrl_map_e2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_ctrl.map_e2.q ),

    // to register interface (read)
    .qs     (classc_ctrl_map_e2_qs)
  );


  //   F[map_e3]: 13:12
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h3)
  ) u_classc_ctrl_map_e3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_ctrl_map_e3_we & regwen_qs),
    .wd     (classc_ctrl_map_e3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_ctrl.map_e3.q ),

    // to register interface (read)
    .qs     (classc_ctrl_map_e3_qs)
  );


  // R[classc_regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_classc_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (classc_regwen_we),
    .wd     (classc_regwen_wd),

    // from internal hardware
    .de     (hw2reg.classc_regwen.de),
    .d      (hw2reg.classc_regwen.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (classc_regwen_qs)
  );


  // R[classc_clr]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("WO"),
    .RESVAL  (1'h0)
  ) u_classc_clr (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_clr_we & classc_regwen_qs),
    .wd     (classc_clr_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.classc_clr.qe),
    .q      (reg2hw.classc_clr.q ),

    .qs     ()
  );


  // R[classc_accum_cnt]: V(True)

  prim_subreg_ext #(
    .DW    (16)
  ) u_classc_accum_cnt (
    .re     (classc_accum_cnt_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.classc_accum_cnt.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (classc_accum_cnt_qs)
  );


  // R[classc_accum_thresh]: V(False)

  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h0)
  ) u_classc_accum_thresh (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_accum_thresh_we & regwen_qs),
    .wd     (classc_accum_thresh_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_accum_thresh.q ),

    // to register interface (read)
    .qs     (classc_accum_thresh_qs)
  );


  // R[classc_timeout_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classc_timeout_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_timeout_cyc_we & regwen_qs),
    .wd     (classc_timeout_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_timeout_cyc.q ),

    // to register interface (read)
    .qs     (classc_timeout_cyc_qs)
  );


  // R[classc_phase0_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classc_phase0_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_phase0_cyc_we & regwen_qs),
    .wd     (classc_phase0_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_phase0_cyc.q ),

    // to register interface (read)
    .qs     (classc_phase0_cyc_qs)
  );


  // R[classc_phase1_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classc_phase1_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_phase1_cyc_we & regwen_qs),
    .wd     (classc_phase1_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_phase1_cyc.q ),

    // to register interface (read)
    .qs     (classc_phase1_cyc_qs)
  );


  // R[classc_phase2_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classc_phase2_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_phase2_cyc_we & regwen_qs),
    .wd     (classc_phase2_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_phase2_cyc.q ),

    // to register interface (read)
    .qs     (classc_phase2_cyc_qs)
  );


  // R[classc_phase3_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classc_phase3_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classc_phase3_cyc_we & regwen_qs),
    .wd     (classc_phase3_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classc_phase3_cyc.q ),

    // to register interface (read)
    .qs     (classc_phase3_cyc_qs)
  );


  // R[classc_esc_cnt]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_classc_esc_cnt (
    .re     (classc_esc_cnt_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.classc_esc_cnt.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (classc_esc_cnt_qs)
  );


  // R[classc_state]: V(True)

  prim_subreg_ext #(
    .DW    (3)
  ) u_classc_state (
    .re     (classc_state_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.classc_state.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (classc_state_qs)
  );


  // R[classd_ctrl]: V(False)

  //   F[en]: 0:0
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_classd_ctrl_en (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_ctrl_en_we & regwen_qs),
    .wd     (classd_ctrl_en_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_ctrl.en.q ),

    // to register interface (read)
    .qs     (classd_ctrl_en_qs)
  );


  //   F[lock]: 1:1
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h0)
  ) u_classd_ctrl_lock (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_ctrl_lock_we & regwen_qs),
    .wd     (classd_ctrl_lock_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_ctrl.lock.q ),

    // to register interface (read)
    .qs     (classd_ctrl_lock_qs)
  );


  //   F[en_e0]: 2:2
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classd_ctrl_en_e0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_ctrl_en_e0_we & regwen_qs),
    .wd     (classd_ctrl_en_e0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_ctrl.en_e0.q ),

    // to register interface (read)
    .qs     (classd_ctrl_en_e0_qs)
  );


  //   F[en_e1]: 3:3
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classd_ctrl_en_e1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_ctrl_en_e1_we & regwen_qs),
    .wd     (classd_ctrl_en_e1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_ctrl.en_e1.q ),

    // to register interface (read)
    .qs     (classd_ctrl_en_e1_qs)
  );


  //   F[en_e2]: 4:4
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classd_ctrl_en_e2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_ctrl_en_e2_we & regwen_qs),
    .wd     (classd_ctrl_en_e2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_ctrl.en_e2.q ),

    // to register interface (read)
    .qs     (classd_ctrl_en_e2_qs)
  );


  //   F[en_e3]: 5:5
  prim_subreg #(
    .DW      (1),
    .SWACCESS("RW"),
    .RESVAL  (1'h1)
  ) u_classd_ctrl_en_e3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_ctrl_en_e3_we & regwen_qs),
    .wd     (classd_ctrl_en_e3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_ctrl.en_e3.q ),

    // to register interface (read)
    .qs     (classd_ctrl_en_e3_qs)
  );


  //   F[map_e0]: 7:6
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h0)
  ) u_classd_ctrl_map_e0 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_ctrl_map_e0_we & regwen_qs),
    .wd     (classd_ctrl_map_e0_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_ctrl.map_e0.q ),

    // to register interface (read)
    .qs     (classd_ctrl_map_e0_qs)
  );


  //   F[map_e1]: 9:8
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h1)
  ) u_classd_ctrl_map_e1 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_ctrl_map_e1_we & regwen_qs),
    .wd     (classd_ctrl_map_e1_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_ctrl.map_e1.q ),

    // to register interface (read)
    .qs     (classd_ctrl_map_e1_qs)
  );


  //   F[map_e2]: 11:10
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h2)
  ) u_classd_ctrl_map_e2 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_ctrl_map_e2_we & regwen_qs),
    .wd     (classd_ctrl_map_e2_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_ctrl.map_e2.q ),

    // to register interface (read)
    .qs     (classd_ctrl_map_e2_qs)
  );


  //   F[map_e3]: 13:12
  prim_subreg #(
    .DW      (2),
    .SWACCESS("RW"),
    .RESVAL  (2'h3)
  ) u_classd_ctrl_map_e3 (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_ctrl_map_e3_we & regwen_qs),
    .wd     (classd_ctrl_map_e3_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_ctrl.map_e3.q ),

    // to register interface (read)
    .qs     (classd_ctrl_map_e3_qs)
  );


  // R[classd_regwen]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("W0C"),
    .RESVAL  (1'h1)
  ) u_classd_regwen (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface
    .we     (classd_regwen_we),
    .wd     (classd_regwen_wd),

    // from internal hardware
    .de     (hw2reg.classd_regwen.de),
    .d      (hw2reg.classd_regwen.d ),

    // to internal hardware
    .qe     (),
    .q      (),

    // to register interface (read)
    .qs     (classd_regwen_qs)
  );


  // R[classd_clr]: V(False)

  prim_subreg #(
    .DW      (1),
    .SWACCESS("WO"),
    .RESVAL  (1'h0)
  ) u_classd_clr (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_clr_we & classd_regwen_qs),
    .wd     (classd_clr_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (reg2hw.classd_clr.qe),
    .q      (reg2hw.classd_clr.q ),

    .qs     ()
  );


  // R[classd_accum_cnt]: V(True)

  prim_subreg_ext #(
    .DW    (16)
  ) u_classd_accum_cnt (
    .re     (classd_accum_cnt_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.classd_accum_cnt.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (classd_accum_cnt_qs)
  );


  // R[classd_accum_thresh]: V(False)

  prim_subreg #(
    .DW      (16),
    .SWACCESS("RW"),
    .RESVAL  (16'h0)
  ) u_classd_accum_thresh (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_accum_thresh_we & regwen_qs),
    .wd     (classd_accum_thresh_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_accum_thresh.q ),

    // to register interface (read)
    .qs     (classd_accum_thresh_qs)
  );


  // R[classd_timeout_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classd_timeout_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_timeout_cyc_we & regwen_qs),
    .wd     (classd_timeout_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_timeout_cyc.q ),

    // to register interface (read)
    .qs     (classd_timeout_cyc_qs)
  );


  // R[classd_phase0_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classd_phase0_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_phase0_cyc_we & regwen_qs),
    .wd     (classd_phase0_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_phase0_cyc.q ),

    // to register interface (read)
    .qs     (classd_phase0_cyc_qs)
  );


  // R[classd_phase1_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classd_phase1_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_phase1_cyc_we & regwen_qs),
    .wd     (classd_phase1_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_phase1_cyc.q ),

    // to register interface (read)
    .qs     (classd_phase1_cyc_qs)
  );


  // R[classd_phase2_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classd_phase2_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_phase2_cyc_we & regwen_qs),
    .wd     (classd_phase2_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_phase2_cyc.q ),

    // to register interface (read)
    .qs     (classd_phase2_cyc_qs)
  );


  // R[classd_phase3_cyc]: V(False)

  prim_subreg #(
    .DW      (32),
    .SWACCESS("RW"),
    .RESVAL  (32'h0)
  ) u_classd_phase3_cyc (
    .clk_i   (clk_i    ),
    .rst_ni  (rst_ni  ),

    // from register interface (qualified with register enable)
    .we     (classd_phase3_cyc_we & regwen_qs),
    .wd     (classd_phase3_cyc_wd),

    // from internal hardware
    .de     (1'b0),
    .d      ('0  ),

    // to internal hardware
    .qe     (),
    .q      (reg2hw.classd_phase3_cyc.q ),

    // to register interface (read)
    .qs     (classd_phase3_cyc_qs)
  );


  // R[classd_esc_cnt]: V(True)

  prim_subreg_ext #(
    .DW    (32)
  ) u_classd_esc_cnt (
    .re     (classd_esc_cnt_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.classd_esc_cnt.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (classd_esc_cnt_qs)
  );


  // R[classd_state]: V(True)

  prim_subreg_ext #(
    .DW    (3)
  ) u_classd_state (
    .re     (classd_state_re),
    .we     (1'b0),
    .wd     ('0),
    .d      (hw2reg.classd_state.d),
    .qre    (),
    .qe     (),
    .q      (),
    .qs     (classd_state_qs)
  );




  logic [58:0] addr_hit;
  always_comb begin
    addr_hit = '0;
    addr_hit[ 0] = (reg_addr == ALERT_HANDLER_INTR_STATE_OFFSET);
    addr_hit[ 1] = (reg_addr == ALERT_HANDLER_INTR_ENABLE_OFFSET);
    addr_hit[ 2] = (reg_addr == ALERT_HANDLER_INTR_TEST_OFFSET);
    addr_hit[ 3] = (reg_addr == ALERT_HANDLER_REGWEN_OFFSET);
    addr_hit[ 4] = (reg_addr == ALERT_HANDLER_PING_TIMEOUT_CYC_OFFSET);
    addr_hit[ 5] = (reg_addr == ALERT_HANDLER_ALERT_EN_OFFSET);
    addr_hit[ 6] = (reg_addr == ALERT_HANDLER_ALERT_CLASS_OFFSET);
    addr_hit[ 7] = (reg_addr == ALERT_HANDLER_ALERT_CAUSE_OFFSET);
    addr_hit[ 8] = (reg_addr == ALERT_HANDLER_LOC_ALERT_EN_OFFSET);
    addr_hit[ 9] = (reg_addr == ALERT_HANDLER_LOC_ALERT_CLASS_OFFSET);
    addr_hit[10] = (reg_addr == ALERT_HANDLER_LOC_ALERT_CAUSE_OFFSET);
    addr_hit[11] = (reg_addr == ALERT_HANDLER_CLASSA_CTRL_OFFSET);
    addr_hit[12] = (reg_addr == ALERT_HANDLER_CLASSA_REGWEN_OFFSET);
    addr_hit[13] = (reg_addr == ALERT_HANDLER_CLASSA_CLR_OFFSET);
    addr_hit[14] = (reg_addr == ALERT_HANDLER_CLASSA_ACCUM_CNT_OFFSET);
    addr_hit[15] = (reg_addr == ALERT_HANDLER_CLASSA_ACCUM_THRESH_OFFSET);
    addr_hit[16] = (reg_addr == ALERT_HANDLER_CLASSA_TIMEOUT_CYC_OFFSET);
    addr_hit[17] = (reg_addr == ALERT_HANDLER_CLASSA_PHASE0_CYC_OFFSET);
    addr_hit[18] = (reg_addr == ALERT_HANDLER_CLASSA_PHASE1_CYC_OFFSET);
    addr_hit[19] = (reg_addr == ALERT_HANDLER_CLASSA_PHASE2_CYC_OFFSET);
    addr_hit[20] = (reg_addr == ALERT_HANDLER_CLASSA_PHASE3_CYC_OFFSET);
    addr_hit[21] = (reg_addr == ALERT_HANDLER_CLASSA_ESC_CNT_OFFSET);
    addr_hit[22] = (reg_addr == ALERT_HANDLER_CLASSA_STATE_OFFSET);
    addr_hit[23] = (reg_addr == ALERT_HANDLER_CLASSB_CTRL_OFFSET);
    addr_hit[24] = (reg_addr == ALERT_HANDLER_CLASSB_REGWEN_OFFSET);
    addr_hit[25] = (reg_addr == ALERT_HANDLER_CLASSB_CLR_OFFSET);
    addr_hit[26] = (reg_addr == ALERT_HANDLER_CLASSB_ACCUM_CNT_OFFSET);
    addr_hit[27] = (reg_addr == ALERT_HANDLER_CLASSB_ACCUM_THRESH_OFFSET);
    addr_hit[28] = (reg_addr == ALERT_HANDLER_CLASSB_TIMEOUT_CYC_OFFSET);
    addr_hit[29] = (reg_addr == ALERT_HANDLER_CLASSB_PHASE0_CYC_OFFSET);
    addr_hit[30] = (reg_addr == ALERT_HANDLER_CLASSB_PHASE1_CYC_OFFSET);
    addr_hit[31] = (reg_addr == ALERT_HANDLER_CLASSB_PHASE2_CYC_OFFSET);
    addr_hit[32] = (reg_addr == ALERT_HANDLER_CLASSB_PHASE3_CYC_OFFSET);
    addr_hit[33] = (reg_addr == ALERT_HANDLER_CLASSB_ESC_CNT_OFFSET);
    addr_hit[34] = (reg_addr == ALERT_HANDLER_CLASSB_STATE_OFFSET);
    addr_hit[35] = (reg_addr == ALERT_HANDLER_CLASSC_CTRL_OFFSET);
    addr_hit[36] = (reg_addr == ALERT_HANDLER_CLASSC_REGWEN_OFFSET);
    addr_hit[37] = (reg_addr == ALERT_HANDLER_CLASSC_CLR_OFFSET);
    addr_hit[38] = (reg_addr == ALERT_HANDLER_CLASSC_ACCUM_CNT_OFFSET);
    addr_hit[39] = (reg_addr == ALERT_HANDLER_CLASSC_ACCUM_THRESH_OFFSET);
    addr_hit[40] = (reg_addr == ALERT_HANDLER_CLASSC_TIMEOUT_CYC_OFFSET);
    addr_hit[41] = (reg_addr == ALERT_HANDLER_CLASSC_PHASE0_CYC_OFFSET);
    addr_hit[42] = (reg_addr == ALERT_HANDLER_CLASSC_PHASE1_CYC_OFFSET);
    addr_hit[43] = (reg_addr == ALERT_HANDLER_CLASSC_PHASE2_CYC_OFFSET);
    addr_hit[44] = (reg_addr == ALERT_HANDLER_CLASSC_PHASE3_CYC_OFFSET);
    addr_hit[45] = (reg_addr == ALERT_HANDLER_CLASSC_ESC_CNT_OFFSET);
    addr_hit[46] = (reg_addr == ALERT_HANDLER_CLASSC_STATE_OFFSET);
    addr_hit[47] = (reg_addr == ALERT_HANDLER_CLASSD_CTRL_OFFSET);
    addr_hit[48] = (reg_addr == ALERT_HANDLER_CLASSD_REGWEN_OFFSET);
    addr_hit[49] = (reg_addr == ALERT_HANDLER_CLASSD_CLR_OFFSET);
    addr_hit[50] = (reg_addr == ALERT_HANDLER_CLASSD_ACCUM_CNT_OFFSET);
    addr_hit[51] = (reg_addr == ALERT_HANDLER_CLASSD_ACCUM_THRESH_OFFSET);
    addr_hit[52] = (reg_addr == ALERT_HANDLER_CLASSD_TIMEOUT_CYC_OFFSET);
    addr_hit[53] = (reg_addr == ALERT_HANDLER_CLASSD_PHASE0_CYC_OFFSET);
    addr_hit[54] = (reg_addr == ALERT_HANDLER_CLASSD_PHASE1_CYC_OFFSET);
    addr_hit[55] = (reg_addr == ALERT_HANDLER_CLASSD_PHASE2_CYC_OFFSET);
    addr_hit[56] = (reg_addr == ALERT_HANDLER_CLASSD_PHASE3_CYC_OFFSET);
    addr_hit[57] = (reg_addr == ALERT_HANDLER_CLASSD_ESC_CNT_OFFSET);
    addr_hit[58] = (reg_addr == ALERT_HANDLER_CLASSD_STATE_OFFSET);
  end

  assign addrmiss = (reg_re || reg_we) ? ~|addr_hit : 1'b0 ;

  // Check sub-word write is permitted
  always_comb begin
    wr_err = 1'b0;
    if (addr_hit[ 0] && reg_we && (ALERT_HANDLER_PERMIT[ 0] != (ALERT_HANDLER_PERMIT[ 0] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 1] && reg_we && (ALERT_HANDLER_PERMIT[ 1] != (ALERT_HANDLER_PERMIT[ 1] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 2] && reg_we && (ALERT_HANDLER_PERMIT[ 2] != (ALERT_HANDLER_PERMIT[ 2] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 3] && reg_we && (ALERT_HANDLER_PERMIT[ 3] != (ALERT_HANDLER_PERMIT[ 3] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 4] && reg_we && (ALERT_HANDLER_PERMIT[ 4] != (ALERT_HANDLER_PERMIT[ 4] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 5] && reg_we && (ALERT_HANDLER_PERMIT[ 5] != (ALERT_HANDLER_PERMIT[ 5] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 6] && reg_we && (ALERT_HANDLER_PERMIT[ 6] != (ALERT_HANDLER_PERMIT[ 6] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 7] && reg_we && (ALERT_HANDLER_PERMIT[ 7] != (ALERT_HANDLER_PERMIT[ 7] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 8] && reg_we && (ALERT_HANDLER_PERMIT[ 8] != (ALERT_HANDLER_PERMIT[ 8] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[ 9] && reg_we && (ALERT_HANDLER_PERMIT[ 9] != (ALERT_HANDLER_PERMIT[ 9] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[10] && reg_we && (ALERT_HANDLER_PERMIT[10] != (ALERT_HANDLER_PERMIT[10] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[11] && reg_we && (ALERT_HANDLER_PERMIT[11] != (ALERT_HANDLER_PERMIT[11] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[12] && reg_we && (ALERT_HANDLER_PERMIT[12] != (ALERT_HANDLER_PERMIT[12] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[13] && reg_we && (ALERT_HANDLER_PERMIT[13] != (ALERT_HANDLER_PERMIT[13] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[14] && reg_we && (ALERT_HANDLER_PERMIT[14] != (ALERT_HANDLER_PERMIT[14] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[15] && reg_we && (ALERT_HANDLER_PERMIT[15] != (ALERT_HANDLER_PERMIT[15] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[16] && reg_we && (ALERT_HANDLER_PERMIT[16] != (ALERT_HANDLER_PERMIT[16] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[17] && reg_we && (ALERT_HANDLER_PERMIT[17] != (ALERT_HANDLER_PERMIT[17] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[18] && reg_we && (ALERT_HANDLER_PERMIT[18] != (ALERT_HANDLER_PERMIT[18] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[19] && reg_we && (ALERT_HANDLER_PERMIT[19] != (ALERT_HANDLER_PERMIT[19] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[20] && reg_we && (ALERT_HANDLER_PERMIT[20] != (ALERT_HANDLER_PERMIT[20] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[21] && reg_we && (ALERT_HANDLER_PERMIT[21] != (ALERT_HANDLER_PERMIT[21] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[22] && reg_we && (ALERT_HANDLER_PERMIT[22] != (ALERT_HANDLER_PERMIT[22] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[23] && reg_we && (ALERT_HANDLER_PERMIT[23] != (ALERT_HANDLER_PERMIT[23] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[24] && reg_we && (ALERT_HANDLER_PERMIT[24] != (ALERT_HANDLER_PERMIT[24] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[25] && reg_we && (ALERT_HANDLER_PERMIT[25] != (ALERT_HANDLER_PERMIT[25] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[26] && reg_we && (ALERT_HANDLER_PERMIT[26] != (ALERT_HANDLER_PERMIT[26] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[27] && reg_we && (ALERT_HANDLER_PERMIT[27] != (ALERT_HANDLER_PERMIT[27] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[28] && reg_we && (ALERT_HANDLER_PERMIT[28] != (ALERT_HANDLER_PERMIT[28] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[29] && reg_we && (ALERT_HANDLER_PERMIT[29] != (ALERT_HANDLER_PERMIT[29] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[30] && reg_we && (ALERT_HANDLER_PERMIT[30] != (ALERT_HANDLER_PERMIT[30] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[31] && reg_we && (ALERT_HANDLER_PERMIT[31] != (ALERT_HANDLER_PERMIT[31] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[32] && reg_we && (ALERT_HANDLER_PERMIT[32] != (ALERT_HANDLER_PERMIT[32] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[33] && reg_we && (ALERT_HANDLER_PERMIT[33] != (ALERT_HANDLER_PERMIT[33] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[34] && reg_we && (ALERT_HANDLER_PERMIT[34] != (ALERT_HANDLER_PERMIT[34] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[35] && reg_we && (ALERT_HANDLER_PERMIT[35] != (ALERT_HANDLER_PERMIT[35] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[36] && reg_we && (ALERT_HANDLER_PERMIT[36] != (ALERT_HANDLER_PERMIT[36] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[37] && reg_we && (ALERT_HANDLER_PERMIT[37] != (ALERT_HANDLER_PERMIT[37] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[38] && reg_we && (ALERT_HANDLER_PERMIT[38] != (ALERT_HANDLER_PERMIT[38] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[39] && reg_we && (ALERT_HANDLER_PERMIT[39] != (ALERT_HANDLER_PERMIT[39] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[40] && reg_we && (ALERT_HANDLER_PERMIT[40] != (ALERT_HANDLER_PERMIT[40] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[41] && reg_we && (ALERT_HANDLER_PERMIT[41] != (ALERT_HANDLER_PERMIT[41] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[42] && reg_we && (ALERT_HANDLER_PERMIT[42] != (ALERT_HANDLER_PERMIT[42] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[43] && reg_we && (ALERT_HANDLER_PERMIT[43] != (ALERT_HANDLER_PERMIT[43] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[44] && reg_we && (ALERT_HANDLER_PERMIT[44] != (ALERT_HANDLER_PERMIT[44] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[45] && reg_we && (ALERT_HANDLER_PERMIT[45] != (ALERT_HANDLER_PERMIT[45] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[46] && reg_we && (ALERT_HANDLER_PERMIT[46] != (ALERT_HANDLER_PERMIT[46] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[47] && reg_we && (ALERT_HANDLER_PERMIT[47] != (ALERT_HANDLER_PERMIT[47] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[48] && reg_we && (ALERT_HANDLER_PERMIT[48] != (ALERT_HANDLER_PERMIT[48] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[49] && reg_we && (ALERT_HANDLER_PERMIT[49] != (ALERT_HANDLER_PERMIT[49] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[50] && reg_we && (ALERT_HANDLER_PERMIT[50] != (ALERT_HANDLER_PERMIT[50] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[51] && reg_we && (ALERT_HANDLER_PERMIT[51] != (ALERT_HANDLER_PERMIT[51] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[52] && reg_we && (ALERT_HANDLER_PERMIT[52] != (ALERT_HANDLER_PERMIT[52] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[53] && reg_we && (ALERT_HANDLER_PERMIT[53] != (ALERT_HANDLER_PERMIT[53] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[54] && reg_we && (ALERT_HANDLER_PERMIT[54] != (ALERT_HANDLER_PERMIT[54] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[55] && reg_we && (ALERT_HANDLER_PERMIT[55] != (ALERT_HANDLER_PERMIT[55] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[56] && reg_we && (ALERT_HANDLER_PERMIT[56] != (ALERT_HANDLER_PERMIT[56] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[57] && reg_we && (ALERT_HANDLER_PERMIT[57] != (ALERT_HANDLER_PERMIT[57] & reg_be))) wr_err = 1'b1 ;
    if (addr_hit[58] && reg_we && (ALERT_HANDLER_PERMIT[58] != (ALERT_HANDLER_PERMIT[58] & reg_be))) wr_err = 1'b1 ;
  end

  assign intr_state_classa_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_classa_wd = reg_wdata[0];

  assign intr_state_classb_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_classb_wd = reg_wdata[1];

  assign intr_state_classc_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_classc_wd = reg_wdata[2];

  assign intr_state_classd_we = addr_hit[0] & reg_we & !reg_error;
  assign intr_state_classd_wd = reg_wdata[3];

  assign intr_enable_classa_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_classa_wd = reg_wdata[0];

  assign intr_enable_classb_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_classb_wd = reg_wdata[1];

  assign intr_enable_classc_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_classc_wd = reg_wdata[2];

  assign intr_enable_classd_we = addr_hit[1] & reg_we & !reg_error;
  assign intr_enable_classd_wd = reg_wdata[3];

  assign intr_test_classa_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_classa_wd = reg_wdata[0];

  assign intr_test_classb_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_classb_wd = reg_wdata[1];

  assign intr_test_classc_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_classc_wd = reg_wdata[2];

  assign intr_test_classd_we = addr_hit[2] & reg_we & !reg_error;
  assign intr_test_classd_wd = reg_wdata[3];

  assign regwen_we = addr_hit[3] & reg_we & !reg_error;
  assign regwen_wd = reg_wdata[0];

  assign ping_timeout_cyc_we = addr_hit[4] & reg_we & !reg_error;
  assign ping_timeout_cyc_wd = reg_wdata[23:0];

  assign alert_en_en_a_0_we = addr_hit[5] & reg_we & !reg_error;
  assign alert_en_en_a_0_wd = reg_wdata[0];

  assign alert_en_en_a_1_we = addr_hit[5] & reg_we & !reg_error;
  assign alert_en_en_a_1_wd = reg_wdata[1];

  assign alert_en_en_a_2_we = addr_hit[5] & reg_we & !reg_error;
  assign alert_en_en_a_2_wd = reg_wdata[2];

  assign alert_en_en_a_3_we = addr_hit[5] & reg_we & !reg_error;
  assign alert_en_en_a_3_wd = reg_wdata[3];

  assign alert_class_class_a_0_we = addr_hit[6] & reg_we & !reg_error;
  assign alert_class_class_a_0_wd = reg_wdata[1:0];

  assign alert_class_class_a_1_we = addr_hit[6] & reg_we & !reg_error;
  assign alert_class_class_a_1_wd = reg_wdata[3:2];

  assign alert_class_class_a_2_we = addr_hit[6] & reg_we & !reg_error;
  assign alert_class_class_a_2_wd = reg_wdata[5:4];

  assign alert_class_class_a_3_we = addr_hit[6] & reg_we & !reg_error;
  assign alert_class_class_a_3_wd = reg_wdata[7:6];

  assign alert_cause_a_0_we = addr_hit[7] & reg_we & !reg_error;
  assign alert_cause_a_0_wd = reg_wdata[0];

  assign alert_cause_a_1_we = addr_hit[7] & reg_we & !reg_error;
  assign alert_cause_a_1_wd = reg_wdata[1];

  assign alert_cause_a_2_we = addr_hit[7] & reg_we & !reg_error;
  assign alert_cause_a_2_wd = reg_wdata[2];

  assign alert_cause_a_3_we = addr_hit[7] & reg_we & !reg_error;
  assign alert_cause_a_3_wd = reg_wdata[3];

  assign loc_alert_en_en_la_0_we = addr_hit[8] & reg_we & !reg_error;
  assign loc_alert_en_en_la_0_wd = reg_wdata[0];

  assign loc_alert_en_en_la_1_we = addr_hit[8] & reg_we & !reg_error;
  assign loc_alert_en_en_la_1_wd = reg_wdata[1];

  assign loc_alert_en_en_la_2_we = addr_hit[8] & reg_we & !reg_error;
  assign loc_alert_en_en_la_2_wd = reg_wdata[2];

  assign loc_alert_en_en_la_3_we = addr_hit[8] & reg_we & !reg_error;
  assign loc_alert_en_en_la_3_wd = reg_wdata[3];

  assign loc_alert_class_class_la_0_we = addr_hit[9] & reg_we & !reg_error;
  assign loc_alert_class_class_la_0_wd = reg_wdata[1:0];

  assign loc_alert_class_class_la_1_we = addr_hit[9] & reg_we & !reg_error;
  assign loc_alert_class_class_la_1_wd = reg_wdata[3:2];

  assign loc_alert_class_class_la_2_we = addr_hit[9] & reg_we & !reg_error;
  assign loc_alert_class_class_la_2_wd = reg_wdata[5:4];

  assign loc_alert_class_class_la_3_we = addr_hit[9] & reg_we & !reg_error;
  assign loc_alert_class_class_la_3_wd = reg_wdata[7:6];

  assign loc_alert_cause_la_0_we = addr_hit[10] & reg_we & !reg_error;
  assign loc_alert_cause_la_0_wd = reg_wdata[0];

  assign loc_alert_cause_la_1_we = addr_hit[10] & reg_we & !reg_error;
  assign loc_alert_cause_la_1_wd = reg_wdata[1];

  assign loc_alert_cause_la_2_we = addr_hit[10] & reg_we & !reg_error;
  assign loc_alert_cause_la_2_wd = reg_wdata[2];

  assign loc_alert_cause_la_3_we = addr_hit[10] & reg_we & !reg_error;
  assign loc_alert_cause_la_3_wd = reg_wdata[3];

  assign classa_ctrl_en_we = addr_hit[11] & reg_we & !reg_error;
  assign classa_ctrl_en_wd = reg_wdata[0];

  assign classa_ctrl_lock_we = addr_hit[11] & reg_we & !reg_error;
  assign classa_ctrl_lock_wd = reg_wdata[1];

  assign classa_ctrl_en_e0_we = addr_hit[11] & reg_we & !reg_error;
  assign classa_ctrl_en_e0_wd = reg_wdata[2];

  assign classa_ctrl_en_e1_we = addr_hit[11] & reg_we & !reg_error;
  assign classa_ctrl_en_e1_wd = reg_wdata[3];

  assign classa_ctrl_en_e2_we = addr_hit[11] & reg_we & !reg_error;
  assign classa_ctrl_en_e2_wd = reg_wdata[4];

  assign classa_ctrl_en_e3_we = addr_hit[11] & reg_we & !reg_error;
  assign classa_ctrl_en_e3_wd = reg_wdata[5];

  assign classa_ctrl_map_e0_we = addr_hit[11] & reg_we & !reg_error;
  assign classa_ctrl_map_e0_wd = reg_wdata[7:6];

  assign classa_ctrl_map_e1_we = addr_hit[11] & reg_we & !reg_error;
  assign classa_ctrl_map_e1_wd = reg_wdata[9:8];

  assign classa_ctrl_map_e2_we = addr_hit[11] & reg_we & !reg_error;
  assign classa_ctrl_map_e2_wd = reg_wdata[11:10];

  assign classa_ctrl_map_e3_we = addr_hit[11] & reg_we & !reg_error;
  assign classa_ctrl_map_e3_wd = reg_wdata[13:12];

  assign classa_regwen_we = addr_hit[12] & reg_we & !reg_error;
  assign classa_regwen_wd = reg_wdata[0];

  assign classa_clr_we = addr_hit[13] & reg_we & !reg_error;
  assign classa_clr_wd = reg_wdata[0];

  assign classa_accum_cnt_re = addr_hit[14] & reg_re & !reg_error;

  assign classa_accum_thresh_we = addr_hit[15] & reg_we & !reg_error;
  assign classa_accum_thresh_wd = reg_wdata[15:0];

  assign classa_timeout_cyc_we = addr_hit[16] & reg_we & !reg_error;
  assign classa_timeout_cyc_wd = reg_wdata[31:0];

  assign classa_phase0_cyc_we = addr_hit[17] & reg_we & !reg_error;
  assign classa_phase0_cyc_wd = reg_wdata[31:0];

  assign classa_phase1_cyc_we = addr_hit[18] & reg_we & !reg_error;
  assign classa_phase1_cyc_wd = reg_wdata[31:0];

  assign classa_phase2_cyc_we = addr_hit[19] & reg_we & !reg_error;
  assign classa_phase2_cyc_wd = reg_wdata[31:0];

  assign classa_phase3_cyc_we = addr_hit[20] & reg_we & !reg_error;
  assign classa_phase3_cyc_wd = reg_wdata[31:0];

  assign classa_esc_cnt_re = addr_hit[21] & reg_re & !reg_error;

  assign classa_state_re = addr_hit[22] & reg_re & !reg_error;

  assign classb_ctrl_en_we = addr_hit[23] & reg_we & !reg_error;
  assign classb_ctrl_en_wd = reg_wdata[0];

  assign classb_ctrl_lock_we = addr_hit[23] & reg_we & !reg_error;
  assign classb_ctrl_lock_wd = reg_wdata[1];

  assign classb_ctrl_en_e0_we = addr_hit[23] & reg_we & !reg_error;
  assign classb_ctrl_en_e0_wd = reg_wdata[2];

  assign classb_ctrl_en_e1_we = addr_hit[23] & reg_we & !reg_error;
  assign classb_ctrl_en_e1_wd = reg_wdata[3];

  assign classb_ctrl_en_e2_we = addr_hit[23] & reg_we & !reg_error;
  assign classb_ctrl_en_e2_wd = reg_wdata[4];

  assign classb_ctrl_en_e3_we = addr_hit[23] & reg_we & !reg_error;
  assign classb_ctrl_en_e3_wd = reg_wdata[5];

  assign classb_ctrl_map_e0_we = addr_hit[23] & reg_we & !reg_error;
  assign classb_ctrl_map_e0_wd = reg_wdata[7:6];

  assign classb_ctrl_map_e1_we = addr_hit[23] & reg_we & !reg_error;
  assign classb_ctrl_map_e1_wd = reg_wdata[9:8];

  assign classb_ctrl_map_e2_we = addr_hit[23] & reg_we & !reg_error;
  assign classb_ctrl_map_e2_wd = reg_wdata[11:10];

  assign classb_ctrl_map_e3_we = addr_hit[23] & reg_we & !reg_error;
  assign classb_ctrl_map_e3_wd = reg_wdata[13:12];

  assign classb_regwen_we = addr_hit[24] & reg_we & !reg_error;
  assign classb_regwen_wd = reg_wdata[0];

  assign classb_clr_we = addr_hit[25] & reg_we & !reg_error;
  assign classb_clr_wd = reg_wdata[0];

  assign classb_accum_cnt_re = addr_hit[26] & reg_re & !reg_error;

  assign classb_accum_thresh_we = addr_hit[27] & reg_we & !reg_error;
  assign classb_accum_thresh_wd = reg_wdata[15:0];

  assign classb_timeout_cyc_we = addr_hit[28] & reg_we & !reg_error;
  assign classb_timeout_cyc_wd = reg_wdata[31:0];

  assign classb_phase0_cyc_we = addr_hit[29] & reg_we & !reg_error;
  assign classb_phase0_cyc_wd = reg_wdata[31:0];

  assign classb_phase1_cyc_we = addr_hit[30] & reg_we & !reg_error;
  assign classb_phase1_cyc_wd = reg_wdata[31:0];

  assign classb_phase2_cyc_we = addr_hit[31] & reg_we & !reg_error;
  assign classb_phase2_cyc_wd = reg_wdata[31:0];

  assign classb_phase3_cyc_we = addr_hit[32] & reg_we & !reg_error;
  assign classb_phase3_cyc_wd = reg_wdata[31:0];

  assign classb_esc_cnt_re = addr_hit[33] & reg_re & !reg_error;

  assign classb_state_re = addr_hit[34] & reg_re & !reg_error;

  assign classc_ctrl_en_we = addr_hit[35] & reg_we & !reg_error;
  assign classc_ctrl_en_wd = reg_wdata[0];

  assign classc_ctrl_lock_we = addr_hit[35] & reg_we & !reg_error;
  assign classc_ctrl_lock_wd = reg_wdata[1];

  assign classc_ctrl_en_e0_we = addr_hit[35] & reg_we & !reg_error;
  assign classc_ctrl_en_e0_wd = reg_wdata[2];

  assign classc_ctrl_en_e1_we = addr_hit[35] & reg_we & !reg_error;
  assign classc_ctrl_en_e1_wd = reg_wdata[3];

  assign classc_ctrl_en_e2_we = addr_hit[35] & reg_we & !reg_error;
  assign classc_ctrl_en_e2_wd = reg_wdata[4];

  assign classc_ctrl_en_e3_we = addr_hit[35] & reg_we & !reg_error;
  assign classc_ctrl_en_e3_wd = reg_wdata[5];

  assign classc_ctrl_map_e0_we = addr_hit[35] & reg_we & !reg_error;
  assign classc_ctrl_map_e0_wd = reg_wdata[7:6];

  assign classc_ctrl_map_e1_we = addr_hit[35] & reg_we & !reg_error;
  assign classc_ctrl_map_e1_wd = reg_wdata[9:8];

  assign classc_ctrl_map_e2_we = addr_hit[35] & reg_we & !reg_error;
  assign classc_ctrl_map_e2_wd = reg_wdata[11:10];

  assign classc_ctrl_map_e3_we = addr_hit[35] & reg_we & !reg_error;
  assign classc_ctrl_map_e3_wd = reg_wdata[13:12];

  assign classc_regwen_we = addr_hit[36] & reg_we & !reg_error;
  assign classc_regwen_wd = reg_wdata[0];

  assign classc_clr_we = addr_hit[37] & reg_we & !reg_error;
  assign classc_clr_wd = reg_wdata[0];

  assign classc_accum_cnt_re = addr_hit[38] & reg_re & !reg_error;

  assign classc_accum_thresh_we = addr_hit[39] & reg_we & !reg_error;
  assign classc_accum_thresh_wd = reg_wdata[15:0];

  assign classc_timeout_cyc_we = addr_hit[40] & reg_we & !reg_error;
  assign classc_timeout_cyc_wd = reg_wdata[31:0];

  assign classc_phase0_cyc_we = addr_hit[41] & reg_we & !reg_error;
  assign classc_phase0_cyc_wd = reg_wdata[31:0];

  assign classc_phase1_cyc_we = addr_hit[42] & reg_we & !reg_error;
  assign classc_phase1_cyc_wd = reg_wdata[31:0];

  assign classc_phase2_cyc_we = addr_hit[43] & reg_we & !reg_error;
  assign classc_phase2_cyc_wd = reg_wdata[31:0];

  assign classc_phase3_cyc_we = addr_hit[44] & reg_we & !reg_error;
  assign classc_phase3_cyc_wd = reg_wdata[31:0];

  assign classc_esc_cnt_re = addr_hit[45] & reg_re & !reg_error;

  assign classc_state_re = addr_hit[46] & reg_re & !reg_error;

  assign classd_ctrl_en_we = addr_hit[47] & reg_we & !reg_error;
  assign classd_ctrl_en_wd = reg_wdata[0];

  assign classd_ctrl_lock_we = addr_hit[47] & reg_we & !reg_error;
  assign classd_ctrl_lock_wd = reg_wdata[1];

  assign classd_ctrl_en_e0_we = addr_hit[47] & reg_we & !reg_error;
  assign classd_ctrl_en_e0_wd = reg_wdata[2];

  assign classd_ctrl_en_e1_we = addr_hit[47] & reg_we & !reg_error;
  assign classd_ctrl_en_e1_wd = reg_wdata[3];

  assign classd_ctrl_en_e2_we = addr_hit[47] & reg_we & !reg_error;
  assign classd_ctrl_en_e2_wd = reg_wdata[4];

  assign classd_ctrl_en_e3_we = addr_hit[47] & reg_we & !reg_error;
  assign classd_ctrl_en_e3_wd = reg_wdata[5];

  assign classd_ctrl_map_e0_we = addr_hit[47] & reg_we & !reg_error;
  assign classd_ctrl_map_e0_wd = reg_wdata[7:6];

  assign classd_ctrl_map_e1_we = addr_hit[47] & reg_we & !reg_error;
  assign classd_ctrl_map_e1_wd = reg_wdata[9:8];

  assign classd_ctrl_map_e2_we = addr_hit[47] & reg_we & !reg_error;
  assign classd_ctrl_map_e2_wd = reg_wdata[11:10];

  assign classd_ctrl_map_e3_we = addr_hit[47] & reg_we & !reg_error;
  assign classd_ctrl_map_e3_wd = reg_wdata[13:12];

  assign classd_regwen_we = addr_hit[48] & reg_we & !reg_error;
  assign classd_regwen_wd = reg_wdata[0];

  assign classd_clr_we = addr_hit[49] & reg_we & !reg_error;
  assign classd_clr_wd = reg_wdata[0];

  assign classd_accum_cnt_re = addr_hit[50] & reg_re & !reg_error;

  assign classd_accum_thresh_we = addr_hit[51] & reg_we & !reg_error;
  assign classd_accum_thresh_wd = reg_wdata[15:0];

  assign classd_timeout_cyc_we = addr_hit[52] & reg_we & !reg_error;
  assign classd_timeout_cyc_wd = reg_wdata[31:0];

  assign classd_phase0_cyc_we = addr_hit[53] & reg_we & !reg_error;
  assign classd_phase0_cyc_wd = reg_wdata[31:0];

  assign classd_phase1_cyc_we = addr_hit[54] & reg_we & !reg_error;
  assign classd_phase1_cyc_wd = reg_wdata[31:0];

  assign classd_phase2_cyc_we = addr_hit[55] & reg_we & !reg_error;
  assign classd_phase2_cyc_wd = reg_wdata[31:0];

  assign classd_phase3_cyc_we = addr_hit[56] & reg_we & !reg_error;
  assign classd_phase3_cyc_wd = reg_wdata[31:0];

  assign classd_esc_cnt_re = addr_hit[57] & reg_re & !reg_error;

  assign classd_state_re = addr_hit[58] & reg_re & !reg_error;

  // Read data return
  always_comb begin
    reg_rdata_next = '0;
    unique case (1'b1)
      addr_hit[0]: begin
        reg_rdata_next[0] = intr_state_classa_qs;
        reg_rdata_next[1] = intr_state_classb_qs;
        reg_rdata_next[2] = intr_state_classc_qs;
        reg_rdata_next[3] = intr_state_classd_qs;
      end

      addr_hit[1]: begin
        reg_rdata_next[0] = intr_enable_classa_qs;
        reg_rdata_next[1] = intr_enable_classb_qs;
        reg_rdata_next[2] = intr_enable_classc_qs;
        reg_rdata_next[3] = intr_enable_classd_qs;
      end

      addr_hit[2]: begin
        reg_rdata_next[0] = '0;
        reg_rdata_next[1] = '0;
        reg_rdata_next[2] = '0;
        reg_rdata_next[3] = '0;
      end

      addr_hit[3]: begin
        reg_rdata_next[0] = regwen_qs;
      end

      addr_hit[4]: begin
        reg_rdata_next[23:0] = ping_timeout_cyc_qs;
      end

      addr_hit[5]: begin
        reg_rdata_next[0] = alert_en_en_a_0_qs;
        reg_rdata_next[1] = alert_en_en_a_1_qs;
        reg_rdata_next[2] = alert_en_en_a_2_qs;
        reg_rdata_next[3] = alert_en_en_a_3_qs;
      end

      addr_hit[6]: begin
        reg_rdata_next[1:0] = alert_class_class_a_0_qs;
        reg_rdata_next[3:2] = alert_class_class_a_1_qs;
        reg_rdata_next[5:4] = alert_class_class_a_2_qs;
        reg_rdata_next[7:6] = alert_class_class_a_3_qs;
      end

      addr_hit[7]: begin
        reg_rdata_next[0] = alert_cause_a_0_qs;
        reg_rdata_next[1] = alert_cause_a_1_qs;
        reg_rdata_next[2] = alert_cause_a_2_qs;
        reg_rdata_next[3] = alert_cause_a_3_qs;
      end

      addr_hit[8]: begin
        reg_rdata_next[0] = loc_alert_en_en_la_0_qs;
        reg_rdata_next[1] = loc_alert_en_en_la_1_qs;
        reg_rdata_next[2] = loc_alert_en_en_la_2_qs;
        reg_rdata_next[3] = loc_alert_en_en_la_3_qs;
      end

      addr_hit[9]: begin
        reg_rdata_next[1:0] = loc_alert_class_class_la_0_qs;
        reg_rdata_next[3:2] = loc_alert_class_class_la_1_qs;
        reg_rdata_next[5:4] = loc_alert_class_class_la_2_qs;
        reg_rdata_next[7:6] = loc_alert_class_class_la_3_qs;
      end

      addr_hit[10]: begin
        reg_rdata_next[0] = loc_alert_cause_la_0_qs;
        reg_rdata_next[1] = loc_alert_cause_la_1_qs;
        reg_rdata_next[2] = loc_alert_cause_la_2_qs;
        reg_rdata_next[3] = loc_alert_cause_la_3_qs;
      end

      addr_hit[11]: begin
        reg_rdata_next[0] = classa_ctrl_en_qs;
        reg_rdata_next[1] = classa_ctrl_lock_qs;
        reg_rdata_next[2] = classa_ctrl_en_e0_qs;
        reg_rdata_next[3] = classa_ctrl_en_e1_qs;
        reg_rdata_next[4] = classa_ctrl_en_e2_qs;
        reg_rdata_next[5] = classa_ctrl_en_e3_qs;
        reg_rdata_next[7:6] = classa_ctrl_map_e0_qs;
        reg_rdata_next[9:8] = classa_ctrl_map_e1_qs;
        reg_rdata_next[11:10] = classa_ctrl_map_e2_qs;
        reg_rdata_next[13:12] = classa_ctrl_map_e3_qs;
      end

      addr_hit[12]: begin
        reg_rdata_next[0] = classa_regwen_qs;
      end

      addr_hit[13]: begin
        reg_rdata_next[0] = '0;
      end

      addr_hit[14]: begin
        reg_rdata_next[15:0] = classa_accum_cnt_qs;
      end

      addr_hit[15]: begin
        reg_rdata_next[15:0] = classa_accum_thresh_qs;
      end

      addr_hit[16]: begin
        reg_rdata_next[31:0] = classa_timeout_cyc_qs;
      end

      addr_hit[17]: begin
        reg_rdata_next[31:0] = classa_phase0_cyc_qs;
      end

      addr_hit[18]: begin
        reg_rdata_next[31:0] = classa_phase1_cyc_qs;
      end

      addr_hit[19]: begin
        reg_rdata_next[31:0] = classa_phase2_cyc_qs;
      end

      addr_hit[20]: begin
        reg_rdata_next[31:0] = classa_phase3_cyc_qs;
      end

      addr_hit[21]: begin
        reg_rdata_next[31:0] = classa_esc_cnt_qs;
      end

      addr_hit[22]: begin
        reg_rdata_next[2:0] = classa_state_qs;
      end

      addr_hit[23]: begin
        reg_rdata_next[0] = classb_ctrl_en_qs;
        reg_rdata_next[1] = classb_ctrl_lock_qs;
        reg_rdata_next[2] = classb_ctrl_en_e0_qs;
        reg_rdata_next[3] = classb_ctrl_en_e1_qs;
        reg_rdata_next[4] = classb_ctrl_en_e2_qs;
        reg_rdata_next[5] = classb_ctrl_en_e3_qs;
        reg_rdata_next[7:6] = classb_ctrl_map_e0_qs;
        reg_rdata_next[9:8] = classb_ctrl_map_e1_qs;
        reg_rdata_next[11:10] = classb_ctrl_map_e2_qs;
        reg_rdata_next[13:12] = classb_ctrl_map_e3_qs;
      end

      addr_hit[24]: begin
        reg_rdata_next[0] = classb_regwen_qs;
      end

      addr_hit[25]: begin
        reg_rdata_next[0] = '0;
      end

      addr_hit[26]: begin
        reg_rdata_next[15:0] = classb_accum_cnt_qs;
      end

      addr_hit[27]: begin
        reg_rdata_next[15:0] = classb_accum_thresh_qs;
      end

      addr_hit[28]: begin
        reg_rdata_next[31:0] = classb_timeout_cyc_qs;
      end

      addr_hit[29]: begin
        reg_rdata_next[31:0] = classb_phase0_cyc_qs;
      end

      addr_hit[30]: begin
        reg_rdata_next[31:0] = classb_phase1_cyc_qs;
      end

      addr_hit[31]: begin
        reg_rdata_next[31:0] = classb_phase2_cyc_qs;
      end

      addr_hit[32]: begin
        reg_rdata_next[31:0] = classb_phase3_cyc_qs;
      end

      addr_hit[33]: begin
        reg_rdata_next[31:0] = classb_esc_cnt_qs;
      end

      addr_hit[34]: begin
        reg_rdata_next[2:0] = classb_state_qs;
      end

      addr_hit[35]: begin
        reg_rdata_next[0] = classc_ctrl_en_qs;
        reg_rdata_next[1] = classc_ctrl_lock_qs;
        reg_rdata_next[2] = classc_ctrl_en_e0_qs;
        reg_rdata_next[3] = classc_ctrl_en_e1_qs;
        reg_rdata_next[4] = classc_ctrl_en_e2_qs;
        reg_rdata_next[5] = classc_ctrl_en_e3_qs;
        reg_rdata_next[7:6] = classc_ctrl_map_e0_qs;
        reg_rdata_next[9:8] = classc_ctrl_map_e1_qs;
        reg_rdata_next[11:10] = classc_ctrl_map_e2_qs;
        reg_rdata_next[13:12] = classc_ctrl_map_e3_qs;
      end

      addr_hit[36]: begin
        reg_rdata_next[0] = classc_regwen_qs;
      end

      addr_hit[37]: begin
        reg_rdata_next[0] = '0;
      end

      addr_hit[38]: begin
        reg_rdata_next[15:0] = classc_accum_cnt_qs;
      end

      addr_hit[39]: begin
        reg_rdata_next[15:0] = classc_accum_thresh_qs;
      end

      addr_hit[40]: begin
        reg_rdata_next[31:0] = classc_timeout_cyc_qs;
      end

      addr_hit[41]: begin
        reg_rdata_next[31:0] = classc_phase0_cyc_qs;
      end

      addr_hit[42]: begin
        reg_rdata_next[31:0] = classc_phase1_cyc_qs;
      end

      addr_hit[43]: begin
        reg_rdata_next[31:0] = classc_phase2_cyc_qs;
      end

      addr_hit[44]: begin
        reg_rdata_next[31:0] = classc_phase3_cyc_qs;
      end

      addr_hit[45]: begin
        reg_rdata_next[31:0] = classc_esc_cnt_qs;
      end

      addr_hit[46]: begin
        reg_rdata_next[2:0] = classc_state_qs;
      end

      addr_hit[47]: begin
        reg_rdata_next[0] = classd_ctrl_en_qs;
        reg_rdata_next[1] = classd_ctrl_lock_qs;
        reg_rdata_next[2] = classd_ctrl_en_e0_qs;
        reg_rdata_next[3] = classd_ctrl_en_e1_qs;
        reg_rdata_next[4] = classd_ctrl_en_e2_qs;
        reg_rdata_next[5] = classd_ctrl_en_e3_qs;
        reg_rdata_next[7:6] = classd_ctrl_map_e0_qs;
        reg_rdata_next[9:8] = classd_ctrl_map_e1_qs;
        reg_rdata_next[11:10] = classd_ctrl_map_e2_qs;
        reg_rdata_next[13:12] = classd_ctrl_map_e3_qs;
      end

      addr_hit[48]: begin
        reg_rdata_next[0] = classd_regwen_qs;
      end

      addr_hit[49]: begin
        reg_rdata_next[0] = '0;
      end

      addr_hit[50]: begin
        reg_rdata_next[15:0] = classd_accum_cnt_qs;
      end

      addr_hit[51]: begin
        reg_rdata_next[15:0] = classd_accum_thresh_qs;
      end

      addr_hit[52]: begin
        reg_rdata_next[31:0] = classd_timeout_cyc_qs;
      end

      addr_hit[53]: begin
        reg_rdata_next[31:0] = classd_phase0_cyc_qs;
      end

      addr_hit[54]: begin
        reg_rdata_next[31:0] = classd_phase1_cyc_qs;
      end

      addr_hit[55]: begin
        reg_rdata_next[31:0] = classd_phase2_cyc_qs;
      end

      addr_hit[56]: begin
        reg_rdata_next[31:0] = classd_phase3_cyc_qs;
      end

      addr_hit[57]: begin
        reg_rdata_next[31:0] = classd_esc_cnt_qs;
      end

      addr_hit[58]: begin
        reg_rdata_next[2:0] = classd_state_qs;
      end

      default: begin
        reg_rdata_next = '1;
      end
    endcase
  end

  // Unused signal tieoff

  // wdata / byte enable are not always fully used
  // add a blanket unused statement to handle lint waivers
  logic unused_wdata;
  logic unused_be;
  assign unused_wdata = ^reg_wdata;
  assign unused_be = ^reg_be;

  // Assertions for Register Interface
  `ASSERT_PULSE(wePulse, reg_we)
  `ASSERT_PULSE(rePulse, reg_re)

  `ASSERT(reAfterRv, $rose(reg_re || reg_we) |=> tl_o.d_valid)

  `ASSERT(en2addrHit, (reg_we || reg_re) |-> $onehot0(addr_hit))

  // this is formulated as an assumption such that the FPV testbenches do disprove this
  // property by mistake
  //`ASSUME(reqParity, tl_reg_h2d.a_valid |-> tl_reg_h2d.a_user.chk_en == tlul_pkg::CheckDis)

endmodule
