---
title: "Introduction to OpenTitan"
---

[OpenTitan](https://opentitan.org) is an open source silicon Root of Trust (RoT) project.
OpenTitan will make the silicon RoT design and implementation more transparent, trustworthy, and secure for enterprises, platform providers, and chip manufacturers.
OpenTitan is administered by lowRISC CIC as a collaborative [project]({{< relref "doc/project" >}}) to produce high quality, open IP for instantiation as a full-featured product.
This repository exists to enable collaboration across partners participating in the OpenTitan project.

To get started using or contributing to the OpenTitan codebase, see the
[list of user guides]({{< relref "doc/ug" >}}).
For details on coding styles or how to use our project-specific tooling, see the
[reference manuals]({{< relref "doc/rm" >}}).
[This page]({{< relref "hw" >}})
contains technical documentation on the SoC, the Ibex processor core, and the individual IP blocks.
For questions about how the project is organized, see the [project]({{< relref "doc/project" >}}) landing spot for more information.

## Repository Structure

The underlying
[repo](http://www.github.com/lowrisc/opentitan)
is set up as a monolithic repository to contain RTL, helper scripts, technical documentation, and other software necessary to produce our hardware designs.

Unless otherwise noted, everything in the repository is covered by the Apache License, Version 2.0. See the [LICENSE](https://github.com/lowRISC/opentitan/blob/master/LICENSE) file and [repository README](https://github.com/lowRISC/opentitan/blob/master/README.md) for more information on licensing and see the user guides below for more information on development methodology.

## Documentation Sections

{{% sectionContent type="section" depth="1" %}}
