/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.calcite.util.Pair;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.SparkHashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinKey;
import org.apache.hadoop.hive.ql.exec.spark.SparkTask;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnOutputMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorColumnSourceMapping;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorMapJoinOuterFilteredOperator;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.IdentityExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerBigOnlyStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinInnerStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinLeftSemiStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinOuterStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkLongOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkMultiKeyOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkObjectHashOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkStringOperator;
import org.apache.hadoop.hive.ql.exec.vector.udf.VectorUDFAdaptor;
import org.apache.hadoop.hive.ql.io.orc.OrcInputFormat;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Dispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.PreOrderOnceWalker;
import org.apache.hadoop.hive.ql.lib.PreOrderWalker;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.VirtualColumn;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.optimizer.physical.VectorizerReason;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.AppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PartitionDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.SparkHashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.VectorAppMasterEventDesc;
import org.apache.hadoop.hive.ql.plan.VectorFileSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorFilterDesc;
import org.apache.hadoop.hive.ql.plan.VectorGroupByDesc;
import org.apache.hadoop.hive.ql.plan.VectorLimitDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinInfo;
import org.apache.hadoop.hive.ql.plan.VectorPartitionDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorReduceSinkInfo;
import org.apache.hadoop.hive.ql.plan.VectorSMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.VectorSelectDesc;
import org.apache.hadoop.hive.ql.plan.VectorSparkHashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorSparkPartitionPruningSinkDesc;
import org.apache.hadoop.hive.ql.plan.VectorTableScanDesc;
import org.apache.hadoop.hive.ql.plan.VectorizationCondition;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFAtan;
import org.apache.hadoop.hive.ql.udf.UDFBin;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFDayOfWeek;
import org.apache.hadoop.hive.ql.udf.UDFDegrees;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFFromUnixTime;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFHour;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFMinute;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFRadians;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRegExpExtract;
import org.apache.hadoop.hive.ql.udf.UDFRegExpReplace;
import org.apache.hadoop.hive.ql.udf.UDFSecond;
import org.apache.hadoop.hive.ql.udf.UDFSign;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFSubstr;
import org.apache.hadoop.hive.ql.udf.UDFTan;
import org.apache.hadoop.hive.ql.udf.UDFToBoolean;
import org.apache.hadoop.hive.ql.udf.UDFToByte;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.UDFToString;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFAbs;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCeil;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCharacterLength;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcat;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateAdd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateDiff;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFDateSub;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFElt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFloor;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInitCap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLength;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFNvl;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDivide;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMinus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNegative;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPlus;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPPositive;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOctetLength;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPosMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFPower;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRegExp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFRound;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToChar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToDecimal;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalDayTime;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToIntervalYearMonth;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFToVarchar;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFUpper;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.NullStructSerDe;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.binarysortable.BinarySortableSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.lazybinary.LazyBinarySerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hive.common.util.AnnotationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Vectorizer
implements PhysicalPlanResolver {
    protected static final transient Logger LOG = LoggerFactory.getLogger(Vectorizer.class);
    static Pattern supportedDataTypesPattern;
    private Set<Class<?>> supportedGenericUDFs = new HashSet();
    private Set<String> supportedAggregationUdfs = new HashSet<String>();
    private HiveConf hiveConf;
    private boolean useVectorizedInputFileFormat;
    private boolean useVectorDeserialize;
    private boolean useRowDeserialize;
    private boolean isReduceVectorizationEnabled;
    private boolean isSchemaEvolution;
    private VectorizationContext.HiveVectorAdaptorUsageMode hiveVectorAdaptorUsageMode;
    private BaseWork currentBaseWork;
    private Operator<? extends OperatorDesc> currentOperator;
    private long vectorizedVertexNum = -1L;

    public void testSetCurrentBaseWork(BaseWork testBaseWork) {
        this.currentBaseWork = testBaseWork;
    }

    private void setNodeIssue(String issue) {
        this.currentBaseWork.setNotVectorizedReason(VectorizerReason.createNodeIssue(issue));
    }

    private void setOperatorIssue(String issue) {
        this.currentBaseWork.setNotVectorizedReason(VectorizerReason.createOperatorIssue(this.currentOperator, issue));
    }

    private void setExpressionIssue(String expressionTitle, String issue) {
        this.currentBaseWork.setNotVectorizedReason(VectorizerReason.createExpressionIssue(this.currentOperator, expressionTitle, issue));
    }

    private void clearNotVectorizedReason() {
        this.currentBaseWork.setNotVectorizedReason(null);
    }

    public Vectorizer() {
        this.supportedGenericUDFs.add(GenericUDFOPPlus.class);
        this.supportedGenericUDFs.add(GenericUDFOPMinus.class);
        this.supportedGenericUDFs.add(GenericUDFOPMultiply.class);
        this.supportedGenericUDFs.add(GenericUDFOPDivide.class);
        this.supportedGenericUDFs.add(GenericUDFOPMod.class);
        this.supportedGenericUDFs.add(GenericUDFOPNegative.class);
        this.supportedGenericUDFs.add(GenericUDFOPPositive.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqualOrLessThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqualOrGreaterThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPGreaterThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPLessThan.class);
        this.supportedGenericUDFs.add(GenericUDFOPNot.class);
        this.supportedGenericUDFs.add(GenericUDFOPNotEqual.class);
        this.supportedGenericUDFs.add(GenericUDFOPNotNull.class);
        this.supportedGenericUDFs.add(GenericUDFOPNull.class);
        this.supportedGenericUDFs.add(GenericUDFOPOr.class);
        this.supportedGenericUDFs.add(GenericUDFOPAnd.class);
        this.supportedGenericUDFs.add(GenericUDFOPEqual.class);
        this.supportedGenericUDFs.add(GenericUDFLength.class);
        this.supportedGenericUDFs.add(GenericUDFCharacterLength.class);
        this.supportedGenericUDFs.add(GenericUDFOctetLength.class);
        this.supportedGenericUDFs.add(UDFYear.class);
        this.supportedGenericUDFs.add(UDFMonth.class);
        this.supportedGenericUDFs.add(UDFDayOfMonth.class);
        this.supportedGenericUDFs.add(UDFDayOfWeek.class);
        this.supportedGenericUDFs.add(UDFHour.class);
        this.supportedGenericUDFs.add(UDFMinute.class);
        this.supportedGenericUDFs.add(UDFSecond.class);
        this.supportedGenericUDFs.add(UDFWeekOfYear.class);
        this.supportedGenericUDFs.add(GenericUDFToUnixTimeStamp.class);
        this.supportedGenericUDFs.add(UDFFromUnixTime.class);
        this.supportedGenericUDFs.add(GenericUDFDateAdd.class);
        this.supportedGenericUDFs.add(GenericUDFDateSub.class);
        this.supportedGenericUDFs.add(GenericUDFDate.class);
        this.supportedGenericUDFs.add(GenericUDFDateDiff.class);
        this.supportedGenericUDFs.add(UDFLike.class);
        this.supportedGenericUDFs.add(GenericUDFRegExp.class);
        this.supportedGenericUDFs.add(UDFRegExpExtract.class);
        this.supportedGenericUDFs.add(UDFRegExpReplace.class);
        this.supportedGenericUDFs.add(UDFSubstr.class);
        this.supportedGenericUDFs.add(GenericUDFLTrim.class);
        this.supportedGenericUDFs.add(GenericUDFRTrim.class);
        this.supportedGenericUDFs.add(GenericUDFTrim.class);
        this.supportedGenericUDFs.add(UDFSin.class);
        this.supportedGenericUDFs.add(UDFCos.class);
        this.supportedGenericUDFs.add(UDFTan.class);
        this.supportedGenericUDFs.add(UDFAsin.class);
        this.supportedGenericUDFs.add(UDFAcos.class);
        this.supportedGenericUDFs.add(UDFAtan.class);
        this.supportedGenericUDFs.add(UDFDegrees.class);
        this.supportedGenericUDFs.add(UDFRadians.class);
        this.supportedGenericUDFs.add(GenericUDFFloor.class);
        this.supportedGenericUDFs.add(GenericUDFCeil.class);
        this.supportedGenericUDFs.add(UDFExp.class);
        this.supportedGenericUDFs.add(UDFLn.class);
        this.supportedGenericUDFs.add(UDFLog2.class);
        this.supportedGenericUDFs.add(UDFLog10.class);
        this.supportedGenericUDFs.add(UDFLog.class);
        this.supportedGenericUDFs.add(GenericUDFPower.class);
        this.supportedGenericUDFs.add(GenericUDFRound.class);
        this.supportedGenericUDFs.add(GenericUDFBRound.class);
        this.supportedGenericUDFs.add(GenericUDFPosMod.class);
        this.supportedGenericUDFs.add(UDFSqrt.class);
        this.supportedGenericUDFs.add(UDFSign.class);
        this.supportedGenericUDFs.add(UDFRand.class);
        this.supportedGenericUDFs.add(UDFBin.class);
        this.supportedGenericUDFs.add(UDFHex.class);
        this.supportedGenericUDFs.add(UDFConv.class);
        this.supportedGenericUDFs.add(GenericUDFLower.class);
        this.supportedGenericUDFs.add(GenericUDFUpper.class);
        this.supportedGenericUDFs.add(GenericUDFConcat.class);
        this.supportedGenericUDFs.add(GenericUDFAbs.class);
        this.supportedGenericUDFs.add(GenericUDFBetween.class);
        this.supportedGenericUDFs.add(GenericUDFIn.class);
        this.supportedGenericUDFs.add(GenericUDFCase.class);
        this.supportedGenericUDFs.add(GenericUDFWhen.class);
        this.supportedGenericUDFs.add(GenericUDFCoalesce.class);
        this.supportedGenericUDFs.add(GenericUDFNvl.class);
        this.supportedGenericUDFs.add(GenericUDFElt.class);
        this.supportedGenericUDFs.add(GenericUDFInitCap.class);
        this.supportedGenericUDFs.add(GenericUDFInBloomFilter.class);
        this.supportedGenericUDFs.add(UDFToLong.class);
        this.supportedGenericUDFs.add(UDFToInteger.class);
        this.supportedGenericUDFs.add(UDFToShort.class);
        this.supportedGenericUDFs.add(UDFToByte.class);
        this.supportedGenericUDFs.add(UDFToBoolean.class);
        this.supportedGenericUDFs.add(UDFToFloat.class);
        this.supportedGenericUDFs.add(UDFToDouble.class);
        this.supportedGenericUDFs.add(UDFToString.class);
        this.supportedGenericUDFs.add(GenericUDFTimestamp.class);
        this.supportedGenericUDFs.add(GenericUDFToDecimal.class);
        this.supportedGenericUDFs.add(GenericUDFToDate.class);
        this.supportedGenericUDFs.add(GenericUDFToChar.class);
        this.supportedGenericUDFs.add(GenericUDFToVarchar.class);
        this.supportedGenericUDFs.add(GenericUDFToIntervalYearMonth.class);
        this.supportedGenericUDFs.add(GenericUDFToIntervalDayTime.class);
        this.supportedGenericUDFs.add(GenericUDFIf.class);
        this.supportedAggregationUdfs.add("min");
        this.supportedAggregationUdfs.add("max");
        this.supportedAggregationUdfs.add("count");
        this.supportedAggregationUdfs.add("sum");
        this.supportedAggregationUdfs.add("avg");
        this.supportedAggregationUdfs.add("variance");
        this.supportedAggregationUdfs.add("var_pop");
        this.supportedAggregationUdfs.add("var_samp");
        this.supportedAggregationUdfs.add("std");
        this.supportedAggregationUdfs.add("stddev");
        this.supportedAggregationUdfs.add("stddev_pop");
        this.supportedAggregationUdfs.add("stddev_samp");
        this.supportedAggregationUdfs.add("bloom_filter");
    }

    @Override
    public PhysicalContext resolve(PhysicalContext physicalContext) throws SemanticException {
        this.hiveConf = physicalContext.getConf();
        boolean vectorPath = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED);
        if (!vectorPath) {
            LOG.info("Vectorization is disabled");
            return physicalContext;
        }
        this.useVectorizedInputFileFormat = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT);
        this.useVectorDeserialize = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTOR_DESERIALIZE);
        this.useRowDeserialize = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_USE_ROW_DESERIALIZE);
        this.isReduceVectorizationEnabled = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_ENABLED);
        this.isSchemaEvolution = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SCHEMA_EVOLUTION);
        this.hiveVectorAdaptorUsageMode = VectorizationContext.HiveVectorAdaptorUsageMode.getHiveConfValue(this.hiveConf);
        VectorizationDispatcher disp = new VectorizationDispatcher();
        TaskGraphWalker ogw = new TaskGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(physicalContext.getRootTasks());
        ogw.startWalking(topNodes, null);
        return physicalContext;
    }

    private void setOperatorNotSupported(Operator<? extends OperatorDesc> op) {
        OperatorDesc desc = op.getConf();
        Annotation note = AnnotationUtils.getAnnotation(desc.getClass(), Explain.class);
        if (note != null) {
            Explain explainNote = (Explain)note;
            this.setNodeIssue(explainNote.displayName() + " (" + (Object)((Object)op.getType()) + ") not supported");
        } else {
            this.setNodeIssue("Operator " + (Object)((Object)op.getType()) + " not supported");
        }
    }

    boolean validateMapWorkOperator(Operator<? extends OperatorDesc> op, MapWork mWork, boolean isTezOrSpark) {
        boolean ret;
        switch (op.getType()) {
            case MAPJOIN: {
                if (op instanceof MapJoinOperator) {
                    ret = this.validateMapJoinOperator((MapJoinOperator)op);
                    break;
                }
                if (op instanceof SMBMapJoinOperator) {
                    ret = this.validateSMBMapJoinOperator((SMBMapJoinOperator)op);
                    break;
                }
                this.setOperatorNotSupported(op);
                ret = false;
                break;
            }
            case GROUPBY: {
                ret = this.validateGroupByOperator((GroupByOperator)op, false, isTezOrSpark);
                break;
            }
            case FILTER: {
                ret = this.validateFilterOperator((FilterOperator)op);
                break;
            }
            case SELECT: {
                ret = this.validateSelectOperator((SelectOperator)op);
                break;
            }
            case REDUCESINK: {
                ret = this.validateReduceSinkOperator((ReduceSinkOperator)op);
                break;
            }
            case TABLESCAN: {
                ret = this.validateTableScanOperator((TableScanOperator)op, mWork);
                break;
            }
            case FILESINK: 
            case LIMIT: 
            case EVENT: 
            case SPARKPRUNINGSINK: {
                ret = true;
                break;
            }
            case HASHTABLESINK: {
                ret = op instanceof SparkHashTableSinkOperator && this.validateSparkHashTableSinkOperator((SparkHashTableSinkOperator)op);
                break;
            }
            default: {
                this.setOperatorNotSupported(op);
                ret = false;
            }
        }
        return ret;
    }

    boolean validateReduceWorkOperator(Operator<? extends OperatorDesc> op) {
        boolean ret;
        switch (op.getType()) {
            case MAPJOIN: {
                if (op instanceof MapJoinOperator) {
                    ret = this.validateMapJoinOperator((MapJoinOperator)op);
                    break;
                }
                if (op instanceof SMBMapJoinOperator) {
                    ret = this.validateSMBMapJoinOperator((SMBMapJoinOperator)op);
                    break;
                }
                this.setOperatorNotSupported(op);
                ret = false;
                break;
            }
            case GROUPBY: {
                if (HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_GROUPBY_ENABLED)) {
                    ret = this.validateGroupByOperator((GroupByOperator)op, true, true);
                    break;
                }
                this.setNodeIssue("Operator " + (Object)((Object)op.getType()) + " not enabled (" + HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCE_GROUPBY_ENABLED.name() + "=true IS false)");
                ret = false;
                break;
            }
            case FILTER: {
                ret = this.validateFilterOperator((FilterOperator)op);
                break;
            }
            case SELECT: {
                ret = this.validateSelectOperator((SelectOperator)op);
                break;
            }
            case REDUCESINK: {
                ret = this.validateReduceSinkOperator((ReduceSinkOperator)op);
                break;
            }
            case FILESINK: {
                ret = this.validateFileSinkOperator((FileSinkOperator)op);
                break;
            }
            case LIMIT: 
            case EVENT: 
            case SPARKPRUNINGSINK: {
                ret = true;
                break;
            }
            case HASHTABLESINK: {
                ret = op instanceof SparkHashTableSinkOperator && this.validateSparkHashTableSinkOperator((SparkHashTableSinkOperator)op);
                break;
            }
            default: {
                this.setOperatorNotSupported(op);
                ret = false;
            }
        }
        return ret;
    }

    private void addOperatorChildrenToSet(Operator<? extends OperatorDesc> op, Set<Operator<? extends OperatorDesc>> nonVectorizedOps) {
        for (Operator<OperatorDesc> childOp : op.getChildOperators()) {
            if (nonVectorizedOps.contains(childOp)) continue;
            nonVectorizedOps.add(childOp);
            this.addOperatorChildrenToSet(childOp, nonVectorizedOps);
        }
    }

    private Boolean isVectorizedGroupByThatOutputsRows(Operator<? extends OperatorDesc> op) throws SemanticException {
        if (op.getType().equals((Object)OperatorType.GROUPBY)) {
            GroupByDesc desc = (GroupByDesc)op.getConf();
            return !((VectorGroupByDesc)desc.getVectorDesc()).isVectorOutput();
        }
        return false;
    }

    private boolean validateSMBMapJoinOperator(SMBMapJoinOperator op) {
        SMBJoinDesc desc = (SMBJoinDesc)op.getConf();
        return this.validateMapJoinDesc(desc);
    }

    private boolean validateTableScanOperator(TableScanOperator op, MapWork mWork) {
        TableScanDesc desc = (TableScanDesc)op.getConf();
        if (desc.isGatherStats()) {
            this.setOperatorIssue("gather stats not supported");
            return false;
        }
        return true;
    }

    private boolean validateMapJoinOperator(MapJoinOperator op) {
        MapJoinDesc desc = (MapJoinDesc)op.getConf();
        return this.validateMapJoinDesc(desc);
    }

    private boolean validateMapJoinDesc(MapJoinDesc desc) {
        byte posBigTable = (byte)desc.getPosBigTable();
        List<ExprNodeDesc> filterExprs = desc.getFilters().get(posBigTable);
        if (!this.validateExprNodeDesc(filterExprs, "Filter", VectorExpressionDescriptor.Mode.FILTER)) {
            return false;
        }
        List<ExprNodeDesc> keyExprs = desc.getKeys().get(posBigTable);
        if (!this.validateExprNodeDesc(keyExprs, "Key")) {
            return false;
        }
        List<ExprNodeDesc> valueExprs = desc.getExprs().get(posBigTable);
        if (!this.validateExprNodeDesc(valueExprs, "Value")) {
            return false;
        }
        Byte[] order = desc.getTagOrder();
        Byte posSingleVectorMapJoinSmallTable = order[0] == posBigTable ? order[1] : order[0];
        List<ExprNodeDesc> smallTableExprs = desc.getExprs().get(posSingleVectorMapJoinSmallTable);
        if (!this.validateExprNodeDesc(smallTableExprs, "Small Table")) {
            return false;
        }
        if (desc.getResidualFilterExprs() != null && !desc.getResidualFilterExprs().isEmpty()) {
            LOG.info("Cannot vectorize outer join with complex ON clause");
            return false;
        }
        return true;
    }

    private boolean validateSparkHashTableSinkOperator(SparkHashTableSinkOperator op) {
        SparkHashTableSinkDesc desc = (SparkHashTableSinkDesc)op.getConf();
        byte tag = desc.getTag();
        List<ExprNodeDesc> filterExprs = desc.getFilters().get(tag);
        List<ExprNodeDesc> keyExprs = desc.getKeys().get(tag);
        List<ExprNodeDesc> valueExprs = desc.getExprs().get(tag);
        return this.validateExprNodeDesc(filterExprs, "Filter", VectorExpressionDescriptor.Mode.FILTER) && this.validateExprNodeDesc(keyExprs, "Key") && this.validateExprNodeDesc(valueExprs, "Value");
    }

    private boolean validateReduceSinkOperator(ReduceSinkOperator op) {
        ArrayList<ExprNodeDesc> keyDescs = ((ReduceSinkDesc)op.getConf()).getKeyCols();
        ArrayList<ExprNodeDesc> partitionDescs = ((ReduceSinkDesc)op.getConf()).getPartitionCols();
        ArrayList<ExprNodeDesc> valueDesc = ((ReduceSinkDesc)op.getConf()).getValueCols();
        return this.validateExprNodeDesc(keyDescs, "Key") && this.validateExprNodeDesc(partitionDescs, "Partition") && this.validateExprNodeDesc(valueDesc, "Value");
    }

    private boolean validateSelectOperator(SelectOperator op) {
        List<ExprNodeDesc> descList = ((SelectDesc)op.getConf()).getColList();
        for (ExprNodeDesc desc : descList) {
            boolean ret = this.validateExprNodeDesc(desc, "Select");
            if (ret) continue;
            return false;
        }
        return true;
    }

    private boolean validateFilterOperator(FilterOperator op) {
        ExprNodeDesc desc = ((FilterDesc)op.getConf()).getPredicate();
        return this.validateExprNodeDesc(desc, "Predicate", VectorExpressionDescriptor.Mode.FILTER);
    }

    private boolean validateGroupByOperator(GroupByOperator op, boolean isReduce, boolean isTezOrSpark) {
        GroupByDesc desc = (GroupByDesc)op.getConf();
        if (desc.getMode() != GroupByDesc.Mode.HASH && desc.isDistinct()) {
            this.setOperatorIssue("DISTINCT not supported");
            return false;
        }
        boolean ret = this.validateExprNodeDesc(desc.getKeys(), "Key");
        if (!ret) {
            return false;
        }
        boolean hasKeys = desc.getKeys().size() > 0;
        VectorGroupByDesc.ProcessingMode processingMode = VectorGroupByDesc.groupByDescModeToVectorProcessingMode(desc.getMode(), hasKeys);
        if (desc.isGroupingSetsPresent() && processingMode != VectorGroupByDesc.ProcessingMode.HASH && processingMode != VectorGroupByDesc.ProcessingMode.STREAMING) {
            LOG.info("Vectorized GROUPING SETS only expected for HASH and STREAMING processing modes");
            return false;
        }
        if (processingMode == VectorGroupByDesc.ProcessingMode.MERGE_PARTIAL) {
            for (ExprNodeDesc keyExpr : desc.getKeys()) {
                if (keyExpr instanceof ExprNodeColumnDesc) continue;
                this.setExpressionIssue("Key", "Non-column key expressions not supported for MERGEPARTIAL");
                return false;
            }
        }
        Pair<Boolean, Boolean> retPair = this.validateAggregationDescs(desc.getAggregators(), processingMode, hasKeys);
        if (!((Boolean)retPair.left).booleanValue()) {
            return false;
        }
        VectorGroupByDesc vectorDesc = new VectorGroupByDesc();
        desc.setVectorDesc(vectorDesc);
        vectorDesc.setVectorOutput((Boolean)retPair.right);
        vectorDesc.setProcessingMode(processingMode);
        LOG.info("Vector GROUP BY operator will use processing mode " + processingMode.name() + ", isVectorOutput " + vectorDesc.isVectorOutput());
        return true;
    }

    private boolean validateFileSinkOperator(FileSinkOperator op) {
        return true;
    }

    private boolean validateExprNodeDesc(List<ExprNodeDesc> descs, String expressionTitle) {
        return this.validateExprNodeDesc(descs, expressionTitle, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    private boolean validateExprNodeDesc(List<ExprNodeDesc> descs, String expressionTitle, VectorExpressionDescriptor.Mode mode) {
        for (ExprNodeDesc d : descs) {
            boolean ret = this.validateExprNodeDesc(d, expressionTitle, mode);
            if (ret) continue;
            return false;
        }
        return true;
    }

    private Pair<Boolean, Boolean> validateAggregationDescs(List<AggregationDesc> descs, VectorGroupByDesc.ProcessingMode processingMode, boolean hasKeys) {
        boolean outputIsPrimitive = true;
        for (AggregationDesc d : descs) {
            Pair<Boolean, Boolean> retPair = this.validateAggregationDesc(d, processingMode, hasKeys);
            if (!((Boolean)retPair.left).booleanValue()) {
                return retPair;
            }
            if (((Boolean)retPair.right).booleanValue()) continue;
            outputIsPrimitive = false;
        }
        return new Pair((Object)true, (Object)outputIsPrimitive);
    }

    private boolean validateExprNodeDescRecursive(ExprNodeDesc desc, String expressionTitle, VectorExpressionDescriptor.Mode mode) {
        ExprNodeColumnDesc c;
        if (desc instanceof ExprNodeColumnDesc && VirtualColumn.VIRTUAL_COLUMN_NAMES.contains((Object)(c = (ExprNodeColumnDesc)desc).getColumn())) {
            this.setExpressionIssue(expressionTitle, "Virtual columns not supported (" + c.getColumn() + ")");
            return false;
        }
        String typeName = desc.getTypeInfo().getTypeName();
        boolean ret = Vectorizer.validateDataType(typeName, mode);
        if (!ret) {
            this.setExpressionIssue(expressionTitle, "Data type " + typeName + " of " + desc.toString() + " not supported");
            return false;
        }
        boolean isInExpression = false;
        if (desc instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc d = (ExprNodeGenericFuncDesc)desc;
            boolean r = this.validateGenericUdf(d);
            if (!r) {
                this.setExpressionIssue(expressionTitle, "UDF " + d + " not supported");
                return false;
            }
            GenericUDF genericUDF = d.getGenericUDF();
            isInExpression = genericUDF instanceof GenericUDFIn;
        }
        if (desc.getChildren() != null) {
            if (isInExpression && desc.getChildren().get(0).getTypeInfo().getCategory() == ObjectInspector.Category.STRUCT) {
                if (!this.validateStructInExpression(desc, expressionTitle, VectorExpressionDescriptor.Mode.FILTER)) {
                    return false;
                }
            } else {
                for (ExprNodeDesc d : desc.getChildren()) {
                    if (this.validateExprNodeDescRecursive(d, expressionTitle, VectorExpressionDescriptor.Mode.FILTER)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validateStructInExpression(ExprNodeDesc desc, String expressionTitle, VectorExpressionDescriptor.Mode mode) {
        for (ExprNodeDesc d : desc.getChildren()) {
            TypeInfo typeInfo = d.getTypeInfo();
            if (typeInfo.getCategory() != ObjectInspector.Category.STRUCT) {
                return false;
            }
            StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
            ArrayList fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
            ArrayList fieldNames = structTypeInfo.getAllStructFieldNames();
            int fieldCount = fieldTypeInfos.size();
            for (int f = 0; f < fieldCount; ++f) {
                TypeInfo fieldTypeInfo = (TypeInfo)fieldTypeInfos.get(f);
                ObjectInspector.Category category = fieldTypeInfo.getCategory();
                if (category != ObjectInspector.Category.PRIMITIVE) {
                    this.setExpressionIssue(expressionTitle, "Cannot vectorize struct field " + (String)fieldNames.get(f) + " of type " + fieldTypeInfo.getTypeName());
                    return false;
                }
                PrimitiveTypeInfo fieldPrimitiveTypeInfo = (PrimitiveTypeInfo)fieldTypeInfo;
                VectorizationContext.InConstantType inConstantType = VectorizationContext.getInConstantTypeFromPrimitiveCategory(fieldPrimitiveTypeInfo.getPrimitiveCategory());
                if (inConstantType == VectorizationContext.InConstantType.INT_FAMILY || inConstantType == VectorizationContext.InConstantType.FLOAT_FAMILY || inConstantType == VectorizationContext.InConstantType.STRING_FAMILY) continue;
                this.setExpressionIssue(expressionTitle, "Cannot vectorize struct field " + (String)fieldNames.get(f) + " of type " + fieldTypeInfo.getTypeName());
                return false;
            }
        }
        return true;
    }

    private boolean validateExprNodeDesc(ExprNodeDesc desc, String expressionTitle) {
        return this.validateExprNodeDesc(desc, expressionTitle, VectorExpressionDescriptor.Mode.PROJECTION);
    }

    boolean validateExprNodeDesc(ExprNodeDesc desc, String expressionTitle, VectorExpressionDescriptor.Mode mode) {
        if (!this.validateExprNodeDescRecursive(desc, expressionTitle, mode)) {
            return false;
        }
        try {
            ValidatorVectorizationContext vc = new ValidatorVectorizationContext(this.hiveConf);
            if (vc.getVectorExpression(desc, mode) == null) {
                this.setExpressionIssue(expressionTitle, "getVectorExpression returned null");
                return false;
            }
        }
        catch (Exception e) {
            if (e instanceof HiveException) {
                this.setExpressionIssue(expressionTitle, e.getMessage());
            } else {
                String issue = "exception: " + VectorizationContext.getStackTraceAsSingleLine(e);
                this.setExpressionIssue(expressionTitle, issue);
            }
            return false;
        }
        return true;
    }

    private boolean validateGenericUdf(ExprNodeGenericFuncDesc genericUDFExpr) {
        if (VectorizationContext.isCustomUDF(genericUDFExpr)) {
            return true;
        }
        if (this.hiveVectorAdaptorUsageMode == VectorizationContext.HiveVectorAdaptorUsageMode.NONE || this.hiveVectorAdaptorUsageMode == VectorizationContext.HiveVectorAdaptorUsageMode.CHOSEN) {
            GenericUDF genericUDF = genericUDFExpr.getGenericUDF();
            if (genericUDF instanceof GenericUDFBridge) {
                Class<? extends UDF> udf = ((GenericUDFBridge)genericUDF).getUdfClass();
                return this.supportedGenericUDFs.contains(udf);
            }
            return this.supportedGenericUDFs.contains(genericUDF.getClass());
        }
        return true;
    }

    public static ObjectInspector.Category aggregationOutputCategory(VectorAggregateExpression vectorAggrExpr) {
        ObjectInspector outputObjInspector = vectorAggrExpr.getOutputObjectInspector();
        return outputObjInspector.getCategory();
    }

    private Pair<Boolean, Boolean> validateAggregationDesc(AggregationDesc aggDesc, VectorGroupByDesc.ProcessingMode processingMode, boolean hasKeys) {
        ObjectInspector.Category outputCategory;
        boolean outputIsPrimitive;
        VectorAggregateExpression vectorAggrExpr;
        String udfName = aggDesc.getGenericUDAFName().toLowerCase();
        if (!this.supportedAggregationUdfs.contains(udfName)) {
            this.setExpressionIssue("Aggregation Function", "UDF " + udfName + " not supported");
            return new Pair((Object)false, (Object)false);
        }
        if (aggDesc.getParameters() != null && !this.validateExprNodeDesc(aggDesc.getParameters(), "Aggregation Function UDF " + udfName + " parameter")) {
            return new Pair((Object)false, (Object)false);
        }
        ValidatorVectorizationContext vc = new ValidatorVectorizationContext(this.hiveConf);
        try {
            vectorAggrExpr = vc.getAggregatorExpression(aggDesc);
        }
        catch (Exception e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Vectorization of aggregation should have succeeded ", (Throwable)e);
            }
            this.setExpressionIssue("Aggregation Function", "Vectorization of aggreation should have succeeded " + e);
            return new Pair((Object)false, (Object)false);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Aggregation " + aggDesc.getExprString() + " -->  vector expression " + vectorAggrExpr.toString());
        }
        boolean bl = outputIsPrimitive = (outputCategory = Vectorizer.aggregationOutputCategory(vectorAggrExpr)) == ObjectInspector.Category.PRIMITIVE;
        if (processingMode == VectorGroupByDesc.ProcessingMode.MERGE_PARTIAL && hasKeys && !outputIsPrimitive) {
            this.setOperatorIssue("Vectorized Reduce MergePartial GROUP BY keys can only handle aggregate outputs that are primitive types");
            return new Pair((Object)false, (Object)false);
        }
        return new Pair((Object)true, (Object)outputIsPrimitive);
    }

    public static boolean validateDataType(String type, VectorExpressionDescriptor.Mode mode) {
        boolean result = supportedDataTypesPattern.matcher(type = type.toLowerCase()).matches();
        if (result && mode == VectorExpressionDescriptor.Mode.PROJECTION && type.equals("void")) {
            return false;
        }
        return result;
    }

    private VectorizationContext getVectorizationContext(String contextName, VectorTaskColumnInfo vectorTaskColumnInfo) {
        VectorizationContext vContext = new VectorizationContext(contextName, vectorTaskColumnInfo.allColumnNames, this.hiveConf);
        return vContext;
    }

    private void fixupParentChildOperators(Operator<? extends OperatorDesc> op, Operator<? extends OperatorDesc> vectorOp) {
        if (op.getParentOperators() != null) {
            vectorOp.setParentOperators(op.getParentOperators());
            for (Operator<OperatorDesc> p : op.getParentOperators()) {
                p.replaceChild(op, vectorOp);
            }
        }
        if (op.getChildOperators() != null) {
            vectorOp.setChildOperators(op.getChildOperators());
            for (Operator<OperatorDesc> c : op.getChildOperators()) {
                c.replaceParent(op, vectorOp);
            }
        }
    }

    private boolean isBigTableOnlyResults(MapJoinDesc desc) {
        int smallTableIndicesSize;
        int[] smallTableIndices;
        Byte posSingleVectorMapJoinSmallTable;
        Byte[] order = desc.getTagOrder();
        byte posBigTable = (byte)desc.getPosBigTable();
        Byte by = posSingleVectorMapJoinSmallTable = order[0] == posBigTable ? order[1] : order[0];
        if (desc.getValueIndices() != null && desc.getValueIndices().get(posSingleVectorMapJoinSmallTable) != null) {
            smallTableIndices = desc.getValueIndices().get(posSingleVectorMapJoinSmallTable);
            LOG.info("Vectorizer isBigTableOnlyResults smallTableIndices " + Arrays.toString(smallTableIndices));
            smallTableIndicesSize = smallTableIndices.length;
        } else {
            smallTableIndices = null;
            LOG.info("Vectorizer isBigTableOnlyResults smallTableIndices EMPTY");
            smallTableIndicesSize = 0;
        }
        List<Integer> smallTableRetainList = desc.getRetainList().get(posSingleVectorMapJoinSmallTable);
        LOG.info("Vectorizer isBigTableOnlyResults smallTableRetainList " + smallTableRetainList);
        int smallTableRetainSize = smallTableRetainList.size();
        if (smallTableIndicesSize > 0) {
            for (int i = 0; i < smallTableIndicesSize; ++i) {
                if (smallTableIndices[i] >= 0) continue;
                this.setOperatorIssue("Vectorizer isBigTableOnlyResults smallTableIndices[i] < 0 returning false");
                return false;
            }
        } else if (smallTableRetainSize > 0) {
            this.setOperatorIssue("Vectorizer isBigTableOnlyResults smallTableRetainSize > 0 returning false");
            return false;
        }
        LOG.info("Vectorizer isBigTableOnlyResults returning true");
        return true;
    }

    Operator<? extends OperatorDesc> specializeMapJoinOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext, MapJoinDesc desc, VectorMapJoinInfo vectorMapJoinInfo) throws HiveException {
        Operator<OperatorDesc> vectorOp = null;
        Class opClass = null;
        VectorMapJoinDesc vectorDesc = (VectorMapJoinDesc)desc.getVectorDesc();
        VectorMapJoinDesc.HashTableImplementationType hashTableImplementationType = VectorMapJoinDesc.HashTableImplementationType.NONE;
        VectorMapJoinDesc.HashTableKind hashTableKind = VectorMapJoinDesc.HashTableKind.NONE;
        VectorMapJoinDesc.HashTableKeyType hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.NONE;
        VectorMapJoinDesc.OperatorVariation operatorVariation = VectorMapJoinDesc.OperatorVariation.NONE;
        hashTableImplementationType = vectorDesc.getIsFastHashTableEnabled() ? VectorMapJoinDesc.HashTableImplementationType.FAST : VectorMapJoinDesc.HashTableImplementationType.OPTIMIZED;
        int joinType = desc.getConds()[0].getType();
        boolean isInnerBigOnly = false;
        if (joinType == 0 && this.isBigTableOnlyResults(desc)) {
            isInnerBigOnly = true;
        }
        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.MULTI_KEY;
        if (!HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_MULTIKEY_ONLY_ENABLED)) {
            byte posBigTable = (byte)desc.getPosBigTable();
            Map<Byte, List<ExprNodeDesc>> keyExprs = desc.getKeys();
            List<ExprNodeDesc> bigTableKeyExprs = keyExprs.get(posBigTable);
            if (bigTableKeyExprs.size() == 1) {
                TypeInfo typeInfo = bigTableKeyExprs.get(0).getTypeInfo();
                LOG.info("Vectorizer vectorizeOperator map join typeName " + typeInfo.getTypeName());
                switch (((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory()) {
                    case BOOLEAN: {
                        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.BOOLEAN;
                        break;
                    }
                    case BYTE: {
                        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.BYTE;
                        break;
                    }
                    case SHORT: {
                        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.SHORT;
                        break;
                    }
                    case INT: {
                        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.INT;
                        break;
                    }
                    case LONG: {
                        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.LONG;
                        break;
                    }
                    case STRING: 
                    case CHAR: 
                    case VARCHAR: 
                    case BINARY: {
                        hashTableKeyType = VectorMapJoinDesc.HashTableKeyType.STRING;
                    }
                }
            }
        }
        switch (joinType) {
            case 0: {
                if (!isInnerBigOnly) {
                    operatorVariation = VectorMapJoinDesc.OperatorVariation.INNER;
                    hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MAP;
                    break;
                }
                operatorVariation = VectorMapJoinDesc.OperatorVariation.INNER_BIG_ONLY;
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MULTISET;
                break;
            }
            case 1: 
            case 2: {
                operatorVariation = VectorMapJoinDesc.OperatorVariation.OUTER;
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_MAP;
                break;
            }
            case 5: {
                operatorVariation = VectorMapJoinDesc.OperatorVariation.LEFT_SEMI;
                hashTableKind = VectorMapJoinDesc.HashTableKind.HASH_SET;
                break;
            }
            default: {
                throw new HiveException("Unknown join type " + joinType);
            }
        }
        LOG.info("Vectorizer vectorizeOperator map join hashTableKind " + hashTableKind.name() + " hashTableKeyType " + hashTableKeyType.name());
        block13 : switch (hashTableKeyType) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                switch (operatorVariation) {
                    case INNER: {
                        opClass = VectorMapJoinInnerLongOperator.class;
                        break block13;
                    }
                    case INNER_BIG_ONLY: {
                        opClass = VectorMapJoinInnerBigOnlyLongOperator.class;
                        break block13;
                    }
                    case LEFT_SEMI: {
                        opClass = VectorMapJoinLeftSemiLongOperator.class;
                        break block13;
                    }
                    case OUTER: {
                        opClass = VectorMapJoinOuterLongOperator.class;
                        break block13;
                    }
                }
                throw new HiveException("Unknown operator variation " + (Object)((Object)operatorVariation));
            }
            case STRING: {
                switch (operatorVariation) {
                    case INNER: {
                        opClass = VectorMapJoinInnerStringOperator.class;
                        break block13;
                    }
                    case INNER_BIG_ONLY: {
                        opClass = VectorMapJoinInnerBigOnlyStringOperator.class;
                        break block13;
                    }
                    case LEFT_SEMI: {
                        opClass = VectorMapJoinLeftSemiStringOperator.class;
                        break block13;
                    }
                    case OUTER: {
                        opClass = VectorMapJoinOuterStringOperator.class;
                        break block13;
                    }
                }
                throw new HiveException("Unknown operator variation " + (Object)((Object)operatorVariation));
            }
            case MULTI_KEY: {
                switch (operatorVariation) {
                    case INNER: {
                        opClass = VectorMapJoinInnerMultiKeyOperator.class;
                        break block13;
                    }
                    case INNER_BIG_ONLY: {
                        opClass = VectorMapJoinInnerBigOnlyMultiKeyOperator.class;
                        break block13;
                    }
                    case LEFT_SEMI: {
                        opClass = VectorMapJoinLeftSemiMultiKeyOperator.class;
                        break block13;
                    }
                    case OUTER: {
                        opClass = VectorMapJoinOuterMultiKeyOperator.class;
                        break block13;
                    }
                }
                throw new HiveException("Unknown operator variation " + (Object)((Object)operatorVariation));
            }
            default: {
                throw new RuntimeException("Unexpected hash table key type " + hashTableKeyType.name());
            }
        }
        boolean minMaxEnabled = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_MINMAX_ENABLED);
        vectorDesc.setHashTableImplementationType(hashTableImplementationType);
        vectorDesc.setHashTableKind(hashTableKind);
        vectorDesc.setHashTableKeyType(hashTableKeyType);
        vectorDesc.setOperatorVariation(operatorVariation);
        vectorDesc.setMinMaxEnabled(minMaxEnabled);
        vectorDesc.setVectorMapJoinInfo(vectorMapJoinInfo);
        vectorOp = OperatorFactory.getVectorOperator(opClass, op.getCompilationOpContext(), op.getConf(), vContext, op);
        LOG.info("Vectorizer vectorizeOperator map join class " + vectorOp.getClass().getSimpleName());
        return vectorOp;
    }

    public static boolean onExpressionHasNullSafes(MapJoinDesc desc) {
        boolean[] nullSafes = desc.getNullSafes();
        if (nullSafes == null) {
            return false;
        }
        for (boolean nullSafe : nullSafes) {
            if (!nullSafe) continue;
            return true;
        }
        return false;
    }

    private boolean canSpecializeMapJoin(Operator<? extends OperatorDesc> op, MapJoinDesc desc, boolean isTezOrSpark, VectorizationContext vContext, VectorMapJoinInfo vectorMapJoinInfo) throws HiveException {
        int smallTableValueIndex;
        int i;
        String[] bigTableRetainedNames;
        int smallTableIndicesSize;
        int[] smallTableIndices;
        Preconditions.checkState((boolean)(op instanceof MapJoinOperator));
        VectorMapJoinDesc vectorDesc = new VectorMapJoinDesc();
        desc.setVectorDesc(vectorDesc);
        boolean isVectorizationMapJoinNativeEnabled = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_ENABLED);
        String engine = HiveConf.getVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
        boolean oneMapJoinCondition = desc.getConds().length == 1;
        boolean hasNullSafes = Vectorizer.onExpressionHasNullSafes(desc);
        byte posBigTable = (byte)desc.getPosBigTable();
        List<ExprNodeDesc> keyDesc = desc.getKeys().get(posBigTable);
        VectorExpression[] allBigTableKeyExpressions = vContext.getVectorExpressions(keyDesc);
        int allBigTableKeyExpressionsLength = allBigTableKeyExpressions.length;
        boolean supportsKeyTypes = true;
        HashSet<String> notSupportedKeyTypes = new HashSet<String>();
        int[] bigTableKeyColumnMap = new int[allBigTableKeyExpressionsLength];
        String[] bigTableKeyColumnNames = new String[allBigTableKeyExpressionsLength];
        TypeInfo[] bigTableKeyTypeInfos = new TypeInfo[allBigTableKeyExpressionsLength];
        ArrayList<VectorExpression> bigTableKeyExpressionsList = new ArrayList<VectorExpression>();
        for (int i2 = 0; i2 < allBigTableKeyExpressionsLength; ++i2) {
            VectorExpression ve = allBigTableKeyExpressions[i2];
            if (!IdentityExpression.isColumnOnly(ve)) {
                bigTableKeyExpressionsList.add(ve);
            }
            bigTableKeyColumnMap[i2] = ve.getOutputColumn();
            ExprNodeDesc exprNode = keyDesc.get(i2);
            bigTableKeyColumnNames[i2] = exprNode.toString();
            TypeInfo typeInfo = exprNode.getTypeInfo();
            if (!MapJoinKey.isSupportedField(typeInfo)) {
                supportsKeyTypes = false;
                ObjectInspector.Category category = typeInfo.getCategory();
                notSupportedKeyTypes.add(category != ObjectInspector.Category.PRIMITIVE ? category.toString() : ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory().toString());
            }
            bigTableKeyTypeInfos[i2] = typeInfo;
        }
        VectorExpression[] bigTableKeyExpressions = bigTableKeyExpressionsList.size() == 0 ? null : bigTableKeyExpressionsList.toArray(new VectorExpression[0]);
        List<ExprNodeDesc> bigTableExprs = desc.getExprs().get(posBigTable);
        VectorExpression[] allBigTableValueExpressions = vContext.getVectorExpressions(bigTableExprs);
        boolean isFastHashTableEnabled = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_MAPJOIN_NATIVE_FAST_HASHTABLE_ENABLED);
        boolean isHybridHashJoin = desc.isHybridHashJoin();
        int[] bigTableValueColumnMap = new int[allBigTableValueExpressions.length];
        String[] bigTableValueColumnNames = new String[allBigTableValueExpressions.length];
        TypeInfo[] bigTableValueTypeInfos = new TypeInfo[allBigTableValueExpressions.length];
        ArrayList<VectorExpression> bigTableValueExpressionsList = new ArrayList<VectorExpression>();
        for (int i3 = 0; i3 < bigTableValueColumnMap.length; ++i3) {
            VectorExpression ve = allBigTableValueExpressions[i3];
            if (!IdentityExpression.isColumnOnly(ve)) {
                bigTableValueExpressionsList.add(ve);
            }
            bigTableValueColumnMap[i3] = ve.getOutputColumn();
            ExprNodeDesc exprNode = bigTableExprs.get(i3);
            bigTableValueColumnNames[i3] = exprNode.toString();
            bigTableValueTypeInfos[i3] = exprNode.getTypeInfo();
        }
        VectorExpression[] bigTableValueExpressions = bigTableValueExpressionsList.size() == 0 ? null : bigTableValueExpressionsList.toArray(new VectorExpression[0]);
        vectorMapJoinInfo.setBigTableKeyColumnMap(bigTableKeyColumnMap);
        vectorMapJoinInfo.setBigTableKeyColumnNames(bigTableKeyColumnNames);
        vectorMapJoinInfo.setBigTableKeyTypeInfos(bigTableKeyTypeInfos);
        vectorMapJoinInfo.setBigTableKeyExpressions(bigTableKeyExpressions);
        vectorMapJoinInfo.setBigTableValueColumnMap(bigTableValueColumnMap);
        vectorMapJoinInfo.setBigTableValueColumnNames(bigTableValueColumnNames);
        vectorMapJoinInfo.setBigTableValueTypeInfos(bigTableValueTypeInfos);
        vectorMapJoinInfo.setBigTableValueExpressions(bigTableValueExpressions);
        VectorColumnOutputMapping bigTableRetainedMapping = new VectorColumnOutputMapping("Big Table Retained Mapping");
        VectorColumnOutputMapping bigTableOuterKeyMapping = new VectorColumnOutputMapping("Big Table Outer Key Mapping");
        VectorColumnSourceMapping smallTableMapping = new VectorColumnSourceMapping("Small Table Mapping");
        Byte[] order = desc.getTagOrder();
        Byte posSingleVectorMapJoinSmallTable = order[0] == posBigTable ? order[1] : order[0];
        boolean isOuterJoin = !desc.getNoOuterJoin();
        List<Integer> bigTableRetainList = desc.getRetainList().get(posBigTable);
        int bigTableRetainSize = bigTableRetainList.size();
        List<ExprNodeDesc> smallTableExprs = desc.getExprs().get(posSingleVectorMapJoinSmallTable);
        if (desc.getValueIndices() != null && desc.getValueIndices().get(posSingleVectorMapJoinSmallTable) != null) {
            smallTableIndices = desc.getValueIndices().get(posSingleVectorMapJoinSmallTable);
            smallTableIndicesSize = smallTableIndices.length;
        } else {
            smallTableIndices = null;
            smallTableIndicesSize = 0;
        }
        List<Integer> smallTableRetainList = desc.getRetainList().get(posSingleVectorMapJoinSmallTable);
        int smallTableRetainSize = smallTableRetainList.size();
        int smallTableResultSize = 0;
        if (smallTableIndicesSize > 0) {
            smallTableResultSize = smallTableIndicesSize;
        } else if (smallTableRetainSize > 0) {
            smallTableResultSize = smallTableRetainSize;
        }
        VectorColumnSourceMapping projectionMapping = new VectorColumnSourceMapping("Projection Mapping");
        int nextOutputColumn = order[0] == posBigTable ? 0 : smallTableResultSize;
        for (int i4 = 0; i4 < bigTableRetainSize; ++i4) {
            int retainColumn = bigTableRetainList.get(i4);
            int batchColumnIndex = bigTableValueColumnMap[retainColumn];
            TypeInfo typeInfo = bigTableValueTypeInfos[i4];
            projectionMapping.add(nextOutputColumn, batchColumnIndex, typeInfo);
            if (!bigTableRetainedMapping.containsOutputColumn(batchColumnIndex)) {
                bigTableRetainedMapping.add(batchColumnIndex, batchColumnIndex, typeInfo);
            }
            ++nextOutputColumn;
        }
        boolean smallTableExprVectorizes = true;
        int firstSmallTableOutputColumn = order[0] == posBigTable ? bigTableRetainSize : 0;
        int smallTableOutputCount = 0;
        nextOutputColumn = firstSmallTableOutputColumn;
        if (smallTableIndicesSize > 0) {
            smallTableOutputCount = smallTableIndicesSize;
            bigTableRetainedNames = new String[smallTableOutputCount];
            for (i = 0; i < smallTableIndicesSize; ++i) {
                int scratchColumn;
                TypeInfo typeInfo;
                if (smallTableIndices[i] >= 0) {
                    int keyIndex = smallTableIndices[i];
                    int batchKeyColumn = bigTableKeyColumnMap[keyIndex];
                    bigTableRetainedNames[i] = bigTableKeyColumnNames[keyIndex];
                    typeInfo = bigTableKeyTypeInfos[keyIndex];
                    if (!isOuterJoin) {
                        projectionMapping.add(nextOutputColumn, batchKeyColumn, typeInfo);
                        if (!bigTableRetainedMapping.containsOutputColumn(batchKeyColumn)) {
                            bigTableRetainedMapping.add(batchKeyColumn, batchKeyColumn, typeInfo);
                        }
                    } else {
                        scratchColumn = vContext.allocateScratchColumn(typeInfo);
                        projectionMapping.add(nextOutputColumn, scratchColumn, typeInfo);
                        bigTableRetainedMapping.add(batchKeyColumn, scratchColumn, typeInfo);
                        bigTableOuterKeyMapping.add(batchKeyColumn, scratchColumn, typeInfo);
                    }
                } else {
                    smallTableValueIndex = -smallTableIndices[i] - 1;
                    ExprNodeDesc smallTableExprNode = smallTableExprs.get(i);
                    if (!this.validateExprNodeDesc(smallTableExprNode, "Small Table")) {
                        this.clearNotVectorizedReason();
                        smallTableExprVectorizes = false;
                    }
                    bigTableRetainedNames[i] = smallTableExprNode.toString();
                    typeInfo = smallTableExprNode.getTypeInfo();
                    scratchColumn = vContext.allocateScratchColumn(typeInfo);
                    projectionMapping.add(nextOutputColumn, scratchColumn, typeInfo);
                    smallTableMapping.add(smallTableValueIndex, scratchColumn, typeInfo);
                }
                ++nextOutputColumn;
            }
        } else if (smallTableRetainSize > 0) {
            smallTableOutputCount = smallTableRetainSize;
            bigTableRetainedNames = new String[smallTableOutputCount];
            for (i = 0; i < smallTableRetainSize; ++i) {
                smallTableValueIndex = smallTableRetainList.get(i);
                ExprNodeDesc smallTableExprNode = smallTableExprs.get(i);
                if (!this.validateExprNodeDesc(smallTableExprNode, "Small Table")) {
                    this.clearNotVectorizedReason();
                    smallTableExprVectorizes = false;
                }
                bigTableRetainedNames[i] = smallTableExprNode.toString();
                TypeInfo typeInfo = smallTableExprNode.getTypeInfo();
                int scratchColumn = vContext.allocateScratchColumn(typeInfo);
                projectionMapping.add(nextOutputColumn, scratchColumn, typeInfo);
                smallTableMapping.add(smallTableValueIndex, scratchColumn, typeInfo);
                ++nextOutputColumn;
            }
        } else {
            bigTableRetainedNames = new String[]{};
        }
        boolean useOptimizedTable = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEMAPJOINUSEOPTIMIZEDTABLE);
        vectorDesc.setUseOptimizedTable(useOptimizedTable);
        vectorDesc.setIsVectorizationMapJoinNativeEnabled(isVectorizationMapJoinNativeEnabled);
        vectorDesc.setEngine(engine);
        vectorDesc.setOneMapJoinCondition(oneMapJoinCondition);
        vectorDesc.setHasNullSafes(hasNullSafes);
        vectorDesc.setSmallTableExprVectorizes(smallTableExprVectorizes);
        vectorDesc.setIsFastHashTableEnabled(isFastHashTableEnabled);
        vectorDesc.setIsHybridHashJoin(isHybridHashJoin);
        vectorDesc.setSupportsKeyTypes(supportsKeyTypes);
        if (!supportsKeyTypes) {
            vectorDesc.setNotSupportedKeyTypes(new ArrayList<String>(notSupportedKeyTypes));
        }
        boolean result = true;
        if (!(useOptimizedTable && isVectorizationMapJoinNativeEnabled && isTezOrSpark && oneMapJoinCondition && !hasNullSafes && smallTableExprVectorizes)) {
            result = false;
        }
        if (!isFastHashTableEnabled) {
            if (!supportsKeyTypes) {
                result = false;
            }
        } else if (isHybridHashJoin) {
            result = false;
        }
        bigTableRetainedMapping.finalize();
        bigTableOuterKeyMapping.finalize();
        smallTableMapping.finalize();
        vectorMapJoinInfo.setBigTableRetainedMapping(bigTableRetainedMapping);
        vectorMapJoinInfo.setBigTableOuterKeyMapping(bigTableOuterKeyMapping);
        vectorMapJoinInfo.setSmallTableMapping(smallTableMapping);
        projectionMapping.finalize();
        assert (projectionMapping.isSourceSequenceGood());
        vectorMapJoinInfo.setProjectionMapping(projectionMapping);
        return result;
    }

    private Operator<? extends OperatorDesc> specializeReduceSinkOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext, ReduceSinkDesc desc, VectorReduceSinkInfo vectorReduceSinkInfo) throws HiveException {
        Class opClass;
        VectorReduceSinkDesc.ReduceSinkKeyType reduceSinkKeyType;
        block16: {
            block15: {
                ColumnVector.Type[] reduceSinkKeyColumnVectorTypes = vectorReduceSinkInfo.getReduceSinkKeyColumnVectorTypes();
                reduceSinkKeyType = VectorReduceSinkDesc.ReduceSinkKeyType.MULTI_KEY;
                if (reduceSinkKeyColumnVectorTypes.length == 1) {
                    LOG.info("Vectorizer vectorizeOperator groupby typeName " + vectorReduceSinkInfo.getReduceSinkKeyTypeInfos()[0]);
                    ColumnVector.Type columnVectorType = reduceSinkKeyColumnVectorTypes[0];
                    block1 : switch (columnVectorType) {
                        case LONG: {
                            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)vectorReduceSinkInfo.getReduceSinkKeyTypeInfos()[0]).getPrimitiveCategory();
                            switch (primitiveCategory) {
                                case BOOLEAN: 
                                case BYTE: 
                                case SHORT: 
                                case INT: 
                                case LONG: {
                                    reduceSinkKeyType = VectorReduceSinkDesc.ReduceSinkKeyType.LONG;
                                    break block1;
                                }
                            }
                            break;
                        }
                        case BYTES: {
                            reduceSinkKeyType = VectorReduceSinkDesc.ReduceSinkKeyType.STRING;
                        }
                    }
                }
                opClass = null;
                if (!vectorReduceSinkInfo.getUseUniformHash()) break block15;
                switch (reduceSinkKeyType) {
                    case LONG: {
                        opClass = VectorReduceSinkLongOperator.class;
                        break block16;
                    }
                    case STRING: {
                        opClass = VectorReduceSinkStringOperator.class;
                        break block16;
                    }
                    case MULTI_KEY: {
                        opClass = VectorReduceSinkMultiKeyOperator.class;
                        break block16;
                    }
                    default: {
                        throw new HiveException("Unknown reduce sink key type " + (Object)((Object)reduceSinkKeyType));
                    }
                }
            }
            opClass = VectorReduceSinkObjectHashOperator.class;
        }
        VectorReduceSinkDesc vectorDesc = (VectorReduceSinkDesc)desc.getVectorDesc();
        vectorDesc.setReduceSinkKeyType(reduceSinkKeyType);
        vectorDesc.setVectorReduceSinkInfo(vectorReduceSinkInfo);
        LOG.info("Vectorizer vectorizeOperator reduce sink class " + opClass.getSimpleName());
        Operator<OperatorDesc> vectorOp = null;
        try {
            vectorOp = OperatorFactory.getVectorOperator(opClass, op.getCompilationOpContext(), op.getConf(), vContext, op);
        }
        catch (Exception e) {
            LOG.info("Vectorizer vectorizeOperator reduce sink class exception " + opClass.getSimpleName() + " exception " + e);
            throw new HiveException(e);
        }
        return vectorOp;
    }

    private boolean canSpecializeReduceSink(ReduceSinkDesc desc, boolean isTezOrSpark, VectorizationContext vContext, VectorReduceSinkInfo vectorReduceSinkInfo) throws HiveException {
        VectorReduceSinkDesc vectorDesc = new VectorReduceSinkDesc();
        desc.setVectorDesc(vectorDesc);
        boolean isUnexpectedCondition = false;
        boolean isVectorizationReduceSinkNativeEnabled = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_REDUCESINK_NEW_ENABLED);
        String engine = HiveConf.getVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE);
        boolean hasTopN = desc.getTopN() >= 0;
        boolean hasDistinctColumns = desc.getDistinctColumnIndices().size() > 0;
        TableDesc keyTableDesc = desc.getKeySerializeInfo();
        Class<? extends Deserializer> keySerializerClass = keyTableDesc.getDeserializerClass();
        boolean isKeyBinarySortable = keySerializerClass == BinarySortableSerDe.class;
        TableDesc valueTableDesc = desc.getValueSerializeInfo();
        Class<? extends Deserializer> valueDeserializerClass = valueTableDesc.getDeserializerClass();
        boolean isValueLazyBinary = valueDeserializerClass == LazyBinarySerDe.class;
        ArrayList<ExprNodeDesc> keysDescs = desc.getKeyCols();
        VectorExpression[] allKeyExpressions = vContext.getVectorExpressions(keysDescs);
        int[] reduceSinkKeyColumnMap = new int[allKeyExpressions.length];
        TypeInfo[] reduceSinkKeyTypeInfos = new TypeInfo[allKeyExpressions.length];
        ColumnVector.Type[] reduceSinkKeyColumnVectorTypes = new ColumnVector.Type[allKeyExpressions.length];
        ArrayList<VectorExpression> groupByKeyExpressionsList = new ArrayList<VectorExpression>();
        for (int i = 0; i < reduceSinkKeyColumnMap.length; ++i) {
            VectorExpression ve = allKeyExpressions[i];
            reduceSinkKeyColumnMap[i] = ve.getOutputColumn();
            reduceSinkKeyTypeInfos[i] = ((ExprNodeDesc)keysDescs.get(i)).getTypeInfo();
            reduceSinkKeyColumnVectorTypes[i] = VectorizationContext.getColumnVectorTypeFromTypeInfo(reduceSinkKeyTypeInfos[i]);
            if (IdentityExpression.isColumnOnly(ve)) continue;
            groupByKeyExpressionsList.add(ve);
        }
        VectorExpression[] reduceSinkKeyExpressions = groupByKeyExpressionsList.size() == 0 ? null : groupByKeyExpressionsList.toArray(new VectorExpression[0]);
        ArrayList<ExprNodeDesc> valueDescs = desc.getValueCols();
        VectorExpression[] allValueExpressions = vContext.getVectorExpressions(valueDescs);
        int[] reduceSinkValueColumnMap = new int[valueDescs.size()];
        TypeInfo[] reduceSinkValueTypeInfos = new TypeInfo[valueDescs.size()];
        ColumnVector.Type[] reduceSinkValueColumnVectorTypes = new ColumnVector.Type[valueDescs.size()];
        ArrayList<VectorExpression> reduceSinkValueExpressionsList = new ArrayList<VectorExpression>();
        for (int i = 0; i < valueDescs.size(); ++i) {
            VectorExpression ve = allValueExpressions[i];
            reduceSinkValueColumnMap[i] = ve.getOutputColumn();
            reduceSinkValueTypeInfos[i] = valueDescs.get(i).getTypeInfo();
            reduceSinkValueColumnVectorTypes[i] = VectorizationContext.getColumnVectorTypeFromTypeInfo(reduceSinkValueTypeInfos[i]);
            if (IdentityExpression.isColumnOnly(ve)) continue;
            reduceSinkValueExpressionsList.add(ve);
        }
        VectorExpression[] reduceSinkValueExpressions = reduceSinkValueExpressionsList.size() == 0 ? null : reduceSinkValueExpressionsList.toArray(new VectorExpression[0]);
        vectorReduceSinkInfo.setReduceSinkKeyColumnMap(reduceSinkKeyColumnMap);
        vectorReduceSinkInfo.setReduceSinkKeyTypeInfos(reduceSinkKeyTypeInfos);
        vectorReduceSinkInfo.setReduceSinkKeyColumnVectorTypes(reduceSinkKeyColumnVectorTypes);
        vectorReduceSinkInfo.setReduceSinkKeyExpressions(reduceSinkKeyExpressions);
        vectorReduceSinkInfo.setReduceSinkValueColumnMap(reduceSinkValueColumnMap);
        vectorReduceSinkInfo.setReduceSinkValueTypeInfos(reduceSinkValueTypeInfos);
        vectorReduceSinkInfo.setReduceSinkValueColumnVectorTypes(reduceSinkValueColumnVectorTypes);
        vectorReduceSinkInfo.setReduceSinkValueExpressions(reduceSinkValueExpressions);
        boolean useUniformHash = desc.getReducerTraits().contains((Object)ReduceSinkDesc.ReducerTraits.UNIFORM);
        vectorReduceSinkInfo.setUseUniformHash(useUniformHash);
        boolean hasEmptyBuckets = false;
        boolean hasNoPartitions = false;
        if (useUniformHash) {
            boolean bl = hasEmptyBuckets = desc.getBucketCols() != null && !desc.getBucketCols().isEmpty() || desc.getPartitionCols().size() == 0;
            if (hasEmptyBuckets) {
                LOG.info("Unexpected condition: UNIFORM hash and empty buckets");
                isUnexpectedCondition = true;
            }
            boolean bl2 = hasNoPartitions = desc.getPartitionCols() == null;
            if (hasNoPartitions) {
                LOG.info("Unexpected condition: UNIFORM hash and no partitions");
                isUnexpectedCondition = true;
            }
        } else {
            int[] reduceSinkBucketColumnMap = null;
            TypeInfo[] reduceSinkBucketTypeInfos = null;
            ColumnVector.Type[] reduceSinkBucketColumnVectorTypes = null;
            VectorExpression[] reduceSinkBucketExpressions = null;
            List<ExprNodeDesc> bucketDescs = desc.getBucketCols();
            if (bucketDescs != null) {
                VectorExpression[] allBucketExpressions = vContext.getVectorExpressions(bucketDescs);
                reduceSinkBucketColumnMap = new int[bucketDescs.size()];
                reduceSinkBucketTypeInfos = new TypeInfo[bucketDescs.size()];
                reduceSinkBucketColumnVectorTypes = new ColumnVector.Type[bucketDescs.size()];
                ArrayList<VectorExpression> reduceSinkBucketExpressionsList = new ArrayList<VectorExpression>();
                for (int i = 0; i < bucketDescs.size(); ++i) {
                    VectorExpression ve = allBucketExpressions[i];
                    reduceSinkBucketColumnMap[i] = ve.getOutputColumn();
                    reduceSinkBucketTypeInfos[i] = bucketDescs.get(i).getTypeInfo();
                    reduceSinkBucketColumnVectorTypes[i] = VectorizationContext.getColumnVectorTypeFromTypeInfo(reduceSinkBucketTypeInfos[i]);
                    if (IdentityExpression.isColumnOnly(ve)) continue;
                    reduceSinkBucketExpressionsList.add(ve);
                }
                reduceSinkBucketExpressions = reduceSinkBucketExpressionsList.size() == 0 ? null : reduceSinkBucketExpressionsList.toArray(new VectorExpression[0]);
            }
            int[] reduceSinkPartitionColumnMap = null;
            TypeInfo[] reduceSinkPartitionTypeInfos = null;
            ColumnVector.Type[] reduceSinkPartitionColumnVectorTypes = null;
            VectorExpression[] reduceSinkPartitionExpressions = null;
            ArrayList<ExprNodeDesc> partitionDescs = desc.getPartitionCols();
            if (partitionDescs != null) {
                VectorExpression[] allPartitionExpressions = vContext.getVectorExpressions(partitionDescs);
                reduceSinkPartitionColumnMap = new int[partitionDescs.size()];
                reduceSinkPartitionTypeInfos = new TypeInfo[partitionDescs.size()];
                reduceSinkPartitionColumnVectorTypes = new ColumnVector.Type[partitionDescs.size()];
                ArrayList<VectorExpression> reduceSinkPartitionExpressionsList = new ArrayList<VectorExpression>();
                for (int i = 0; i < partitionDescs.size(); ++i) {
                    VectorExpression ve = allPartitionExpressions[i];
                    reduceSinkPartitionColumnMap[i] = ve.getOutputColumn();
                    reduceSinkPartitionTypeInfos[i] = ((ExprNodeDesc)partitionDescs.get(i)).getTypeInfo();
                    reduceSinkPartitionColumnVectorTypes[i] = VectorizationContext.getColumnVectorTypeFromTypeInfo(reduceSinkPartitionTypeInfos[i]);
                    if (IdentityExpression.isColumnOnly(ve)) continue;
                    reduceSinkPartitionExpressionsList.add(ve);
                }
                reduceSinkPartitionExpressions = reduceSinkPartitionExpressionsList.size() == 0 ? null : reduceSinkPartitionExpressionsList.toArray(new VectorExpression[0]);
            }
            vectorReduceSinkInfo.setReduceSinkBucketColumnMap(reduceSinkBucketColumnMap);
            vectorReduceSinkInfo.setReduceSinkBucketTypeInfos(reduceSinkBucketTypeInfos);
            vectorReduceSinkInfo.setReduceSinkBucketColumnVectorTypes(reduceSinkBucketColumnVectorTypes);
            vectorReduceSinkInfo.setReduceSinkBucketExpressions(reduceSinkBucketExpressions);
            vectorReduceSinkInfo.setReduceSinkPartitionColumnMap(reduceSinkPartitionColumnMap);
            vectorReduceSinkInfo.setReduceSinkPartitionTypeInfos(reduceSinkPartitionTypeInfos);
            vectorReduceSinkInfo.setReduceSinkPartitionColumnVectorTypes(reduceSinkPartitionColumnVectorTypes);
            vectorReduceSinkInfo.setReduceSinkPartitionExpressions(reduceSinkPartitionExpressions);
        }
        vectorDesc.setIsVectorizationReduceSinkNativeEnabled(isVectorizationReduceSinkNativeEnabled);
        vectorDesc.setEngine(engine);
        vectorDesc.setHasTopN(hasTopN);
        vectorDesc.setHasDistinctColumns(hasDistinctColumns);
        vectorDesc.setIsKeyBinarySortable(isKeyBinarySortable);
        vectorDesc.setIsValueLazyBinary(isValueLazyBinary);
        vectorDesc.setIsUnexpectedCondition(isUnexpectedCondition);
        return isVectorizationReduceSinkNativeEnabled && isTezOrSpark && (!useUniformHash || !hasEmptyBuckets && !hasNoPartitions) && !hasTopN && !hasDistinctColumns && isKeyBinarySortable && isValueLazyBinary && !isUnexpectedCondition;
    }

    private boolean usesVectorUDFAdaptor(VectorExpression vecExpr) {
        if (vecExpr == null) {
            return false;
        }
        if (vecExpr instanceof VectorUDFAdaptor) {
            return true;
        }
        return this.usesVectorUDFAdaptor(vecExpr.getChildExpressions());
    }

    private boolean usesVectorUDFAdaptor(VectorExpression[] vecExprs) {
        if (vecExprs == null) {
            return false;
        }
        for (VectorExpression vecExpr : vecExprs) {
            if (!this.usesVectorUDFAdaptor(vecExpr)) continue;
            return true;
        }
        return false;
    }

    public static Operator<? extends OperatorDesc> vectorizeTableScanOperator(Operator<? extends OperatorDesc> tableScanOp, VectorizationContext vContext) throws HiveException {
        TableScanDesc tableScanDesc = (TableScanDesc)tableScanOp.getConf();
        VectorTableScanDesc vectorTableScanDesc = new VectorTableScanDesc();
        tableScanDesc.setVectorDesc(vectorTableScanDesc);
        vectorTableScanDesc.setProjectedOutputColumns(ArrayUtils.toPrimitive((Integer[])vContext.getProjectedColumns().toArray(new Integer[0])));
        return tableScanOp;
    }

    public static Operator<? extends OperatorDesc> vectorizeFilterOperator(Operator<? extends OperatorDesc> filterOp, VectorizationContext vContext) throws HiveException {
        FilterDesc filterDesc = (FilterDesc)filterOp.getConf();
        VectorFilterDesc vectorFilterDesc = new VectorFilterDesc();
        filterDesc.setVectorDesc(vectorFilterDesc);
        ExprNodeDesc predicateExpr = filterDesc.getPredicate();
        VectorExpression vectorPredicateExpr = vContext.getVectorExpression(predicateExpr, VectorExpressionDescriptor.Mode.FILTER);
        vectorFilterDesc.setPredicateExpression(vectorPredicateExpr);
        return OperatorFactory.getVectorOperator(filterOp.getCompilationOpContext(), filterDesc, vContext, filterOp);
    }

    public static Operator<? extends OperatorDesc> vectorizeGroupByOperator(Operator<? extends OperatorDesc> groupByOp, VectorizationContext vContext) throws HiveException {
        GroupByDesc groupByDesc = (GroupByDesc)groupByOp.getConf();
        ArrayList<ExprNodeDesc> keysDesc = groupByDesc.getKeys();
        VectorExpression[] vecKeyExpressions = vContext.getVectorExpressions(keysDesc);
        ArrayList<AggregationDesc> aggrDesc = groupByDesc.getAggregators();
        int size = aggrDesc.size();
        VectorAggregateExpression[] vecAggregators = new VectorAggregateExpression[size];
        int[] projectedOutputColumns = new int[size];
        for (int i = 0; i < size; ++i) {
            AggregationDesc aggDesc = aggrDesc.get(i);
            vecAggregators[i] = vContext.getAggregatorExpression(aggDesc);
            projectedOutputColumns[i] = i;
        }
        VectorGroupByDesc vectorGroupByDesc = (VectorGroupByDesc)groupByDesc.getVectorDesc();
        vectorGroupByDesc.setKeyExpressions(vecKeyExpressions);
        vectorGroupByDesc.setAggregators(vecAggregators);
        vectorGroupByDesc.setProjectedOutputColumns(projectedOutputColumns);
        return OperatorFactory.getVectorOperator(groupByOp.getCompilationOpContext(), groupByDesc, vContext, groupByOp);
    }

    public static Operator<? extends OperatorDesc> vectorizeSelectOperator(Operator<? extends OperatorDesc> selectOp, VectorizationContext vContext) throws HiveException {
        SelectDesc selectDesc = (SelectDesc)selectOp.getConf();
        VectorSelectDesc vectorSelectDesc = new VectorSelectDesc();
        selectDesc.setVectorDesc(vectorSelectDesc);
        List<ExprNodeDesc> colList = selectDesc.getColList();
        int index = 0;
        int size = colList.size();
        VectorExpression[] vectorSelectExprs = new VectorExpression[size];
        int[] projectedOutputColumns = new int[size];
        for (int i = 0; i < size; ++i) {
            ExprNodeDesc expr = colList.get(i);
            VectorExpression ve = vContext.getVectorExpression(expr);
            projectedOutputColumns[i] = ve.getOutputColumn();
            if (ve instanceof IdentityExpression) continue;
            vectorSelectExprs[index++] = ve;
        }
        if (index < size) {
            vectorSelectExprs = Arrays.copyOf(vectorSelectExprs, index);
        }
        vectorSelectDesc.setSelectExpressions(vectorSelectExprs);
        vectorSelectDesc.setProjectedOutputColumns(projectedOutputColumns);
        return OperatorFactory.getVectorOperator(selectOp.getCompilationOpContext(), selectDesc, vContext, selectOp);
    }

    public Operator<? extends OperatorDesc> vectorizeOperator(Operator<? extends OperatorDesc> op, VectorizationContext vContext, boolean isTezOrSpark, VectorTaskColumnInfo vectorTaskColumnInfo) throws HiveException {
        boolean isNative;
        Operator<? extends OperatorDesc> vectorOp = null;
        switch (op.getType()) {
            case TABLESCAN: {
                vectorOp = Vectorizer.vectorizeTableScanOperator(op, vContext);
                isNative = true;
                break;
            }
            case MAPJOIN: {
                if (op instanceof MapJoinOperator) {
                    VectorMapJoinInfo vectorMapJoinInfo = new VectorMapJoinInfo();
                    MapJoinDesc desc = (MapJoinDesc)op.getConf();
                    boolean specialize = this.canSpecializeMapJoin(op, desc, isTezOrSpark, vContext, vectorMapJoinInfo);
                    if (!specialize) {
                        Class opClass = null;
                        List<ExprNodeDesc> bigTableFilters = desc.getFilters().get((byte)desc.getPosBigTable());
                        boolean isOuterAndFiltered = !desc.isNoOuterJoin() && bigTableFilters.size() > 0;
                        opClass = !isOuterAndFiltered ? VectorMapJoinOperator.class : VectorMapJoinOuterFilteredOperator.class;
                        vectorOp = OperatorFactory.getVectorOperator(opClass, op.getCompilationOpContext(), op.getConf(), vContext, op);
                        isNative = false;
                        break;
                    }
                    vectorOp = this.specializeMapJoinOperator(op, vContext, desc, vectorMapJoinInfo);
                    isNative = true;
                    if (vectorTaskColumnInfo == null) break;
                    if (this.usesVectorUDFAdaptor(vectorMapJoinInfo.getBigTableKeyExpressions())) {
                        vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                    }
                    if (!this.usesVectorUDFAdaptor(vectorMapJoinInfo.getBigTableValueExpressions())) break;
                    vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                    break;
                }
                Preconditions.checkState((boolean)(op instanceof SMBMapJoinOperator));
                SMBJoinDesc smbJoinSinkDesc = (SMBJoinDesc)op.getConf();
                VectorSMBJoinDesc vectorSMBJoinDesc = new VectorSMBJoinDesc();
                smbJoinSinkDesc.setVectorDesc(vectorSMBJoinDesc);
                vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), smbJoinSinkDesc, vContext, op);
                isNative = false;
                break;
            }
            case REDUCESINK: {
                VectorReduceSinkInfo vectorReduceSinkInfo = new VectorReduceSinkInfo();
                ReduceSinkDesc desc = (ReduceSinkDesc)op.getConf();
                boolean specialize = this.canSpecializeReduceSink(desc, isTezOrSpark, vContext, vectorReduceSinkInfo);
                if (!specialize) {
                    vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), op.getConf(), vContext, op);
                    isNative = false;
                    break;
                }
                vectorOp = this.specializeReduceSinkOperator(op, vContext, desc, vectorReduceSinkInfo);
                isNative = true;
                if (vectorTaskColumnInfo == null) break;
                if (this.usesVectorUDFAdaptor(vectorReduceSinkInfo.getReduceSinkKeyExpressions())) {
                    vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                }
                if (!this.usesVectorUDFAdaptor(vectorReduceSinkInfo.getReduceSinkValueExpressions())) break;
                vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                break;
            }
            case FILTER: {
                VectorFilterDesc vectorFilterDesc;
                VectorExpression vectorPredicateExpr;
                vectorOp = Vectorizer.vectorizeFilterOperator(op, vContext);
                isNative = true;
                if (vectorTaskColumnInfo == null || !this.usesVectorUDFAdaptor(vectorPredicateExpr = (vectorFilterDesc = (VectorFilterDesc)((AbstractOperatorDesc)vectorOp.getConf()).getVectorDesc()).getPredicateExpression())) break;
                vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                break;
            }
            case SELECT: {
                VectorSelectDesc vectorSelectDesc;
                VectorExpression[] vectorSelectExprs;
                vectorOp = Vectorizer.vectorizeSelectOperator(op, vContext);
                isNative = true;
                if (vectorTaskColumnInfo == null || !this.usesVectorUDFAdaptor(vectorSelectExprs = (vectorSelectDesc = (VectorSelectDesc)((AbstractOperatorDesc)vectorOp.getConf()).getVectorDesc()).getSelectExpressions())) break;
                vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                break;
            }
            case GROUPBY: {
                VectorAggregateExpression[] vecAggregators;
                VectorExpression[] vecKeyExpressions;
                vectorOp = Vectorizer.vectorizeGroupByOperator(op, vContext);
                isNative = false;
                if (vectorTaskColumnInfo == null) break;
                VectorGroupByDesc vectorGroupByDesc = (VectorGroupByDesc)((AbstractOperatorDesc)vectorOp.getConf()).getVectorDesc();
                if (!vectorGroupByDesc.isVectorOutput()) {
                    vectorTaskColumnInfo.setGroupByVectorOutput(false);
                }
                if (this.usesVectorUDFAdaptor(vecKeyExpressions = vectorGroupByDesc.getKeyExpressions())) {
                    vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                }
                for (VectorAggregateExpression vecAggr : vecAggregators = vectorGroupByDesc.getAggregators()) {
                    if (!this.usesVectorUDFAdaptor(vecAggr.inputExpression())) continue;
                    vectorTaskColumnInfo.setUsesVectorUDFAdaptor(true);
                }
                break;
            }
            case FILESINK: {
                FileSinkDesc fileSinkDesc = (FileSinkDesc)op.getConf();
                VectorFileSinkDesc vectorFileSinkDesc = new VectorFileSinkDesc();
                fileSinkDesc.setVectorDesc(vectorFileSinkDesc);
                vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), fileSinkDesc, vContext, op);
                isNative = false;
                break;
            }
            case LIMIT: {
                LimitDesc limitDesc = (LimitDesc)op.getConf();
                VectorLimitDesc vectorLimitDesc = new VectorLimitDesc();
                limitDesc.setVectorDesc(vectorLimitDesc);
                vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), limitDesc, vContext, op);
                isNative = true;
                break;
            }
            case EVENT: {
                AppMasterEventDesc eventDesc = (AppMasterEventDesc)op.getConf();
                VectorAppMasterEventDesc vectorEventDesc = new VectorAppMasterEventDesc();
                eventDesc.setVectorDesc(vectorEventDesc);
                vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), eventDesc, vContext, op);
                isNative = true;
                break;
            }
            case HASHTABLESINK: {
                SparkHashTableSinkDesc sparkHashTableSinkDesc = (SparkHashTableSinkDesc)op.getConf();
                VectorSparkHashTableSinkDesc vectorSparkHashTableSinkDesc = new VectorSparkHashTableSinkDesc();
                sparkHashTableSinkDesc.setVectorDesc(vectorSparkHashTableSinkDesc);
                vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), sparkHashTableSinkDesc, vContext, op);
                isNative = true;
                break;
            }
            case SPARKPRUNINGSINK: {
                SparkPartitionPruningSinkDesc sparkPartitionPruningSinkDesc = (SparkPartitionPruningSinkDesc)op.getConf();
                VectorSparkPartitionPruningSinkDesc vectorSparkPartitionPruningSinkDesc = new VectorSparkPartitionPruningSinkDesc();
                sparkPartitionPruningSinkDesc.setVectorDesc(vectorSparkPartitionPruningSinkDesc);
                vectorOp = OperatorFactory.getVectorOperator(op.getCompilationOpContext(), sparkPartitionPruningSinkDesc, vContext, op);
                isNative = true;
                break;
            }
            default: {
                isNative = false;
                vectorOp = op;
            }
        }
        Preconditions.checkState((vectorOp != null ? 1 : 0) != 0);
        if (vectorTaskColumnInfo != null && !isNative) {
            vectorTaskColumnInfo.setAllNative(false);
        }
        LOG.debug("vectorizeOperator " + vectorOp.getClass().getName());
        LOG.debug("vectorizeOperator " + vectorOp.getConf().getClass().getName());
        if (vectorOp != op) {
            this.fixupParentChildOperators(op, vectorOp);
            ((AbstractOperatorDesc)vectorOp.getConf()).setVectorMode(true);
        }
        return vectorOp;
    }

    private boolean isVirtualColumn(ColumnInfo column) {
        return VirtualColumn.VIRTUAL_COLUMN_NAMES.contains((Object)column.getInternalName());
    }

    public void debugDisplayAllMaps(BaseWork work) {
        VectorizedRowBatchCtx vectorizedRowBatchCtx = work.getVectorizedRowBatchCtx();
        Object[] allColumnNames = vectorizedRowBatchCtx.getRowColumnNames();
        TypeInfo[] columnTypeInfos = vectorizedRowBatchCtx.getRowColumnTypeInfos();
        int partitionColumnCount = vectorizedRowBatchCtx.getPartitionColumnCount();
        Object[] scratchColumnTypeNames = vectorizedRowBatchCtx.getScratchColumnTypeNames();
        LOG.debug("debugDisplayAllMaps allColumnNames " + Arrays.toString(allColumnNames));
        LOG.debug("debugDisplayAllMaps columnTypeInfos " + Arrays.deepToString(columnTypeInfos));
        LOG.debug("debugDisplayAllMaps partitionColumnCount " + partitionColumnCount);
        LOG.debug("debugDisplayAllMaps scratchColumnTypeNames " + Arrays.toString(scratchColumnTypeNames));
    }

    static {
        StringBuilder patternBuilder = new StringBuilder();
        patternBuilder.append("int");
        patternBuilder.append("|smallint");
        patternBuilder.append("|tinyint");
        patternBuilder.append("|bigint");
        patternBuilder.append("|integer");
        patternBuilder.append("|long");
        patternBuilder.append("|short");
        patternBuilder.append("|timestamp");
        patternBuilder.append("|interval_year_month");
        patternBuilder.append("|interval_day_time");
        patternBuilder.append("|boolean");
        patternBuilder.append("|binary");
        patternBuilder.append("|string");
        patternBuilder.append("|byte");
        patternBuilder.append("|float");
        patternBuilder.append("|double");
        patternBuilder.append("|date");
        patternBuilder.append("|void");
        patternBuilder.append("|decimal.*");
        patternBuilder.append("|char.*");
        patternBuilder.append("|varchar.*");
        supportedDataTypesPattern = Pattern.compile(patternBuilder.toString());
    }

    private static class ValidatorVectorizationContext
    extends VectorizationContext {
        private ValidatorVectorizationContext(HiveConf hiveConf) {
            super("No Name", hiveConf);
        }

        @Override
        protected int getInputColumnIndex(String name) {
            return 0;
        }

        @Override
        protected int getInputColumnIndex(ExprNodeColumnDesc colExpr) {
            return 0;
        }
    }

    class ReduceWorkVectorizationNodeProcessor
    extends VectorizationNodeProcessor {
        private final VectorTaskColumnInfo vectorTaskColumnInfo;
        private Operator<? extends OperatorDesc> rootVectorOp;

        public Operator<? extends OperatorDesc> getRootVectorOp() {
            return this.rootVectorOp;
        }

        public ReduceWorkVectorizationNodeProcessor(VectorTaskColumnInfo vectorTaskColumnInfo) {
            super(vectorTaskColumnInfo, vectorTaskColumnInfo.getNonVectorizedOps());
            this.vectorTaskColumnInfo = vectorTaskColumnInfo;
            this.rootVectorOp = null;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            if (this.nonVectorizedOps.contains(op)) {
                return null;
            }
            VectorizationContext vContext = null;
            boolean saveRootVectorOp = false;
            Vectorizer.this.currentOperator = op;
            if (op.getParentOperators().size() == 0) {
                if (LOG.isInfoEnabled()) {
                    LOG.info("ReduceWorkVectorizationNodeProcessor process vectorizedVertexNum " + Vectorizer.this.vectorizedVertexNum + " reduceColumnNames " + this.vectorTaskColumnInfo.allColumnNames.toString());
                    LOG.info("ReduceWorkVectorizationNodeProcessor process vectorizedVertexNum " + Vectorizer.this.vectorizedVertexNum + " reduceTypeInfos " + this.vectorTaskColumnInfo.allTypeInfos.toString());
                }
                this.taskVectorizationContext = vContext = new VectorizationContext("__Reduce_Shuffle__", this.vectorTaskColumnInfo.allColumnNames, Vectorizer.this.hiveConf);
                saveRootVectorOp = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Vectorized ReduceWork reduce shuffle vectorization context " + vContext.toString());
                }
            } else {
                LOG.info("ReduceWorkVectorizationNodeProcessor process going to walk the operator stack to get vectorization context for " + op.getName());
                vContext = this.walkStackToFindVectorizationContext(stack, op);
                if (vContext == null) {
                    vContext = this.taskVectorizationContext;
                }
            }
            assert (vContext != null);
            LOG.info("ReduceWorkVectorizationNodeProcessor process operator " + op.getName() + " using vectorization context" + vContext.toString());
            Operator<? extends OperatorDesc> vectorOp = this.doVectorize(op, vContext, true);
            if (LOG.isDebugEnabled() && vectorOp instanceof VectorizationContextRegion) {
                VectorizationContextRegion vcRegion = (VectorizationContextRegion)((Object)vectorOp);
                VectorizationContext vNewContext = vcRegion.getOuputVectorizationContext();
                LOG.debug("Vectorized ReduceWork operator " + vectorOp.getName() + " added vectorization context " + vNewContext.toString());
            }
            if (saveRootVectorOp && op != vectorOp) {
                this.rootVectorOp = vectorOp;
            }
            return null;
        }
    }

    class MapWorkVectorizationNodeProcessor
    extends VectorizationNodeProcessor {
        private final VectorTaskColumnInfo vectorTaskColumnInfo;
        private final boolean isTezOrSpark;

        public MapWorkVectorizationNodeProcessor(MapWork mWork, boolean isTezOrSpark, VectorTaskColumnInfo vectorTaskColumnInfo) {
            super(vectorTaskColumnInfo, vectorTaskColumnInfo.getNonVectorizedOps());
            this.vectorTaskColumnInfo = vectorTaskColumnInfo;
            this.isTezOrSpark = isTezOrSpark;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            if (this.nonVectorizedOps.contains(op)) {
                return null;
            }
            VectorizationContext vContext = null;
            Vectorizer.this.currentOperator = op;
            if (op instanceof TableScanOperator) {
                if (this.taskVectorizationContext == null) {
                    this.taskVectorizationContext = Vectorizer.this.getVectorizationContext(op.getName(), this.vectorTaskColumnInfo);
                    if (LOG.isInfoEnabled()) {
                        LOG.info("MapWorkVectorizationNodeProcessor process vectorizedVertexNum " + Vectorizer.this.vectorizedVertexNum + " mapColumnNames " + this.vectorTaskColumnInfo.allColumnNames.toString());
                        LOG.info("MapWorkVectorizationNodeProcessor process vectorizedVertexNum " + Vectorizer.this.vectorizedVertexNum + " mapTypeInfos " + this.vectorTaskColumnInfo.allTypeInfos.toString());
                    }
                }
                vContext = this.taskVectorizationContext;
            } else {
                LOG.debug("MapWorkVectorizationNodeProcessor process going to walk the operator stack to get vectorization context for " + op.getName());
                vContext = this.walkStackToFindVectorizationContext(stack, op);
                if (vContext == null) {
                    vContext = this.taskVectorizationContext;
                }
            }
            assert (vContext != null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("MapWorkVectorizationNodeProcessor process operator " + op.getName() + " using vectorization context" + vContext.toString());
            }
            Operator<? extends OperatorDesc> vectorOp = this.doVectorize(op, vContext, this.isTezOrSpark);
            if (LOG.isDebugEnabled() && vectorOp instanceof VectorizationContextRegion) {
                VectorizationContextRegion vcRegion = (VectorizationContextRegion)((Object)vectorOp);
                VectorizationContext vNewContext = vcRegion.getOuputVectorizationContext();
                LOG.debug("Vectorized MapWork operator " + vectorOp.getName() + " added vectorization context " + vNewContext.toString());
            }
            return null;
        }
    }

    class VectorizationNodeProcessor
    implements NodeProcessor {
        protected VectorizationContext taskVectorizationContext;
        protected final VectorTaskColumnInfo vectorTaskColumnInfo;
        protected final Set<Operator<? extends OperatorDesc>> nonVectorizedOps;
        protected final Set<Operator<? extends OperatorDesc>> opsDone = new HashSet<Operator<? extends OperatorDesc>>();
        protected final Map<Operator<? extends OperatorDesc>, Operator<? extends OperatorDesc>> opToVectorOpMap = new HashMap<Operator<? extends OperatorDesc>, Operator<? extends OperatorDesc>>();

        VectorizationNodeProcessor(VectorTaskColumnInfo vectorTaskColumnInfo, Set<Operator<? extends OperatorDesc>> nonVectorizedOps) {
            this.vectorTaskColumnInfo = vectorTaskColumnInfo;
            this.nonVectorizedOps = nonVectorizedOps;
        }

        public String[] getVectorScratchColumnTypeNames() {
            return this.taskVectorizationContext.getScratchColumnTypeNames();
        }

        public VectorizationContext walkStackToFindVectorizationContext(Stack<Node> stack, Operator<? extends OperatorDesc> op) throws SemanticException {
            VectorizationContext vContext = null;
            if (stack.size() <= 1) {
                throw new SemanticException(String.format("Expected operator stack for operator %s to have at least 2 operators", op.getName()));
            }
            int i = stack.size() - 2;
            while (vContext == null) {
                if (i < 0) {
                    return null;
                }
                Operator opParent = (Operator)stack.get(i);
                Operator<? extends OperatorDesc> vectorOpParent = this.opToVectorOpMap.get(opParent);
                if (vectorOpParent != null) {
                    if (vectorOpParent instanceof VectorizationContextRegion) {
                        VectorizationContextRegion vcRegion = (VectorizationContextRegion)((Object)vectorOpParent);
                        vContext = vcRegion.getOuputVectorizationContext();
                        LOG.info("walkStackToFindVectorizationContext " + vectorOpParent.getName() + " has new vectorization context " + vContext.toString());
                    } else {
                        LOG.info("walkStackToFindVectorizationContext " + vectorOpParent.getName() + " does not have new vectorization context");
                    }
                } else {
                    LOG.info("walkStackToFindVectorizationContext " + opParent.getName() + " is not vectorized");
                }
                --i;
            }
            return vContext;
        }

        public Operator<? extends OperatorDesc> doVectorize(Operator<? extends OperatorDesc> op, VectorizationContext vContext, boolean isTezOrSpark) throws SemanticException {
            Operator<? extends OperatorDesc> vectorOp = op;
            try {
                if (!this.opsDone.contains(op)) {
                    vectorOp = Vectorizer.this.vectorizeOperator(op, vContext, isTezOrSpark, this.vectorTaskColumnInfo);
                    this.opsDone.add(op);
                    if (vectorOp != op) {
                        this.opToVectorOpMap.put(op, vectorOp);
                        this.opsDone.add(vectorOp);
                    }
                }
            }
            catch (HiveException e) {
                throw new SemanticException(e);
            }
            return vectorOp;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            throw new SemanticException("Must be overridden");
        }
    }

    class ReduceWorkValidationNodeProcessor
    implements NodeProcessor {
        protected final Set<Operator<? extends OperatorDesc>> nonVectorizedOps = new HashSet<Operator<? extends OperatorDesc>>();

        ReduceWorkValidationNodeProcessor() {
        }

        public Set<Operator<? extends OperatorDesc>> getNonVectorizeOps() {
            return this.nonVectorizedOps;
        }

        public Set<Operator<? extends OperatorDesc>> getNonVectorizedOps() {
            return this.nonVectorizedOps;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            for (Node n : stack) {
                Operator op = (Operator)n;
                if (this.nonVectorizedOps.contains(op)) {
                    return new Boolean(true);
                }
                Vectorizer.this.currentOperator = op;
                boolean ret = Vectorizer.this.validateReduceWorkOperator(op);
                if (!ret) {
                    return new Boolean(false);
                }
                if (!Vectorizer.this.isVectorizedGroupByThatOutputsRows(op).booleanValue()) continue;
                Vectorizer.this.addOperatorChildrenToSet(op, this.nonVectorizedOps);
                return new Boolean(true);
            }
            return new Boolean(true);
        }
    }

    class MapWorkValidationNodeProcessor
    implements NodeProcessor {
        private final MapWork mapWork;
        private final boolean isTezOrSpark;
        protected final Set<Operator<? extends OperatorDesc>> nonVectorizedOps = new HashSet<Operator<? extends OperatorDesc>>();

        public Set<Operator<? extends OperatorDesc>> getNonVectorizedOps() {
            return this.nonVectorizedOps;
        }

        public MapWorkValidationNodeProcessor(MapWork mapWork, boolean isTezOrSpark) {
            this.mapWork = mapWork;
            this.isTezOrSpark = isTezOrSpark;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            for (Node n : stack) {
                boolean ret;
                Operator op = (Operator)n;
                if (this.nonVectorizedOps.contains(op)) {
                    return new Boolean(true);
                }
                Vectorizer.this.currentOperator = op;
                try {
                    ret = Vectorizer.this.validateMapWorkOperator(op, this.mapWork, this.isTezOrSpark);
                }
                catch (Exception e) {
                    throw new SemanticException(e);
                }
                if (!ret) {
                    return new Boolean(false);
                }
                if (!Vectorizer.this.isVectorizedGroupByThatOutputsRows(op).booleanValue()) continue;
                Vectorizer.this.addOperatorChildrenToSet(op, this.nonVectorizedOps);
                return new Boolean(true);
            }
            return new Boolean(true);
        }
    }

    class VectorizationDispatcher
    implements Dispatcher {
        VectorizationDispatcher() {
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            block8: {
                Task currTask;
                block7: {
                    currTask = (Task)nd;
                    if (!(currTask instanceof MapRedTask)) break block7;
                    MapredWork mapredWork = (MapredWork)((MapRedTask)currTask).getWork();
                    this.convertMapWork(mapredWork.getMapWork(), false);
                    ReduceWork reduceWork = mapredWork.getReduceWork();
                    if (reduceWork == null) break block8;
                    this.setReduceWorkExplainConditions(reduceWork);
                    break block8;
                }
                if (currTask instanceof TezTask) {
                    TezWork work = (TezWork)((TezTask)currTask).getWork();
                    for (BaseWork baseWork : work.getAllWork()) {
                        if (baseWork instanceof MapWork) {
                            this.convertMapWork((MapWork)baseWork, true);
                            continue;
                        }
                        if (!(baseWork instanceof ReduceWork)) continue;
                        ReduceWork reduceWork = (ReduceWork)baseWork;
                        this.setReduceWorkExplainConditions(reduceWork);
                        if (!Vectorizer.this.isReduceVectorizationEnabled) continue;
                        this.convertReduceWork(reduceWork);
                    }
                } else if (currTask instanceof SparkTask) {
                    SparkWork sparkWork = (SparkWork)currTask.getWork();
                    for (BaseWork baseWork : sparkWork.getAllWork()) {
                        if (baseWork instanceof MapWork) {
                            this.convertMapWork((MapWork)baseWork, true);
                            continue;
                        }
                        if (!(baseWork instanceof ReduceWork)) continue;
                        ReduceWork reduceWork = (ReduceWork)baseWork;
                        this.setReduceWorkExplainConditions(reduceWork);
                        if (!Vectorizer.this.isReduceVectorizationEnabled) continue;
                        this.convertReduceWork(reduceWork);
                    }
                }
            }
            return null;
        }

        private void convertMapWork(MapWork mapWork, boolean isTezOrSpark) throws SemanticException {
            boolean ret;
            mapWork.setVectorizationExamined(true);
            Vectorizer.this.currentBaseWork = mapWork;
            VectorTaskColumnInfo vectorTaskColumnInfo = new VectorTaskColumnInfo();
            vectorTaskColumnInfo.assume();
            mapWork.setVectorizedVertexNum(++Vectorizer.this.vectorizedVertexNum);
            try {
                ret = this.validateMapWork(mapWork, vectorTaskColumnInfo, isTezOrSpark);
            }
            catch (Exception e) {
                String issue = "exception: " + VectorizationContext.getStackTraceAsSingleLine(e);
                Vectorizer.this.setNodeIssue(issue);
                ret = false;
            }
            if (ret) {
                this.vectorizeMapWork(mapWork, vectorTaskColumnInfo, isTezOrSpark);
            } else if (Vectorizer.this.currentBaseWork.getVectorizationEnabled()) {
                VectorizerReason notVectorizedReason = Vectorizer.this.currentBaseWork.getNotVectorizedReason();
                if (notVectorizedReason == null) {
                    LOG.info("Cannot vectorize: unknown");
                } else {
                    LOG.info("Cannot vectorize: " + notVectorizedReason.toString());
                }
                this.clearMapWorkVectorDescs(mapWork);
            }
        }

        private void addMapWorkRules(Map<Rule, NodeProcessor> opRules, NodeProcessor np) {
            opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + ".*" + FileSinkOperator.getOperatorName()), np);
            opRules.put(new RuleRegExp("R2", TableScanOperator.getOperatorName() + ".*" + ReduceSinkOperator.getOperatorName()), np);
        }

        private ImmutablePair<String, TableScanOperator> verifyOnlyOneTableScanOperator(MapWork mapWork) {
            LinkedHashMap<String, Operator<? extends OperatorDesc>> aliasToWork = mapWork.getAliasToWork();
            if (aliasToWork == null || aliasToWork.size() == 0) {
                Vectorizer.this.setNodeIssue("Vectorized map work requires work");
                return null;
            }
            int tableScanCount = 0;
            String alias = "";
            TableScanOperator tableScanOperator = null;
            for (Map.Entry<String, Operator<? extends OperatorDesc>> entry : aliasToWork.entrySet()) {
                Operator<? extends OperatorDesc> op = entry.getValue();
                if (op == null) {
                    Vectorizer.this.setNodeIssue("Vectorized map work requires a valid alias");
                    return null;
                }
                if (!(op instanceof TableScanOperator)) continue;
                ++tableScanCount;
                alias = entry.getKey();
                tableScanOperator = (TableScanOperator)op;
            }
            if (tableScanCount > 1) {
                Vectorizer.this.setNodeIssue("Vectorized map work only works with 1 TableScanOperator");
                return null;
            }
            return new ImmutablePair((Object)alias, tableScanOperator);
        }

        private void getTableScanOperatorSchemaInfo(TableScanOperator tableScanOperator, List<String> logicalColumnNameList, List<TypeInfo> logicalTypeInfoList) {
            RowSchema rowSchema = tableScanOperator.getSchema();
            for (ColumnInfo c : rowSchema.getSignature()) {
                if (Vectorizer.this.isVirtualColumn(c)) continue;
                String columnName = c.getInternalName();
                String typeName = c.getTypeName();
                TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString((String)typeName);
                logicalColumnNameList.add(columnName);
                logicalTypeInfoList.add(typeInfo);
            }
        }

        private void determineDataColumnNums(TableScanOperator tableScanOperator, List<String> allColumnNameList, int dataColumnCount, List<Integer> dataColumnNums) {
            HashSet<String> neededColumns = new HashSet<String>(tableScanOperator.getNeededColumns());
            for (int dataColumnNum = 0; dataColumnNum < dataColumnCount; ++dataColumnNum) {
                String columnName = allColumnNameList.get(dataColumnNum);
                if (!neededColumns.contains(columnName)) continue;
                dataColumnNums.add(dataColumnNum);
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean verifyAndSetVectorPartDesc(PartitionDesc pd, boolean isAcidTable, HashSet<String> inputFileFormatClassNameSet, HashSet<String> enabledConditionsMetSet, ArrayList<String> enabledConditionsNotMetList) {
            boolean isVectorDeserializeEligable;
            String inputFileFormatClassName = pd.getInputFileFormatClassName();
            inputFileFormatClassNameSet.add(inputFileFormatClassName);
            boolean isInputFileFormatVectorized = Utilities.isInputFileFormatVectorized(pd);
            if (isAcidTable) {
                Preconditions.checkState((boolean)isInputFileFormatVectorized);
                Preconditions.checkState((boolean)inputFileFormatClassName.equals(OrcInputFormat.class.getName()));
                if (!Vectorizer.this.useVectorizedInputFileFormat) {
                    enabledConditionsNotMetList.add("Vectorizing ACID tables requires " + HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT.varname);
                    return false;
                }
                pd.setVectorPartitionDesc(VectorPartitionDesc.createVectorizedInputFileFormat(inputFileFormatClassName, Utilities.isInputFileFormatSelfDescribing(pd)));
                enabledConditionsMetSet.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT.varname);
                return true;
            }
            if (Vectorizer.this.useVectorizedInputFileFormat && isInputFileFormatVectorized) {
                pd.setVectorPartitionDesc(VectorPartitionDesc.createVectorizedInputFileFormat(inputFileFormatClassName, Utilities.isInputFileFormatSelfDescribing(pd)));
                enabledConditionsMetSet.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT.varname);
                return true;
            }
            if (!Vectorizer.this.isSchemaEvolution) {
                enabledConditionsNotMetList.add("Vectorizing tables without Schema Evolution requires " + HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT.varname);
                return false;
            }
            String deserializerClassName = pd.getDeserializerClassName();
            boolean isTextFormat = inputFileFormatClassName.equals(TextInputFormat.class.getName()) && deserializerClassName.equals(LazySimpleSerDe.class.getName());
            boolean isSequenceFormat = inputFileFormatClassName.equals(SequenceFileInputFormat.class.getName()) && deserializerClassName.equals(LazyBinarySerDe.class.getName());
            boolean bl = isVectorDeserializeEligable = isTextFormat || isSequenceFormat;
            if (Vectorizer.this.useVectorDeserialize) {
                if (isTextFormat) {
                    boolean lastColumnTakesRest;
                    Properties properties = pd.getTableDesc().getProperties();
                    String lastColumnTakesRestString = properties.getProperty("serialization.last.column.takes.rest");
                    boolean bl2 = lastColumnTakesRest = lastColumnTakesRestString != null && lastColumnTakesRestString.equalsIgnoreCase("true");
                    if (!lastColumnTakesRest) {
                        pd.setVectorPartitionDesc(VectorPartitionDesc.createVectorDeserialize(inputFileFormatClassName, VectorPartitionDesc.VectorDeserializeType.LAZY_SIMPLE));
                        enabledConditionsMetSet.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTOR_DESERIALIZE.varname);
                        return true;
                    }
                    if (Vectorizer.this.useRowDeserialize) {
                        enabledConditionsNotMetList.add(inputFileFormatClassName + " " + "serialization.last.column.takes.rest" + " must be disabled ");
                        return false;
                    }
                } else if (isSequenceFormat) {
                    pd.setVectorPartitionDesc(VectorPartitionDesc.createVectorDeserialize(inputFileFormatClassName, VectorPartitionDesc.VectorDeserializeType.LAZY_BINARY));
                    enabledConditionsMetSet.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTOR_DESERIALIZE.varname);
                    return true;
                }
            }
            if (Vectorizer.this.useRowDeserialize) {
                pd.setVectorPartitionDesc(VectorPartitionDesc.createRowDeserialize(inputFileFormatClassName, Utilities.isInputFileFormatSelfDescribing(pd), deserializerClassName));
                enabledConditionsMetSet.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_ROW_DESERIALIZE.varname);
                return true;
            }
            if (isInputFileFormatVectorized) {
                Preconditions.checkState((!Vectorizer.this.useVectorizedInputFileFormat ? 1 : 0) != 0);
                enabledConditionsNotMetList.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTORIZED_INPUT_FILE_FORMAT.varname);
                return false;
            }
            if (!isVectorDeserializeEligable) {
                enabledConditionsNotMetList.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_ROW_DESERIALIZE.varname);
                return false;
            }
            Preconditions.checkState((!Vectorizer.this.useVectorDeserialize ? 1 : 0) != 0);
            enabledConditionsNotMetList.add(HiveConf.ConfVars.HIVE_VECTORIZATION_USE_VECTOR_DESERIALIZE.varname);
            return false;
        }

        private ImmutablePair<Boolean, Boolean> validateInputFormatAndSchemaEvolution(MapWork mapWork, String alias, TableScanOperator tableScanOperator, VectorTaskColumnInfo vectorTaskColumnInfo) throws SemanticException {
            boolean isAcidTable = ((TableScanDesc)tableScanOperator.getConf()).isAcidTable();
            ArrayList<String> allColumnNameList = new ArrayList<String>();
            ArrayList<TypeInfo> allTypeInfoList = new ArrayList<TypeInfo>();
            this.getTableScanOperatorSchemaInfo(tableScanOperator, allColumnNameList, allTypeInfoList);
            ArrayList<Integer> dataColumnNums = new ArrayList<Integer>();
            int allColumnCount = allColumnNameList.size();
            boolean isFirst = true;
            int dataColumnCount = 0;
            int partitionColumnCount = 0;
            List tableDataColumnList = null;
            ArrayList tableDataTypeInfoList = null;
            LinkedHashMap<Path, ArrayList<String>> pathToAliases = mapWork.getPathToAliases();
            LinkedHashMap<Path, PartitionDesc> pathToPartitionInfo = mapWork.getPathToPartitionInfo();
            HashSet<String> inputFileFormatClassNameSet = new HashSet<String>();
            HashSet<String> enabledConditionsMetSet = new HashSet<String>();
            ArrayList<String> enabledConditionsNotMetList = new ArrayList<String>();
            for (Map.Entry<Path, ArrayList<String>> entry : pathToAliases.entrySet()) {
                ArrayList nextDataTypeInfoList;
                StructObjectInspector partObjectInspector;
                Deserializer deserializer;
                boolean isPresent;
                Path path = entry.getKey();
                List aliases = entry.getValue();
                boolean bl = isPresent = aliases != null && aliases.indexOf(alias) != -1;
                if (!isPresent) {
                    Vectorizer.this.setOperatorIssue("Alias " + alias + " not present in aliases " + aliases);
                    return new ImmutablePair((Object)false, (Object)false);
                }
                PartitionDesc partDesc = pathToPartitionInfo.get(path);
                if (partDesc.getVectorPartitionDesc() != null) continue;
                if (!this.verifyAndSetVectorPartDesc(partDesc, isAcidTable, inputFileFormatClassNameSet, enabledConditionsMetSet, enabledConditionsNotMetList)) {
                    mapWork.setVectorizationInputFileFormatClassNameSet(inputFileFormatClassNameSet);
                    mapWork.setVectorizationEnabledConditionsMet(new ArrayList<String>(enabledConditionsMetSet));
                    mapWork.setVectorizationEnabledConditionsNotMet(enabledConditionsNotMetList);
                    LOG.info("Cannot enable vectorization because input file format(s) " + inputFileFormatClassNameSet + " do not met conditions " + VectorizationCondition.addBooleans(enabledConditionsNotMetList, false));
                    return new ImmutablePair((Object)false, (Object)true);
                }
                VectorPartitionDesc vectorPartDesc = partDesc.getVectorPartitionDesc();
                if (isFirst) {
                    LinkedHashMap<String, String> partSpec = partDesc.getPartSpec();
                    if (partSpec != null && partSpec.size() > 0) {
                        partitionColumnCount = partSpec.size();
                        dataColumnCount = allColumnCount - partitionColumnCount;
                    } else {
                        partitionColumnCount = 0;
                        dataColumnCount = allColumnCount;
                    }
                    this.determineDataColumnNums(tableScanOperator, allColumnNameList, dataColumnCount, dataColumnNums);
                    tableDataColumnList = allColumnNameList.subList(0, dataColumnCount);
                    tableDataTypeInfoList = allTypeInfoList.subList(0, dataColumnCount);
                    isFirst = false;
                }
                try {
                    deserializer = partDesc.getDeserializer((Configuration)Vectorizer.this.hiveConf);
                    partObjectInspector = (StructObjectInspector)deserializer.getObjectInspector();
                }
                catch (Exception e) {
                    throw new SemanticException(e);
                }
                String nextDataColumnsString = ObjectInspectorUtils.getFieldNames((StructObjectInspector)partObjectInspector);
                String[] nextDataColumns = nextDataColumnsString.split(",");
                List<String> nextDataColumnList = Arrays.asList(nextDataColumns);
                if (nextDataColumnList.size() > tableDataColumnList.size()) {
                    Vectorizer.this.setOperatorIssue(String.format("Could not vectorize partition %s (deserializer " + deserializer.getClass().getName() + ")The partition column names %d is greater than the number of table columns %d", path, nextDataColumnList.size(), tableDataColumnList.size()));
                    return new ImmutablePair((Object)false, (Object)false);
                }
                if (!(deserializer instanceof NullStructSerDe)) {
                    for (int i = 0; i < nextDataColumnList.size(); ++i) {
                        String tableColumnName;
                        String nextColumnName = nextDataColumnList.get(i);
                        if (nextColumnName.equals(tableColumnName = (String)tableDataColumnList.get(i))) continue;
                        Vectorizer.this.setOperatorIssue(String.format("Could not vectorize partition %s (deserializer " + deserializer.getClass().getName() + ")The partition column name %s is does not match table column name %s", path, nextColumnName, tableColumnName));
                        return new ImmutablePair((Object)false, (Object)false);
                    }
                }
                if (vectorPartDesc.getIsInputFileFormatSelfDescribing()) {
                    nextDataTypeInfoList = tableDataTypeInfoList;
                } else {
                    String nextDataTypesString = ObjectInspectorUtils.getFieldTypes((StructObjectInspector)partObjectInspector);
                    nextDataTypeInfoList = TypeInfoUtils.getTypeInfosFromTypeString((String)nextDataTypesString);
                }
                vectorPartDesc.setDataTypeInfos(nextDataTypeInfoList);
            }
            vectorTaskColumnInfo.setAllColumnNames(allColumnNameList);
            vectorTaskColumnInfo.setAllTypeInfos(allTypeInfoList);
            vectorTaskColumnInfo.setDataColumnNums(dataColumnNums);
            vectorTaskColumnInfo.setPartitionColumnCount(partitionColumnCount);
            vectorTaskColumnInfo.setUseVectorizedInputFileFormat(Vectorizer.this.useVectorizedInputFileFormat);
            mapWork.setVectorizationInputFileFormatClassNameSet(inputFileFormatClassNameSet);
            mapWork.setVectorizationEnabledConditionsMet(new ArrayList<String>(enabledConditionsMetSet));
            mapWork.setVectorizationEnabledConditionsNotMet(enabledConditionsNotMetList);
            return new ImmutablePair((Object)true, (Object)false);
        }

        private boolean validateMapWork(MapWork mapWork, VectorTaskColumnInfo vectorTaskColumnInfo, boolean isTezOrSpark) throws SemanticException {
            LOG.info("Validating MapWork...");
            ImmutablePair<String, TableScanOperator> onlyOneTableScanPair = this.verifyOnlyOneTableScanOperator(mapWork);
            if (onlyOneTableScanPair == null) {
                VectorizerReason notVectorizedReason = Vectorizer.this.currentBaseWork.getNotVectorizedReason();
                Preconditions.checkState((notVectorizedReason != null ? 1 : 0) != 0);
                mapWork.setVectorizationEnabledConditionsNotMet(Arrays.asList(notVectorizedReason.toString()));
                return false;
            }
            String alias = (String)onlyOneTableScanPair.left;
            TableScanOperator tableScanOperator = (TableScanOperator)onlyOneTableScanPair.right;
            Vectorizer.this.currentOperator = tableScanOperator;
            ImmutablePair<Boolean, Boolean> validateInputFormatAndSchemaEvolutionPair = this.validateInputFormatAndSchemaEvolution(mapWork, alias, tableScanOperator, vectorTaskColumnInfo);
            if (!((Boolean)validateInputFormatAndSchemaEvolutionPair.left).booleanValue()) {
                if (!((Boolean)validateInputFormatAndSchemaEvolutionPair.right).booleanValue()) {
                    VectorizerReason notVectorizedReason = Vectorizer.this.currentBaseWork.getNotVectorizedReason();
                    Preconditions.checkState((notVectorizedReason != null ? 1 : 0) != 0);
                    mapWork.setVectorizationEnabledConditionsNotMet(Arrays.asList(notVectorizedReason.toString()));
                }
                return false;
            }
            mapWork.setVectorizationEnabled(true);
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            MapWorkValidationNodeProcessor vnp = new MapWorkValidationNodeProcessor(mapWork, isTezOrSpark);
            this.addMapWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(mapWork.getAliasToWork().values());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            for (Node n : nodeOutput.keySet()) {
                if (nodeOutput.get(n) == null || ((Boolean)nodeOutput.get(n)).booleanValue()) continue;
                return false;
            }
            vectorTaskColumnInfo.setNonVectorizedOps(vnp.getNonVectorizedOps());
            return true;
        }

        private void vectorizeMapWork(MapWork mapWork, VectorTaskColumnInfo vectorTaskColumnInfo, boolean isTezOrSpark) throws SemanticException {
            LOG.info("Vectorizing MapWork...");
            mapWork.setVectorMode(true);
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            MapWorkVectorizationNodeProcessor vnp = new MapWorkVectorizationNodeProcessor(mapWork, isTezOrSpark, vectorTaskColumnInfo);
            this.addMapWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            PreOrderOnceWalker ogw = new PreOrderOnceWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(mapWork.getAliasToWork().values());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            vectorTaskColumnInfo.setScratchTypeNameArray(vnp.getVectorScratchColumnTypeNames());
            vectorTaskColumnInfo.transferToBaseWork(mapWork);
            if (LOG.isDebugEnabled()) {
                Vectorizer.this.debugDisplayAllMaps(mapWork);
            }
        }

        private void setReduceWorkExplainConditions(ReduceWork reduceWork) {
            reduceWork.setVectorizationExamined(true);
            reduceWork.setReduceVectorizationEnabled(Vectorizer.this.isReduceVectorizationEnabled);
            reduceWork.setVectorReduceEngine(HiveConf.getVar((Configuration)Vectorizer.this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_EXECUTION_ENGINE));
        }

        private void convertReduceWork(ReduceWork reduceWork) throws SemanticException {
            boolean ret;
            Vectorizer.this.currentBaseWork = reduceWork;
            Vectorizer.this.currentBaseWork.setVectorizationEnabled(true);
            VectorTaskColumnInfo vectorTaskColumnInfo = new VectorTaskColumnInfo();
            vectorTaskColumnInfo.assume();
            reduceWork.setVectorizedVertexNum(++Vectorizer.this.vectorizedVertexNum);
            try {
                ret = this.validateReduceWork(reduceWork, vectorTaskColumnInfo);
            }
            catch (Exception e) {
                String issue = "exception: " + VectorizationContext.getStackTraceAsSingleLine(e);
                Vectorizer.this.setNodeIssue(issue);
                ret = false;
            }
            if (ret) {
                this.vectorizeReduceWork(reduceWork, vectorTaskColumnInfo);
            } else if (Vectorizer.this.currentBaseWork.getVectorizationEnabled()) {
                VectorizerReason notVectorizedReason = Vectorizer.this.currentBaseWork.getNotVectorizedReason();
                if (notVectorizedReason == null) {
                    LOG.info("Cannot vectorize: unknown");
                } else {
                    LOG.info("Cannot vectorize: " + notVectorizedReason.toString());
                }
                this.clearReduceWorkVectorDescs(reduceWork);
            }
        }

        private boolean getOnlyStructObjectInspectors(ReduceWork reduceWork, VectorTaskColumnInfo vectorTaskColumnInfo) throws SemanticException {
            ArrayList<String> reduceColumnNames = new ArrayList<String>();
            ArrayList<TypeInfo> reduceTypeInfos = new ArrayList<TypeInfo>();
            if (reduceWork.getNeedsTagging()) {
                Vectorizer.this.setNodeIssue("Tagging not supported");
                return false;
            }
            try {
                TableDesc keyTableDesc = reduceWork.getKeyDesc();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using reduce tag " + reduceWork.getTag());
                }
                TableDesc valueTableDesc = reduceWork.getTagToValueDesc().get(reduceWork.getTag());
                Deserializer keyDeserializer = (Deserializer)ReflectionUtils.newInstance(keyTableDesc.getDeserializerClass(), null);
                SerDeUtils.initializeSerDe((Deserializer)keyDeserializer, null, (Properties)keyTableDesc.getProperties(), null);
                ObjectInspector keyObjectInspector = keyDeserializer.getObjectInspector();
                if (keyObjectInspector == null) {
                    Vectorizer.this.setNodeIssue("Key object inspector null");
                    return false;
                }
                if (!(keyObjectInspector instanceof StructObjectInspector)) {
                    Vectorizer.this.setNodeIssue("Key object inspector not StructObjectInspector");
                    return false;
                }
                StructObjectInspector keyStructObjectInspector = (StructObjectInspector)keyObjectInspector;
                List keyFields = keyStructObjectInspector.getAllStructFieldRefs();
                for (StructField field : keyFields) {
                    reduceColumnNames.add(Utilities.ReduceField.KEY.toString() + "." + field.getFieldName());
                    reduceTypeInfos.add(TypeInfoUtils.getTypeInfoFromTypeString((String)field.getFieldObjectInspector().getTypeName()));
                }
                Deserializer valueDeserializer = (Deserializer)ReflectionUtils.newInstance(valueTableDesc.getDeserializerClass(), null);
                SerDeUtils.initializeSerDe((Deserializer)valueDeserializer, null, (Properties)valueTableDesc.getProperties(), null);
                ObjectInspector valueObjectInspector = valueDeserializer.getObjectInspector();
                if (valueObjectInspector != null) {
                    if (!(valueObjectInspector instanceof StructObjectInspector)) {
                        Vectorizer.this.setNodeIssue("Value object inspector not StructObjectInspector");
                        return false;
                    }
                    StructObjectInspector valueStructObjectInspector = (StructObjectInspector)valueObjectInspector;
                    List valueFields = valueStructObjectInspector.getAllStructFieldRefs();
                    for (StructField field : valueFields) {
                        reduceColumnNames.add(Utilities.ReduceField.VALUE.toString() + "." + field.getFieldName());
                        reduceTypeInfos.add(TypeInfoUtils.getTypeInfoFromTypeString((String)field.getFieldObjectInspector().getTypeName()));
                    }
                }
            }
            catch (Exception e) {
                throw new SemanticException(e);
            }
            vectorTaskColumnInfo.setAllColumnNames(reduceColumnNames);
            vectorTaskColumnInfo.setAllTypeInfos(reduceTypeInfos);
            return true;
        }

        private void addReduceWorkRules(Map<Rule, NodeProcessor> opRules, NodeProcessor np) {
            opRules.put(new RuleRegExp("R1", GroupByOperator.getOperatorName() + ".*"), np);
            opRules.put(new RuleRegExp("R2", SelectOperator.getOperatorName() + ".*"), np);
        }

        private boolean validateReduceWork(ReduceWork reduceWork, VectorTaskColumnInfo vectorTaskColumnInfo) throws SemanticException {
            LOG.info("Validating ReduceWork...");
            if (!this.getOnlyStructObjectInspectors(reduceWork, vectorTaskColumnInfo)) {
                return false;
            }
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            ReduceWorkValidationNodeProcessor vnp = new ReduceWorkValidationNodeProcessor();
            this.addReduceWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.add(reduceWork.getReducer());
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            for (Node n : nodeOutput.keySet()) {
                if (nodeOutput.get(n) == null || ((Boolean)nodeOutput.get(n)).booleanValue()) continue;
                return false;
            }
            vectorTaskColumnInfo.setNonVectorizedOps(vnp.getNonVectorizedOps());
            return true;
        }

        private void vectorizeReduceWork(ReduceWork reduceWork, VectorTaskColumnInfo vectorTaskColumnInfo) throws SemanticException {
            LOG.info("Vectorizing ReduceWork...");
            reduceWork.setVectorMode(true);
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            ReduceWorkVectorizationNodeProcessor vnp = new ReduceWorkVectorizationNodeProcessor(vectorTaskColumnInfo);
            this.addReduceWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            PreOrderWalker ogw = new PreOrderWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.add(reduceWork.getReducer());
            LOG.info("vectorizeReduceWork reducer Operator: " + reduceWork.getReducer().getName() + "...");
            HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
            ogw.startWalking(topNodes, nodeOutput);
            reduceWork.setReducer(vnp.getRootVectorOp());
            vectorTaskColumnInfo.setScratchTypeNameArray(vnp.getVectorScratchColumnTypeNames());
            vectorTaskColumnInfo.transferToBaseWork(reduceWork);
            if (LOG.isDebugEnabled()) {
                Vectorizer.this.debugDisplayAllMaps(reduceWork);
            }
        }

        private void clearMapWorkVectorDescs(MapWork mapWork) throws SemanticException {
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            ClearVectorDescsNodeProcessor vnp = new ClearVectorDescsNodeProcessor();
            this.addMapWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(mapWork.getAliasToWork().values());
            ogw.startWalking(topNodes, null);
        }

        private void clearReduceWorkVectorDescs(ReduceWork reduceWork) throws SemanticException {
            LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
            ClearVectorDescsNodeProcessor vnp = new ClearVectorDescsNodeProcessor();
            this.addReduceWorkRules(opRules, vnp);
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(vnp, opRules, null);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.add(reduceWork.getReducer());
            ogw.startWalking(topNodes, null);
        }

        class ClearVectorDescsNodeProcessor
        implements NodeProcessor {
            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                for (Node n : stack) {
                    Operator op = (Operator)n;
                    Object desc = op.getConf();
                    if (!(desc instanceof AbstractOperatorDesc)) continue;
                    AbstractOperatorDesc abstractDesc = (AbstractOperatorDesc)desc;
                    abstractDesc.setVectorDesc(null);
                }
                return null;
            }
        }
    }

    private class VectorTaskColumnInfo {
        List<String> allColumnNames;
        List<TypeInfo> allTypeInfos;
        List<Integer> dataColumnNums;
        int partitionColumnCount = 0;
        boolean useVectorizedInputFileFormat;
        boolean groupByVectorOutput;
        boolean allNative;
        boolean usesVectorUDFAdaptor;
        String[] scratchTypeNameArray;
        Set<Operator<? extends OperatorDesc>> nonVectorizedOps;

        VectorTaskColumnInfo() {
        }

        public void assume() {
            this.groupByVectorOutput = true;
            this.allNative = true;
            this.usesVectorUDFAdaptor = false;
        }

        public void setAllColumnNames(List<String> allColumnNames) {
            this.allColumnNames = allColumnNames;
        }

        public void setAllTypeInfos(List<TypeInfo> allTypeInfos) {
            this.allTypeInfos = allTypeInfos;
        }

        public void setDataColumnNums(List<Integer> dataColumnNums) {
            this.dataColumnNums = dataColumnNums;
        }

        public void setPartitionColumnCount(int partitionColumnCount) {
            this.partitionColumnCount = partitionColumnCount;
        }

        public void setScratchTypeNameArray(String[] scratchTypeNameArray) {
            this.scratchTypeNameArray = scratchTypeNameArray;
        }

        public void setGroupByVectorOutput(boolean groupByVectorOutput) {
            this.groupByVectorOutput = groupByVectorOutput;
        }

        public void setAllNative(boolean allNative) {
            this.allNative = allNative;
        }

        public void setUsesVectorUDFAdaptor(boolean usesVectorUDFAdaptor) {
            this.usesVectorUDFAdaptor = usesVectorUDFAdaptor;
        }

        public void setUseVectorizedInputFileFormat(boolean useVectorizedInputFileFormat) {
            this.useVectorizedInputFileFormat = useVectorizedInputFileFormat;
        }

        public void setNonVectorizedOps(Set<Operator<? extends OperatorDesc>> nonVectorizedOps) {
            this.nonVectorizedOps = nonVectorizedOps;
        }

        public Set<Operator<? extends OperatorDesc>> getNonVectorizedOps() {
            return this.nonVectorizedOps;
        }

        public void transferToBaseWork(BaseWork baseWork) {
            String[] allColumnNameArray = this.allColumnNames.toArray(new String[0]);
            TypeInfo[] allTypeInfoArray = this.allTypeInfos.toArray(new TypeInfo[0]);
            int[] dataColumnNumsArray = this.dataColumnNums != null ? ArrayUtils.toPrimitive((Integer[])this.dataColumnNums.toArray(new Integer[0])) : null;
            VectorizedRowBatchCtx vectorizedRowBatchCtx = new VectorizedRowBatchCtx(allColumnNameArray, allTypeInfoArray, dataColumnNumsArray, this.partitionColumnCount, this.scratchTypeNameArray);
            baseWork.setVectorizedRowBatchCtx(vectorizedRowBatchCtx);
            if (baseWork instanceof MapWork) {
                MapWork mapWork = (MapWork)baseWork;
                mapWork.setUseVectorizedInputFileFormat(this.useVectorizedInputFileFormat);
            }
            baseWork.setAllNative(this.allNative);
            baseWork.setGroupByVectorOutput(this.groupByVectorOutput);
            baseWork.setUsesVectorUDFAdaptor(this.usesVectorUDFAdaptor);
        }
    }
}

